<?php

namespace  App\Services\Optimisation\Construction2Algo;

use App\Services\Optimisation\OptimisationData;
use Illuminate\Support\Facades\DB;

class Main
{
    use OptimisationData;

    public $i;

    public function construction($optimisation_id)
    {
        $time_start = microtime(true);
        $clausters = DB::select("SELECT * from optimisation_clauster where optimisation_id = $optimisation_id");
        $array = [];
        $vehicules = $this->getOptimisationVehicules($optimisation_id);
        $drivers = $this->getOptimisationDrivers($optimisation_id);
        $optimisationParams = $this->getOptimisationParams($optimisation_id);
        $this->i = 0;
        foreach ($clausters as $clauster) {
            $result = $this->optimiseClauster($optimisation_id, $clauster, $vehicules, $drivers, $optimisationParams);
            $array = array_merge($array, $result);
            $time_end = microtime(true);
            echo "finishing $clauster->clauster_id at" . ($time_end - $time_start);
            echo '<br>';
        }
        $time_end = microtime(true);
        $this->deleteOptimisationMissions($optimisation_id);
        $this->insertToOptimisation($optimisation_id, $array, ($time_end - $time_start));
        dd($array);
    }

    public function optimiseClauster($optimisation_id, $clauster, $vehicules, $drivers, $optimisationParams)
    {
        $time_start = microtime(true);
        $result = [];
        $results = [];
        $optimisations = [];
        $clients = $this->getClientsList($optimisation_id, $clauster->clauster_id);

        $depot_id = -6;
        $array = "[$depot_id," . $clients[0]->clients . ']';
        $time_end = microtime(true);
        echo 'getting local clients data ' . ($time_end - $time_start);
        echo '<br>';
        $matriceDistance = $this->getMastriceDistance($array);
        $time_end = microtime(true);
        echo 'getting osrm clients data ' . ($time_end - $time_start);
        echo '<br>';
        //$matriceDistance = collect($matriceDistance);
        // dd($matriceDistance);
        $time_end = microtime(true);
        echo 'transfering clients data to collection ' . ($time_end - $time_start);
        echo '<br>';


        $simpleMatrice = (array) $matriceDistance;

        // for ($i = 0; $i < count($listClients); $i++) {

        //     $simpleMatrice[$listClients[$i]] = $matriceDistance->where("client_1_id", $listClients[$i])->sortBy('distance')->toArray();
        // }
        // $time_end = microtime(true);
        echo 'ordering collection data base on distance  ' . ($time_end - $time_start);
        echo '<br>';
        //dd($simpleMatrice);
        $listClients = explode(',', "$depot_id," . $clients[0]->clients);
        $listClients = $this->getClientsData($listClients, $optimisation_id);
        unset($listClients[$depot_id]);

        $done = false;
        $ratio = 1;
     

        $nextClient = $this->getNextToDepot($simpleMatrice[$depot_id], $listClients);
        $param_distance_max = $optimisationParams->param_distance_max;
        $param_poids_max = $optimisationParams->param_poids_max;
        $param_capacite_max = $optimisationParams->param_capacite_max;
        $montant_chargement_max = $optimisationParams->montant_chargement_max;
        $param_nb_clients_max = $optimisationParams->param_nb_clients_max;
        $montant_chargement_min = $optimisationParams->montant_chargement_min;



        $optimisation = new OptimisationConstructionModel2(
            $vehicules[$this->i]->vehicule_id ?? $vehicules[count($vehicules) - 1]->vehicule_id,
            $drivers[$this->i]->contact_id ?? $drivers[count($drivers) - 1]->contact_id,
            $simpleMatrice,
            $nextClient,
            [],
            1,
            $listClients,
            $param_distance_max,
            $param_poids_max,
            $param_capacite_max,
            $montant_chargement_max,
            $param_nb_clients_max,
            $montant_chargement_min
        );
        $optimisations[] = $optimisation;

    
        while (!$done) {
            $this->i++;
            echo "<br>";
            echo "optimisation number ".$this->i;
            $optimisation->optimise();
            $result[] = $optimisation;
            if ($optimisation->clientReste == null || count($optimisation->clientReste) == 0 || $this->i == 20) {
                $done = true;
            } else {
                $nextClient = $this->getNextToDepot($simpleMatrice[$depot_id], $optimisation->clientReste);
                if ($nextClient != null && $nextClient != false) {
                    $optimisation = new OptimisationConstructionModel2(
                        $vehicules[$this->i]->vehicule_id ?? $vehicules[count($vehicules) - 1]->vehicule_id,
                        $drivers[$this->i]->contact_id ?? $drivers[count($drivers) - 1]->contact_id,
                        $simpleMatrice,
                        $nextClient,
                        [],
                        1,
                        $optimisation->clientReste,
                        $param_distance_max,
                        $param_poids_max,
                        $param_capacite_max,
                        $montant_chargement_max,
                        $param_nb_clients_max,
                        $montant_chargement_min
                    );
                } else {
                    $done = true;
                }
            }
            
            echo "<br>";
            echo "client reste : ".count( $optimisation->clientReste);
            //dd($optimisation);
            //}


         
        }
        //dd($result);
        return $result;
        
        //dd($optimisations);
        // return $this->getBestresult($result);
    }

    public function getNextToDepot($array1, $array2)
    {
        foreach ($array1 as $key => $value) {
            if (isset($array2[$value->client_2_id])) {
                return $value;
            }
        }

        return null;
    }

    public function getBestresult($results)
    {
        $fitness = [];
        $i = 0;
        foreach ($results as $optimisation) {
            $fitness[] = $this->calculateFitness($optimisation, $i);
            $i++;
        }
        $fitness = collect($fitness);
        $best = $fitness->sortBy('last_name')->sortBy('first_name')->sortBy('')->first();
        //dd($best);
        return  $results[$best->index];
    }

    public function calculateFitness($optimisation, $index)
    {
        $optimisation = collect($optimisation);
        return ((object) [
            "index" => $index,
            "nbr_van" => $optimisation->count() ?? 0,
            "distance" => $optimisation->sum('distance'),
            "avg_clients" => $optimisation->avg('nbr_clients')
        ]);
    }
}
