<?php

namespace App\Services\Optimisation\Construction2Algo;

use stdClass;

class OptimisationConstructionModel2
{
    public $distance;

    public $capacite;

    public $montant;

    public $poids;

    public $duree;

    public $nbr_clients;

    public $nbr_colis;

    public array $clients_data;

    public function __construct(
        public int $vehicule_id,
        public int $driver_id,
        public array $clients_param,
        public $nextClient,
        public array $clients,
        public $status,
        public array $clientReste,
        public $max_distance,
        public $max_poids,
        public $max_capacite,
        public $max_montant,
        public $max_nbr_clients,
        public $montant_chargement_min
    ) {
        $this->distance = 0;
        $this->capacite = 0;
        $this->montant = 0;
        $this->poids = 0;
        $this->duree = 0;
        $this->nbr_colis = 0;
        $this->nbr_clients = 0;
        $this->clients_data = [];
    }

    public function optimise()
    {
        while ($this->status == 1 && $this->nextClient != null && $this->nextClient != false) {
            $this->addClient();
            $this->findNextClient();
            $this->checkOptimisationStatus();
        }
    }

    public function addClient()
    {
        if (count($this->clients) == 0) {
            $this->distance += 0;
            $this->duree += 0;
        } else {
            $this->distance += $this->nextClient->distance;
            $this->duree += $this->nextClient->duree;
        }

        $this->clients[] = $this->nextClient->client_2_id;
        $this->nbr_clients++;

        $this->capacite += $this->clientReste[$this->nextClient->client_2_id]->volume;
        $this->montant += $this->clientReste[$this->nextClient->client_2_id]->montant;
        $this->poids += $this->clientReste[$this->nextClient->client_2_id]->poids;
        $this->nbr_colis += $this->clientReste[$this->nextClient->client_2_id]->nbr_colis;
        $this->setClientData();
        unset($this->clientReste[$this->nextClient->client_2_id]);
    }

    public function setClientData()
    {
        $data = new stdClass();

        $data->distance = $this->nextClient->distance;
        $data->duree = $this->nextClient->duree;
        $data->capacite = $this->clientReste[$this->nextClient->client_2_id]->volume;
        $data->montant = $this->clientReste[$this->nextClient->client_2_id]->montant;
        $data->poids = $this->clientReste[$this->nextClient->client_2_id]->poids;
        $data->nbr_colis = $this->clientReste[$this->nextClient->client_2_id]->nbr_colis;
        $this->clients_data[] = $data;
    }

    public function findNextClient()
    {
        //$array = $this->clients_param[$this->nextClient->client_2_id];
        $array = $this->clients_param[-6];
        $first = null;
        $second = null;
        $third = null;
        echo "find next for  ".$this->nextClient->client_2_id ;
        echo "<br>";
        foreach ($array as $elem) {
            if (!in_array($elem->client_2_id, $this->clients, true) && isset($this->clientReste[$elem->client_2_id])) {
                // if ($elem->distance > 2000 &&  (($this->nbr_clients + 1) / $this->max_nbr_clients) > 0.7) {
                //     if (is_null($first)) {
                //         $this->nextClient = null;
                //         $this->status = 2;
                //         return true;
                //     } else {
                //         continue;
                //     }
                // }
                if (!is_null($first) && !is_null($second)  && !is_null($third)) {
                    continue;
                }
                if (!is_null($first) && !is_null($second)  && is_null($third)) {
                    $third = $elem;
                    echo "third is $elem->client_2_id";
                    echo "<br>";
                }
                if (!is_null($first) && is_null($second)) {
                    $second = $elem;
                    echo "second is $elem->client_2_id";
                    echo "<br>";
                }
                if (is_null($first)) {
                    $first = $elem;
                    echo "first is $elem->client_2_id";
                    echo "<br>";
                }
            }
        }

        if (is_null($first)) {
            $this->nextClient = null;
            $this->status = 2;
            return true;
        }

        $picked = $this->pickNext($first, $second, $third);

        // if (!$this->checkOptimisationStatusWithNext($elem->distance, $this->clientReste[$elem->client_2_id]->montant, $this->clientReste[$elem->client_2_id]->poids, 1)) {
        //     $this->nextClient = null;
        //     $this->status = 2;
        //     return true;
        // }

        $this->nextClient = $picked;
        return true;
    }

    public function pickNext($first, $second, $third)
    {
        //  dd($first, $second,$third);
        $picked = $first;
        return  $picked;
        $matericeDistance = $this->clients_param;
        $first_id = $first->client_2_id ?? -1;
        $second_id = $second->client_2_id ?? -1;
        $third_id = $third->client_2_id ?? -1;
        $a = max($this->existInRoad($first_id, $second_id, $matericeDistance), $this->existInRoad($first_id, $third_id, $matericeDistance));
        $b = max($this->existInRoad($second_id, $first_id, $matericeDistance), $this->existInRoad($second_id, $third_id, $matericeDistance));
        $c = max($this->existInRoad($third_id, $first_id, $matericeDistance), $this->existInRoad($third_id, $second_id, $matericeDistance));
        echo "<br>";
        echo ("a road is $a");
        echo "<br>";
        echo ( "b road is $b");
        echo "<br>";
         echo ( "c raod is $c");
        echo "<br>";
        $min = min($a, $b, $c);
        if ($min == $a) {
            $picked = $first;
        } else {
            if ($min == $b) {
                $picked = $second;
            } else {
                if ($min == $c) {
                    $picked = $third;
                }
            }
        }


        return $picked;
    }

    public function existInRoad(int $start_client, int $end_client, $matericeDistance)
    {
        $first = $start_client;
        $next = null;
        $i = 1;
        $road = [];
        if ($end_client == -1 || $start_client == -1) {
            return 100;
        }
        // echo "<br>";
        // echo "looking for $end_client in $start_client road";
        $road[] = $first;

        while ($i < 50 && $next != $end_client && !is_null($first)) {

            $next = $this->getNextNew($matericeDistance[$first], $road);
            $road[] = $next;
            // echo "<br>";
            // echo "next is $next";
            $first = $next;
            $i++;
        }

        if (is_null($next)) {
            return 100;
        } else {
            return $i;
        }
    }
    public function getNextNew($list, $road)
    {
        foreach ($list as $elem) {
            if (!in_array($elem->client_2_id, $this->clients, true) && isset($this->clientReste[$elem->client_2_id]) && !in_array($elem->client_2_id, $road, false)) {
                $next = $elem->client_2_id;
                return $next;
            }
        }
    }
    public function checkOptimisationStatus()
    {
        if (
            (($this->distance >= $this->max_distance && $this->max_distance != -1)
                || ($this->capacite >= $this->max_capacite && $this->max_capacite != -1)
                || ($this->montant >= $this->max_montant && $this->max_montant != -1)
                || ($this->poids >= $this->max_poids && $this->max_poids != -1)
                || ($this->nbr_clients >= $this->max_nbr_clients && $this->max_nbr_clients != -1)
            ) && $this->max_montant >= $this->montant_chargement_min
        ) {
            $this->status = 2;
            echo 'status=' . $this->status;
            echo '<br>';
            // echo ' capacite at'.$this->capacite.' / max is '.$this->max_capacite;
            // echo '<br>';
            // echo ' distance at '.$this->distance.' / max is '.$this->max_distance;
            // echo '<br>';
            // echo '  montant at '.$this->montant.' / max is '.$this->max_montant;
            // echo '<br>';
            // echo ' poids at '.$this->poids.' / max is '.$this->max_poids;
            // echo '<br>';
            // echo ' nbr_colis at '.$this->nbr_colis;
            // echo '<br>';
            // echo ' nbr_clients  at '.$this->nbr_clients;
            // echo '<br>';
        }
    }

    public function checkOptimisationStatusWithNext($distance, $montant, $poids, $nbr_clients)
    {
        if (
            (($this->distance >= ($this->max_distance + $distance) && $this->max_distance != -1)
                || ($this->capacite >= ($this->max_capacite + 0) && $this->max_capacite != -1)
                || ($this->montant >= ($this->max_montant + $montant)  && $this->max_montant != -1)
                || ($this->poids >= ($this->max_poids + $poids) && $this->max_poids != -1)
                || ($this->nbr_clients >= ($this->max_nbr_clients + $nbr_clients) && $this->max_nbr_clients != -1)
            )
            && ($this->max_montant + $montant) >= $this->montant_chargement_min
        ) {
            return false;
        }
        return true;
    }
}
