import {
  require_fs,
  require_path,
  require_picocolors_browser,
  require_postcss,
  require_url
} from "./chunk-JL7NXA4A.js";
import {
  __commonJS,
  __esm,
  __export,
  __require,
  __toCommonJS,
  __toESM
} from "./chunk-AUZ3RYOM.js";

// node_modules/@alloc/quick-lru/index.js
var require_quick_lru = __commonJS({
  "node_modules/@alloc/quick-lru/index.js"(exports, module) {
    "use strict";
    var QuickLRU = class {
      constructor(options = {}) {
        if (!(options.maxSize && options.maxSize > 0)) {
          throw new TypeError("`maxSize` must be a number greater than 0");
        }
        if (typeof options.maxAge === "number" && options.maxAge === 0) {
          throw new TypeError("`maxAge` must be a number greater than 0");
        }
        this.maxSize = options.maxSize;
        this.maxAge = options.maxAge || Infinity;
        this.onEviction = options.onEviction;
        this.cache = /* @__PURE__ */ new Map();
        this.oldCache = /* @__PURE__ */ new Map();
        this._size = 0;
      }
      _emitEvictions(cache) {
        if (typeof this.onEviction !== "function") {
          return;
        }
        for (const [key, item] of cache) {
          this.onEviction(key, item.value);
        }
      }
      _deleteIfExpired(key, item) {
        if (typeof item.expiry === "number" && item.expiry <= Date.now()) {
          if (typeof this.onEviction === "function") {
            this.onEviction(key, item.value);
          }
          return this.delete(key);
        }
        return false;
      }
      _getOrDeleteIfExpired(key, item) {
        const deleted = this._deleteIfExpired(key, item);
        if (deleted === false) {
          return item.value;
        }
      }
      _getItemValue(key, item) {
        return item.expiry ? this._getOrDeleteIfExpired(key, item) : item.value;
      }
      _peek(key, cache) {
        const item = cache.get(key);
        return this._getItemValue(key, item);
      }
      _set(key, value2) {
        this.cache.set(key, value2);
        this._size++;
        if (this._size >= this.maxSize) {
          this._size = 0;
          this._emitEvictions(this.oldCache);
          this.oldCache = this.cache;
          this.cache = /* @__PURE__ */ new Map();
        }
      }
      _moveToRecent(key, item) {
        this.oldCache.delete(key);
        this._set(key, item);
      }
      *_entriesAscending() {
        for (const item of this.oldCache) {
          const [key, value2] = item;
          if (!this.cache.has(key)) {
            const deleted = this._deleteIfExpired(key, value2);
            if (deleted === false) {
              yield item;
            }
          }
        }
        for (const item of this.cache) {
          const [key, value2] = item;
          const deleted = this._deleteIfExpired(key, value2);
          if (deleted === false) {
            yield item;
          }
        }
      }
      get(key) {
        if (this.cache.has(key)) {
          const item = this.cache.get(key);
          return this._getItemValue(key, item);
        }
        if (this.oldCache.has(key)) {
          const item = this.oldCache.get(key);
          if (this._deleteIfExpired(key, item) === false) {
            this._moveToRecent(key, item);
            return item.value;
          }
        }
      }
      set(key, value2, { maxAge = this.maxAge === Infinity ? void 0 : Date.now() + this.maxAge } = {}) {
        if (this.cache.has(key)) {
          this.cache.set(key, {
            value: value2,
            maxAge
          });
        } else {
          this._set(key, { value: value2, expiry: maxAge });
        }
      }
      has(key) {
        if (this.cache.has(key)) {
          return !this._deleteIfExpired(key, this.cache.get(key));
        }
        if (this.oldCache.has(key)) {
          return !this._deleteIfExpired(key, this.oldCache.get(key));
        }
        return false;
      }
      peek(key) {
        if (this.cache.has(key)) {
          return this._peek(key, this.cache);
        }
        if (this.oldCache.has(key)) {
          return this._peek(key, this.oldCache);
        }
      }
      delete(key) {
        const deleted = this.cache.delete(key);
        if (deleted) {
          this._size--;
        }
        return this.oldCache.delete(key) || deleted;
      }
      clear() {
        this.cache.clear();
        this.oldCache.clear();
        this._size = 0;
      }
      resize(newSize) {
        if (!(newSize && newSize > 0)) {
          throw new TypeError("`maxSize` must be a number greater than 0");
        }
        const items = [...this._entriesAscending()];
        const removeCount = items.length - newSize;
        if (removeCount < 0) {
          this.cache = new Map(items);
          this.oldCache = /* @__PURE__ */ new Map();
          this._size = items.length;
        } else {
          if (removeCount > 0) {
            this._emitEvictions(items.slice(0, removeCount));
          }
          this.oldCache = new Map(items.slice(removeCount));
          this.cache = /* @__PURE__ */ new Map();
          this._size = 0;
        }
        this.maxSize = newSize;
      }
      *keys() {
        for (const [key] of this) {
          yield key;
        }
      }
      *values() {
        for (const [, value2] of this) {
          yield value2;
        }
      }
      *[Symbol.iterator]() {
        for (const item of this.cache) {
          const [key, value2] = item;
          const deleted = this._deleteIfExpired(key, value2);
          if (deleted === false) {
            yield [key, value2.value];
          }
        }
        for (const item of this.oldCache) {
          const [key, value2] = item;
          if (!this.cache.has(key)) {
            const deleted = this._deleteIfExpired(key, value2);
            if (deleted === false) {
              yield [key, value2.value];
            }
          }
        }
      }
      *entriesDescending() {
        let items = [...this.cache];
        for (let i = items.length - 1; i >= 0; --i) {
          const item = items[i];
          const [key, value2] = item;
          const deleted = this._deleteIfExpired(key, value2);
          if (deleted === false) {
            yield [key, value2.value];
          }
        }
        items = [...this.oldCache];
        for (let i = items.length - 1; i >= 0; --i) {
          const item = items[i];
          const [key, value2] = item;
          if (!this.cache.has(key)) {
            const deleted = this._deleteIfExpired(key, value2);
            if (deleted === false) {
              yield [key, value2.value];
            }
          }
        }
      }
      *entriesAscending() {
        for (const [key, value2] of this._entriesAscending()) {
          yield [key, value2.value];
        }
      }
      get size() {
        if (!this._size) {
          return this.oldCache.size;
        }
        let oldCacheSize = 0;
        for (const key of this.oldCache.keys()) {
          if (!this.cache.has(key)) {
            oldCacheSize++;
          }
        }
        return Math.min(this._size + oldCacheSize, this.maxSize);
      }
    };
    module.exports = QuickLRU;
  }
});

// node_modules/object-hash/dist/object_hash.js
var require_object_hash = __commonJS({
  "node_modules/object-hash/dist/object_hash.js"(exports, module) {
    !function(e) {
      var t2;
      "object" == typeof exports ? module.exports = e() : "function" == typeof define && define.amd ? define(e) : ("undefined" != typeof window ? t2 = window : "undefined" != typeof global ? t2 = global : "undefined" != typeof self && (t2 = self), t2.objectHash = e());
    }(function() {
      return function r(o, i, u) {
        function s(n, e2) {
          if (!i[n]) {
            if (!o[n]) {
              var t2 = "function" == typeof __require && __require;
              if (!e2 && t2)
                return t2(n, true);
              if (a)
                return a(n, true);
              throw new Error("Cannot find module '" + n + "'");
            }
            e2 = i[n] = { exports: {} };
            o[n][0].call(e2.exports, function(e3) {
              var t3 = o[n][1][e3];
              return s(t3 || e3);
            }, e2, e2.exports, r, o, i, u);
          }
          return i[n].exports;
        }
        for (var a = "function" == typeof __require && __require, e = 0; e < u.length; e++)
          s(u[e]);
        return s;
      }({ 1: [function(w, b, m) {
        !(function(e, n, s, c, d, h, p, g, y) {
          "use strict";
          var r = w("crypto");
          function t2(e2, t3) {
            t3 = u(e2, t3);
            var n2;
            return void 0 === (n2 = "passthrough" !== t3.algorithm ? r.createHash(t3.algorithm) : new l()).write && (n2.write = n2.update, n2.end = n2.update), f(t3, n2).dispatch(e2), n2.update || n2.end(""), n2.digest ? n2.digest("buffer" === t3.encoding ? void 0 : t3.encoding) : (e2 = n2.read(), "buffer" !== t3.encoding ? e2.toString(t3.encoding) : e2);
          }
          (m = b.exports = t2).sha1 = function(e2) {
            return t2(e2);
          }, m.keys = function(e2) {
            return t2(e2, { excludeValues: true, algorithm: "sha1", encoding: "hex" });
          }, m.MD5 = function(e2) {
            return t2(e2, { algorithm: "md5", encoding: "hex" });
          }, m.keysMD5 = function(e2) {
            return t2(e2, { algorithm: "md5", encoding: "hex", excludeValues: true });
          };
          var o = r.getHashes ? r.getHashes().slice() : ["sha1", "md5"], i = (o.push("passthrough"), ["buffer", "hex", "binary", "base64"]);
          function u(e2, t3) {
            var n2 = {};
            if (n2.algorithm = (t3 = t3 || {}).algorithm || "sha1", n2.encoding = t3.encoding || "hex", n2.excludeValues = !!t3.excludeValues, n2.algorithm = n2.algorithm.toLowerCase(), n2.encoding = n2.encoding.toLowerCase(), n2.ignoreUnknown = true === t3.ignoreUnknown, n2.respectType = false !== t3.respectType, n2.respectFunctionNames = false !== t3.respectFunctionNames, n2.respectFunctionProperties = false !== t3.respectFunctionProperties, n2.unorderedArrays = true === t3.unorderedArrays, n2.unorderedSets = false !== t3.unorderedSets, n2.unorderedObjects = false !== t3.unorderedObjects, n2.replacer = t3.replacer || void 0, n2.excludeKeys = t3.excludeKeys || void 0, void 0 === e2)
              throw new Error("Object argument required.");
            for (var r2 = 0; r2 < o.length; ++r2)
              o[r2].toLowerCase() === n2.algorithm.toLowerCase() && (n2.algorithm = o[r2]);
            if (-1 === o.indexOf(n2.algorithm))
              throw new Error('Algorithm "' + n2.algorithm + '"  not supported. supported values: ' + o.join(", "));
            if (-1 === i.indexOf(n2.encoding) && "passthrough" !== n2.algorithm)
              throw new Error('Encoding "' + n2.encoding + '"  not supported. supported values: ' + i.join(", "));
            return n2;
          }
          function a(e2) {
            if ("function" == typeof e2)
              return null != /^function\s+\w*\s*\(\s*\)\s*{\s+\[native code\]\s+}$/i.exec(Function.prototype.toString.call(e2));
          }
          function f(o2, t3, i2) {
            i2 = i2 || [];
            function u2(e2) {
              return t3.update ? t3.update(e2, "utf8") : t3.write(e2, "utf8");
            }
            return { dispatch: function(e2) {
              return this["_" + (null === (e2 = o2.replacer ? o2.replacer(e2) : e2) ? "null" : typeof e2)](e2);
            }, _object: function(t4) {
              var n2, e2 = Object.prototype.toString.call(t4), r2 = /\[object (.*)\]/i.exec(e2);
              r2 = (r2 = r2 ? r2[1] : "unknown:[" + e2 + "]").toLowerCase();
              if (0 <= (e2 = i2.indexOf(t4)))
                return this.dispatch("[CIRCULAR:" + e2 + "]");
              if (i2.push(t4), void 0 !== s && s.isBuffer && s.isBuffer(t4))
                return u2("buffer:"), u2(t4);
              if ("object" === r2 || "function" === r2 || "asyncfunction" === r2)
                return e2 = Object.keys(t4), o2.unorderedObjects && (e2 = e2.sort()), false === o2.respectType || a(t4) || e2.splice(0, 0, "prototype", "__proto__", "constructor"), o2.excludeKeys && (e2 = e2.filter(function(e3) {
                  return !o2.excludeKeys(e3);
                })), u2("object:" + e2.length + ":"), n2 = this, e2.forEach(function(e3) {
                  n2.dispatch(e3), u2(":"), o2.excludeValues || n2.dispatch(t4[e3]), u2(",");
                });
              if (!this["_" + r2]) {
                if (o2.ignoreUnknown)
                  return u2("[" + r2 + "]");
                throw new Error('Unknown object type "' + r2 + '"');
              }
              this["_" + r2](t4);
            }, _array: function(e2, t4) {
              t4 = void 0 !== t4 ? t4 : false !== o2.unorderedArrays;
              var n2 = this;
              if (u2("array:" + e2.length + ":"), !t4 || e2.length <= 1)
                return e2.forEach(function(e3) {
                  return n2.dispatch(e3);
                });
              var r2 = [], t4 = e2.map(function(e3) {
                var t5 = new l(), n3 = i2.slice();
                return f(o2, t5, n3).dispatch(e3), r2 = r2.concat(n3.slice(i2.length)), t5.read().toString();
              });
              return i2 = i2.concat(r2), t4.sort(), this._array(t4, false);
            }, _date: function(e2) {
              return u2("date:" + e2.toJSON());
            }, _symbol: function(e2) {
              return u2("symbol:" + e2.toString());
            }, _error: function(e2) {
              return u2("error:" + e2.toString());
            }, _boolean: function(e2) {
              return u2("bool:" + e2.toString());
            }, _string: function(e2) {
              u2("string:" + e2.length + ":"), u2(e2.toString());
            }, _function: function(e2) {
              u2("fn:"), a(e2) ? this.dispatch("[native]") : this.dispatch(e2.toString()), false !== o2.respectFunctionNames && this.dispatch("function-name:" + String(e2.name)), o2.respectFunctionProperties && this._object(e2);
            }, _number: function(e2) {
              return u2("number:" + e2.toString());
            }, _xml: function(e2) {
              return u2("xml:" + e2.toString());
            }, _null: function() {
              return u2("Null");
            }, _undefined: function() {
              return u2("Undefined");
            }, _regexp: function(e2) {
              return u2("regex:" + e2.toString());
            }, _uint8array: function(e2) {
              return u2("uint8array:"), this.dispatch(Array.prototype.slice.call(e2));
            }, _uint8clampedarray: function(e2) {
              return u2("uint8clampedarray:"), this.dispatch(Array.prototype.slice.call(e2));
            }, _int8array: function(e2) {
              return u2("int8array:"), this.dispatch(Array.prototype.slice.call(e2));
            }, _uint16array: function(e2) {
              return u2("uint16array:"), this.dispatch(Array.prototype.slice.call(e2));
            }, _int16array: function(e2) {
              return u2("int16array:"), this.dispatch(Array.prototype.slice.call(e2));
            }, _uint32array: function(e2) {
              return u2("uint32array:"), this.dispatch(Array.prototype.slice.call(e2));
            }, _int32array: function(e2) {
              return u2("int32array:"), this.dispatch(Array.prototype.slice.call(e2));
            }, _float32array: function(e2) {
              return u2("float32array:"), this.dispatch(Array.prototype.slice.call(e2));
            }, _float64array: function(e2) {
              return u2("float64array:"), this.dispatch(Array.prototype.slice.call(e2));
            }, _arraybuffer: function(e2) {
              return u2("arraybuffer:"), this.dispatch(new Uint8Array(e2));
            }, _url: function(e2) {
              return u2("url:" + e2.toString());
            }, _map: function(e2) {
              u2("map:");
              e2 = Array.from(e2);
              return this._array(e2, false !== o2.unorderedSets);
            }, _set: function(e2) {
              u2("set:");
              e2 = Array.from(e2);
              return this._array(e2, false !== o2.unorderedSets);
            }, _file: function(e2) {
              return u2("file:"), this.dispatch([e2.name, e2.size, e2.type, e2.lastModfied]);
            }, _blob: function() {
              if (o2.ignoreUnknown)
                return u2("[blob]");
              throw Error('Hashing Blob objects is currently not supported\n(see https://github.com/puleos/object-hash/issues/26)\nUse "options.replacer" or "options.ignoreUnknown"\n');
            }, _domwindow: function() {
              return u2("domwindow");
            }, _bigint: function(e2) {
              return u2("bigint:" + e2.toString());
            }, _process: function() {
              return u2("process");
            }, _timer: function() {
              return u2("timer");
            }, _pipe: function() {
              return u2("pipe");
            }, _tcp: function() {
              return u2("tcp");
            }, _udp: function() {
              return u2("udp");
            }, _tty: function() {
              return u2("tty");
            }, _statwatcher: function() {
              return u2("statwatcher");
            }, _securecontext: function() {
              return u2("securecontext");
            }, _connection: function() {
              return u2("connection");
            }, _zlib: function() {
              return u2("zlib");
            }, _context: function() {
              return u2("context");
            }, _nodescript: function() {
              return u2("nodescript");
            }, _httpparser: function() {
              return u2("httpparser");
            }, _dataview: function() {
              return u2("dataview");
            }, _signal: function() {
              return u2("signal");
            }, _fsevent: function() {
              return u2("fsevent");
            }, _tlswrap: function() {
              return u2("tlswrap");
            } };
          }
          function l() {
            return { buf: "", write: function(e2) {
              this.buf += e2;
            }, end: function(e2) {
              this.buf += e2;
            }, read: function() {
              return this.buf;
            } };
          }
          m.writeToStream = function(e2, t3, n2) {
            return void 0 === n2 && (n2 = t3, t3 = {}), f(t3 = u(e2, t3), n2).dispatch(e2);
          };
        }).call(this, w("lYpoI2"), "undefined" != typeof self ? self : "undefined" != typeof window ? window : {}, w("buffer").Buffer, arguments[3], arguments[4], arguments[5], arguments[6], "/fake_9a5aa49d.js", "/");
      }, { buffer: 3, crypto: 5, lYpoI2: 11 }], 2: [function(e, t2, f) {
        !(function(e2, t3, n, r, o, i, u, s, a) {
          !function(e3) {
            "use strict";
            var a2 = "undefined" != typeof Uint8Array ? Uint8Array : Array, t4 = "+".charCodeAt(0), n2 = "/".charCodeAt(0), r2 = "0".charCodeAt(0), o2 = "a".charCodeAt(0), i2 = "A".charCodeAt(0), u2 = "-".charCodeAt(0), s2 = "_".charCodeAt(0);
            function f2(e4) {
              e4 = e4.charCodeAt(0);
              return e4 === t4 || e4 === u2 ? 62 : e4 === n2 || e4 === s2 ? 63 : e4 < r2 ? -1 : e4 < r2 + 10 ? e4 - r2 + 26 + 26 : e4 < i2 + 26 ? e4 - i2 : e4 < o2 + 26 ? e4 - o2 + 26 : void 0;
            }
            e3.toByteArray = function(e4) {
              var t5, n3;
              if (0 < e4.length % 4)
                throw new Error("Invalid string. Length must be a multiple of 4");
              var r3 = e4.length, r3 = "=" === e4.charAt(r3 - 2) ? 2 : "=" === e4.charAt(r3 - 1) ? 1 : 0, o3 = new a2(3 * e4.length / 4 - r3), i3 = 0 < r3 ? e4.length - 4 : e4.length, u3 = 0;
              function s3(e5) {
                o3[u3++] = e5;
              }
              for (t5 = 0; t5 < i3; t5 += 4, 0)
                s3((16711680 & (n3 = f2(e4.charAt(t5)) << 18 | f2(e4.charAt(t5 + 1)) << 12 | f2(e4.charAt(t5 + 2)) << 6 | f2(e4.charAt(t5 + 3)))) >> 16), s3((65280 & n3) >> 8), s3(255 & n3);
              return 2 == r3 ? s3(255 & (n3 = f2(e4.charAt(t5)) << 2 | f2(e4.charAt(t5 + 1)) >> 4)) : 1 == r3 && (s3((n3 = f2(e4.charAt(t5)) << 10 | f2(e4.charAt(t5 + 1)) << 4 | f2(e4.charAt(t5 + 2)) >> 2) >> 8 & 255), s3(255 & n3)), o3;
            }, e3.fromByteArray = function(e4) {
              var t5, n3, r3, o3, i3 = e4.length % 3, u3 = "";
              function s3(e5) {
                return "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/".charAt(e5);
              }
              for (t5 = 0, r3 = e4.length - i3; t5 < r3; t5 += 3)
                n3 = (e4[t5] << 16) + (e4[t5 + 1] << 8) + e4[t5 + 2], u3 += s3((o3 = n3) >> 18 & 63) + s3(o3 >> 12 & 63) + s3(o3 >> 6 & 63) + s3(63 & o3);
              switch (i3) {
                case 1:
                  u3 = (u3 += s3((n3 = e4[e4.length - 1]) >> 2)) + s3(n3 << 4 & 63) + "==";
                  break;
                case 2:
                  u3 = (u3 = (u3 += s3((n3 = (e4[e4.length - 2] << 8) + e4[e4.length - 1]) >> 10)) + s3(n3 >> 4 & 63)) + s3(n3 << 2 & 63) + "=";
              }
              return u3;
            };
          }(void 0 === f ? this.base64js = {} : f);
        }).call(this, e("lYpoI2"), "undefined" != typeof self ? self : "undefined" != typeof window ? window : {}, e("buffer").Buffer, arguments[3], arguments[4], arguments[5], arguments[6], "/node_modules/gulp-browserify/node_modules/base64-js/lib/b64.js", "/node_modules/gulp-browserify/node_modules/base64-js/lib");
      }, { buffer: 3, lYpoI2: 11 }], 3: [function(O, e, H) {
        !(function(e2, n, f, r, h, p, g, y, w) {
          var a = O("base64-js"), i = O("ieee754");
          function f(e3, t3, n2) {
            if (!(this instanceof f))
              return new f(e3, t3, n2);
            var r2, o2, i2, u2, s2 = typeof e3;
            if ("base64" === t3 && "string" == s2)
              for (e3 = (u2 = e3).trim ? u2.trim() : u2.replace(/^\s+|\s+$/g, ""); e3.length % 4 != 0; )
                e3 += "=";
            if ("number" == s2)
              r2 = j(e3);
            else if ("string" == s2)
              r2 = f.byteLength(e3, t3);
            else {
              if ("object" != s2)
                throw new Error("First argument needs to be a number, array or string.");
              r2 = j(e3.length);
            }
            if (f._useTypedArrays ? o2 = f._augment(new Uint8Array(r2)) : ((o2 = this).length = r2, o2._isBuffer = true), f._useTypedArrays && "number" == typeof e3.byteLength)
              o2._set(e3);
            else if (C(u2 = e3) || f.isBuffer(u2) || u2 && "object" == typeof u2 && "number" == typeof u2.length)
              for (i2 = 0; i2 < r2; i2++)
                f.isBuffer(e3) ? o2[i2] = e3.readUInt8(i2) : o2[i2] = e3[i2];
            else if ("string" == s2)
              o2.write(e3, 0, t3);
            else if ("number" == s2 && !f._useTypedArrays && !n2)
              for (i2 = 0; i2 < r2; i2++)
                o2[i2] = 0;
            return o2;
          }
          function b(e3, t3, n2, r2) {
            return f._charsWritten = c(function(e4) {
              for (var t4 = [], n3 = 0; n3 < e4.length; n3++)
                t4.push(255 & e4.charCodeAt(n3));
              return t4;
            }(t3), e3, n2, r2);
          }
          function m(e3, t3, n2, r2) {
            return f._charsWritten = c(function(e4) {
              for (var t4, n3, r3 = [], o2 = 0; o2 < e4.length; o2++)
                n3 = e4.charCodeAt(o2), t4 = n3 >> 8, n3 = n3 % 256, r3.push(n3), r3.push(t4);
              return r3;
            }(t3), e3, n2, r2);
          }
          function v(e3, t3, n2) {
            var r2 = "";
            n2 = Math.min(e3.length, n2);
            for (var o2 = t3; o2 < n2; o2++)
              r2 += String.fromCharCode(e3[o2]);
            return r2;
          }
          function o(e3, t3, n2, r2) {
            r2 || (d("boolean" == typeof n2, "missing or invalid endian"), d(null != t3, "missing offset"), d(t3 + 1 < e3.length, "Trying to read beyond buffer length"));
            var o2, r2 = e3.length;
            if (!(r2 <= t3))
              return n2 ? (o2 = e3[t3], t3 + 1 < r2 && (o2 |= e3[t3 + 1] << 8)) : (o2 = e3[t3] << 8, t3 + 1 < r2 && (o2 |= e3[t3 + 1])), o2;
          }
          function u(e3, t3, n2, r2) {
            r2 || (d("boolean" == typeof n2, "missing or invalid endian"), d(null != t3, "missing offset"), d(t3 + 3 < e3.length, "Trying to read beyond buffer length"));
            var o2, r2 = e3.length;
            if (!(r2 <= t3))
              return n2 ? (t3 + 2 < r2 && (o2 = e3[t3 + 2] << 16), t3 + 1 < r2 && (o2 |= e3[t3 + 1] << 8), o2 |= e3[t3], t3 + 3 < r2 && (o2 += e3[t3 + 3] << 24 >>> 0)) : (t3 + 1 < r2 && (o2 = e3[t3 + 1] << 16), t3 + 2 < r2 && (o2 |= e3[t3 + 2] << 8), t3 + 3 < r2 && (o2 |= e3[t3 + 3]), o2 += e3[t3] << 24 >>> 0), o2;
          }
          function _(e3, t3, n2, r2) {
            if (r2 || (d("boolean" == typeof n2, "missing or invalid endian"), d(null != t3, "missing offset"), d(t3 + 1 < e3.length, "Trying to read beyond buffer length")), !(e3.length <= t3))
              return r2 = o(e3, t3, n2, true), 32768 & r2 ? -1 * (65535 - r2 + 1) : r2;
          }
          function E(e3, t3, n2, r2) {
            if (r2 || (d("boolean" == typeof n2, "missing or invalid endian"), d(null != t3, "missing offset"), d(t3 + 3 < e3.length, "Trying to read beyond buffer length")), !(e3.length <= t3))
              return r2 = u(e3, t3, n2, true), 2147483648 & r2 ? -1 * (4294967295 - r2 + 1) : r2;
          }
          function I(e3, t3, n2, r2) {
            return r2 || (d("boolean" == typeof n2, "missing or invalid endian"), d(t3 + 3 < e3.length, "Trying to read beyond buffer length")), i.read(e3, t3, n2, 23, 4);
          }
          function A(e3, t3, n2, r2) {
            return r2 || (d("boolean" == typeof n2, "missing or invalid endian"), d(t3 + 7 < e3.length, "Trying to read beyond buffer length")), i.read(e3, t3, n2, 52, 8);
          }
          function s(e3, t3, n2, r2, o2) {
            o2 || (d(null != t3, "missing value"), d("boolean" == typeof r2, "missing or invalid endian"), d(null != n2, "missing offset"), d(n2 + 1 < e3.length, "trying to write beyond buffer length"), Y(t3, 65535));
            o2 = e3.length;
            if (!(o2 <= n2))
              for (var i2 = 0, u2 = Math.min(o2 - n2, 2); i2 < u2; i2++)
                e3[n2 + i2] = (t3 & 255 << 8 * (r2 ? i2 : 1 - i2)) >>> 8 * (r2 ? i2 : 1 - i2);
          }
          function l(e3, t3, n2, r2, o2) {
            o2 || (d(null != t3, "missing value"), d("boolean" == typeof r2, "missing or invalid endian"), d(null != n2, "missing offset"), d(n2 + 3 < e3.length, "trying to write beyond buffer length"), Y(t3, 4294967295));
            o2 = e3.length;
            if (!(o2 <= n2))
              for (var i2 = 0, u2 = Math.min(o2 - n2, 4); i2 < u2; i2++)
                e3[n2 + i2] = t3 >>> 8 * (r2 ? i2 : 3 - i2) & 255;
          }
          function B(e3, t3, n2, r2, o2) {
            o2 || (d(null != t3, "missing value"), d("boolean" == typeof r2, "missing or invalid endian"), d(null != n2, "missing offset"), d(n2 + 1 < e3.length, "Trying to write beyond buffer length"), F(t3, 32767, -32768)), e3.length <= n2 || s(e3, 0 <= t3 ? t3 : 65535 + t3 + 1, n2, r2, o2);
          }
          function L(e3, t3, n2, r2, o2) {
            o2 || (d(null != t3, "missing value"), d("boolean" == typeof r2, "missing or invalid endian"), d(null != n2, "missing offset"), d(n2 + 3 < e3.length, "Trying to write beyond buffer length"), F(t3, 2147483647, -2147483648)), e3.length <= n2 || l(e3, 0 <= t3 ? t3 : 4294967295 + t3 + 1, n2, r2, o2);
          }
          function U(e3, t3, n2, r2, o2) {
            o2 || (d(null != t3, "missing value"), d("boolean" == typeof r2, "missing or invalid endian"), d(null != n2, "missing offset"), d(n2 + 3 < e3.length, "Trying to write beyond buffer length"), D(t3, 34028234663852886e22, -34028234663852886e22)), e3.length <= n2 || i.write(e3, t3, n2, r2, 23, 4);
          }
          function x(e3, t3, n2, r2, o2) {
            o2 || (d(null != t3, "missing value"), d("boolean" == typeof r2, "missing or invalid endian"), d(null != n2, "missing offset"), d(n2 + 7 < e3.length, "Trying to write beyond buffer length"), D(t3, 17976931348623157e292, -17976931348623157e292)), e3.length <= n2 || i.write(e3, t3, n2, r2, 52, 8);
          }
          H.Buffer = f, H.SlowBuffer = f, H.INSPECT_MAX_BYTES = 50, f.poolSize = 8192, f._useTypedArrays = function() {
            try {
              var e3 = new ArrayBuffer(0), t3 = new Uint8Array(e3);
              return t3.foo = function() {
                return 42;
              }, 42 === t3.foo() && "function" == typeof t3.subarray;
            } catch (e4) {
              return false;
            }
          }(), f.isEncoding = function(e3) {
            switch (String(e3).toLowerCase()) {
              case "hex":
              case "utf8":
              case "utf-8":
              case "ascii":
              case "binary":
              case "base64":
              case "raw":
              case "ucs2":
              case "ucs-2":
              case "utf16le":
              case "utf-16le":
                return true;
              default:
                return false;
            }
          }, f.isBuffer = function(e3) {
            return !(null == e3 || !e3._isBuffer);
          }, f.byteLength = function(e3, t3) {
            var n2;
            switch (e3 += "", t3 || "utf8") {
              case "hex":
                n2 = e3.length / 2;
                break;
              case "utf8":
              case "utf-8":
                n2 = T(e3).length;
                break;
              case "ascii":
              case "binary":
              case "raw":
                n2 = e3.length;
                break;
              case "base64":
                n2 = M(e3).length;
                break;
              case "ucs2":
              case "ucs-2":
              case "utf16le":
              case "utf-16le":
                n2 = 2 * e3.length;
                break;
              default:
                throw new Error("Unknown encoding");
            }
            return n2;
          }, f.concat = function(e3, t3) {
            if (d(C(e3), "Usage: Buffer.concat(list, [totalLength])\nlist should be an Array."), 0 === e3.length)
              return new f(0);
            if (1 === e3.length)
              return e3[0];
            if ("number" != typeof t3)
              for (o2 = t3 = 0; o2 < e3.length; o2++)
                t3 += e3[o2].length;
            for (var n2 = new f(t3), r2 = 0, o2 = 0; o2 < e3.length; o2++) {
              var i2 = e3[o2];
              i2.copy(n2, r2), r2 += i2.length;
            }
            return n2;
          }, f.prototype.write = function(e3, t3, n2, r2) {
            isFinite(t3) ? isFinite(n2) || (r2 = n2, n2 = void 0) : (a2 = r2, r2 = t3, t3 = n2, n2 = a2), t3 = Number(t3) || 0;
            var o2, i2, u2, s2, a2 = this.length - t3;
            switch ((!n2 || a2 < (n2 = Number(n2))) && (n2 = a2), r2 = String(r2 || "utf8").toLowerCase()) {
              case "hex":
                o2 = function(e4, t4, n3, r3) {
                  n3 = Number(n3) || 0;
                  var o3 = e4.length - n3;
                  (!r3 || o3 < (r3 = Number(r3))) && (r3 = o3), d((o3 = t4.length) % 2 == 0, "Invalid hex string"), o3 / 2 < r3 && (r3 = o3 / 2);
                  for (var i3 = 0; i3 < r3; i3++) {
                    var u3 = parseInt(t4.substr(2 * i3, 2), 16);
                    d(!isNaN(u3), "Invalid hex string"), e4[n3 + i3] = u3;
                  }
                  return f._charsWritten = 2 * i3, i3;
                }(this, e3, t3, n2);
                break;
              case "utf8":
              case "utf-8":
                i2 = this, u2 = t3, s2 = n2, o2 = f._charsWritten = c(T(e3), i2, u2, s2);
                break;
              case "ascii":
              case "binary":
                o2 = b(this, e3, t3, n2);
                break;
              case "base64":
                i2 = this, u2 = t3, s2 = n2, o2 = f._charsWritten = c(M(e3), i2, u2, s2);
                break;
              case "ucs2":
              case "ucs-2":
              case "utf16le":
              case "utf-16le":
                o2 = m(this, e3, t3, n2);
                break;
              default:
                throw new Error("Unknown encoding");
            }
            return o2;
          }, f.prototype.toString = function(e3, t3, n2) {
            var r2, o2, i2, u2, s2 = this;
            if (e3 = String(e3 || "utf8").toLowerCase(), t3 = Number(t3) || 0, (n2 = void 0 !== n2 ? Number(n2) : s2.length) === t3)
              return "";
            switch (e3) {
              case "hex":
                r2 = function(e4, t4, n3) {
                  var r3 = e4.length;
                  (!t4 || t4 < 0) && (t4 = 0);
                  (!n3 || n3 < 0 || r3 < n3) && (n3 = r3);
                  for (var o3 = "", i3 = t4; i3 < n3; i3++)
                    o3 += k(e4[i3]);
                  return o3;
                }(s2, t3, n2);
                break;
              case "utf8":
              case "utf-8":
                r2 = function(e4, t4, n3) {
                  var r3 = "", o3 = "";
                  n3 = Math.min(e4.length, n3);
                  for (var i3 = t4; i3 < n3; i3++)
                    e4[i3] <= 127 ? (r3 += N(o3) + String.fromCharCode(e4[i3]), o3 = "") : o3 += "%" + e4[i3].toString(16);
                  return r3 + N(o3);
                }(s2, t3, n2);
                break;
              case "ascii":
              case "binary":
                r2 = v(s2, t3, n2);
                break;
              case "base64":
                o2 = s2, u2 = n2, r2 = 0 === (i2 = t3) && u2 === o2.length ? a.fromByteArray(o2) : a.fromByteArray(o2.slice(i2, u2));
                break;
              case "ucs2":
              case "ucs-2":
              case "utf16le":
              case "utf-16le":
                r2 = function(e4, t4, n3) {
                  for (var r3 = e4.slice(t4, n3), o3 = "", i3 = 0; i3 < r3.length; i3 += 2)
                    o3 += String.fromCharCode(r3[i3] + 256 * r3[i3 + 1]);
                  return o3;
                }(s2, t3, n2);
                break;
              default:
                throw new Error("Unknown encoding");
            }
            return r2;
          }, f.prototype.toJSON = function() {
            return { type: "Buffer", data: Array.prototype.slice.call(this._arr || this, 0) };
          }, f.prototype.copy = function(e3, t3, n2, r2) {
            if (t3 = t3 || 0, (r2 = r2 || 0 === r2 ? r2 : this.length) !== (n2 = n2 || 0) && 0 !== e3.length && 0 !== this.length) {
              d(n2 <= r2, "sourceEnd < sourceStart"), d(0 <= t3 && t3 < e3.length, "targetStart out of bounds"), d(0 <= n2 && n2 < this.length, "sourceStart out of bounds"), d(0 <= r2 && r2 <= this.length, "sourceEnd out of bounds"), r2 > this.length && (r2 = this.length);
              var o2 = (r2 = e3.length - t3 < r2 - n2 ? e3.length - t3 + n2 : r2) - n2;
              if (o2 < 100 || !f._useTypedArrays)
                for (var i2 = 0; i2 < o2; i2++)
                  e3[i2 + t3] = this[i2 + n2];
              else
                e3._set(this.subarray(n2, n2 + o2), t3);
            }
          }, f.prototype.slice = function(e3, t3) {
            var n2 = this.length;
            if (e3 = S(e3, n2, 0), t3 = S(t3, n2, n2), f._useTypedArrays)
              return f._augment(this.subarray(e3, t3));
            for (var r2 = t3 - e3, o2 = new f(r2, void 0, true), i2 = 0; i2 < r2; i2++)
              o2[i2] = this[i2 + e3];
            return o2;
          }, f.prototype.get = function(e3) {
            return console.log(".get() is deprecated. Access using array indexes instead."), this.readUInt8(e3);
          }, f.prototype.set = function(e3, t3) {
            return console.log(".set() is deprecated. Access using array indexes instead."), this.writeUInt8(e3, t3);
          }, f.prototype.readUInt8 = function(e3, t3) {
            if (t3 || (d(null != e3, "missing offset"), d(e3 < this.length, "Trying to read beyond buffer length")), !(e3 >= this.length))
              return this[e3];
          }, f.prototype.readUInt16LE = function(e3, t3) {
            return o(this, e3, true, t3);
          }, f.prototype.readUInt16BE = function(e3, t3) {
            return o(this, e3, false, t3);
          }, f.prototype.readUInt32LE = function(e3, t3) {
            return u(this, e3, true, t3);
          }, f.prototype.readUInt32BE = function(e3, t3) {
            return u(this, e3, false, t3);
          }, f.prototype.readInt8 = function(e3, t3) {
            if (t3 || (d(null != e3, "missing offset"), d(e3 < this.length, "Trying to read beyond buffer length")), !(e3 >= this.length))
              return 128 & this[e3] ? -1 * (255 - this[e3] + 1) : this[e3];
          }, f.prototype.readInt16LE = function(e3, t3) {
            return _(this, e3, true, t3);
          }, f.prototype.readInt16BE = function(e3, t3) {
            return _(this, e3, false, t3);
          }, f.prototype.readInt32LE = function(e3, t3) {
            return E(this, e3, true, t3);
          }, f.prototype.readInt32BE = function(e3, t3) {
            return E(this, e3, false, t3);
          }, f.prototype.readFloatLE = function(e3, t3) {
            return I(this, e3, true, t3);
          }, f.prototype.readFloatBE = function(e3, t3) {
            return I(this, e3, false, t3);
          }, f.prototype.readDoubleLE = function(e3, t3) {
            return A(this, e3, true, t3);
          }, f.prototype.readDoubleBE = function(e3, t3) {
            return A(this, e3, false, t3);
          }, f.prototype.writeUInt8 = function(e3, t3, n2) {
            n2 || (d(null != e3, "missing value"), d(null != t3, "missing offset"), d(t3 < this.length, "trying to write beyond buffer length"), Y(e3, 255)), t3 >= this.length || (this[t3] = e3);
          }, f.prototype.writeUInt16LE = function(e3, t3, n2) {
            s(this, e3, t3, true, n2);
          }, f.prototype.writeUInt16BE = function(e3, t3, n2) {
            s(this, e3, t3, false, n2);
          }, f.prototype.writeUInt32LE = function(e3, t3, n2) {
            l(this, e3, t3, true, n2);
          }, f.prototype.writeUInt32BE = function(e3, t3, n2) {
            l(this, e3, t3, false, n2);
          }, f.prototype.writeInt8 = function(e3, t3, n2) {
            n2 || (d(null != e3, "missing value"), d(null != t3, "missing offset"), d(t3 < this.length, "Trying to write beyond buffer length"), F(e3, 127, -128)), t3 >= this.length || (0 <= e3 ? this.writeUInt8(e3, t3, n2) : this.writeUInt8(255 + e3 + 1, t3, n2));
          }, f.prototype.writeInt16LE = function(e3, t3, n2) {
            B(this, e3, t3, true, n2);
          }, f.prototype.writeInt16BE = function(e3, t3, n2) {
            B(this, e3, t3, false, n2);
          }, f.prototype.writeInt32LE = function(e3, t3, n2) {
            L(this, e3, t3, true, n2);
          }, f.prototype.writeInt32BE = function(e3, t3, n2) {
            L(this, e3, t3, false, n2);
          }, f.prototype.writeFloatLE = function(e3, t3, n2) {
            U(this, e3, t3, true, n2);
          }, f.prototype.writeFloatBE = function(e3, t3, n2) {
            U(this, e3, t3, false, n2);
          }, f.prototype.writeDoubleLE = function(e3, t3, n2) {
            x(this, e3, t3, true, n2);
          }, f.prototype.writeDoubleBE = function(e3, t3, n2) {
            x(this, e3, t3, false, n2);
          }, f.prototype.fill = function(e3, t3, n2) {
            if (t3 = t3 || 0, n2 = n2 || this.length, d("number" == typeof (e3 = "string" == typeof (e3 = e3 || 0) ? e3.charCodeAt(0) : e3) && !isNaN(e3), "value is not a number"), d(t3 <= n2, "end < start"), n2 !== t3 && 0 !== this.length) {
              d(0 <= t3 && t3 < this.length, "start out of bounds"), d(0 <= n2 && n2 <= this.length, "end out of bounds");
              for (var r2 = t3; r2 < n2; r2++)
                this[r2] = e3;
            }
          }, f.prototype.inspect = function() {
            for (var e3 = [], t3 = this.length, n2 = 0; n2 < t3; n2++)
              if (e3[n2] = k(this[n2]), n2 === H.INSPECT_MAX_BYTES) {
                e3[n2 + 1] = "...";
                break;
              }
            return "<Buffer " + e3.join(" ") + ">";
          }, f.prototype.toArrayBuffer = function() {
            if ("undefined" == typeof Uint8Array)
              throw new Error("Buffer.toArrayBuffer not supported in this browser");
            if (f._useTypedArrays)
              return new f(this).buffer;
            for (var e3 = new Uint8Array(this.length), t3 = 0, n2 = e3.length; t3 < n2; t3 += 1)
              e3[t3] = this[t3];
            return e3.buffer;
          };
          var t2 = f.prototype;
          function S(e3, t3, n2) {
            return "number" != typeof e3 ? n2 : t3 <= (e3 = ~~e3) ? t3 : 0 <= e3 || 0 <= (e3 += t3) ? e3 : 0;
          }
          function j(e3) {
            return (e3 = ~~Math.ceil(+e3)) < 0 ? 0 : e3;
          }
          function C(e3) {
            return (Array.isArray || function(e4) {
              return "[object Array]" === Object.prototype.toString.call(e4);
            })(e3);
          }
          function k(e3) {
            return e3 < 16 ? "0" + e3.toString(16) : e3.toString(16);
          }
          function T(e3) {
            for (var t3 = [], n2 = 0; n2 < e3.length; n2++) {
              var r2 = e3.charCodeAt(n2);
              if (r2 <= 127)
                t3.push(e3.charCodeAt(n2));
              else
                for (var o2 = n2, i2 = (55296 <= r2 && r2 <= 57343 && n2++, encodeURIComponent(e3.slice(o2, n2 + 1)).substr(1).split("%")), u2 = 0; u2 < i2.length; u2++)
                  t3.push(parseInt(i2[u2], 16));
            }
            return t3;
          }
          function M(e3) {
            return a.toByteArray(e3);
          }
          function c(e3, t3, n2, r2) {
            for (var o2 = 0; o2 < r2 && !(o2 + n2 >= t3.length || o2 >= e3.length); o2++)
              t3[o2 + n2] = e3[o2];
            return o2;
          }
          function N(e3) {
            try {
              return decodeURIComponent(e3);
            } catch (e4) {
              return String.fromCharCode(65533);
            }
          }
          function Y(e3, t3) {
            d("number" == typeof e3, "cannot write a non-number as a number"), d(0 <= e3, "specified a negative value for writing an unsigned value"), d(e3 <= t3, "value is larger than maximum value for type"), d(Math.floor(e3) === e3, "value has a fractional component");
          }
          function F(e3, t3, n2) {
            d("number" == typeof e3, "cannot write a non-number as a number"), d(e3 <= t3, "value larger than maximum allowed value"), d(n2 <= e3, "value smaller than minimum allowed value"), d(Math.floor(e3) === e3, "value has a fractional component");
          }
          function D(e3, t3, n2) {
            d("number" == typeof e3, "cannot write a non-number as a number"), d(e3 <= t3, "value larger than maximum allowed value"), d(n2 <= e3, "value smaller than minimum allowed value");
          }
          function d(e3, t3) {
            if (!e3)
              throw new Error(t3 || "Failed assertion");
          }
          f._augment = function(e3) {
            return e3._isBuffer = true, e3._get = e3.get, e3._set = e3.set, e3.get = t2.get, e3.set = t2.set, e3.write = t2.write, e3.toString = t2.toString, e3.toLocaleString = t2.toString, e3.toJSON = t2.toJSON, e3.copy = t2.copy, e3.slice = t2.slice, e3.readUInt8 = t2.readUInt8, e3.readUInt16LE = t2.readUInt16LE, e3.readUInt16BE = t2.readUInt16BE, e3.readUInt32LE = t2.readUInt32LE, e3.readUInt32BE = t2.readUInt32BE, e3.readInt8 = t2.readInt8, e3.readInt16LE = t2.readInt16LE, e3.readInt16BE = t2.readInt16BE, e3.readInt32LE = t2.readInt32LE, e3.readInt32BE = t2.readInt32BE, e3.readFloatLE = t2.readFloatLE, e3.readFloatBE = t2.readFloatBE, e3.readDoubleLE = t2.readDoubleLE, e3.readDoubleBE = t2.readDoubleBE, e3.writeUInt8 = t2.writeUInt8, e3.writeUInt16LE = t2.writeUInt16LE, e3.writeUInt16BE = t2.writeUInt16BE, e3.writeUInt32LE = t2.writeUInt32LE, e3.writeUInt32BE = t2.writeUInt32BE, e3.writeInt8 = t2.writeInt8, e3.writeInt16LE = t2.writeInt16LE, e3.writeInt16BE = t2.writeInt16BE, e3.writeInt32LE = t2.writeInt32LE, e3.writeInt32BE = t2.writeInt32BE, e3.writeFloatLE = t2.writeFloatLE, e3.writeFloatBE = t2.writeFloatBE, e3.writeDoubleLE = t2.writeDoubleLE, e3.writeDoubleBE = t2.writeDoubleBE, e3.fill = t2.fill, e3.inspect = t2.inspect, e3.toArrayBuffer = t2.toArrayBuffer, e3;
          };
        }).call(this, O("lYpoI2"), "undefined" != typeof self ? self : "undefined" != typeof window ? window : {}, O("buffer").Buffer, arguments[3], arguments[4], arguments[5], arguments[6], "/node_modules/gulp-browserify/node_modules/buffer/index.js", "/node_modules/gulp-browserify/node_modules/buffer");
      }, { "base64-js": 2, buffer: 3, ieee754: 10, lYpoI2: 11 }], 4: [function(c, d, e) {
        !(function(e2, t2, a, n, r, o, i, u, s) {
          var a = c("buffer").Buffer, f = 4, l = new a(f);
          l.fill(0);
          d.exports = { hash: function(e3, t3, n2, r2) {
            for (var o2 = t3(function(e4, t4) {
              e4.length % f != 0 && (n3 = e4.length + (f - e4.length % f), e4 = a.concat([e4, l], n3));
              for (var n3, r3 = [], o3 = t4 ? e4.readInt32BE : e4.readInt32LE, i3 = 0; i3 < e4.length; i3 += f)
                r3.push(o3.call(e4, i3));
              return r3;
            }(e3 = a.isBuffer(e3) ? e3 : new a(e3), r2), 8 * e3.length), t3 = r2, i2 = new a(n2), u2 = t3 ? i2.writeInt32BE : i2.writeInt32LE, s2 = 0; s2 < o2.length; s2++)
              u2.call(i2, o2[s2], 4 * s2, true);
            return i2;
          } };
        }).call(this, c("lYpoI2"), "undefined" != typeof self ? self : "undefined" != typeof window ? window : {}, c("buffer").Buffer, arguments[3], arguments[4], arguments[5], arguments[6], "/node_modules/gulp-browserify/node_modules/crypto-browserify/helpers.js", "/node_modules/gulp-browserify/node_modules/crypto-browserify");
      }, { buffer: 3, lYpoI2: 11 }], 5: [function(v, e, _) {
        !(function(l, c, u, d, h, p, g, y, w) {
          var u = v("buffer").Buffer, e2 = v("./sha"), t2 = v("./sha256"), n = v("./rng"), b = { sha1: e2, sha256: t2, md5: v("./md5") }, s = 64, a = new u(s);
          function r(e3, n2) {
            var r2 = b[e3 = e3 || "sha1"], o2 = [];
            return r2 || i("algorithm:", e3, "is not yet supported"), { update: function(e4) {
              return u.isBuffer(e4) || (e4 = new u(e4)), o2.push(e4), e4.length, this;
            }, digest: function(e4) {
              var t3 = u.concat(o2), t3 = n2 ? function(e5, t4, n3) {
                u.isBuffer(t4) || (t4 = new u(t4)), u.isBuffer(n3) || (n3 = new u(n3)), t4.length > s ? t4 = e5(t4) : t4.length < s && (t4 = u.concat([t4, a], s));
                for (var r3 = new u(s), o3 = new u(s), i2 = 0; i2 < s; i2++)
                  r3[i2] = 54 ^ t4[i2], o3[i2] = 92 ^ t4[i2];
                return n3 = e5(u.concat([r3, n3])), e5(u.concat([o3, n3]));
              }(r2, n2, t3) : r2(t3);
              return o2 = null, e4 ? t3.toString(e4) : t3;
            } };
          }
          function i() {
            var e3 = [].slice.call(arguments).join(" ");
            throw new Error([e3, "we accept pull requests", "http://github.com/dominictarr/crypto-browserify"].join("\n"));
          }
          a.fill(0), _.createHash = function(e3) {
            return r(e3);
          }, _.createHmac = r, _.randomBytes = function(e3, t3) {
            if (!t3 || !t3.call)
              return new u(n(e3));
            try {
              t3.call(this, void 0, new u(n(e3)));
            } catch (e4) {
              t3(e4);
            }
          };
          var o, f = ["createCredentials", "createCipher", "createCipheriv", "createDecipher", "createDecipheriv", "createSign", "createVerify", "createDiffieHellman", "pbkdf2"], m = function(e3) {
            _[e3] = function() {
              i("sorry,", e3, "is not implemented yet");
            };
          };
          for (o in f)
            m(f[o], o);
        }).call(this, v("lYpoI2"), "undefined" != typeof self ? self : "undefined" != typeof window ? window : {}, v("buffer").Buffer, arguments[3], arguments[4], arguments[5], arguments[6], "/node_modules/gulp-browserify/node_modules/crypto-browserify/index.js", "/node_modules/gulp-browserify/node_modules/crypto-browserify");
      }, { "./md5": 6, "./rng": 7, "./sha": 8, "./sha256": 9, buffer: 3, lYpoI2: 11 }], 6: [function(w, b, e) {
        !(function(e2, r, o, i, u, a, f, l, y) {
          var t2 = w("./helpers");
          function n(e3, t3) {
            e3[t3 >> 5] |= 128 << t3 % 32, e3[14 + (t3 + 64 >>> 9 << 4)] = t3;
            for (var n2 = 1732584193, r2 = -271733879, o2 = -1732584194, i2 = 271733878, u2 = 0; u2 < e3.length; u2 += 16) {
              var s2 = n2, a2 = r2, f2 = o2, l2 = i2, n2 = c(n2, r2, o2, i2, e3[u2 + 0], 7, -680876936), i2 = c(i2, n2, r2, o2, e3[u2 + 1], 12, -389564586), o2 = c(o2, i2, n2, r2, e3[u2 + 2], 17, 606105819), r2 = c(r2, o2, i2, n2, e3[u2 + 3], 22, -1044525330);
              n2 = c(n2, r2, o2, i2, e3[u2 + 4], 7, -176418897), i2 = c(i2, n2, r2, o2, e3[u2 + 5], 12, 1200080426), o2 = c(o2, i2, n2, r2, e3[u2 + 6], 17, -1473231341), r2 = c(r2, o2, i2, n2, e3[u2 + 7], 22, -45705983), n2 = c(n2, r2, o2, i2, e3[u2 + 8], 7, 1770035416), i2 = c(i2, n2, r2, o2, e3[u2 + 9], 12, -1958414417), o2 = c(o2, i2, n2, r2, e3[u2 + 10], 17, -42063), r2 = c(r2, o2, i2, n2, e3[u2 + 11], 22, -1990404162), n2 = c(n2, r2, o2, i2, e3[u2 + 12], 7, 1804603682), i2 = c(i2, n2, r2, o2, e3[u2 + 13], 12, -40341101), o2 = c(o2, i2, n2, r2, e3[u2 + 14], 17, -1502002290), n2 = d(n2, r2 = c(r2, o2, i2, n2, e3[u2 + 15], 22, 1236535329), o2, i2, e3[u2 + 1], 5, -165796510), i2 = d(i2, n2, r2, o2, e3[u2 + 6], 9, -1069501632), o2 = d(o2, i2, n2, r2, e3[u2 + 11], 14, 643717713), r2 = d(r2, o2, i2, n2, e3[u2 + 0], 20, -373897302), n2 = d(n2, r2, o2, i2, e3[u2 + 5], 5, -701558691), i2 = d(i2, n2, r2, o2, e3[u2 + 10], 9, 38016083), o2 = d(o2, i2, n2, r2, e3[u2 + 15], 14, -660478335), r2 = d(r2, o2, i2, n2, e3[u2 + 4], 20, -405537848), n2 = d(n2, r2, o2, i2, e3[u2 + 9], 5, 568446438), i2 = d(i2, n2, r2, o2, e3[u2 + 14], 9, -1019803690), o2 = d(o2, i2, n2, r2, e3[u2 + 3], 14, -187363961), r2 = d(r2, o2, i2, n2, e3[u2 + 8], 20, 1163531501), n2 = d(n2, r2, o2, i2, e3[u2 + 13], 5, -1444681467), i2 = d(i2, n2, r2, o2, e3[u2 + 2], 9, -51403784), o2 = d(o2, i2, n2, r2, e3[u2 + 7], 14, 1735328473), n2 = h(n2, r2 = d(r2, o2, i2, n2, e3[u2 + 12], 20, -1926607734), o2, i2, e3[u2 + 5], 4, -378558), i2 = h(i2, n2, r2, o2, e3[u2 + 8], 11, -2022574463), o2 = h(o2, i2, n2, r2, e3[u2 + 11], 16, 1839030562), r2 = h(r2, o2, i2, n2, e3[u2 + 14], 23, -35309556), n2 = h(n2, r2, o2, i2, e3[u2 + 1], 4, -1530992060), i2 = h(i2, n2, r2, o2, e3[u2 + 4], 11, 1272893353), o2 = h(o2, i2, n2, r2, e3[u2 + 7], 16, -155497632), r2 = h(r2, o2, i2, n2, e3[u2 + 10], 23, -1094730640), n2 = h(n2, r2, o2, i2, e3[u2 + 13], 4, 681279174), i2 = h(i2, n2, r2, o2, e3[u2 + 0], 11, -358537222), o2 = h(o2, i2, n2, r2, e3[u2 + 3], 16, -722521979), r2 = h(r2, o2, i2, n2, e3[u2 + 6], 23, 76029189), n2 = h(n2, r2, o2, i2, e3[u2 + 9], 4, -640364487), i2 = h(i2, n2, r2, o2, e3[u2 + 12], 11, -421815835), o2 = h(o2, i2, n2, r2, e3[u2 + 15], 16, 530742520), n2 = p(n2, r2 = h(r2, o2, i2, n2, e3[u2 + 2], 23, -995338651), o2, i2, e3[u2 + 0], 6, -198630844), i2 = p(i2, n2, r2, o2, e3[u2 + 7], 10, 1126891415), o2 = p(o2, i2, n2, r2, e3[u2 + 14], 15, -1416354905), r2 = p(r2, o2, i2, n2, e3[u2 + 5], 21, -57434055), n2 = p(n2, r2, o2, i2, e3[u2 + 12], 6, 1700485571), i2 = p(i2, n2, r2, o2, e3[u2 + 3], 10, -1894986606), o2 = p(o2, i2, n2, r2, e3[u2 + 10], 15, -1051523), r2 = p(r2, o2, i2, n2, e3[u2 + 1], 21, -2054922799), n2 = p(n2, r2, o2, i2, e3[u2 + 8], 6, 1873313359), i2 = p(i2, n2, r2, o2, e3[u2 + 15], 10, -30611744), o2 = p(o2, i2, n2, r2, e3[u2 + 6], 15, -1560198380), r2 = p(r2, o2, i2, n2, e3[u2 + 13], 21, 1309151649), n2 = p(n2, r2, o2, i2, e3[u2 + 4], 6, -145523070), i2 = p(i2, n2, r2, o2, e3[u2 + 11], 10, -1120210379), o2 = p(o2, i2, n2, r2, e3[u2 + 2], 15, 718787259), r2 = p(r2, o2, i2, n2, e3[u2 + 9], 21, -343485551), n2 = g(n2, s2), r2 = g(r2, a2), o2 = g(o2, f2), i2 = g(i2, l2);
            }
            return Array(n2, r2, o2, i2);
          }
          function s(e3, t3, n2, r2, o2, i2) {
            return g((t3 = g(g(t3, e3), g(r2, i2))) << o2 | t3 >>> 32 - o2, n2);
          }
          function c(e3, t3, n2, r2, o2, i2, u2) {
            return s(t3 & n2 | ~t3 & r2, e3, t3, o2, i2, u2);
          }
          function d(e3, t3, n2, r2, o2, i2, u2) {
            return s(t3 & r2 | n2 & ~r2, e3, t3, o2, i2, u2);
          }
          function h(e3, t3, n2, r2, o2, i2, u2) {
            return s(t3 ^ n2 ^ r2, e3, t3, o2, i2, u2);
          }
          function p(e3, t3, n2, r2, o2, i2, u2) {
            return s(n2 ^ (t3 | ~r2), e3, t3, o2, i2, u2);
          }
          function g(e3, t3) {
            var n2 = (65535 & e3) + (65535 & t3);
            return (e3 >> 16) + (t3 >> 16) + (n2 >> 16) << 16 | 65535 & n2;
          }
          b.exports = function(e3) {
            return t2.hash(e3, n, 16);
          };
        }).call(this, w("lYpoI2"), "undefined" != typeof self ? self : "undefined" != typeof window ? window : {}, w("buffer").Buffer, arguments[3], arguments[4], arguments[5], arguments[6], "/node_modules/gulp-browserify/node_modules/crypto-browserify/md5.js", "/node_modules/gulp-browserify/node_modules/crypto-browserify");
      }, { "./helpers": 4, buffer: 3, lYpoI2: 11 }], 7: [function(e, l, t2) {
        !(function(e2, t3, n, r, o, i, u, s, f) {
          var a;
          l.exports = a || function(e3) {
            for (var t4, n2 = new Array(e3), r2 = 0; r2 < e3; r2++)
              0 == (3 & r2) && (t4 = 4294967296 * Math.random()), n2[r2] = t4 >>> ((3 & r2) << 3) & 255;
            return n2;
          };
        }).call(this, e("lYpoI2"), "undefined" != typeof self ? self : "undefined" != typeof window ? window : {}, e("buffer").Buffer, arguments[3], arguments[4], arguments[5], arguments[6], "/node_modules/gulp-browserify/node_modules/crypto-browserify/rng.js", "/node_modules/gulp-browserify/node_modules/crypto-browserify");
      }, { buffer: 3, lYpoI2: 11 }], 8: [function(c, d, e) {
        !(function(e2, t2, n, r, o, s, a, f, l) {
          var i = c("./helpers");
          function u(l2, c2) {
            l2[c2 >> 5] |= 128 << 24 - c2 % 32, l2[15 + (c2 + 64 >> 9 << 4)] = c2;
            for (var e3, t3, n2, r2 = Array(80), o2 = 1732584193, i2 = -271733879, u2 = -1732584194, s2 = 271733878, d2 = -1009589776, h = 0; h < l2.length; h += 16) {
              for (var p = o2, g = i2, y = u2, w = s2, b = d2, a2 = 0; a2 < 80; a2++) {
                r2[a2] = a2 < 16 ? l2[h + a2] : v(r2[a2 - 3] ^ r2[a2 - 8] ^ r2[a2 - 14] ^ r2[a2 - 16], 1);
                var f2 = m(m(v(o2, 5), (f2 = i2, t3 = u2, n2 = s2, (e3 = a2) < 20 ? f2 & t3 | ~f2 & n2 : !(e3 < 40) && e3 < 60 ? f2 & t3 | f2 & n2 | t3 & n2 : f2 ^ t3 ^ n2)), m(m(d2, r2[a2]), (e3 = a2) < 20 ? 1518500249 : e3 < 40 ? 1859775393 : e3 < 60 ? -1894007588 : -899497514)), d2 = s2, s2 = u2, u2 = v(i2, 30), i2 = o2, o2 = f2;
              }
              o2 = m(o2, p), i2 = m(i2, g), u2 = m(u2, y), s2 = m(s2, w), d2 = m(d2, b);
            }
            return Array(o2, i2, u2, s2, d2);
          }
          function m(e3, t3) {
            var n2 = (65535 & e3) + (65535 & t3);
            return (e3 >> 16) + (t3 >> 16) + (n2 >> 16) << 16 | 65535 & n2;
          }
          function v(e3, t3) {
            return e3 << t3 | e3 >>> 32 - t3;
          }
          d.exports = function(e3) {
            return i.hash(e3, u, 20, true);
          };
        }).call(this, c("lYpoI2"), "undefined" != typeof self ? self : "undefined" != typeof window ? window : {}, c("buffer").Buffer, arguments[3], arguments[4], arguments[5], arguments[6], "/node_modules/gulp-browserify/node_modules/crypto-browserify/sha.js", "/node_modules/gulp-browserify/node_modules/crypto-browserify");
      }, { "./helpers": 4, buffer: 3, lYpoI2: 11 }], 9: [function(c, d, e) {
        !(function(e2, t2, n, r, u, s, a, f, l) {
          function b(e3, t3) {
            var n2 = (65535 & e3) + (65535 & t3);
            return (e3 >> 16) + (t3 >> 16) + (n2 >> 16) << 16 | 65535 & n2;
          }
          function o(e3, l2) {
            var c2, d2 = new Array(1116352408, 1899447441, 3049323471, 3921009573, 961987163, 1508970993, 2453635748, 2870763221, 3624381080, 310598401, 607225278, 1426881987, 1925078388, 2162078206, 2614888103, 3248222580, 3835390401, 4022224774, 264347078, 604807628, 770255983, 1249150122, 1555081692, 1996064986, 2554220882, 2821834349, 2952996808, 3210313671, 3336571891, 3584528711, 113926993, 338241895, 666307205, 773529912, 1294757372, 1396182291, 1695183700, 1986661051, 2177026350, 2456956037, 2730485921, 2820302411, 3259730800, 3345764771, 3516065817, 3600352804, 4094571909, 275423344, 430227734, 506948616, 659060556, 883997877, 958139571, 1322822218, 1537002063, 1747873779, 1955562222, 2024104815, 2227730452, 2361852424, 2428436474, 2756734187, 3204031479, 3329325298), t3 = new Array(1779033703, 3144134277, 1013904242, 2773480762, 1359893119, 2600822924, 528734635, 1541459225), n2 = new Array(64);
            e3[l2 >> 5] |= 128 << 24 - l2 % 32, e3[15 + (l2 + 64 >> 9 << 4)] = l2;
            for (var r2, o2, h = 0; h < e3.length; h += 16) {
              for (var i2 = t3[0], u2 = t3[1], s2 = t3[2], p = t3[3], a2 = t3[4], g = t3[5], y = t3[6], w = t3[7], f2 = 0; f2 < 64; f2++)
                n2[f2] = f2 < 16 ? e3[f2 + h] : b(b(b((o2 = n2[f2 - 2], m(o2, 17) ^ m(o2, 19) ^ v(o2, 10)), n2[f2 - 7]), (o2 = n2[f2 - 15], m(o2, 7) ^ m(o2, 18) ^ v(o2, 3))), n2[f2 - 16]), c2 = b(b(b(b(w, m(o2 = a2, 6) ^ m(o2, 11) ^ m(o2, 25)), a2 & g ^ ~a2 & y), d2[f2]), n2[f2]), r2 = b(m(r2 = i2, 2) ^ m(r2, 13) ^ m(r2, 22), i2 & u2 ^ i2 & s2 ^ u2 & s2), w = y, y = g, g = a2, a2 = b(p, c2), p = s2, s2 = u2, u2 = i2, i2 = b(c2, r2);
              t3[0] = b(i2, t3[0]), t3[1] = b(u2, t3[1]), t3[2] = b(s2, t3[2]), t3[3] = b(p, t3[3]), t3[4] = b(a2, t3[4]), t3[5] = b(g, t3[5]), t3[6] = b(y, t3[6]), t3[7] = b(w, t3[7]);
            }
            return t3;
          }
          var i = c("./helpers"), m = function(e3, t3) {
            return e3 >>> t3 | e3 << 32 - t3;
          }, v = function(e3, t3) {
            return e3 >>> t3;
          };
          d.exports = function(e3) {
            return i.hash(e3, o, 32, true);
          };
        }).call(this, c("lYpoI2"), "undefined" != typeof self ? self : "undefined" != typeof window ? window : {}, c("buffer").Buffer, arguments[3], arguments[4], arguments[5], arguments[6], "/node_modules/gulp-browserify/node_modules/crypto-browserify/sha256.js", "/node_modules/gulp-browserify/node_modules/crypto-browserify");
      }, { "./helpers": 4, buffer: 3, lYpoI2: 11 }], 10: [function(e, t2, f) {
        !(function(e2, t3, n, r, o, i, u, s, a) {
          f.read = function(e3, t4, n2, r2, o2) {
            var i2, u2, l = 8 * o2 - r2 - 1, c = (1 << l) - 1, d = c >> 1, s2 = -7, a2 = n2 ? o2 - 1 : 0, f2 = n2 ? -1 : 1, o2 = e3[t4 + a2];
            for (a2 += f2, i2 = o2 & (1 << -s2) - 1, o2 >>= -s2, s2 += l; 0 < s2; i2 = 256 * i2 + e3[t4 + a2], a2 += f2, s2 -= 8)
              ;
            for (u2 = i2 & (1 << -s2) - 1, i2 >>= -s2, s2 += r2; 0 < s2; u2 = 256 * u2 + e3[t4 + a2], a2 += f2, s2 -= 8)
              ;
            if (0 === i2)
              i2 = 1 - d;
            else {
              if (i2 === c)
                return u2 ? NaN : 1 / 0 * (o2 ? -1 : 1);
              u2 += Math.pow(2, r2), i2 -= d;
            }
            return (o2 ? -1 : 1) * u2 * Math.pow(2, i2 - r2);
          }, f.write = function(e3, t4, l, n2, r2, c) {
            var o2, i2, u2 = 8 * c - r2 - 1, s2 = (1 << u2) - 1, a2 = s2 >> 1, d = 23 === r2 ? Math.pow(2, -24) - Math.pow(2, -77) : 0, f2 = n2 ? 0 : c - 1, h = n2 ? 1 : -1, c = t4 < 0 || 0 === t4 && 1 / t4 < 0 ? 1 : 0;
            for (t4 = Math.abs(t4), isNaN(t4) || t4 === 1 / 0 ? (i2 = isNaN(t4) ? 1 : 0, o2 = s2) : (o2 = Math.floor(Math.log(t4) / Math.LN2), t4 * (n2 = Math.pow(2, -o2)) < 1 && (o2--, n2 *= 2), 2 <= (t4 += 1 <= o2 + a2 ? d / n2 : d * Math.pow(2, 1 - a2)) * n2 && (o2++, n2 /= 2), s2 <= o2 + a2 ? (i2 = 0, o2 = s2) : 1 <= o2 + a2 ? (i2 = (t4 * n2 - 1) * Math.pow(2, r2), o2 += a2) : (i2 = t4 * Math.pow(2, a2 - 1) * Math.pow(2, r2), o2 = 0)); 8 <= r2; e3[l + f2] = 255 & i2, f2 += h, i2 /= 256, r2 -= 8)
              ;
            for (o2 = o2 << r2 | i2, u2 += r2; 0 < u2; e3[l + f2] = 255 & o2, f2 += h, o2 /= 256, u2 -= 8)
              ;
            e3[l + f2 - h] |= 128 * c;
          };
        }).call(this, e("lYpoI2"), "undefined" != typeof self ? self : "undefined" != typeof window ? window : {}, e("buffer").Buffer, arguments[3], arguments[4], arguments[5], arguments[6], "/node_modules/gulp-browserify/node_modules/ieee754/index.js", "/node_modules/gulp-browserify/node_modules/ieee754");
      }, { buffer: 3, lYpoI2: 11 }], 11: [function(e, h, t2) {
        !(function(e2, t3, n, r, o, f, l, c, d) {
          var i, u, s;
          function a() {
          }
          (e2 = h.exports = {}).nextTick = (u = "undefined" != typeof window && window.setImmediate, s = "undefined" != typeof window && window.postMessage && window.addEventListener, u ? function(e3) {
            return window.setImmediate(e3);
          } : s ? (i = [], window.addEventListener("message", function(e3) {
            var t4 = e3.source;
            t4 !== window && null !== t4 || "process-tick" !== e3.data || (e3.stopPropagation(), 0 < i.length && i.shift()());
          }, true), function(e3) {
            i.push(e3), window.postMessage("process-tick", "*");
          }) : function(e3) {
            setTimeout(e3, 0);
          }), e2.title = "browser", e2.browser = true, e2.env = {}, e2.argv = [], e2.on = a, e2.addListener = a, e2.once = a, e2.off = a, e2.removeListener = a, e2.removeAllListeners = a, e2.emit = a, e2.binding = function(e3) {
            throw new Error("process.binding is not supported");
          }, e2.cwd = function() {
            return "/";
          }, e2.chdir = function(e3) {
            throw new Error("process.chdir is not supported");
          };
        }).call(this, e("lYpoI2"), "undefined" != typeof self ? self : "undefined" != typeof window ? window : {}, e("buffer").Buffer, arguments[3], arguments[4], arguments[5], arguments[6], "/node_modules/gulp-browserify/node_modules/process/browser.js", "/node_modules/gulp-browserify/node_modules/process");
      }, { buffer: 3, lYpoI2: 11 }] }, {}, [1])(1);
    });
  }
});

// node_modules/tailwindcss/lib/util/hashConfig.js
var require_hashConfig = __commonJS({
  "node_modules/tailwindcss/lib/util/hashConfig.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    Object.defineProperty(exports, "default", {
      enumerable: true,
      get: function() {
        return hashConfig;
      }
    });
    var _objecthash = _interop_require_default(require_object_hash());
    function _interop_require_default(obj) {
      return obj && obj.__esModule ? obj : {
        default: obj
      };
    }
    function hashConfig(config) {
      return (0, _objecthash.default)(config, {
        ignoreUnknown: true
      });
    }
  }
});

// node_modules/tailwindcss/lib/util/negateValue.js
var require_negateValue = __commonJS({
  "node_modules/tailwindcss/lib/util/negateValue.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    Object.defineProperty(exports, "default", {
      enumerable: true,
      get: function() {
        return negateValue;
      }
    });
    function negateValue(value2) {
      value2 = `${value2}`;
      if (value2 === "0") {
        return "0";
      }
      if (/^[+-]?(\d+|\d*\.\d+)(e[+-]?\d+)?(%|\w+)?$/.test(value2)) {
        return value2.replace(/^[+-]?/, (sign) => sign === "-" ? "" : "-");
      }
      let numericFunctions = [
        "var",
        "calc",
        "min",
        "max",
        "clamp"
      ];
      for (const fn of numericFunctions) {
        if (value2.includes(`${fn}(`)) {
          return `calc(${value2} * -1)`;
        }
      }
    }
  }
});

// node_modules/tailwindcss/lib/corePluginList.js
var require_corePluginList = __commonJS({
  "node_modules/tailwindcss/lib/corePluginList.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    Object.defineProperty(exports, "default", {
      enumerable: true,
      get: function() {
        return _default;
      }
    });
    var _default = [
      "preflight",
      "container",
      "accessibility",
      "pointerEvents",
      "visibility",
      "position",
      "inset",
      "isolation",
      "zIndex",
      "order",
      "gridColumn",
      "gridColumnStart",
      "gridColumnEnd",
      "gridRow",
      "gridRowStart",
      "gridRowEnd",
      "float",
      "clear",
      "margin",
      "boxSizing",
      "lineClamp",
      "display",
      "aspectRatio",
      "size",
      "height",
      "maxHeight",
      "minHeight",
      "width",
      "minWidth",
      "maxWidth",
      "flex",
      "flexShrink",
      "flexGrow",
      "flexBasis",
      "tableLayout",
      "captionSide",
      "borderCollapse",
      "borderSpacing",
      "transformOrigin",
      "translate",
      "rotate",
      "skew",
      "scale",
      "transform",
      "animation",
      "cursor",
      "touchAction",
      "userSelect",
      "resize",
      "scrollSnapType",
      "scrollSnapAlign",
      "scrollSnapStop",
      "scrollMargin",
      "scrollPadding",
      "listStylePosition",
      "listStyleType",
      "listStyleImage",
      "appearance",
      "columns",
      "breakBefore",
      "breakInside",
      "breakAfter",
      "gridAutoColumns",
      "gridAutoFlow",
      "gridAutoRows",
      "gridTemplateColumns",
      "gridTemplateRows",
      "flexDirection",
      "flexWrap",
      "placeContent",
      "placeItems",
      "alignContent",
      "alignItems",
      "justifyContent",
      "justifyItems",
      "gap",
      "space",
      "divideWidth",
      "divideStyle",
      "divideColor",
      "divideOpacity",
      "placeSelf",
      "alignSelf",
      "justifySelf",
      "overflow",
      "overscrollBehavior",
      "scrollBehavior",
      "textOverflow",
      "hyphens",
      "whitespace",
      "textWrap",
      "wordBreak",
      "borderRadius",
      "borderWidth",
      "borderStyle",
      "borderColor",
      "borderOpacity",
      "backgroundColor",
      "backgroundOpacity",
      "backgroundImage",
      "gradientColorStops",
      "boxDecorationBreak",
      "backgroundSize",
      "backgroundAttachment",
      "backgroundClip",
      "backgroundPosition",
      "backgroundRepeat",
      "backgroundOrigin",
      "fill",
      "stroke",
      "strokeWidth",
      "objectFit",
      "objectPosition",
      "padding",
      "textAlign",
      "textIndent",
      "verticalAlign",
      "fontFamily",
      "fontSize",
      "fontWeight",
      "textTransform",
      "fontStyle",
      "fontVariantNumeric",
      "lineHeight",
      "letterSpacing",
      "textColor",
      "textOpacity",
      "textDecoration",
      "textDecorationColor",
      "textDecorationStyle",
      "textDecorationThickness",
      "textUnderlineOffset",
      "fontSmoothing",
      "placeholderColor",
      "placeholderOpacity",
      "caretColor",
      "accentColor",
      "opacity",
      "backgroundBlendMode",
      "mixBlendMode",
      "boxShadow",
      "boxShadowColor",
      "outlineStyle",
      "outlineWidth",
      "outlineOffset",
      "outlineColor",
      "ringWidth",
      "ringColor",
      "ringOpacity",
      "ringOffsetWidth",
      "ringOffsetColor",
      "blur",
      "brightness",
      "contrast",
      "dropShadow",
      "grayscale",
      "hueRotate",
      "invert",
      "saturate",
      "sepia",
      "filter",
      "backdropBlur",
      "backdropBrightness",
      "backdropContrast",
      "backdropGrayscale",
      "backdropHueRotate",
      "backdropInvert",
      "backdropOpacity",
      "backdropSaturate",
      "backdropSepia",
      "backdropFilter",
      "transitionProperty",
      "transitionDelay",
      "transitionDuration",
      "transitionTimingFunction",
      "willChange",
      "contain",
      "content",
      "forcedColorAdjust"
    ];
  }
});

// node_modules/tailwindcss/lib/util/configurePlugins.js
var require_configurePlugins = __commonJS({
  "node_modules/tailwindcss/lib/util/configurePlugins.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    Object.defineProperty(exports, "default", {
      enumerable: true,
      get: function() {
        return _default;
      }
    });
    function _default(pluginConfig, plugins) {
      if (pluginConfig === void 0) {
        return plugins;
      }
      const pluginNames = Array.isArray(pluginConfig) ? pluginConfig : [
        ...new Set(plugins.filter((pluginName) => {
          return pluginConfig !== false && pluginConfig[pluginName] !== false;
        }).concat(Object.keys(pluginConfig).filter((pluginName) => {
          return pluginConfig[pluginName] !== false;
        })))
      ];
      return pluginNames;
    }
  }
});

// node_modules/tailwindcss/lib/util/log.js
var require_log = __commonJS({
  "node_modules/tailwindcss/lib/util/log.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    function _export(target, all) {
      for (var name in all)
        Object.defineProperty(target, name, {
          enumerable: true,
          get: all[name]
        });
    }
    _export(exports, {
      dim: function() {
        return dim;
      },
      default: function() {
        return _default;
      }
    });
    var _picocolors = _interop_require_default(require_picocolors_browser());
    function _interop_require_default(obj) {
      return obj && obj.__esModule ? obj : {
        default: obj
      };
    }
    var alreadyShown = /* @__PURE__ */ new Set();
    function log(type, messages, key) {
      if (typeof process !== "undefined" && process.env.JEST_WORKER_ID)
        return;
      if (key && alreadyShown.has(key))
        return;
      if (key)
        alreadyShown.add(key);
      console.warn("");
      messages.forEach((message) => console.warn(type, "-", message));
    }
    function dim(input2) {
      return _picocolors.default.dim(input2);
    }
    var _default = {
      info(key, messages) {
        log(_picocolors.default.bold(_picocolors.default.cyan("info")), ...Array.isArray(key) ? [
          key
        ] : [
          messages,
          key
        ]);
      },
      warn(key, messages) {
        log(_picocolors.default.bold(_picocolors.default.yellow("warn")), ...Array.isArray(key) ? [
          key
        ] : [
          messages,
          key
        ]);
      },
      risk(key, messages) {
        log(_picocolors.default.bold(_picocolors.default.magenta("risk")), ...Array.isArray(key) ? [
          key
        ] : [
          messages,
          key
        ]);
      }
    };
  }
});

// node_modules/tailwindcss/lib/public/colors.js
var require_colors = __commonJS({
  "node_modules/tailwindcss/lib/public/colors.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    Object.defineProperty(exports, "default", {
      enumerable: true,
      get: function() {
        return _default;
      }
    });
    var _log = _interop_require_default(require_log());
    function _interop_require_default(obj) {
      return obj && obj.__esModule ? obj : {
        default: obj
      };
    }
    function warn({ version, from, to }) {
      _log.default.warn(`${from}-color-renamed`, [
        `As of Tailwind CSS ${version}, \`${from}\` has been renamed to \`${to}\`.`,
        "Update your configuration file to silence this warning."
      ]);
    }
    var _default = {
      inherit: "inherit",
      current: "currentColor",
      transparent: "transparent",
      black: "#000",
      white: "#fff",
      slate: {
        50: "#f8fafc",
        100: "#f1f5f9",
        200: "#e2e8f0",
        300: "#cbd5e1",
        400: "#94a3b8",
        500: "#64748b",
        600: "#475569",
        700: "#334155",
        800: "#1e293b",
        900: "#0f172a",
        950: "#020617"
      },
      gray: {
        50: "#f9fafb",
        100: "#f3f4f6",
        200: "#e5e7eb",
        300: "#d1d5db",
        400: "#9ca3af",
        500: "#6b7280",
        600: "#4b5563",
        700: "#374151",
        800: "#1f2937",
        900: "#111827",
        950: "#030712"
      },
      zinc: {
        50: "#fafafa",
        100: "#f4f4f5",
        200: "#e4e4e7",
        300: "#d4d4d8",
        400: "#a1a1aa",
        500: "#71717a",
        600: "#52525b",
        700: "#3f3f46",
        800: "#27272a",
        900: "#18181b",
        950: "#09090b"
      },
      neutral: {
        50: "#fafafa",
        100: "#f5f5f5",
        200: "#e5e5e5",
        300: "#d4d4d4",
        400: "#a3a3a3",
        500: "#737373",
        600: "#525252",
        700: "#404040",
        800: "#262626",
        900: "#171717",
        950: "#0a0a0a"
      },
      stone: {
        50: "#fafaf9",
        100: "#f5f5f4",
        200: "#e7e5e4",
        300: "#d6d3d1",
        400: "#a8a29e",
        500: "#78716c",
        600: "#57534e",
        700: "#44403c",
        800: "#292524",
        900: "#1c1917",
        950: "#0c0a09"
      },
      red: {
        50: "#fef2f2",
        100: "#fee2e2",
        200: "#fecaca",
        300: "#fca5a5",
        400: "#f87171",
        500: "#ef4444",
        600: "#dc2626",
        700: "#b91c1c",
        800: "#991b1b",
        900: "#7f1d1d",
        950: "#450a0a"
      },
      orange: {
        50: "#fff7ed",
        100: "#ffedd5",
        200: "#fed7aa",
        300: "#fdba74",
        400: "#fb923c",
        500: "#f97316",
        600: "#ea580c",
        700: "#c2410c",
        800: "#9a3412",
        900: "#7c2d12",
        950: "#431407"
      },
      amber: {
        50: "#fffbeb",
        100: "#fef3c7",
        200: "#fde68a",
        300: "#fcd34d",
        400: "#fbbf24",
        500: "#f59e0b",
        600: "#d97706",
        700: "#b45309",
        800: "#92400e",
        900: "#78350f",
        950: "#451a03"
      },
      yellow: {
        50: "#fefce8",
        100: "#fef9c3",
        200: "#fef08a",
        300: "#fde047",
        400: "#facc15",
        500: "#eab308",
        600: "#ca8a04",
        700: "#a16207",
        800: "#854d0e",
        900: "#713f12",
        950: "#422006"
      },
      lime: {
        50: "#f7fee7",
        100: "#ecfccb",
        200: "#d9f99d",
        300: "#bef264",
        400: "#a3e635",
        500: "#84cc16",
        600: "#65a30d",
        700: "#4d7c0f",
        800: "#3f6212",
        900: "#365314",
        950: "#1a2e05"
      },
      green: {
        50: "#f0fdf4",
        100: "#dcfce7",
        200: "#bbf7d0",
        300: "#86efac",
        400: "#4ade80",
        500: "#22c55e",
        600: "#16a34a",
        700: "#15803d",
        800: "#166534",
        900: "#14532d",
        950: "#052e16"
      },
      emerald: {
        50: "#ecfdf5",
        100: "#d1fae5",
        200: "#a7f3d0",
        300: "#6ee7b7",
        400: "#34d399",
        500: "#10b981",
        600: "#059669",
        700: "#047857",
        800: "#065f46",
        900: "#064e3b",
        950: "#022c22"
      },
      teal: {
        50: "#f0fdfa",
        100: "#ccfbf1",
        200: "#99f6e4",
        300: "#5eead4",
        400: "#2dd4bf",
        500: "#14b8a6",
        600: "#0d9488",
        700: "#0f766e",
        800: "#115e59",
        900: "#134e4a",
        950: "#042f2e"
      },
      cyan: {
        50: "#ecfeff",
        100: "#cffafe",
        200: "#a5f3fc",
        300: "#67e8f9",
        400: "#22d3ee",
        500: "#06b6d4",
        600: "#0891b2",
        700: "#0e7490",
        800: "#155e75",
        900: "#164e63",
        950: "#083344"
      },
      sky: {
        50: "#f0f9ff",
        100: "#e0f2fe",
        200: "#bae6fd",
        300: "#7dd3fc",
        400: "#38bdf8",
        500: "#0ea5e9",
        600: "#0284c7",
        700: "#0369a1",
        800: "#075985",
        900: "#0c4a6e",
        950: "#082f49"
      },
      blue: {
        50: "#eff6ff",
        100: "#dbeafe",
        200: "#bfdbfe",
        300: "#93c5fd",
        400: "#60a5fa",
        500: "#3b82f6",
        600: "#2563eb",
        700: "#1d4ed8",
        800: "#1e40af",
        900: "#1e3a8a",
        950: "#172554"
      },
      indigo: {
        50: "#eef2ff",
        100: "#e0e7ff",
        200: "#c7d2fe",
        300: "#a5b4fc",
        400: "#818cf8",
        500: "#6366f1",
        600: "#4f46e5",
        700: "#4338ca",
        800: "#3730a3",
        900: "#312e81",
        950: "#1e1b4b"
      },
      violet: {
        50: "#f5f3ff",
        100: "#ede9fe",
        200: "#ddd6fe",
        300: "#c4b5fd",
        400: "#a78bfa",
        500: "#8b5cf6",
        600: "#7c3aed",
        700: "#6d28d9",
        800: "#5b21b6",
        900: "#4c1d95",
        950: "#2e1065"
      },
      purple: {
        50: "#faf5ff",
        100: "#f3e8ff",
        200: "#e9d5ff",
        300: "#d8b4fe",
        400: "#c084fc",
        500: "#a855f7",
        600: "#9333ea",
        700: "#7e22ce",
        800: "#6b21a8",
        900: "#581c87",
        950: "#3b0764"
      },
      fuchsia: {
        50: "#fdf4ff",
        100: "#fae8ff",
        200: "#f5d0fe",
        300: "#f0abfc",
        400: "#e879f9",
        500: "#d946ef",
        600: "#c026d3",
        700: "#a21caf",
        800: "#86198f",
        900: "#701a75",
        950: "#4a044e"
      },
      pink: {
        50: "#fdf2f8",
        100: "#fce7f3",
        200: "#fbcfe8",
        300: "#f9a8d4",
        400: "#f472b6",
        500: "#ec4899",
        600: "#db2777",
        700: "#be185d",
        800: "#9d174d",
        900: "#831843",
        950: "#500724"
      },
      rose: {
        50: "#fff1f2",
        100: "#ffe4e6",
        200: "#fecdd3",
        300: "#fda4af",
        400: "#fb7185",
        500: "#f43f5e",
        600: "#e11d48",
        700: "#be123c",
        800: "#9f1239",
        900: "#881337",
        950: "#4c0519"
      },
      get lightBlue() {
        warn({
          version: "v2.2",
          from: "lightBlue",
          to: "sky"
        });
        return this.sky;
      },
      get warmGray() {
        warn({
          version: "v3.0",
          from: "warmGray",
          to: "stone"
        });
        return this.stone;
      },
      get trueGray() {
        warn({
          version: "v3.0",
          from: "trueGray",
          to: "neutral"
        });
        return this.neutral;
      },
      get coolGray() {
        warn({
          version: "v3.0",
          from: "coolGray",
          to: "gray"
        });
        return this.gray;
      },
      get blueGray() {
        warn({
          version: "v3.0",
          from: "blueGray",
          to: "slate"
        });
        return this.slate;
      }
    };
  }
});

// node_modules/tailwindcss/lib/util/defaults.js
var require_defaults = __commonJS({
  "node_modules/tailwindcss/lib/util/defaults.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    Object.defineProperty(exports, "defaults", {
      enumerable: true,
      get: function() {
        return defaults;
      }
    });
    function defaults(target, ...sources) {
      for (let source of sources) {
        for (let k in source) {
          var _target_hasOwnProperty;
          if (!(target === null || target === void 0 ? void 0 : (_target_hasOwnProperty = target.hasOwnProperty) === null || _target_hasOwnProperty === void 0 ? void 0 : _target_hasOwnProperty.call(target, k))) {
            target[k] = source[k];
          }
        }
        for (let k of Object.getOwnPropertySymbols(source)) {
          var _target_hasOwnProperty1;
          if (!(target === null || target === void 0 ? void 0 : (_target_hasOwnProperty1 = target.hasOwnProperty) === null || _target_hasOwnProperty1 === void 0 ? void 0 : _target_hasOwnProperty1.call(target, k))) {
            target[k] = source[k];
          }
        }
      }
      return target;
    }
  }
});

// node_modules/tailwindcss/lib/util/toPath.js
var require_toPath = __commonJS({
  "node_modules/tailwindcss/lib/util/toPath.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    Object.defineProperty(exports, "toPath", {
      enumerable: true,
      get: function() {
        return toPath;
      }
    });
    function toPath(path) {
      if (Array.isArray(path))
        return path;
      let openBrackets = path.split("[").length - 1;
      let closedBrackets = path.split("]").length - 1;
      if (openBrackets !== closedBrackets) {
        throw new Error(`Path is invalid. Has unbalanced brackets: ${path}`);
      }
      return path.split(/\.(?![^\[]*\])|[\[\]]/g).filter(Boolean);
    }
  }
});

// node_modules/tailwindcss/lib/featureFlags.js
var require_featureFlags = __commonJS({
  "node_modules/tailwindcss/lib/featureFlags.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    function _export(target, all) {
      for (var name in all)
        Object.defineProperty(target, name, {
          enumerable: true,
          get: all[name]
        });
    }
    _export(exports, {
      flagEnabled: function() {
        return flagEnabled;
      },
      issueFlagNotices: function() {
        return issueFlagNotices;
      },
      default: function() {
        return _default;
      }
    });
    var _picocolors = _interop_require_default(require_picocolors_browser());
    var _log = _interop_require_default(require_log());
    function _interop_require_default(obj) {
      return obj && obj.__esModule ? obj : {
        default: obj
      };
    }
    var defaults = {
      optimizeUniversalDefaults: false,
      generalizedModifiers: true,
      disableColorOpacityUtilitiesByDefault: false,
      relativeContentPathsByDefault: false
    };
    var featureFlags = {
      future: [
        "hoverOnlyWhenSupported",
        "respectDefaultRingColorOpacity",
        "disableColorOpacityUtilitiesByDefault",
        "relativeContentPathsByDefault"
      ],
      experimental: [
        "optimizeUniversalDefaults",
        "generalizedModifiers"
      ]
    };
    function flagEnabled(config, flag) {
      if (featureFlags.future.includes(flag)) {
        var _config_future;
        var _config_future_flag, _ref;
        return config.future === "all" || ((_ref = (_config_future_flag = config === null || config === void 0 ? void 0 : (_config_future = config.future) === null || _config_future === void 0 ? void 0 : _config_future[flag]) !== null && _config_future_flag !== void 0 ? _config_future_flag : defaults[flag]) !== null && _ref !== void 0 ? _ref : false);
      }
      if (featureFlags.experimental.includes(flag)) {
        var _config_experimental;
        var _config_experimental_flag, _ref1;
        return config.experimental === "all" || ((_ref1 = (_config_experimental_flag = config === null || config === void 0 ? void 0 : (_config_experimental = config.experimental) === null || _config_experimental === void 0 ? void 0 : _config_experimental[flag]) !== null && _config_experimental_flag !== void 0 ? _config_experimental_flag : defaults[flag]) !== null && _ref1 !== void 0 ? _ref1 : false);
      }
      return false;
    }
    function experimentalFlagsEnabled(config) {
      if (config.experimental === "all") {
        return featureFlags.experimental;
      }
      var _config_experimental;
      return Object.keys((_config_experimental = config === null || config === void 0 ? void 0 : config.experimental) !== null && _config_experimental !== void 0 ? _config_experimental : {}).filter((flag) => featureFlags.experimental.includes(flag) && config.experimental[flag]);
    }
    function issueFlagNotices(config) {
      if (process.env.JEST_WORKER_ID !== void 0) {
        return;
      }
      if (experimentalFlagsEnabled(config).length > 0) {
        let changes = experimentalFlagsEnabled(config).map((s) => _picocolors.default.yellow(s)).join(", ");
        _log.default.warn("experimental-flags-enabled", [
          `You have enabled experimental features: ${changes}`,
          "Experimental features in Tailwind CSS are not covered by semver, may introduce breaking changes, and can change at any time."
        ]);
      }
    }
    var _default = featureFlags;
  }
});

// node_modules/tailwindcss/lib/util/normalizeConfig.js
var require_normalizeConfig = __commonJS({
  "node_modules/tailwindcss/lib/util/normalizeConfig.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    Object.defineProperty(exports, "normalizeConfig", {
      enumerable: true,
      get: function() {
        return normalizeConfig;
      }
    });
    var _featureFlags = require_featureFlags();
    var _log = _interop_require_wildcard(require_log());
    function _getRequireWildcardCache(nodeInterop) {
      if (typeof WeakMap !== "function")
        return null;
      var cacheBabelInterop = /* @__PURE__ */ new WeakMap();
      var cacheNodeInterop = /* @__PURE__ */ new WeakMap();
      return (_getRequireWildcardCache = function(nodeInterop2) {
        return nodeInterop2 ? cacheNodeInterop : cacheBabelInterop;
      })(nodeInterop);
    }
    function _interop_require_wildcard(obj, nodeInterop) {
      if (!nodeInterop && obj && obj.__esModule) {
        return obj;
      }
      if (obj === null || typeof obj !== "object" && typeof obj !== "function") {
        return {
          default: obj
        };
      }
      var cache = _getRequireWildcardCache(nodeInterop);
      if (cache && cache.has(obj)) {
        return cache.get(obj);
      }
      var newObj = {};
      var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;
      for (var key in obj) {
        if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) {
          var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;
          if (desc && (desc.get || desc.set)) {
            Object.defineProperty(newObj, key, desc);
          } else {
            newObj[key] = obj[key];
          }
        }
      }
      newObj.default = obj;
      if (cache) {
        cache.set(obj, newObj);
      }
      return newObj;
    }
    function normalizeConfig(config) {
      let valid = (() => {
        if (config.purge) {
          return false;
        }
        if (!config.content) {
          return false;
        }
        if (!Array.isArray(config.content) && !(typeof config.content === "object" && config.content !== null)) {
          return false;
        }
        if (Array.isArray(config.content)) {
          return config.content.every((path) => {
            if (typeof path === "string")
              return true;
            if (typeof (path === null || path === void 0 ? void 0 : path.raw) !== "string")
              return false;
            if ((path === null || path === void 0 ? void 0 : path.extension) && typeof (path === null || path === void 0 ? void 0 : path.extension) !== "string") {
              return false;
            }
            return true;
          });
        }
        if (typeof config.content === "object" && config.content !== null) {
          if (Object.keys(config.content).some((key) => ![
            "files",
            "relative",
            "extract",
            "transform"
          ].includes(key))) {
            return false;
          }
          if (Array.isArray(config.content.files)) {
            if (!config.content.files.every((path) => {
              if (typeof path === "string")
                return true;
              if (typeof (path === null || path === void 0 ? void 0 : path.raw) !== "string")
                return false;
              if ((path === null || path === void 0 ? void 0 : path.extension) && typeof (path === null || path === void 0 ? void 0 : path.extension) !== "string") {
                return false;
              }
              return true;
            })) {
              return false;
            }
            if (typeof config.content.extract === "object") {
              for (let value2 of Object.values(config.content.extract)) {
                if (typeof value2 !== "function") {
                  return false;
                }
              }
            } else if (!(config.content.extract === void 0 || typeof config.content.extract === "function")) {
              return false;
            }
            if (typeof config.content.transform === "object") {
              for (let value2 of Object.values(config.content.transform)) {
                if (typeof value2 !== "function") {
                  return false;
                }
              }
            } else if (!(config.content.transform === void 0 || typeof config.content.transform === "function")) {
              return false;
            }
            if (typeof config.content.relative !== "boolean" && typeof config.content.relative !== "undefined") {
              return false;
            }
          }
          return true;
        }
        return false;
      })();
      if (!valid) {
        _log.default.warn("purge-deprecation", [
          "The `purge`/`content` options have changed in Tailwind CSS v3.0.",
          "Update your configuration file to eliminate this warning.",
          "https://tailwindcss.com/docs/upgrade-guide#configure-content-sources"
        ]);
      }
      config.safelist = (() => {
        var _purge_options;
        let { content, purge, safelist } = config;
        if (Array.isArray(safelist))
          return safelist;
        if (Array.isArray(content === null || content === void 0 ? void 0 : content.safelist))
          return content.safelist;
        if (Array.isArray(purge === null || purge === void 0 ? void 0 : purge.safelist))
          return purge.safelist;
        if (Array.isArray(purge === null || purge === void 0 ? void 0 : (_purge_options = purge.options) === null || _purge_options === void 0 ? void 0 : _purge_options.safelist))
          return purge.options.safelist;
        return [];
      })();
      config.blocklist = (() => {
        let { blocklist } = config;
        if (Array.isArray(blocklist)) {
          if (blocklist.every((item) => typeof item === "string")) {
            return blocklist;
          }
          _log.default.warn("blocklist-invalid", [
            "The `blocklist` option must be an array of strings.",
            "https://tailwindcss.com/docs/content-configuration#discarding-classes"
          ]);
        }
        return [];
      })();
      if (typeof config.prefix === "function") {
        _log.default.warn("prefix-function", [
          "As of Tailwind CSS v3.0, `prefix` cannot be a function.",
          "Update `prefix` in your configuration to be a string to eliminate this warning.",
          "https://tailwindcss.com/docs/upgrade-guide#prefix-cannot-be-a-function"
        ]);
        config.prefix = "";
      } else {
        var _config_prefix;
        config.prefix = (_config_prefix = config.prefix) !== null && _config_prefix !== void 0 ? _config_prefix : "";
      }
      config.content = {
        relative: (() => {
          let { content } = config;
          if (content === null || content === void 0 ? void 0 : content.relative) {
            return content.relative;
          }
          return (0, _featureFlags.flagEnabled)(config, "relativeContentPathsByDefault");
        })(),
        files: (() => {
          let { content, purge } = config;
          if (Array.isArray(purge))
            return purge;
          if (Array.isArray(purge === null || purge === void 0 ? void 0 : purge.content))
            return purge.content;
          if (Array.isArray(content))
            return content;
          if (Array.isArray(content === null || content === void 0 ? void 0 : content.content))
            return content.content;
          if (Array.isArray(content === null || content === void 0 ? void 0 : content.files))
            return content.files;
          return [];
        })(),
        extract: (() => {
          let extract = (() => {
            var _config_purge, _config_content, _config_purge1, _config_purge_extract, _config_content1, _config_content_extract, _config_purge2, _config_purge_options, _config_content2, _config_content_options;
            if ((_config_purge = config.purge) === null || _config_purge === void 0 ? void 0 : _config_purge.extract)
              return config.purge.extract;
            if ((_config_content = config.content) === null || _config_content === void 0 ? void 0 : _config_content.extract)
              return config.content.extract;
            if ((_config_purge1 = config.purge) === null || _config_purge1 === void 0 ? void 0 : (_config_purge_extract = _config_purge1.extract) === null || _config_purge_extract === void 0 ? void 0 : _config_purge_extract.DEFAULT)
              return config.purge.extract.DEFAULT;
            if ((_config_content1 = config.content) === null || _config_content1 === void 0 ? void 0 : (_config_content_extract = _config_content1.extract) === null || _config_content_extract === void 0 ? void 0 : _config_content_extract.DEFAULT)
              return config.content.extract.DEFAULT;
            if ((_config_purge2 = config.purge) === null || _config_purge2 === void 0 ? void 0 : (_config_purge_options = _config_purge2.options) === null || _config_purge_options === void 0 ? void 0 : _config_purge_options.extractors)
              return config.purge.options.extractors;
            if ((_config_content2 = config.content) === null || _config_content2 === void 0 ? void 0 : (_config_content_options = _config_content2.options) === null || _config_content_options === void 0 ? void 0 : _config_content_options.extractors)
              return config.content.options.extractors;
            return {};
          })();
          let extractors = {};
          let defaultExtractor = (() => {
            var _config_purge, _config_purge_options, _config_content, _config_content_options;
            if ((_config_purge = config.purge) === null || _config_purge === void 0 ? void 0 : (_config_purge_options = _config_purge.options) === null || _config_purge_options === void 0 ? void 0 : _config_purge_options.defaultExtractor) {
              return config.purge.options.defaultExtractor;
            }
            if ((_config_content = config.content) === null || _config_content === void 0 ? void 0 : (_config_content_options = _config_content.options) === null || _config_content_options === void 0 ? void 0 : _config_content_options.defaultExtractor) {
              return config.content.options.defaultExtractor;
            }
            return void 0;
          })();
          if (defaultExtractor !== void 0) {
            extractors.DEFAULT = defaultExtractor;
          }
          if (typeof extract === "function") {
            extractors.DEFAULT = extract;
          } else if (Array.isArray(extract)) {
            for (let { extensions, extractor } of extract !== null && extract !== void 0 ? extract : []) {
              for (let extension of extensions) {
                extractors[extension] = extractor;
              }
            }
          } else if (typeof extract === "object" && extract !== null) {
            Object.assign(extractors, extract);
          }
          return extractors;
        })(),
        transform: (() => {
          let transform2 = (() => {
            var _config_purge, _config_content, _config_purge1, _config_purge_transform, _config_content1, _config_content_transform;
            if ((_config_purge = config.purge) === null || _config_purge === void 0 ? void 0 : _config_purge.transform)
              return config.purge.transform;
            if ((_config_content = config.content) === null || _config_content === void 0 ? void 0 : _config_content.transform)
              return config.content.transform;
            if ((_config_purge1 = config.purge) === null || _config_purge1 === void 0 ? void 0 : (_config_purge_transform = _config_purge1.transform) === null || _config_purge_transform === void 0 ? void 0 : _config_purge_transform.DEFAULT)
              return config.purge.transform.DEFAULT;
            if ((_config_content1 = config.content) === null || _config_content1 === void 0 ? void 0 : (_config_content_transform = _config_content1.transform) === null || _config_content_transform === void 0 ? void 0 : _config_content_transform.DEFAULT)
              return config.content.transform.DEFAULT;
            return {};
          })();
          let transformers = {};
          if (typeof transform2 === "function") {
            transformers.DEFAULT = transform2;
          }
          if (typeof transform2 === "object" && transform2 !== null) {
            Object.assign(transformers, transform2);
          }
          return transformers;
        })()
      };
      for (let file of config.content.files) {
        if (typeof file === "string" && /{([^,]*?)}/g.test(file)) {
          _log.default.warn("invalid-glob-braces", [
            `The glob pattern ${(0, _log.dim)(file)} in your Tailwind CSS configuration is invalid.`,
            `Update it to ${(0, _log.dim)(file.replace(/{([^,]*?)}/g, "$1"))} to silence this warning.`
          ]);
          break;
        }
      }
      return config;
    }
  }
});

// node_modules/tailwindcss/lib/util/isPlainObject.js
var require_isPlainObject = __commonJS({
  "node_modules/tailwindcss/lib/util/isPlainObject.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    Object.defineProperty(exports, "default", {
      enumerable: true,
      get: function() {
        return isPlainObject;
      }
    });
    function isPlainObject(value2) {
      if (Object.prototype.toString.call(value2) !== "[object Object]") {
        return false;
      }
      const prototype = Object.getPrototypeOf(value2);
      return prototype === null || Object.getPrototypeOf(prototype) === null;
    }
  }
});

// node_modules/tailwindcss/lib/util/cloneDeep.js
var require_cloneDeep = __commonJS({
  "node_modules/tailwindcss/lib/util/cloneDeep.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    Object.defineProperty(exports, "cloneDeep", {
      enumerable: true,
      get: function() {
        return cloneDeep;
      }
    });
    function cloneDeep(value2) {
      if (Array.isArray(value2)) {
        return value2.map((child) => cloneDeep(child));
      }
      if (typeof value2 === "object" && value2 !== null) {
        return Object.fromEntries(Object.entries(value2).map(([k, v]) => [
          k,
          cloneDeep(v)
        ]));
      }
      return value2;
    }
  }
});

// node_modules/tailwindcss/lib/util/escapeCommas.js
var require_escapeCommas = __commonJS({
  "node_modules/tailwindcss/lib/util/escapeCommas.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    Object.defineProperty(exports, "default", {
      enumerable: true,
      get: function() {
        return escapeCommas;
      }
    });
    function escapeCommas(className) {
      return className.replace(/\\,/g, "\\2c ");
    }
  }
});

// node_modules/tailwindcss/lib/util/colorNames.js
var require_colorNames = __commonJS({
  "node_modules/tailwindcss/lib/util/colorNames.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    Object.defineProperty(exports, "default", {
      enumerable: true,
      get: function() {
        return _default;
      }
    });
    var _default = {
      aliceblue: [
        240,
        248,
        255
      ],
      antiquewhite: [
        250,
        235,
        215
      ],
      aqua: [
        0,
        255,
        255
      ],
      aquamarine: [
        127,
        255,
        212
      ],
      azure: [
        240,
        255,
        255
      ],
      beige: [
        245,
        245,
        220
      ],
      bisque: [
        255,
        228,
        196
      ],
      black: [
        0,
        0,
        0
      ],
      blanchedalmond: [
        255,
        235,
        205
      ],
      blue: [
        0,
        0,
        255
      ],
      blueviolet: [
        138,
        43,
        226
      ],
      brown: [
        165,
        42,
        42
      ],
      burlywood: [
        222,
        184,
        135
      ],
      cadetblue: [
        95,
        158,
        160
      ],
      chartreuse: [
        127,
        255,
        0
      ],
      chocolate: [
        210,
        105,
        30
      ],
      coral: [
        255,
        127,
        80
      ],
      cornflowerblue: [
        100,
        149,
        237
      ],
      cornsilk: [
        255,
        248,
        220
      ],
      crimson: [
        220,
        20,
        60
      ],
      cyan: [
        0,
        255,
        255
      ],
      darkblue: [
        0,
        0,
        139
      ],
      darkcyan: [
        0,
        139,
        139
      ],
      darkgoldenrod: [
        184,
        134,
        11
      ],
      darkgray: [
        169,
        169,
        169
      ],
      darkgreen: [
        0,
        100,
        0
      ],
      darkgrey: [
        169,
        169,
        169
      ],
      darkkhaki: [
        189,
        183,
        107
      ],
      darkmagenta: [
        139,
        0,
        139
      ],
      darkolivegreen: [
        85,
        107,
        47
      ],
      darkorange: [
        255,
        140,
        0
      ],
      darkorchid: [
        153,
        50,
        204
      ],
      darkred: [
        139,
        0,
        0
      ],
      darksalmon: [
        233,
        150,
        122
      ],
      darkseagreen: [
        143,
        188,
        143
      ],
      darkslateblue: [
        72,
        61,
        139
      ],
      darkslategray: [
        47,
        79,
        79
      ],
      darkslategrey: [
        47,
        79,
        79
      ],
      darkturquoise: [
        0,
        206,
        209
      ],
      darkviolet: [
        148,
        0,
        211
      ],
      deeppink: [
        255,
        20,
        147
      ],
      deepskyblue: [
        0,
        191,
        255
      ],
      dimgray: [
        105,
        105,
        105
      ],
      dimgrey: [
        105,
        105,
        105
      ],
      dodgerblue: [
        30,
        144,
        255
      ],
      firebrick: [
        178,
        34,
        34
      ],
      floralwhite: [
        255,
        250,
        240
      ],
      forestgreen: [
        34,
        139,
        34
      ],
      fuchsia: [
        255,
        0,
        255
      ],
      gainsboro: [
        220,
        220,
        220
      ],
      ghostwhite: [
        248,
        248,
        255
      ],
      gold: [
        255,
        215,
        0
      ],
      goldenrod: [
        218,
        165,
        32
      ],
      gray: [
        128,
        128,
        128
      ],
      green: [
        0,
        128,
        0
      ],
      greenyellow: [
        173,
        255,
        47
      ],
      grey: [
        128,
        128,
        128
      ],
      honeydew: [
        240,
        255,
        240
      ],
      hotpink: [
        255,
        105,
        180
      ],
      indianred: [
        205,
        92,
        92
      ],
      indigo: [
        75,
        0,
        130
      ],
      ivory: [
        255,
        255,
        240
      ],
      khaki: [
        240,
        230,
        140
      ],
      lavender: [
        230,
        230,
        250
      ],
      lavenderblush: [
        255,
        240,
        245
      ],
      lawngreen: [
        124,
        252,
        0
      ],
      lemonchiffon: [
        255,
        250,
        205
      ],
      lightblue: [
        173,
        216,
        230
      ],
      lightcoral: [
        240,
        128,
        128
      ],
      lightcyan: [
        224,
        255,
        255
      ],
      lightgoldenrodyellow: [
        250,
        250,
        210
      ],
      lightgray: [
        211,
        211,
        211
      ],
      lightgreen: [
        144,
        238,
        144
      ],
      lightgrey: [
        211,
        211,
        211
      ],
      lightpink: [
        255,
        182,
        193
      ],
      lightsalmon: [
        255,
        160,
        122
      ],
      lightseagreen: [
        32,
        178,
        170
      ],
      lightskyblue: [
        135,
        206,
        250
      ],
      lightslategray: [
        119,
        136,
        153
      ],
      lightslategrey: [
        119,
        136,
        153
      ],
      lightsteelblue: [
        176,
        196,
        222
      ],
      lightyellow: [
        255,
        255,
        224
      ],
      lime: [
        0,
        255,
        0
      ],
      limegreen: [
        50,
        205,
        50
      ],
      linen: [
        250,
        240,
        230
      ],
      magenta: [
        255,
        0,
        255
      ],
      maroon: [
        128,
        0,
        0
      ],
      mediumaquamarine: [
        102,
        205,
        170
      ],
      mediumblue: [
        0,
        0,
        205
      ],
      mediumorchid: [
        186,
        85,
        211
      ],
      mediumpurple: [
        147,
        112,
        219
      ],
      mediumseagreen: [
        60,
        179,
        113
      ],
      mediumslateblue: [
        123,
        104,
        238
      ],
      mediumspringgreen: [
        0,
        250,
        154
      ],
      mediumturquoise: [
        72,
        209,
        204
      ],
      mediumvioletred: [
        199,
        21,
        133
      ],
      midnightblue: [
        25,
        25,
        112
      ],
      mintcream: [
        245,
        255,
        250
      ],
      mistyrose: [
        255,
        228,
        225
      ],
      moccasin: [
        255,
        228,
        181
      ],
      navajowhite: [
        255,
        222,
        173
      ],
      navy: [
        0,
        0,
        128
      ],
      oldlace: [
        253,
        245,
        230
      ],
      olive: [
        128,
        128,
        0
      ],
      olivedrab: [
        107,
        142,
        35
      ],
      orange: [
        255,
        165,
        0
      ],
      orangered: [
        255,
        69,
        0
      ],
      orchid: [
        218,
        112,
        214
      ],
      palegoldenrod: [
        238,
        232,
        170
      ],
      palegreen: [
        152,
        251,
        152
      ],
      paleturquoise: [
        175,
        238,
        238
      ],
      palevioletred: [
        219,
        112,
        147
      ],
      papayawhip: [
        255,
        239,
        213
      ],
      peachpuff: [
        255,
        218,
        185
      ],
      peru: [
        205,
        133,
        63
      ],
      pink: [
        255,
        192,
        203
      ],
      plum: [
        221,
        160,
        221
      ],
      powderblue: [
        176,
        224,
        230
      ],
      purple: [
        128,
        0,
        128
      ],
      rebeccapurple: [
        102,
        51,
        153
      ],
      red: [
        255,
        0,
        0
      ],
      rosybrown: [
        188,
        143,
        143
      ],
      royalblue: [
        65,
        105,
        225
      ],
      saddlebrown: [
        139,
        69,
        19
      ],
      salmon: [
        250,
        128,
        114
      ],
      sandybrown: [
        244,
        164,
        96
      ],
      seagreen: [
        46,
        139,
        87
      ],
      seashell: [
        255,
        245,
        238
      ],
      sienna: [
        160,
        82,
        45
      ],
      silver: [
        192,
        192,
        192
      ],
      skyblue: [
        135,
        206,
        235
      ],
      slateblue: [
        106,
        90,
        205
      ],
      slategray: [
        112,
        128,
        144
      ],
      slategrey: [
        112,
        128,
        144
      ],
      snow: [
        255,
        250,
        250
      ],
      springgreen: [
        0,
        255,
        127
      ],
      steelblue: [
        70,
        130,
        180
      ],
      tan: [
        210,
        180,
        140
      ],
      teal: [
        0,
        128,
        128
      ],
      thistle: [
        216,
        191,
        216
      ],
      tomato: [
        255,
        99,
        71
      ],
      turquoise: [
        64,
        224,
        208
      ],
      violet: [
        238,
        130,
        238
      ],
      wheat: [
        245,
        222,
        179
      ],
      white: [
        255,
        255,
        255
      ],
      whitesmoke: [
        245,
        245,
        245
      ],
      yellow: [
        255,
        255,
        0
      ],
      yellowgreen: [
        154,
        205,
        50
      ]
    };
  }
});

// node_modules/tailwindcss/lib/util/color.js
var require_color = __commonJS({
  "node_modules/tailwindcss/lib/util/color.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    function _export(target, all) {
      for (var name in all)
        Object.defineProperty(target, name, {
          enumerable: true,
          get: all[name]
        });
    }
    _export(exports, {
      parseColor: function() {
        return parseColor;
      },
      formatColor: function() {
        return formatColor;
      }
    });
    var _colorNames = _interop_require_default(require_colorNames());
    function _interop_require_default(obj) {
      return obj && obj.__esModule ? obj : {
        default: obj
      };
    }
    var HEX = /^#([a-f\d]{2})([a-f\d]{2})([a-f\d]{2})([a-f\d]{2})?$/i;
    var SHORT_HEX = /^#([a-f\d])([a-f\d])([a-f\d])([a-f\d])?$/i;
    var VALUE = /(?:\d+|\d*\.\d+)%?/;
    var SEP = /(?:\s*,\s*|\s+)/;
    var ALPHA_SEP = /\s*[,/]\s*/;
    var CUSTOM_PROPERTY = /var\(--(?:[^ )]*?)(?:,(?:[^ )]*?|var\(--[^ )]*?\)))?\)/;
    var RGB = new RegExp(`^(rgba?)\\(\\s*(${VALUE.source}|${CUSTOM_PROPERTY.source})(?:${SEP.source}(${VALUE.source}|${CUSTOM_PROPERTY.source}))?(?:${SEP.source}(${VALUE.source}|${CUSTOM_PROPERTY.source}))?(?:${ALPHA_SEP.source}(${VALUE.source}|${CUSTOM_PROPERTY.source}))?\\s*\\)$`);
    var HSL = new RegExp(`^(hsla?)\\(\\s*((?:${VALUE.source})(?:deg|rad|grad|turn)?|${CUSTOM_PROPERTY.source})(?:${SEP.source}(${VALUE.source}|${CUSTOM_PROPERTY.source}))?(?:${SEP.source}(${VALUE.source}|${CUSTOM_PROPERTY.source}))?(?:${ALPHA_SEP.source}(${VALUE.source}|${CUSTOM_PROPERTY.source}))?\\s*\\)$`);
    function parseColor(value2, { loose = false } = {}) {
      var _match_, _match__toString;
      if (typeof value2 !== "string") {
        return null;
      }
      value2 = value2.trim();
      if (value2 === "transparent") {
        return {
          mode: "rgb",
          color: [
            "0",
            "0",
            "0"
          ],
          alpha: "0"
        };
      }
      if (value2 in _colorNames.default) {
        return {
          mode: "rgb",
          color: _colorNames.default[value2].map((v) => v.toString())
        };
      }
      let hex = value2.replace(SHORT_HEX, (_, r, g, b, a) => [
        "#",
        r,
        r,
        g,
        g,
        b,
        b,
        a ? a + a : ""
      ].join("")).match(HEX);
      if (hex !== null) {
        return {
          mode: "rgb",
          color: [
            parseInt(hex[1], 16),
            parseInt(hex[2], 16),
            parseInt(hex[3], 16)
          ].map((v) => v.toString()),
          alpha: hex[4] ? (parseInt(hex[4], 16) / 255).toString() : void 0
        };
      }
      var _value_match;
      let match2 = (_value_match = value2.match(RGB)) !== null && _value_match !== void 0 ? _value_match : value2.match(HSL);
      if (match2 === null) {
        return null;
      }
      let color = [
        match2[2],
        match2[3],
        match2[4]
      ].filter(Boolean).map((v) => v.toString());
      if (color.length === 2 && color[0].startsWith("var(")) {
        return {
          mode: match2[1],
          color: [
            color[0]
          ],
          alpha: color[1]
        };
      }
      if (!loose && color.length !== 3) {
        return null;
      }
      if (color.length < 3 && !color.some((part) => /^var\(.*?\)$/.test(part))) {
        return null;
      }
      return {
        mode: match2[1],
        color,
        alpha: (_match_ = match2[5]) === null || _match_ === void 0 ? void 0 : (_match__toString = _match_.toString) === null || _match__toString === void 0 ? void 0 : _match__toString.call(_match_)
      };
    }
    function formatColor({ mode, color, alpha }) {
      let hasAlpha = alpha !== void 0;
      if (mode === "rgba" || mode === "hsla") {
        return `${mode}(${color.join(", ")}${hasAlpha ? `, ${alpha}` : ""})`;
      }
      return `${mode}(${color.join(" ")}${hasAlpha ? ` / ${alpha}` : ""})`;
    }
  }
});

// node_modules/tailwindcss/lib/util/withAlphaVariable.js
var require_withAlphaVariable = __commonJS({
  "node_modules/tailwindcss/lib/util/withAlphaVariable.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    function _export(target, all) {
      for (var name in all)
        Object.defineProperty(target, name, {
          enumerable: true,
          get: all[name]
        });
    }
    _export(exports, {
      withAlphaValue: function() {
        return withAlphaValue;
      },
      default: function() {
        return withAlphaVariable;
      }
    });
    var _color = require_color();
    function withAlphaValue(color, alphaValue, defaultValue) {
      if (typeof color === "function") {
        return color({
          opacityValue: alphaValue
        });
      }
      let parsed = (0, _color.parseColor)(color, {
        loose: true
      });
      if (parsed === null) {
        return defaultValue;
      }
      return (0, _color.formatColor)({
        ...parsed,
        alpha: alphaValue
      });
    }
    function withAlphaVariable({ color, property, variable }) {
      let properties = [].concat(property);
      if (typeof color === "function") {
        return {
          [variable]: "1",
          ...Object.fromEntries(properties.map((p) => {
            return [
              p,
              color({
                opacityVariable: variable,
                opacityValue: `var(${variable})`
              })
            ];
          }))
        };
      }
      const parsed = (0, _color.parseColor)(color);
      if (parsed === null) {
        return Object.fromEntries(properties.map((p) => [
          p,
          color
        ]));
      }
      if (parsed.alpha !== void 0) {
        return Object.fromEntries(properties.map((p) => [
          p,
          color
        ]));
      }
      return {
        [variable]: "1",
        ...Object.fromEntries(properties.map((p) => {
          return [
            p,
            (0, _color.formatColor)({
              ...parsed,
              alpha: `var(${variable})`
            })
          ];
        }))
      };
    }
  }
});

// node_modules/tailwindcss/lib/util/splitAtTopLevelOnly.js
var require_splitAtTopLevelOnly = __commonJS({
  "node_modules/tailwindcss/lib/util/splitAtTopLevelOnly.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    Object.defineProperty(exports, "splitAtTopLevelOnly", {
      enumerable: true,
      get: function() {
        return splitAtTopLevelOnly;
      }
    });
    function splitAtTopLevelOnly(input2, separator) {
      let stack = [];
      let parts = [];
      let lastPos = 0;
      let isEscaped = false;
      for (let idx = 0; idx < input2.length; idx++) {
        let char = input2[idx];
        if (stack.length === 0 && char === separator[0] && !isEscaped) {
          if (separator.length === 1 || input2.slice(idx, idx + separator.length) === separator) {
            parts.push(input2.slice(lastPos, idx));
            lastPos = idx + separator.length;
          }
        }
        if (isEscaped) {
          isEscaped = false;
        } else if (char === "\\") {
          isEscaped = true;
        }
        if (char === "(" || char === "[" || char === "{") {
          stack.push(char);
        } else if (char === ")" && stack[stack.length - 1] === "(" || char === "]" && stack[stack.length - 1] === "[" || char === "}" && stack[stack.length - 1] === "{") {
          stack.pop();
        }
      }
      parts.push(input2.slice(lastPos));
      return parts;
    }
  }
});

// node_modules/tailwindcss/lib/util/parseBoxShadowValue.js
var require_parseBoxShadowValue = __commonJS({
  "node_modules/tailwindcss/lib/util/parseBoxShadowValue.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    function _export(target, all) {
      for (var name in all)
        Object.defineProperty(target, name, {
          enumerable: true,
          get: all[name]
        });
    }
    _export(exports, {
      parseBoxShadowValue: function() {
        return parseBoxShadowValue;
      },
      formatBoxShadowValue: function() {
        return formatBoxShadowValue;
      }
    });
    var _splitAtTopLevelOnly = require_splitAtTopLevelOnly();
    var KEYWORDS = /* @__PURE__ */ new Set([
      "inset",
      "inherit",
      "initial",
      "revert",
      "unset"
    ]);
    var SPACE = /\ +(?![^(]*\))/g;
    var LENGTH = /^-?(\d+|\.\d+)(.*?)$/g;
    function parseBoxShadowValue(input2) {
      let shadows = (0, _splitAtTopLevelOnly.splitAtTopLevelOnly)(input2, ",");
      return shadows.map((shadow) => {
        let value2 = shadow.trim();
        let result = {
          raw: value2
        };
        let parts = value2.split(SPACE);
        let seen = /* @__PURE__ */ new Set();
        for (let part of parts) {
          LENGTH.lastIndex = 0;
          if (!seen.has("KEYWORD") && KEYWORDS.has(part)) {
            result.keyword = part;
            seen.add("KEYWORD");
          } else if (LENGTH.test(part)) {
            if (!seen.has("X")) {
              result.x = part;
              seen.add("X");
            } else if (!seen.has("Y")) {
              result.y = part;
              seen.add("Y");
            } else if (!seen.has("BLUR")) {
              result.blur = part;
              seen.add("BLUR");
            } else if (!seen.has("SPREAD")) {
              result.spread = part;
              seen.add("SPREAD");
            }
          } else {
            if (!result.color) {
              result.color = part;
            } else {
              if (!result.unknown)
                result.unknown = [];
              result.unknown.push(part);
            }
          }
        }
        result.valid = result.x !== void 0 && result.y !== void 0;
        return result;
      });
    }
    function formatBoxShadowValue(shadows) {
      return shadows.map((shadow) => {
        if (!shadow.valid) {
          return shadow.raw;
        }
        return [
          shadow.keyword,
          shadow.x,
          shadow.y,
          shadow.blur,
          shadow.spread,
          shadow.color
        ].filter(Boolean).join(" ");
      }).join(", ");
    }
  }
});

// node_modules/tailwindcss/lib/util/dataTypes.js
var require_dataTypes = __commonJS({
  "node_modules/tailwindcss/lib/util/dataTypes.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    function _export(target, all) {
      for (var name in all)
        Object.defineProperty(target, name, {
          enumerable: true,
          get: all[name]
        });
    }
    _export(exports, {
      normalize: function() {
        return normalize;
      },
      url: function() {
        return url;
      },
      number: function() {
        return number;
      },
      percentage: function() {
        return percentage;
      },
      length: function() {
        return length;
      },
      lineWidth: function() {
        return lineWidth;
      },
      shadow: function() {
        return shadow;
      },
      color: function() {
        return color;
      },
      image: function() {
        return image;
      },
      gradient: function() {
        return gradient;
      },
      position: function() {
        return position;
      },
      familyName: function() {
        return familyName;
      },
      genericName: function() {
        return genericName;
      },
      absoluteSize: function() {
        return absoluteSize;
      },
      relativeSize: function() {
        return relativeSize;
      }
    });
    var _color = require_color();
    var _parseBoxShadowValue = require_parseBoxShadowValue();
    var _splitAtTopLevelOnly = require_splitAtTopLevelOnly();
    var cssFunctions = [
      "min",
      "max",
      "clamp",
      "calc"
    ];
    function isCSSFunction(value2) {
      return cssFunctions.some((fn) => new RegExp(`^${fn}\\(.*\\)`).test(value2));
    }
    var AUTO_VAR_INJECTION_EXCEPTIONS = /* @__PURE__ */ new Set([
      // Concrete properties
      "scroll-timeline-name",
      "timeline-scope",
      "view-timeline-name",
      "font-palette",
      // Shorthand properties
      "scroll-timeline",
      "animation-timeline",
      "view-timeline"
    ]);
    function normalize(value2, context = null, isRoot = true) {
      let isVarException = context && AUTO_VAR_INJECTION_EXCEPTIONS.has(context.property);
      if (value2.startsWith("--") && !isVarException) {
        return `var(${value2})`;
      }
      if (value2.includes("url(")) {
        return value2.split(/(url\(.*?\))/g).filter(Boolean).map((part) => {
          if (/^url\(.*?\)$/.test(part)) {
            return part;
          }
          return normalize(part, context, false);
        }).join("");
      }
      value2 = value2.replace(/([^\\])_+/g, (fullMatch, characterBefore) => characterBefore + " ".repeat(fullMatch.length - 1)).replace(/^_/g, " ").replace(/\\_/g, "_");
      if (isRoot) {
        value2 = value2.trim();
      }
      value2 = normalizeMathOperatorSpacing(value2);
      return value2;
    }
    function normalizeMathOperatorSpacing(value2) {
      let preventFormattingInFunctions = [
        "theme"
      ];
      let preventFormattingKeywords = [
        "min-content",
        "max-content",
        "fit-content",
        // Env
        "safe-area-inset-top",
        "safe-area-inset-right",
        "safe-area-inset-bottom",
        "safe-area-inset-left",
        "titlebar-area-x",
        "titlebar-area-y",
        "titlebar-area-width",
        "titlebar-area-height",
        "keyboard-inset-top",
        "keyboard-inset-right",
        "keyboard-inset-bottom",
        "keyboard-inset-left",
        "keyboard-inset-width",
        "keyboard-inset-height",
        "radial-gradient",
        "linear-gradient",
        "conic-gradient",
        "repeating-radial-gradient",
        "repeating-linear-gradient",
        "repeating-conic-gradient"
      ];
      return value2.replace(/(calc|min|max|clamp)\(.+\)/g, (match2) => {
        let result = "";
        function lastChar() {
          let char = result.trimEnd();
          return char[char.length - 1];
        }
        for (let i = 0; i < match2.length; i++) {
          let peek = function(word) {
            return word.split("").every((char2, j) => match2[i + j] === char2);
          }, consumeUntil = function(chars) {
            let minIndex = Infinity;
            for (let char2 of chars) {
              let index = match2.indexOf(char2, i);
              if (index !== -1 && index < minIndex) {
                minIndex = index;
              }
            }
            let result2 = match2.slice(i, minIndex);
            i += result2.length - 1;
            return result2;
          };
          let char = match2[i];
          if (peek("var")) {
            result += consumeUntil([
              ")",
              ","
            ]);
          } else if (preventFormattingKeywords.some((keyword) => peek(keyword))) {
            let keyword = preventFormattingKeywords.find((keyword2) => peek(keyword2));
            result += keyword;
            i += keyword.length - 1;
          } else if (preventFormattingInFunctions.some((fn) => peek(fn))) {
            result += consumeUntil([
              ")"
            ]);
          } else if (peek("[")) {
            result += consumeUntil([
              "]"
            ]);
          } else if ([
            "+",
            "-",
            "*",
            "/"
          ].includes(char) && ![
            "(",
            "+",
            "-",
            "*",
            "/",
            ","
          ].includes(lastChar())) {
            result += ` ${char} `;
          } else {
            result += char;
          }
        }
        return result.replace(/\s+/g, " ");
      });
    }
    function url(value2) {
      return value2.startsWith("url(");
    }
    function number(value2) {
      return !isNaN(Number(value2)) || isCSSFunction(value2);
    }
    function percentage(value2) {
      return value2.endsWith("%") && number(value2.slice(0, -1)) || isCSSFunction(value2);
    }
    var lengthUnits = [
      "cm",
      "mm",
      "Q",
      "in",
      "pc",
      "pt",
      "px",
      "em",
      "ex",
      "ch",
      "rem",
      "lh",
      "rlh",
      "vw",
      "vh",
      "vmin",
      "vmax",
      "vb",
      "vi",
      "svw",
      "svh",
      "lvw",
      "lvh",
      "dvw",
      "dvh",
      "cqw",
      "cqh",
      "cqi",
      "cqb",
      "cqmin",
      "cqmax"
    ];
    var lengthUnitsPattern = `(?:${lengthUnits.join("|")})`;
    function length(value2) {
      return value2 === "0" || new RegExp(`^[+-]?[0-9]*.?[0-9]+(?:[eE][+-]?[0-9]+)?${lengthUnitsPattern}$`).test(value2) || isCSSFunction(value2);
    }
    var lineWidths = /* @__PURE__ */ new Set([
      "thin",
      "medium",
      "thick"
    ]);
    function lineWidth(value2) {
      return lineWidths.has(value2);
    }
    function shadow(value2) {
      let parsedShadows = (0, _parseBoxShadowValue.parseBoxShadowValue)(normalize(value2));
      for (let parsedShadow of parsedShadows) {
        if (!parsedShadow.valid) {
          return false;
        }
      }
      return true;
    }
    function color(value2) {
      let colors = 0;
      let result = (0, _splitAtTopLevelOnly.splitAtTopLevelOnly)(value2, "_").every((part) => {
        part = normalize(part);
        if (part.startsWith("var("))
          return true;
        if ((0, _color.parseColor)(part, {
          loose: true
        }) !== null)
          return colors++, true;
        return false;
      });
      if (!result)
        return false;
      return colors > 0;
    }
    function image(value2) {
      let images = 0;
      let result = (0, _splitAtTopLevelOnly.splitAtTopLevelOnly)(value2, ",").every((part) => {
        part = normalize(part);
        if (part.startsWith("var("))
          return true;
        if (url(part) || gradient(part) || [
          "element(",
          "image(",
          "cross-fade(",
          "image-set("
        ].some((fn) => part.startsWith(fn))) {
          images++;
          return true;
        }
        return false;
      });
      if (!result)
        return false;
      return images > 0;
    }
    var gradientTypes = /* @__PURE__ */ new Set([
      "conic-gradient",
      "linear-gradient",
      "radial-gradient",
      "repeating-conic-gradient",
      "repeating-linear-gradient",
      "repeating-radial-gradient"
    ]);
    function gradient(value2) {
      value2 = normalize(value2);
      for (let type of gradientTypes) {
        if (value2.startsWith(`${type}(`)) {
          return true;
        }
      }
      return false;
    }
    var validPositions = /* @__PURE__ */ new Set([
      "center",
      "top",
      "right",
      "bottom",
      "left"
    ]);
    function position(value2) {
      let positions = 0;
      let result = (0, _splitAtTopLevelOnly.splitAtTopLevelOnly)(value2, "_").every((part) => {
        part = normalize(part);
        if (part.startsWith("var("))
          return true;
        if (validPositions.has(part) || length(part) || percentage(part)) {
          positions++;
          return true;
        }
        return false;
      });
      if (!result)
        return false;
      return positions > 0;
    }
    function familyName(value2) {
      let fonts = 0;
      let result = (0, _splitAtTopLevelOnly.splitAtTopLevelOnly)(value2, ",").every((part) => {
        part = normalize(part);
        if (part.startsWith("var("))
          return true;
        if (part.includes(" ")) {
          if (!/(['"])([^"']+)\1/g.test(part)) {
            return false;
          }
        }
        if (/^\d/g.test(part)) {
          return false;
        }
        fonts++;
        return true;
      });
      if (!result)
        return false;
      return fonts > 0;
    }
    var genericNames = /* @__PURE__ */ new Set([
      "serif",
      "sans-serif",
      "monospace",
      "cursive",
      "fantasy",
      "system-ui",
      "ui-serif",
      "ui-sans-serif",
      "ui-monospace",
      "ui-rounded",
      "math",
      "emoji",
      "fangsong"
    ]);
    function genericName(value2) {
      return genericNames.has(value2);
    }
    var absoluteSizes = /* @__PURE__ */ new Set([
      "xx-small",
      "x-small",
      "small",
      "medium",
      "large",
      "x-large",
      "xx-large",
      "xxx-large"
    ]);
    function absoluteSize(value2) {
      return absoluteSizes.has(value2);
    }
    var relativeSizes = /* @__PURE__ */ new Set([
      "larger",
      "smaller"
    ]);
    function relativeSize(value2) {
      return relativeSizes.has(value2);
    }
  }
});

// node_modules/tailwindcss/lib/util/validateFormalSyntax.js
var require_validateFormalSyntax = __commonJS({
  "node_modules/tailwindcss/lib/util/validateFormalSyntax.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    Object.defineProperty(exports, "backgroundSize", {
      enumerable: true,
      get: function() {
        return backgroundSize;
      }
    });
    var _dataTypes = require_dataTypes();
    var _splitAtTopLevelOnly = require_splitAtTopLevelOnly();
    function backgroundSize(value2) {
      let keywordValues = [
        "cover",
        "contain"
      ];
      return (0, _splitAtTopLevelOnly.splitAtTopLevelOnly)(value2, ",").every((part) => {
        let sizes = (0, _splitAtTopLevelOnly.splitAtTopLevelOnly)(part, "_").filter(Boolean);
        if (sizes.length === 1 && keywordValues.includes(sizes[0]))
          return true;
        if (sizes.length !== 1 && sizes.length !== 2)
          return false;
        return sizes.every((size) => (0, _dataTypes.length)(size) || (0, _dataTypes.percentage)(size) || size === "auto");
      });
    }
  }
});

// node_modules/tailwindcss/lib/util/pluginUtils.js
var require_pluginUtils = __commonJS({
  "node_modules/tailwindcss/lib/util/pluginUtils.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    function _export(target, all) {
      for (var name in all)
        Object.defineProperty(target, name, {
          enumerable: true,
          get: all[name]
        });
    }
    _export(exports, {
      updateAllClasses: function() {
        return updateAllClasses;
      },
      asValue: function() {
        return asValue;
      },
      parseColorFormat: function() {
        return parseColorFormat;
      },
      asColor: function() {
        return asColor;
      },
      asLookupValue: function() {
        return asLookupValue;
      },
      typeMap: function() {
        return typeMap;
      },
      coerceValue: function() {
        return coerceValue;
      },
      getMatchingTypes: function() {
        return getMatchingTypes;
      }
    });
    var _escapeCommas = _interop_require_default(require_escapeCommas());
    var _withAlphaVariable = require_withAlphaVariable();
    var _dataTypes = require_dataTypes();
    var _negateValue = _interop_require_default(require_negateValue());
    var _validateFormalSyntax = require_validateFormalSyntax();
    var _featureFlags = require_featureFlags();
    function _interop_require_default(obj) {
      return obj && obj.__esModule ? obj : {
        default: obj
      };
    }
    function updateAllClasses(selectors, updateClass) {
      selectors.walkClasses((sel) => {
        sel.value = updateClass(sel.value);
        if (sel.raws && sel.raws.value) {
          sel.raws.value = (0, _escapeCommas.default)(sel.raws.value);
        }
      });
    }
    function resolveArbitraryValue(modifier, validate) {
      if (!isArbitraryValue(modifier)) {
        return void 0;
      }
      let value2 = modifier.slice(1, -1);
      if (!validate(value2)) {
        return void 0;
      }
      return (0, _dataTypes.normalize)(value2);
    }
    function asNegativeValue(modifier, lookup = {}, validate) {
      let positiveValue = lookup[modifier];
      if (positiveValue !== void 0) {
        return (0, _negateValue.default)(positiveValue);
      }
      if (isArbitraryValue(modifier)) {
        let resolved = resolveArbitraryValue(modifier, validate);
        if (resolved === void 0) {
          return void 0;
        }
        return (0, _negateValue.default)(resolved);
      }
    }
    function asValue(modifier, options = {}, { validate = () => true } = {}) {
      var _options_values;
      let value2 = (_options_values = options.values) === null || _options_values === void 0 ? void 0 : _options_values[modifier];
      if (value2 !== void 0) {
        return value2;
      }
      if (options.supportsNegativeValues && modifier.startsWith("-")) {
        return asNegativeValue(modifier.slice(1), options.values, validate);
      }
      return resolveArbitraryValue(modifier, validate);
    }
    function isArbitraryValue(input2) {
      return input2.startsWith("[") && input2.endsWith("]");
    }
    function splitUtilityModifier(modifier) {
      let slashIdx = modifier.lastIndexOf("/");
      let arbitraryStartIdx = modifier.lastIndexOf("[", slashIdx);
      let arbitraryEndIdx = modifier.indexOf("]", slashIdx);
      let isNextToArbitrary = modifier[slashIdx - 1] === "]" || modifier[slashIdx + 1] === "[";
      if (!isNextToArbitrary) {
        if (arbitraryStartIdx !== -1 && arbitraryEndIdx !== -1) {
          if (arbitraryStartIdx < slashIdx && slashIdx < arbitraryEndIdx) {
            slashIdx = modifier.lastIndexOf("/", arbitraryStartIdx);
          }
        }
      }
      if (slashIdx === -1 || slashIdx === modifier.length - 1) {
        return [
          modifier,
          void 0
        ];
      }
      let arbitrary = isArbitraryValue(modifier);
      if (arbitrary && !modifier.includes("]/[")) {
        return [
          modifier,
          void 0
        ];
      }
      return [
        modifier.slice(0, slashIdx),
        modifier.slice(slashIdx + 1)
      ];
    }
    function parseColorFormat(value2) {
      if (typeof value2 === "string" && value2.includes("<alpha-value>")) {
        let oldValue = value2;
        return ({ opacityValue = 1 }) => oldValue.replace(/<alpha-value>/g, opacityValue);
      }
      return value2;
    }
    function unwrapArbitraryModifier(modifier) {
      return (0, _dataTypes.normalize)(modifier.slice(1, -1));
    }
    function asColor(modifier, options = {}, { tailwindConfig = {} } = {}) {
      var _options_values;
      if (((_options_values = options.values) === null || _options_values === void 0 ? void 0 : _options_values[modifier]) !== void 0) {
        var _options_values1;
        return parseColorFormat((_options_values1 = options.values) === null || _options_values1 === void 0 ? void 0 : _options_values1[modifier]);
      }
      let [color, alpha] = splitUtilityModifier(modifier);
      if (alpha !== void 0) {
        var _options_values2, _tailwindConfig_theme, _tailwindConfig_theme_opacity;
        var _options_values_color;
        let normalizedColor = (_options_values_color = (_options_values2 = options.values) === null || _options_values2 === void 0 ? void 0 : _options_values2[color]) !== null && _options_values_color !== void 0 ? _options_values_color : isArbitraryValue(color) ? color.slice(1, -1) : void 0;
        if (normalizedColor === void 0) {
          return void 0;
        }
        normalizedColor = parseColorFormat(normalizedColor);
        if (isArbitraryValue(alpha)) {
          return (0, _withAlphaVariable.withAlphaValue)(normalizedColor, unwrapArbitraryModifier(alpha));
        }
        if (((_tailwindConfig_theme = tailwindConfig.theme) === null || _tailwindConfig_theme === void 0 ? void 0 : (_tailwindConfig_theme_opacity = _tailwindConfig_theme.opacity) === null || _tailwindConfig_theme_opacity === void 0 ? void 0 : _tailwindConfig_theme_opacity[alpha]) === void 0) {
          return void 0;
        }
        return (0, _withAlphaVariable.withAlphaValue)(normalizedColor, tailwindConfig.theme.opacity[alpha]);
      }
      return asValue(modifier, options, {
        validate: _dataTypes.color
      });
    }
    function asLookupValue(modifier, options = {}) {
      var _options_values;
      return (_options_values = options.values) === null || _options_values === void 0 ? void 0 : _options_values[modifier];
    }
    function guess(validate) {
      return (modifier, options) => {
        return asValue(modifier, options, {
          validate
        });
      };
    }
    var typeMap = {
      any: asValue,
      color: asColor,
      url: guess(_dataTypes.url),
      image: guess(_dataTypes.image),
      length: guess(_dataTypes.length),
      percentage: guess(_dataTypes.percentage),
      position: guess(_dataTypes.position),
      lookup: asLookupValue,
      "generic-name": guess(_dataTypes.genericName),
      "family-name": guess(_dataTypes.familyName),
      number: guess(_dataTypes.number),
      "line-width": guess(_dataTypes.lineWidth),
      "absolute-size": guess(_dataTypes.absoluteSize),
      "relative-size": guess(_dataTypes.relativeSize),
      shadow: guess(_dataTypes.shadow),
      size: guess(_validateFormalSyntax.backgroundSize)
    };
    var supportedTypes = Object.keys(typeMap);
    function splitAtFirst(input2, delim) {
      let idx = input2.indexOf(delim);
      if (idx === -1)
        return [
          void 0,
          input2
        ];
      return [
        input2.slice(0, idx),
        input2.slice(idx + 1)
      ];
    }
    function coerceValue(types, modifier, options, tailwindConfig) {
      if (options.values && modifier in options.values) {
        for (let { type } of types !== null && types !== void 0 ? types : []) {
          let result = typeMap[type](modifier, options, {
            tailwindConfig
          });
          if (result === void 0) {
            continue;
          }
          return [
            result,
            type,
            null
          ];
        }
      }
      if (isArbitraryValue(modifier)) {
        let arbitraryValue = modifier.slice(1, -1);
        let [explicitType, value2] = splitAtFirst(arbitraryValue, ":");
        if (!/^[\w-_]+$/g.test(explicitType)) {
          value2 = arbitraryValue;
        } else if (explicitType !== void 0 && !supportedTypes.includes(explicitType)) {
          return [];
        }
        if (value2.length > 0 && supportedTypes.includes(explicitType)) {
          return [
            asValue(`[${value2}]`, options),
            explicitType,
            null
          ];
        }
      }
      let matches = getMatchingTypes(types, modifier, options, tailwindConfig);
      for (let match2 of matches) {
        return match2;
      }
      return [];
    }
    function* getMatchingTypes(types, rawModifier, options, tailwindConfig) {
      let modifiersEnabled = (0, _featureFlags.flagEnabled)(tailwindConfig, "generalizedModifiers");
      let [modifier, utilityModifier] = splitUtilityModifier(rawModifier);
      let canUseUtilityModifier = modifiersEnabled && options.modifiers != null && (options.modifiers === "any" || typeof options.modifiers === "object" && (utilityModifier && isArbitraryValue(utilityModifier) || utilityModifier in options.modifiers));
      if (!canUseUtilityModifier) {
        modifier = rawModifier;
        utilityModifier = void 0;
      }
      if (utilityModifier !== void 0 && modifier === "") {
        modifier = "DEFAULT";
      }
      if (utilityModifier !== void 0) {
        if (typeof options.modifiers === "object") {
          var _options_modifiers;
          var _options_modifiers_utilityModifier;
          let configValue = (_options_modifiers_utilityModifier = (_options_modifiers = options.modifiers) === null || _options_modifiers === void 0 ? void 0 : _options_modifiers[utilityModifier]) !== null && _options_modifiers_utilityModifier !== void 0 ? _options_modifiers_utilityModifier : null;
          if (configValue !== null) {
            utilityModifier = configValue;
          } else if (isArbitraryValue(utilityModifier)) {
            utilityModifier = unwrapArbitraryModifier(utilityModifier);
          }
        }
      }
      for (let { type } of types !== null && types !== void 0 ? types : []) {
        let result = typeMap[type](modifier, options, {
          tailwindConfig
        });
        if (result === void 0) {
          continue;
        }
        yield [
          result,
          type,
          utilityModifier !== null && utilityModifier !== void 0 ? utilityModifier : null
        ];
      }
    }
  }
});

// node_modules/tailwindcss/lib/util/toColorValue.js
var require_toColorValue = __commonJS({
  "node_modules/tailwindcss/lib/util/toColorValue.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    Object.defineProperty(exports, "default", {
      enumerable: true,
      get: function() {
        return toColorValue;
      }
    });
    function toColorValue(maybeFunction) {
      return typeof maybeFunction === "function" ? maybeFunction({}) : maybeFunction;
    }
  }
});

// node_modules/tailwindcss/lib/util/resolveConfig.js
var require_resolveConfig = __commonJS({
  "node_modules/tailwindcss/lib/util/resolveConfig.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    Object.defineProperty(exports, "default", {
      enumerable: true,
      get: function() {
        return resolveConfig;
      }
    });
    var _negateValue = _interop_require_default(require_negateValue());
    var _corePluginList = _interop_require_default(require_corePluginList());
    var _configurePlugins = _interop_require_default(require_configurePlugins());
    var _colors = _interop_require_default(require_colors());
    var _defaults = require_defaults();
    var _toPath = require_toPath();
    var _normalizeConfig = require_normalizeConfig();
    var _isPlainObject = _interop_require_default(require_isPlainObject());
    var _cloneDeep = require_cloneDeep();
    var _pluginUtils = require_pluginUtils();
    var _withAlphaVariable = require_withAlphaVariable();
    var _toColorValue = _interop_require_default(require_toColorValue());
    function _interop_require_default(obj) {
      return obj && obj.__esModule ? obj : {
        default: obj
      };
    }
    function isFunction(input2) {
      return typeof input2 === "function";
    }
    function mergeWith(target, ...sources) {
      let customizer = sources.pop();
      for (let source of sources) {
        for (let k in source) {
          let merged = customizer(target[k], source[k]);
          if (merged === void 0) {
            if ((0, _isPlainObject.default)(target[k]) && (0, _isPlainObject.default)(source[k])) {
              target[k] = mergeWith({}, target[k], source[k], customizer);
            } else {
              target[k] = source[k];
            }
          } else {
            target[k] = merged;
          }
        }
      }
      return target;
    }
    var configUtils = {
      colors: _colors.default,
      negative(scale) {
        return Object.keys(scale).filter((key) => scale[key] !== "0").reduce((negativeScale, key) => {
          let negativeValue = (0, _negateValue.default)(scale[key]);
          if (negativeValue !== void 0) {
            negativeScale[`-${key}`] = negativeValue;
          }
          return negativeScale;
        }, {});
      },
      breakpoints(screens) {
        return Object.keys(screens).filter((key) => typeof screens[key] === "string").reduce((breakpoints, key) => ({
          ...breakpoints,
          [`screen-${key}`]: screens[key]
        }), {});
      }
    };
    function value2(valueToResolve, ...args) {
      return isFunction(valueToResolve) ? valueToResolve(...args) : valueToResolve;
    }
    function collectExtends(items) {
      return items.reduce((merged, { extend }) => {
        return mergeWith(merged, extend, (mergedValue, extendValue) => {
          if (mergedValue === void 0) {
            return [
              extendValue
            ];
          }
          if (Array.isArray(mergedValue)) {
            return [
              extendValue,
              ...mergedValue
            ];
          }
          return [
            extendValue,
            mergedValue
          ];
        });
      }, {});
    }
    function mergeThemes(themes) {
      return {
        ...themes.reduce((merged, theme) => (0, _defaults.defaults)(merged, theme), {}),
        // In order to resolve n config objects, we combine all of their `extend` properties
        // into arrays instead of objects so they aren't overridden.
        extend: collectExtends(themes)
      };
    }
    function mergeExtensionCustomizer(merged, value3) {
      if (Array.isArray(merged) && (0, _isPlainObject.default)(merged[0])) {
        return merged.concat(value3);
      }
      if (Array.isArray(value3) && (0, _isPlainObject.default)(value3[0]) && (0, _isPlainObject.default)(merged)) {
        return [
          merged,
          ...value3
        ];
      }
      if (Array.isArray(value3)) {
        return value3;
      }
      return void 0;
    }
    function mergeExtensions({ extend, ...theme }) {
      return mergeWith(theme, extend, (themeValue, extensions) => {
        if (!isFunction(themeValue) && !extensions.some(isFunction)) {
          return mergeWith({}, themeValue, ...extensions, mergeExtensionCustomizer);
        }
        return (resolveThemePath, utils) => mergeWith({}, ...[
          themeValue,
          ...extensions
        ].map((e) => value2(e, resolveThemePath, utils)), mergeExtensionCustomizer);
      });
    }
    function* toPaths(key) {
      let path = (0, _toPath.toPath)(key);
      if (path.length === 0) {
        return;
      }
      yield path;
      if (Array.isArray(key)) {
        return;
      }
      let pattern = /^(.*?)\s*\/\s*([^/]+)$/;
      let matches = key.match(pattern);
      if (matches !== null) {
        let [, prefix, alpha] = matches;
        let newPath = (0, _toPath.toPath)(prefix);
        newPath.alpha = alpha;
        yield newPath;
      }
    }
    function resolveFunctionKeys(object) {
      const resolvePath = (key, defaultValue) => {
        for (const path of toPaths(key)) {
          let index = 0;
          let val = object;
          while (val !== void 0 && val !== null && index < path.length) {
            val = val[path[index++]];
            let shouldResolveAsFn = isFunction(val) && (path.alpha === void 0 || index <= path.length - 1);
            val = shouldResolveAsFn ? val(resolvePath, configUtils) : val;
          }
          if (val !== void 0) {
            if (path.alpha !== void 0) {
              let normalized = (0, _pluginUtils.parseColorFormat)(val);
              return (0, _withAlphaVariable.withAlphaValue)(normalized, path.alpha, (0, _toColorValue.default)(normalized));
            }
            if ((0, _isPlainObject.default)(val)) {
              return (0, _cloneDeep.cloneDeep)(val);
            }
            return val;
          }
        }
        return defaultValue;
      };
      Object.assign(resolvePath, {
        theme: resolvePath,
        ...configUtils
      });
      return Object.keys(object).reduce((resolved, key) => {
        resolved[key] = isFunction(object[key]) ? object[key](resolvePath, configUtils) : object[key];
        return resolved;
      }, {});
    }
    function extractPluginConfigs(configs) {
      let allConfigs = [];
      configs.forEach((config) => {
        allConfigs = [
          ...allConfigs,
          config
        ];
        var _config_plugins;
        const plugins = (_config_plugins = config === null || config === void 0 ? void 0 : config.plugins) !== null && _config_plugins !== void 0 ? _config_plugins : [];
        if (plugins.length === 0) {
          return;
        }
        plugins.forEach((plugin) => {
          if (plugin.__isOptionsFunction) {
            plugin = plugin();
          }
          var _plugin_config;
          allConfigs = [
            ...allConfigs,
            ...extractPluginConfigs([
              (_plugin_config = plugin === null || plugin === void 0 ? void 0 : plugin.config) !== null && _plugin_config !== void 0 ? _plugin_config : {}
            ])
          ];
        });
      });
      return allConfigs;
    }
    function resolveCorePlugins(corePluginConfigs) {
      const result = [
        ...corePluginConfigs
      ].reduceRight((resolved, corePluginConfig) => {
        if (isFunction(corePluginConfig)) {
          return corePluginConfig({
            corePlugins: resolved
          });
        }
        return (0, _configurePlugins.default)(corePluginConfig, resolved);
      }, _corePluginList.default);
      return result;
    }
    function resolvePluginLists(pluginLists) {
      const result = [
        ...pluginLists
      ].reduceRight((resolved, pluginList) => {
        return [
          ...resolved,
          ...pluginList
        ];
      }, []);
      return result;
    }
    function resolveConfig(configs) {
      let allConfigs = [
        ...extractPluginConfigs(configs),
        {
          prefix: "",
          important: false,
          separator: ":"
        }
      ];
      var _t_theme, _c_plugins;
      return (0, _normalizeConfig.normalizeConfig)((0, _defaults.defaults)({
        theme: resolveFunctionKeys(mergeExtensions(mergeThemes(allConfigs.map((t2) => {
          return (_t_theme = t2 === null || t2 === void 0 ? void 0 : t2.theme) !== null && _t_theme !== void 0 ? _t_theme : {};
        })))),
        corePlugins: resolveCorePlugins(allConfigs.map((c) => c.corePlugins)),
        plugins: resolvePluginLists(configs.map((c) => {
          return (_c_plugins = c === null || c === void 0 ? void 0 : c.plugins) !== null && _c_plugins !== void 0 ? _c_plugins : [];
        }))
      }, ...allConfigs));
    }
  }
});

// node_modules/tailwindcss/stubs/config.full.js
var require_config_full = __commonJS({
  "node_modules/tailwindcss/stubs/config.full.js"(exports, module) {
    module.exports = {
      content: [],
      presets: [],
      darkMode: "media",
      // or 'class'
      theme: {
        accentColor: ({ theme }) => ({
          ...theme("colors"),
          auto: "auto"
        }),
        animation: {
          none: "none",
          spin: "spin 1s linear infinite",
          ping: "ping 1s cubic-bezier(0, 0, 0.2, 1) infinite",
          pulse: "pulse 2s cubic-bezier(0.4, 0, 0.6, 1) infinite",
          bounce: "bounce 1s infinite"
        },
        aria: {
          busy: 'busy="true"',
          checked: 'checked="true"',
          disabled: 'disabled="true"',
          expanded: 'expanded="true"',
          hidden: 'hidden="true"',
          pressed: 'pressed="true"',
          readonly: 'readonly="true"',
          required: 'required="true"',
          selected: 'selected="true"'
        },
        aspectRatio: {
          auto: "auto",
          square: "1 / 1",
          video: "16 / 9"
        },
        backdropBlur: ({ theme }) => theme("blur"),
        backdropBrightness: ({ theme }) => theme("brightness"),
        backdropContrast: ({ theme }) => theme("contrast"),
        backdropGrayscale: ({ theme }) => theme("grayscale"),
        backdropHueRotate: ({ theme }) => theme("hueRotate"),
        backdropInvert: ({ theme }) => theme("invert"),
        backdropOpacity: ({ theme }) => theme("opacity"),
        backdropSaturate: ({ theme }) => theme("saturate"),
        backdropSepia: ({ theme }) => theme("sepia"),
        backgroundColor: ({ theme }) => theme("colors"),
        backgroundImage: {
          none: "none",
          "gradient-to-t": "linear-gradient(to top, var(--tw-gradient-stops))",
          "gradient-to-tr": "linear-gradient(to top right, var(--tw-gradient-stops))",
          "gradient-to-r": "linear-gradient(to right, var(--tw-gradient-stops))",
          "gradient-to-br": "linear-gradient(to bottom right, var(--tw-gradient-stops))",
          "gradient-to-b": "linear-gradient(to bottom, var(--tw-gradient-stops))",
          "gradient-to-bl": "linear-gradient(to bottom left, var(--tw-gradient-stops))",
          "gradient-to-l": "linear-gradient(to left, var(--tw-gradient-stops))",
          "gradient-to-tl": "linear-gradient(to top left, var(--tw-gradient-stops))"
        },
        backgroundOpacity: ({ theme }) => theme("opacity"),
        backgroundPosition: {
          bottom: "bottom",
          center: "center",
          left: "left",
          "left-bottom": "left bottom",
          "left-top": "left top",
          right: "right",
          "right-bottom": "right bottom",
          "right-top": "right top",
          top: "top"
        },
        backgroundSize: {
          auto: "auto",
          cover: "cover",
          contain: "contain"
        },
        blur: {
          0: "0",
          none: "0",
          sm: "4px",
          DEFAULT: "8px",
          md: "12px",
          lg: "16px",
          xl: "24px",
          "2xl": "40px",
          "3xl": "64px"
        },
        borderColor: ({ theme }) => ({
          ...theme("colors"),
          DEFAULT: theme("colors.gray.200", "currentColor")
        }),
        borderOpacity: ({ theme }) => theme("opacity"),
        borderRadius: {
          none: "0px",
          sm: "0.125rem",
          DEFAULT: "0.25rem",
          md: "0.375rem",
          lg: "0.5rem",
          xl: "0.75rem",
          "2xl": "1rem",
          "3xl": "1.5rem",
          full: "9999px"
        },
        borderSpacing: ({ theme }) => ({
          ...theme("spacing")
        }),
        borderWidth: {
          DEFAULT: "1px",
          0: "0px",
          2: "2px",
          4: "4px",
          8: "8px"
        },
        boxShadow: {
          sm: "0 1px 2px 0 rgb(0 0 0 / 0.05)",
          DEFAULT: "0 1px 3px 0 rgb(0 0 0 / 0.1), 0 1px 2px -1px rgb(0 0 0 / 0.1)",
          md: "0 4px 6px -1px rgb(0 0 0 / 0.1), 0 2px 4px -2px rgb(0 0 0 / 0.1)",
          lg: "0 10px 15px -3px rgb(0 0 0 / 0.1), 0 4px 6px -4px rgb(0 0 0 / 0.1)",
          xl: "0 20px 25px -5px rgb(0 0 0 / 0.1), 0 8px 10px -6px rgb(0 0 0 / 0.1)",
          "2xl": "0 25px 50px -12px rgb(0 0 0 / 0.25)",
          inner: "inset 0 2px 4px 0 rgb(0 0 0 / 0.05)",
          none: "none"
        },
        boxShadowColor: ({ theme }) => theme("colors"),
        brightness: {
          0: "0",
          50: ".5",
          75: ".75",
          90: ".9",
          95: ".95",
          100: "1",
          105: "1.05",
          110: "1.1",
          125: "1.25",
          150: "1.5",
          200: "2"
        },
        caretColor: ({ theme }) => theme("colors"),
        colors: ({ colors }) => ({
          inherit: colors.inherit,
          current: colors.current,
          transparent: colors.transparent,
          black: colors.black,
          white: colors.white,
          slate: colors.slate,
          gray: colors.gray,
          zinc: colors.zinc,
          neutral: colors.neutral,
          stone: colors.stone,
          red: colors.red,
          orange: colors.orange,
          amber: colors.amber,
          yellow: colors.yellow,
          lime: colors.lime,
          green: colors.green,
          emerald: colors.emerald,
          teal: colors.teal,
          cyan: colors.cyan,
          sky: colors.sky,
          blue: colors.blue,
          indigo: colors.indigo,
          violet: colors.violet,
          purple: colors.purple,
          fuchsia: colors.fuchsia,
          pink: colors.pink,
          rose: colors.rose
        }),
        columns: {
          auto: "auto",
          1: "1",
          2: "2",
          3: "3",
          4: "4",
          5: "5",
          6: "6",
          7: "7",
          8: "8",
          9: "9",
          10: "10",
          11: "11",
          12: "12",
          "3xs": "16rem",
          "2xs": "18rem",
          xs: "20rem",
          sm: "24rem",
          md: "28rem",
          lg: "32rem",
          xl: "36rem",
          "2xl": "42rem",
          "3xl": "48rem",
          "4xl": "56rem",
          "5xl": "64rem",
          "6xl": "72rem",
          "7xl": "80rem"
        },
        container: {},
        content: {
          none: "none"
        },
        contrast: {
          0: "0",
          50: ".5",
          75: ".75",
          100: "1",
          125: "1.25",
          150: "1.5",
          200: "2"
        },
        cursor: {
          auto: "auto",
          default: "default",
          pointer: "pointer",
          wait: "wait",
          text: "text",
          move: "move",
          help: "help",
          "not-allowed": "not-allowed",
          none: "none",
          "context-menu": "context-menu",
          progress: "progress",
          cell: "cell",
          crosshair: "crosshair",
          "vertical-text": "vertical-text",
          alias: "alias",
          copy: "copy",
          "no-drop": "no-drop",
          grab: "grab",
          grabbing: "grabbing",
          "all-scroll": "all-scroll",
          "col-resize": "col-resize",
          "row-resize": "row-resize",
          "n-resize": "n-resize",
          "e-resize": "e-resize",
          "s-resize": "s-resize",
          "w-resize": "w-resize",
          "ne-resize": "ne-resize",
          "nw-resize": "nw-resize",
          "se-resize": "se-resize",
          "sw-resize": "sw-resize",
          "ew-resize": "ew-resize",
          "ns-resize": "ns-resize",
          "nesw-resize": "nesw-resize",
          "nwse-resize": "nwse-resize",
          "zoom-in": "zoom-in",
          "zoom-out": "zoom-out"
        },
        divideColor: ({ theme }) => theme("borderColor"),
        divideOpacity: ({ theme }) => theme("borderOpacity"),
        divideWidth: ({ theme }) => theme("borderWidth"),
        dropShadow: {
          sm: "0 1px 1px rgb(0 0 0 / 0.05)",
          DEFAULT: ["0 1px 2px rgb(0 0 0 / 0.1)", "0 1px 1px rgb(0 0 0 / 0.06)"],
          md: ["0 4px 3px rgb(0 0 0 / 0.07)", "0 2px 2px rgb(0 0 0 / 0.06)"],
          lg: ["0 10px 8px rgb(0 0 0 / 0.04)", "0 4px 3px rgb(0 0 0 / 0.1)"],
          xl: ["0 20px 13px rgb(0 0 0 / 0.03)", "0 8px 5px rgb(0 0 0 / 0.08)"],
          "2xl": "0 25px 25px rgb(0 0 0 / 0.15)",
          none: "0 0 #0000"
        },
        fill: ({ theme }) => ({
          none: "none",
          ...theme("colors")
        }),
        flex: {
          1: "1 1 0%",
          auto: "1 1 auto",
          initial: "0 1 auto",
          none: "none"
        },
        flexBasis: ({ theme }) => ({
          auto: "auto",
          ...theme("spacing"),
          "1/2": "50%",
          "1/3": "33.333333%",
          "2/3": "66.666667%",
          "1/4": "25%",
          "2/4": "50%",
          "3/4": "75%",
          "1/5": "20%",
          "2/5": "40%",
          "3/5": "60%",
          "4/5": "80%",
          "1/6": "16.666667%",
          "2/6": "33.333333%",
          "3/6": "50%",
          "4/6": "66.666667%",
          "5/6": "83.333333%",
          "1/12": "8.333333%",
          "2/12": "16.666667%",
          "3/12": "25%",
          "4/12": "33.333333%",
          "5/12": "41.666667%",
          "6/12": "50%",
          "7/12": "58.333333%",
          "8/12": "66.666667%",
          "9/12": "75%",
          "10/12": "83.333333%",
          "11/12": "91.666667%",
          full: "100%"
        }),
        flexGrow: {
          0: "0",
          DEFAULT: "1"
        },
        flexShrink: {
          0: "0",
          DEFAULT: "1"
        },
        fontFamily: {
          sans: [
            "ui-sans-serif",
            "system-ui",
            "sans-serif",
            '"Apple Color Emoji"',
            '"Segoe UI Emoji"',
            '"Segoe UI Symbol"',
            '"Noto Color Emoji"'
          ],
          serif: ["ui-serif", "Georgia", "Cambria", '"Times New Roman"', "Times", "serif"],
          mono: [
            "ui-monospace",
            "SFMono-Regular",
            "Menlo",
            "Monaco",
            "Consolas",
            '"Liberation Mono"',
            '"Courier New"',
            "monospace"
          ]
        },
        fontSize: {
          xs: ["0.75rem", { lineHeight: "1rem" }],
          sm: ["0.875rem", { lineHeight: "1.25rem" }],
          base: ["1rem", { lineHeight: "1.5rem" }],
          lg: ["1.125rem", { lineHeight: "1.75rem" }],
          xl: ["1.25rem", { lineHeight: "1.75rem" }],
          "2xl": ["1.5rem", { lineHeight: "2rem" }],
          "3xl": ["1.875rem", { lineHeight: "2.25rem" }],
          "4xl": ["2.25rem", { lineHeight: "2.5rem" }],
          "5xl": ["3rem", { lineHeight: "1" }],
          "6xl": ["3.75rem", { lineHeight: "1" }],
          "7xl": ["4.5rem", { lineHeight: "1" }],
          "8xl": ["6rem", { lineHeight: "1" }],
          "9xl": ["8rem", { lineHeight: "1" }]
        },
        fontWeight: {
          thin: "100",
          extralight: "200",
          light: "300",
          normal: "400",
          medium: "500",
          semibold: "600",
          bold: "700",
          extrabold: "800",
          black: "900"
        },
        gap: ({ theme }) => theme("spacing"),
        gradientColorStops: ({ theme }) => theme("colors"),
        gradientColorStopPositions: {
          "0%": "0%",
          "5%": "5%",
          "10%": "10%",
          "15%": "15%",
          "20%": "20%",
          "25%": "25%",
          "30%": "30%",
          "35%": "35%",
          "40%": "40%",
          "45%": "45%",
          "50%": "50%",
          "55%": "55%",
          "60%": "60%",
          "65%": "65%",
          "70%": "70%",
          "75%": "75%",
          "80%": "80%",
          "85%": "85%",
          "90%": "90%",
          "95%": "95%",
          "100%": "100%"
        },
        grayscale: {
          0: "0",
          DEFAULT: "100%"
        },
        gridAutoColumns: {
          auto: "auto",
          min: "min-content",
          max: "max-content",
          fr: "minmax(0, 1fr)"
        },
        gridAutoRows: {
          auto: "auto",
          min: "min-content",
          max: "max-content",
          fr: "minmax(0, 1fr)"
        },
        gridColumn: {
          auto: "auto",
          "span-1": "span 1 / span 1",
          "span-2": "span 2 / span 2",
          "span-3": "span 3 / span 3",
          "span-4": "span 4 / span 4",
          "span-5": "span 5 / span 5",
          "span-6": "span 6 / span 6",
          "span-7": "span 7 / span 7",
          "span-8": "span 8 / span 8",
          "span-9": "span 9 / span 9",
          "span-10": "span 10 / span 10",
          "span-11": "span 11 / span 11",
          "span-12": "span 12 / span 12",
          "span-full": "1 / -1"
        },
        gridColumnEnd: {
          auto: "auto",
          1: "1",
          2: "2",
          3: "3",
          4: "4",
          5: "5",
          6: "6",
          7: "7",
          8: "8",
          9: "9",
          10: "10",
          11: "11",
          12: "12",
          13: "13"
        },
        gridColumnStart: {
          auto: "auto",
          1: "1",
          2: "2",
          3: "3",
          4: "4",
          5: "5",
          6: "6",
          7: "7",
          8: "8",
          9: "9",
          10: "10",
          11: "11",
          12: "12",
          13: "13"
        },
        gridRow: {
          auto: "auto",
          "span-1": "span 1 / span 1",
          "span-2": "span 2 / span 2",
          "span-3": "span 3 / span 3",
          "span-4": "span 4 / span 4",
          "span-5": "span 5 / span 5",
          "span-6": "span 6 / span 6",
          "span-7": "span 7 / span 7",
          "span-8": "span 8 / span 8",
          "span-9": "span 9 / span 9",
          "span-10": "span 10 / span 10",
          "span-11": "span 11 / span 11",
          "span-12": "span 12 / span 12",
          "span-full": "1 / -1"
        },
        gridRowEnd: {
          auto: "auto",
          1: "1",
          2: "2",
          3: "3",
          4: "4",
          5: "5",
          6: "6",
          7: "7",
          8: "8",
          9: "9",
          10: "10",
          11: "11",
          12: "12",
          13: "13"
        },
        gridRowStart: {
          auto: "auto",
          1: "1",
          2: "2",
          3: "3",
          4: "4",
          5: "5",
          6: "6",
          7: "7",
          8: "8",
          9: "9",
          10: "10",
          11: "11",
          12: "12",
          13: "13"
        },
        gridTemplateColumns: {
          none: "none",
          subgrid: "subgrid",
          1: "repeat(1, minmax(0, 1fr))",
          2: "repeat(2, minmax(0, 1fr))",
          3: "repeat(3, minmax(0, 1fr))",
          4: "repeat(4, minmax(0, 1fr))",
          5: "repeat(5, minmax(0, 1fr))",
          6: "repeat(6, minmax(0, 1fr))",
          7: "repeat(7, minmax(0, 1fr))",
          8: "repeat(8, minmax(0, 1fr))",
          9: "repeat(9, minmax(0, 1fr))",
          10: "repeat(10, minmax(0, 1fr))",
          11: "repeat(11, minmax(0, 1fr))",
          12: "repeat(12, minmax(0, 1fr))"
        },
        gridTemplateRows: {
          none: "none",
          subgrid: "subgrid",
          1: "repeat(1, minmax(0, 1fr))",
          2: "repeat(2, minmax(0, 1fr))",
          3: "repeat(3, minmax(0, 1fr))",
          4: "repeat(4, minmax(0, 1fr))",
          5: "repeat(5, minmax(0, 1fr))",
          6: "repeat(6, minmax(0, 1fr))",
          7: "repeat(7, minmax(0, 1fr))",
          8: "repeat(8, minmax(0, 1fr))",
          9: "repeat(9, minmax(0, 1fr))",
          10: "repeat(10, minmax(0, 1fr))",
          11: "repeat(11, minmax(0, 1fr))",
          12: "repeat(12, minmax(0, 1fr))"
        },
        height: ({ theme }) => ({
          auto: "auto",
          ...theme("spacing"),
          "1/2": "50%",
          "1/3": "33.333333%",
          "2/3": "66.666667%",
          "1/4": "25%",
          "2/4": "50%",
          "3/4": "75%",
          "1/5": "20%",
          "2/5": "40%",
          "3/5": "60%",
          "4/5": "80%",
          "1/6": "16.666667%",
          "2/6": "33.333333%",
          "3/6": "50%",
          "4/6": "66.666667%",
          "5/6": "83.333333%",
          full: "100%",
          screen: "100vh",
          svh: "100svh",
          lvh: "100lvh",
          dvh: "100dvh",
          min: "min-content",
          max: "max-content",
          fit: "fit-content"
        }),
        hueRotate: {
          0: "0deg",
          15: "15deg",
          30: "30deg",
          60: "60deg",
          90: "90deg",
          180: "180deg"
        },
        inset: ({ theme }) => ({
          auto: "auto",
          ...theme("spacing"),
          "1/2": "50%",
          "1/3": "33.333333%",
          "2/3": "66.666667%",
          "1/4": "25%",
          "2/4": "50%",
          "3/4": "75%",
          full: "100%"
        }),
        invert: {
          0: "0",
          DEFAULT: "100%"
        },
        keyframes: {
          spin: {
            to: {
              transform: "rotate(360deg)"
            }
          },
          ping: {
            "75%, 100%": {
              transform: "scale(2)",
              opacity: "0"
            }
          },
          pulse: {
            "50%": {
              opacity: ".5"
            }
          },
          bounce: {
            "0%, 100%": {
              transform: "translateY(-25%)",
              animationTimingFunction: "cubic-bezier(0.8,0,1,1)"
            },
            "50%": {
              transform: "none",
              animationTimingFunction: "cubic-bezier(0,0,0.2,1)"
            }
          }
        },
        letterSpacing: {
          tighter: "-0.05em",
          tight: "-0.025em",
          normal: "0em",
          wide: "0.025em",
          wider: "0.05em",
          widest: "0.1em"
        },
        lineHeight: {
          none: "1",
          tight: "1.25",
          snug: "1.375",
          normal: "1.5",
          relaxed: "1.625",
          loose: "2",
          3: ".75rem",
          4: "1rem",
          5: "1.25rem",
          6: "1.5rem",
          7: "1.75rem",
          8: "2rem",
          9: "2.25rem",
          10: "2.5rem"
        },
        listStyleType: {
          none: "none",
          disc: "disc",
          decimal: "decimal"
        },
        listStyleImage: {
          none: "none"
        },
        margin: ({ theme }) => ({
          auto: "auto",
          ...theme("spacing")
        }),
        lineClamp: {
          1: "1",
          2: "2",
          3: "3",
          4: "4",
          5: "5",
          6: "6"
        },
        maxHeight: ({ theme }) => ({
          ...theme("spacing"),
          none: "none",
          full: "100%",
          screen: "100vh",
          svh: "100svh",
          lvh: "100lvh",
          dvh: "100dvh",
          min: "min-content",
          max: "max-content",
          fit: "fit-content"
        }),
        maxWidth: ({ theme, breakpoints }) => ({
          ...theme("spacing"),
          none: "none",
          xs: "20rem",
          sm: "24rem",
          md: "28rem",
          lg: "32rem",
          xl: "36rem",
          "2xl": "42rem",
          "3xl": "48rem",
          "4xl": "56rem",
          "5xl": "64rem",
          "6xl": "72rem",
          "7xl": "80rem",
          full: "100%",
          min: "min-content",
          max: "max-content",
          fit: "fit-content",
          prose: "65ch",
          ...breakpoints(theme("screens"))
        }),
        minHeight: ({ theme }) => ({
          ...theme("spacing"),
          full: "100%",
          screen: "100vh",
          svh: "100svh",
          lvh: "100lvh",
          dvh: "100dvh",
          min: "min-content",
          max: "max-content",
          fit: "fit-content"
        }),
        minWidth: ({ theme }) => ({
          ...theme("spacing"),
          full: "100%",
          min: "min-content",
          max: "max-content",
          fit: "fit-content"
        }),
        objectPosition: {
          bottom: "bottom",
          center: "center",
          left: "left",
          "left-bottom": "left bottom",
          "left-top": "left top",
          right: "right",
          "right-bottom": "right bottom",
          "right-top": "right top",
          top: "top"
        },
        opacity: {
          0: "0",
          5: "0.05",
          10: "0.1",
          15: "0.15",
          20: "0.2",
          25: "0.25",
          30: "0.3",
          35: "0.35",
          40: "0.4",
          45: "0.45",
          50: "0.5",
          55: "0.55",
          60: "0.6",
          65: "0.65",
          70: "0.7",
          75: "0.75",
          80: "0.8",
          85: "0.85",
          90: "0.9",
          95: "0.95",
          100: "1"
        },
        order: {
          first: "-9999",
          last: "9999",
          none: "0",
          1: "1",
          2: "2",
          3: "3",
          4: "4",
          5: "5",
          6: "6",
          7: "7",
          8: "8",
          9: "9",
          10: "10",
          11: "11",
          12: "12"
        },
        outlineColor: ({ theme }) => theme("colors"),
        outlineOffset: {
          0: "0px",
          1: "1px",
          2: "2px",
          4: "4px",
          8: "8px"
        },
        outlineWidth: {
          0: "0px",
          1: "1px",
          2: "2px",
          4: "4px",
          8: "8px"
        },
        padding: ({ theme }) => theme("spacing"),
        placeholderColor: ({ theme }) => theme("colors"),
        placeholderOpacity: ({ theme }) => theme("opacity"),
        ringColor: ({ theme }) => ({
          DEFAULT: theme("colors.blue.500", "#3b82f6"),
          ...theme("colors")
        }),
        ringOffsetColor: ({ theme }) => theme("colors"),
        ringOffsetWidth: {
          0: "0px",
          1: "1px",
          2: "2px",
          4: "4px",
          8: "8px"
        },
        ringOpacity: ({ theme }) => ({
          DEFAULT: "0.5",
          ...theme("opacity")
        }),
        ringWidth: {
          DEFAULT: "3px",
          0: "0px",
          1: "1px",
          2: "2px",
          4: "4px",
          8: "8px"
        },
        rotate: {
          0: "0deg",
          1: "1deg",
          2: "2deg",
          3: "3deg",
          6: "6deg",
          12: "12deg",
          45: "45deg",
          90: "90deg",
          180: "180deg"
        },
        saturate: {
          0: "0",
          50: ".5",
          100: "1",
          150: "1.5",
          200: "2"
        },
        scale: {
          0: "0",
          50: ".5",
          75: ".75",
          90: ".9",
          95: ".95",
          100: "1",
          105: "1.05",
          110: "1.1",
          125: "1.25",
          150: "1.5"
        },
        screens: {
          sm: "640px",
          md: "768px",
          lg: "1024px",
          xl: "1280px",
          "2xl": "1536px"
        },
        scrollMargin: ({ theme }) => ({
          ...theme("spacing")
        }),
        scrollPadding: ({ theme }) => theme("spacing"),
        sepia: {
          0: "0",
          DEFAULT: "100%"
        },
        skew: {
          0: "0deg",
          1: "1deg",
          2: "2deg",
          3: "3deg",
          6: "6deg",
          12: "12deg"
        },
        space: ({ theme }) => ({
          ...theme("spacing")
        }),
        spacing: {
          px: "1px",
          0: "0px",
          0.5: "0.125rem",
          1: "0.25rem",
          1.5: "0.375rem",
          2: "0.5rem",
          2.5: "0.625rem",
          3: "0.75rem",
          3.5: "0.875rem",
          4: "1rem",
          5: "1.25rem",
          6: "1.5rem",
          7: "1.75rem",
          8: "2rem",
          9: "2.25rem",
          10: "2.5rem",
          11: "2.75rem",
          12: "3rem",
          14: "3.5rem",
          16: "4rem",
          20: "5rem",
          24: "6rem",
          28: "7rem",
          32: "8rem",
          36: "9rem",
          40: "10rem",
          44: "11rem",
          48: "12rem",
          52: "13rem",
          56: "14rem",
          60: "15rem",
          64: "16rem",
          72: "18rem",
          80: "20rem",
          96: "24rem"
        },
        stroke: ({ theme }) => ({
          none: "none",
          ...theme("colors")
        }),
        strokeWidth: {
          0: "0",
          1: "1",
          2: "2"
        },
        supports: {},
        data: {},
        textColor: ({ theme }) => theme("colors"),
        textDecorationColor: ({ theme }) => theme("colors"),
        textDecorationThickness: {
          auto: "auto",
          "from-font": "from-font",
          0: "0px",
          1: "1px",
          2: "2px",
          4: "4px",
          8: "8px"
        },
        textIndent: ({ theme }) => ({
          ...theme("spacing")
        }),
        textOpacity: ({ theme }) => theme("opacity"),
        textUnderlineOffset: {
          auto: "auto",
          0: "0px",
          1: "1px",
          2: "2px",
          4: "4px",
          8: "8px"
        },
        transformOrigin: {
          center: "center",
          top: "top",
          "top-right": "top right",
          right: "right",
          "bottom-right": "bottom right",
          bottom: "bottom",
          "bottom-left": "bottom left",
          left: "left",
          "top-left": "top left"
        },
        transitionDelay: {
          0: "0s",
          75: "75ms",
          100: "100ms",
          150: "150ms",
          200: "200ms",
          300: "300ms",
          500: "500ms",
          700: "700ms",
          1e3: "1000ms"
        },
        transitionDuration: {
          DEFAULT: "150ms",
          0: "0s",
          75: "75ms",
          100: "100ms",
          150: "150ms",
          200: "200ms",
          300: "300ms",
          500: "500ms",
          700: "700ms",
          1e3: "1000ms"
        },
        transitionProperty: {
          none: "none",
          all: "all",
          DEFAULT: "color, background-color, border-color, text-decoration-color, fill, stroke, opacity, box-shadow, transform, filter, backdrop-filter",
          colors: "color, background-color, border-color, text-decoration-color, fill, stroke",
          opacity: "opacity",
          shadow: "box-shadow",
          transform: "transform"
        },
        transitionTimingFunction: {
          DEFAULT: "cubic-bezier(0.4, 0, 0.2, 1)",
          linear: "linear",
          in: "cubic-bezier(0.4, 0, 1, 1)",
          out: "cubic-bezier(0, 0, 0.2, 1)",
          "in-out": "cubic-bezier(0.4, 0, 0.2, 1)"
        },
        translate: ({ theme }) => ({
          ...theme("spacing"),
          "1/2": "50%",
          "1/3": "33.333333%",
          "2/3": "66.666667%",
          "1/4": "25%",
          "2/4": "50%",
          "3/4": "75%",
          full: "100%"
        }),
        size: ({ theme }) => ({
          auto: "auto",
          ...theme("spacing"),
          "1/2": "50%",
          "1/3": "33.333333%",
          "2/3": "66.666667%",
          "1/4": "25%",
          "2/4": "50%",
          "3/4": "75%",
          "1/5": "20%",
          "2/5": "40%",
          "3/5": "60%",
          "4/5": "80%",
          "1/6": "16.666667%",
          "2/6": "33.333333%",
          "3/6": "50%",
          "4/6": "66.666667%",
          "5/6": "83.333333%",
          "1/12": "8.333333%",
          "2/12": "16.666667%",
          "3/12": "25%",
          "4/12": "33.333333%",
          "5/12": "41.666667%",
          "6/12": "50%",
          "7/12": "58.333333%",
          "8/12": "66.666667%",
          "9/12": "75%",
          "10/12": "83.333333%",
          "11/12": "91.666667%",
          full: "100%",
          min: "min-content",
          max: "max-content",
          fit: "fit-content"
        }),
        width: ({ theme }) => ({
          auto: "auto",
          ...theme("spacing"),
          "1/2": "50%",
          "1/3": "33.333333%",
          "2/3": "66.666667%",
          "1/4": "25%",
          "2/4": "50%",
          "3/4": "75%",
          "1/5": "20%",
          "2/5": "40%",
          "3/5": "60%",
          "4/5": "80%",
          "1/6": "16.666667%",
          "2/6": "33.333333%",
          "3/6": "50%",
          "4/6": "66.666667%",
          "5/6": "83.333333%",
          "1/12": "8.333333%",
          "2/12": "16.666667%",
          "3/12": "25%",
          "4/12": "33.333333%",
          "5/12": "41.666667%",
          "6/12": "50%",
          "7/12": "58.333333%",
          "8/12": "66.666667%",
          "9/12": "75%",
          "10/12": "83.333333%",
          "11/12": "91.666667%",
          full: "100%",
          screen: "100vw",
          svw: "100svw",
          lvw: "100lvw",
          dvw: "100dvw",
          min: "min-content",
          max: "max-content",
          fit: "fit-content"
        }),
        willChange: {
          auto: "auto",
          scroll: "scroll-position",
          contents: "contents",
          transform: "transform"
        },
        zIndex: {
          auto: "auto",
          0: "0",
          10: "10",
          20: "20",
          30: "30",
          40: "40",
          50: "50"
        }
      },
      plugins: []
    };
  }
});

// node_modules/tailwindcss/lib/util/getAllConfigs.js
var require_getAllConfigs = __commonJS({
  "node_modules/tailwindcss/lib/util/getAllConfigs.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    Object.defineProperty(exports, "default", {
      enumerable: true,
      get: function() {
        return getAllConfigs;
      }
    });
    var _configfull = _interop_require_default(require_config_full());
    var _featureFlags = require_featureFlags();
    function _interop_require_default(obj) {
      return obj && obj.__esModule ? obj : {
        default: obj
      };
    }
    function getAllConfigs(config) {
      var _config_presets;
      const configs = ((_config_presets = config === null || config === void 0 ? void 0 : config.presets) !== null && _config_presets !== void 0 ? _config_presets : [
        _configfull.default
      ]).slice().reverse().flatMap((preset) => getAllConfigs(preset instanceof Function ? preset() : preset));
      const features = {
        // Add experimental configs here...
        respectDefaultRingColorOpacity: {
          theme: {
            ringColor: ({ theme }) => ({
              DEFAULT: "#3b82f67f",
              ...theme("colors")
            })
          }
        },
        disableColorOpacityUtilitiesByDefault: {
          corePlugins: {
            backgroundOpacity: false,
            borderOpacity: false,
            divideOpacity: false,
            placeholderOpacity: false,
            ringOpacity: false,
            textOpacity: false
          }
        }
      };
      const experimentals = Object.keys(features).filter((feature) => (0, _featureFlags.flagEnabled)(config, feature)).map((feature) => features[feature]);
      return [
        config,
        ...experimentals,
        ...configs
      ];
    }
  }
});

// node_modules/tailwindcss/lib/public/resolve-config.js
var require_resolve_config = __commonJS({
  "node_modules/tailwindcss/lib/public/resolve-config.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    Object.defineProperty(exports, "default", {
      enumerable: true,
      get: function() {
        return resolveConfig;
      }
    });
    var _resolveConfig = _interop_require_default(require_resolveConfig());
    var _getAllConfigs = _interop_require_default(require_getAllConfigs());
    function _interop_require_default(obj) {
      return obj && obj.__esModule ? obj : {
        default: obj
      };
    }
    function resolveConfig(...configs) {
      let [, ...defaultConfigs] = (0, _getAllConfigs.default)(configs[0]);
      return (0, _resolveConfig.default)([
        ...configs,
        ...defaultConfigs
      ]);
    }
  }
});

// node_modules/tailwindcss/lib/util/resolveConfigPath.js
var require_resolveConfigPath = __commonJS({
  "node_modules/tailwindcss/lib/util/resolveConfigPath.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    function _export(target, all) {
      for (var name in all)
        Object.defineProperty(target, name, {
          enumerable: true,
          get: all[name]
        });
    }
    _export(exports, {
      default: function() {
        return resolveConfigPath;
      },
      resolveDefaultConfigPath: function() {
        return resolveDefaultConfigPath;
      }
    });
    var _fs = _interop_require_default(require_fs());
    var _path = _interop_require_default(require_path());
    function _interop_require_default(obj) {
      return obj && obj.__esModule ? obj : {
        default: obj
      };
    }
    var defaultConfigFiles = [
      "./tailwind.config.js",
      "./tailwind.config.cjs",
      "./tailwind.config.mjs",
      "./tailwind.config.ts"
    ];
    function isObject(value2) {
      return typeof value2 === "object" && value2 !== null;
    }
    function isEmpty(obj) {
      return Object.keys(obj).length === 0;
    }
    function isString(value2) {
      return typeof value2 === "string" || value2 instanceof String;
    }
    function resolveConfigPath(pathOrConfig) {
      if (isObject(pathOrConfig) && pathOrConfig.config === void 0 && !isEmpty(pathOrConfig)) {
        return null;
      }
      if (isObject(pathOrConfig) && pathOrConfig.config !== void 0 && isString(pathOrConfig.config)) {
        return _path.default.resolve(pathOrConfig.config);
      }
      if (isObject(pathOrConfig) && pathOrConfig.config !== void 0 && isObject(pathOrConfig.config)) {
        return null;
      }
      if (isString(pathOrConfig)) {
        return _path.default.resolve(pathOrConfig);
      }
      return resolveDefaultConfigPath();
    }
    function resolveDefaultConfigPath() {
      for (const configFile of defaultConfigFiles) {
        try {
          const configPath = _path.default.resolve(configFile);
          _fs.default.accessSync(configPath);
          return configPath;
        } catch (err) {
        }
      }
      return null;
    }
  }
});

// node_modules/dlv/dist/dlv.umd.js
var require_dlv_umd = __commonJS({
  "node_modules/dlv/dist/dlv.umd.js"(exports, module) {
    !function(t2, n) {
      "object" == typeof exports && "undefined" != typeof module ? module.exports = function(t3, n2, e, i, o) {
        for (n2 = n2.split ? n2.split(".") : n2, i = 0; i < n2.length; i++)
          t3 = t3 ? t3[n2[i]] : o;
        return t3 === o ? e : t3;
      } : "function" == typeof define && define.amd ? define(function() {
        return function(t3, n2, e, i, o) {
          for (n2 = n2.split ? n2.split(".") : n2, i = 0; i < n2.length; i++)
            t3 = t3 ? t3[n2[i]] : o;
          return t3 === o ? e : t3;
        };
      }) : t2.dlv = function(t3, n2, e, i, o) {
        for (n2 = n2.split ? n2.split(".") : n2, i = 0; i < n2.length; i++)
          t3 = t3 ? t3[n2[i]] : o;
        return t3 === o ? e : t3;
      };
    }(exports);
  }
});

// node_modules/postcss-selector-parser/dist/util/unesc.js
var require_unesc = __commonJS({
  "node_modules/postcss-selector-parser/dist/util/unesc.js"(exports, module) {
    "use strict";
    exports.__esModule = true;
    exports["default"] = unesc;
    function gobbleHex(str) {
      var lower = str.toLowerCase();
      var hex = "";
      var spaceTerminated = false;
      for (var i = 0; i < 6 && lower[i] !== void 0; i++) {
        var code = lower.charCodeAt(i);
        var valid = code >= 97 && code <= 102 || code >= 48 && code <= 57;
        spaceTerminated = code === 32;
        if (!valid) {
          break;
        }
        hex += lower[i];
      }
      if (hex.length === 0) {
        return void 0;
      }
      var codePoint = parseInt(hex, 16);
      var isSurrogate = codePoint >= 55296 && codePoint <= 57343;
      if (isSurrogate || codePoint === 0 || codePoint > 1114111) {
        return ["�", hex.length + (spaceTerminated ? 1 : 0)];
      }
      return [String.fromCodePoint(codePoint), hex.length + (spaceTerminated ? 1 : 0)];
    }
    var CONTAINS_ESCAPE = /\\/;
    function unesc(str) {
      var needToProcess = CONTAINS_ESCAPE.test(str);
      if (!needToProcess) {
        return str;
      }
      var ret = "";
      for (var i = 0; i < str.length; i++) {
        if (str[i] === "\\") {
          var gobbled = gobbleHex(str.slice(i + 1, i + 7));
          if (gobbled !== void 0) {
            ret += gobbled[0];
            i += gobbled[1];
            continue;
          }
          if (str[i + 1] === "\\") {
            ret += "\\";
            i++;
            continue;
          }
          if (str.length === i + 1) {
            ret += str[i];
          }
          continue;
        }
        ret += str[i];
      }
      return ret;
    }
    module.exports = exports.default;
  }
});

// node_modules/postcss-selector-parser/dist/util/getProp.js
var require_getProp = __commonJS({
  "node_modules/postcss-selector-parser/dist/util/getProp.js"(exports, module) {
    "use strict";
    exports.__esModule = true;
    exports["default"] = getProp;
    function getProp(obj) {
      for (var _len = arguments.length, props = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
        props[_key - 1] = arguments[_key];
      }
      while (props.length > 0) {
        var prop = props.shift();
        if (!obj[prop]) {
          return void 0;
        }
        obj = obj[prop];
      }
      return obj;
    }
    module.exports = exports.default;
  }
});

// node_modules/postcss-selector-parser/dist/util/ensureObject.js
var require_ensureObject = __commonJS({
  "node_modules/postcss-selector-parser/dist/util/ensureObject.js"(exports, module) {
    "use strict";
    exports.__esModule = true;
    exports["default"] = ensureObject;
    function ensureObject(obj) {
      for (var _len = arguments.length, props = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
        props[_key - 1] = arguments[_key];
      }
      while (props.length > 0) {
        var prop = props.shift();
        if (!obj[prop]) {
          obj[prop] = {};
        }
        obj = obj[prop];
      }
    }
    module.exports = exports.default;
  }
});

// node_modules/postcss-selector-parser/dist/util/stripComments.js
var require_stripComments = __commonJS({
  "node_modules/postcss-selector-parser/dist/util/stripComments.js"(exports, module) {
    "use strict";
    exports.__esModule = true;
    exports["default"] = stripComments;
    function stripComments(str) {
      var s = "";
      var commentStart = str.indexOf("/*");
      var lastEnd = 0;
      while (commentStart >= 0) {
        s = s + str.slice(lastEnd, commentStart);
        var commentEnd = str.indexOf("*/", commentStart + 2);
        if (commentEnd < 0) {
          return s;
        }
        lastEnd = commentEnd + 2;
        commentStart = str.indexOf("/*", lastEnd);
      }
      s = s + str.slice(lastEnd);
      return s;
    }
    module.exports = exports.default;
  }
});

// node_modules/postcss-selector-parser/dist/util/index.js
var require_util = __commonJS({
  "node_modules/postcss-selector-parser/dist/util/index.js"(exports) {
    "use strict";
    exports.__esModule = true;
    exports.unesc = exports.stripComments = exports.getProp = exports.ensureObject = void 0;
    var _unesc = _interopRequireDefault(require_unesc());
    exports.unesc = _unesc["default"];
    var _getProp = _interopRequireDefault(require_getProp());
    exports.getProp = _getProp["default"];
    var _ensureObject = _interopRequireDefault(require_ensureObject());
    exports.ensureObject = _ensureObject["default"];
    var _stripComments = _interopRequireDefault(require_stripComments());
    exports.stripComments = _stripComments["default"];
    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { "default": obj };
    }
  }
});

// node_modules/postcss-selector-parser/dist/selectors/node.js
var require_node = __commonJS({
  "node_modules/postcss-selector-parser/dist/selectors/node.js"(exports, module) {
    "use strict";
    exports.__esModule = true;
    exports["default"] = void 0;
    var _util = require_util();
    function _defineProperties(target, props) {
      for (var i = 0; i < props.length; i++) {
        var descriptor = props[i];
        descriptor.enumerable = descriptor.enumerable || false;
        descriptor.configurable = true;
        if ("value" in descriptor)
          descriptor.writable = true;
        Object.defineProperty(target, descriptor.key, descriptor);
      }
    }
    function _createClass(Constructor, protoProps, staticProps) {
      if (protoProps)
        _defineProperties(Constructor.prototype, protoProps);
      if (staticProps)
        _defineProperties(Constructor, staticProps);
      Object.defineProperty(Constructor, "prototype", { writable: false });
      return Constructor;
    }
    var cloneNode = function cloneNode2(obj, parent) {
      if (typeof obj !== "object" || obj === null) {
        return obj;
      }
      var cloned = new obj.constructor();
      for (var i in obj) {
        if (!obj.hasOwnProperty(i)) {
          continue;
        }
        var value2 = obj[i];
        var type = typeof value2;
        if (i === "parent" && type === "object") {
          if (parent) {
            cloned[i] = parent;
          }
        } else if (value2 instanceof Array) {
          cloned[i] = value2.map(function(j) {
            return cloneNode2(j, cloned);
          });
        } else {
          cloned[i] = cloneNode2(value2, cloned);
        }
      }
      return cloned;
    };
    var Node = function() {
      function Node2(opts) {
        if (opts === void 0) {
          opts = {};
        }
        Object.assign(this, opts);
        this.spaces = this.spaces || {};
        this.spaces.before = this.spaces.before || "";
        this.spaces.after = this.spaces.after || "";
      }
      var _proto = Node2.prototype;
      _proto.remove = function remove() {
        if (this.parent) {
          this.parent.removeChild(this);
        }
        this.parent = void 0;
        return this;
      };
      _proto.replaceWith = function replaceWith() {
        if (this.parent) {
          for (var index in arguments) {
            this.parent.insertBefore(this, arguments[index]);
          }
          this.remove();
        }
        return this;
      };
      _proto.next = function next2() {
        return this.parent.at(this.parent.index(this) + 1);
      };
      _proto.prev = function prev() {
        return this.parent.at(this.parent.index(this) - 1);
      };
      _proto.clone = function clone(overrides) {
        if (overrides === void 0) {
          overrides = {};
        }
        var cloned = cloneNode(this);
        for (var name in overrides) {
          cloned[name] = overrides[name];
        }
        return cloned;
      };
      _proto.appendToPropertyAndEscape = function appendToPropertyAndEscape(name, value2, valueEscaped) {
        if (!this.raws) {
          this.raws = {};
        }
        var originalValue = this[name];
        var originalEscaped = this.raws[name];
        this[name] = originalValue + value2;
        if (originalEscaped || valueEscaped !== value2) {
          this.raws[name] = (originalEscaped || originalValue) + valueEscaped;
        } else {
          delete this.raws[name];
        }
      };
      _proto.setPropertyAndEscape = function setPropertyAndEscape(name, value2, valueEscaped) {
        if (!this.raws) {
          this.raws = {};
        }
        this[name] = value2;
        this.raws[name] = valueEscaped;
      };
      _proto.setPropertyWithoutEscape = function setPropertyWithoutEscape(name, value2) {
        this[name] = value2;
        if (this.raws) {
          delete this.raws[name];
        }
      };
      _proto.isAtPosition = function isAtPosition(line, column) {
        if (this.source && this.source.start && this.source.end) {
          if (this.source.start.line > line) {
            return false;
          }
          if (this.source.end.line < line) {
            return false;
          }
          if (this.source.start.line === line && this.source.start.column > column) {
            return false;
          }
          if (this.source.end.line === line && this.source.end.column < column) {
            return false;
          }
          return true;
        }
        return void 0;
      };
      _proto.stringifyProperty = function stringifyProperty(name) {
        return this.raws && this.raws[name] || this[name];
      };
      _proto.valueToString = function valueToString() {
        return String(this.stringifyProperty("value"));
      };
      _proto.toString = function toString() {
        return [this.rawSpaceBefore, this.valueToString(), this.rawSpaceAfter].join("");
      };
      _createClass(Node2, [{
        key: "rawSpaceBefore",
        get: function get() {
          var rawSpace = this.raws && this.raws.spaces && this.raws.spaces.before;
          if (rawSpace === void 0) {
            rawSpace = this.spaces && this.spaces.before;
          }
          return rawSpace || "";
        },
        set: function set(raw) {
          (0, _util.ensureObject)(this, "raws", "spaces");
          this.raws.spaces.before = raw;
        }
      }, {
        key: "rawSpaceAfter",
        get: function get() {
          var rawSpace = this.raws && this.raws.spaces && this.raws.spaces.after;
          if (rawSpace === void 0) {
            rawSpace = this.spaces.after;
          }
          return rawSpace || "";
        },
        set: function set(raw) {
          (0, _util.ensureObject)(this, "raws", "spaces");
          this.raws.spaces.after = raw;
        }
      }]);
      return Node2;
    }();
    exports["default"] = Node;
    module.exports = exports.default;
  }
});

// node_modules/postcss-selector-parser/dist/selectors/types.js
var require_types = __commonJS({
  "node_modules/postcss-selector-parser/dist/selectors/types.js"(exports) {
    "use strict";
    exports.__esModule = true;
    exports.UNIVERSAL = exports.TAG = exports.STRING = exports.SELECTOR = exports.ROOT = exports.PSEUDO = exports.NESTING = exports.ID = exports.COMMENT = exports.COMBINATOR = exports.CLASS = exports.ATTRIBUTE = void 0;
    var TAG = "tag";
    exports.TAG = TAG;
    var STRING = "string";
    exports.STRING = STRING;
    var SELECTOR = "selector";
    exports.SELECTOR = SELECTOR;
    var ROOT = "root";
    exports.ROOT = ROOT;
    var PSEUDO = "pseudo";
    exports.PSEUDO = PSEUDO;
    var NESTING = "nesting";
    exports.NESTING = NESTING;
    var ID = "id";
    exports.ID = ID;
    var COMMENT = "comment";
    exports.COMMENT = COMMENT;
    var COMBINATOR = "combinator";
    exports.COMBINATOR = COMBINATOR;
    var CLASS = "class";
    exports.CLASS = CLASS;
    var ATTRIBUTE = "attribute";
    exports.ATTRIBUTE = ATTRIBUTE;
    var UNIVERSAL = "universal";
    exports.UNIVERSAL = UNIVERSAL;
  }
});

// node_modules/postcss-selector-parser/dist/selectors/container.js
var require_container = __commonJS({
  "node_modules/postcss-selector-parser/dist/selectors/container.js"(exports, module) {
    "use strict";
    exports.__esModule = true;
    exports["default"] = void 0;
    var _node = _interopRequireDefault(require_node());
    var types = _interopRequireWildcard(require_types());
    function _getRequireWildcardCache(nodeInterop) {
      if (typeof WeakMap !== "function")
        return null;
      var cacheBabelInterop = /* @__PURE__ */ new WeakMap();
      var cacheNodeInterop = /* @__PURE__ */ new WeakMap();
      return (_getRequireWildcardCache = function _getRequireWildcardCache2(nodeInterop2) {
        return nodeInterop2 ? cacheNodeInterop : cacheBabelInterop;
      })(nodeInterop);
    }
    function _interopRequireWildcard(obj, nodeInterop) {
      if (!nodeInterop && obj && obj.__esModule) {
        return obj;
      }
      if (obj === null || typeof obj !== "object" && typeof obj !== "function") {
        return { "default": obj };
      }
      var cache = _getRequireWildcardCache(nodeInterop);
      if (cache && cache.has(obj)) {
        return cache.get(obj);
      }
      var newObj = {};
      var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;
      for (var key in obj) {
        if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) {
          var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;
          if (desc && (desc.get || desc.set)) {
            Object.defineProperty(newObj, key, desc);
          } else {
            newObj[key] = obj[key];
          }
        }
      }
      newObj["default"] = obj;
      if (cache) {
        cache.set(obj, newObj);
      }
      return newObj;
    }
    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { "default": obj };
    }
    function _createForOfIteratorHelperLoose(o, allowArrayLike) {
      var it = typeof Symbol !== "undefined" && o[Symbol.iterator] || o["@@iterator"];
      if (it)
        return (it = it.call(o)).next.bind(it);
      if (Array.isArray(o) || (it = _unsupportedIterableToArray(o)) || allowArrayLike && o && typeof o.length === "number") {
        if (it)
          o = it;
        var i = 0;
        return function() {
          if (i >= o.length)
            return { done: true };
          return { done: false, value: o[i++] };
        };
      }
      throw new TypeError("Invalid attempt to iterate non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method.");
    }
    function _unsupportedIterableToArray(o, minLen) {
      if (!o)
        return;
      if (typeof o === "string")
        return _arrayLikeToArray(o, minLen);
      var n = Object.prototype.toString.call(o).slice(8, -1);
      if (n === "Object" && o.constructor)
        n = o.constructor.name;
      if (n === "Map" || n === "Set")
        return Array.from(o);
      if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n))
        return _arrayLikeToArray(o, minLen);
    }
    function _arrayLikeToArray(arr, len) {
      if (len == null || len > arr.length)
        len = arr.length;
      for (var i = 0, arr2 = new Array(len); i < len; i++) {
        arr2[i] = arr[i];
      }
      return arr2;
    }
    function _defineProperties(target, props) {
      for (var i = 0; i < props.length; i++) {
        var descriptor = props[i];
        descriptor.enumerable = descriptor.enumerable || false;
        descriptor.configurable = true;
        if ("value" in descriptor)
          descriptor.writable = true;
        Object.defineProperty(target, descriptor.key, descriptor);
      }
    }
    function _createClass(Constructor, protoProps, staticProps) {
      if (protoProps)
        _defineProperties(Constructor.prototype, protoProps);
      if (staticProps)
        _defineProperties(Constructor, staticProps);
      Object.defineProperty(Constructor, "prototype", { writable: false });
      return Constructor;
    }
    function _inheritsLoose(subClass, superClass) {
      subClass.prototype = Object.create(superClass.prototype);
      subClass.prototype.constructor = subClass;
      _setPrototypeOf(subClass, superClass);
    }
    function _setPrototypeOf(o, p) {
      _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function _setPrototypeOf2(o2, p2) {
        o2.__proto__ = p2;
        return o2;
      };
      return _setPrototypeOf(o, p);
    }
    var Container = function(_Node) {
      _inheritsLoose(Container2, _Node);
      function Container2(opts) {
        var _this;
        _this = _Node.call(this, opts) || this;
        if (!_this.nodes) {
          _this.nodes = [];
        }
        return _this;
      }
      var _proto = Container2.prototype;
      _proto.append = function append(selector) {
        selector.parent = this;
        this.nodes.push(selector);
        return this;
      };
      _proto.prepend = function prepend(selector) {
        selector.parent = this;
        this.nodes.unshift(selector);
        return this;
      };
      _proto.at = function at(index) {
        return this.nodes[index];
      };
      _proto.index = function index(child) {
        if (typeof child === "number") {
          return child;
        }
        return this.nodes.indexOf(child);
      };
      _proto.removeChild = function removeChild(child) {
        child = this.index(child);
        this.at(child).parent = void 0;
        this.nodes.splice(child, 1);
        var index;
        for (var id in this.indexes) {
          index = this.indexes[id];
          if (index >= child) {
            this.indexes[id] = index - 1;
          }
        }
        return this;
      };
      _proto.removeAll = function removeAll() {
        for (var _iterator = _createForOfIteratorHelperLoose(this.nodes), _step; !(_step = _iterator()).done; ) {
          var node = _step.value;
          node.parent = void 0;
        }
        this.nodes = [];
        return this;
      };
      _proto.empty = function empty() {
        return this.removeAll();
      };
      _proto.insertAfter = function insertAfter(oldNode, newNode) {
        newNode.parent = this;
        var oldIndex = this.index(oldNode);
        this.nodes.splice(oldIndex + 1, 0, newNode);
        newNode.parent = this;
        var index;
        for (var id in this.indexes) {
          index = this.indexes[id];
          if (oldIndex <= index) {
            this.indexes[id] = index + 1;
          }
        }
        return this;
      };
      _proto.insertBefore = function insertBefore(oldNode, newNode) {
        newNode.parent = this;
        var oldIndex = this.index(oldNode);
        this.nodes.splice(oldIndex, 0, newNode);
        newNode.parent = this;
        var index;
        for (var id in this.indexes) {
          index = this.indexes[id];
          if (index <= oldIndex) {
            this.indexes[id] = index + 1;
          }
        }
        return this;
      };
      _proto._findChildAtPosition = function _findChildAtPosition(line, col) {
        var found = void 0;
        this.each(function(node) {
          if (node.atPosition) {
            var foundChild = node.atPosition(line, col);
            if (foundChild) {
              found = foundChild;
              return false;
            }
          } else if (node.isAtPosition(line, col)) {
            found = node;
            return false;
          }
        });
        return found;
      };
      _proto.atPosition = function atPosition(line, col) {
        if (this.isAtPosition(line, col)) {
          return this._findChildAtPosition(line, col) || this;
        } else {
          return void 0;
        }
      };
      _proto._inferEndPosition = function _inferEndPosition() {
        if (this.last && this.last.source && this.last.source.end) {
          this.source = this.source || {};
          this.source.end = this.source.end || {};
          Object.assign(this.source.end, this.last.source.end);
        }
      };
      _proto.each = function each(callback) {
        if (!this.lastEach) {
          this.lastEach = 0;
        }
        if (!this.indexes) {
          this.indexes = {};
        }
        this.lastEach++;
        var id = this.lastEach;
        this.indexes[id] = 0;
        if (!this.length) {
          return void 0;
        }
        var index, result;
        while (this.indexes[id] < this.length) {
          index = this.indexes[id];
          result = callback(this.at(index), index);
          if (result === false) {
            break;
          }
          this.indexes[id] += 1;
        }
        delete this.indexes[id];
        if (result === false) {
          return false;
        }
      };
      _proto.walk = function walk(callback) {
        return this.each(function(node, i) {
          var result = callback(node, i);
          if (result !== false && node.length) {
            result = node.walk(callback);
          }
          if (result === false) {
            return false;
          }
        });
      };
      _proto.walkAttributes = function walkAttributes(callback) {
        var _this2 = this;
        return this.walk(function(selector) {
          if (selector.type === types.ATTRIBUTE) {
            return callback.call(_this2, selector);
          }
        });
      };
      _proto.walkClasses = function walkClasses(callback) {
        var _this3 = this;
        return this.walk(function(selector) {
          if (selector.type === types.CLASS) {
            return callback.call(_this3, selector);
          }
        });
      };
      _proto.walkCombinators = function walkCombinators(callback) {
        var _this4 = this;
        return this.walk(function(selector) {
          if (selector.type === types.COMBINATOR) {
            return callback.call(_this4, selector);
          }
        });
      };
      _proto.walkComments = function walkComments(callback) {
        var _this5 = this;
        return this.walk(function(selector) {
          if (selector.type === types.COMMENT) {
            return callback.call(_this5, selector);
          }
        });
      };
      _proto.walkIds = function walkIds(callback) {
        var _this6 = this;
        return this.walk(function(selector) {
          if (selector.type === types.ID) {
            return callback.call(_this6, selector);
          }
        });
      };
      _proto.walkNesting = function walkNesting(callback) {
        var _this7 = this;
        return this.walk(function(selector) {
          if (selector.type === types.NESTING) {
            return callback.call(_this7, selector);
          }
        });
      };
      _proto.walkPseudos = function walkPseudos(callback) {
        var _this8 = this;
        return this.walk(function(selector) {
          if (selector.type === types.PSEUDO) {
            return callback.call(_this8, selector);
          }
        });
      };
      _proto.walkTags = function walkTags(callback) {
        var _this9 = this;
        return this.walk(function(selector) {
          if (selector.type === types.TAG) {
            return callback.call(_this9, selector);
          }
        });
      };
      _proto.walkUniversals = function walkUniversals(callback) {
        var _this10 = this;
        return this.walk(function(selector) {
          if (selector.type === types.UNIVERSAL) {
            return callback.call(_this10, selector);
          }
        });
      };
      _proto.split = function split(callback) {
        var _this11 = this;
        var current = [];
        return this.reduce(function(memo, node, index) {
          var split2 = callback.call(_this11, node);
          current.push(node);
          if (split2) {
            memo.push(current);
            current = [];
          } else if (index === _this11.length - 1) {
            memo.push(current);
          }
          return memo;
        }, []);
      };
      _proto.map = function map(callback) {
        return this.nodes.map(callback);
      };
      _proto.reduce = function reduce(callback, memo) {
        return this.nodes.reduce(callback, memo);
      };
      _proto.every = function every(callback) {
        return this.nodes.every(callback);
      };
      _proto.some = function some(callback) {
        return this.nodes.some(callback);
      };
      _proto.filter = function filter(callback) {
        return this.nodes.filter(callback);
      };
      _proto.sort = function sort(callback) {
        return this.nodes.sort(callback);
      };
      _proto.toString = function toString() {
        return this.map(String).join("");
      };
      _createClass(Container2, [{
        key: "first",
        get: function get() {
          return this.at(0);
        }
      }, {
        key: "last",
        get: function get() {
          return this.at(this.length - 1);
        }
      }, {
        key: "length",
        get: function get() {
          return this.nodes.length;
        }
      }]);
      return Container2;
    }(_node["default"]);
    exports["default"] = Container;
    module.exports = exports.default;
  }
});

// node_modules/postcss-selector-parser/dist/selectors/root.js
var require_root = __commonJS({
  "node_modules/postcss-selector-parser/dist/selectors/root.js"(exports, module) {
    "use strict";
    exports.__esModule = true;
    exports["default"] = void 0;
    var _container = _interopRequireDefault(require_container());
    var _types = require_types();
    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { "default": obj };
    }
    function _defineProperties(target, props) {
      for (var i = 0; i < props.length; i++) {
        var descriptor = props[i];
        descriptor.enumerable = descriptor.enumerable || false;
        descriptor.configurable = true;
        if ("value" in descriptor)
          descriptor.writable = true;
        Object.defineProperty(target, descriptor.key, descriptor);
      }
    }
    function _createClass(Constructor, protoProps, staticProps) {
      if (protoProps)
        _defineProperties(Constructor.prototype, protoProps);
      if (staticProps)
        _defineProperties(Constructor, staticProps);
      Object.defineProperty(Constructor, "prototype", { writable: false });
      return Constructor;
    }
    function _inheritsLoose(subClass, superClass) {
      subClass.prototype = Object.create(superClass.prototype);
      subClass.prototype.constructor = subClass;
      _setPrototypeOf(subClass, superClass);
    }
    function _setPrototypeOf(o, p) {
      _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function _setPrototypeOf2(o2, p2) {
        o2.__proto__ = p2;
        return o2;
      };
      return _setPrototypeOf(o, p);
    }
    var Root = function(_Container) {
      _inheritsLoose(Root2, _Container);
      function Root2(opts) {
        var _this;
        _this = _Container.call(this, opts) || this;
        _this.type = _types.ROOT;
        return _this;
      }
      var _proto = Root2.prototype;
      _proto.toString = function toString() {
        var str = this.reduce(function(memo, selector) {
          memo.push(String(selector));
          return memo;
        }, []).join(",");
        return this.trailingComma ? str + "," : str;
      };
      _proto.error = function error(message, options) {
        if (this._error) {
          return this._error(message, options);
        } else {
          return new Error(message);
        }
      };
      _createClass(Root2, [{
        key: "errorGenerator",
        set: function set(handler) {
          this._error = handler;
        }
      }]);
      return Root2;
    }(_container["default"]);
    exports["default"] = Root;
    module.exports = exports.default;
  }
});

// node_modules/postcss-selector-parser/dist/selectors/selector.js
var require_selector = __commonJS({
  "node_modules/postcss-selector-parser/dist/selectors/selector.js"(exports, module) {
    "use strict";
    exports.__esModule = true;
    exports["default"] = void 0;
    var _container = _interopRequireDefault(require_container());
    var _types = require_types();
    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { "default": obj };
    }
    function _inheritsLoose(subClass, superClass) {
      subClass.prototype = Object.create(superClass.prototype);
      subClass.prototype.constructor = subClass;
      _setPrototypeOf(subClass, superClass);
    }
    function _setPrototypeOf(o, p) {
      _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function _setPrototypeOf2(o2, p2) {
        o2.__proto__ = p2;
        return o2;
      };
      return _setPrototypeOf(o, p);
    }
    var Selector = function(_Container) {
      _inheritsLoose(Selector2, _Container);
      function Selector2(opts) {
        var _this;
        _this = _Container.call(this, opts) || this;
        _this.type = _types.SELECTOR;
        return _this;
      }
      return Selector2;
    }(_container["default"]);
    exports["default"] = Selector;
    module.exports = exports.default;
  }
});

// node_modules/cssesc/cssesc.js
var require_cssesc = __commonJS({
  "node_modules/cssesc/cssesc.js"(exports, module) {
    "use strict";
    var object = {};
    var hasOwnProperty2 = object.hasOwnProperty;
    var merge = function merge2(options, defaults) {
      if (!options) {
        return defaults;
      }
      var result = {};
      for (var key in defaults) {
        result[key] = hasOwnProperty2.call(options, key) ? options[key] : defaults[key];
      }
      return result;
    };
    var regexAnySingleEscape = /[ -,\.\/:-@\[-\^`\{-~]/;
    var regexSingleEscape = /[ -,\.\/:-@\[\]\^`\{-~]/;
    var regexExcessiveSpaces = /(^|\\+)?(\\[A-F0-9]{1,6})\x20(?![a-fA-F0-9\x20])/g;
    var cssesc = function cssesc2(string, options) {
      options = merge(options, cssesc2.options);
      if (options.quotes != "single" && options.quotes != "double") {
        options.quotes = "single";
      }
      var quote = options.quotes == "double" ? '"' : "'";
      var isIdentifier2 = options.isIdentifier;
      var firstChar = string.charAt(0);
      var output = "";
      var counter = 0;
      var length = string.length;
      while (counter < length) {
        var character = string.charAt(counter++);
        var codePoint = character.charCodeAt();
        var value2 = void 0;
        if (codePoint < 32 || codePoint > 126) {
          if (codePoint >= 55296 && codePoint <= 56319 && counter < length) {
            var extra = string.charCodeAt(counter++);
            if ((extra & 64512) == 56320) {
              codePoint = ((codePoint & 1023) << 10) + (extra & 1023) + 65536;
            } else {
              counter--;
            }
          }
          value2 = "\\" + codePoint.toString(16).toUpperCase() + " ";
        } else {
          if (options.escapeEverything) {
            if (regexAnySingleEscape.test(character)) {
              value2 = "\\" + character;
            } else {
              value2 = "\\" + codePoint.toString(16).toUpperCase() + " ";
            }
          } else if (/[\t\n\f\r\x0B]/.test(character)) {
            value2 = "\\" + codePoint.toString(16).toUpperCase() + " ";
          } else if (character == "\\" || !isIdentifier2 && (character == '"' && quote == character || character == "'" && quote == character) || isIdentifier2 && regexSingleEscape.test(character)) {
            value2 = "\\" + character;
          } else {
            value2 = character;
          }
        }
        output += value2;
      }
      if (isIdentifier2) {
        if (/^-[-\d]/.test(output)) {
          output = "\\-" + output.slice(1);
        } else if (/\d/.test(firstChar)) {
          output = "\\3" + firstChar + " " + output.slice(1);
        }
      }
      output = output.replace(regexExcessiveSpaces, function($0, $1, $2) {
        if ($1 && $1.length % 2) {
          return $0;
        }
        return ($1 || "") + $2;
      });
      if (!isIdentifier2 && options.wrap) {
        return quote + output + quote;
      }
      return output;
    };
    cssesc.options = {
      "escapeEverything": false,
      "isIdentifier": false,
      "quotes": "single",
      "wrap": false
    };
    cssesc.version = "3.0.0";
    module.exports = cssesc;
  }
});

// node_modules/postcss-selector-parser/dist/selectors/className.js
var require_className = __commonJS({
  "node_modules/postcss-selector-parser/dist/selectors/className.js"(exports, module) {
    "use strict";
    exports.__esModule = true;
    exports["default"] = void 0;
    var _cssesc = _interopRequireDefault(require_cssesc());
    var _util = require_util();
    var _node = _interopRequireDefault(require_node());
    var _types = require_types();
    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { "default": obj };
    }
    function _defineProperties(target, props) {
      for (var i = 0; i < props.length; i++) {
        var descriptor = props[i];
        descriptor.enumerable = descriptor.enumerable || false;
        descriptor.configurable = true;
        if ("value" in descriptor)
          descriptor.writable = true;
        Object.defineProperty(target, descriptor.key, descriptor);
      }
    }
    function _createClass(Constructor, protoProps, staticProps) {
      if (protoProps)
        _defineProperties(Constructor.prototype, protoProps);
      if (staticProps)
        _defineProperties(Constructor, staticProps);
      Object.defineProperty(Constructor, "prototype", { writable: false });
      return Constructor;
    }
    function _inheritsLoose(subClass, superClass) {
      subClass.prototype = Object.create(superClass.prototype);
      subClass.prototype.constructor = subClass;
      _setPrototypeOf(subClass, superClass);
    }
    function _setPrototypeOf(o, p) {
      _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function _setPrototypeOf2(o2, p2) {
        o2.__proto__ = p2;
        return o2;
      };
      return _setPrototypeOf(o, p);
    }
    var ClassName = function(_Node) {
      _inheritsLoose(ClassName2, _Node);
      function ClassName2(opts) {
        var _this;
        _this = _Node.call(this, opts) || this;
        _this.type = _types.CLASS;
        _this._constructed = true;
        return _this;
      }
      var _proto = ClassName2.prototype;
      _proto.valueToString = function valueToString() {
        return "." + _Node.prototype.valueToString.call(this);
      };
      _createClass(ClassName2, [{
        key: "value",
        get: function get() {
          return this._value;
        },
        set: function set(v) {
          if (this._constructed) {
            var escaped = (0, _cssesc["default"])(v, {
              isIdentifier: true
            });
            if (escaped !== v) {
              (0, _util.ensureObject)(this, "raws");
              this.raws.value = escaped;
            } else if (this.raws) {
              delete this.raws.value;
            }
          }
          this._value = v;
        }
      }]);
      return ClassName2;
    }(_node["default"]);
    exports["default"] = ClassName;
    module.exports = exports.default;
  }
});

// node_modules/postcss-selector-parser/dist/selectors/comment.js
var require_comment = __commonJS({
  "node_modules/postcss-selector-parser/dist/selectors/comment.js"(exports, module) {
    "use strict";
    exports.__esModule = true;
    exports["default"] = void 0;
    var _node = _interopRequireDefault(require_node());
    var _types = require_types();
    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { "default": obj };
    }
    function _inheritsLoose(subClass, superClass) {
      subClass.prototype = Object.create(superClass.prototype);
      subClass.prototype.constructor = subClass;
      _setPrototypeOf(subClass, superClass);
    }
    function _setPrototypeOf(o, p) {
      _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function _setPrototypeOf2(o2, p2) {
        o2.__proto__ = p2;
        return o2;
      };
      return _setPrototypeOf(o, p);
    }
    var Comment = function(_Node) {
      _inheritsLoose(Comment2, _Node);
      function Comment2(opts) {
        var _this;
        _this = _Node.call(this, opts) || this;
        _this.type = _types.COMMENT;
        return _this;
      }
      return Comment2;
    }(_node["default"]);
    exports["default"] = Comment;
    module.exports = exports.default;
  }
});

// node_modules/postcss-selector-parser/dist/selectors/id.js
var require_id = __commonJS({
  "node_modules/postcss-selector-parser/dist/selectors/id.js"(exports, module) {
    "use strict";
    exports.__esModule = true;
    exports["default"] = void 0;
    var _node = _interopRequireDefault(require_node());
    var _types = require_types();
    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { "default": obj };
    }
    function _inheritsLoose(subClass, superClass) {
      subClass.prototype = Object.create(superClass.prototype);
      subClass.prototype.constructor = subClass;
      _setPrototypeOf(subClass, superClass);
    }
    function _setPrototypeOf(o, p) {
      _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function _setPrototypeOf2(o2, p2) {
        o2.__proto__ = p2;
        return o2;
      };
      return _setPrototypeOf(o, p);
    }
    var ID = function(_Node) {
      _inheritsLoose(ID2, _Node);
      function ID2(opts) {
        var _this;
        _this = _Node.call(this, opts) || this;
        _this.type = _types.ID;
        return _this;
      }
      var _proto = ID2.prototype;
      _proto.valueToString = function valueToString() {
        return "#" + _Node.prototype.valueToString.call(this);
      };
      return ID2;
    }(_node["default"]);
    exports["default"] = ID;
    module.exports = exports.default;
  }
});

// node_modules/postcss-selector-parser/dist/selectors/namespace.js
var require_namespace = __commonJS({
  "node_modules/postcss-selector-parser/dist/selectors/namespace.js"(exports, module) {
    "use strict";
    exports.__esModule = true;
    exports["default"] = void 0;
    var _cssesc = _interopRequireDefault(require_cssesc());
    var _util = require_util();
    var _node = _interopRequireDefault(require_node());
    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { "default": obj };
    }
    function _defineProperties(target, props) {
      for (var i = 0; i < props.length; i++) {
        var descriptor = props[i];
        descriptor.enumerable = descriptor.enumerable || false;
        descriptor.configurable = true;
        if ("value" in descriptor)
          descriptor.writable = true;
        Object.defineProperty(target, descriptor.key, descriptor);
      }
    }
    function _createClass(Constructor, protoProps, staticProps) {
      if (protoProps)
        _defineProperties(Constructor.prototype, protoProps);
      if (staticProps)
        _defineProperties(Constructor, staticProps);
      Object.defineProperty(Constructor, "prototype", { writable: false });
      return Constructor;
    }
    function _inheritsLoose(subClass, superClass) {
      subClass.prototype = Object.create(superClass.prototype);
      subClass.prototype.constructor = subClass;
      _setPrototypeOf(subClass, superClass);
    }
    function _setPrototypeOf(o, p) {
      _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function _setPrototypeOf2(o2, p2) {
        o2.__proto__ = p2;
        return o2;
      };
      return _setPrototypeOf(o, p);
    }
    var Namespace = function(_Node) {
      _inheritsLoose(Namespace2, _Node);
      function Namespace2() {
        return _Node.apply(this, arguments) || this;
      }
      var _proto = Namespace2.prototype;
      _proto.qualifiedName = function qualifiedName(value2) {
        if (this.namespace) {
          return this.namespaceString + "|" + value2;
        } else {
          return value2;
        }
      };
      _proto.valueToString = function valueToString() {
        return this.qualifiedName(_Node.prototype.valueToString.call(this));
      };
      _createClass(Namespace2, [{
        key: "namespace",
        get: function get() {
          return this._namespace;
        },
        set: function set(namespace) {
          if (namespace === true || namespace === "*" || namespace === "&") {
            this._namespace = namespace;
            if (this.raws) {
              delete this.raws.namespace;
            }
            return;
          }
          var escaped = (0, _cssesc["default"])(namespace, {
            isIdentifier: true
          });
          this._namespace = namespace;
          if (escaped !== namespace) {
            (0, _util.ensureObject)(this, "raws");
            this.raws.namespace = escaped;
          } else if (this.raws) {
            delete this.raws.namespace;
          }
        }
      }, {
        key: "ns",
        get: function get() {
          return this._namespace;
        },
        set: function set(namespace) {
          this.namespace = namespace;
        }
      }, {
        key: "namespaceString",
        get: function get() {
          if (this.namespace) {
            var ns = this.stringifyProperty("namespace");
            if (ns === true) {
              return "";
            } else {
              return ns;
            }
          } else {
            return "";
          }
        }
      }]);
      return Namespace2;
    }(_node["default"]);
    exports["default"] = Namespace;
    module.exports = exports.default;
  }
});

// node_modules/postcss-selector-parser/dist/selectors/tag.js
var require_tag = __commonJS({
  "node_modules/postcss-selector-parser/dist/selectors/tag.js"(exports, module) {
    "use strict";
    exports.__esModule = true;
    exports["default"] = void 0;
    var _namespace = _interopRequireDefault(require_namespace());
    var _types = require_types();
    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { "default": obj };
    }
    function _inheritsLoose(subClass, superClass) {
      subClass.prototype = Object.create(superClass.prototype);
      subClass.prototype.constructor = subClass;
      _setPrototypeOf(subClass, superClass);
    }
    function _setPrototypeOf(o, p) {
      _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function _setPrototypeOf2(o2, p2) {
        o2.__proto__ = p2;
        return o2;
      };
      return _setPrototypeOf(o, p);
    }
    var Tag = function(_Namespace) {
      _inheritsLoose(Tag2, _Namespace);
      function Tag2(opts) {
        var _this;
        _this = _Namespace.call(this, opts) || this;
        _this.type = _types.TAG;
        return _this;
      }
      return Tag2;
    }(_namespace["default"]);
    exports["default"] = Tag;
    module.exports = exports.default;
  }
});

// node_modules/postcss-selector-parser/dist/selectors/string.js
var require_string = __commonJS({
  "node_modules/postcss-selector-parser/dist/selectors/string.js"(exports, module) {
    "use strict";
    exports.__esModule = true;
    exports["default"] = void 0;
    var _node = _interopRequireDefault(require_node());
    var _types = require_types();
    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { "default": obj };
    }
    function _inheritsLoose(subClass, superClass) {
      subClass.prototype = Object.create(superClass.prototype);
      subClass.prototype.constructor = subClass;
      _setPrototypeOf(subClass, superClass);
    }
    function _setPrototypeOf(o, p) {
      _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function _setPrototypeOf2(o2, p2) {
        o2.__proto__ = p2;
        return o2;
      };
      return _setPrototypeOf(o, p);
    }
    var String2 = function(_Node) {
      _inheritsLoose(String3, _Node);
      function String3(opts) {
        var _this;
        _this = _Node.call(this, opts) || this;
        _this.type = _types.STRING;
        return _this;
      }
      return String3;
    }(_node["default"]);
    exports["default"] = String2;
    module.exports = exports.default;
  }
});

// node_modules/postcss-selector-parser/dist/selectors/pseudo.js
var require_pseudo = __commonJS({
  "node_modules/postcss-selector-parser/dist/selectors/pseudo.js"(exports, module) {
    "use strict";
    exports.__esModule = true;
    exports["default"] = void 0;
    var _container = _interopRequireDefault(require_container());
    var _types = require_types();
    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { "default": obj };
    }
    function _inheritsLoose(subClass, superClass) {
      subClass.prototype = Object.create(superClass.prototype);
      subClass.prototype.constructor = subClass;
      _setPrototypeOf(subClass, superClass);
    }
    function _setPrototypeOf(o, p) {
      _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function _setPrototypeOf2(o2, p2) {
        o2.__proto__ = p2;
        return o2;
      };
      return _setPrototypeOf(o, p);
    }
    var Pseudo = function(_Container) {
      _inheritsLoose(Pseudo2, _Container);
      function Pseudo2(opts) {
        var _this;
        _this = _Container.call(this, opts) || this;
        _this.type = _types.PSEUDO;
        return _this;
      }
      var _proto = Pseudo2.prototype;
      _proto.toString = function toString() {
        var params = this.length ? "(" + this.map(String).join(",") + ")" : "";
        return [this.rawSpaceBefore, this.stringifyProperty("value"), params, this.rawSpaceAfter].join("");
      };
      return Pseudo2;
    }(_container["default"]);
    exports["default"] = Pseudo;
    module.exports = exports.default;
  }
});

// node_modules/util-deprecate/browser.js
var require_browser = __commonJS({
  "node_modules/util-deprecate/browser.js"(exports, module) {
    module.exports = deprecate;
    function deprecate(fn, msg) {
      if (config("noDeprecation")) {
        return fn;
      }
      var warned = false;
      function deprecated() {
        if (!warned) {
          if (config("throwDeprecation")) {
            throw new Error(msg);
          } else if (config("traceDeprecation")) {
            console.trace(msg);
          } else {
            console.warn(msg);
          }
          warned = true;
        }
        return fn.apply(this, arguments);
      }
      return deprecated;
    }
    function config(name) {
      try {
        if (!global.localStorage)
          return false;
      } catch (_) {
        return false;
      }
      var val = global.localStorage[name];
      if (null == val)
        return false;
      return String(val).toLowerCase() === "true";
    }
  }
});

// node_modules/postcss-selector-parser/dist/selectors/attribute.js
var require_attribute = __commonJS({
  "node_modules/postcss-selector-parser/dist/selectors/attribute.js"(exports) {
    "use strict";
    exports.__esModule = true;
    exports["default"] = void 0;
    exports.unescapeValue = unescapeValue;
    var _cssesc = _interopRequireDefault(require_cssesc());
    var _unesc = _interopRequireDefault(require_unesc());
    var _namespace = _interopRequireDefault(require_namespace());
    var _types = require_types();
    var _CSSESC_QUOTE_OPTIONS;
    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { "default": obj };
    }
    function _defineProperties(target, props) {
      for (var i = 0; i < props.length; i++) {
        var descriptor = props[i];
        descriptor.enumerable = descriptor.enumerable || false;
        descriptor.configurable = true;
        if ("value" in descriptor)
          descriptor.writable = true;
        Object.defineProperty(target, descriptor.key, descriptor);
      }
    }
    function _createClass(Constructor, protoProps, staticProps) {
      if (protoProps)
        _defineProperties(Constructor.prototype, protoProps);
      if (staticProps)
        _defineProperties(Constructor, staticProps);
      Object.defineProperty(Constructor, "prototype", { writable: false });
      return Constructor;
    }
    function _inheritsLoose(subClass, superClass) {
      subClass.prototype = Object.create(superClass.prototype);
      subClass.prototype.constructor = subClass;
      _setPrototypeOf(subClass, superClass);
    }
    function _setPrototypeOf(o, p) {
      _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function _setPrototypeOf2(o2, p2) {
        o2.__proto__ = p2;
        return o2;
      };
      return _setPrototypeOf(o, p);
    }
    var deprecate = require_browser();
    var WRAPPED_IN_QUOTES = /^('|")([^]*)\1$/;
    var warnOfDeprecatedValueAssignment = deprecate(function() {
    }, "Assigning an attribute a value containing characters that might need to be escaped is deprecated. Call attribute.setValue() instead.");
    var warnOfDeprecatedQuotedAssignment = deprecate(function() {
    }, "Assigning attr.quoted is deprecated and has no effect. Assign to attr.quoteMark instead.");
    var warnOfDeprecatedConstructor = deprecate(function() {
    }, "Constructing an Attribute selector with a value without specifying quoteMark is deprecated. Note: The value should be unescaped now.");
    function unescapeValue(value2) {
      var deprecatedUsage = false;
      var quoteMark = null;
      var unescaped = value2;
      var m = unescaped.match(WRAPPED_IN_QUOTES);
      if (m) {
        quoteMark = m[1];
        unescaped = m[2];
      }
      unescaped = (0, _unesc["default"])(unescaped);
      if (unescaped !== value2) {
        deprecatedUsage = true;
      }
      return {
        deprecatedUsage,
        unescaped,
        quoteMark
      };
    }
    function handleDeprecatedContructorOpts(opts) {
      if (opts.quoteMark !== void 0) {
        return opts;
      }
      if (opts.value === void 0) {
        return opts;
      }
      warnOfDeprecatedConstructor();
      var _unescapeValue = unescapeValue(opts.value), quoteMark = _unescapeValue.quoteMark, unescaped = _unescapeValue.unescaped;
      if (!opts.raws) {
        opts.raws = {};
      }
      if (opts.raws.value === void 0) {
        opts.raws.value = opts.value;
      }
      opts.value = unescaped;
      opts.quoteMark = quoteMark;
      return opts;
    }
    var Attribute = function(_Namespace) {
      _inheritsLoose(Attribute2, _Namespace);
      function Attribute2(opts) {
        var _this;
        if (opts === void 0) {
          opts = {};
        }
        _this = _Namespace.call(this, handleDeprecatedContructorOpts(opts)) || this;
        _this.type = _types.ATTRIBUTE;
        _this.raws = _this.raws || {};
        Object.defineProperty(_this.raws, "unquoted", {
          get: deprecate(function() {
            return _this.value;
          }, "attr.raws.unquoted is deprecated. Call attr.value instead."),
          set: deprecate(function() {
            return _this.value;
          }, "Setting attr.raws.unquoted is deprecated and has no effect. attr.value is unescaped by default now.")
        });
        _this._constructed = true;
        return _this;
      }
      var _proto = Attribute2.prototype;
      _proto.getQuotedValue = function getQuotedValue(options) {
        if (options === void 0) {
          options = {};
        }
        var quoteMark = this._determineQuoteMark(options);
        var cssescopts = CSSESC_QUOTE_OPTIONS[quoteMark];
        var escaped = (0, _cssesc["default"])(this._value, cssescopts);
        return escaped;
      };
      _proto._determineQuoteMark = function _determineQuoteMark(options) {
        return options.smart ? this.smartQuoteMark(options) : this.preferredQuoteMark(options);
      };
      _proto.setValue = function setValue(value2, options) {
        if (options === void 0) {
          options = {};
        }
        this._value = value2;
        this._quoteMark = this._determineQuoteMark(options);
        this._syncRawValue();
      };
      _proto.smartQuoteMark = function smartQuoteMark(options) {
        var v = this.value;
        var numSingleQuotes = v.replace(/[^']/g, "").length;
        var numDoubleQuotes = v.replace(/[^"]/g, "").length;
        if (numSingleQuotes + numDoubleQuotes === 0) {
          var escaped = (0, _cssesc["default"])(v, {
            isIdentifier: true
          });
          if (escaped === v) {
            return Attribute2.NO_QUOTE;
          } else {
            var pref = this.preferredQuoteMark(options);
            if (pref === Attribute2.NO_QUOTE) {
              var quote = this.quoteMark || options.quoteMark || Attribute2.DOUBLE_QUOTE;
              var opts = CSSESC_QUOTE_OPTIONS[quote];
              var quoteValue = (0, _cssesc["default"])(v, opts);
              if (quoteValue.length < escaped.length) {
                return quote;
              }
            }
            return pref;
          }
        } else if (numDoubleQuotes === numSingleQuotes) {
          return this.preferredQuoteMark(options);
        } else if (numDoubleQuotes < numSingleQuotes) {
          return Attribute2.DOUBLE_QUOTE;
        } else {
          return Attribute2.SINGLE_QUOTE;
        }
      };
      _proto.preferredQuoteMark = function preferredQuoteMark(options) {
        var quoteMark = options.preferCurrentQuoteMark ? this.quoteMark : options.quoteMark;
        if (quoteMark === void 0) {
          quoteMark = options.preferCurrentQuoteMark ? options.quoteMark : this.quoteMark;
        }
        if (quoteMark === void 0) {
          quoteMark = Attribute2.DOUBLE_QUOTE;
        }
        return quoteMark;
      };
      _proto._syncRawValue = function _syncRawValue() {
        var rawValue = (0, _cssesc["default"])(this._value, CSSESC_QUOTE_OPTIONS[this.quoteMark]);
        if (rawValue === this._value) {
          if (this.raws) {
            delete this.raws.value;
          }
        } else {
          this.raws.value = rawValue;
        }
      };
      _proto._handleEscapes = function _handleEscapes(prop, value2) {
        if (this._constructed) {
          var escaped = (0, _cssesc["default"])(value2, {
            isIdentifier: true
          });
          if (escaped !== value2) {
            this.raws[prop] = escaped;
          } else {
            delete this.raws[prop];
          }
        }
      };
      _proto._spacesFor = function _spacesFor(name) {
        var attrSpaces = {
          before: "",
          after: ""
        };
        var spaces = this.spaces[name] || {};
        var rawSpaces = this.raws.spaces && this.raws.spaces[name] || {};
        return Object.assign(attrSpaces, spaces, rawSpaces);
      };
      _proto._stringFor = function _stringFor(name, spaceName, concat) {
        if (spaceName === void 0) {
          spaceName = name;
        }
        if (concat === void 0) {
          concat = defaultAttrConcat;
        }
        var attrSpaces = this._spacesFor(spaceName);
        return concat(this.stringifyProperty(name), attrSpaces);
      };
      _proto.offsetOf = function offsetOf(name) {
        var count = 1;
        var attributeSpaces = this._spacesFor("attribute");
        count += attributeSpaces.before.length;
        if (name === "namespace" || name === "ns") {
          return this.namespace ? count : -1;
        }
        if (name === "attributeNS") {
          return count;
        }
        count += this.namespaceString.length;
        if (this.namespace) {
          count += 1;
        }
        if (name === "attribute") {
          return count;
        }
        count += this.stringifyProperty("attribute").length;
        count += attributeSpaces.after.length;
        var operatorSpaces = this._spacesFor("operator");
        count += operatorSpaces.before.length;
        var operator = this.stringifyProperty("operator");
        if (name === "operator") {
          return operator ? count : -1;
        }
        count += operator.length;
        count += operatorSpaces.after.length;
        var valueSpaces = this._spacesFor("value");
        count += valueSpaces.before.length;
        var value2 = this.stringifyProperty("value");
        if (name === "value") {
          return value2 ? count : -1;
        }
        count += value2.length;
        count += valueSpaces.after.length;
        var insensitiveSpaces = this._spacesFor("insensitive");
        count += insensitiveSpaces.before.length;
        if (name === "insensitive") {
          return this.insensitive ? count : -1;
        }
        return -1;
      };
      _proto.toString = function toString() {
        var _this2 = this;
        var selector = [this.rawSpaceBefore, "["];
        selector.push(this._stringFor("qualifiedAttribute", "attribute"));
        if (this.operator && (this.value || this.value === "")) {
          selector.push(this._stringFor("operator"));
          selector.push(this._stringFor("value"));
          selector.push(this._stringFor("insensitiveFlag", "insensitive", function(attrValue, attrSpaces) {
            if (attrValue.length > 0 && !_this2.quoted && attrSpaces.before.length === 0 && !(_this2.spaces.value && _this2.spaces.value.after)) {
              attrSpaces.before = " ";
            }
            return defaultAttrConcat(attrValue, attrSpaces);
          }));
        }
        selector.push("]");
        selector.push(this.rawSpaceAfter);
        return selector.join("");
      };
      _createClass(Attribute2, [{
        key: "quoted",
        get: function get() {
          var qm = this.quoteMark;
          return qm === "'" || qm === '"';
        },
        set: function set(value2) {
          warnOfDeprecatedQuotedAssignment();
        }
        /**
         * returns a single (`'`) or double (`"`) quote character if the value is quoted.
         * returns `null` if the value is not quoted.
         * returns `undefined` if the quotation state is unknown (this can happen when
         * the attribute is constructed without specifying a quote mark.)
         */
      }, {
        key: "quoteMark",
        get: function get() {
          return this._quoteMark;
        },
        set: function set(quoteMark) {
          if (!this._constructed) {
            this._quoteMark = quoteMark;
            return;
          }
          if (this._quoteMark !== quoteMark) {
            this._quoteMark = quoteMark;
            this._syncRawValue();
          }
        }
      }, {
        key: "qualifiedAttribute",
        get: function get() {
          return this.qualifiedName(this.raws.attribute || this.attribute);
        }
      }, {
        key: "insensitiveFlag",
        get: function get() {
          return this.insensitive ? "i" : "";
        }
      }, {
        key: "value",
        get: function get() {
          return this._value;
        },
        set: (
          /**
           * Before 3.0, the value had to be set to an escaped value including any wrapped
           * quote marks. In 3.0, the semantics of `Attribute.value` changed so that the value
           * is unescaped during parsing and any quote marks are removed.
           *
           * Because the ambiguity of this semantic change, if you set `attr.value = newValue`,
           * a deprecation warning is raised when the new value contains any characters that would
           * require escaping (including if it contains wrapped quotes).
           *
           * Instead, you should call `attr.setValue(newValue, opts)` and pass options that describe
           * how the new value is quoted.
           */
          function set(v) {
            if (this._constructed) {
              var _unescapeValue2 = unescapeValue(v), deprecatedUsage = _unescapeValue2.deprecatedUsage, unescaped = _unescapeValue2.unescaped, quoteMark = _unescapeValue2.quoteMark;
              if (deprecatedUsage) {
                warnOfDeprecatedValueAssignment();
              }
              if (unescaped === this._value && quoteMark === this._quoteMark) {
                return;
              }
              this._value = unescaped;
              this._quoteMark = quoteMark;
              this._syncRawValue();
            } else {
              this._value = v;
            }
          }
        )
      }, {
        key: "insensitive",
        get: function get() {
          return this._insensitive;
        },
        set: function set(insensitive) {
          if (!insensitive) {
            this._insensitive = false;
            if (this.raws && (this.raws.insensitiveFlag === "I" || this.raws.insensitiveFlag === "i")) {
              this.raws.insensitiveFlag = void 0;
            }
          }
          this._insensitive = insensitive;
        }
      }, {
        key: "attribute",
        get: function get() {
          return this._attribute;
        },
        set: function set(name) {
          this._handleEscapes("attribute", name);
          this._attribute = name;
        }
      }]);
      return Attribute2;
    }(_namespace["default"]);
    exports["default"] = Attribute;
    Attribute.NO_QUOTE = null;
    Attribute.SINGLE_QUOTE = "'";
    Attribute.DOUBLE_QUOTE = '"';
    var CSSESC_QUOTE_OPTIONS = (_CSSESC_QUOTE_OPTIONS = {
      "'": {
        quotes: "single",
        wrap: true
      },
      '"': {
        quotes: "double",
        wrap: true
      }
    }, _CSSESC_QUOTE_OPTIONS[null] = {
      isIdentifier: true
    }, _CSSESC_QUOTE_OPTIONS);
    function defaultAttrConcat(attrValue, attrSpaces) {
      return "" + attrSpaces.before + attrValue + attrSpaces.after;
    }
  }
});

// node_modules/postcss-selector-parser/dist/selectors/universal.js
var require_universal = __commonJS({
  "node_modules/postcss-selector-parser/dist/selectors/universal.js"(exports, module) {
    "use strict";
    exports.__esModule = true;
    exports["default"] = void 0;
    var _namespace = _interopRequireDefault(require_namespace());
    var _types = require_types();
    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { "default": obj };
    }
    function _inheritsLoose(subClass, superClass) {
      subClass.prototype = Object.create(superClass.prototype);
      subClass.prototype.constructor = subClass;
      _setPrototypeOf(subClass, superClass);
    }
    function _setPrototypeOf(o, p) {
      _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function _setPrototypeOf2(o2, p2) {
        o2.__proto__ = p2;
        return o2;
      };
      return _setPrototypeOf(o, p);
    }
    var Universal = function(_Namespace) {
      _inheritsLoose(Universal2, _Namespace);
      function Universal2(opts) {
        var _this;
        _this = _Namespace.call(this, opts) || this;
        _this.type = _types.UNIVERSAL;
        _this.value = "*";
        return _this;
      }
      return Universal2;
    }(_namespace["default"]);
    exports["default"] = Universal;
    module.exports = exports.default;
  }
});

// node_modules/postcss-selector-parser/dist/selectors/combinator.js
var require_combinator = __commonJS({
  "node_modules/postcss-selector-parser/dist/selectors/combinator.js"(exports, module) {
    "use strict";
    exports.__esModule = true;
    exports["default"] = void 0;
    var _node = _interopRequireDefault(require_node());
    var _types = require_types();
    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { "default": obj };
    }
    function _inheritsLoose(subClass, superClass) {
      subClass.prototype = Object.create(superClass.prototype);
      subClass.prototype.constructor = subClass;
      _setPrototypeOf(subClass, superClass);
    }
    function _setPrototypeOf(o, p) {
      _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function _setPrototypeOf2(o2, p2) {
        o2.__proto__ = p2;
        return o2;
      };
      return _setPrototypeOf(o, p);
    }
    var Combinator = function(_Node) {
      _inheritsLoose(Combinator2, _Node);
      function Combinator2(opts) {
        var _this;
        _this = _Node.call(this, opts) || this;
        _this.type = _types.COMBINATOR;
        return _this;
      }
      return Combinator2;
    }(_node["default"]);
    exports["default"] = Combinator;
    module.exports = exports.default;
  }
});

// node_modules/postcss-selector-parser/dist/selectors/nesting.js
var require_nesting = __commonJS({
  "node_modules/postcss-selector-parser/dist/selectors/nesting.js"(exports, module) {
    "use strict";
    exports.__esModule = true;
    exports["default"] = void 0;
    var _node = _interopRequireDefault(require_node());
    var _types = require_types();
    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { "default": obj };
    }
    function _inheritsLoose(subClass, superClass) {
      subClass.prototype = Object.create(superClass.prototype);
      subClass.prototype.constructor = subClass;
      _setPrototypeOf(subClass, superClass);
    }
    function _setPrototypeOf(o, p) {
      _setPrototypeOf = Object.setPrototypeOf ? Object.setPrototypeOf.bind() : function _setPrototypeOf2(o2, p2) {
        o2.__proto__ = p2;
        return o2;
      };
      return _setPrototypeOf(o, p);
    }
    var Nesting = function(_Node) {
      _inheritsLoose(Nesting2, _Node);
      function Nesting2(opts) {
        var _this;
        _this = _Node.call(this, opts) || this;
        _this.type = _types.NESTING;
        _this.value = "&";
        return _this;
      }
      return Nesting2;
    }(_node["default"]);
    exports["default"] = Nesting;
    module.exports = exports.default;
  }
});

// node_modules/postcss-selector-parser/dist/sortAscending.js
var require_sortAscending = __commonJS({
  "node_modules/postcss-selector-parser/dist/sortAscending.js"(exports, module) {
    "use strict";
    exports.__esModule = true;
    exports["default"] = sortAscending;
    function sortAscending(list) {
      return list.sort(function(a, b) {
        return a - b;
      });
    }
    module.exports = exports.default;
  }
});

// node_modules/postcss-selector-parser/dist/tokenTypes.js
var require_tokenTypes = __commonJS({
  "node_modules/postcss-selector-parser/dist/tokenTypes.js"(exports) {
    "use strict";
    exports.__esModule = true;
    exports.word = exports.tilde = exports.tab = exports.str = exports.space = exports.slash = exports.singleQuote = exports.semicolon = exports.plus = exports.pipe = exports.openSquare = exports.openParenthesis = exports.newline = exports.greaterThan = exports.feed = exports.equals = exports.doubleQuote = exports.dollar = exports.cr = exports.comment = exports.comma = exports.combinator = exports.colon = exports.closeSquare = exports.closeParenthesis = exports.caret = exports.bang = exports.backslash = exports.at = exports.asterisk = exports.ampersand = void 0;
    var ampersand = 38;
    exports.ampersand = ampersand;
    var asterisk = 42;
    exports.asterisk = asterisk;
    var at = 64;
    exports.at = at;
    var comma = 44;
    exports.comma = comma;
    var colon = 58;
    exports.colon = colon;
    var semicolon2 = 59;
    exports.semicolon = semicolon2;
    var openParenthesis = 40;
    exports.openParenthesis = openParenthesis;
    var closeParenthesis = 41;
    exports.closeParenthesis = closeParenthesis;
    var openSquare = 91;
    exports.openSquare = openSquare;
    var closeSquare = 93;
    exports.closeSquare = closeSquare;
    var dollar = 36;
    exports.dollar = dollar;
    var tilde = 126;
    exports.tilde = tilde;
    var caret = 94;
    exports.caret = caret;
    var plus = 43;
    exports.plus = plus;
    var equals = 61;
    exports.equals = equals;
    var pipe = 124;
    exports.pipe = pipe;
    var greaterThan = 62;
    exports.greaterThan = greaterThan;
    var space = 32;
    exports.space = space;
    var singleQuote = 39;
    exports.singleQuote = singleQuote;
    var doubleQuote = 34;
    exports.doubleQuote = doubleQuote;
    var slash = 47;
    exports.slash = slash;
    var bang = 33;
    exports.bang = bang;
    var backslash = 92;
    exports.backslash = backslash;
    var cr = 13;
    exports.cr = cr;
    var feed = 12;
    exports.feed = feed;
    var newline = 10;
    exports.newline = newline;
    var tab = 9;
    exports.tab = tab;
    var str = singleQuote;
    exports.str = str;
    var comment = -1;
    exports.comment = comment;
    var word = -2;
    exports.word = word;
    var combinator = -3;
    exports.combinator = combinator;
  }
});

// node_modules/postcss-selector-parser/dist/tokenize.js
var require_tokenize = __commonJS({
  "node_modules/postcss-selector-parser/dist/tokenize.js"(exports) {
    "use strict";
    exports.__esModule = true;
    exports.FIELDS = void 0;
    exports["default"] = tokenize;
    var t2 = _interopRequireWildcard(require_tokenTypes());
    var _unescapable;
    var _wordDelimiters;
    function _getRequireWildcardCache(nodeInterop) {
      if (typeof WeakMap !== "function")
        return null;
      var cacheBabelInterop = /* @__PURE__ */ new WeakMap();
      var cacheNodeInterop = /* @__PURE__ */ new WeakMap();
      return (_getRequireWildcardCache = function _getRequireWildcardCache2(nodeInterop2) {
        return nodeInterop2 ? cacheNodeInterop : cacheBabelInterop;
      })(nodeInterop);
    }
    function _interopRequireWildcard(obj, nodeInterop) {
      if (!nodeInterop && obj && obj.__esModule) {
        return obj;
      }
      if (obj === null || typeof obj !== "object" && typeof obj !== "function") {
        return { "default": obj };
      }
      var cache = _getRequireWildcardCache(nodeInterop);
      if (cache && cache.has(obj)) {
        return cache.get(obj);
      }
      var newObj = {};
      var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;
      for (var key in obj) {
        if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) {
          var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;
          if (desc && (desc.get || desc.set)) {
            Object.defineProperty(newObj, key, desc);
          } else {
            newObj[key] = obj[key];
          }
        }
      }
      newObj["default"] = obj;
      if (cache) {
        cache.set(obj, newObj);
      }
      return newObj;
    }
    var unescapable = (_unescapable = {}, _unescapable[t2.tab] = true, _unescapable[t2.newline] = true, _unescapable[t2.cr] = true, _unescapable[t2.feed] = true, _unescapable);
    var wordDelimiters = (_wordDelimiters = {}, _wordDelimiters[t2.space] = true, _wordDelimiters[t2.tab] = true, _wordDelimiters[t2.newline] = true, _wordDelimiters[t2.cr] = true, _wordDelimiters[t2.feed] = true, _wordDelimiters[t2.ampersand] = true, _wordDelimiters[t2.asterisk] = true, _wordDelimiters[t2.bang] = true, _wordDelimiters[t2.comma] = true, _wordDelimiters[t2.colon] = true, _wordDelimiters[t2.semicolon] = true, _wordDelimiters[t2.openParenthesis] = true, _wordDelimiters[t2.closeParenthesis] = true, _wordDelimiters[t2.openSquare] = true, _wordDelimiters[t2.closeSquare] = true, _wordDelimiters[t2.singleQuote] = true, _wordDelimiters[t2.doubleQuote] = true, _wordDelimiters[t2.plus] = true, _wordDelimiters[t2.pipe] = true, _wordDelimiters[t2.tilde] = true, _wordDelimiters[t2.greaterThan] = true, _wordDelimiters[t2.equals] = true, _wordDelimiters[t2.dollar] = true, _wordDelimiters[t2.caret] = true, _wordDelimiters[t2.slash] = true, _wordDelimiters);
    var hex = {};
    var hexChars = "0123456789abcdefABCDEF";
    for (i = 0; i < hexChars.length; i++) {
      hex[hexChars.charCodeAt(i)] = true;
    }
    var i;
    function consumeWord(css, start) {
      var next2 = start;
      var code;
      do {
        code = css.charCodeAt(next2);
        if (wordDelimiters[code]) {
          return next2 - 1;
        } else if (code === t2.backslash) {
          next2 = consumeEscape(css, next2) + 1;
        } else {
          next2++;
        }
      } while (next2 < css.length);
      return next2 - 1;
    }
    function consumeEscape(css, start) {
      var next2 = start;
      var code = css.charCodeAt(next2 + 1);
      if (unescapable[code]) {
      } else if (hex[code]) {
        var hexDigits = 0;
        do {
          next2++;
          hexDigits++;
          code = css.charCodeAt(next2 + 1);
        } while (hex[code] && hexDigits < 6);
        if (hexDigits < 6 && code === t2.space) {
          next2++;
        }
      } else {
        next2++;
      }
      return next2;
    }
    var FIELDS = {
      TYPE: 0,
      START_LINE: 1,
      START_COL: 2,
      END_LINE: 3,
      END_COL: 4,
      START_POS: 5,
      END_POS: 6
    };
    exports.FIELDS = FIELDS;
    function tokenize(input2) {
      var tokens = [];
      var css = input2.css.valueOf();
      var _css = css, length = _css.length;
      var offset = -1;
      var line = 1;
      var start = 0;
      var end = 0;
      var code, content, endColumn, endLine, escaped, escapePos, last, lines, next2, nextLine, nextOffset, quote, tokenType;
      function unclosed(what, fix) {
        if (input2.safe) {
          css += fix;
          next2 = css.length - 1;
        } else {
          throw input2.error("Unclosed " + what, line, start - offset, start);
        }
      }
      while (start < length) {
        code = css.charCodeAt(start);
        if (code === t2.newline) {
          offset = start;
          line += 1;
        }
        switch (code) {
          case t2.space:
          case t2.tab:
          case t2.newline:
          case t2.cr:
          case t2.feed:
            next2 = start;
            do {
              next2 += 1;
              code = css.charCodeAt(next2);
              if (code === t2.newline) {
                offset = next2;
                line += 1;
              }
            } while (code === t2.space || code === t2.newline || code === t2.tab || code === t2.cr || code === t2.feed);
            tokenType = t2.space;
            endLine = line;
            endColumn = next2 - offset - 1;
            end = next2;
            break;
          case t2.plus:
          case t2.greaterThan:
          case t2.tilde:
          case t2.pipe:
            next2 = start;
            do {
              next2 += 1;
              code = css.charCodeAt(next2);
            } while (code === t2.plus || code === t2.greaterThan || code === t2.tilde || code === t2.pipe);
            tokenType = t2.combinator;
            endLine = line;
            endColumn = start - offset;
            end = next2;
            break;
          case t2.asterisk:
          case t2.ampersand:
          case t2.bang:
          case t2.comma:
          case t2.equals:
          case t2.dollar:
          case t2.caret:
          case t2.openSquare:
          case t2.closeSquare:
          case t2.colon:
          case t2.semicolon:
          case t2.openParenthesis:
          case t2.closeParenthesis:
            next2 = start;
            tokenType = code;
            endLine = line;
            endColumn = start - offset;
            end = next2 + 1;
            break;
          case t2.singleQuote:
          case t2.doubleQuote:
            quote = code === t2.singleQuote ? "'" : '"';
            next2 = start;
            do {
              escaped = false;
              next2 = css.indexOf(quote, next2 + 1);
              if (next2 === -1) {
                unclosed("quote", quote);
              }
              escapePos = next2;
              while (css.charCodeAt(escapePos - 1) === t2.backslash) {
                escapePos -= 1;
                escaped = !escaped;
              }
            } while (escaped);
            tokenType = t2.str;
            endLine = line;
            endColumn = start - offset;
            end = next2 + 1;
            break;
          default:
            if (code === t2.slash && css.charCodeAt(start + 1) === t2.asterisk) {
              next2 = css.indexOf("*/", start + 2) + 1;
              if (next2 === 0) {
                unclosed("comment", "*/");
              }
              content = css.slice(start, next2 + 1);
              lines = content.split("\n");
              last = lines.length - 1;
              if (last > 0) {
                nextLine = line + last;
                nextOffset = next2 - lines[last].length;
              } else {
                nextLine = line;
                nextOffset = offset;
              }
              tokenType = t2.comment;
              line = nextLine;
              endLine = nextLine;
              endColumn = next2 - nextOffset;
            } else if (code === t2.slash) {
              next2 = start;
              tokenType = code;
              endLine = line;
              endColumn = start - offset;
              end = next2 + 1;
            } else {
              next2 = consumeWord(css, start);
              tokenType = t2.word;
              endLine = line;
              endColumn = next2 - offset;
            }
            end = next2 + 1;
            break;
        }
        tokens.push([
          tokenType,
          // [0] Token type
          line,
          // [1] Starting line
          start - offset,
          // [2] Starting column
          endLine,
          // [3] Ending line
          endColumn,
          // [4] Ending column
          start,
          // [5] Start position / Source index
          end
          // [6] End position
        ]);
        if (nextOffset) {
          offset = nextOffset;
          nextOffset = null;
        }
        start = end;
      }
      return tokens;
    }
  }
});

// node_modules/postcss-selector-parser/dist/parser.js
var require_parser = __commonJS({
  "node_modules/postcss-selector-parser/dist/parser.js"(exports, module) {
    "use strict";
    exports.__esModule = true;
    exports["default"] = void 0;
    var _root = _interopRequireDefault(require_root());
    var _selector = _interopRequireDefault(require_selector());
    var _className = _interopRequireDefault(require_className());
    var _comment = _interopRequireDefault(require_comment());
    var _id = _interopRequireDefault(require_id());
    var _tag = _interopRequireDefault(require_tag());
    var _string = _interopRequireDefault(require_string());
    var _pseudo = _interopRequireDefault(require_pseudo());
    var _attribute = _interopRequireWildcard(require_attribute());
    var _universal = _interopRequireDefault(require_universal());
    var _combinator = _interopRequireDefault(require_combinator());
    var _nesting = _interopRequireDefault(require_nesting());
    var _sortAscending = _interopRequireDefault(require_sortAscending());
    var _tokenize = _interopRequireWildcard(require_tokenize());
    var tokens = _interopRequireWildcard(require_tokenTypes());
    var types = _interopRequireWildcard(require_types());
    var _util = require_util();
    var _WHITESPACE_TOKENS;
    var _Object$assign;
    function _getRequireWildcardCache(nodeInterop) {
      if (typeof WeakMap !== "function")
        return null;
      var cacheBabelInterop = /* @__PURE__ */ new WeakMap();
      var cacheNodeInterop = /* @__PURE__ */ new WeakMap();
      return (_getRequireWildcardCache = function _getRequireWildcardCache2(nodeInterop2) {
        return nodeInterop2 ? cacheNodeInterop : cacheBabelInterop;
      })(nodeInterop);
    }
    function _interopRequireWildcard(obj, nodeInterop) {
      if (!nodeInterop && obj && obj.__esModule) {
        return obj;
      }
      if (obj === null || typeof obj !== "object" && typeof obj !== "function") {
        return { "default": obj };
      }
      var cache = _getRequireWildcardCache(nodeInterop);
      if (cache && cache.has(obj)) {
        return cache.get(obj);
      }
      var newObj = {};
      var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;
      for (var key in obj) {
        if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) {
          var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;
          if (desc && (desc.get || desc.set)) {
            Object.defineProperty(newObj, key, desc);
          } else {
            newObj[key] = obj[key];
          }
        }
      }
      newObj["default"] = obj;
      if (cache) {
        cache.set(obj, newObj);
      }
      return newObj;
    }
    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { "default": obj };
    }
    function _defineProperties(target, props) {
      for (var i = 0; i < props.length; i++) {
        var descriptor = props[i];
        descriptor.enumerable = descriptor.enumerable || false;
        descriptor.configurable = true;
        if ("value" in descriptor)
          descriptor.writable = true;
        Object.defineProperty(target, descriptor.key, descriptor);
      }
    }
    function _createClass(Constructor, protoProps, staticProps) {
      if (protoProps)
        _defineProperties(Constructor.prototype, protoProps);
      if (staticProps)
        _defineProperties(Constructor, staticProps);
      Object.defineProperty(Constructor, "prototype", { writable: false });
      return Constructor;
    }
    var WHITESPACE_TOKENS = (_WHITESPACE_TOKENS = {}, _WHITESPACE_TOKENS[tokens.space] = true, _WHITESPACE_TOKENS[tokens.cr] = true, _WHITESPACE_TOKENS[tokens.feed] = true, _WHITESPACE_TOKENS[tokens.newline] = true, _WHITESPACE_TOKENS[tokens.tab] = true, _WHITESPACE_TOKENS);
    var WHITESPACE_EQUIV_TOKENS = Object.assign({}, WHITESPACE_TOKENS, (_Object$assign = {}, _Object$assign[tokens.comment] = true, _Object$assign));
    function tokenStart(token) {
      return {
        line: token[_tokenize.FIELDS.START_LINE],
        column: token[_tokenize.FIELDS.START_COL]
      };
    }
    function tokenEnd(token) {
      return {
        line: token[_tokenize.FIELDS.END_LINE],
        column: token[_tokenize.FIELDS.END_COL]
      };
    }
    function getSource(startLine, startColumn, endLine, endColumn) {
      return {
        start: {
          line: startLine,
          column: startColumn
        },
        end: {
          line: endLine,
          column: endColumn
        }
      };
    }
    function getTokenSource(token) {
      return getSource(token[_tokenize.FIELDS.START_LINE], token[_tokenize.FIELDS.START_COL], token[_tokenize.FIELDS.END_LINE], token[_tokenize.FIELDS.END_COL]);
    }
    function getTokenSourceSpan(startToken, endToken) {
      if (!startToken) {
        return void 0;
      }
      return getSource(startToken[_tokenize.FIELDS.START_LINE], startToken[_tokenize.FIELDS.START_COL], endToken[_tokenize.FIELDS.END_LINE], endToken[_tokenize.FIELDS.END_COL]);
    }
    function unescapeProp(node, prop) {
      var value2 = node[prop];
      if (typeof value2 !== "string") {
        return;
      }
      if (value2.indexOf("\\") !== -1) {
        (0, _util.ensureObject)(node, "raws");
        node[prop] = (0, _util.unesc)(value2);
        if (node.raws[prop] === void 0) {
          node.raws[prop] = value2;
        }
      }
      return node;
    }
    function indexesOf(array2, item) {
      var i = -1;
      var indexes = [];
      while ((i = array2.indexOf(item, i + 1)) !== -1) {
        indexes.push(i);
      }
      return indexes;
    }
    function uniqs() {
      var list = Array.prototype.concat.apply([], arguments);
      return list.filter(function(item, i) {
        return i === list.indexOf(item);
      });
    }
    var Parser = function() {
      function Parser2(rule, options) {
        if (options === void 0) {
          options = {};
        }
        this.rule = rule;
        this.options = Object.assign({
          lossy: false,
          safe: false
        }, options);
        this.position = 0;
        this.css = typeof this.rule === "string" ? this.rule : this.rule.selector;
        this.tokens = (0, _tokenize["default"])({
          css: this.css,
          error: this._errorGenerator(),
          safe: this.options.safe
        });
        var rootSource = getTokenSourceSpan(this.tokens[0], this.tokens[this.tokens.length - 1]);
        this.root = new _root["default"]({
          source: rootSource
        });
        this.root.errorGenerator = this._errorGenerator();
        var selector = new _selector["default"]({
          source: {
            start: {
              line: 1,
              column: 1
            }
          },
          sourceIndex: 0
        });
        this.root.append(selector);
        this.current = selector;
        this.loop();
      }
      var _proto = Parser2.prototype;
      _proto._errorGenerator = function _errorGenerator() {
        var _this = this;
        return function(message, errorOptions) {
          if (typeof _this.rule === "string") {
            return new Error(message);
          }
          return _this.rule.error(message, errorOptions);
        };
      };
      _proto.attribute = function attribute() {
        var attr = [];
        var startingToken = this.currToken;
        this.position++;
        while (this.position < this.tokens.length && this.currToken[_tokenize.FIELDS.TYPE] !== tokens.closeSquare) {
          attr.push(this.currToken);
          this.position++;
        }
        if (this.currToken[_tokenize.FIELDS.TYPE] !== tokens.closeSquare) {
          return this.expected("closing square bracket", this.currToken[_tokenize.FIELDS.START_POS]);
        }
        var len = attr.length;
        var node = {
          source: getSource(startingToken[1], startingToken[2], this.currToken[3], this.currToken[4]),
          sourceIndex: startingToken[_tokenize.FIELDS.START_POS]
        };
        if (len === 1 && !~[tokens.word].indexOf(attr[0][_tokenize.FIELDS.TYPE])) {
          return this.expected("attribute", attr[0][_tokenize.FIELDS.START_POS]);
        }
        var pos = 0;
        var spaceBefore = "";
        var commentBefore = "";
        var lastAdded = null;
        var spaceAfterMeaningfulToken = false;
        while (pos < len) {
          var token = attr[pos];
          var content = this.content(token);
          var next2 = attr[pos + 1];
          switch (token[_tokenize.FIELDS.TYPE]) {
            case tokens.space:
              spaceAfterMeaningfulToken = true;
              if (this.options.lossy) {
                break;
              }
              if (lastAdded) {
                (0, _util.ensureObject)(node, "spaces", lastAdded);
                var prevContent = node.spaces[lastAdded].after || "";
                node.spaces[lastAdded].after = prevContent + content;
                var existingComment = (0, _util.getProp)(node, "raws", "spaces", lastAdded, "after") || null;
                if (existingComment) {
                  node.raws.spaces[lastAdded].after = existingComment + content;
                }
              } else {
                spaceBefore = spaceBefore + content;
                commentBefore = commentBefore + content;
              }
              break;
            case tokens.asterisk:
              if (next2[_tokenize.FIELDS.TYPE] === tokens.equals) {
                node.operator = content;
                lastAdded = "operator";
              } else if ((!node.namespace || lastAdded === "namespace" && !spaceAfterMeaningfulToken) && next2) {
                if (spaceBefore) {
                  (0, _util.ensureObject)(node, "spaces", "attribute");
                  node.spaces.attribute.before = spaceBefore;
                  spaceBefore = "";
                }
                if (commentBefore) {
                  (0, _util.ensureObject)(node, "raws", "spaces", "attribute");
                  node.raws.spaces.attribute.before = spaceBefore;
                  commentBefore = "";
                }
                node.namespace = (node.namespace || "") + content;
                var rawValue = (0, _util.getProp)(node, "raws", "namespace") || null;
                if (rawValue) {
                  node.raws.namespace += content;
                }
                lastAdded = "namespace";
              }
              spaceAfterMeaningfulToken = false;
              break;
            case tokens.dollar:
              if (lastAdded === "value") {
                var oldRawValue = (0, _util.getProp)(node, "raws", "value");
                node.value += "$";
                if (oldRawValue) {
                  node.raws.value = oldRawValue + "$";
                }
                break;
              }
            case tokens.caret:
              if (next2[_tokenize.FIELDS.TYPE] === tokens.equals) {
                node.operator = content;
                lastAdded = "operator";
              }
              spaceAfterMeaningfulToken = false;
              break;
            case tokens.combinator:
              if (content === "~" && next2[_tokenize.FIELDS.TYPE] === tokens.equals) {
                node.operator = content;
                lastAdded = "operator";
              }
              if (content !== "|") {
                spaceAfterMeaningfulToken = false;
                break;
              }
              if (next2[_tokenize.FIELDS.TYPE] === tokens.equals) {
                node.operator = content;
                lastAdded = "operator";
              } else if (!node.namespace && !node.attribute) {
                node.namespace = true;
              }
              spaceAfterMeaningfulToken = false;
              break;
            case tokens.word:
              if (next2 && this.content(next2) === "|" && attr[pos + 2] && attr[pos + 2][_tokenize.FIELDS.TYPE] !== tokens.equals && // this look-ahead probably fails with comment nodes involved.
              !node.operator && !node.namespace) {
                node.namespace = content;
                lastAdded = "namespace";
              } else if (!node.attribute || lastAdded === "attribute" && !spaceAfterMeaningfulToken) {
                if (spaceBefore) {
                  (0, _util.ensureObject)(node, "spaces", "attribute");
                  node.spaces.attribute.before = spaceBefore;
                  spaceBefore = "";
                }
                if (commentBefore) {
                  (0, _util.ensureObject)(node, "raws", "spaces", "attribute");
                  node.raws.spaces.attribute.before = commentBefore;
                  commentBefore = "";
                }
                node.attribute = (node.attribute || "") + content;
                var _rawValue = (0, _util.getProp)(node, "raws", "attribute") || null;
                if (_rawValue) {
                  node.raws.attribute += content;
                }
                lastAdded = "attribute";
              } else if (!node.value && node.value !== "" || lastAdded === "value" && !(spaceAfterMeaningfulToken || node.quoteMark)) {
                var _unescaped = (0, _util.unesc)(content);
                var _oldRawValue = (0, _util.getProp)(node, "raws", "value") || "";
                var oldValue = node.value || "";
                node.value = oldValue + _unescaped;
                node.quoteMark = null;
                if (_unescaped !== content || _oldRawValue) {
                  (0, _util.ensureObject)(node, "raws");
                  node.raws.value = (_oldRawValue || oldValue) + content;
                }
                lastAdded = "value";
              } else {
                var insensitive = content === "i" || content === "I";
                if ((node.value || node.value === "") && (node.quoteMark || spaceAfterMeaningfulToken)) {
                  node.insensitive = insensitive;
                  if (!insensitive || content === "I") {
                    (0, _util.ensureObject)(node, "raws");
                    node.raws.insensitiveFlag = content;
                  }
                  lastAdded = "insensitive";
                  if (spaceBefore) {
                    (0, _util.ensureObject)(node, "spaces", "insensitive");
                    node.spaces.insensitive.before = spaceBefore;
                    spaceBefore = "";
                  }
                  if (commentBefore) {
                    (0, _util.ensureObject)(node, "raws", "spaces", "insensitive");
                    node.raws.spaces.insensitive.before = commentBefore;
                    commentBefore = "";
                  }
                } else if (node.value || node.value === "") {
                  lastAdded = "value";
                  node.value += content;
                  if (node.raws.value) {
                    node.raws.value += content;
                  }
                }
              }
              spaceAfterMeaningfulToken = false;
              break;
            case tokens.str:
              if (!node.attribute || !node.operator) {
                return this.error("Expected an attribute followed by an operator preceding the string.", {
                  index: token[_tokenize.FIELDS.START_POS]
                });
              }
              var _unescapeValue = (0, _attribute.unescapeValue)(content), unescaped = _unescapeValue.unescaped, quoteMark = _unescapeValue.quoteMark;
              node.value = unescaped;
              node.quoteMark = quoteMark;
              lastAdded = "value";
              (0, _util.ensureObject)(node, "raws");
              node.raws.value = content;
              spaceAfterMeaningfulToken = false;
              break;
            case tokens.equals:
              if (!node.attribute) {
                return this.expected("attribute", token[_tokenize.FIELDS.START_POS], content);
              }
              if (node.value) {
                return this.error('Unexpected "=" found; an operator was already defined.', {
                  index: token[_tokenize.FIELDS.START_POS]
                });
              }
              node.operator = node.operator ? node.operator + content : content;
              lastAdded = "operator";
              spaceAfterMeaningfulToken = false;
              break;
            case tokens.comment:
              if (lastAdded) {
                if (spaceAfterMeaningfulToken || next2 && next2[_tokenize.FIELDS.TYPE] === tokens.space || lastAdded === "insensitive") {
                  var lastComment = (0, _util.getProp)(node, "spaces", lastAdded, "after") || "";
                  var rawLastComment = (0, _util.getProp)(node, "raws", "spaces", lastAdded, "after") || lastComment;
                  (0, _util.ensureObject)(node, "raws", "spaces", lastAdded);
                  node.raws.spaces[lastAdded].after = rawLastComment + content;
                } else {
                  var lastValue = node[lastAdded] || "";
                  var rawLastValue = (0, _util.getProp)(node, "raws", lastAdded) || lastValue;
                  (0, _util.ensureObject)(node, "raws");
                  node.raws[lastAdded] = rawLastValue + content;
                }
              } else {
                commentBefore = commentBefore + content;
              }
              break;
            default:
              return this.error('Unexpected "' + content + '" found.', {
                index: token[_tokenize.FIELDS.START_POS]
              });
          }
          pos++;
        }
        unescapeProp(node, "attribute");
        unescapeProp(node, "namespace");
        this.newNode(new _attribute["default"](node));
        this.position++;
      };
      _proto.parseWhitespaceEquivalentTokens = function parseWhitespaceEquivalentTokens(stopPosition) {
        if (stopPosition < 0) {
          stopPosition = this.tokens.length;
        }
        var startPosition = this.position;
        var nodes = [];
        var space = "";
        var lastComment = void 0;
        do {
          if (WHITESPACE_TOKENS[this.currToken[_tokenize.FIELDS.TYPE]]) {
            if (!this.options.lossy) {
              space += this.content();
            }
          } else if (this.currToken[_tokenize.FIELDS.TYPE] === tokens.comment) {
            var spaces = {};
            if (space) {
              spaces.before = space;
              space = "";
            }
            lastComment = new _comment["default"]({
              value: this.content(),
              source: getTokenSource(this.currToken),
              sourceIndex: this.currToken[_tokenize.FIELDS.START_POS],
              spaces
            });
            nodes.push(lastComment);
          }
        } while (++this.position < stopPosition);
        if (space) {
          if (lastComment) {
            lastComment.spaces.after = space;
          } else if (!this.options.lossy) {
            var firstToken = this.tokens[startPosition];
            var lastToken = this.tokens[this.position - 1];
            nodes.push(new _string["default"]({
              value: "",
              source: getSource(firstToken[_tokenize.FIELDS.START_LINE], firstToken[_tokenize.FIELDS.START_COL], lastToken[_tokenize.FIELDS.END_LINE], lastToken[_tokenize.FIELDS.END_COL]),
              sourceIndex: firstToken[_tokenize.FIELDS.START_POS],
              spaces: {
                before: space,
                after: ""
              }
            }));
          }
        }
        return nodes;
      };
      _proto.convertWhitespaceNodesToSpace = function convertWhitespaceNodesToSpace(nodes, requiredSpace) {
        var _this2 = this;
        if (requiredSpace === void 0) {
          requiredSpace = false;
        }
        var space = "";
        var rawSpace = "";
        nodes.forEach(function(n) {
          var spaceBefore = _this2.lossySpace(n.spaces.before, requiredSpace);
          var rawSpaceBefore = _this2.lossySpace(n.rawSpaceBefore, requiredSpace);
          space += spaceBefore + _this2.lossySpace(n.spaces.after, requiredSpace && spaceBefore.length === 0);
          rawSpace += spaceBefore + n.value + _this2.lossySpace(n.rawSpaceAfter, requiredSpace && rawSpaceBefore.length === 0);
        });
        if (rawSpace === space) {
          rawSpace = void 0;
        }
        var result = {
          space,
          rawSpace
        };
        return result;
      };
      _proto.isNamedCombinator = function isNamedCombinator(position) {
        if (position === void 0) {
          position = this.position;
        }
        return this.tokens[position + 0] && this.tokens[position + 0][_tokenize.FIELDS.TYPE] === tokens.slash && this.tokens[position + 1] && this.tokens[position + 1][_tokenize.FIELDS.TYPE] === tokens.word && this.tokens[position + 2] && this.tokens[position + 2][_tokenize.FIELDS.TYPE] === tokens.slash;
      };
      _proto.namedCombinator = function namedCombinator() {
        if (this.isNamedCombinator()) {
          var nameRaw = this.content(this.tokens[this.position + 1]);
          var name = (0, _util.unesc)(nameRaw).toLowerCase();
          var raws = {};
          if (name !== nameRaw) {
            raws.value = "/" + nameRaw + "/";
          }
          var node = new _combinator["default"]({
            value: "/" + name + "/",
            source: getSource(this.currToken[_tokenize.FIELDS.START_LINE], this.currToken[_tokenize.FIELDS.START_COL], this.tokens[this.position + 2][_tokenize.FIELDS.END_LINE], this.tokens[this.position + 2][_tokenize.FIELDS.END_COL]),
            sourceIndex: this.currToken[_tokenize.FIELDS.START_POS],
            raws
          });
          this.position = this.position + 3;
          return node;
        } else {
          this.unexpected();
        }
      };
      _proto.combinator = function combinator() {
        var _this3 = this;
        if (this.content() === "|") {
          return this.namespace();
        }
        var nextSigTokenPos = this.locateNextMeaningfulToken(this.position);
        if (nextSigTokenPos < 0 || this.tokens[nextSigTokenPos][_tokenize.FIELDS.TYPE] === tokens.comma) {
          var nodes = this.parseWhitespaceEquivalentTokens(nextSigTokenPos);
          if (nodes.length > 0) {
            var last = this.current.last;
            if (last) {
              var _this$convertWhitespa = this.convertWhitespaceNodesToSpace(nodes), space = _this$convertWhitespa.space, rawSpace = _this$convertWhitespa.rawSpace;
              if (rawSpace !== void 0) {
                last.rawSpaceAfter += rawSpace;
              }
              last.spaces.after += space;
            } else {
              nodes.forEach(function(n) {
                return _this3.newNode(n);
              });
            }
          }
          return;
        }
        var firstToken = this.currToken;
        var spaceOrDescendantSelectorNodes = void 0;
        if (nextSigTokenPos > this.position) {
          spaceOrDescendantSelectorNodes = this.parseWhitespaceEquivalentTokens(nextSigTokenPos);
        }
        var node;
        if (this.isNamedCombinator()) {
          node = this.namedCombinator();
        } else if (this.currToken[_tokenize.FIELDS.TYPE] === tokens.combinator) {
          node = new _combinator["default"]({
            value: this.content(),
            source: getTokenSource(this.currToken),
            sourceIndex: this.currToken[_tokenize.FIELDS.START_POS]
          });
          this.position++;
        } else if (WHITESPACE_TOKENS[this.currToken[_tokenize.FIELDS.TYPE]]) {
        } else if (!spaceOrDescendantSelectorNodes) {
          this.unexpected();
        }
        if (node) {
          if (spaceOrDescendantSelectorNodes) {
            var _this$convertWhitespa2 = this.convertWhitespaceNodesToSpace(spaceOrDescendantSelectorNodes), _space = _this$convertWhitespa2.space, _rawSpace = _this$convertWhitespa2.rawSpace;
            node.spaces.before = _space;
            node.rawSpaceBefore = _rawSpace;
          }
        } else {
          var _this$convertWhitespa3 = this.convertWhitespaceNodesToSpace(spaceOrDescendantSelectorNodes, true), _space2 = _this$convertWhitespa3.space, _rawSpace2 = _this$convertWhitespa3.rawSpace;
          if (!_rawSpace2) {
            _rawSpace2 = _space2;
          }
          var spaces = {};
          var raws = {
            spaces: {}
          };
          if (_space2.endsWith(" ") && _rawSpace2.endsWith(" ")) {
            spaces.before = _space2.slice(0, _space2.length - 1);
            raws.spaces.before = _rawSpace2.slice(0, _rawSpace2.length - 1);
          } else if (_space2.startsWith(" ") && _rawSpace2.startsWith(" ")) {
            spaces.after = _space2.slice(1);
            raws.spaces.after = _rawSpace2.slice(1);
          } else {
            raws.value = _rawSpace2;
          }
          node = new _combinator["default"]({
            value: " ",
            source: getTokenSourceSpan(firstToken, this.tokens[this.position - 1]),
            sourceIndex: firstToken[_tokenize.FIELDS.START_POS],
            spaces,
            raws
          });
        }
        if (this.currToken && this.currToken[_tokenize.FIELDS.TYPE] === tokens.space) {
          node.spaces.after = this.optionalSpace(this.content());
          this.position++;
        }
        return this.newNode(node);
      };
      _proto.comma = function comma() {
        if (this.position === this.tokens.length - 1) {
          this.root.trailingComma = true;
          this.position++;
          return;
        }
        this.current._inferEndPosition();
        var selector = new _selector["default"]({
          source: {
            start: tokenStart(this.tokens[this.position + 1])
          },
          sourceIndex: this.tokens[this.position + 1][_tokenize.FIELDS.START_POS]
        });
        this.current.parent.append(selector);
        this.current = selector;
        this.position++;
      };
      _proto.comment = function comment() {
        var current = this.currToken;
        this.newNode(new _comment["default"]({
          value: this.content(),
          source: getTokenSource(current),
          sourceIndex: current[_tokenize.FIELDS.START_POS]
        }));
        this.position++;
      };
      _proto.error = function error(message, opts) {
        throw this.root.error(message, opts);
      };
      _proto.missingBackslash = function missingBackslash() {
        return this.error("Expected a backslash preceding the semicolon.", {
          index: this.currToken[_tokenize.FIELDS.START_POS]
        });
      };
      _proto.missingParenthesis = function missingParenthesis() {
        return this.expected("opening parenthesis", this.currToken[_tokenize.FIELDS.START_POS]);
      };
      _proto.missingSquareBracket = function missingSquareBracket() {
        return this.expected("opening square bracket", this.currToken[_tokenize.FIELDS.START_POS]);
      };
      _proto.unexpected = function unexpected2() {
        return this.error("Unexpected '" + this.content() + "'. Escaping special characters with \\ may help.", this.currToken[_tokenize.FIELDS.START_POS]);
      };
      _proto.unexpectedPipe = function unexpectedPipe() {
        return this.error("Unexpected '|'.", this.currToken[_tokenize.FIELDS.START_POS]);
      };
      _proto.namespace = function namespace() {
        var before = this.prevToken && this.content(this.prevToken) || true;
        if (this.nextToken[_tokenize.FIELDS.TYPE] === tokens.word) {
          this.position++;
          return this.word(before);
        } else if (this.nextToken[_tokenize.FIELDS.TYPE] === tokens.asterisk) {
          this.position++;
          return this.universal(before);
        }
        this.unexpectedPipe();
      };
      _proto.nesting = function nesting() {
        if (this.nextToken) {
          var nextContent = this.content(this.nextToken);
          if (nextContent === "|") {
            this.position++;
            return;
          }
        }
        var current = this.currToken;
        this.newNode(new _nesting["default"]({
          value: this.content(),
          source: getTokenSource(current),
          sourceIndex: current[_tokenize.FIELDS.START_POS]
        }));
        this.position++;
      };
      _proto.parentheses = function parentheses() {
        var last = this.current.last;
        var unbalanced = 1;
        this.position++;
        if (last && last.type === types.PSEUDO) {
          var selector = new _selector["default"]({
            source: {
              start: tokenStart(this.tokens[this.position])
            },
            sourceIndex: this.tokens[this.position][_tokenize.FIELDS.START_POS]
          });
          var cache = this.current;
          last.append(selector);
          this.current = selector;
          while (this.position < this.tokens.length && unbalanced) {
            if (this.currToken[_tokenize.FIELDS.TYPE] === tokens.openParenthesis) {
              unbalanced++;
            }
            if (this.currToken[_tokenize.FIELDS.TYPE] === tokens.closeParenthesis) {
              unbalanced--;
            }
            if (unbalanced) {
              this.parse();
            } else {
              this.current.source.end = tokenEnd(this.currToken);
              this.current.parent.source.end = tokenEnd(this.currToken);
              this.position++;
            }
          }
          this.current = cache;
        } else {
          var parenStart = this.currToken;
          var parenValue = "(";
          var parenEnd;
          while (this.position < this.tokens.length && unbalanced) {
            if (this.currToken[_tokenize.FIELDS.TYPE] === tokens.openParenthesis) {
              unbalanced++;
            }
            if (this.currToken[_tokenize.FIELDS.TYPE] === tokens.closeParenthesis) {
              unbalanced--;
            }
            parenEnd = this.currToken;
            parenValue += this.parseParenthesisToken(this.currToken);
            this.position++;
          }
          if (last) {
            last.appendToPropertyAndEscape("value", parenValue, parenValue);
          } else {
            this.newNode(new _string["default"]({
              value: parenValue,
              source: getSource(parenStart[_tokenize.FIELDS.START_LINE], parenStart[_tokenize.FIELDS.START_COL], parenEnd[_tokenize.FIELDS.END_LINE], parenEnd[_tokenize.FIELDS.END_COL]),
              sourceIndex: parenStart[_tokenize.FIELDS.START_POS]
            }));
          }
        }
        if (unbalanced) {
          return this.expected("closing parenthesis", this.currToken[_tokenize.FIELDS.START_POS]);
        }
      };
      _proto.pseudo = function pseudo() {
        var _this4 = this;
        var pseudoStr = "";
        var startingToken = this.currToken;
        while (this.currToken && this.currToken[_tokenize.FIELDS.TYPE] === tokens.colon) {
          pseudoStr += this.content();
          this.position++;
        }
        if (!this.currToken) {
          return this.expected(["pseudo-class", "pseudo-element"], this.position - 1);
        }
        if (this.currToken[_tokenize.FIELDS.TYPE] === tokens.word) {
          this.splitWord(false, function(first, length) {
            pseudoStr += first;
            _this4.newNode(new _pseudo["default"]({
              value: pseudoStr,
              source: getTokenSourceSpan(startingToken, _this4.currToken),
              sourceIndex: startingToken[_tokenize.FIELDS.START_POS]
            }));
            if (length > 1 && _this4.nextToken && _this4.nextToken[_tokenize.FIELDS.TYPE] === tokens.openParenthesis) {
              _this4.error("Misplaced parenthesis.", {
                index: _this4.nextToken[_tokenize.FIELDS.START_POS]
              });
            }
          });
        } else {
          return this.expected(["pseudo-class", "pseudo-element"], this.currToken[_tokenize.FIELDS.START_POS]);
        }
      };
      _proto.space = function space() {
        var content = this.content();
        if (this.position === 0 || this.prevToken[_tokenize.FIELDS.TYPE] === tokens.comma || this.prevToken[_tokenize.FIELDS.TYPE] === tokens.openParenthesis || this.current.nodes.every(function(node) {
          return node.type === "comment";
        })) {
          this.spaces = this.optionalSpace(content);
          this.position++;
        } else if (this.position === this.tokens.length - 1 || this.nextToken[_tokenize.FIELDS.TYPE] === tokens.comma || this.nextToken[_tokenize.FIELDS.TYPE] === tokens.closeParenthesis) {
          this.current.last.spaces.after = this.optionalSpace(content);
          this.position++;
        } else {
          this.combinator();
        }
      };
      _proto.string = function string() {
        var current = this.currToken;
        this.newNode(new _string["default"]({
          value: this.content(),
          source: getTokenSource(current),
          sourceIndex: current[_tokenize.FIELDS.START_POS]
        }));
        this.position++;
      };
      _proto.universal = function universal(namespace) {
        var nextToken2 = this.nextToken;
        if (nextToken2 && this.content(nextToken2) === "|") {
          this.position++;
          return this.namespace();
        }
        var current = this.currToken;
        this.newNode(new _universal["default"]({
          value: this.content(),
          source: getTokenSource(current),
          sourceIndex: current[_tokenize.FIELDS.START_POS]
        }), namespace);
        this.position++;
      };
      _proto.splitWord = function splitWord(namespace, firstCallback) {
        var _this5 = this;
        var nextToken2 = this.nextToken;
        var word = this.content();
        while (nextToken2 && ~[tokens.dollar, tokens.caret, tokens.equals, tokens.word].indexOf(nextToken2[_tokenize.FIELDS.TYPE])) {
          this.position++;
          var current = this.content();
          word += current;
          if (current.lastIndexOf("\\") === current.length - 1) {
            var next2 = this.nextToken;
            if (next2 && next2[_tokenize.FIELDS.TYPE] === tokens.space) {
              word += this.requiredSpace(this.content(next2));
              this.position++;
            }
          }
          nextToken2 = this.nextToken;
        }
        var hasClass = indexesOf(word, ".").filter(function(i) {
          var escapedDot = word[i - 1] === "\\";
          var isKeyframesPercent = /^\d+\.\d+%$/.test(word);
          return !escapedDot && !isKeyframesPercent;
        });
        var hasId = indexesOf(word, "#").filter(function(i) {
          return word[i - 1] !== "\\";
        });
        var interpolations = indexesOf(word, "#{");
        if (interpolations.length) {
          hasId = hasId.filter(function(hashIndex) {
            return !~interpolations.indexOf(hashIndex);
          });
        }
        var indices = (0, _sortAscending["default"])(uniqs([0].concat(hasClass, hasId)));
        indices.forEach(function(ind, i) {
          var index = indices[i + 1] || word.length;
          var value2 = word.slice(ind, index);
          if (i === 0 && firstCallback) {
            return firstCallback.call(_this5, value2, indices.length);
          }
          var node;
          var current2 = _this5.currToken;
          var sourceIndex = current2[_tokenize.FIELDS.START_POS] + indices[i];
          var source = getSource(current2[1], current2[2] + ind, current2[3], current2[2] + (index - 1));
          if (~hasClass.indexOf(ind)) {
            var classNameOpts = {
              value: value2.slice(1),
              source,
              sourceIndex
            };
            node = new _className["default"](unescapeProp(classNameOpts, "value"));
          } else if (~hasId.indexOf(ind)) {
            var idOpts = {
              value: value2.slice(1),
              source,
              sourceIndex
            };
            node = new _id["default"](unescapeProp(idOpts, "value"));
          } else {
            var tagOpts = {
              value: value2,
              source,
              sourceIndex
            };
            unescapeProp(tagOpts, "value");
            node = new _tag["default"](tagOpts);
          }
          _this5.newNode(node, namespace);
          namespace = null;
        });
        this.position++;
      };
      _proto.word = function word(namespace) {
        var nextToken2 = this.nextToken;
        if (nextToken2 && this.content(nextToken2) === "|") {
          this.position++;
          return this.namespace();
        }
        return this.splitWord(namespace);
      };
      _proto.loop = function loop() {
        while (this.position < this.tokens.length) {
          this.parse(true);
        }
        this.current._inferEndPosition();
        return this.root;
      };
      _proto.parse = function parse2(throwOnParenthesis) {
        switch (this.currToken[_tokenize.FIELDS.TYPE]) {
          case tokens.space:
            this.space();
            break;
          case tokens.comment:
            this.comment();
            break;
          case tokens.openParenthesis:
            this.parentheses();
            break;
          case tokens.closeParenthesis:
            if (throwOnParenthesis) {
              this.missingParenthesis();
            }
            break;
          case tokens.openSquare:
            this.attribute();
            break;
          case tokens.dollar:
          case tokens.caret:
          case tokens.equals:
          case tokens.word:
            this.word();
            break;
          case tokens.colon:
            this.pseudo();
            break;
          case tokens.comma:
            this.comma();
            break;
          case tokens.asterisk:
            this.universal();
            break;
          case tokens.ampersand:
            this.nesting();
            break;
          case tokens.slash:
          case tokens.combinator:
            this.combinator();
            break;
          case tokens.str:
            this.string();
            break;
          case tokens.closeSquare:
            this.missingSquareBracket();
          case tokens.semicolon:
            this.missingBackslash();
          default:
            this.unexpected();
        }
      };
      _proto.expected = function expected(description, index, found) {
        if (Array.isArray(description)) {
          var last = description.pop();
          description = description.join(", ") + " or " + last;
        }
        var an = /^[aeiou]/.test(description[0]) ? "an" : "a";
        if (!found) {
          return this.error("Expected " + an + " " + description + ".", {
            index
          });
        }
        return this.error("Expected " + an + " " + description + ', found "' + found + '" instead.', {
          index
        });
      };
      _proto.requiredSpace = function requiredSpace(space) {
        return this.options.lossy ? " " : space;
      };
      _proto.optionalSpace = function optionalSpace(space) {
        return this.options.lossy ? "" : space;
      };
      _proto.lossySpace = function lossySpace(space, required) {
        if (this.options.lossy) {
          return required ? " " : "";
        } else {
          return space;
        }
      };
      _proto.parseParenthesisToken = function parseParenthesisToken(token) {
        var content = this.content(token);
        if (token[_tokenize.FIELDS.TYPE] === tokens.space) {
          return this.requiredSpace(content);
        } else {
          return content;
        }
      };
      _proto.newNode = function newNode(node, namespace) {
        if (namespace) {
          if (/^ +$/.test(namespace)) {
            if (!this.options.lossy) {
              this.spaces = (this.spaces || "") + namespace;
            }
            namespace = true;
          }
          node.namespace = namespace;
          unescapeProp(node, "namespace");
        }
        if (this.spaces) {
          node.spaces.before = this.spaces;
          this.spaces = "";
        }
        return this.current.append(node);
      };
      _proto.content = function content(token) {
        if (token === void 0) {
          token = this.currToken;
        }
        return this.css.slice(token[_tokenize.FIELDS.START_POS], token[_tokenize.FIELDS.END_POS]);
      };
      _proto.locateNextMeaningfulToken = function locateNextMeaningfulToken(startPosition) {
        if (startPosition === void 0) {
          startPosition = this.position + 1;
        }
        var searchPosition = startPosition;
        while (searchPosition < this.tokens.length) {
          if (WHITESPACE_EQUIV_TOKENS[this.tokens[searchPosition][_tokenize.FIELDS.TYPE]]) {
            searchPosition++;
            continue;
          } else {
            return searchPosition;
          }
        }
        return -1;
      };
      _createClass(Parser2, [{
        key: "currToken",
        get: function get() {
          return this.tokens[this.position];
        }
      }, {
        key: "nextToken",
        get: function get() {
          return this.tokens[this.position + 1];
        }
      }, {
        key: "prevToken",
        get: function get() {
          return this.tokens[this.position - 1];
        }
      }]);
      return Parser2;
    }();
    exports["default"] = Parser;
    module.exports = exports.default;
  }
});

// node_modules/postcss-selector-parser/dist/processor.js
var require_processor = __commonJS({
  "node_modules/postcss-selector-parser/dist/processor.js"(exports, module) {
    "use strict";
    exports.__esModule = true;
    exports["default"] = void 0;
    var _parser = _interopRequireDefault(require_parser());
    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { "default": obj };
    }
    var Processor = function() {
      function Processor2(func, options) {
        this.func = func || function noop() {
        };
        this.funcRes = null;
        this.options = options;
      }
      var _proto = Processor2.prototype;
      _proto._shouldUpdateSelector = function _shouldUpdateSelector(rule, options) {
        if (options === void 0) {
          options = {};
        }
        var merged = Object.assign({}, this.options, options);
        if (merged.updateSelector === false) {
          return false;
        } else {
          return typeof rule !== "string";
        }
      };
      _proto._isLossy = function _isLossy(options) {
        if (options === void 0) {
          options = {};
        }
        var merged = Object.assign({}, this.options, options);
        if (merged.lossless === false) {
          return true;
        } else {
          return false;
        }
      };
      _proto._root = function _root(rule, options) {
        if (options === void 0) {
          options = {};
        }
        var parser = new _parser["default"](rule, this._parseOptions(options));
        return parser.root;
      };
      _proto._parseOptions = function _parseOptions(options) {
        return {
          lossy: this._isLossy(options)
        };
      };
      _proto._run = function _run(rule, options) {
        var _this = this;
        if (options === void 0) {
          options = {};
        }
        return new Promise(function(resolve, reject) {
          try {
            var root = _this._root(rule, options);
            Promise.resolve(_this.func(root)).then(function(transform2) {
              var string = void 0;
              if (_this._shouldUpdateSelector(rule, options)) {
                string = root.toString();
                rule.selector = string;
              }
              return {
                transform: transform2,
                root,
                string
              };
            }).then(resolve, reject);
          } catch (e) {
            reject(e);
            return;
          }
        });
      };
      _proto._runSync = function _runSync(rule, options) {
        if (options === void 0) {
          options = {};
        }
        var root = this._root(rule, options);
        var transform2 = this.func(root);
        if (transform2 && typeof transform2.then === "function") {
          throw new Error("Selector processor returned a promise to a synchronous call.");
        }
        var string = void 0;
        if (options.updateSelector && typeof rule !== "string") {
          string = root.toString();
          rule.selector = string;
        }
        return {
          transform: transform2,
          root,
          string
        };
      };
      _proto.ast = function ast(rule, options) {
        return this._run(rule, options).then(function(result) {
          return result.root;
        });
      };
      _proto.astSync = function astSync(rule, options) {
        return this._runSync(rule, options).root;
      };
      _proto.transform = function transform2(rule, options) {
        return this._run(rule, options).then(function(result) {
          return result.transform;
        });
      };
      _proto.transformSync = function transformSync(rule, options) {
        return this._runSync(rule, options).transform;
      };
      _proto.process = function process2(rule, options) {
        return this._run(rule, options).then(function(result) {
          return result.string || result.root.toString();
        });
      };
      _proto.processSync = function processSync(rule, options) {
        var result = this._runSync(rule, options);
        return result.string || result.root.toString();
      };
      return Processor2;
    }();
    exports["default"] = Processor;
    module.exports = exports.default;
  }
});

// node_modules/postcss-selector-parser/dist/selectors/constructors.js
var require_constructors = __commonJS({
  "node_modules/postcss-selector-parser/dist/selectors/constructors.js"(exports) {
    "use strict";
    exports.__esModule = true;
    exports.universal = exports.tag = exports.string = exports.selector = exports.root = exports.pseudo = exports.nesting = exports.id = exports.comment = exports.combinator = exports.className = exports.attribute = void 0;
    var _attribute = _interopRequireDefault(require_attribute());
    var _className = _interopRequireDefault(require_className());
    var _combinator = _interopRequireDefault(require_combinator());
    var _comment = _interopRequireDefault(require_comment());
    var _id = _interopRequireDefault(require_id());
    var _nesting = _interopRequireDefault(require_nesting());
    var _pseudo = _interopRequireDefault(require_pseudo());
    var _root = _interopRequireDefault(require_root());
    var _selector = _interopRequireDefault(require_selector());
    var _string = _interopRequireDefault(require_string());
    var _tag = _interopRequireDefault(require_tag());
    var _universal = _interopRequireDefault(require_universal());
    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { "default": obj };
    }
    var attribute = function attribute2(opts) {
      return new _attribute["default"](opts);
    };
    exports.attribute = attribute;
    var className = function className2(opts) {
      return new _className["default"](opts);
    };
    exports.className = className;
    var combinator = function combinator2(opts) {
      return new _combinator["default"](opts);
    };
    exports.combinator = combinator;
    var comment = function comment2(opts) {
      return new _comment["default"](opts);
    };
    exports.comment = comment;
    var id = function id2(opts) {
      return new _id["default"](opts);
    };
    exports.id = id;
    var nesting = function nesting2(opts) {
      return new _nesting["default"](opts);
    };
    exports.nesting = nesting;
    var pseudo = function pseudo2(opts) {
      return new _pseudo["default"](opts);
    };
    exports.pseudo = pseudo;
    var root = function root2(opts) {
      return new _root["default"](opts);
    };
    exports.root = root;
    var selector = function selector2(opts) {
      return new _selector["default"](opts);
    };
    exports.selector = selector;
    var string = function string2(opts) {
      return new _string["default"](opts);
    };
    exports.string = string;
    var tag = function tag2(opts) {
      return new _tag["default"](opts);
    };
    exports.tag = tag;
    var universal = function universal2(opts) {
      return new _universal["default"](opts);
    };
    exports.universal = universal;
  }
});

// node_modules/postcss-selector-parser/dist/selectors/guards.js
var require_guards = __commonJS({
  "node_modules/postcss-selector-parser/dist/selectors/guards.js"(exports) {
    "use strict";
    exports.__esModule = true;
    exports.isComment = exports.isCombinator = exports.isClassName = exports.isAttribute = void 0;
    exports.isContainer = isContainer;
    exports.isIdentifier = void 0;
    exports.isNamespace = isNamespace;
    exports.isNesting = void 0;
    exports.isNode = isNode;
    exports.isPseudo = void 0;
    exports.isPseudoClass = isPseudoClass;
    exports.isPseudoElement = isPseudoElement;
    exports.isUniversal = exports.isTag = exports.isString = exports.isSelector = exports.isRoot = void 0;
    var _types = require_types();
    var _IS_TYPE;
    var IS_TYPE = (_IS_TYPE = {}, _IS_TYPE[_types.ATTRIBUTE] = true, _IS_TYPE[_types.CLASS] = true, _IS_TYPE[_types.COMBINATOR] = true, _IS_TYPE[_types.COMMENT] = true, _IS_TYPE[_types.ID] = true, _IS_TYPE[_types.NESTING] = true, _IS_TYPE[_types.PSEUDO] = true, _IS_TYPE[_types.ROOT] = true, _IS_TYPE[_types.SELECTOR] = true, _IS_TYPE[_types.STRING] = true, _IS_TYPE[_types.TAG] = true, _IS_TYPE[_types.UNIVERSAL] = true, _IS_TYPE);
    function isNode(node) {
      return typeof node === "object" && IS_TYPE[node.type];
    }
    function isNodeType(type, node) {
      return isNode(node) && node.type === type;
    }
    var isAttribute = isNodeType.bind(null, _types.ATTRIBUTE);
    exports.isAttribute = isAttribute;
    var isClassName = isNodeType.bind(null, _types.CLASS);
    exports.isClassName = isClassName;
    var isCombinator = isNodeType.bind(null, _types.COMBINATOR);
    exports.isCombinator = isCombinator;
    var isComment = isNodeType.bind(null, _types.COMMENT);
    exports.isComment = isComment;
    var isIdentifier2 = isNodeType.bind(null, _types.ID);
    exports.isIdentifier = isIdentifier2;
    var isNesting = isNodeType.bind(null, _types.NESTING);
    exports.isNesting = isNesting;
    var isPseudo = isNodeType.bind(null, _types.PSEUDO);
    exports.isPseudo = isPseudo;
    var isRoot = isNodeType.bind(null, _types.ROOT);
    exports.isRoot = isRoot;
    var isSelector = isNodeType.bind(null, _types.SELECTOR);
    exports.isSelector = isSelector;
    var isString = isNodeType.bind(null, _types.STRING);
    exports.isString = isString;
    var isTag = isNodeType.bind(null, _types.TAG);
    exports.isTag = isTag;
    var isUniversal = isNodeType.bind(null, _types.UNIVERSAL);
    exports.isUniversal = isUniversal;
    function isPseudoElement(node) {
      return isPseudo(node) && node.value && (node.value.startsWith("::") || node.value.toLowerCase() === ":before" || node.value.toLowerCase() === ":after" || node.value.toLowerCase() === ":first-letter" || node.value.toLowerCase() === ":first-line");
    }
    function isPseudoClass(node) {
      return isPseudo(node) && !isPseudoElement(node);
    }
    function isContainer(node) {
      return !!(isNode(node) && node.walk);
    }
    function isNamespace(node) {
      return isAttribute(node) || isTag(node);
    }
  }
});

// node_modules/postcss-selector-parser/dist/selectors/index.js
var require_selectors = __commonJS({
  "node_modules/postcss-selector-parser/dist/selectors/index.js"(exports) {
    "use strict";
    exports.__esModule = true;
    var _types = require_types();
    Object.keys(_types).forEach(function(key) {
      if (key === "default" || key === "__esModule")
        return;
      if (key in exports && exports[key] === _types[key])
        return;
      exports[key] = _types[key];
    });
    var _constructors = require_constructors();
    Object.keys(_constructors).forEach(function(key) {
      if (key === "default" || key === "__esModule")
        return;
      if (key in exports && exports[key] === _constructors[key])
        return;
      exports[key] = _constructors[key];
    });
    var _guards = require_guards();
    Object.keys(_guards).forEach(function(key) {
      if (key === "default" || key === "__esModule")
        return;
      if (key in exports && exports[key] === _guards[key])
        return;
      exports[key] = _guards[key];
    });
  }
});

// node_modules/postcss-selector-parser/dist/index.js
var require_dist = __commonJS({
  "node_modules/postcss-selector-parser/dist/index.js"(exports, module) {
    "use strict";
    exports.__esModule = true;
    exports["default"] = void 0;
    var _processor = _interopRequireDefault(require_processor());
    var selectors = _interopRequireWildcard(require_selectors());
    function _getRequireWildcardCache(nodeInterop) {
      if (typeof WeakMap !== "function")
        return null;
      var cacheBabelInterop = /* @__PURE__ */ new WeakMap();
      var cacheNodeInterop = /* @__PURE__ */ new WeakMap();
      return (_getRequireWildcardCache = function _getRequireWildcardCache2(nodeInterop2) {
        return nodeInterop2 ? cacheNodeInterop : cacheBabelInterop;
      })(nodeInterop);
    }
    function _interopRequireWildcard(obj, nodeInterop) {
      if (!nodeInterop && obj && obj.__esModule) {
        return obj;
      }
      if (obj === null || typeof obj !== "object" && typeof obj !== "function") {
        return { "default": obj };
      }
      var cache = _getRequireWildcardCache(nodeInterop);
      if (cache && cache.has(obj)) {
        return cache.get(obj);
      }
      var newObj = {};
      var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;
      for (var key in obj) {
        if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) {
          var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;
          if (desc && (desc.get || desc.set)) {
            Object.defineProperty(newObj, key, desc);
          } else {
            newObj[key] = obj[key];
          }
        }
      }
      newObj["default"] = obj;
      if (cache) {
        cache.set(obj, newObj);
      }
      return newObj;
    }
    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { "default": obj };
    }
    var parser = function parser2(processor) {
      return new _processor["default"](processor);
    };
    Object.assign(parser, selectors);
    delete parser.__esModule;
    var _default = parser;
    exports["default"] = _default;
    module.exports = exports.default;
  }
});

// node_modules/tailwindcss/lib/util/transformThemeValue.js
var require_transformThemeValue = __commonJS({
  "node_modules/tailwindcss/lib/util/transformThemeValue.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    Object.defineProperty(exports, "default", {
      enumerable: true,
      get: function() {
        return transformThemeValue;
      }
    });
    var _postcss = _interop_require_default(require_postcss());
    var _isPlainObject = _interop_require_default(require_isPlainObject());
    function _interop_require_default(obj) {
      return obj && obj.__esModule ? obj : {
        default: obj
      };
    }
    function transformThemeValue(themeSection) {
      if ([
        "fontSize",
        "outline"
      ].includes(themeSection)) {
        return (value2) => {
          if (typeof value2 === "function")
            value2 = value2({});
          if (Array.isArray(value2))
            value2 = value2[0];
          return value2;
        };
      }
      if (themeSection === "fontFamily") {
        return (value2) => {
          if (typeof value2 === "function")
            value2 = value2({});
          let families = Array.isArray(value2) && (0, _isPlainObject.default)(value2[1]) ? value2[0] : value2;
          return Array.isArray(families) ? families.join(", ") : families;
        };
      }
      if ([
        "boxShadow",
        "transitionProperty",
        "transitionDuration",
        "transitionDelay",
        "transitionTimingFunction",
        "backgroundImage",
        "backgroundSize",
        "backgroundColor",
        "cursor",
        "animation"
      ].includes(themeSection)) {
        return (value2) => {
          if (typeof value2 === "function")
            value2 = value2({});
          if (Array.isArray(value2))
            value2 = value2.join(", ");
          return value2;
        };
      }
      if ([
        "gridTemplateColumns",
        "gridTemplateRows",
        "objectPosition"
      ].includes(themeSection)) {
        return (value2) => {
          if (typeof value2 === "function")
            value2 = value2({});
          if (typeof value2 === "string")
            value2 = _postcss.default.list.comma(value2).join(" ");
          return value2;
        };
      }
      return (value2, opts = {}) => {
        if (typeof value2 === "function") {
          value2 = value2(opts);
        }
        return value2;
      };
    }
  }
});

// node_modules/postcss-nested/index.js
var require_postcss_nested = __commonJS({
  "node_modules/postcss-nested/index.js"(exports, module) {
    var { Rule, AtRule } = require_postcss();
    var parser = require_dist();
    function parse2(rawSelector, rule) {
      let nodes;
      try {
        parser((parsed) => {
          nodes = parsed;
        }).processSync(rawSelector);
      } catch (e) {
        if (rawSelector.includes(":")) {
          throw rule ? rule.error("Missed semicolon") : e;
        } else {
          throw rule ? rule.error(e.message) : e;
        }
      }
      return nodes.at(0);
    }
    function interpolateAmpInSelector(nodes, parent) {
      let replaced = false;
      nodes.each((node) => {
        if (node.type === "nesting") {
          let clonedParent = parent.clone({});
          if (node.value !== "&") {
            node.replaceWith(
              parse2(node.value.replace("&", clonedParent.toString()))
            );
          } else {
            node.replaceWith(clonedParent);
          }
          replaced = true;
        } else if ("nodes" in node && node.nodes) {
          if (interpolateAmpInSelector(node, parent)) {
            replaced = true;
          }
        }
      });
      return replaced;
    }
    function mergeSelectors(parent, child) {
      let merged = [];
      parent.selectors.forEach((sel) => {
        let parentNode = parse2(sel, parent);
        child.selectors.forEach((selector) => {
          if (!selector) {
            return;
          }
          let node = parse2(selector, child);
          let replaced = interpolateAmpInSelector(node, parentNode);
          if (!replaced) {
            node.prepend(parser.combinator({ value: " " }));
            node.prepend(parentNode.clone({}));
          }
          merged.push(node.toString());
        });
      });
      return merged;
    }
    function breakOut(child, after) {
      let prev = child.prev();
      after.after(child);
      while (prev && prev.type === "comment") {
        let nextPrev = prev.prev();
        after.after(prev);
        prev = nextPrev;
      }
      return child;
    }
    function createFnAtruleChilds(bubble) {
      return function atruleChilds(rule, atrule, bubbling, mergeSels = bubbling) {
        let children = [];
        atrule.each((child) => {
          if (child.type === "rule" && bubbling) {
            if (mergeSels) {
              child.selectors = mergeSelectors(rule, child);
            }
          } else if (child.type === "atrule" && child.nodes) {
            if (bubble[child.name]) {
              atruleChilds(rule, child, mergeSels);
            } else if (atrule[rootRuleMergeSel] !== false) {
              children.push(child);
            }
          } else {
            children.push(child);
          }
        });
        if (bubbling) {
          if (children.length) {
            let clone = rule.clone({ nodes: [] });
            for (let child of children) {
              clone.append(child);
            }
            atrule.prepend(clone);
          }
        }
      };
    }
    function pickDeclarations(selector, declarations, after) {
      let parent = new Rule({
        selector,
        nodes: []
      });
      parent.append(declarations);
      after.after(parent);
      return parent;
    }
    function atruleNames(defaults, custom) {
      let list = {};
      for (let name of defaults) {
        list[name] = true;
      }
      if (custom) {
        for (let name of custom) {
          list[name.replace(/^@/, "")] = true;
        }
      }
      return list;
    }
    function parseRootRuleParams(params) {
      params = params.trim();
      let braceBlock = params.match(/^\((.*)\)$/);
      if (!braceBlock) {
        return { type: "basic", selector: params };
      }
      let bits = braceBlock[1].match(/^(with(?:out)?):(.+)$/);
      if (bits) {
        let allowlist = bits[1] === "with";
        let rules = Object.fromEntries(
          bits[2].trim().split(/\s+/).map((name) => [name, true])
        );
        if (allowlist && rules.all) {
          return { type: "noop" };
        }
        let escapes = (rule) => !!rules[rule];
        if (rules.all) {
          escapes = () => true;
        } else if (allowlist) {
          escapes = (rule) => rule === "all" ? false : !rules[rule];
        }
        return {
          type: "withrules",
          escapes
        };
      }
      return { type: "unknown" };
    }
    function getAncestorRules(leaf) {
      let lineage = [];
      let parent = leaf.parent;
      while (parent && parent instanceof AtRule) {
        lineage.push(parent);
        parent = parent.parent;
      }
      return lineage;
    }
    function unwrapRootRule(rule) {
      let escapes = rule[rootRuleEscapes];
      if (!escapes) {
        rule.after(rule.nodes);
      } else {
        let nodes = rule.nodes;
        let topEscaped;
        let topEscapedIdx = -1;
        let breakoutLeaf;
        let breakoutRoot;
        let clone;
        let lineage = getAncestorRules(rule);
        lineage.forEach((parent, i) => {
          if (escapes(parent.name)) {
            topEscaped = parent;
            topEscapedIdx = i;
            breakoutRoot = clone;
          } else {
            let oldClone = clone;
            clone = parent.clone({ nodes: [] });
            oldClone && clone.append(oldClone);
            breakoutLeaf = breakoutLeaf || clone;
          }
        });
        if (!topEscaped) {
          rule.after(nodes);
        } else if (!breakoutRoot) {
          topEscaped.after(nodes);
        } else {
          let leaf = breakoutLeaf;
          leaf.append(nodes);
          topEscaped.after(breakoutRoot);
        }
        if (rule.next() && topEscaped) {
          let restRoot;
          lineage.slice(0, topEscapedIdx + 1).forEach((parent, i, arr) => {
            let oldRoot = restRoot;
            restRoot = parent.clone({ nodes: [] });
            oldRoot && restRoot.append(oldRoot);
            let nextSibs = [];
            let _child = arr[i - 1] || rule;
            let next2 = _child.next();
            while (next2) {
              nextSibs.push(next2);
              next2 = next2.next();
            }
            restRoot.append(nextSibs);
          });
          restRoot && (breakoutRoot || nodes[nodes.length - 1]).after(restRoot);
        }
      }
      rule.remove();
    }
    var rootRuleMergeSel = Symbol("rootRuleMergeSel");
    var rootRuleEscapes = Symbol("rootRuleEscapes");
    function normalizeRootRule(rule) {
      let { params } = rule;
      let { type, selector, escapes } = parseRootRuleParams(params);
      if (type === "unknown") {
        throw rule.error(
          `Unknown @${rule.name} parameter ${JSON.stringify(params)}`
        );
      }
      if (type === "basic" && selector) {
        let selectorBlock = new Rule({ selector, nodes: rule.nodes });
        rule.removeAll();
        rule.append(selectorBlock);
      }
      rule[rootRuleEscapes] = escapes;
      rule[rootRuleMergeSel] = escapes ? !escapes("all") : type === "noop";
    }
    var hasRootRule = Symbol("hasRootRule");
    module.exports = (opts = {}) => {
      let bubble = atruleNames(
        ["media", "supports", "layer", "container"],
        opts.bubble
      );
      let atruleChilds = createFnAtruleChilds(bubble);
      let unwrap = atruleNames(
        [
          "document",
          "font-face",
          "keyframes",
          "-webkit-keyframes",
          "-moz-keyframes"
        ],
        opts.unwrap
      );
      let rootRuleName = (opts.rootRuleName || "at-root").replace(/^@/, "");
      let preserveEmpty = opts.preserveEmpty;
      return {
        postcssPlugin: "postcss-nested",
        Once(root) {
          root.walkAtRules(rootRuleName, (node) => {
            normalizeRootRule(node);
            root[hasRootRule] = true;
          });
        },
        Rule(rule) {
          let unwrapped = false;
          let after = rule;
          let copyDeclarations = false;
          let declarations = [];
          rule.each((child) => {
            if (child.type === "rule") {
              if (declarations.length) {
                after = pickDeclarations(rule.selector, declarations, after);
                declarations = [];
              }
              copyDeclarations = true;
              unwrapped = true;
              child.selectors = mergeSelectors(rule, child);
              after = breakOut(child, after);
            } else if (child.type === "atrule") {
              if (declarations.length) {
                after = pickDeclarations(rule.selector, declarations, after);
                declarations = [];
              }
              if (child.name === rootRuleName) {
                unwrapped = true;
                atruleChilds(rule, child, true, child[rootRuleMergeSel]);
                after = breakOut(child, after);
              } else if (bubble[child.name]) {
                copyDeclarations = true;
                unwrapped = true;
                atruleChilds(rule, child, true);
                after = breakOut(child, after);
              } else if (unwrap[child.name]) {
                copyDeclarations = true;
                unwrapped = true;
                atruleChilds(rule, child, false);
                after = breakOut(child, after);
              } else if (copyDeclarations) {
                declarations.push(child);
              }
            } else if (child.type === "decl" && copyDeclarations) {
              declarations.push(child);
            }
          });
          if (declarations.length) {
            after = pickDeclarations(rule.selector, declarations, after);
          }
          if (unwrapped && preserveEmpty !== true) {
            rule.raws.semicolon = true;
            if (rule.nodes.length === 0)
              rule.remove();
          }
        },
        RootExit(root) {
          if (root[hasRootRule]) {
            root.walkAtRules(rootRuleName, unwrapRootRule);
            root[hasRootRule] = false;
          }
        }
      };
    };
    module.exports.postcss = true;
  }
});

// node_modules/camelcase-css/index-es5.js
var require_index_es5 = __commonJS({
  "node_modules/camelcase-css/index-es5.js"(exports, module) {
    "use strict";
    var pattern = /-(\w|$)/g;
    var callback = function callback2(dashChar, char) {
      return char.toUpperCase();
    };
    var camelCaseCSS = function camelCaseCSS2(property) {
      property = property.toLowerCase();
      if (property === "float") {
        return "cssFloat";
      } else if (property.charCodeAt(0) === 45 && property.charCodeAt(1) === 109 && property.charCodeAt(2) === 115 && property.charCodeAt(3) === 45) {
        return property.substr(1).replace(pattern, callback);
      } else {
        return property.replace(pattern, callback);
      }
    };
    module.exports = camelCaseCSS;
  }
});

// node_modules/postcss-js/objectifier.js
var require_objectifier = __commonJS({
  "node_modules/postcss-js/objectifier.js"(exports, module) {
    var camelcase = require_index_es5();
    var UNITLESS = {
      boxFlex: true,
      boxFlexGroup: true,
      columnCount: true,
      flex: true,
      flexGrow: true,
      flexPositive: true,
      flexShrink: true,
      flexNegative: true,
      fontWeight: true,
      lineClamp: true,
      lineHeight: true,
      opacity: true,
      order: true,
      orphans: true,
      tabSize: true,
      widows: true,
      zIndex: true,
      zoom: true,
      fillOpacity: true,
      strokeDashoffset: true,
      strokeOpacity: true,
      strokeWidth: true
    };
    function atRule(node) {
      if (typeof node.nodes === "undefined") {
        return true;
      } else {
        return process2(node);
      }
    }
    function process2(node) {
      let name;
      let result = {};
      node.each((child) => {
        if (child.type === "atrule") {
          name = "@" + child.name;
          if (child.params)
            name += " " + child.params;
          if (typeof result[name] === "undefined") {
            result[name] = atRule(child);
          } else if (Array.isArray(result[name])) {
            result[name].push(atRule(child));
          } else {
            result[name] = [result[name], atRule(child)];
          }
        } else if (child.type === "rule") {
          let body = process2(child);
          if (result[child.selector]) {
            for (let i in body) {
              result[child.selector][i] = body[i];
            }
          } else {
            result[child.selector] = body;
          }
        } else if (child.type === "decl") {
          if (child.prop[0] === "-" && child.prop[1] === "-") {
            name = child.prop;
          } else if (child.parent && child.parent.selector === ":export") {
            name = child.prop;
          } else {
            name = camelcase(child.prop);
          }
          let value2 = child.value;
          if (!isNaN(child.value) && UNITLESS[name]) {
            value2 = parseFloat(child.value);
          }
          if (child.important)
            value2 += " !important";
          if (typeof result[name] === "undefined") {
            result[name] = value2;
          } else if (Array.isArray(result[name])) {
            result[name].push(value2);
          } else {
            result[name] = [result[name], value2];
          }
        }
      });
      return result;
    }
    module.exports = process2;
  }
});

// node_modules/postcss-js/parser.js
var require_parser2 = __commonJS({
  "node_modules/postcss-js/parser.js"(exports, module) {
    var postcss = require_postcss();
    var IMPORTANT = /\s*!important\s*$/i;
    var UNITLESS = {
      "box-flex": true,
      "box-flex-group": true,
      "column-count": true,
      "flex": true,
      "flex-grow": true,
      "flex-positive": true,
      "flex-shrink": true,
      "flex-negative": true,
      "font-weight": true,
      "line-clamp": true,
      "line-height": true,
      "opacity": true,
      "order": true,
      "orphans": true,
      "tab-size": true,
      "widows": true,
      "z-index": true,
      "zoom": true,
      "fill-opacity": true,
      "stroke-dashoffset": true,
      "stroke-opacity": true,
      "stroke-width": true
    };
    function dashify(str) {
      return str.replace(/([A-Z])/g, "-$1").replace(/^ms-/, "-ms-").toLowerCase();
    }
    function decl(parent, name, value2) {
      if (value2 === false || value2 === null)
        return;
      if (!name.startsWith("--")) {
        name = dashify(name);
      }
      if (typeof value2 === "number") {
        if (value2 === 0 || UNITLESS[name]) {
          value2 = value2.toString();
        } else {
          value2 += "px";
        }
      }
      if (name === "css-float")
        name = "float";
      if (IMPORTANT.test(value2)) {
        value2 = value2.replace(IMPORTANT, "");
        parent.push(postcss.decl({ prop: name, value: value2, important: true }));
      } else {
        parent.push(postcss.decl({ prop: name, value: value2 }));
      }
    }
    function atRule(parent, parts, value2) {
      let node = postcss.atRule({ name: parts[1], params: parts[3] || "" });
      if (typeof value2 === "object") {
        node.nodes = [];
        parse2(value2, node);
      }
      parent.push(node);
    }
    function parse2(obj, parent) {
      let name, value2, node;
      for (name in obj) {
        value2 = obj[name];
        if (value2 === null || typeof value2 === "undefined") {
          continue;
        } else if (name[0] === "@") {
          let parts = name.match(/@(\S+)(\s+([\W\w]*)\s*)?/);
          if (Array.isArray(value2)) {
            for (let i of value2) {
              atRule(parent, parts, i);
            }
          } else {
            atRule(parent, parts, value2);
          }
        } else if (Array.isArray(value2)) {
          for (let i of value2) {
            decl(parent, name, i);
          }
        } else if (typeof value2 === "object") {
          node = postcss.rule({ selector: name });
          parse2(value2, node);
          parent.push(node);
        } else {
          decl(parent, name, value2);
        }
      }
    }
    module.exports = function(obj) {
      let root = postcss.root();
      parse2(obj, root);
      return root;
    };
  }
});

// node_modules/postcss-js/process-result.js
var require_process_result = __commonJS({
  "node_modules/postcss-js/process-result.js"(exports, module) {
    var objectify = require_objectifier();
    module.exports = function processResult(result) {
      if (console && console.warn) {
        result.warnings().forEach((warn) => {
          let source = warn.plugin || "PostCSS";
          console.warn(source + ": " + warn.text);
        });
      }
      return objectify(result.root);
    };
  }
});

// node_modules/postcss-js/async.js
var require_async = __commonJS({
  "node_modules/postcss-js/async.js"(exports, module) {
    var postcss = require_postcss();
    var processResult = require_process_result();
    var parse2 = require_parser2();
    module.exports = function async(plugins) {
      let processor = postcss(plugins);
      return async (input2) => {
        let result = await processor.process(input2, {
          parser: parse2,
          from: void 0
        });
        return processResult(result);
      };
    };
  }
});

// node_modules/postcss-js/sync.js
var require_sync = __commonJS({
  "node_modules/postcss-js/sync.js"(exports, module) {
    var postcss = require_postcss();
    var processResult = require_process_result();
    var parse2 = require_parser2();
    module.exports = function(plugins) {
      let processor = postcss(plugins);
      return (input2) => {
        let result = processor.process(input2, { parser: parse2, from: void 0 });
        return processResult(result);
      };
    };
  }
});

// node_modules/postcss-js/index.js
var require_postcss_js = __commonJS({
  "node_modules/postcss-js/index.js"(exports, module) {
    var objectify = require_objectifier();
    var parse2 = require_parser2();
    var async = require_async();
    var sync = require_sync();
    module.exports = {
      objectify,
      parse: parse2,
      async,
      sync
    };
  }
});

// node_modules/tailwindcss/lib/util/parseObjectStyles.js
var require_parseObjectStyles = __commonJS({
  "node_modules/tailwindcss/lib/util/parseObjectStyles.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    Object.defineProperty(exports, "default", {
      enumerable: true,
      get: function() {
        return parseObjectStyles;
      }
    });
    var _postcss = _interop_require_default(require_postcss());
    var _postcssnested = _interop_require_default(require_postcss_nested());
    var _postcssjs = _interop_require_default(require_postcss_js());
    function _interop_require_default(obj) {
      return obj && obj.__esModule ? obj : {
        default: obj
      };
    }
    function parseObjectStyles(styles) {
      if (!Array.isArray(styles)) {
        return parseObjectStyles([
          styles
        ]);
      }
      return styles.flatMap((style) => {
        return (0, _postcss.default)([
          (0, _postcssnested.default)({
            bubble: [
              "screen"
            ]
          })
        ]).process(style, {
          parser: _postcssjs.default
        }).root.nodes;
      });
    }
  }
});

// node_modules/tailwindcss/lib/util/prefixSelector.js
var require_prefixSelector = __commonJS({
  "node_modules/tailwindcss/lib/util/prefixSelector.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    Object.defineProperty(
      exports,
      /**
      * @template {string | import('postcss-selector-parser').Root} T
      *
      * Prefix all classes in the selector with the given prefix
      *
      * It can take either a string or a selector AST and will return the same type
      *
      * @param {string} prefix
      * @param {T} selector
      * @param {boolean} prependNegative
      * @returns {T}
      */
      "default",
      {
        enumerable: true,
        get: function() {
          return _default;
        }
      }
    );
    var _postcssselectorparser = _interop_require_default(require_dist());
    function _interop_require_default(obj) {
      return obj && obj.__esModule ? obj : {
        default: obj
      };
    }
    function _default(prefix, selector, prependNegative = false) {
      if (prefix === "") {
        return selector;
      }
      let ast = typeof selector === "string" ? (0, _postcssselectorparser.default)().astSync(selector) : selector;
      ast.walkClasses((classSelector) => {
        let baseClass = classSelector.value;
        let shouldPlaceNegativeBeforePrefix = prependNegative && baseClass.startsWith("-");
        classSelector.value = shouldPlaceNegativeBeforePrefix ? `-${prefix}${baseClass.slice(1)}` : `${prefix}${baseClass}`;
      });
      return typeof selector === "string" ? ast.toString() : ast;
    }
  }
});

// node_modules/tailwindcss/lib/util/escapeClassName.js
var require_escapeClassName = __commonJS({
  "node_modules/tailwindcss/lib/util/escapeClassName.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    Object.defineProperty(exports, "default", {
      enumerable: true,
      get: function() {
        return escapeClassName;
      }
    });
    var _postcssselectorparser = _interop_require_default(require_dist());
    var _escapeCommas = _interop_require_default(require_escapeCommas());
    function _interop_require_default(obj) {
      return obj && obj.__esModule ? obj : {
        default: obj
      };
    }
    function escapeClassName(className) {
      var _node_raws;
      let node = _postcssselectorparser.default.className();
      node.value = className;
      var _node_raws_value;
      return (0, _escapeCommas.default)((_node_raws_value = node === null || node === void 0 ? void 0 : (_node_raws = node.raws) === null || _node_raws === void 0 ? void 0 : _node_raws.value) !== null && _node_raws_value !== void 0 ? _node_raws_value : node.value);
    }
  }
});

// node_modules/tailwindcss/lib/util/nameClass.js
var require_nameClass = __commonJS({
  "node_modules/tailwindcss/lib/util/nameClass.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    function _export(target, all) {
      for (var name in all)
        Object.defineProperty(target, name, {
          enumerable: true,
          get: all[name]
        });
    }
    _export(exports, {
      asClass: function() {
        return asClass;
      },
      default: function() {
        return nameClass;
      },
      formatClass: function() {
        return formatClass;
      }
    });
    var _escapeClassName = _interop_require_default(require_escapeClassName());
    var _escapeCommas = _interop_require_default(require_escapeCommas());
    function _interop_require_default(obj) {
      return obj && obj.__esModule ? obj : {
        default: obj
      };
    }
    function asClass(name) {
      return (0, _escapeCommas.default)(`.${(0, _escapeClassName.default)(name)}`);
    }
    function nameClass(classPrefix, key) {
      return asClass(formatClass(classPrefix, key));
    }
    function formatClass(classPrefix, key) {
      if (key === "DEFAULT") {
        return classPrefix;
      }
      if (key === "-" || key === "-DEFAULT") {
        return `-${classPrefix}`;
      }
      if (key.startsWith("-")) {
        return `-${classPrefix}${key}`;
      }
      if (key.startsWith("/")) {
        return `${classPrefix}${key}`;
      }
      return `${classPrefix}-${key}`;
    }
  }
});

// node_modules/tailwindcss/lib/util/createUtilityPlugin.js
var require_createUtilityPlugin = __commonJS({
  "node_modules/tailwindcss/lib/util/createUtilityPlugin.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    Object.defineProperty(exports, "default", {
      enumerable: true,
      get: function() {
        return createUtilityPlugin;
      }
    });
    var _transformThemeValue = _interop_require_default(require_transformThemeValue());
    function _interop_require_default(obj) {
      return obj && obj.__esModule ? obj : {
        default: obj
      };
    }
    function createUtilityPlugin(themeKey, utilityVariations = [
      [
        themeKey,
        [
          themeKey
        ]
      ]
    ], { filterDefault = false, ...options } = {}) {
      let transformValue = (0, _transformThemeValue.default)(themeKey);
      return function({ matchUtilities, theme }) {
        for (let utilityVariation of utilityVariations) {
          let group = Array.isArray(utilityVariation[0]) ? utilityVariation : [
            utilityVariation
          ];
          var _theme;
          matchUtilities(group.reduce((obj, [classPrefix, properties]) => {
            return Object.assign(obj, {
              [classPrefix]: (value2) => {
                return properties.reduce((obj2, name) => {
                  if (Array.isArray(name)) {
                    return Object.assign(obj2, {
                      [name[0]]: name[1]
                    });
                  }
                  return Object.assign(obj2, {
                    [name]: transformValue(value2)
                  });
                }, {});
              }
            });
          }, {}), {
            ...options,
            values: filterDefault ? Object.fromEntries(Object.entries((_theme = theme(themeKey)) !== null && _theme !== void 0 ? _theme : {}).filter(([modifier]) => modifier !== "DEFAULT")) : theme(themeKey)
          });
        }
      };
    }
  }
});

// node_modules/tailwindcss/lib/util/buildMediaQuery.js
var require_buildMediaQuery = __commonJS({
  "node_modules/tailwindcss/lib/util/buildMediaQuery.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    Object.defineProperty(exports, "default", {
      enumerable: true,
      get: function() {
        return buildMediaQuery;
      }
    });
    function buildMediaQuery(screens) {
      screens = Array.isArray(screens) ? screens : [
        screens
      ];
      return screens.map((screen) => {
        let values = screen.values.map((screen2) => {
          if (screen2.raw !== void 0) {
            return screen2.raw;
          }
          return [
            screen2.min && `(min-width: ${screen2.min})`,
            screen2.max && `(max-width: ${screen2.max})`
          ].filter(Boolean).join(" and ");
        });
        return screen.not ? `not all and ${values}` : values;
      }).join(", ");
    }
  }
});

// node_modules/tailwindcss/lib/util/parseAnimationValue.js
var require_parseAnimationValue = __commonJS({
  "node_modules/tailwindcss/lib/util/parseAnimationValue.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    Object.defineProperty(exports, "default", {
      enumerable: true,
      get: function() {
        return parseAnimationValue;
      }
    });
    var DIRECTIONS = /* @__PURE__ */ new Set([
      "normal",
      "reverse",
      "alternate",
      "alternate-reverse"
    ]);
    var PLAY_STATES = /* @__PURE__ */ new Set([
      "running",
      "paused"
    ]);
    var FILL_MODES = /* @__PURE__ */ new Set([
      "none",
      "forwards",
      "backwards",
      "both"
    ]);
    var ITERATION_COUNTS = /* @__PURE__ */ new Set([
      "infinite"
    ]);
    var TIMINGS = /* @__PURE__ */ new Set([
      "linear",
      "ease",
      "ease-in",
      "ease-out",
      "ease-in-out",
      "step-start",
      "step-end"
    ]);
    var TIMING_FNS = [
      "cubic-bezier",
      "steps"
    ];
    var COMMA = /\,(?![^(]*\))/g;
    var SPACE = /\ +(?![^(]*\))/g;
    var TIME = /^(-?[\d.]+m?s)$/;
    var DIGIT = /^(\d+)$/;
    function parseAnimationValue(input2) {
      let animations = input2.split(COMMA);
      return animations.map((animation) => {
        let value2 = animation.trim();
        let result = {
          value: value2
        };
        let parts = value2.split(SPACE);
        let seen = /* @__PURE__ */ new Set();
        for (let part of parts) {
          if (!seen.has("DIRECTIONS") && DIRECTIONS.has(part)) {
            result.direction = part;
            seen.add("DIRECTIONS");
          } else if (!seen.has("PLAY_STATES") && PLAY_STATES.has(part)) {
            result.playState = part;
            seen.add("PLAY_STATES");
          } else if (!seen.has("FILL_MODES") && FILL_MODES.has(part)) {
            result.fillMode = part;
            seen.add("FILL_MODES");
          } else if (!seen.has("ITERATION_COUNTS") && (ITERATION_COUNTS.has(part) || DIGIT.test(part))) {
            result.iterationCount = part;
            seen.add("ITERATION_COUNTS");
          } else if (!seen.has("TIMING_FUNCTION") && TIMINGS.has(part)) {
            result.timingFunction = part;
            seen.add("TIMING_FUNCTION");
          } else if (!seen.has("TIMING_FUNCTION") && TIMING_FNS.some((f) => part.startsWith(`${f}(`))) {
            result.timingFunction = part;
            seen.add("TIMING_FUNCTION");
          } else if (!seen.has("DURATION") && TIME.test(part)) {
            result.duration = part;
            seen.add("DURATION");
          } else if (!seen.has("DELAY") && TIME.test(part)) {
            result.delay = part;
            seen.add("DELAY");
          } else if (!seen.has("NAME")) {
            result.name = part;
            seen.add("NAME");
          } else {
            if (!result.unknown)
              result.unknown = [];
            result.unknown.push(part);
          }
        }
        return result;
      });
    }
  }
});

// node_modules/tailwindcss/lib/util/flattenColorPalette.js
var require_flattenColorPalette = __commonJS({
  "node_modules/tailwindcss/lib/util/flattenColorPalette.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    Object.defineProperty(exports, "default", {
      enumerable: true,
      get: function() {
        return _default;
      }
    });
    var flattenColorPalette = (colors) => Object.assign({}, ...Object.entries(colors !== null && colors !== void 0 ? colors : {}).flatMap(([color, values]) => typeof values == "object" ? Object.entries(flattenColorPalette(values)).map(([number, hex]) => ({
      [color + (number === "DEFAULT" ? "" : `-${number}`)]: hex
    })) : [
      {
        [`${color}`]: values
      }
    ]));
    var _default = flattenColorPalette;
  }
});

// node_modules/tailwindcss/package.json
var require_package = __commonJS({
  "node_modules/tailwindcss/package.json"(exports, module) {
    module.exports = {
      name: "tailwindcss",
      version: "3.4.4",
      description: "A utility-first CSS framework for rapidly building custom user interfaces.",
      license: "MIT",
      main: "lib/index.js",
      types: "types/index.d.ts",
      repository: "https://github.com/tailwindlabs/tailwindcss.git",
      bugs: "https://github.com/tailwindlabs/tailwindcss/issues",
      homepage: "https://tailwindcss.com",
      bin: {
        tailwind: "lib/cli.js",
        tailwindcss: "lib/cli.js"
      },
      scripts: {
        prebuild: "npm run generate && rimraf lib",
        build: "swc src --out-dir lib --copy-files",
        postbuild: "esbuild lib/cli-peer-dependencies.js --bundle --platform=node --outfile=peers/index.js --define:process.env.CSS_TRANSFORMER_WASM=false",
        "rebuild-fixtures": "npm run build && node -r @swc/register scripts/rebuildFixtures.js",
        style: "eslint .",
        pretest: "npm run generate",
        test: "jest",
        "test:integrations": "npm run test --prefix ./integrations",
        "install:integrations": "node scripts/install-integrations.js",
        "generate:plugin-list": "node -r @swc/register scripts/create-plugin-list.js",
        "generate:types": "node -r @swc/register scripts/generate-types.js",
        generate: "npm run generate:plugin-list && npm run generate:types",
        "release-channel": "node ./scripts/release-channel.js",
        "release-notes": "node ./scripts/release-notes.js",
        prepublishOnly: "npm install --force && npm run build"
      },
      files: [
        "src/*",
        "cli/*",
        "lib/*",
        "peers/*",
        "scripts/*.js",
        "stubs/*",
        "nesting/*",
        "types/**/*",
        "*.d.ts",
        "*.css",
        "*.js"
      ],
      devDependencies: {
        "@swc/cli": "^0.1.62",
        "@swc/core": "^1.3.55",
        "@swc/jest": "^0.2.26",
        "@swc/register": "^0.1.10",
        autoprefixer: "^10.4.14",
        browserslist: "^4.21.5",
        concurrently: "^8.0.1",
        cssnano: "^6.0.0",
        esbuild: "^0.20.2",
        eslint: "^8.39.0",
        "eslint-config-prettier": "^8.8.0",
        "eslint-plugin-prettier": "^4.2.1",
        jest: "^29.6.0",
        "jest-diff": "^29.6.0",
        lightningcss: "1.24.1",
        prettier: "^2.8.8",
        rimraf: "^5.0.0",
        "source-map-js": "^1.0.2",
        turbo: "^1.9.3"
      },
      dependencies: {
        "@alloc/quick-lru": "^5.2.0",
        arg: "^5.0.2",
        chokidar: "^3.5.3",
        didyoumean: "^1.2.2",
        dlv: "^1.1.3",
        "fast-glob": "^3.3.0",
        "glob-parent": "^6.0.2",
        "is-glob": "^4.0.3",
        jiti: "^1.21.0",
        lilconfig: "^2.1.0",
        micromatch: "^4.0.5",
        "normalize-path": "^3.0.0",
        "object-hash": "^3.0.0",
        picocolors: "^1.0.0",
        postcss: "^8.4.23",
        "postcss-import": "^15.1.0",
        "postcss-js": "^4.0.1",
        "postcss-load-config": "^4.0.1",
        "postcss-nested": "^6.0.1",
        "postcss-selector-parser": "^6.0.11",
        resolve: "^1.22.2",
        sucrase: "^3.32.0"
      },
      browserslist: [
        "> 1%",
        "not edge <= 18",
        "not ie 11",
        "not op_mini all"
      ],
      jest: {
        testTimeout: 3e4,
        setupFilesAfterEnv: [
          "<rootDir>/jest/customMatchers.js"
        ],
        testPathIgnorePatterns: [
          "/node_modules/",
          "/integrations/",
          "/standalone-cli/",
          "\\.test\\.skip\\.js$"
        ],
        transformIgnorePatterns: [
          "node_modules/(?!lightningcss)"
        ],
        transform: {
          "\\.js$": "@swc/jest",
          "\\.ts$": "@swc/jest"
        }
      },
      engines: {
        node: ">=14.0.0"
      }
    };
  }
});

// node_modules/tailwindcss/lib/util/normalizeScreens.js
var require_normalizeScreens = __commonJS({
  "node_modules/tailwindcss/lib/util/normalizeScreens.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    function _export(target, all) {
      for (var name in all)
        Object.defineProperty(target, name, {
          enumerable: true,
          get: all[name]
        });
    }
    _export(exports, {
      normalizeScreens: function() {
        return normalizeScreens;
      },
      isScreenSortable: function() {
        return isScreenSortable;
      },
      compareScreens: function() {
        return compareScreens;
      },
      toScreen: function() {
        return toScreen;
      }
    });
    function normalizeScreens(screens, root = true) {
      if (Array.isArray(screens)) {
        return screens.map((screen) => {
          if (root && Array.isArray(screen)) {
            throw new Error("The tuple syntax is not supported for `screens`.");
          }
          if (typeof screen === "string") {
            return {
              name: screen.toString(),
              not: false,
              values: [
                {
                  min: screen,
                  max: void 0
                }
              ]
            };
          }
          let [name, options] = screen;
          name = name.toString();
          if (typeof options === "string") {
            return {
              name,
              not: false,
              values: [
                {
                  min: options,
                  max: void 0
                }
              ]
            };
          }
          if (Array.isArray(options)) {
            return {
              name,
              not: false,
              values: options.map((option) => resolveValue(option))
            };
          }
          return {
            name,
            not: false,
            values: [
              resolveValue(options)
            ]
          };
        });
      }
      return normalizeScreens(Object.entries(screens !== null && screens !== void 0 ? screens : {}), false);
    }
    function isScreenSortable(screen) {
      if (screen.values.length !== 1) {
        return {
          result: false,
          reason: "multiple-values"
        };
      } else if (screen.values[0].raw !== void 0) {
        return {
          result: false,
          reason: "raw-values"
        };
      } else if (screen.values[0].min !== void 0 && screen.values[0].max !== void 0) {
        return {
          result: false,
          reason: "min-and-max"
        };
      }
      return {
        result: true,
        reason: null
      };
    }
    function compareScreens(type, a, z) {
      let aScreen = toScreen(a, type);
      let zScreen = toScreen(z, type);
      let aSorting = isScreenSortable(aScreen);
      let bSorting = isScreenSortable(zScreen);
      if (aSorting.reason === "multiple-values" || bSorting.reason === "multiple-values") {
        throw new Error("Attempted to sort a screen with multiple values. This should never happen. Please open a bug report.");
      } else if (aSorting.reason === "raw-values" || bSorting.reason === "raw-values") {
        throw new Error("Attempted to sort a screen with raw values. This should never happen. Please open a bug report.");
      } else if (aSorting.reason === "min-and-max" || bSorting.reason === "min-and-max") {
        throw new Error("Attempted to sort a screen with both min and max values. This should never happen. Please open a bug report.");
      }
      let { min: aMin, max: aMax } = aScreen.values[0];
      let { min: zMin, max: zMax } = zScreen.values[0];
      if (a.not)
        [aMin, aMax] = [
          aMax,
          aMin
        ];
      if (z.not)
        [zMin, zMax] = [
          zMax,
          zMin
        ];
      aMin = aMin === void 0 ? aMin : parseFloat(aMin);
      aMax = aMax === void 0 ? aMax : parseFloat(aMax);
      zMin = zMin === void 0 ? zMin : parseFloat(zMin);
      zMax = zMax === void 0 ? zMax : parseFloat(zMax);
      let [aValue, zValue] = type === "min" ? [
        aMin,
        zMin
      ] : [
        zMax,
        aMax
      ];
      return aValue - zValue;
    }
    function toScreen(value2, type) {
      if (typeof value2 === "object") {
        return value2;
      }
      return {
        name: "arbitrary-screen",
        values: [
          {
            [type]: value2
          }
        ]
      };
    }
    function resolveValue({ "min-width": _minWidth, min = _minWidth, max, raw } = {}) {
      return {
        min,
        max,
        raw
      };
    }
  }
});

// node_modules/tailwindcss/lib/util/removeAlphaVariables.js
var require_removeAlphaVariables = __commonJS({
  "node_modules/tailwindcss/lib/util/removeAlphaVariables.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    Object.defineProperty(exports, "removeAlphaVariables", {
      enumerable: true,
      get: function() {
        return removeAlphaVariables;
      }
    });
    function removeAlphaVariables(container, toRemove) {
      container.walkDecls((decl) => {
        if (toRemove.includes(decl.prop)) {
          decl.remove();
          return;
        }
        for (let varName of toRemove) {
          if (decl.value.includes(`/ var(${varName})`)) {
            decl.value = decl.value.replace(`/ var(${varName})`, "");
          }
        }
      });
    }
  }
});

// node_modules/tailwindcss/lib/corePlugins.js
var require_corePlugins = __commonJS({
  "node_modules/tailwindcss/lib/corePlugins.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    function _export(target, all) {
      for (var name in all)
        Object.defineProperty(target, name, {
          enumerable: true,
          get: all[name]
        });
    }
    _export(exports, {
      variantPlugins: function() {
        return variantPlugins;
      },
      corePlugins: function() {
        return corePlugins;
      }
    });
    var _fs = _interop_require_default(require_fs());
    var _path = _interop_require_wildcard(require_path());
    var _postcss = _interop_require_default(require_postcss());
    var _createUtilityPlugin = _interop_require_default(require_createUtilityPlugin());
    var _buildMediaQuery = _interop_require_default(require_buildMediaQuery());
    var _escapeClassName = _interop_require_default(require_escapeClassName());
    var _parseAnimationValue = _interop_require_default(require_parseAnimationValue());
    var _flattenColorPalette = _interop_require_default(require_flattenColorPalette());
    var _withAlphaVariable = _interop_require_wildcard(require_withAlphaVariable());
    var _toColorValue = _interop_require_default(require_toColorValue());
    var _isPlainObject = _interop_require_default(require_isPlainObject());
    var _transformThemeValue = _interop_require_default(require_transformThemeValue());
    var _packagejson = require_package();
    var _log = _interop_require_default(require_log());
    var _normalizeScreens = require_normalizeScreens();
    var _parseBoxShadowValue = require_parseBoxShadowValue();
    var _removeAlphaVariables = require_removeAlphaVariables();
    var _featureFlags = require_featureFlags();
    var _dataTypes = require_dataTypes();
    var _setupContextUtils = require_setupContextUtils();
    function _interop_require_default(obj) {
      return obj && obj.__esModule ? obj : {
        default: obj
      };
    }
    function _getRequireWildcardCache(nodeInterop) {
      if (typeof WeakMap !== "function")
        return null;
      var cacheBabelInterop = /* @__PURE__ */ new WeakMap();
      var cacheNodeInterop = /* @__PURE__ */ new WeakMap();
      return (_getRequireWildcardCache = function(nodeInterop2) {
        return nodeInterop2 ? cacheNodeInterop : cacheBabelInterop;
      })(nodeInterop);
    }
    function _interop_require_wildcard(obj, nodeInterop) {
      if (!nodeInterop && obj && obj.__esModule) {
        return obj;
      }
      if (obj === null || typeof obj !== "object" && typeof obj !== "function") {
        return {
          default: obj
        };
      }
      var cache = _getRequireWildcardCache(nodeInterop);
      if (cache && cache.has(obj)) {
        return cache.get(obj);
      }
      var newObj = {};
      var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;
      for (var key in obj) {
        if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) {
          var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;
          if (desc && (desc.get || desc.set)) {
            Object.defineProperty(newObj, key, desc);
          } else {
            newObj[key] = obj[key];
          }
        }
      }
      newObj.default = obj;
      if (cache) {
        cache.set(obj, newObj);
      }
      return newObj;
    }
    var variantPlugins = {
      childVariant: ({ addVariant }) => {
        addVariant("*", "& > *");
      },
      pseudoElementVariants: ({ addVariant }) => {
        addVariant("first-letter", "&::first-letter");
        addVariant("first-line", "&::first-line");
        addVariant("marker", [
          ({ container }) => {
            (0, _removeAlphaVariables.removeAlphaVariables)(container, [
              "--tw-text-opacity"
            ]);
            return "& *::marker";
          },
          ({ container }) => {
            (0, _removeAlphaVariables.removeAlphaVariables)(container, [
              "--tw-text-opacity"
            ]);
            return "&::marker";
          }
        ]);
        addVariant("selection", [
          "& *::selection",
          "&::selection"
        ]);
        addVariant("file", "&::file-selector-button");
        addVariant("placeholder", "&::placeholder");
        addVariant("backdrop", "&::backdrop");
        addVariant("before", ({ container }) => {
          container.walkRules((rule) => {
            let foundContent = false;
            rule.walkDecls("content", () => {
              foundContent = true;
            });
            if (!foundContent) {
              rule.prepend(_postcss.default.decl({
                prop: "content",
                value: "var(--tw-content)"
              }));
            }
          });
          return "&::before";
        });
        addVariant("after", ({ container }) => {
          container.walkRules((rule) => {
            let foundContent = false;
            rule.walkDecls("content", () => {
              foundContent = true;
            });
            if (!foundContent) {
              rule.prepend(_postcss.default.decl({
                prop: "content",
                value: "var(--tw-content)"
              }));
            }
          });
          return "&::after";
        });
      },
      pseudoClassVariants: ({ addVariant, matchVariant, config, prefix }) => {
        let pseudoVariants = [
          // Positional
          [
            "first",
            "&:first-child"
          ],
          [
            "last",
            "&:last-child"
          ],
          [
            "only",
            "&:only-child"
          ],
          [
            "odd",
            "&:nth-child(odd)"
          ],
          [
            "even",
            "&:nth-child(even)"
          ],
          "first-of-type",
          "last-of-type",
          "only-of-type",
          // State
          [
            "visited",
            ({ container }) => {
              (0, _removeAlphaVariables.removeAlphaVariables)(container, [
                "--tw-text-opacity",
                "--tw-border-opacity",
                "--tw-bg-opacity"
              ]);
              return "&:visited";
            }
          ],
          "target",
          [
            "open",
            "&[open]"
          ],
          // Forms
          "default",
          "checked",
          "indeterminate",
          "placeholder-shown",
          "autofill",
          "optional",
          "required",
          "valid",
          "invalid",
          "in-range",
          "out-of-range",
          "read-only",
          // Content
          "empty",
          // Interactive
          "focus-within",
          [
            "hover",
            !(0, _featureFlags.flagEnabled)(config(), "hoverOnlyWhenSupported") ? "&:hover" : "@media (hover: hover) and (pointer: fine) { &:hover }"
          ],
          "focus",
          "focus-visible",
          "active",
          "enabled",
          "disabled"
        ].map((variant) => Array.isArray(variant) ? variant : [
          variant,
          `&:${variant}`
        ]);
        for (let [variantName, state2] of pseudoVariants) {
          addVariant(variantName, (ctx) => {
            let result = typeof state2 === "function" ? state2(ctx) : state2;
            return result;
          });
        }
        let variants = {
          group: (_, { modifier }) => modifier ? [
            `:merge(${prefix(".group")}\\/${(0, _escapeClassName.default)(modifier)})`,
            " &"
          ] : [
            `:merge(${prefix(".group")})`,
            " &"
          ],
          peer: (_, { modifier }) => modifier ? [
            `:merge(${prefix(".peer")}\\/${(0, _escapeClassName.default)(modifier)})`,
            " ~ &"
          ] : [
            `:merge(${prefix(".peer")})`,
            " ~ &"
          ]
        };
        for (let [name, fn] of Object.entries(variants)) {
          matchVariant(name, (value2 = "", extra) => {
            let result = (0, _dataTypes.normalize)(typeof value2 === "function" ? value2(extra) : value2);
            if (!result.includes("&"))
              result = "&" + result;
            let [a, b] = fn("", extra);
            let start = null;
            let end = null;
            let quotes = 0;
            for (let i = 0; i < result.length; ++i) {
              let c = result[i];
              if (c === "&") {
                start = i;
              } else if (c === "'" || c === '"') {
                quotes += 1;
              } else if (start !== null && c === " " && !quotes) {
                end = i;
              }
            }
            if (start !== null && end === null) {
              end = result.length;
            }
            return result.slice(0, start) + a + result.slice(start + 1, end) + b + result.slice(end);
          }, {
            values: Object.fromEntries(pseudoVariants),
            [_setupContextUtils.INTERNAL_FEATURES]: {
              respectPrefix: false
            }
          });
        }
      },
      directionVariants: ({ addVariant }) => {
        addVariant("ltr", '&:where([dir="ltr"], [dir="ltr"] *)');
        addVariant("rtl", '&:where([dir="rtl"], [dir="rtl"] *)');
      },
      reducedMotionVariants: ({ addVariant }) => {
        addVariant("motion-safe", "@media (prefers-reduced-motion: no-preference)");
        addVariant("motion-reduce", "@media (prefers-reduced-motion: reduce)");
      },
      darkVariants: ({ config, addVariant }) => {
        let [mode, selector = ".dark"] = [].concat(config("darkMode", "media"));
        if (mode === false) {
          mode = "media";
          _log.default.warn("darkmode-false", [
            "The `darkMode` option in your Tailwind CSS configuration is set to `false`, which now behaves the same as `media`.",
            "Change `darkMode` to `media` or remove it entirely.",
            "https://tailwindcss.com/docs/upgrade-guide#remove-dark-mode-configuration"
          ]);
        }
        if (mode === "variant") {
          let formats;
          if (Array.isArray(selector)) {
            formats = selector;
          } else if (typeof selector === "function") {
            formats = selector;
          } else if (typeof selector === "string") {
            formats = [
              selector
            ];
          }
          if (Array.isArray(formats)) {
            for (let format of formats) {
              if (format === ".dark") {
                mode = false;
                _log.default.warn("darkmode-variant-without-selector", [
                  "When using `variant` for `darkMode`, you must provide a selector.",
                  'Example: `darkMode: ["variant", ".your-selector &"]`'
                ]);
              } else if (!format.includes("&")) {
                mode = false;
                _log.default.warn("darkmode-variant-without-ampersand", [
                  "When using `variant` for `darkMode`, your selector must contain `&`.",
                  'Example `darkMode: ["variant", ".your-selector &"]`'
                ]);
              }
            }
          }
          selector = formats;
        }
        if (mode === "selector") {
          addVariant("dark", `&:where(${selector}, ${selector} *)`);
        } else if (mode === "media") {
          addVariant("dark", "@media (prefers-color-scheme: dark)");
        } else if (mode === "variant") {
          addVariant("dark", selector);
        } else if (mode === "class") {
          addVariant("dark", `&:is(${selector} *)`);
        }
      },
      printVariant: ({ addVariant }) => {
        addVariant("print", "@media print");
      },
      screenVariants: ({ theme, addVariant, matchVariant }) => {
        var _theme;
        let rawScreens = (_theme = theme("screens")) !== null && _theme !== void 0 ? _theme : {};
        let areSimpleScreens = Object.values(rawScreens).every((v) => typeof v === "string");
        let screens = (0, _normalizeScreens.normalizeScreens)(theme("screens"));
        let unitCache = /* @__PURE__ */ new Set([]);
        function units(value2) {
          var _value_match;
          var _value_match_;
          return (_value_match_ = (_value_match = value2.match(/(\D+)$/)) === null || _value_match === void 0 ? void 0 : _value_match[1]) !== null && _value_match_ !== void 0 ? _value_match_ : "(none)";
        }
        function recordUnits(value2) {
          if (value2 !== void 0) {
            unitCache.add(units(value2));
          }
        }
        function canUseUnits(value2) {
          recordUnits(value2);
          return unitCache.size === 1;
        }
        for (const screen of screens) {
          for (const value2 of screen.values) {
            recordUnits(value2.min);
            recordUnits(value2.max);
          }
        }
        let screensUseConsistentUnits = unitCache.size <= 1;
        function buildScreenValues(type) {
          return Object.fromEntries(screens.filter((screen) => (0, _normalizeScreens.isScreenSortable)(screen).result).map((screen) => {
            let { min, max } = screen.values[0];
            if (type === "min" && min !== void 0) {
              return screen;
            } else if (type === "min" && max !== void 0) {
              return {
                ...screen,
                not: !screen.not
              };
            } else if (type === "max" && max !== void 0) {
              return screen;
            } else if (type === "max" && min !== void 0) {
              return {
                ...screen,
                not: !screen.not
              };
            }
          }).map((screen) => [
            screen.name,
            screen
          ]));
        }
        function buildSort(type) {
          return (a, z) => (0, _normalizeScreens.compareScreens)(type, a.value, z.value);
        }
        let maxSort = buildSort("max");
        let minSort = buildSort("min");
        function buildScreenVariant(type) {
          return (value2) => {
            if (!areSimpleScreens) {
              _log.default.warn("complex-screen-config", [
                "The `min-*` and `max-*` variants are not supported with a `screens` configuration containing objects."
              ]);
              return [];
            } else if (!screensUseConsistentUnits) {
              _log.default.warn("mixed-screen-units", [
                "The `min-*` and `max-*` variants are not supported with a `screens` configuration containing mixed units."
              ]);
              return [];
            } else if (typeof value2 === "string" && !canUseUnits(value2)) {
              _log.default.warn("minmax-have-mixed-units", [
                "The `min-*` and `max-*` variants are not supported with a `screens` configuration containing mixed units."
              ]);
              return [];
            }
            return [
              `@media ${(0, _buildMediaQuery.default)((0, _normalizeScreens.toScreen)(value2, type))}`
            ];
          };
        }
        matchVariant("max", buildScreenVariant("max"), {
          sort: maxSort,
          values: areSimpleScreens ? buildScreenValues("max") : {}
        });
        let id = "min-screens";
        for (let screen of screens) {
          addVariant(screen.name, `@media ${(0, _buildMediaQuery.default)(screen)}`, {
            id,
            sort: areSimpleScreens && screensUseConsistentUnits ? minSort : void 0,
            value: screen
          });
        }
        matchVariant("min", buildScreenVariant("min"), {
          id,
          sort: minSort
        });
      },
      supportsVariants: ({ matchVariant, theme }) => {
        var _theme;
        matchVariant("supports", (value2 = "") => {
          let check = (0, _dataTypes.normalize)(value2);
          let isRaw = /^\w*\s*\(/.test(check);
          check = isRaw ? check.replace(/\b(and|or|not)\b/g, " $1 ") : check;
          if (isRaw) {
            return `@supports ${check}`;
          }
          if (!check.includes(":")) {
            check = `${check}: var(--tw)`;
          }
          if (!(check.startsWith("(") && check.endsWith(")"))) {
            check = `(${check})`;
          }
          return `@supports ${check}`;
        }, {
          values: (_theme = theme("supports")) !== null && _theme !== void 0 ? _theme : {}
        });
      },
      hasVariants: ({ matchVariant, prefix }) => {
        matchVariant("has", (value2) => `&:has(${(0, _dataTypes.normalize)(value2)})`, {
          values: {},
          [_setupContextUtils.INTERNAL_FEATURES]: {
            respectPrefix: false
          }
        });
        matchVariant("group-has", (value2, { modifier }) => modifier ? `:merge(${prefix(".group")}\\/${modifier}):has(${(0, _dataTypes.normalize)(value2)}) &` : `:merge(${prefix(".group")}):has(${(0, _dataTypes.normalize)(value2)}) &`, {
          values: {},
          [_setupContextUtils.INTERNAL_FEATURES]: {
            respectPrefix: false
          }
        });
        matchVariant("peer-has", (value2, { modifier }) => modifier ? `:merge(${prefix(".peer")}\\/${modifier}):has(${(0, _dataTypes.normalize)(value2)}) ~ &` : `:merge(${prefix(".peer")}):has(${(0, _dataTypes.normalize)(value2)}) ~ &`, {
          values: {},
          [_setupContextUtils.INTERNAL_FEATURES]: {
            respectPrefix: false
          }
        });
      },
      ariaVariants: ({ matchVariant, theme }) => {
        var _theme;
        matchVariant("aria", (value2) => `&[aria-${(0, _dataTypes.normalize)(value2)}]`, {
          values: (_theme = theme("aria")) !== null && _theme !== void 0 ? _theme : {}
        });
        var _theme1;
        matchVariant("group-aria", (value2, { modifier }) => modifier ? `:merge(.group\\/${modifier})[aria-${(0, _dataTypes.normalize)(value2)}] &` : `:merge(.group)[aria-${(0, _dataTypes.normalize)(value2)}] &`, {
          values: (_theme1 = theme("aria")) !== null && _theme1 !== void 0 ? _theme1 : {}
        });
        var _theme2;
        matchVariant("peer-aria", (value2, { modifier }) => modifier ? `:merge(.peer\\/${modifier})[aria-${(0, _dataTypes.normalize)(value2)}] ~ &` : `:merge(.peer)[aria-${(0, _dataTypes.normalize)(value2)}] ~ &`, {
          values: (_theme2 = theme("aria")) !== null && _theme2 !== void 0 ? _theme2 : {}
        });
      },
      dataVariants: ({ matchVariant, theme }) => {
        var _theme;
        matchVariant("data", (value2) => `&[data-${(0, _dataTypes.normalize)(value2)}]`, {
          values: (_theme = theme("data")) !== null && _theme !== void 0 ? _theme : {}
        });
        var _theme1;
        matchVariant("group-data", (value2, { modifier }) => modifier ? `:merge(.group\\/${modifier})[data-${(0, _dataTypes.normalize)(value2)}] &` : `:merge(.group)[data-${(0, _dataTypes.normalize)(value2)}] &`, {
          values: (_theme1 = theme("data")) !== null && _theme1 !== void 0 ? _theme1 : {}
        });
        var _theme2;
        matchVariant("peer-data", (value2, { modifier }) => modifier ? `:merge(.peer\\/${modifier})[data-${(0, _dataTypes.normalize)(value2)}] ~ &` : `:merge(.peer)[data-${(0, _dataTypes.normalize)(value2)}] ~ &`, {
          values: (_theme2 = theme("data")) !== null && _theme2 !== void 0 ? _theme2 : {}
        });
      },
      orientationVariants: ({ addVariant }) => {
        addVariant("portrait", "@media (orientation: portrait)");
        addVariant("landscape", "@media (orientation: landscape)");
      },
      prefersContrastVariants: ({ addVariant }) => {
        addVariant("contrast-more", "@media (prefers-contrast: more)");
        addVariant("contrast-less", "@media (prefers-contrast: less)");
      },
      forcedColorsVariants: ({ addVariant }) => {
        addVariant("forced-colors", "@media (forced-colors: active)");
      }
    };
    var cssTransformValue = [
      "translate(var(--tw-translate-x), var(--tw-translate-y))",
      "rotate(var(--tw-rotate))",
      "skewX(var(--tw-skew-x))",
      "skewY(var(--tw-skew-y))",
      "scaleX(var(--tw-scale-x))",
      "scaleY(var(--tw-scale-y))"
    ].join(" ");
    var cssFilterValue = [
      "var(--tw-blur)",
      "var(--tw-brightness)",
      "var(--tw-contrast)",
      "var(--tw-grayscale)",
      "var(--tw-hue-rotate)",
      "var(--tw-invert)",
      "var(--tw-saturate)",
      "var(--tw-sepia)",
      "var(--tw-drop-shadow)"
    ].join(" ");
    var cssBackdropFilterValue = [
      "var(--tw-backdrop-blur)",
      "var(--tw-backdrop-brightness)",
      "var(--tw-backdrop-contrast)",
      "var(--tw-backdrop-grayscale)",
      "var(--tw-backdrop-hue-rotate)",
      "var(--tw-backdrop-invert)",
      "var(--tw-backdrop-opacity)",
      "var(--tw-backdrop-saturate)",
      "var(--tw-backdrop-sepia)"
    ].join(" ");
    var corePlugins = {
      preflight: ({ addBase }) => {
        let preflightStyles = _postcss.default.parse(_fs.default.readFileSync(_path.join(__dirname, "./css/preflight.css"), "utf8"));
        addBase([
          _postcss.default.comment({
            text: `! tailwindcss v${_packagejson.version} | MIT License | https://tailwindcss.com`
          }),
          ...preflightStyles.nodes
        ]);
      },
      container: (() => {
        function extractMinWidths(breakpoints = []) {
          return breakpoints.flatMap((breakpoint) => breakpoint.values.map((breakpoint2) => breakpoint2.min)).filter((v) => v !== void 0);
        }
        function mapMinWidthsToPadding(minWidths, screens, paddings) {
          if (typeof paddings === "undefined") {
            return [];
          }
          if (!(typeof paddings === "object" && paddings !== null)) {
            return [
              {
                screen: "DEFAULT",
                minWidth: 0,
                padding: paddings
              }
            ];
          }
          let mapping = [];
          if (paddings.DEFAULT) {
            mapping.push({
              screen: "DEFAULT",
              minWidth: 0,
              padding: paddings.DEFAULT
            });
          }
          for (let minWidth of minWidths) {
            for (let screen of screens) {
              for (let { min } of screen.values) {
                if (min === minWidth) {
                  mapping.push({
                    minWidth,
                    padding: paddings[screen.name]
                  });
                }
              }
            }
          }
          return mapping;
        }
        return function({ addComponents, theme }) {
          let screens = (0, _normalizeScreens.normalizeScreens)(theme("container.screens", theme("screens")));
          let minWidths = extractMinWidths(screens);
          let paddings = mapMinWidthsToPadding(minWidths, screens, theme("container.padding"));
          let generatePaddingFor = (minWidth) => {
            let paddingConfig = paddings.find((padding) => padding.minWidth === minWidth);
            if (!paddingConfig) {
              return {};
            }
            return {
              paddingRight: paddingConfig.padding,
              paddingLeft: paddingConfig.padding
            };
          };
          let atRules = Array.from(new Set(minWidths.slice().sort((a, z) => parseInt(a) - parseInt(z)))).map((minWidth) => ({
            [`@media (min-width: ${minWidth})`]: {
              ".container": {
                "max-width": minWidth,
                ...generatePaddingFor(minWidth)
              }
            }
          }));
          addComponents([
            {
              ".container": Object.assign({
                width: "100%"
              }, theme("container.center", false) ? {
                marginRight: "auto",
                marginLeft: "auto"
              } : {}, generatePaddingFor(0))
            },
            ...atRules
          ]);
        };
      })(),
      accessibility: ({ addUtilities }) => {
        addUtilities({
          ".sr-only": {
            position: "absolute",
            width: "1px",
            height: "1px",
            padding: "0",
            margin: "-1px",
            overflow: "hidden",
            clip: "rect(0, 0, 0, 0)",
            whiteSpace: "nowrap",
            borderWidth: "0"
          },
          ".not-sr-only": {
            position: "static",
            width: "auto",
            height: "auto",
            padding: "0",
            margin: "0",
            overflow: "visible",
            clip: "auto",
            whiteSpace: "normal"
          }
        });
      },
      pointerEvents: ({ addUtilities }) => {
        addUtilities({
          ".pointer-events-none": {
            "pointer-events": "none"
          },
          ".pointer-events-auto": {
            "pointer-events": "auto"
          }
        });
      },
      visibility: ({ addUtilities }) => {
        addUtilities({
          ".visible": {
            visibility: "visible"
          },
          ".invisible": {
            visibility: "hidden"
          },
          ".collapse": {
            visibility: "collapse"
          }
        });
      },
      position: ({ addUtilities }) => {
        addUtilities({
          ".static": {
            position: "static"
          },
          ".fixed": {
            position: "fixed"
          },
          ".absolute": {
            position: "absolute"
          },
          ".relative": {
            position: "relative"
          },
          ".sticky": {
            position: "sticky"
          }
        });
      },
      inset: (0, _createUtilityPlugin.default)("inset", [
        [
          "inset",
          [
            "inset"
          ]
        ],
        [
          [
            "inset-x",
            [
              "left",
              "right"
            ]
          ],
          [
            "inset-y",
            [
              "top",
              "bottom"
            ]
          ]
        ],
        [
          [
            "start",
            [
              "inset-inline-start"
            ]
          ],
          [
            "end",
            [
              "inset-inline-end"
            ]
          ],
          [
            "top",
            [
              "top"
            ]
          ],
          [
            "right",
            [
              "right"
            ]
          ],
          [
            "bottom",
            [
              "bottom"
            ]
          ],
          [
            "left",
            [
              "left"
            ]
          ]
        ]
      ], {
        supportsNegativeValues: true
      }),
      isolation: ({ addUtilities }) => {
        addUtilities({
          ".isolate": {
            isolation: "isolate"
          },
          ".isolation-auto": {
            isolation: "auto"
          }
        });
      },
      zIndex: (0, _createUtilityPlugin.default)("zIndex", [
        [
          "z",
          [
            "zIndex"
          ]
        ]
      ], {
        supportsNegativeValues: true
      }),
      order: (0, _createUtilityPlugin.default)("order", void 0, {
        supportsNegativeValues: true
      }),
      gridColumn: (0, _createUtilityPlugin.default)("gridColumn", [
        [
          "col",
          [
            "gridColumn"
          ]
        ]
      ]),
      gridColumnStart: (0, _createUtilityPlugin.default)("gridColumnStart", [
        [
          "col-start",
          [
            "gridColumnStart"
          ]
        ]
      ], {
        supportsNegativeValues: true
      }),
      gridColumnEnd: (0, _createUtilityPlugin.default)("gridColumnEnd", [
        [
          "col-end",
          [
            "gridColumnEnd"
          ]
        ]
      ], {
        supportsNegativeValues: true
      }),
      gridRow: (0, _createUtilityPlugin.default)("gridRow", [
        [
          "row",
          [
            "gridRow"
          ]
        ]
      ]),
      gridRowStart: (0, _createUtilityPlugin.default)("gridRowStart", [
        [
          "row-start",
          [
            "gridRowStart"
          ]
        ]
      ], {
        supportsNegativeValues: true
      }),
      gridRowEnd: (0, _createUtilityPlugin.default)("gridRowEnd", [
        [
          "row-end",
          [
            "gridRowEnd"
          ]
        ]
      ], {
        supportsNegativeValues: true
      }),
      float: ({ addUtilities }) => {
        addUtilities({
          ".float-start": {
            float: "inline-start"
          },
          ".float-end": {
            float: "inline-end"
          },
          ".float-right": {
            float: "right"
          },
          ".float-left": {
            float: "left"
          },
          ".float-none": {
            float: "none"
          }
        });
      },
      clear: ({ addUtilities }) => {
        addUtilities({
          ".clear-start": {
            clear: "inline-start"
          },
          ".clear-end": {
            clear: "inline-end"
          },
          ".clear-left": {
            clear: "left"
          },
          ".clear-right": {
            clear: "right"
          },
          ".clear-both": {
            clear: "both"
          },
          ".clear-none": {
            clear: "none"
          }
        });
      },
      margin: (0, _createUtilityPlugin.default)("margin", [
        [
          "m",
          [
            "margin"
          ]
        ],
        [
          [
            "mx",
            [
              "margin-left",
              "margin-right"
            ]
          ],
          [
            "my",
            [
              "margin-top",
              "margin-bottom"
            ]
          ]
        ],
        [
          [
            "ms",
            [
              "margin-inline-start"
            ]
          ],
          [
            "me",
            [
              "margin-inline-end"
            ]
          ],
          [
            "mt",
            [
              "margin-top"
            ]
          ],
          [
            "mr",
            [
              "margin-right"
            ]
          ],
          [
            "mb",
            [
              "margin-bottom"
            ]
          ],
          [
            "ml",
            [
              "margin-left"
            ]
          ]
        ]
      ], {
        supportsNegativeValues: true
      }),
      boxSizing: ({ addUtilities }) => {
        addUtilities({
          ".box-border": {
            "box-sizing": "border-box"
          },
          ".box-content": {
            "box-sizing": "content-box"
          }
        });
      },
      lineClamp: ({ matchUtilities, addUtilities, theme }) => {
        matchUtilities({
          "line-clamp": (value2) => ({
            overflow: "hidden",
            display: "-webkit-box",
            "-webkit-box-orient": "vertical",
            "-webkit-line-clamp": `${value2}`
          })
        }, {
          values: theme("lineClamp")
        });
        addUtilities({
          ".line-clamp-none": {
            overflow: "visible",
            display: "block",
            "-webkit-box-orient": "horizontal",
            "-webkit-line-clamp": "none"
          }
        });
      },
      display: ({ addUtilities }) => {
        addUtilities({
          ".block": {
            display: "block"
          },
          ".inline-block": {
            display: "inline-block"
          },
          ".inline": {
            display: "inline"
          },
          ".flex": {
            display: "flex"
          },
          ".inline-flex": {
            display: "inline-flex"
          },
          ".table": {
            display: "table"
          },
          ".inline-table": {
            display: "inline-table"
          },
          ".table-caption": {
            display: "table-caption"
          },
          ".table-cell": {
            display: "table-cell"
          },
          ".table-column": {
            display: "table-column"
          },
          ".table-column-group": {
            display: "table-column-group"
          },
          ".table-footer-group": {
            display: "table-footer-group"
          },
          ".table-header-group": {
            display: "table-header-group"
          },
          ".table-row-group": {
            display: "table-row-group"
          },
          ".table-row": {
            display: "table-row"
          },
          ".flow-root": {
            display: "flow-root"
          },
          ".grid": {
            display: "grid"
          },
          ".inline-grid": {
            display: "inline-grid"
          },
          ".contents": {
            display: "contents"
          },
          ".list-item": {
            display: "list-item"
          },
          ".hidden": {
            display: "none"
          }
        });
      },
      aspectRatio: (0, _createUtilityPlugin.default)("aspectRatio", [
        [
          "aspect",
          [
            "aspect-ratio"
          ]
        ]
      ]),
      size: (0, _createUtilityPlugin.default)("size", [
        [
          "size",
          [
            "width",
            "height"
          ]
        ]
      ]),
      height: (0, _createUtilityPlugin.default)("height", [
        [
          "h",
          [
            "height"
          ]
        ]
      ]),
      maxHeight: (0, _createUtilityPlugin.default)("maxHeight", [
        [
          "max-h",
          [
            "maxHeight"
          ]
        ]
      ]),
      minHeight: (0, _createUtilityPlugin.default)("minHeight", [
        [
          "min-h",
          [
            "minHeight"
          ]
        ]
      ]),
      width: (0, _createUtilityPlugin.default)("width", [
        [
          "w",
          [
            "width"
          ]
        ]
      ]),
      minWidth: (0, _createUtilityPlugin.default)("minWidth", [
        [
          "min-w",
          [
            "minWidth"
          ]
        ]
      ]),
      maxWidth: (0, _createUtilityPlugin.default)("maxWidth", [
        [
          "max-w",
          [
            "maxWidth"
          ]
        ]
      ]),
      flex: (0, _createUtilityPlugin.default)("flex"),
      flexShrink: (0, _createUtilityPlugin.default)("flexShrink", [
        [
          "flex-shrink",
          [
            "flex-shrink"
          ]
        ],
        [
          "shrink",
          [
            "flex-shrink"
          ]
        ]
      ]),
      flexGrow: (0, _createUtilityPlugin.default)("flexGrow", [
        [
          "flex-grow",
          [
            "flex-grow"
          ]
        ],
        [
          "grow",
          [
            "flex-grow"
          ]
        ]
      ]),
      flexBasis: (0, _createUtilityPlugin.default)("flexBasis", [
        [
          "basis",
          [
            "flex-basis"
          ]
        ]
      ]),
      tableLayout: ({ addUtilities }) => {
        addUtilities({
          ".table-auto": {
            "table-layout": "auto"
          },
          ".table-fixed": {
            "table-layout": "fixed"
          }
        });
      },
      captionSide: ({ addUtilities }) => {
        addUtilities({
          ".caption-top": {
            "caption-side": "top"
          },
          ".caption-bottom": {
            "caption-side": "bottom"
          }
        });
      },
      borderCollapse: ({ addUtilities }) => {
        addUtilities({
          ".border-collapse": {
            "border-collapse": "collapse"
          },
          ".border-separate": {
            "border-collapse": "separate"
          }
        });
      },
      borderSpacing: ({ addDefaults, matchUtilities, theme }) => {
        addDefaults("border-spacing", {
          "--tw-border-spacing-x": 0,
          "--tw-border-spacing-y": 0
        });
        matchUtilities({
          "border-spacing": (value2) => {
            return {
              "--tw-border-spacing-x": value2,
              "--tw-border-spacing-y": value2,
              "@defaults border-spacing": {},
              "border-spacing": "var(--tw-border-spacing-x) var(--tw-border-spacing-y)"
            };
          },
          "border-spacing-x": (value2) => {
            return {
              "--tw-border-spacing-x": value2,
              "@defaults border-spacing": {},
              "border-spacing": "var(--tw-border-spacing-x) var(--tw-border-spacing-y)"
            };
          },
          "border-spacing-y": (value2) => {
            return {
              "--tw-border-spacing-y": value2,
              "@defaults border-spacing": {},
              "border-spacing": "var(--tw-border-spacing-x) var(--tw-border-spacing-y)"
            };
          }
        }, {
          values: theme("borderSpacing")
        });
      },
      transformOrigin: (0, _createUtilityPlugin.default)("transformOrigin", [
        [
          "origin",
          [
            "transformOrigin"
          ]
        ]
      ]),
      translate: (0, _createUtilityPlugin.default)("translate", [
        [
          [
            "translate-x",
            [
              [
                "@defaults transform",
                {}
              ],
              "--tw-translate-x",
              [
                "transform",
                cssTransformValue
              ]
            ]
          ],
          [
            "translate-y",
            [
              [
                "@defaults transform",
                {}
              ],
              "--tw-translate-y",
              [
                "transform",
                cssTransformValue
              ]
            ]
          ]
        ]
      ], {
        supportsNegativeValues: true
      }),
      rotate: (0, _createUtilityPlugin.default)("rotate", [
        [
          "rotate",
          [
            [
              "@defaults transform",
              {}
            ],
            "--tw-rotate",
            [
              "transform",
              cssTransformValue
            ]
          ]
        ]
      ], {
        supportsNegativeValues: true
      }),
      skew: (0, _createUtilityPlugin.default)("skew", [
        [
          [
            "skew-x",
            [
              [
                "@defaults transform",
                {}
              ],
              "--tw-skew-x",
              [
                "transform",
                cssTransformValue
              ]
            ]
          ],
          [
            "skew-y",
            [
              [
                "@defaults transform",
                {}
              ],
              "--tw-skew-y",
              [
                "transform",
                cssTransformValue
              ]
            ]
          ]
        ]
      ], {
        supportsNegativeValues: true
      }),
      scale: (0, _createUtilityPlugin.default)("scale", [
        [
          "scale",
          [
            [
              "@defaults transform",
              {}
            ],
            "--tw-scale-x",
            "--tw-scale-y",
            [
              "transform",
              cssTransformValue
            ]
          ]
        ],
        [
          [
            "scale-x",
            [
              [
                "@defaults transform",
                {}
              ],
              "--tw-scale-x",
              [
                "transform",
                cssTransformValue
              ]
            ]
          ],
          [
            "scale-y",
            [
              [
                "@defaults transform",
                {}
              ],
              "--tw-scale-y",
              [
                "transform",
                cssTransformValue
              ]
            ]
          ]
        ]
      ], {
        supportsNegativeValues: true
      }),
      transform: ({ addDefaults, addUtilities }) => {
        addDefaults("transform", {
          "--tw-translate-x": "0",
          "--tw-translate-y": "0",
          "--tw-rotate": "0",
          "--tw-skew-x": "0",
          "--tw-skew-y": "0",
          "--tw-scale-x": "1",
          "--tw-scale-y": "1"
        });
        addUtilities({
          ".transform": {
            "@defaults transform": {},
            transform: cssTransformValue
          },
          ".transform-cpu": {
            transform: cssTransformValue
          },
          ".transform-gpu": {
            transform: cssTransformValue.replace("translate(var(--tw-translate-x), var(--tw-translate-y))", "translate3d(var(--tw-translate-x), var(--tw-translate-y), 0)")
          },
          ".transform-none": {
            transform: "none"
          }
        });
      },
      animation: ({ matchUtilities, theme, config }) => {
        let prefixName = (name) => (0, _escapeClassName.default)(config("prefix") + name);
        var _theme;
        let keyframes = Object.fromEntries(Object.entries((_theme = theme("keyframes")) !== null && _theme !== void 0 ? _theme : {}).map(([key, value2]) => {
          return [
            key,
            {
              [`@keyframes ${prefixName(key)}`]: value2
            }
          ];
        }));
        matchUtilities({
          animate: (value2) => {
            let animations = (0, _parseAnimationValue.default)(value2);
            return [
              ...animations.flatMap((animation) => keyframes[animation.name]),
              {
                animation: animations.map(({ name, value: value3 }) => {
                  if (name === void 0 || keyframes[name] === void 0) {
                    return value3;
                  }
                  return value3.replace(name, prefixName(name));
                }).join(", ")
              }
            ];
          }
        }, {
          values: theme("animation")
        });
      },
      cursor: (0, _createUtilityPlugin.default)("cursor"),
      touchAction: ({ addDefaults, addUtilities }) => {
        addDefaults("touch-action", {
          "--tw-pan-x": " ",
          "--tw-pan-y": " ",
          "--tw-pinch-zoom": " "
        });
        let cssTouchActionValue = "var(--tw-pan-x) var(--tw-pan-y) var(--tw-pinch-zoom)";
        addUtilities({
          ".touch-auto": {
            "touch-action": "auto"
          },
          ".touch-none": {
            "touch-action": "none"
          },
          ".touch-pan-x": {
            "@defaults touch-action": {},
            "--tw-pan-x": "pan-x",
            "touch-action": cssTouchActionValue
          },
          ".touch-pan-left": {
            "@defaults touch-action": {},
            "--tw-pan-x": "pan-left",
            "touch-action": cssTouchActionValue
          },
          ".touch-pan-right": {
            "@defaults touch-action": {},
            "--tw-pan-x": "pan-right",
            "touch-action": cssTouchActionValue
          },
          ".touch-pan-y": {
            "@defaults touch-action": {},
            "--tw-pan-y": "pan-y",
            "touch-action": cssTouchActionValue
          },
          ".touch-pan-up": {
            "@defaults touch-action": {},
            "--tw-pan-y": "pan-up",
            "touch-action": cssTouchActionValue
          },
          ".touch-pan-down": {
            "@defaults touch-action": {},
            "--tw-pan-y": "pan-down",
            "touch-action": cssTouchActionValue
          },
          ".touch-pinch-zoom": {
            "@defaults touch-action": {},
            "--tw-pinch-zoom": "pinch-zoom",
            "touch-action": cssTouchActionValue
          },
          ".touch-manipulation": {
            "touch-action": "manipulation"
          }
        });
      },
      userSelect: ({ addUtilities }) => {
        addUtilities({
          ".select-none": {
            "user-select": "none"
          },
          ".select-text": {
            "user-select": "text"
          },
          ".select-all": {
            "user-select": "all"
          },
          ".select-auto": {
            "user-select": "auto"
          }
        });
      },
      resize: ({ addUtilities }) => {
        addUtilities({
          ".resize-none": {
            resize: "none"
          },
          ".resize-y": {
            resize: "vertical"
          },
          ".resize-x": {
            resize: "horizontal"
          },
          ".resize": {
            resize: "both"
          }
        });
      },
      scrollSnapType: ({ addDefaults, addUtilities }) => {
        addDefaults("scroll-snap-type", {
          "--tw-scroll-snap-strictness": "proximity"
        });
        addUtilities({
          ".snap-none": {
            "scroll-snap-type": "none"
          },
          ".snap-x": {
            "@defaults scroll-snap-type": {},
            "scroll-snap-type": "x var(--tw-scroll-snap-strictness)"
          },
          ".snap-y": {
            "@defaults scroll-snap-type": {},
            "scroll-snap-type": "y var(--tw-scroll-snap-strictness)"
          },
          ".snap-both": {
            "@defaults scroll-snap-type": {},
            "scroll-snap-type": "both var(--tw-scroll-snap-strictness)"
          },
          ".snap-mandatory": {
            "--tw-scroll-snap-strictness": "mandatory"
          },
          ".snap-proximity": {
            "--tw-scroll-snap-strictness": "proximity"
          }
        });
      },
      scrollSnapAlign: ({ addUtilities }) => {
        addUtilities({
          ".snap-start": {
            "scroll-snap-align": "start"
          },
          ".snap-end": {
            "scroll-snap-align": "end"
          },
          ".snap-center": {
            "scroll-snap-align": "center"
          },
          ".snap-align-none": {
            "scroll-snap-align": "none"
          }
        });
      },
      scrollSnapStop: ({ addUtilities }) => {
        addUtilities({
          ".snap-normal": {
            "scroll-snap-stop": "normal"
          },
          ".snap-always": {
            "scroll-snap-stop": "always"
          }
        });
      },
      scrollMargin: (0, _createUtilityPlugin.default)("scrollMargin", [
        [
          "scroll-m",
          [
            "scroll-margin"
          ]
        ],
        [
          [
            "scroll-mx",
            [
              "scroll-margin-left",
              "scroll-margin-right"
            ]
          ],
          [
            "scroll-my",
            [
              "scroll-margin-top",
              "scroll-margin-bottom"
            ]
          ]
        ],
        [
          [
            "scroll-ms",
            [
              "scroll-margin-inline-start"
            ]
          ],
          [
            "scroll-me",
            [
              "scroll-margin-inline-end"
            ]
          ],
          [
            "scroll-mt",
            [
              "scroll-margin-top"
            ]
          ],
          [
            "scroll-mr",
            [
              "scroll-margin-right"
            ]
          ],
          [
            "scroll-mb",
            [
              "scroll-margin-bottom"
            ]
          ],
          [
            "scroll-ml",
            [
              "scroll-margin-left"
            ]
          ]
        ]
      ], {
        supportsNegativeValues: true
      }),
      scrollPadding: (0, _createUtilityPlugin.default)("scrollPadding", [
        [
          "scroll-p",
          [
            "scroll-padding"
          ]
        ],
        [
          [
            "scroll-px",
            [
              "scroll-padding-left",
              "scroll-padding-right"
            ]
          ],
          [
            "scroll-py",
            [
              "scroll-padding-top",
              "scroll-padding-bottom"
            ]
          ]
        ],
        [
          [
            "scroll-ps",
            [
              "scroll-padding-inline-start"
            ]
          ],
          [
            "scroll-pe",
            [
              "scroll-padding-inline-end"
            ]
          ],
          [
            "scroll-pt",
            [
              "scroll-padding-top"
            ]
          ],
          [
            "scroll-pr",
            [
              "scroll-padding-right"
            ]
          ],
          [
            "scroll-pb",
            [
              "scroll-padding-bottom"
            ]
          ],
          [
            "scroll-pl",
            [
              "scroll-padding-left"
            ]
          ]
        ]
      ]),
      listStylePosition: ({ addUtilities }) => {
        addUtilities({
          ".list-inside": {
            "list-style-position": "inside"
          },
          ".list-outside": {
            "list-style-position": "outside"
          }
        });
      },
      listStyleType: (0, _createUtilityPlugin.default)("listStyleType", [
        [
          "list",
          [
            "listStyleType"
          ]
        ]
      ]),
      listStyleImage: (0, _createUtilityPlugin.default)("listStyleImage", [
        [
          "list-image",
          [
            "listStyleImage"
          ]
        ]
      ]),
      appearance: ({ addUtilities }) => {
        addUtilities({
          ".appearance-none": {
            appearance: "none"
          },
          ".appearance-auto": {
            appearance: "auto"
          }
        });
      },
      columns: (0, _createUtilityPlugin.default)("columns", [
        [
          "columns",
          [
            "columns"
          ]
        ]
      ]),
      breakBefore: ({ addUtilities }) => {
        addUtilities({
          ".break-before-auto": {
            "break-before": "auto"
          },
          ".break-before-avoid": {
            "break-before": "avoid"
          },
          ".break-before-all": {
            "break-before": "all"
          },
          ".break-before-avoid-page": {
            "break-before": "avoid-page"
          },
          ".break-before-page": {
            "break-before": "page"
          },
          ".break-before-left": {
            "break-before": "left"
          },
          ".break-before-right": {
            "break-before": "right"
          },
          ".break-before-column": {
            "break-before": "column"
          }
        });
      },
      breakInside: ({ addUtilities }) => {
        addUtilities({
          ".break-inside-auto": {
            "break-inside": "auto"
          },
          ".break-inside-avoid": {
            "break-inside": "avoid"
          },
          ".break-inside-avoid-page": {
            "break-inside": "avoid-page"
          },
          ".break-inside-avoid-column": {
            "break-inside": "avoid-column"
          }
        });
      },
      breakAfter: ({ addUtilities }) => {
        addUtilities({
          ".break-after-auto": {
            "break-after": "auto"
          },
          ".break-after-avoid": {
            "break-after": "avoid"
          },
          ".break-after-all": {
            "break-after": "all"
          },
          ".break-after-avoid-page": {
            "break-after": "avoid-page"
          },
          ".break-after-page": {
            "break-after": "page"
          },
          ".break-after-left": {
            "break-after": "left"
          },
          ".break-after-right": {
            "break-after": "right"
          },
          ".break-after-column": {
            "break-after": "column"
          }
        });
      },
      gridAutoColumns: (0, _createUtilityPlugin.default)("gridAutoColumns", [
        [
          "auto-cols",
          [
            "gridAutoColumns"
          ]
        ]
      ]),
      gridAutoFlow: ({ addUtilities }) => {
        addUtilities({
          ".grid-flow-row": {
            gridAutoFlow: "row"
          },
          ".grid-flow-col": {
            gridAutoFlow: "column"
          },
          ".grid-flow-dense": {
            gridAutoFlow: "dense"
          },
          ".grid-flow-row-dense": {
            gridAutoFlow: "row dense"
          },
          ".grid-flow-col-dense": {
            gridAutoFlow: "column dense"
          }
        });
      },
      gridAutoRows: (0, _createUtilityPlugin.default)("gridAutoRows", [
        [
          "auto-rows",
          [
            "gridAutoRows"
          ]
        ]
      ]),
      gridTemplateColumns: (0, _createUtilityPlugin.default)("gridTemplateColumns", [
        [
          "grid-cols",
          [
            "gridTemplateColumns"
          ]
        ]
      ]),
      gridTemplateRows: (0, _createUtilityPlugin.default)("gridTemplateRows", [
        [
          "grid-rows",
          [
            "gridTemplateRows"
          ]
        ]
      ]),
      flexDirection: ({ addUtilities }) => {
        addUtilities({
          ".flex-row": {
            "flex-direction": "row"
          },
          ".flex-row-reverse": {
            "flex-direction": "row-reverse"
          },
          ".flex-col": {
            "flex-direction": "column"
          },
          ".flex-col-reverse": {
            "flex-direction": "column-reverse"
          }
        });
      },
      flexWrap: ({ addUtilities }) => {
        addUtilities({
          ".flex-wrap": {
            "flex-wrap": "wrap"
          },
          ".flex-wrap-reverse": {
            "flex-wrap": "wrap-reverse"
          },
          ".flex-nowrap": {
            "flex-wrap": "nowrap"
          }
        });
      },
      placeContent: ({ addUtilities }) => {
        addUtilities({
          ".place-content-center": {
            "place-content": "center"
          },
          ".place-content-start": {
            "place-content": "start"
          },
          ".place-content-end": {
            "place-content": "end"
          },
          ".place-content-between": {
            "place-content": "space-between"
          },
          ".place-content-around": {
            "place-content": "space-around"
          },
          ".place-content-evenly": {
            "place-content": "space-evenly"
          },
          ".place-content-baseline": {
            "place-content": "baseline"
          },
          ".place-content-stretch": {
            "place-content": "stretch"
          }
        });
      },
      placeItems: ({ addUtilities }) => {
        addUtilities({
          ".place-items-start": {
            "place-items": "start"
          },
          ".place-items-end": {
            "place-items": "end"
          },
          ".place-items-center": {
            "place-items": "center"
          },
          ".place-items-baseline": {
            "place-items": "baseline"
          },
          ".place-items-stretch": {
            "place-items": "stretch"
          }
        });
      },
      alignContent: ({ addUtilities }) => {
        addUtilities({
          ".content-normal": {
            "align-content": "normal"
          },
          ".content-center": {
            "align-content": "center"
          },
          ".content-start": {
            "align-content": "flex-start"
          },
          ".content-end": {
            "align-content": "flex-end"
          },
          ".content-between": {
            "align-content": "space-between"
          },
          ".content-around": {
            "align-content": "space-around"
          },
          ".content-evenly": {
            "align-content": "space-evenly"
          },
          ".content-baseline": {
            "align-content": "baseline"
          },
          ".content-stretch": {
            "align-content": "stretch"
          }
        });
      },
      alignItems: ({ addUtilities }) => {
        addUtilities({
          ".items-start": {
            "align-items": "flex-start"
          },
          ".items-end": {
            "align-items": "flex-end"
          },
          ".items-center": {
            "align-items": "center"
          },
          ".items-baseline": {
            "align-items": "baseline"
          },
          ".items-stretch": {
            "align-items": "stretch"
          }
        });
      },
      justifyContent: ({ addUtilities }) => {
        addUtilities({
          ".justify-normal": {
            "justify-content": "normal"
          },
          ".justify-start": {
            "justify-content": "flex-start"
          },
          ".justify-end": {
            "justify-content": "flex-end"
          },
          ".justify-center": {
            "justify-content": "center"
          },
          ".justify-between": {
            "justify-content": "space-between"
          },
          ".justify-around": {
            "justify-content": "space-around"
          },
          ".justify-evenly": {
            "justify-content": "space-evenly"
          },
          ".justify-stretch": {
            "justify-content": "stretch"
          }
        });
      },
      justifyItems: ({ addUtilities }) => {
        addUtilities({
          ".justify-items-start": {
            "justify-items": "start"
          },
          ".justify-items-end": {
            "justify-items": "end"
          },
          ".justify-items-center": {
            "justify-items": "center"
          },
          ".justify-items-stretch": {
            "justify-items": "stretch"
          }
        });
      },
      gap: (0, _createUtilityPlugin.default)("gap", [
        [
          "gap",
          [
            "gap"
          ]
        ],
        [
          [
            "gap-x",
            [
              "columnGap"
            ]
          ],
          [
            "gap-y",
            [
              "rowGap"
            ]
          ]
        ]
      ]),
      space: ({ matchUtilities, addUtilities, theme }) => {
        matchUtilities({
          "space-x": (value2) => {
            value2 = value2 === "0" ? "0px" : value2;
            return {
              "& > :not([hidden]) ~ :not([hidden])": {
                "--tw-space-x-reverse": "0",
                "margin-right": `calc(${value2} * var(--tw-space-x-reverse))`,
                "margin-left": `calc(${value2} * calc(1 - var(--tw-space-x-reverse)))`
              }
            };
          },
          "space-y": (value2) => {
            value2 = value2 === "0" ? "0px" : value2;
            return {
              "& > :not([hidden]) ~ :not([hidden])": {
                "--tw-space-y-reverse": "0",
                "margin-top": `calc(${value2} * calc(1 - var(--tw-space-y-reverse)))`,
                "margin-bottom": `calc(${value2} * var(--tw-space-y-reverse))`
              }
            };
          }
        }, {
          values: theme("space"),
          supportsNegativeValues: true
        });
        addUtilities({
          ".space-y-reverse > :not([hidden]) ~ :not([hidden])": {
            "--tw-space-y-reverse": "1"
          },
          ".space-x-reverse > :not([hidden]) ~ :not([hidden])": {
            "--tw-space-x-reverse": "1"
          }
        });
      },
      divideWidth: ({ matchUtilities, addUtilities, theme }) => {
        matchUtilities({
          "divide-x": (value2) => {
            value2 = value2 === "0" ? "0px" : value2;
            return {
              "& > :not([hidden]) ~ :not([hidden])": {
                "@defaults border-width": {},
                "--tw-divide-x-reverse": "0",
                "border-right-width": `calc(${value2} * var(--tw-divide-x-reverse))`,
                "border-left-width": `calc(${value2} * calc(1 - var(--tw-divide-x-reverse)))`
              }
            };
          },
          "divide-y": (value2) => {
            value2 = value2 === "0" ? "0px" : value2;
            return {
              "& > :not([hidden]) ~ :not([hidden])": {
                "@defaults border-width": {},
                "--tw-divide-y-reverse": "0",
                "border-top-width": `calc(${value2} * calc(1 - var(--tw-divide-y-reverse)))`,
                "border-bottom-width": `calc(${value2} * var(--tw-divide-y-reverse))`
              }
            };
          }
        }, {
          values: theme("divideWidth"),
          type: [
            "line-width",
            "length",
            "any"
          ]
        });
        addUtilities({
          ".divide-y-reverse > :not([hidden]) ~ :not([hidden])": {
            "@defaults border-width": {},
            "--tw-divide-y-reverse": "1"
          },
          ".divide-x-reverse > :not([hidden]) ~ :not([hidden])": {
            "@defaults border-width": {},
            "--tw-divide-x-reverse": "1"
          }
        });
      },
      divideStyle: ({ addUtilities }) => {
        addUtilities({
          ".divide-solid > :not([hidden]) ~ :not([hidden])": {
            "border-style": "solid"
          },
          ".divide-dashed > :not([hidden]) ~ :not([hidden])": {
            "border-style": "dashed"
          },
          ".divide-dotted > :not([hidden]) ~ :not([hidden])": {
            "border-style": "dotted"
          },
          ".divide-double > :not([hidden]) ~ :not([hidden])": {
            "border-style": "double"
          },
          ".divide-none > :not([hidden]) ~ :not([hidden])": {
            "border-style": "none"
          }
        });
      },
      divideColor: ({ matchUtilities, theme, corePlugins: corePlugins2 }) => {
        matchUtilities({
          divide: (value2) => {
            if (!corePlugins2("divideOpacity")) {
              return {
                ["& > :not([hidden]) ~ :not([hidden])"]: {
                  "border-color": (0, _toColorValue.default)(value2)
                }
              };
            }
            return {
              ["& > :not([hidden]) ~ :not([hidden])"]: (0, _withAlphaVariable.default)({
                color: value2,
                property: "border-color",
                variable: "--tw-divide-opacity"
              })
            };
          }
        }, {
          values: (({ DEFAULT: _, ...colors }) => colors)((0, _flattenColorPalette.default)(theme("divideColor"))),
          type: [
            "color",
            "any"
          ]
        });
      },
      divideOpacity: ({ matchUtilities, theme }) => {
        matchUtilities({
          "divide-opacity": (value2) => {
            return {
              [`& > :not([hidden]) ~ :not([hidden])`]: {
                "--tw-divide-opacity": value2
              }
            };
          }
        }, {
          values: theme("divideOpacity")
        });
      },
      placeSelf: ({ addUtilities }) => {
        addUtilities({
          ".place-self-auto": {
            "place-self": "auto"
          },
          ".place-self-start": {
            "place-self": "start"
          },
          ".place-self-end": {
            "place-self": "end"
          },
          ".place-self-center": {
            "place-self": "center"
          },
          ".place-self-stretch": {
            "place-self": "stretch"
          }
        });
      },
      alignSelf: ({ addUtilities }) => {
        addUtilities({
          ".self-auto": {
            "align-self": "auto"
          },
          ".self-start": {
            "align-self": "flex-start"
          },
          ".self-end": {
            "align-self": "flex-end"
          },
          ".self-center": {
            "align-self": "center"
          },
          ".self-stretch": {
            "align-self": "stretch"
          },
          ".self-baseline": {
            "align-self": "baseline"
          }
        });
      },
      justifySelf: ({ addUtilities }) => {
        addUtilities({
          ".justify-self-auto": {
            "justify-self": "auto"
          },
          ".justify-self-start": {
            "justify-self": "start"
          },
          ".justify-self-end": {
            "justify-self": "end"
          },
          ".justify-self-center": {
            "justify-self": "center"
          },
          ".justify-self-stretch": {
            "justify-self": "stretch"
          }
        });
      },
      overflow: ({ addUtilities }) => {
        addUtilities({
          ".overflow-auto": {
            overflow: "auto"
          },
          ".overflow-hidden": {
            overflow: "hidden"
          },
          ".overflow-clip": {
            overflow: "clip"
          },
          ".overflow-visible": {
            overflow: "visible"
          },
          ".overflow-scroll": {
            overflow: "scroll"
          },
          ".overflow-x-auto": {
            "overflow-x": "auto"
          },
          ".overflow-y-auto": {
            "overflow-y": "auto"
          },
          ".overflow-x-hidden": {
            "overflow-x": "hidden"
          },
          ".overflow-y-hidden": {
            "overflow-y": "hidden"
          },
          ".overflow-x-clip": {
            "overflow-x": "clip"
          },
          ".overflow-y-clip": {
            "overflow-y": "clip"
          },
          ".overflow-x-visible": {
            "overflow-x": "visible"
          },
          ".overflow-y-visible": {
            "overflow-y": "visible"
          },
          ".overflow-x-scroll": {
            "overflow-x": "scroll"
          },
          ".overflow-y-scroll": {
            "overflow-y": "scroll"
          }
        });
      },
      overscrollBehavior: ({ addUtilities }) => {
        addUtilities({
          ".overscroll-auto": {
            "overscroll-behavior": "auto"
          },
          ".overscroll-contain": {
            "overscroll-behavior": "contain"
          },
          ".overscroll-none": {
            "overscroll-behavior": "none"
          },
          ".overscroll-y-auto": {
            "overscroll-behavior-y": "auto"
          },
          ".overscroll-y-contain": {
            "overscroll-behavior-y": "contain"
          },
          ".overscroll-y-none": {
            "overscroll-behavior-y": "none"
          },
          ".overscroll-x-auto": {
            "overscroll-behavior-x": "auto"
          },
          ".overscroll-x-contain": {
            "overscroll-behavior-x": "contain"
          },
          ".overscroll-x-none": {
            "overscroll-behavior-x": "none"
          }
        });
      },
      scrollBehavior: ({ addUtilities }) => {
        addUtilities({
          ".scroll-auto": {
            "scroll-behavior": "auto"
          },
          ".scroll-smooth": {
            "scroll-behavior": "smooth"
          }
        });
      },
      textOverflow: ({ addUtilities }) => {
        addUtilities({
          ".truncate": {
            overflow: "hidden",
            "text-overflow": "ellipsis",
            "white-space": "nowrap"
          },
          ".overflow-ellipsis": {
            "text-overflow": "ellipsis"
          },
          ".text-ellipsis": {
            "text-overflow": "ellipsis"
          },
          ".text-clip": {
            "text-overflow": "clip"
          }
        });
      },
      hyphens: ({ addUtilities }) => {
        addUtilities({
          ".hyphens-none": {
            hyphens: "none"
          },
          ".hyphens-manual": {
            hyphens: "manual"
          },
          ".hyphens-auto": {
            hyphens: "auto"
          }
        });
      },
      whitespace: ({ addUtilities }) => {
        addUtilities({
          ".whitespace-normal": {
            "white-space": "normal"
          },
          ".whitespace-nowrap": {
            "white-space": "nowrap"
          },
          ".whitespace-pre": {
            "white-space": "pre"
          },
          ".whitespace-pre-line": {
            "white-space": "pre-line"
          },
          ".whitespace-pre-wrap": {
            "white-space": "pre-wrap"
          },
          ".whitespace-break-spaces": {
            "white-space": "break-spaces"
          }
        });
      },
      textWrap: ({ addUtilities }) => {
        addUtilities({
          ".text-wrap": {
            "text-wrap": "wrap"
          },
          ".text-nowrap": {
            "text-wrap": "nowrap"
          },
          ".text-balance": {
            "text-wrap": "balance"
          },
          ".text-pretty": {
            "text-wrap": "pretty"
          }
        });
      },
      wordBreak: ({ addUtilities }) => {
        addUtilities({
          ".break-normal": {
            "overflow-wrap": "normal",
            "word-break": "normal"
          },
          ".break-words": {
            "overflow-wrap": "break-word"
          },
          ".break-all": {
            "word-break": "break-all"
          },
          ".break-keep": {
            "word-break": "keep-all"
          }
        });
      },
      borderRadius: (0, _createUtilityPlugin.default)("borderRadius", [
        [
          "rounded",
          [
            "border-radius"
          ]
        ],
        [
          [
            "rounded-s",
            [
              "border-start-start-radius",
              "border-end-start-radius"
            ]
          ],
          [
            "rounded-e",
            [
              "border-start-end-radius",
              "border-end-end-radius"
            ]
          ],
          [
            "rounded-t",
            [
              "border-top-left-radius",
              "border-top-right-radius"
            ]
          ],
          [
            "rounded-r",
            [
              "border-top-right-radius",
              "border-bottom-right-radius"
            ]
          ],
          [
            "rounded-b",
            [
              "border-bottom-right-radius",
              "border-bottom-left-radius"
            ]
          ],
          [
            "rounded-l",
            [
              "border-top-left-radius",
              "border-bottom-left-radius"
            ]
          ]
        ],
        [
          [
            "rounded-ss",
            [
              "border-start-start-radius"
            ]
          ],
          [
            "rounded-se",
            [
              "border-start-end-radius"
            ]
          ],
          [
            "rounded-ee",
            [
              "border-end-end-radius"
            ]
          ],
          [
            "rounded-es",
            [
              "border-end-start-radius"
            ]
          ],
          [
            "rounded-tl",
            [
              "border-top-left-radius"
            ]
          ],
          [
            "rounded-tr",
            [
              "border-top-right-radius"
            ]
          ],
          [
            "rounded-br",
            [
              "border-bottom-right-radius"
            ]
          ],
          [
            "rounded-bl",
            [
              "border-bottom-left-radius"
            ]
          ]
        ]
      ]),
      borderWidth: (0, _createUtilityPlugin.default)("borderWidth", [
        [
          "border",
          [
            [
              "@defaults border-width",
              {}
            ],
            "border-width"
          ]
        ],
        [
          [
            "border-x",
            [
              [
                "@defaults border-width",
                {}
              ],
              "border-left-width",
              "border-right-width"
            ]
          ],
          [
            "border-y",
            [
              [
                "@defaults border-width",
                {}
              ],
              "border-top-width",
              "border-bottom-width"
            ]
          ]
        ],
        [
          [
            "border-s",
            [
              [
                "@defaults border-width",
                {}
              ],
              "border-inline-start-width"
            ]
          ],
          [
            "border-e",
            [
              [
                "@defaults border-width",
                {}
              ],
              "border-inline-end-width"
            ]
          ],
          [
            "border-t",
            [
              [
                "@defaults border-width",
                {}
              ],
              "border-top-width"
            ]
          ],
          [
            "border-r",
            [
              [
                "@defaults border-width",
                {}
              ],
              "border-right-width"
            ]
          ],
          [
            "border-b",
            [
              [
                "@defaults border-width",
                {}
              ],
              "border-bottom-width"
            ]
          ],
          [
            "border-l",
            [
              [
                "@defaults border-width",
                {}
              ],
              "border-left-width"
            ]
          ]
        ]
      ], {
        type: [
          "line-width",
          "length"
        ]
      }),
      borderStyle: ({ addUtilities }) => {
        addUtilities({
          ".border-solid": {
            "border-style": "solid"
          },
          ".border-dashed": {
            "border-style": "dashed"
          },
          ".border-dotted": {
            "border-style": "dotted"
          },
          ".border-double": {
            "border-style": "double"
          },
          ".border-hidden": {
            "border-style": "hidden"
          },
          ".border-none": {
            "border-style": "none"
          }
        });
      },
      borderColor: ({ matchUtilities, theme, corePlugins: corePlugins2 }) => {
        matchUtilities({
          border: (value2) => {
            if (!corePlugins2("borderOpacity")) {
              return {
                "border-color": (0, _toColorValue.default)(value2)
              };
            }
            return (0, _withAlphaVariable.default)({
              color: value2,
              property: "border-color",
              variable: "--tw-border-opacity"
            });
          }
        }, {
          values: (({ DEFAULT: _, ...colors }) => colors)((0, _flattenColorPalette.default)(theme("borderColor"))),
          type: [
            "color",
            "any"
          ]
        });
        matchUtilities({
          "border-x": (value2) => {
            if (!corePlugins2("borderOpacity")) {
              return {
                "border-left-color": (0, _toColorValue.default)(value2),
                "border-right-color": (0, _toColorValue.default)(value2)
              };
            }
            return (0, _withAlphaVariable.default)({
              color: value2,
              property: [
                "border-left-color",
                "border-right-color"
              ],
              variable: "--tw-border-opacity"
            });
          },
          "border-y": (value2) => {
            if (!corePlugins2("borderOpacity")) {
              return {
                "border-top-color": (0, _toColorValue.default)(value2),
                "border-bottom-color": (0, _toColorValue.default)(value2)
              };
            }
            return (0, _withAlphaVariable.default)({
              color: value2,
              property: [
                "border-top-color",
                "border-bottom-color"
              ],
              variable: "--tw-border-opacity"
            });
          }
        }, {
          values: (({ DEFAULT: _, ...colors }) => colors)((0, _flattenColorPalette.default)(theme("borderColor"))),
          type: [
            "color",
            "any"
          ]
        });
        matchUtilities({
          "border-s": (value2) => {
            if (!corePlugins2("borderOpacity")) {
              return {
                "border-inline-start-color": (0, _toColorValue.default)(value2)
              };
            }
            return (0, _withAlphaVariable.default)({
              color: value2,
              property: "border-inline-start-color",
              variable: "--tw-border-opacity"
            });
          },
          "border-e": (value2) => {
            if (!corePlugins2("borderOpacity")) {
              return {
                "border-inline-end-color": (0, _toColorValue.default)(value2)
              };
            }
            return (0, _withAlphaVariable.default)({
              color: value2,
              property: "border-inline-end-color",
              variable: "--tw-border-opacity"
            });
          },
          "border-t": (value2) => {
            if (!corePlugins2("borderOpacity")) {
              return {
                "border-top-color": (0, _toColorValue.default)(value2)
              };
            }
            return (0, _withAlphaVariable.default)({
              color: value2,
              property: "border-top-color",
              variable: "--tw-border-opacity"
            });
          },
          "border-r": (value2) => {
            if (!corePlugins2("borderOpacity")) {
              return {
                "border-right-color": (0, _toColorValue.default)(value2)
              };
            }
            return (0, _withAlphaVariable.default)({
              color: value2,
              property: "border-right-color",
              variable: "--tw-border-opacity"
            });
          },
          "border-b": (value2) => {
            if (!corePlugins2("borderOpacity")) {
              return {
                "border-bottom-color": (0, _toColorValue.default)(value2)
              };
            }
            return (0, _withAlphaVariable.default)({
              color: value2,
              property: "border-bottom-color",
              variable: "--tw-border-opacity"
            });
          },
          "border-l": (value2) => {
            if (!corePlugins2("borderOpacity")) {
              return {
                "border-left-color": (0, _toColorValue.default)(value2)
              };
            }
            return (0, _withAlphaVariable.default)({
              color: value2,
              property: "border-left-color",
              variable: "--tw-border-opacity"
            });
          }
        }, {
          values: (({ DEFAULT: _, ...colors }) => colors)((0, _flattenColorPalette.default)(theme("borderColor"))),
          type: [
            "color",
            "any"
          ]
        });
      },
      borderOpacity: (0, _createUtilityPlugin.default)("borderOpacity", [
        [
          "border-opacity",
          [
            "--tw-border-opacity"
          ]
        ]
      ]),
      backgroundColor: ({ matchUtilities, theme, corePlugins: corePlugins2 }) => {
        matchUtilities({
          bg: (value2) => {
            if (!corePlugins2("backgroundOpacity")) {
              return {
                "background-color": (0, _toColorValue.default)(value2)
              };
            }
            return (0, _withAlphaVariable.default)({
              color: value2,
              property: "background-color",
              variable: "--tw-bg-opacity"
            });
          }
        }, {
          values: (0, _flattenColorPalette.default)(theme("backgroundColor")),
          type: [
            "color",
            "any"
          ]
        });
      },
      backgroundOpacity: (0, _createUtilityPlugin.default)("backgroundOpacity", [
        [
          "bg-opacity",
          [
            "--tw-bg-opacity"
          ]
        ]
      ]),
      backgroundImage: (0, _createUtilityPlugin.default)("backgroundImage", [
        [
          "bg",
          [
            "background-image"
          ]
        ]
      ], {
        type: [
          "lookup",
          "image",
          "url"
        ]
      }),
      gradientColorStops: (() => {
        function transparentTo(value2) {
          return (0, _withAlphaVariable.withAlphaValue)(value2, 0, "rgb(255 255 255 / 0)");
        }
        return function({ matchUtilities, theme, addDefaults }) {
          addDefaults("gradient-color-stops", {
            "--tw-gradient-from-position": " ",
            "--tw-gradient-via-position": " ",
            "--tw-gradient-to-position": " "
          });
          let options = {
            values: (0, _flattenColorPalette.default)(theme("gradientColorStops")),
            type: [
              "color",
              "any"
            ]
          };
          let positionOptions = {
            values: theme("gradientColorStopPositions"),
            type: [
              "length",
              "percentage"
            ]
          };
          matchUtilities({
            from: (value2) => {
              let transparentToValue = transparentTo(value2);
              return {
                "@defaults gradient-color-stops": {},
                "--tw-gradient-from": `${(0, _toColorValue.default)(value2)} var(--tw-gradient-from-position)`,
                "--tw-gradient-to": `${transparentToValue} var(--tw-gradient-to-position)`,
                "--tw-gradient-stops": `var(--tw-gradient-from), var(--tw-gradient-to)`
              };
            }
          }, options);
          matchUtilities({
            from: (value2) => {
              return {
                "--tw-gradient-from-position": value2
              };
            }
          }, positionOptions);
          matchUtilities({
            via: (value2) => {
              let transparentToValue = transparentTo(value2);
              return {
                "@defaults gradient-color-stops": {},
                "--tw-gradient-to": `${transparentToValue}  var(--tw-gradient-to-position)`,
                "--tw-gradient-stops": `var(--tw-gradient-from), ${(0, _toColorValue.default)(value2)} var(--tw-gradient-via-position), var(--tw-gradient-to)`
              };
            }
          }, options);
          matchUtilities({
            via: (value2) => {
              return {
                "--tw-gradient-via-position": value2
              };
            }
          }, positionOptions);
          matchUtilities({
            to: (value2) => ({
              "@defaults gradient-color-stops": {},
              "--tw-gradient-to": `${(0, _toColorValue.default)(value2)} var(--tw-gradient-to-position)`
            })
          }, options);
          matchUtilities({
            to: (value2) => {
              return {
                "--tw-gradient-to-position": value2
              };
            }
          }, positionOptions);
        };
      })(),
      boxDecorationBreak: ({ addUtilities }) => {
        addUtilities({
          ".decoration-slice": {
            "box-decoration-break": "slice"
          },
          ".decoration-clone": {
            "box-decoration-break": "clone"
          },
          ".box-decoration-slice": {
            "box-decoration-break": "slice"
          },
          ".box-decoration-clone": {
            "box-decoration-break": "clone"
          }
        });
      },
      backgroundSize: (0, _createUtilityPlugin.default)("backgroundSize", [
        [
          "bg",
          [
            "background-size"
          ]
        ]
      ], {
        type: [
          "lookup",
          "length",
          "percentage",
          "size"
        ]
      }),
      backgroundAttachment: ({ addUtilities }) => {
        addUtilities({
          ".bg-fixed": {
            "background-attachment": "fixed"
          },
          ".bg-local": {
            "background-attachment": "local"
          },
          ".bg-scroll": {
            "background-attachment": "scroll"
          }
        });
      },
      backgroundClip: ({ addUtilities }) => {
        addUtilities({
          ".bg-clip-border": {
            "background-clip": "border-box"
          },
          ".bg-clip-padding": {
            "background-clip": "padding-box"
          },
          ".bg-clip-content": {
            "background-clip": "content-box"
          },
          ".bg-clip-text": {
            "background-clip": "text"
          }
        });
      },
      backgroundPosition: (0, _createUtilityPlugin.default)("backgroundPosition", [
        [
          "bg",
          [
            "background-position"
          ]
        ]
      ], {
        type: [
          "lookup",
          [
            "position",
            {
              preferOnConflict: true
            }
          ]
        ]
      }),
      backgroundRepeat: ({ addUtilities }) => {
        addUtilities({
          ".bg-repeat": {
            "background-repeat": "repeat"
          },
          ".bg-no-repeat": {
            "background-repeat": "no-repeat"
          },
          ".bg-repeat-x": {
            "background-repeat": "repeat-x"
          },
          ".bg-repeat-y": {
            "background-repeat": "repeat-y"
          },
          ".bg-repeat-round": {
            "background-repeat": "round"
          },
          ".bg-repeat-space": {
            "background-repeat": "space"
          }
        });
      },
      backgroundOrigin: ({ addUtilities }) => {
        addUtilities({
          ".bg-origin-border": {
            "background-origin": "border-box"
          },
          ".bg-origin-padding": {
            "background-origin": "padding-box"
          },
          ".bg-origin-content": {
            "background-origin": "content-box"
          }
        });
      },
      fill: ({ matchUtilities, theme }) => {
        matchUtilities({
          fill: (value2) => {
            return {
              fill: (0, _toColorValue.default)(value2)
            };
          }
        }, {
          values: (0, _flattenColorPalette.default)(theme("fill")),
          type: [
            "color",
            "any"
          ]
        });
      },
      stroke: ({ matchUtilities, theme }) => {
        matchUtilities({
          stroke: (value2) => {
            return {
              stroke: (0, _toColorValue.default)(value2)
            };
          }
        }, {
          values: (0, _flattenColorPalette.default)(theme("stroke")),
          type: [
            "color",
            "url",
            "any"
          ]
        });
      },
      strokeWidth: (0, _createUtilityPlugin.default)("strokeWidth", [
        [
          "stroke",
          [
            "stroke-width"
          ]
        ]
      ], {
        type: [
          "length",
          "number",
          "percentage"
        ]
      }),
      objectFit: ({ addUtilities }) => {
        addUtilities({
          ".object-contain": {
            "object-fit": "contain"
          },
          ".object-cover": {
            "object-fit": "cover"
          },
          ".object-fill": {
            "object-fit": "fill"
          },
          ".object-none": {
            "object-fit": "none"
          },
          ".object-scale-down": {
            "object-fit": "scale-down"
          }
        });
      },
      objectPosition: (0, _createUtilityPlugin.default)("objectPosition", [
        [
          "object",
          [
            "object-position"
          ]
        ]
      ]),
      padding: (0, _createUtilityPlugin.default)("padding", [
        [
          "p",
          [
            "padding"
          ]
        ],
        [
          [
            "px",
            [
              "padding-left",
              "padding-right"
            ]
          ],
          [
            "py",
            [
              "padding-top",
              "padding-bottom"
            ]
          ]
        ],
        [
          [
            "ps",
            [
              "padding-inline-start"
            ]
          ],
          [
            "pe",
            [
              "padding-inline-end"
            ]
          ],
          [
            "pt",
            [
              "padding-top"
            ]
          ],
          [
            "pr",
            [
              "padding-right"
            ]
          ],
          [
            "pb",
            [
              "padding-bottom"
            ]
          ],
          [
            "pl",
            [
              "padding-left"
            ]
          ]
        ]
      ]),
      textAlign: ({ addUtilities }) => {
        addUtilities({
          ".text-left": {
            "text-align": "left"
          },
          ".text-center": {
            "text-align": "center"
          },
          ".text-right": {
            "text-align": "right"
          },
          ".text-justify": {
            "text-align": "justify"
          },
          ".text-start": {
            "text-align": "start"
          },
          ".text-end": {
            "text-align": "end"
          }
        });
      },
      textIndent: (0, _createUtilityPlugin.default)("textIndent", [
        [
          "indent",
          [
            "text-indent"
          ]
        ]
      ], {
        supportsNegativeValues: true
      }),
      verticalAlign: ({ addUtilities, matchUtilities }) => {
        addUtilities({
          ".align-baseline": {
            "vertical-align": "baseline"
          },
          ".align-top": {
            "vertical-align": "top"
          },
          ".align-middle": {
            "vertical-align": "middle"
          },
          ".align-bottom": {
            "vertical-align": "bottom"
          },
          ".align-text-top": {
            "vertical-align": "text-top"
          },
          ".align-text-bottom": {
            "vertical-align": "text-bottom"
          },
          ".align-sub": {
            "vertical-align": "sub"
          },
          ".align-super": {
            "vertical-align": "super"
          }
        });
        matchUtilities({
          align: (value2) => ({
            "vertical-align": value2
          })
        });
      },
      fontFamily: ({ matchUtilities, theme }) => {
        matchUtilities({
          font: (value2) => {
            let [families, options = {}] = Array.isArray(value2) && (0, _isPlainObject.default)(value2[1]) ? value2 : [
              value2
            ];
            let { fontFeatureSettings, fontVariationSettings } = options;
            return {
              "font-family": Array.isArray(families) ? families.join(", ") : families,
              ...fontFeatureSettings === void 0 ? {} : {
                "font-feature-settings": fontFeatureSettings
              },
              ...fontVariationSettings === void 0 ? {} : {
                "font-variation-settings": fontVariationSettings
              }
            };
          }
        }, {
          values: theme("fontFamily"),
          type: [
            "lookup",
            "generic-name",
            "family-name"
          ]
        });
      },
      fontSize: ({ matchUtilities, theme }) => {
        matchUtilities({
          text: (value2, { modifier }) => {
            let [fontSize, options] = Array.isArray(value2) ? value2 : [
              value2
            ];
            if (modifier) {
              return {
                "font-size": fontSize,
                "line-height": modifier
              };
            }
            let { lineHeight, letterSpacing, fontWeight } = (0, _isPlainObject.default)(options) ? options : {
              lineHeight: options
            };
            return {
              "font-size": fontSize,
              ...lineHeight === void 0 ? {} : {
                "line-height": lineHeight
              },
              ...letterSpacing === void 0 ? {} : {
                "letter-spacing": letterSpacing
              },
              ...fontWeight === void 0 ? {} : {
                "font-weight": fontWeight
              }
            };
          }
        }, {
          values: theme("fontSize"),
          modifiers: theme("lineHeight"),
          type: [
            "absolute-size",
            "relative-size",
            "length",
            "percentage"
          ]
        });
      },
      fontWeight: (0, _createUtilityPlugin.default)("fontWeight", [
        [
          "font",
          [
            "fontWeight"
          ]
        ]
      ], {
        type: [
          "lookup",
          "number",
          "any"
        ]
      }),
      textTransform: ({ addUtilities }) => {
        addUtilities({
          ".uppercase": {
            "text-transform": "uppercase"
          },
          ".lowercase": {
            "text-transform": "lowercase"
          },
          ".capitalize": {
            "text-transform": "capitalize"
          },
          ".normal-case": {
            "text-transform": "none"
          }
        });
      },
      fontStyle: ({ addUtilities }) => {
        addUtilities({
          ".italic": {
            "font-style": "italic"
          },
          ".not-italic": {
            "font-style": "normal"
          }
        });
      },
      fontVariantNumeric: ({ addDefaults, addUtilities }) => {
        let cssFontVariantNumericValue = "var(--tw-ordinal) var(--tw-slashed-zero) var(--tw-numeric-figure) var(--tw-numeric-spacing) var(--tw-numeric-fraction)";
        addDefaults("font-variant-numeric", {
          "--tw-ordinal": " ",
          "--tw-slashed-zero": " ",
          "--tw-numeric-figure": " ",
          "--tw-numeric-spacing": " ",
          "--tw-numeric-fraction": " "
        });
        addUtilities({
          ".normal-nums": {
            "font-variant-numeric": "normal"
          },
          ".ordinal": {
            "@defaults font-variant-numeric": {},
            "--tw-ordinal": "ordinal",
            "font-variant-numeric": cssFontVariantNumericValue
          },
          ".slashed-zero": {
            "@defaults font-variant-numeric": {},
            "--tw-slashed-zero": "slashed-zero",
            "font-variant-numeric": cssFontVariantNumericValue
          },
          ".lining-nums": {
            "@defaults font-variant-numeric": {},
            "--tw-numeric-figure": "lining-nums",
            "font-variant-numeric": cssFontVariantNumericValue
          },
          ".oldstyle-nums": {
            "@defaults font-variant-numeric": {},
            "--tw-numeric-figure": "oldstyle-nums",
            "font-variant-numeric": cssFontVariantNumericValue
          },
          ".proportional-nums": {
            "@defaults font-variant-numeric": {},
            "--tw-numeric-spacing": "proportional-nums",
            "font-variant-numeric": cssFontVariantNumericValue
          },
          ".tabular-nums": {
            "@defaults font-variant-numeric": {},
            "--tw-numeric-spacing": "tabular-nums",
            "font-variant-numeric": cssFontVariantNumericValue
          },
          ".diagonal-fractions": {
            "@defaults font-variant-numeric": {},
            "--tw-numeric-fraction": "diagonal-fractions",
            "font-variant-numeric": cssFontVariantNumericValue
          },
          ".stacked-fractions": {
            "@defaults font-variant-numeric": {},
            "--tw-numeric-fraction": "stacked-fractions",
            "font-variant-numeric": cssFontVariantNumericValue
          }
        });
      },
      lineHeight: (0, _createUtilityPlugin.default)("lineHeight", [
        [
          "leading",
          [
            "lineHeight"
          ]
        ]
      ]),
      letterSpacing: (0, _createUtilityPlugin.default)("letterSpacing", [
        [
          "tracking",
          [
            "letterSpacing"
          ]
        ]
      ], {
        supportsNegativeValues: true
      }),
      textColor: ({ matchUtilities, theme, corePlugins: corePlugins2 }) => {
        matchUtilities({
          text: (value2) => {
            if (!corePlugins2("textOpacity")) {
              return {
                color: (0, _toColorValue.default)(value2)
              };
            }
            return (0, _withAlphaVariable.default)({
              color: value2,
              property: "color",
              variable: "--tw-text-opacity"
            });
          }
        }, {
          values: (0, _flattenColorPalette.default)(theme("textColor")),
          type: [
            "color",
            "any"
          ]
        });
      },
      textOpacity: (0, _createUtilityPlugin.default)("textOpacity", [
        [
          "text-opacity",
          [
            "--tw-text-opacity"
          ]
        ]
      ]),
      textDecoration: ({ addUtilities }) => {
        addUtilities({
          ".underline": {
            "text-decoration-line": "underline"
          },
          ".overline": {
            "text-decoration-line": "overline"
          },
          ".line-through": {
            "text-decoration-line": "line-through"
          },
          ".no-underline": {
            "text-decoration-line": "none"
          }
        });
      },
      textDecorationColor: ({ matchUtilities, theme }) => {
        matchUtilities({
          decoration: (value2) => {
            return {
              "text-decoration-color": (0, _toColorValue.default)(value2)
            };
          }
        }, {
          values: (0, _flattenColorPalette.default)(theme("textDecorationColor")),
          type: [
            "color",
            "any"
          ]
        });
      },
      textDecorationStyle: ({ addUtilities }) => {
        addUtilities({
          ".decoration-solid": {
            "text-decoration-style": "solid"
          },
          ".decoration-double": {
            "text-decoration-style": "double"
          },
          ".decoration-dotted": {
            "text-decoration-style": "dotted"
          },
          ".decoration-dashed": {
            "text-decoration-style": "dashed"
          },
          ".decoration-wavy": {
            "text-decoration-style": "wavy"
          }
        });
      },
      textDecorationThickness: (0, _createUtilityPlugin.default)("textDecorationThickness", [
        [
          "decoration",
          [
            "text-decoration-thickness"
          ]
        ]
      ], {
        type: [
          "length",
          "percentage"
        ]
      }),
      textUnderlineOffset: (0, _createUtilityPlugin.default)("textUnderlineOffset", [
        [
          "underline-offset",
          [
            "text-underline-offset"
          ]
        ]
      ], {
        type: [
          "length",
          "percentage",
          "any"
        ]
      }),
      fontSmoothing: ({ addUtilities }) => {
        addUtilities({
          ".antialiased": {
            "-webkit-font-smoothing": "antialiased",
            "-moz-osx-font-smoothing": "grayscale"
          },
          ".subpixel-antialiased": {
            "-webkit-font-smoothing": "auto",
            "-moz-osx-font-smoothing": "auto"
          }
        });
      },
      placeholderColor: ({ matchUtilities, theme, corePlugins: corePlugins2 }) => {
        matchUtilities({
          placeholder: (value2) => {
            if (!corePlugins2("placeholderOpacity")) {
              return {
                "&::placeholder": {
                  color: (0, _toColorValue.default)(value2)
                }
              };
            }
            return {
              "&::placeholder": (0, _withAlphaVariable.default)({
                color: value2,
                property: "color",
                variable: "--tw-placeholder-opacity"
              })
            };
          }
        }, {
          values: (0, _flattenColorPalette.default)(theme("placeholderColor")),
          type: [
            "color",
            "any"
          ]
        });
      },
      placeholderOpacity: ({ matchUtilities, theme }) => {
        matchUtilities({
          "placeholder-opacity": (value2) => {
            return {
              ["&::placeholder"]: {
                "--tw-placeholder-opacity": value2
              }
            };
          }
        }, {
          values: theme("placeholderOpacity")
        });
      },
      caretColor: ({ matchUtilities, theme }) => {
        matchUtilities({
          caret: (value2) => {
            return {
              "caret-color": (0, _toColorValue.default)(value2)
            };
          }
        }, {
          values: (0, _flattenColorPalette.default)(theme("caretColor")),
          type: [
            "color",
            "any"
          ]
        });
      },
      accentColor: ({ matchUtilities, theme }) => {
        matchUtilities({
          accent: (value2) => {
            return {
              "accent-color": (0, _toColorValue.default)(value2)
            };
          }
        }, {
          values: (0, _flattenColorPalette.default)(theme("accentColor")),
          type: [
            "color",
            "any"
          ]
        });
      },
      opacity: (0, _createUtilityPlugin.default)("opacity", [
        [
          "opacity",
          [
            "opacity"
          ]
        ]
      ]),
      backgroundBlendMode: ({ addUtilities }) => {
        addUtilities({
          ".bg-blend-normal": {
            "background-blend-mode": "normal"
          },
          ".bg-blend-multiply": {
            "background-blend-mode": "multiply"
          },
          ".bg-blend-screen": {
            "background-blend-mode": "screen"
          },
          ".bg-blend-overlay": {
            "background-blend-mode": "overlay"
          },
          ".bg-blend-darken": {
            "background-blend-mode": "darken"
          },
          ".bg-blend-lighten": {
            "background-blend-mode": "lighten"
          },
          ".bg-blend-color-dodge": {
            "background-blend-mode": "color-dodge"
          },
          ".bg-blend-color-burn": {
            "background-blend-mode": "color-burn"
          },
          ".bg-blend-hard-light": {
            "background-blend-mode": "hard-light"
          },
          ".bg-blend-soft-light": {
            "background-blend-mode": "soft-light"
          },
          ".bg-blend-difference": {
            "background-blend-mode": "difference"
          },
          ".bg-blend-exclusion": {
            "background-blend-mode": "exclusion"
          },
          ".bg-blend-hue": {
            "background-blend-mode": "hue"
          },
          ".bg-blend-saturation": {
            "background-blend-mode": "saturation"
          },
          ".bg-blend-color": {
            "background-blend-mode": "color"
          },
          ".bg-blend-luminosity": {
            "background-blend-mode": "luminosity"
          }
        });
      },
      mixBlendMode: ({ addUtilities }) => {
        addUtilities({
          ".mix-blend-normal": {
            "mix-blend-mode": "normal"
          },
          ".mix-blend-multiply": {
            "mix-blend-mode": "multiply"
          },
          ".mix-blend-screen": {
            "mix-blend-mode": "screen"
          },
          ".mix-blend-overlay": {
            "mix-blend-mode": "overlay"
          },
          ".mix-blend-darken": {
            "mix-blend-mode": "darken"
          },
          ".mix-blend-lighten": {
            "mix-blend-mode": "lighten"
          },
          ".mix-blend-color-dodge": {
            "mix-blend-mode": "color-dodge"
          },
          ".mix-blend-color-burn": {
            "mix-blend-mode": "color-burn"
          },
          ".mix-blend-hard-light": {
            "mix-blend-mode": "hard-light"
          },
          ".mix-blend-soft-light": {
            "mix-blend-mode": "soft-light"
          },
          ".mix-blend-difference": {
            "mix-blend-mode": "difference"
          },
          ".mix-blend-exclusion": {
            "mix-blend-mode": "exclusion"
          },
          ".mix-blend-hue": {
            "mix-blend-mode": "hue"
          },
          ".mix-blend-saturation": {
            "mix-blend-mode": "saturation"
          },
          ".mix-blend-color": {
            "mix-blend-mode": "color"
          },
          ".mix-blend-luminosity": {
            "mix-blend-mode": "luminosity"
          },
          ".mix-blend-plus-darker": {
            "mix-blend-mode": "plus-darker"
          },
          ".mix-blend-plus-lighter": {
            "mix-blend-mode": "plus-lighter"
          }
        });
      },
      boxShadow: (() => {
        let transformValue = (0, _transformThemeValue.default)("boxShadow");
        let defaultBoxShadow = [
          `var(--tw-ring-offset-shadow, 0 0 #0000)`,
          `var(--tw-ring-shadow, 0 0 #0000)`,
          `var(--tw-shadow)`
        ].join(", ");
        return function({ matchUtilities, addDefaults, theme }) {
          addDefaults("box-shadow", {
            "--tw-ring-offset-shadow": "0 0 #0000",
            "--tw-ring-shadow": "0 0 #0000",
            "--tw-shadow": "0 0 #0000",
            "--tw-shadow-colored": "0 0 #0000"
          });
          matchUtilities({
            shadow: (value2) => {
              value2 = transformValue(value2);
              let ast = (0, _parseBoxShadowValue.parseBoxShadowValue)(value2);
              for (let shadow of ast) {
                if (!shadow.valid) {
                  continue;
                }
                shadow.color = "var(--tw-shadow-color)";
              }
              return {
                "@defaults box-shadow": {},
                "--tw-shadow": value2 === "none" ? "0 0 #0000" : value2,
                "--tw-shadow-colored": value2 === "none" ? "0 0 #0000" : (0, _parseBoxShadowValue.formatBoxShadowValue)(ast),
                "box-shadow": defaultBoxShadow
              };
            }
          }, {
            values: theme("boxShadow"),
            type: [
              "shadow"
            ]
          });
        };
      })(),
      boxShadowColor: ({ matchUtilities, theme }) => {
        matchUtilities({
          shadow: (value2) => {
            return {
              "--tw-shadow-color": (0, _toColorValue.default)(value2),
              "--tw-shadow": "var(--tw-shadow-colored)"
            };
          }
        }, {
          values: (0, _flattenColorPalette.default)(theme("boxShadowColor")),
          type: [
            "color",
            "any"
          ]
        });
      },
      outlineStyle: ({ addUtilities }) => {
        addUtilities({
          ".outline-none": {
            outline: "2px solid transparent",
            "outline-offset": "2px"
          },
          ".outline": {
            "outline-style": "solid"
          },
          ".outline-dashed": {
            "outline-style": "dashed"
          },
          ".outline-dotted": {
            "outline-style": "dotted"
          },
          ".outline-double": {
            "outline-style": "double"
          }
        });
      },
      outlineWidth: (0, _createUtilityPlugin.default)("outlineWidth", [
        [
          "outline",
          [
            "outline-width"
          ]
        ]
      ], {
        type: [
          "length",
          "number",
          "percentage"
        ]
      }),
      outlineOffset: (0, _createUtilityPlugin.default)("outlineOffset", [
        [
          "outline-offset",
          [
            "outline-offset"
          ]
        ]
      ], {
        type: [
          "length",
          "number",
          "percentage",
          "any"
        ],
        supportsNegativeValues: true
      }),
      outlineColor: ({ matchUtilities, theme }) => {
        matchUtilities({
          outline: (value2) => {
            return {
              "outline-color": (0, _toColorValue.default)(value2)
            };
          }
        }, {
          values: (0, _flattenColorPalette.default)(theme("outlineColor")),
          type: [
            "color",
            "any"
          ]
        });
      },
      ringWidth: ({ matchUtilities, addDefaults, addUtilities, theme, config }) => {
        let ringColorDefault = (() => {
          var _theme, _theme1;
          if ((0, _featureFlags.flagEnabled)(config(), "respectDefaultRingColorOpacity")) {
            return theme("ringColor.DEFAULT");
          }
          let ringOpacityDefault = theme("ringOpacity.DEFAULT", "0.5");
          if (!((_theme = theme("ringColor")) === null || _theme === void 0 ? void 0 : _theme.DEFAULT)) {
            return `rgb(147 197 253 / ${ringOpacityDefault})`;
          }
          return (0, _withAlphaVariable.withAlphaValue)((_theme1 = theme("ringColor")) === null || _theme1 === void 0 ? void 0 : _theme1.DEFAULT, ringOpacityDefault, `rgb(147 197 253 / ${ringOpacityDefault})`);
        })();
        addDefaults("ring-width", {
          "--tw-ring-inset": " ",
          "--tw-ring-offset-width": theme("ringOffsetWidth.DEFAULT", "0px"),
          "--tw-ring-offset-color": theme("ringOffsetColor.DEFAULT", "#fff"),
          "--tw-ring-color": ringColorDefault,
          "--tw-ring-offset-shadow": "0 0 #0000",
          "--tw-ring-shadow": "0 0 #0000",
          "--tw-shadow": "0 0 #0000",
          "--tw-shadow-colored": "0 0 #0000"
        });
        matchUtilities({
          ring: (value2) => {
            return {
              "@defaults ring-width": {},
              "--tw-ring-offset-shadow": `var(--tw-ring-inset) 0 0 0 var(--tw-ring-offset-width) var(--tw-ring-offset-color)`,
              "--tw-ring-shadow": `var(--tw-ring-inset) 0 0 0 calc(${value2} + var(--tw-ring-offset-width)) var(--tw-ring-color)`,
              "box-shadow": [
                `var(--tw-ring-offset-shadow)`,
                `var(--tw-ring-shadow)`,
                `var(--tw-shadow, 0 0 #0000)`
              ].join(", ")
            };
          }
        }, {
          values: theme("ringWidth"),
          type: "length"
        });
        addUtilities({
          ".ring-inset": {
            "@defaults ring-width": {},
            "--tw-ring-inset": "inset"
          }
        });
      },
      ringColor: ({ matchUtilities, theme, corePlugins: corePlugins2 }) => {
        matchUtilities({
          ring: (value2) => {
            if (!corePlugins2("ringOpacity")) {
              return {
                "--tw-ring-color": (0, _toColorValue.default)(value2)
              };
            }
            return (0, _withAlphaVariable.default)({
              color: value2,
              property: "--tw-ring-color",
              variable: "--tw-ring-opacity"
            });
          }
        }, {
          values: Object.fromEntries(Object.entries((0, _flattenColorPalette.default)(theme("ringColor"))).filter(([modifier]) => modifier !== "DEFAULT")),
          type: [
            "color",
            "any"
          ]
        });
      },
      ringOpacity: (helpers) => {
        let { config } = helpers;
        return (0, _createUtilityPlugin.default)("ringOpacity", [
          [
            "ring-opacity",
            [
              "--tw-ring-opacity"
            ]
          ]
        ], {
          filterDefault: !(0, _featureFlags.flagEnabled)(config(), "respectDefaultRingColorOpacity")
        })(helpers);
      },
      ringOffsetWidth: (0, _createUtilityPlugin.default)("ringOffsetWidth", [
        [
          "ring-offset",
          [
            "--tw-ring-offset-width"
          ]
        ]
      ], {
        type: "length"
      }),
      ringOffsetColor: ({ matchUtilities, theme }) => {
        matchUtilities({
          "ring-offset": (value2) => {
            return {
              "--tw-ring-offset-color": (0, _toColorValue.default)(value2)
            };
          }
        }, {
          values: (0, _flattenColorPalette.default)(theme("ringOffsetColor")),
          type: [
            "color",
            "any"
          ]
        });
      },
      blur: ({ matchUtilities, theme }) => {
        matchUtilities({
          blur: (value2) => {
            return {
              "--tw-blur": `blur(${value2})`,
              "@defaults filter": {},
              filter: cssFilterValue
            };
          }
        }, {
          values: theme("blur")
        });
      },
      brightness: ({ matchUtilities, theme }) => {
        matchUtilities({
          brightness: (value2) => {
            return {
              "--tw-brightness": `brightness(${value2})`,
              "@defaults filter": {},
              filter: cssFilterValue
            };
          }
        }, {
          values: theme("brightness")
        });
      },
      contrast: ({ matchUtilities, theme }) => {
        matchUtilities({
          contrast: (value2) => {
            return {
              "--tw-contrast": `contrast(${value2})`,
              "@defaults filter": {},
              filter: cssFilterValue
            };
          }
        }, {
          values: theme("contrast")
        });
      },
      dropShadow: ({ matchUtilities, theme }) => {
        matchUtilities({
          "drop-shadow": (value2) => {
            return {
              "--tw-drop-shadow": Array.isArray(value2) ? value2.map((v) => `drop-shadow(${v})`).join(" ") : `drop-shadow(${value2})`,
              "@defaults filter": {},
              filter: cssFilterValue
            };
          }
        }, {
          values: theme("dropShadow")
        });
      },
      grayscale: ({ matchUtilities, theme }) => {
        matchUtilities({
          grayscale: (value2) => {
            return {
              "--tw-grayscale": `grayscale(${value2})`,
              "@defaults filter": {},
              filter: cssFilterValue
            };
          }
        }, {
          values: theme("grayscale")
        });
      },
      hueRotate: ({ matchUtilities, theme }) => {
        matchUtilities({
          "hue-rotate": (value2) => {
            return {
              "--tw-hue-rotate": `hue-rotate(${value2})`,
              "@defaults filter": {},
              filter: cssFilterValue
            };
          }
        }, {
          values: theme("hueRotate"),
          supportsNegativeValues: true
        });
      },
      invert: ({ matchUtilities, theme }) => {
        matchUtilities({
          invert: (value2) => {
            return {
              "--tw-invert": `invert(${value2})`,
              "@defaults filter": {},
              filter: cssFilterValue
            };
          }
        }, {
          values: theme("invert")
        });
      },
      saturate: ({ matchUtilities, theme }) => {
        matchUtilities({
          saturate: (value2) => {
            return {
              "--tw-saturate": `saturate(${value2})`,
              "@defaults filter": {},
              filter: cssFilterValue
            };
          }
        }, {
          values: theme("saturate")
        });
      },
      sepia: ({ matchUtilities, theme }) => {
        matchUtilities({
          sepia: (value2) => {
            return {
              "--tw-sepia": `sepia(${value2})`,
              "@defaults filter": {},
              filter: cssFilterValue
            };
          }
        }, {
          values: theme("sepia")
        });
      },
      filter: ({ addDefaults, addUtilities }) => {
        addDefaults("filter", {
          "--tw-blur": " ",
          "--tw-brightness": " ",
          "--tw-contrast": " ",
          "--tw-grayscale": " ",
          "--tw-hue-rotate": " ",
          "--tw-invert": " ",
          "--tw-saturate": " ",
          "--tw-sepia": " ",
          "--tw-drop-shadow": " "
        });
        addUtilities({
          ".filter": {
            "@defaults filter": {},
            filter: cssFilterValue
          },
          ".filter-none": {
            filter: "none"
          }
        });
      },
      backdropBlur: ({ matchUtilities, theme }) => {
        matchUtilities({
          "backdrop-blur": (value2) => {
            return {
              "--tw-backdrop-blur": `blur(${value2})`,
              "@defaults backdrop-filter": {},
              "backdrop-filter": cssBackdropFilterValue
            };
          }
        }, {
          values: theme("backdropBlur")
        });
      },
      backdropBrightness: ({ matchUtilities, theme }) => {
        matchUtilities({
          "backdrop-brightness": (value2) => {
            return {
              "--tw-backdrop-brightness": `brightness(${value2})`,
              "@defaults backdrop-filter": {},
              "backdrop-filter": cssBackdropFilterValue
            };
          }
        }, {
          values: theme("backdropBrightness")
        });
      },
      backdropContrast: ({ matchUtilities, theme }) => {
        matchUtilities({
          "backdrop-contrast": (value2) => {
            return {
              "--tw-backdrop-contrast": `contrast(${value2})`,
              "@defaults backdrop-filter": {},
              "backdrop-filter": cssBackdropFilterValue
            };
          }
        }, {
          values: theme("backdropContrast")
        });
      },
      backdropGrayscale: ({ matchUtilities, theme }) => {
        matchUtilities({
          "backdrop-grayscale": (value2) => {
            return {
              "--tw-backdrop-grayscale": `grayscale(${value2})`,
              "@defaults backdrop-filter": {},
              "backdrop-filter": cssBackdropFilterValue
            };
          }
        }, {
          values: theme("backdropGrayscale")
        });
      },
      backdropHueRotate: ({ matchUtilities, theme }) => {
        matchUtilities({
          "backdrop-hue-rotate": (value2) => {
            return {
              "--tw-backdrop-hue-rotate": `hue-rotate(${value2})`,
              "@defaults backdrop-filter": {},
              "backdrop-filter": cssBackdropFilterValue
            };
          }
        }, {
          values: theme("backdropHueRotate"),
          supportsNegativeValues: true
        });
      },
      backdropInvert: ({ matchUtilities, theme }) => {
        matchUtilities({
          "backdrop-invert": (value2) => {
            return {
              "--tw-backdrop-invert": `invert(${value2})`,
              "@defaults backdrop-filter": {},
              "backdrop-filter": cssBackdropFilterValue
            };
          }
        }, {
          values: theme("backdropInvert")
        });
      },
      backdropOpacity: ({ matchUtilities, theme }) => {
        matchUtilities({
          "backdrop-opacity": (value2) => {
            return {
              "--tw-backdrop-opacity": `opacity(${value2})`,
              "@defaults backdrop-filter": {},
              "backdrop-filter": cssBackdropFilterValue
            };
          }
        }, {
          values: theme("backdropOpacity")
        });
      },
      backdropSaturate: ({ matchUtilities, theme }) => {
        matchUtilities({
          "backdrop-saturate": (value2) => {
            return {
              "--tw-backdrop-saturate": `saturate(${value2})`,
              "@defaults backdrop-filter": {},
              "backdrop-filter": cssBackdropFilterValue
            };
          }
        }, {
          values: theme("backdropSaturate")
        });
      },
      backdropSepia: ({ matchUtilities, theme }) => {
        matchUtilities({
          "backdrop-sepia": (value2) => {
            return {
              "--tw-backdrop-sepia": `sepia(${value2})`,
              "@defaults backdrop-filter": {},
              "backdrop-filter": cssBackdropFilterValue
            };
          }
        }, {
          values: theme("backdropSepia")
        });
      },
      backdropFilter: ({ addDefaults, addUtilities }) => {
        addDefaults("backdrop-filter", {
          "--tw-backdrop-blur": " ",
          "--tw-backdrop-brightness": " ",
          "--tw-backdrop-contrast": " ",
          "--tw-backdrop-grayscale": " ",
          "--tw-backdrop-hue-rotate": " ",
          "--tw-backdrop-invert": " ",
          "--tw-backdrop-opacity": " ",
          "--tw-backdrop-saturate": " ",
          "--tw-backdrop-sepia": " "
        });
        addUtilities({
          ".backdrop-filter": {
            "@defaults backdrop-filter": {},
            "backdrop-filter": cssBackdropFilterValue
          },
          ".backdrop-filter-none": {
            "backdrop-filter": "none"
          }
        });
      },
      transitionProperty: ({ matchUtilities, theme }) => {
        let defaultTimingFunction = theme("transitionTimingFunction.DEFAULT");
        let defaultDuration = theme("transitionDuration.DEFAULT");
        matchUtilities({
          transition: (value2) => {
            return {
              "transition-property": value2,
              ...value2 === "none" ? {} : {
                "transition-timing-function": defaultTimingFunction,
                "transition-duration": defaultDuration
              }
            };
          }
        }, {
          values: theme("transitionProperty")
        });
      },
      transitionDelay: (0, _createUtilityPlugin.default)("transitionDelay", [
        [
          "delay",
          [
            "transitionDelay"
          ]
        ]
      ]),
      transitionDuration: (0, _createUtilityPlugin.default)("transitionDuration", [
        [
          "duration",
          [
            "transitionDuration"
          ]
        ]
      ], {
        filterDefault: true
      }),
      transitionTimingFunction: (0, _createUtilityPlugin.default)("transitionTimingFunction", [
        [
          "ease",
          [
            "transitionTimingFunction"
          ]
        ]
      ], {
        filterDefault: true
      }),
      willChange: (0, _createUtilityPlugin.default)("willChange", [
        [
          "will-change",
          [
            "will-change"
          ]
        ]
      ]),
      contain: ({ addDefaults, addUtilities }) => {
        let cssContainValue = "var(--tw-contain-size) var(--tw-contain-layout) var(--tw-contain-paint) var(--tw-contain-style)";
        addDefaults("contain", {
          "--tw-contain-size": " ",
          "--tw-contain-layout": " ",
          "--tw-contain-paint": " ",
          "--tw-contain-style": " "
        });
        addUtilities({
          ".contain-none": {
            contain: "none"
          },
          ".contain-content": {
            contain: "content"
          },
          ".contain-strict": {
            contain: "strict"
          },
          ".contain-size": {
            "@defaults contain": {},
            "--tw-contain-size": "size",
            contain: cssContainValue
          },
          ".contain-inline-size": {
            "@defaults contain": {},
            "--tw-contain-size": "inline-size",
            contain: cssContainValue
          },
          ".contain-layout": {
            "@defaults contain": {},
            "--tw-contain-layout": "layout",
            contain: cssContainValue
          },
          ".contain-paint": {
            "@defaults contain": {},
            "--tw-contain-paint": "paint",
            contain: cssContainValue
          },
          ".contain-style": {
            "@defaults contain": {},
            "--tw-contain-style": "style",
            contain: cssContainValue
          }
        });
      },
      content: (0, _createUtilityPlugin.default)("content", [
        [
          "content",
          [
            "--tw-content",
            [
              "content",
              "var(--tw-content)"
            ]
          ]
        ]
      ]),
      forcedColorAdjust: ({ addUtilities }) => {
        addUtilities({
          ".forced-color-adjust-auto": {
            "forced-color-adjust": "auto"
          },
          ".forced-color-adjust-none": {
            "forced-color-adjust": "none"
          }
        });
      }
    };
  }
});

// node_modules/tailwindcss/lib/lib/sharedState.js
var require_sharedState = __commonJS({
  "node_modules/tailwindcss/lib/lib/sharedState.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    function _export(target, all) {
      for (var name in all)
        Object.defineProperty(target, name, {
          enumerable: true,
          get: all[name]
        });
    }
    _export(exports, {
      env: function() {
        return env;
      },
      contextMap: function() {
        return contextMap;
      },
      configContextMap: function() {
        return configContextMap;
      },
      contextSourcesMap: function() {
        return contextSourcesMap;
      },
      sourceHashMap: function() {
        return sourceHashMap;
      },
      NOT_ON_DEMAND: function() {
        return NOT_ON_DEMAND;
      },
      NONE: function() {
        return NONE;
      },
      resolveDebug: function() {
        return resolveDebug;
      }
    });
    var env = typeof process !== "undefined" ? {
      NODE_ENV: "development",
      DEBUG: resolveDebug(process.env.DEBUG)
    } : {
      NODE_ENV: "production",
      DEBUG: false
    };
    var contextMap = /* @__PURE__ */ new Map();
    var configContextMap = /* @__PURE__ */ new Map();
    var contextSourcesMap = /* @__PURE__ */ new Map();
    var sourceHashMap = /* @__PURE__ */ new Map();
    var NOT_ON_DEMAND = new String("*");
    var NONE = Symbol("__NONE__");
    function resolveDebug(debug) {
      if (debug === void 0) {
        return false;
      }
      if (debug === "true" || debug === "1") {
        return true;
      }
      if (debug === "false" || debug === "0") {
        return false;
      }
      if (debug === "*") {
        return true;
      }
      let debuggers = debug.split(",").map((d) => d.split(":")[0]);
      if (debuggers.includes("-tailwindcss")) {
        return false;
      }
      if (debuggers.includes("tailwindcss")) {
        return true;
      }
      return false;
    }
  }
});

// node_modules/tailwindcss/lib/util/isSyntacticallyValidPropertyValue.js
var require_isSyntacticallyValidPropertyValue = __commonJS({
  "node_modules/tailwindcss/lib/util/isSyntacticallyValidPropertyValue.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    Object.defineProperty(
      exports,
      // Arbitrary values must contain balanced brackets (), [] and {}. Escaped
      // values don't count, and brackets inside quotes also don't count.
      //
      // E.g.: w-[this-is]w-[weird-and-invalid]
      // E.g.: w-[this-is\\]w-\\[weird-but-valid]
      // E.g.: content-['this-is-also-valid]-weirdly-enough']
      "default",
      {
        enumerable: true,
        get: function() {
          return isSyntacticallyValidPropertyValue;
        }
      }
    );
    var matchingBrackets = /* @__PURE__ */ new Map([
      [
        "{",
        "}"
      ],
      [
        "[",
        "]"
      ],
      [
        "(",
        ")"
      ]
    ]);
    var inverseMatchingBrackets = new Map(Array.from(matchingBrackets.entries()).map(([k, v]) => [
      v,
      k
    ]));
    var quotes = /* @__PURE__ */ new Set([
      '"',
      "'",
      "`"
    ]);
    function isSyntacticallyValidPropertyValue(value2) {
      let stack = [];
      let inQuotes = false;
      for (let i = 0; i < value2.length; i++) {
        let char = value2[i];
        if (char === ":" && !inQuotes && stack.length === 0) {
          return false;
        }
        if (quotes.has(char) && value2[i - 1] !== "\\") {
          inQuotes = !inQuotes;
        }
        if (inQuotes)
          continue;
        if (value2[i - 1] === "\\")
          continue;
        if (matchingBrackets.has(char)) {
          stack.push(char);
        } else if (inverseMatchingBrackets.has(char)) {
          let inverse = inverseMatchingBrackets.get(char);
          if (stack.length <= 0) {
            return false;
          }
          if (stack.pop() !== inverse) {
            return false;
          }
        }
      }
      if (stack.length > 0) {
        return false;
      }
      return true;
    }
  }
});

// node_modules/tailwindcss/lib/util/pseudoElements.js
var require_pseudoElements = __commonJS({
  "node_modules/tailwindcss/lib/util/pseudoElements.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    Object.defineProperty(exports, "movePseudos", {
      enumerable: true,
      get: function() {
        return movePseudos;
      }
    });
    var elementProperties = {
      // Pseudo elements from the spec
      "::after": [
        "terminal",
        "jumpable"
      ],
      "::backdrop": [
        "terminal",
        "jumpable"
      ],
      "::before": [
        "terminal",
        "jumpable"
      ],
      "::cue": [
        "terminal"
      ],
      "::cue-region": [
        "terminal"
      ],
      "::first-letter": [
        "terminal",
        "jumpable"
      ],
      "::first-line": [
        "terminal",
        "jumpable"
      ],
      "::grammar-error": [
        "terminal"
      ],
      "::marker": [
        "terminal",
        "jumpable"
      ],
      "::part": [
        "terminal",
        "actionable"
      ],
      "::placeholder": [
        "terminal",
        "jumpable"
      ],
      "::selection": [
        "terminal",
        "jumpable"
      ],
      "::slotted": [
        "terminal"
      ],
      "::spelling-error": [
        "terminal"
      ],
      "::target-text": [
        "terminal"
      ],
      // Pseudo elements from the spec with special rules
      "::file-selector-button": [
        "terminal",
        "actionable"
      ],
      // Library-specific pseudo elements used by component libraries
      // These are Shadow DOM-like
      "::deep": [
        "actionable"
      ],
      "::v-deep": [
        "actionable"
      ],
      "::ng-deep": [
        "actionable"
      ],
      // Note: As a rule, double colons (::) should be used instead of a single colon
      // (:). This distinguishes pseudo-classes from pseudo-elements. However, since
      // this distinction was not present in older versions of the W3C spec, most
      // browsers support both syntaxes for the original pseudo-elements.
      ":after": [
        "terminal",
        "jumpable"
      ],
      ":before": [
        "terminal",
        "jumpable"
      ],
      ":first-letter": [
        "terminal",
        "jumpable"
      ],
      ":first-line": [
        "terminal",
        "jumpable"
      ],
      ":where": [],
      ":is": [],
      ":has": [],
      // The default value is used when the pseudo-element is not recognized
      // Because it's not recognized, we don't know if it's terminal or not
      // So we assume it can be moved AND can have user-action pseudo classes attached to it
      __default__: [
        "terminal",
        "actionable"
      ]
    };
    function movePseudos(sel) {
      let [pseudos] = movablePseudos(sel);
      pseudos.forEach(([sel2, pseudo]) => sel2.removeChild(pseudo));
      sel.nodes.push(...pseudos.map(([, pseudo]) => pseudo));
      return sel;
    }
    function movablePseudos(sel) {
      let buffer = [];
      let lastSeenElement = null;
      for (let node of sel.nodes) {
        if (node.type === "combinator") {
          buffer = buffer.filter(([, node2]) => propertiesForPseudo(node2).includes("jumpable"));
          lastSeenElement = null;
        } else if (node.type === "pseudo") {
          if (isMovablePseudoElement(node)) {
            lastSeenElement = node;
            buffer.push([
              sel,
              node,
              null
            ]);
          } else if (lastSeenElement && isAttachablePseudoClass(node, lastSeenElement)) {
            buffer.push([
              sel,
              node,
              lastSeenElement
            ]);
          } else {
            lastSeenElement = null;
          }
          var _node_nodes;
          for (let sub of (_node_nodes = node.nodes) !== null && _node_nodes !== void 0 ? _node_nodes : []) {
            let [movable, lastSeenElementInSub] = movablePseudos(sub);
            lastSeenElement = lastSeenElementInSub || lastSeenElement;
            buffer.push(...movable);
          }
        }
      }
      return [
        buffer,
        lastSeenElement
      ];
    }
    function isPseudoElement(node) {
      return node.value.startsWith("::") || elementProperties[node.value] !== void 0;
    }
    function isMovablePseudoElement(node) {
      return isPseudoElement(node) && propertiesForPseudo(node).includes("terminal");
    }
    function isAttachablePseudoClass(node, pseudo) {
      if (node.type !== "pseudo")
        return false;
      if (isPseudoElement(node))
        return false;
      return propertiesForPseudo(pseudo).includes("actionable");
    }
    function propertiesForPseudo(pseudo) {
      var _elementProperties_pseudo_value;
      return (_elementProperties_pseudo_value = elementProperties[pseudo.value]) !== null && _elementProperties_pseudo_value !== void 0 ? _elementProperties_pseudo_value : elementProperties.__default__;
    }
  }
});

// node_modules/tailwindcss/lib/util/formatVariantSelector.js
var require_formatVariantSelector = __commonJS({
  "node_modules/tailwindcss/lib/util/formatVariantSelector.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    function _export(target, all) {
      for (var name in all)
        Object.defineProperty(target, name, {
          enumerable: true,
          get: all[name]
        });
    }
    _export(exports, {
      formatVariantSelector: function() {
        return formatVariantSelector;
      },
      eliminateIrrelevantSelectors: function() {
        return eliminateIrrelevantSelectors;
      },
      finalizeSelector: function() {
        return finalizeSelector;
      },
      handleMergePseudo: function() {
        return handleMergePseudo;
      }
    });
    var _postcssselectorparser = _interop_require_default(require_dist());
    var _unesc = _interop_require_default(require_unesc());
    var _escapeClassName = _interop_require_default(require_escapeClassName());
    var _prefixSelector = _interop_require_default(require_prefixSelector());
    var _pseudoElements = require_pseudoElements();
    var _splitAtTopLevelOnly = require_splitAtTopLevelOnly();
    function _interop_require_default(obj) {
      return obj && obj.__esModule ? obj : {
        default: obj
      };
    }
    var MERGE = ":merge";
    function formatVariantSelector(formats, { context, candidate }) {
      var _context_tailwindConfig_prefix;
      let prefix = (_context_tailwindConfig_prefix = context === null || context === void 0 ? void 0 : context.tailwindConfig.prefix) !== null && _context_tailwindConfig_prefix !== void 0 ? _context_tailwindConfig_prefix : "";
      let parsedFormats = formats.map((format) => {
        let ast = (0, _postcssselectorparser.default)().astSync(format.format);
        return {
          ...format,
          ast: format.respectPrefix ? (0, _prefixSelector.default)(prefix, ast) : ast
        };
      });
      let formatAst = _postcssselectorparser.default.root({
        nodes: [
          _postcssselectorparser.default.selector({
            nodes: [
              _postcssselectorparser.default.className({
                value: (0, _escapeClassName.default)(candidate)
              })
            ]
          })
        ]
      });
      for (let { ast } of parsedFormats) {
        [formatAst, ast] = handleMergePseudo(formatAst, ast);
        ast.walkNesting((nesting) => nesting.replaceWith(...formatAst.nodes[0].nodes));
        formatAst = ast;
      }
      return formatAst;
    }
    function simpleSelectorForNode(node) {
      let nodes = [];
      while (node.prev() && node.prev().type !== "combinator") {
        node = node.prev();
      }
      while (node && node.type !== "combinator") {
        nodes.push(node);
        node = node.next();
      }
      return nodes;
    }
    function resortSelector(sel) {
      sel.sort((a, b) => {
        if (a.type === "tag" && b.type === "class") {
          return -1;
        } else if (a.type === "class" && b.type === "tag") {
          return 1;
        } else if (a.type === "class" && b.type === "pseudo" && b.value.startsWith("::")) {
          return -1;
        } else if (a.type === "pseudo" && a.value.startsWith("::") && b.type === "class") {
          return 1;
        }
        return sel.index(a) - sel.index(b);
      });
      return sel;
    }
    function eliminateIrrelevantSelectors(sel, base) {
      let hasClassesMatchingCandidate = false;
      sel.walk((child) => {
        if (child.type === "class" && child.value === base) {
          hasClassesMatchingCandidate = true;
          return false;
        }
      });
      if (!hasClassesMatchingCandidate) {
        sel.remove();
      }
    }
    function finalizeSelector(current, formats, { context, candidate, base }) {
      var _context_tailwindConfig;
      var _context_tailwindConfig_separator;
      let separator = (_context_tailwindConfig_separator = context === null || context === void 0 ? void 0 : (_context_tailwindConfig = context.tailwindConfig) === null || _context_tailwindConfig === void 0 ? void 0 : _context_tailwindConfig.separator) !== null && _context_tailwindConfig_separator !== void 0 ? _context_tailwindConfig_separator : ":";
      base = base !== null && base !== void 0 ? base : (0, _splitAtTopLevelOnly.splitAtTopLevelOnly)(candidate, separator).pop();
      let selector = (0, _postcssselectorparser.default)().astSync(current);
      selector.walkClasses((node) => {
        if (node.raws && node.value.includes(base)) {
          node.raws.value = (0, _escapeClassName.default)((0, _unesc.default)(node.raws.value));
        }
      });
      selector.each((sel) => eliminateIrrelevantSelectors(sel, base));
      if (selector.length === 0) {
        return null;
      }
      let formatAst = Array.isArray(formats) ? formatVariantSelector(formats, {
        context,
        candidate
      }) : formats;
      if (formatAst === null) {
        return selector.toString();
      }
      let simpleStart = _postcssselectorparser.default.comment({
        value: "/*__simple__*/"
      });
      let simpleEnd = _postcssselectorparser.default.comment({
        value: "/*__simple__*/"
      });
      selector.walkClasses((node) => {
        if (node.value !== base) {
          return;
        }
        let parent = node.parent;
        let formatNodes = formatAst.nodes[0].nodes;
        if (parent.nodes.length === 1) {
          node.replaceWith(...formatNodes);
          return;
        }
        let simpleSelector = simpleSelectorForNode(node);
        parent.insertBefore(simpleSelector[0], simpleStart);
        parent.insertAfter(simpleSelector[simpleSelector.length - 1], simpleEnd);
        for (let child of formatNodes) {
          parent.insertBefore(simpleSelector[0], child.clone());
        }
        node.remove();
        simpleSelector = simpleSelectorForNode(simpleStart);
        let firstNode = parent.index(simpleStart);
        parent.nodes.splice(firstNode, simpleSelector.length, ...resortSelector(_postcssselectorparser.default.selector({
          nodes: simpleSelector
        })).nodes);
        simpleStart.remove();
        simpleEnd.remove();
      });
      selector.walkPseudos((p) => {
        if (p.value === MERGE) {
          p.replaceWith(p.nodes);
        }
      });
      selector.each((sel) => (0, _pseudoElements.movePseudos)(sel));
      return selector.toString();
    }
    function handleMergePseudo(selector, format) {
      let merges = [];
      selector.walkPseudos((pseudo) => {
        if (pseudo.value === MERGE) {
          merges.push({
            pseudo,
            value: pseudo.nodes[0].toString()
          });
        }
      });
      format.walkPseudos((pseudo) => {
        if (pseudo.value !== MERGE) {
          return;
        }
        let value2 = pseudo.nodes[0].toString();
        let existing = merges.find((merge) => merge.value === value2);
        if (!existing) {
          return;
        }
        let attachments = [];
        let next2 = pseudo.next();
        while (next2 && next2.type !== "combinator") {
          attachments.push(next2);
          next2 = next2.next();
        }
        let combinator = next2;
        existing.pseudo.parent.insertAfter(existing.pseudo, _postcssselectorparser.default.selector({
          nodes: attachments.map((node) => node.clone())
        }));
        pseudo.remove();
        attachments.forEach((node) => node.remove());
        if (combinator && combinator.type === "combinator") {
          combinator.remove();
        }
      });
      return [
        selector,
        format
      ];
    }
  }
});

// node_modules/tailwindcss/lib/util/applyImportantSelector.js
var require_applyImportantSelector = __commonJS({
  "node_modules/tailwindcss/lib/util/applyImportantSelector.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    Object.defineProperty(exports, "applyImportantSelector", {
      enumerable: true,
      get: function() {
        return applyImportantSelector;
      }
    });
    var _postcssselectorparser = _interop_require_default(require_dist());
    var _pseudoElements = require_pseudoElements();
    function _interop_require_default(obj) {
      return obj && obj.__esModule ? obj : {
        default: obj
      };
    }
    function applyImportantSelector(selector, important) {
      let sel = (0, _postcssselectorparser.default)().astSync(selector);
      sel.each((sel2) => {
        let isWrapped = sel2.nodes[0].type === "pseudo" && sel2.nodes[0].value === ":is" && sel2.nodes.every((node) => node.type !== "combinator");
        if (!isWrapped) {
          sel2.nodes = [
            _postcssselectorparser.default.pseudo({
              value: ":is",
              nodes: [
                sel2.clone()
              ]
            })
          ];
        }
        (0, _pseudoElements.movePseudos)(sel2);
      });
      return `${important} ${sel.toString()}`;
    }
  }
});

// node_modules/tailwindcss/lib/lib/generateRules.js
var require_generateRules = __commonJS({
  "node_modules/tailwindcss/lib/lib/generateRules.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    function _export(target, all) {
      for (var name in all)
        Object.defineProperty(target, name, {
          enumerable: true,
          get: all[name]
        });
    }
    _export(exports, {
      getClassNameFromSelector: function() {
        return getClassNameFromSelector;
      },
      resolveMatches: function() {
        return resolveMatches;
      },
      generateRules: function() {
        return generateRules;
      }
    });
    var _postcss = _interop_require_default(require_postcss());
    var _postcssselectorparser = _interop_require_default(require_dist());
    var _parseObjectStyles = _interop_require_default(require_parseObjectStyles());
    var _isPlainObject = _interop_require_default(require_isPlainObject());
    var _prefixSelector = _interop_require_default(require_prefixSelector());
    var _pluginUtils = require_pluginUtils();
    var _log = _interop_require_default(require_log());
    var _sharedState = _interop_require_wildcard(require_sharedState());
    var _formatVariantSelector = require_formatVariantSelector();
    var _nameClass = require_nameClass();
    var _dataTypes = require_dataTypes();
    var _setupContextUtils = require_setupContextUtils();
    var _isSyntacticallyValidPropertyValue = _interop_require_default(require_isSyntacticallyValidPropertyValue());
    var _splitAtTopLevelOnly = require_splitAtTopLevelOnly();
    var _featureFlags = require_featureFlags();
    var _applyImportantSelector = require_applyImportantSelector();
    function _interop_require_default(obj) {
      return obj && obj.__esModule ? obj : {
        default: obj
      };
    }
    function _getRequireWildcardCache(nodeInterop) {
      if (typeof WeakMap !== "function")
        return null;
      var cacheBabelInterop = /* @__PURE__ */ new WeakMap();
      var cacheNodeInterop = /* @__PURE__ */ new WeakMap();
      return (_getRequireWildcardCache = function(nodeInterop2) {
        return nodeInterop2 ? cacheNodeInterop : cacheBabelInterop;
      })(nodeInterop);
    }
    function _interop_require_wildcard(obj, nodeInterop) {
      if (!nodeInterop && obj && obj.__esModule) {
        return obj;
      }
      if (obj === null || typeof obj !== "object" && typeof obj !== "function") {
        return {
          default: obj
        };
      }
      var cache = _getRequireWildcardCache(nodeInterop);
      if (cache && cache.has(obj)) {
        return cache.get(obj);
      }
      var newObj = {};
      var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;
      for (var key in obj) {
        if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) {
          var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;
          if (desc && (desc.get || desc.set)) {
            Object.defineProperty(newObj, key, desc);
          } else {
            newObj[key] = obj[key];
          }
        }
      }
      newObj.default = obj;
      if (cache) {
        cache.set(obj, newObj);
      }
      return newObj;
    }
    var classNameParser = (0, _postcssselectorparser.default)((selectors) => {
      return selectors.first.filter(({ type }) => type === "class").pop().value;
    });
    function getClassNameFromSelector(selector) {
      return classNameParser.transformSync(selector);
    }
    function* candidatePermutations(candidate) {
      let lastIndex = Infinity;
      while (lastIndex >= 0) {
        let dashIdx;
        let wasSlash = false;
        if (lastIndex === Infinity && candidate.endsWith("]")) {
          let bracketIdx = candidate.indexOf("[");
          if (candidate[bracketIdx - 1] === "-") {
            dashIdx = bracketIdx - 1;
          } else if (candidate[bracketIdx - 1] === "/") {
            dashIdx = bracketIdx - 1;
            wasSlash = true;
          } else {
            dashIdx = -1;
          }
        } else if (lastIndex === Infinity && candidate.includes("/")) {
          dashIdx = candidate.lastIndexOf("/");
          wasSlash = true;
        } else {
          dashIdx = candidate.lastIndexOf("-", lastIndex);
        }
        if (dashIdx < 0) {
          break;
        }
        let prefix = candidate.slice(0, dashIdx);
        let modifier = candidate.slice(wasSlash ? dashIdx : dashIdx + 1);
        lastIndex = dashIdx - 1;
        if (prefix === "" || modifier === "/") {
          continue;
        }
        yield [
          prefix,
          modifier
        ];
      }
    }
    function applyPrefix(matches, context) {
      if (matches.length === 0 || context.tailwindConfig.prefix === "") {
        return matches;
      }
      for (let match2 of matches) {
        let [meta] = match2;
        if (meta.options.respectPrefix) {
          let container = _postcss.default.root({
            nodes: [
              match2[1].clone()
            ]
          });
          let classCandidate = match2[1].raws.tailwind.classCandidate;
          container.walkRules((r) => {
            let shouldPrependNegative = classCandidate.startsWith("-");
            r.selector = (0, _prefixSelector.default)(context.tailwindConfig.prefix, r.selector, shouldPrependNegative);
          });
          match2[1] = container.nodes[0];
        }
      }
      return matches;
    }
    function applyImportant(matches, classCandidate) {
      if (matches.length === 0) {
        return matches;
      }
      let result = [];
      function isInKeyframes(rule) {
        return rule.parent && rule.parent.type === "atrule" && rule.parent.name === "keyframes";
      }
      for (let [meta, rule] of matches) {
        let container = _postcss.default.root({
          nodes: [
            rule.clone()
          ]
        });
        container.walkRules((r) => {
          if (isInKeyframes(r)) {
            return;
          }
          let ast = (0, _postcssselectorparser.default)().astSync(r.selector);
          ast.each((sel) => (0, _formatVariantSelector.eliminateIrrelevantSelectors)(sel, classCandidate));
          (0, _pluginUtils.updateAllClasses)(ast, (className) => className === classCandidate ? `!${className}` : className);
          r.selector = ast.toString();
          r.walkDecls((d) => d.important = true);
        });
        result.push([
          {
            ...meta,
            important: true
          },
          container.nodes[0]
        ]);
      }
      return result;
    }
    function applyVariant(variant, matches, context) {
      if (matches.length === 0) {
        return matches;
      }
      let args = {
        modifier: null,
        value: _sharedState.NONE
      };
      {
        let [baseVariant, ...modifiers] = (0, _splitAtTopLevelOnly.splitAtTopLevelOnly)(variant, "/");
        if (modifiers.length > 1) {
          baseVariant = baseVariant + "/" + modifiers.slice(0, -1).join("/");
          modifiers = modifiers.slice(-1);
        }
        if (modifiers.length && !context.variantMap.has(variant)) {
          variant = baseVariant;
          args.modifier = modifiers[0];
          if (!(0, _featureFlags.flagEnabled)(context.tailwindConfig, "generalizedModifiers")) {
            return [];
          }
        }
      }
      if (variant.endsWith("]") && !variant.startsWith("[")) {
        let match2 = /(.)(-?)\[(.*)\]/g.exec(variant);
        if (match2) {
          let [, char, separator, value2] = match2;
          if (char === "@" && separator === "-")
            return [];
          if (char !== "@" && separator === "")
            return [];
          variant = variant.replace(`${separator}[${value2}]`, "");
          args.value = value2;
        }
      }
      if (isArbitraryValue(variant) && !context.variantMap.has(variant)) {
        let sort = context.offsets.recordVariant(variant);
        let selector = (0, _dataTypes.normalize)(variant.slice(1, -1));
        let selectors = (0, _splitAtTopLevelOnly.splitAtTopLevelOnly)(selector, ",");
        if (selectors.length > 1) {
          return [];
        }
        if (!selectors.every(_setupContextUtils.isValidVariantFormatString)) {
          return [];
        }
        let records = selectors.map((sel, idx) => [
          context.offsets.applyParallelOffset(sort, idx),
          (0, _setupContextUtils.parseVariant)(sel.trim())
        ]);
        context.variantMap.set(variant, records);
      }
      if (context.variantMap.has(variant)) {
        var _context_variantOptions_get;
        let isArbitraryVariant = isArbitraryValue(variant);
        var _context_variantOptions_get_INTERNAL_FEATURES;
        let internalFeatures = (_context_variantOptions_get_INTERNAL_FEATURES = (_context_variantOptions_get = context.variantOptions.get(variant)) === null || _context_variantOptions_get === void 0 ? void 0 : _context_variantOptions_get[_setupContextUtils.INTERNAL_FEATURES]) !== null && _context_variantOptions_get_INTERNAL_FEATURES !== void 0 ? _context_variantOptions_get_INTERNAL_FEATURES : {};
        let variantFunctionTuples = context.variantMap.get(variant).slice();
        let result = [];
        let respectPrefix = (() => {
          if (isArbitraryVariant)
            return false;
          if (internalFeatures.respectPrefix === false)
            return false;
          return true;
        })();
        for (let [meta, rule] of matches) {
          if (meta.layer === "user") {
            continue;
          }
          let container = _postcss.default.root({
            nodes: [
              rule.clone()
            ]
          });
          for (let [variantSort, variantFunction, containerFromArray] of variantFunctionTuples) {
            let prepareBackup = function() {
              if (clone.raws.neededBackup) {
                return;
              }
              clone.raws.neededBackup = true;
              clone.walkRules((rule2) => rule2.raws.originalSelector = rule2.selector);
            }, modifySelectors = function(modifierFunction) {
              prepareBackup();
              clone.each((rule2) => {
                if (rule2.type !== "rule") {
                  return;
                }
                rule2.selectors = rule2.selectors.map((selector) => {
                  return modifierFunction({
                    get className() {
                      return getClassNameFromSelector(selector);
                    },
                    selector
                  });
                });
              });
              return clone;
            };
            let clone = (containerFromArray !== null && containerFromArray !== void 0 ? containerFromArray : container).clone();
            let collectedFormats = [];
            let ruleWithVariant = variantFunction({
              // Public API
              get container() {
                prepareBackup();
                return clone;
              },
              separator: context.tailwindConfig.separator,
              modifySelectors,
              // Private API for now
              wrap(wrapper) {
                let nodes = clone.nodes;
                clone.removeAll();
                wrapper.append(nodes);
                clone.append(wrapper);
              },
              format(selectorFormat) {
                collectedFormats.push({
                  format: selectorFormat,
                  respectPrefix
                });
              },
              args
            });
            if (Array.isArray(ruleWithVariant)) {
              for (let [idx, variantFunction2] of ruleWithVariant.entries()) {
                variantFunctionTuples.push([
                  context.offsets.applyParallelOffset(variantSort, idx),
                  variantFunction2,
                  // If the clone has been modified we have to pass that back
                  // though so each rule can use the modified container
                  clone.clone()
                ]);
              }
              continue;
            }
            if (typeof ruleWithVariant === "string") {
              collectedFormats.push({
                format: ruleWithVariant,
                respectPrefix
              });
            }
            if (ruleWithVariant === null) {
              continue;
            }
            if (clone.raws.neededBackup) {
              delete clone.raws.neededBackup;
              clone.walkRules((rule2) => {
                let before = rule2.raws.originalSelector;
                if (!before)
                  return;
                delete rule2.raws.originalSelector;
                if (before === rule2.selector)
                  return;
                let modified = rule2.selector;
                let rebuiltBase = (0, _postcssselectorparser.default)((selectors) => {
                  selectors.walkClasses((classNode) => {
                    classNode.value = `${variant}${context.tailwindConfig.separator}${classNode.value}`;
                  });
                }).processSync(before);
                collectedFormats.push({
                  format: modified.replace(rebuiltBase, "&"),
                  respectPrefix
                });
                rule2.selector = before;
              });
            }
            clone.nodes[0].raws.tailwind = {
              ...clone.nodes[0].raws.tailwind,
              parentLayer: meta.layer
            };
            var _meta_collectedFormats;
            let withOffset = [
              {
                ...meta,
                sort: context.offsets.applyVariantOffset(meta.sort, variantSort, Object.assign(args, context.variantOptions.get(variant))),
                collectedFormats: ((_meta_collectedFormats = meta.collectedFormats) !== null && _meta_collectedFormats !== void 0 ? _meta_collectedFormats : []).concat(collectedFormats)
              },
              clone.nodes[0]
            ];
            result.push(withOffset);
          }
        }
        return result;
      }
      return [];
    }
    function parseRules(rule, cache, options = {}) {
      if (!(0, _isPlainObject.default)(rule) && !Array.isArray(rule)) {
        return [
          [
            rule
          ],
          options
        ];
      }
      if (Array.isArray(rule)) {
        return parseRules(rule[0], cache, rule[1]);
      }
      if (!cache.has(rule)) {
        cache.set(rule, (0, _parseObjectStyles.default)(rule));
      }
      return [
        cache.get(rule),
        options
      ];
    }
    var IS_VALID_PROPERTY_NAME = /^[a-z_-]/;
    function isValidPropName(name) {
      return IS_VALID_PROPERTY_NAME.test(name);
    }
    function looksLikeUri(declaration) {
      if (!declaration.includes("://")) {
        return false;
      }
      try {
        const url = new URL(declaration);
        return url.scheme !== "" && url.host !== "";
      } catch (err) {
        return false;
      }
    }
    function isParsableNode(node) {
      let isParsable = true;
      node.walkDecls((decl) => {
        if (!isParsableCssValue(decl.prop, decl.value)) {
          isParsable = false;
          return false;
        }
      });
      return isParsable;
    }
    function isParsableCssValue(property, value2) {
      if (looksLikeUri(`${property}:${value2}`)) {
        return false;
      }
      try {
        _postcss.default.parse(`a{${property}:${value2}}`).toResult();
        return true;
      } catch (err) {
        return false;
      }
    }
    function extractArbitraryProperty(classCandidate, context) {
      var _classCandidate_match;
      let [, property, value2] = (_classCandidate_match = classCandidate.match(/^\[([a-zA-Z0-9-_]+):(\S+)\]$/)) !== null && _classCandidate_match !== void 0 ? _classCandidate_match : [];
      if (value2 === void 0) {
        return null;
      }
      if (!isValidPropName(property)) {
        return null;
      }
      if (!(0, _isSyntacticallyValidPropertyValue.default)(value2)) {
        return null;
      }
      let normalized = (0, _dataTypes.normalize)(value2, {
        property
      });
      if (!isParsableCssValue(property, normalized)) {
        return null;
      }
      let sort = context.offsets.arbitraryProperty(classCandidate);
      return [
        [
          {
            sort,
            layer: "utilities",
            options: {
              respectImportant: true
            }
          },
          () => ({
            [(0, _nameClass.asClass)(classCandidate)]: {
              [property]: normalized
            }
          })
        ]
      ];
    }
    function* resolveMatchedPlugins(classCandidate, context) {
      if (context.candidateRuleMap.has(classCandidate)) {
        yield [
          context.candidateRuleMap.get(classCandidate),
          "DEFAULT"
        ];
      }
      yield* function* (arbitraryPropertyRule) {
        if (arbitraryPropertyRule !== null) {
          yield [
            arbitraryPropertyRule,
            "DEFAULT"
          ];
        }
      }(extractArbitraryProperty(classCandidate, context));
      let candidatePrefix = classCandidate;
      let negative = false;
      const twConfigPrefix = context.tailwindConfig.prefix;
      const twConfigPrefixLen = twConfigPrefix.length;
      const hasMatchingPrefix = candidatePrefix.startsWith(twConfigPrefix) || candidatePrefix.startsWith(`-${twConfigPrefix}`);
      if (candidatePrefix[twConfigPrefixLen] === "-" && hasMatchingPrefix) {
        negative = true;
        candidatePrefix = twConfigPrefix + candidatePrefix.slice(twConfigPrefixLen + 1);
      }
      if (negative && context.candidateRuleMap.has(candidatePrefix)) {
        yield [
          context.candidateRuleMap.get(candidatePrefix),
          "-DEFAULT"
        ];
      }
      for (let [prefix, modifier] of candidatePermutations(candidatePrefix)) {
        if (context.candidateRuleMap.has(prefix)) {
          yield [
            context.candidateRuleMap.get(prefix),
            negative ? `-${modifier}` : modifier
          ];
        }
      }
    }
    function splitWithSeparator(input2, separator) {
      if (input2 === _sharedState.NOT_ON_DEMAND) {
        return [
          _sharedState.NOT_ON_DEMAND
        ];
      }
      return (0, _splitAtTopLevelOnly.splitAtTopLevelOnly)(input2, separator);
    }
    function* recordCandidates(matches, classCandidate) {
      for (const match2 of matches) {
        var _match__options;
        var _match__options_preserveSource;
        match2[1].raws.tailwind = {
          ...match2[1].raws.tailwind,
          classCandidate,
          preserveSource: (_match__options_preserveSource = (_match__options = match2[0].options) === null || _match__options === void 0 ? void 0 : _match__options.preserveSource) !== null && _match__options_preserveSource !== void 0 ? _match__options_preserveSource : false
        };
        yield match2;
      }
    }
    function* resolveMatches(candidate, context) {
      let separator = context.tailwindConfig.separator;
      let [classCandidate, ...variants] = splitWithSeparator(candidate, separator).reverse();
      let important = false;
      if (classCandidate.startsWith("!")) {
        important = true;
        classCandidate = classCandidate.slice(1);
      }
      for (let matchedPlugins of resolveMatchedPlugins(classCandidate, context)) {
        let matches = [];
        let typesByMatches = /* @__PURE__ */ new Map();
        let [plugins, modifier] = matchedPlugins;
        let isOnlyPlugin = plugins.length === 1;
        for (let [sort, plugin] of plugins) {
          let matchesPerPlugin = [];
          if (typeof plugin === "function") {
            for (let ruleSet of [].concat(plugin(modifier, {
              isOnlyPlugin
            }))) {
              let [rules, options] = parseRules(ruleSet, context.postCssNodeCache);
              for (let rule of rules) {
                matchesPerPlugin.push([
                  {
                    ...sort,
                    options: {
                      ...sort.options,
                      ...options
                    }
                  },
                  rule
                ]);
              }
            }
          } else if (modifier === "DEFAULT" || modifier === "-DEFAULT") {
            let ruleSet = plugin;
            let [rules, options] = parseRules(ruleSet, context.postCssNodeCache);
            for (let rule of rules) {
              matchesPerPlugin.push([
                {
                  ...sort,
                  options: {
                    ...sort.options,
                    ...options
                  }
                },
                rule
              ]);
            }
          }
          if (matchesPerPlugin.length > 0) {
            var _sort_options;
            var _sort_options_types, _sort_options1;
            let matchingTypes = Array.from((0, _pluginUtils.getMatchingTypes)((_sort_options_types = (_sort_options = sort.options) === null || _sort_options === void 0 ? void 0 : _sort_options.types) !== null && _sort_options_types !== void 0 ? _sort_options_types : [], modifier, (_sort_options1 = sort.options) !== null && _sort_options1 !== void 0 ? _sort_options1 : {}, context.tailwindConfig)).map(([_, type]) => type);
            if (matchingTypes.length > 0) {
              typesByMatches.set(matchesPerPlugin, matchingTypes);
            }
            matches.push(matchesPerPlugin);
          }
        }
        if (isArbitraryValue(modifier)) {
          if (matches.length > 1) {
            let findFallback = function(matches2) {
              if (matches2.length === 1) {
                return matches2[0];
              }
              return matches2.find((rules) => {
                let matchingTypes = typesByMatches.get(rules);
                return rules.some(([{ options }, rule]) => {
                  if (!isParsableNode(rule)) {
                    return false;
                  }
                  return options.types.some(({ type, preferOnConflict }) => matchingTypes.includes(type) && preferOnConflict);
                });
              });
            };
            let [withAny, withoutAny] = matches.reduce((group, plugin) => {
              let hasAnyType = plugin.some(([{ options }]) => options.types.some(({ type }) => type === "any"));
              if (hasAnyType) {
                group[0].push(plugin);
              } else {
                group[1].push(plugin);
              }
              return group;
            }, [
              [],
              []
            ]);
            var _findFallback;
            let fallback = (_findFallback = findFallback(withoutAny)) !== null && _findFallback !== void 0 ? _findFallback : findFallback(withAny);
            if (fallback) {
              matches = [
                fallback
              ];
            } else {
              var _typesByMatches_get;
              let typesPerPlugin = matches.map((match2) => /* @__PURE__ */ new Set([
                ...(_typesByMatches_get = typesByMatches.get(match2)) !== null && _typesByMatches_get !== void 0 ? _typesByMatches_get : []
              ]));
              for (let pluginTypes of typesPerPlugin) {
                for (let type of pluginTypes) {
                  let removeFromOwnGroup = false;
                  for (let otherGroup of typesPerPlugin) {
                    if (pluginTypes === otherGroup)
                      continue;
                    if (otherGroup.has(type)) {
                      otherGroup.delete(type);
                      removeFromOwnGroup = true;
                    }
                  }
                  if (removeFromOwnGroup)
                    pluginTypes.delete(type);
                }
              }
              let messages = [];
              for (let [idx, group] of typesPerPlugin.entries()) {
                for (let type of group) {
                  let rules = matches[idx].map(([, rule]) => rule).flat().map((rule) => rule.toString().split("\n").slice(1, -1).map((line) => line.trim()).map((x) => `      ${x}`).join("\n")).join("\n\n");
                  messages.push(`  Use \`${candidate.replace("[", `[${type}:`)}\` for \`${rules.trim()}\``);
                  break;
                }
              }
              _log.default.warn([
                `The class \`${candidate}\` is ambiguous and matches multiple utilities.`,
                ...messages,
                `If this is content and not a class, replace it with \`${candidate.replace("[", "&lsqb;").replace("]", "&rsqb;")}\` to silence this warning.`
              ]);
              continue;
            }
          }
          matches = matches.map((list) => list.filter((match2) => isParsableNode(match2[1])));
        }
        matches = matches.flat();
        matches = Array.from(recordCandidates(matches, classCandidate));
        matches = applyPrefix(matches, context);
        if (important) {
          matches = applyImportant(matches, classCandidate);
        }
        for (let variant of variants) {
          matches = applyVariant(variant, matches, context);
        }
        for (let match2 of matches) {
          match2[1].raws.tailwind = {
            ...match2[1].raws.tailwind,
            candidate
          };
          match2 = applyFinalFormat(match2, {
            context,
            candidate
          });
          if (match2 === null) {
            continue;
          }
          yield match2;
        }
      }
    }
    function applyFinalFormat(match2, { context, candidate }) {
      if (!match2[0].collectedFormats) {
        return match2;
      }
      let isValid = true;
      let finalFormat;
      try {
        finalFormat = (0, _formatVariantSelector.formatVariantSelector)(match2[0].collectedFormats, {
          context,
          candidate
        });
      } catch {
        return null;
      }
      let container = _postcss.default.root({
        nodes: [
          match2[1].clone()
        ]
      });
      container.walkRules((rule) => {
        if (inKeyframes(rule)) {
          return;
        }
        try {
          let selector = (0, _formatVariantSelector.finalizeSelector)(rule.selector, finalFormat, {
            candidate,
            context
          });
          if (selector === null) {
            rule.remove();
            return;
          }
          rule.selector = selector;
        } catch {
          isValid = false;
          return false;
        }
      });
      if (!isValid) {
        return null;
      }
      if (container.nodes.length === 0) {
        return null;
      }
      match2[1] = container.nodes[0];
      return match2;
    }
    function inKeyframes(rule) {
      return rule.parent && rule.parent.type === "atrule" && rule.parent.name === "keyframes";
    }
    function getImportantStrategy(important) {
      if (important === true) {
        return (rule) => {
          if (inKeyframes(rule)) {
            return;
          }
          rule.walkDecls((d) => {
            if (d.parent.type === "rule" && !inKeyframes(d.parent)) {
              d.important = true;
            }
          });
        };
      }
      if (typeof important === "string") {
        return (rule) => {
          if (inKeyframes(rule)) {
            return;
          }
          rule.selectors = rule.selectors.map((selector) => {
            return (0, _applyImportantSelector.applyImportantSelector)(selector, important);
          });
        };
      }
    }
    function generateRules(candidates, context, isSorting = false) {
      let allRules = [];
      let strategy = getImportantStrategy(context.tailwindConfig.important);
      for (let candidate of candidates) {
        if (context.notClassCache.has(candidate)) {
          continue;
        }
        if (context.candidateRuleCache.has(candidate)) {
          allRules = allRules.concat(Array.from(context.candidateRuleCache.get(candidate)));
          continue;
        }
        let matches = Array.from(resolveMatches(candidate, context));
        if (matches.length === 0) {
          context.notClassCache.add(candidate);
          continue;
        }
        context.classCache.set(candidate, matches);
        var _context_candidateRuleCache_get;
        let rules = (_context_candidateRuleCache_get = context.candidateRuleCache.get(candidate)) !== null && _context_candidateRuleCache_get !== void 0 ? _context_candidateRuleCache_get : /* @__PURE__ */ new Set();
        context.candidateRuleCache.set(candidate, rules);
        for (const match2 of matches) {
          let [{ sort, options }, rule] = match2;
          if (options.respectImportant && strategy) {
            let container = _postcss.default.root({
              nodes: [
                rule.clone()
              ]
            });
            container.walkRules(strategy);
            rule = container.nodes[0];
          }
          let newEntry = [
            sort,
            isSorting ? rule.clone() : rule
          ];
          rules.add(newEntry);
          context.ruleCache.add(newEntry);
          allRules.push(newEntry);
        }
      }
      return allRules;
    }
    function isArbitraryValue(input2) {
      return input2.startsWith("[") && input2.endsWith("]");
    }
  }
});

// browser-external:crypto
var require_crypto = __commonJS({
  "browser-external:crypto"(exports, module) {
    module.exports = Object.create(new Proxy({}, {
      get(_, key) {
        if (key !== "__esModule" && key !== "__proto__" && key !== "constructor" && key !== "splice") {
          console.warn(`Module "crypto" has been externalized for browser compatibility. Cannot access "crypto.${key}" in client code. See http://vitejs.dev/guide/troubleshooting.html#module-externalized-for-browser-compatibility for more details.`);
        }
      }
    }));
  }
});

// node_modules/tailwindcss/lib/lib/cacheInvalidation.js
var require_cacheInvalidation = __commonJS({
  "node_modules/tailwindcss/lib/lib/cacheInvalidation.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    Object.defineProperty(exports, "hasContentChanged", {
      enumerable: true,
      get: function() {
        return hasContentChanged;
      }
    });
    var _crypto = _interop_require_default(require_crypto());
    var _sharedState = _interop_require_wildcard(require_sharedState());
    function _interop_require_default(obj) {
      return obj && obj.__esModule ? obj : {
        default: obj
      };
    }
    function _getRequireWildcardCache(nodeInterop) {
      if (typeof WeakMap !== "function")
        return null;
      var cacheBabelInterop = /* @__PURE__ */ new WeakMap();
      var cacheNodeInterop = /* @__PURE__ */ new WeakMap();
      return (_getRequireWildcardCache = function(nodeInterop2) {
        return nodeInterop2 ? cacheNodeInterop : cacheBabelInterop;
      })(nodeInterop);
    }
    function _interop_require_wildcard(obj, nodeInterop) {
      if (!nodeInterop && obj && obj.__esModule) {
        return obj;
      }
      if (obj === null || typeof obj !== "object" && typeof obj !== "function") {
        return {
          default: obj
        };
      }
      var cache = _getRequireWildcardCache(nodeInterop);
      if (cache && cache.has(obj)) {
        return cache.get(obj);
      }
      var newObj = {};
      var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;
      for (var key in obj) {
        if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) {
          var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;
          if (desc && (desc.get || desc.set)) {
            Object.defineProperty(newObj, key, desc);
          } else {
            newObj[key] = obj[key];
          }
        }
      }
      newObj.default = obj;
      if (cache) {
        cache.set(obj, newObj);
      }
      return newObj;
    }
    function getHash(str) {
      try {
        return _crypto.default.createHash("md5").update(str, "utf-8").digest("binary");
      } catch (err) {
        return "";
      }
    }
    function hasContentChanged(sourcePath, root) {
      let css = root.toString();
      if (!css.includes("@tailwind")) {
        return false;
      }
      let existingHash = _sharedState.sourceHashMap.get(sourcePath);
      let rootHash = getHash(css);
      let didChange = existingHash !== rootHash;
      _sharedState.sourceHashMap.set(sourcePath, rootHash);
      return didChange;
    }
  }
});

// node_modules/tailwindcss/lib/util/bigSign.js
var require_bigSign = __commonJS({
  "node_modules/tailwindcss/lib/util/bigSign.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    Object.defineProperty(exports, "default", {
      enumerable: true,
      get: function() {
        return bigSign;
      }
    });
    function bigSign(bigIntValue) {
      return (bigIntValue > 0n) - (bigIntValue < 0n);
    }
  }
});

// node_modules/tailwindcss/lib/lib/remap-bitfield.js
var require_remap_bitfield = __commonJS({
  "node_modules/tailwindcss/lib/lib/remap-bitfield.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    Object.defineProperty(exports, "remapBitfield", {
      enumerable: true,
      get: function() {
        return remapBitfield;
      }
    });
    function remapBitfield(num, mapping) {
      let oldMask = 0n;
      let newMask = 0n;
      for (let [oldBit, newBit] of mapping) {
        if (num & oldBit) {
          oldMask = oldMask | oldBit;
          newMask = newMask | newBit;
        }
      }
      return num & ~oldMask | newMask;
    }
  }
});

// node_modules/tailwindcss/lib/lib/offsets.js
var require_offsets = __commonJS({
  "node_modules/tailwindcss/lib/lib/offsets.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    Object.defineProperty(exports, "Offsets", {
      enumerable: true,
      get: function() {
        return Offsets;
      }
    });
    var _bigSign = _interop_require_default(require_bigSign());
    var _remapbitfield = require_remap_bitfield();
    function _interop_require_default(obj) {
      return obj && obj.__esModule ? obj : {
        default: obj
      };
    }
    var Offsets = class {
      constructor() {
        this.offsets = {
          defaults: 0n,
          base: 0n,
          components: 0n,
          utilities: 0n,
          variants: 0n,
          user: 0n
        };
        this.layerPositions = {
          defaults: 0n,
          base: 1n,
          components: 2n,
          utilities: 3n,
          // There isn't technically a "user" layer, but we need to give it a position
          // Because it's used for ordering user-css from @apply
          user: 4n,
          variants: 5n
        };
        this.reservedVariantBits = 0n;
        this.variantOffsets = /* @__PURE__ */ new Map();
      }
      /**
      * @param {Layer} layer
      * @returns {RuleOffset}
      */
      create(layer) {
        return {
          layer,
          parentLayer: layer,
          arbitrary: 0n,
          variants: 0n,
          parallelIndex: 0n,
          index: this.offsets[layer]++,
          propertyOffset: 0n,
          property: "",
          options: []
        };
      }
      /**
      * @param {string} name
      * @returns {RuleOffset}
      */
      arbitraryProperty(name) {
        return {
          ...this.create("utilities"),
          arbitrary: 1n,
          property: name
        };
      }
      /**
      * Get the offset for a variant
      *
      * @param {string} variant
      * @param {number} index
      * @returns {RuleOffset}
      */
      forVariant(variant, index = 0) {
        let offset = this.variantOffsets.get(variant);
        if (offset === void 0) {
          throw new Error(`Cannot find offset for unknown variant ${variant}`);
        }
        return {
          ...this.create("variants"),
          variants: offset << BigInt(index)
        };
      }
      /**
      * @param {RuleOffset} rule
      * @param {RuleOffset} variant
      * @param {VariantOption} options
      * @returns {RuleOffset}
      */
      applyVariantOffset(rule, variant, options) {
        options.variant = variant.variants;
        return {
          ...rule,
          layer: "variants",
          parentLayer: rule.layer === "variants" ? rule.parentLayer : rule.layer,
          variants: rule.variants | variant.variants,
          options: options.sort ? [].concat(options, rule.options) : rule.options,
          // TODO: Technically this is wrong. We should be handling parallel index on a per variant basis.
          // We'll take the max of all the parallel indexes for now.
          // @ts-ignore
          parallelIndex: max([
            rule.parallelIndex,
            variant.parallelIndex
          ])
        };
      }
      /**
      * @param {RuleOffset} offset
      * @param {number} parallelIndex
      * @returns {RuleOffset}
      */
      applyParallelOffset(offset, parallelIndex) {
        return {
          ...offset,
          parallelIndex: BigInt(parallelIndex)
        };
      }
      /**
      * Each variant gets 1 bit per function / rule registered.
      * This is because multiple variants can be applied to a single rule and we need to know which ones are present and which ones are not.
      * Additionally, every unique group of variants is grouped together in the stylesheet.
      *
      * This grouping is order-independent. For instance, we do not differentiate between `hover:focus` and `focus:hover`.
      *
      * @param {string[]} variants
      * @param {(name: string) => number} getLength
      */
      recordVariants(variants, getLength) {
        for (let variant of variants) {
          this.recordVariant(variant, getLength(variant));
        }
      }
      /**
      * The same as `recordVariants` but for a single arbitrary variant at runtime.
      * @param {string} variant
      * @param {number} fnCount
      *
      * @returns {RuleOffset} The highest offset for this variant
      */
      recordVariant(variant, fnCount = 1) {
        this.variantOffsets.set(variant, 1n << this.reservedVariantBits);
        this.reservedVariantBits += BigInt(fnCount);
        return {
          ...this.create("variants"),
          variants: this.variantOffsets.get(variant)
        };
      }
      /**
      * @param {RuleOffset} a
      * @param {RuleOffset} b
      * @returns {bigint}
      */
      compare(a, b) {
        if (a.layer !== b.layer) {
          return this.layerPositions[a.layer] - this.layerPositions[b.layer];
        }
        if (a.parentLayer !== b.parentLayer) {
          return this.layerPositions[a.parentLayer] - this.layerPositions[b.parentLayer];
        }
        for (let aOptions of a.options) {
          for (let bOptions of b.options) {
            if (aOptions.id !== bOptions.id)
              continue;
            if (!aOptions.sort || !bOptions.sort)
              continue;
            var _max;
            let maxFnVariant = (_max = max([
              aOptions.variant,
              bOptions.variant
            ])) !== null && _max !== void 0 ? _max : 0n;
            let mask = ~(maxFnVariant | maxFnVariant - 1n);
            let aVariantsAfterFn = a.variants & mask;
            let bVariantsAfterFn = b.variants & mask;
            if (aVariantsAfterFn !== bVariantsAfterFn) {
              continue;
            }
            let result = aOptions.sort({
              value: aOptions.value,
              modifier: aOptions.modifier
            }, {
              value: bOptions.value,
              modifier: bOptions.modifier
            });
            if (result !== 0)
              return result;
          }
        }
        if (a.variants !== b.variants) {
          return a.variants - b.variants;
        }
        if (a.parallelIndex !== b.parallelIndex) {
          return a.parallelIndex - b.parallelIndex;
        }
        if (a.arbitrary !== b.arbitrary) {
          return a.arbitrary - b.arbitrary;
        }
        if (a.propertyOffset !== b.propertyOffset) {
          return a.propertyOffset - b.propertyOffset;
        }
        return a.index - b.index;
      }
      /**
      * Arbitrary variants are recorded in the order they're encountered.
      * This means that the order is not stable between environments and sets of content files.
      *
      * In order to make the order stable, we need to remap the arbitrary variant offsets to
      * be in alphabetical order starting from the offset of the first arbitrary variant.
      */
      recalculateVariantOffsets() {
        let variants = Array.from(this.variantOffsets.entries()).filter(([v]) => v.startsWith("[")).sort(([a], [z]) => fastCompare(a, z));
        let newOffsets = variants.map(([, offset]) => offset).sort((a, z) => (0, _bigSign.default)(a - z));
        let mapping = variants.map(([, oldOffset], i) => [
          oldOffset,
          newOffsets[i]
        ]);
        return mapping.filter(([a, z]) => a !== z);
      }
      /**
      * @template T
      * @param {[RuleOffset, T][]} list
      * @returns {[RuleOffset, T][]}
      */
      remapArbitraryVariantOffsets(list) {
        let mapping = this.recalculateVariantOffsets();
        if (mapping.length === 0) {
          return list;
        }
        return list.map((item) => {
          let [offset, rule] = item;
          offset = {
            ...offset,
            variants: (0, _remapbitfield.remapBitfield)(offset.variants, mapping)
          };
          return [
            offset,
            rule
          ];
        });
      }
      /**
      * @template T
      * @param {[RuleOffset, T][]} list
      * @returns {[RuleOffset, T][]}
      */
      sortArbitraryProperties(list) {
        let known = /* @__PURE__ */ new Set();
        for (let [offset2] of list) {
          if (offset2.arbitrary === 1n) {
            known.add(offset2.property);
          }
        }
        if (known.size === 0) {
          return list;
        }
        let properties = Array.from(known).sort();
        let offsets = /* @__PURE__ */ new Map();
        let offset = 1n;
        for (let property of properties) {
          offsets.set(property, offset++);
        }
        return list.map((item) => {
          let [offset2, rule] = item;
          var _offsets_get;
          offset2 = {
            ...offset2,
            propertyOffset: (_offsets_get = offsets.get(offset2.property)) !== null && _offsets_get !== void 0 ? _offsets_get : 0n
          };
          return [
            offset2,
            rule
          ];
        });
      }
      /**
      * @template T
      * @param {[RuleOffset, T][]} list
      * @returns {[RuleOffset, T][]}
      */
      sort(list) {
        list = this.remapArbitraryVariantOffsets(list);
        list = this.sortArbitraryProperties(list);
        return list.sort(([a], [b]) => (0, _bigSign.default)(this.compare(a, b)));
      }
    };
    function max(nums) {
      let max2 = null;
      for (const num of nums) {
        max2 = max2 !== null && max2 !== void 0 ? max2 : num;
        max2 = max2 > num ? max2 : num;
      }
      return max2;
    }
    function fastCompare(a, b) {
      let aLen = a.length;
      let bLen = b.length;
      let minLen = aLen < bLen ? aLen : bLen;
      for (let i = 0; i < minLen; i++) {
        let cmp = a.charCodeAt(i) - b.charCodeAt(i);
        if (cmp !== 0)
          return cmp;
      }
      return aLen - bLen;
    }
  }
});

// node_modules/tailwindcss/lib/lib/setupContextUtils.js
var require_setupContextUtils = __commonJS({
  "node_modules/tailwindcss/lib/lib/setupContextUtils.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    function _export(target, all) {
      for (var name in all)
        Object.defineProperty(target, name, {
          enumerable: true,
          get: all[name]
        });
    }
    _export(exports, {
      INTERNAL_FEATURES: function() {
        return INTERNAL_FEATURES;
      },
      isValidVariantFormatString: function() {
        return isValidVariantFormatString;
      },
      parseVariant: function() {
        return parseVariant;
      },
      getFileModifiedMap: function() {
        return getFileModifiedMap;
      },
      createContext: function() {
        return createContext;
      },
      getContext: function() {
        return getContext;
      }
    });
    var _fs = _interop_require_default(require_fs());
    var _url = _interop_require_default(require_url());
    var _postcss = _interop_require_default(require_postcss());
    var _dlv = _interop_require_default(require_dlv_umd());
    var _postcssselectorparser = _interop_require_default(require_dist());
    var _transformThemeValue = _interop_require_default(require_transformThemeValue());
    var _parseObjectStyles = _interop_require_default(require_parseObjectStyles());
    var _prefixSelector = _interop_require_default(require_prefixSelector());
    var _isPlainObject = _interop_require_default(require_isPlainObject());
    var _escapeClassName = _interop_require_default(require_escapeClassName());
    var _nameClass = _interop_require_wildcard(require_nameClass());
    var _pluginUtils = require_pluginUtils();
    var _corePlugins = require_corePlugins();
    var _sharedState = _interop_require_wildcard(require_sharedState());
    var _toPath = require_toPath();
    var _log = _interop_require_default(require_log());
    var _negateValue = _interop_require_default(require_negateValue());
    var _isSyntacticallyValidPropertyValue = _interop_require_default(require_isSyntacticallyValidPropertyValue());
    var _generateRules = require_generateRules();
    var _cacheInvalidation = require_cacheInvalidation();
    var _offsets = require_offsets();
    var _featureFlags = require_featureFlags();
    var _formatVariantSelector = require_formatVariantSelector();
    function _interop_require_default(obj) {
      return obj && obj.__esModule ? obj : {
        default: obj
      };
    }
    function _getRequireWildcardCache(nodeInterop) {
      if (typeof WeakMap !== "function")
        return null;
      var cacheBabelInterop = /* @__PURE__ */ new WeakMap();
      var cacheNodeInterop = /* @__PURE__ */ new WeakMap();
      return (_getRequireWildcardCache = function(nodeInterop2) {
        return nodeInterop2 ? cacheNodeInterop : cacheBabelInterop;
      })(nodeInterop);
    }
    function _interop_require_wildcard(obj, nodeInterop) {
      if (!nodeInterop && obj && obj.__esModule) {
        return obj;
      }
      if (obj === null || typeof obj !== "object" && typeof obj !== "function") {
        return {
          default: obj
        };
      }
      var cache = _getRequireWildcardCache(nodeInterop);
      if (cache && cache.has(obj)) {
        return cache.get(obj);
      }
      var newObj = {};
      var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;
      for (var key in obj) {
        if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) {
          var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;
          if (desc && (desc.get || desc.set)) {
            Object.defineProperty(newObj, key, desc);
          } else {
            newObj[key] = obj[key];
          }
        }
      }
      newObj.default = obj;
      if (cache) {
        cache.set(obj, newObj);
      }
      return newObj;
    }
    var INTERNAL_FEATURES = Symbol();
    var VARIANT_TYPES = {
      AddVariant: Symbol.for("ADD_VARIANT"),
      MatchVariant: Symbol.for("MATCH_VARIANT")
    };
    var VARIANT_INFO = {
      Base: 1 << 0,
      Dynamic: 1 << 1
    };
    function prefix(context, selector) {
      let prefix2 = context.tailwindConfig.prefix;
      return typeof prefix2 === "function" ? prefix2(selector) : prefix2 + selector;
    }
    function normalizeOptionTypes({ type = "any", ...options }) {
      let types = [].concat(type);
      return {
        ...options,
        types: types.map((type2) => {
          if (Array.isArray(type2)) {
            return {
              type: type2[0],
              ...type2[1]
            };
          }
          return {
            type: type2,
            preferOnConflict: false
          };
        })
      };
    }
    function parseVariantFormatString(input2) {
      let parts = [];
      let current = "";
      let depth = 0;
      for (let idx = 0; idx < input2.length; idx++) {
        let char = input2[idx];
        if (char === "\\") {
          current += "\\" + input2[++idx];
        } else if (char === "{") {
          ++depth;
          parts.push(current.trim());
          current = "";
        } else if (char === "}") {
          if (--depth < 0) {
            throw new Error(`Your { and } are unbalanced.`);
          }
          parts.push(current.trim());
          current = "";
        } else {
          current += char;
        }
      }
      if (current.length > 0) {
        parts.push(current.trim());
      }
      parts = parts.filter((part) => part !== "");
      return parts;
    }
    function insertInto(list, value2, { before = [] } = {}) {
      before = [].concat(before);
      if (before.length <= 0) {
        list.push(value2);
        return;
      }
      let idx = list.length - 1;
      for (let other of before) {
        let iidx = list.indexOf(other);
        if (iidx === -1)
          continue;
        idx = Math.min(idx, iidx);
      }
      list.splice(idx, 0, value2);
    }
    function parseStyles(styles) {
      if (!Array.isArray(styles)) {
        return parseStyles([
          styles
        ]);
      }
      return styles.flatMap((style) => {
        let isNode = !Array.isArray(style) && !(0, _isPlainObject.default)(style);
        return isNode ? style : (0, _parseObjectStyles.default)(style);
      });
    }
    function getClasses(selector, mutate) {
      let parser = (0, _postcssselectorparser.default)((selectors) => {
        let allClasses = [];
        if (mutate) {
          mutate(selectors);
        }
        selectors.walkClasses((classNode) => {
          allClasses.push(classNode.value);
        });
        return allClasses;
      });
      return parser.transformSync(selector);
    }
    function ignoreNot(selectors) {
      selectors.walkPseudos((pseudo) => {
        if (pseudo.value === ":not") {
          pseudo.remove();
        }
      });
    }
    function extractCandidates(node, state2 = {
      containsNonOnDemandable: false
    }, depth = 0) {
      let classes = [];
      let selectors = [];
      if (node.type === "rule") {
        selectors.push(...node.selectors);
      } else if (node.type === "atrule") {
        node.walkRules((rule) => selectors.push(...rule.selectors));
      }
      for (let selector of selectors) {
        let classCandidates = getClasses(selector, ignoreNot);
        if (classCandidates.length === 0) {
          state2.containsNonOnDemandable = true;
        }
        for (let classCandidate of classCandidates) {
          classes.push(classCandidate);
        }
      }
      if (depth === 0) {
        return [
          state2.containsNonOnDemandable || classes.length === 0,
          classes
        ];
      }
      return classes;
    }
    function withIdentifiers(styles) {
      return parseStyles(styles).flatMap((node) => {
        let nodeMap = /* @__PURE__ */ new Map();
        let [containsNonOnDemandableSelectors, candidates] = extractCandidates(node);
        if (containsNonOnDemandableSelectors) {
          candidates.unshift(_sharedState.NOT_ON_DEMAND);
        }
        return candidates.map((c) => {
          if (!nodeMap.has(node)) {
            nodeMap.set(node, node);
          }
          return [
            c,
            nodeMap.get(node)
          ];
        });
      });
    }
    function isValidVariantFormatString(format) {
      return format.startsWith("@") || format.includes("&");
    }
    function parseVariant(variant) {
      variant = variant.replace(/\n+/g, "").replace(/\s{1,}/g, " ").trim();
      let fns = parseVariantFormatString(variant).map((str) => {
        if (!str.startsWith("@")) {
          return ({ format }) => format(str);
        }
        let [, name, params] = /@(\S*)( .+|[({].*)?/g.exec(str);
        var _params_trim;
        return ({ wrap }) => {
          return wrap(_postcss.default.atRule({
            name,
            params: (_params_trim = params === null || params === void 0 ? void 0 : params.trim()) !== null && _params_trim !== void 0 ? _params_trim : ""
          }));
        };
      }).reverse();
      return (api) => {
        for (let fn of fns) {
          fn(api);
        }
      };
    }
    function buildPluginApi(tailwindConfig, context, { variantList, variantMap, offsets, classList }) {
      function getConfigValue(path, defaultValue) {
        return path ? (0, _dlv.default)(tailwindConfig, path, defaultValue) : tailwindConfig;
      }
      function applyConfiguredPrefix(selector) {
        return (0, _prefixSelector.default)(tailwindConfig.prefix, selector);
      }
      function prefixIdentifier(identifier, options) {
        if (identifier === _sharedState.NOT_ON_DEMAND) {
          return _sharedState.NOT_ON_DEMAND;
        }
        if (!options.respectPrefix) {
          return identifier;
        }
        return context.tailwindConfig.prefix + identifier;
      }
      function resolveThemeValue(path, defaultValue, opts = {}) {
        let parts = (0, _toPath.toPath)(path);
        let value2 = getConfigValue([
          "theme",
          ...parts
        ], defaultValue);
        return (0, _transformThemeValue.default)(parts[0])(value2, opts);
      }
      let variantIdentifier = 0;
      let api = {
        postcss: _postcss.default,
        prefix: applyConfiguredPrefix,
        e: _escapeClassName.default,
        config: getConfigValue,
        theme: resolveThemeValue,
        corePlugins: (path) => {
          if (Array.isArray(tailwindConfig.corePlugins)) {
            return tailwindConfig.corePlugins.includes(path);
          }
          return getConfigValue([
            "corePlugins",
            path
          ], true);
        },
        variants: () => {
          return [];
        },
        addBase(base) {
          for (let [identifier, rule] of withIdentifiers(base)) {
            let prefixedIdentifier = prefixIdentifier(identifier, {});
            let offset = offsets.create("base");
            if (!context.candidateRuleMap.has(prefixedIdentifier)) {
              context.candidateRuleMap.set(prefixedIdentifier, []);
            }
            context.candidateRuleMap.get(prefixedIdentifier).push([
              {
                sort: offset,
                layer: "base"
              },
              rule
            ]);
          }
        },
        /**
        * @param {string} group
        * @param {Record<string, string | string[]>} declarations
        */
        addDefaults(group, declarations) {
          const groups = {
            [`@defaults ${group}`]: declarations
          };
          for (let [identifier, rule] of withIdentifiers(groups)) {
            let prefixedIdentifier = prefixIdentifier(identifier, {});
            if (!context.candidateRuleMap.has(prefixedIdentifier)) {
              context.candidateRuleMap.set(prefixedIdentifier, []);
            }
            context.candidateRuleMap.get(prefixedIdentifier).push([
              {
                sort: offsets.create("defaults"),
                layer: "defaults"
              },
              rule
            ]);
          }
        },
        addComponents(components, options) {
          let defaultOptions = {
            preserveSource: false,
            respectPrefix: true,
            respectImportant: false
          };
          options = Object.assign({}, defaultOptions, Array.isArray(options) ? {} : options);
          for (let [identifier, rule] of withIdentifiers(components)) {
            let prefixedIdentifier = prefixIdentifier(identifier, options);
            classList.add(prefixedIdentifier);
            if (!context.candidateRuleMap.has(prefixedIdentifier)) {
              context.candidateRuleMap.set(prefixedIdentifier, []);
            }
            context.candidateRuleMap.get(prefixedIdentifier).push([
              {
                sort: offsets.create("components"),
                layer: "components",
                options
              },
              rule
            ]);
          }
        },
        addUtilities(utilities, options) {
          let defaultOptions = {
            preserveSource: false,
            respectPrefix: true,
            respectImportant: true
          };
          options = Object.assign({}, defaultOptions, Array.isArray(options) ? {} : options);
          for (let [identifier, rule] of withIdentifiers(utilities)) {
            let prefixedIdentifier = prefixIdentifier(identifier, options);
            classList.add(prefixedIdentifier);
            if (!context.candidateRuleMap.has(prefixedIdentifier)) {
              context.candidateRuleMap.set(prefixedIdentifier, []);
            }
            context.candidateRuleMap.get(prefixedIdentifier).push([
              {
                sort: offsets.create("utilities"),
                layer: "utilities",
                options
              },
              rule
            ]);
          }
        },
        matchUtilities: function(utilities, options) {
          let defaultOptions = {
            respectPrefix: true,
            respectImportant: true,
            modifiers: false
          };
          options = normalizeOptionTypes({
            ...defaultOptions,
            ...options
          });
          let offset = offsets.create("utilities");
          for (let identifier in utilities) {
            let wrapped = function(modifier, { isOnlyPlugin }) {
              let [value2, coercedType, utilityModifier] = (0, _pluginUtils.coerceValue)(options.types, modifier, options, tailwindConfig);
              if (value2 === void 0) {
                return [];
              }
              if (!options.types.some(({ type }) => type === coercedType)) {
                if (isOnlyPlugin) {
                  _log.default.warn([
                    `Unnecessary typehint \`${coercedType}\` in \`${identifier}-${modifier}\`.`,
                    `You can safely update it to \`${identifier}-${modifier.replace(coercedType + ":", "")}\`.`
                  ]);
                } else {
                  return [];
                }
              }
              if (!(0, _isSyntacticallyValidPropertyValue.default)(value2)) {
                return [];
              }
              let extras = {
                get modifier() {
                  if (!options.modifiers) {
                    _log.default.warn(`modifier-used-without-options-for-${identifier}`, [
                      "Your plugin must set `modifiers: true` in its options to support modifiers."
                    ]);
                  }
                  return utilityModifier;
                }
              };
              let modifiersEnabled = (0, _featureFlags.flagEnabled)(tailwindConfig, "generalizedModifiers");
              let ruleSets = [].concat(modifiersEnabled ? rule(value2, extras) : rule(value2)).filter(Boolean).map((declaration) => ({
                [(0, _nameClass.default)(identifier, modifier)]: declaration
              }));
              return ruleSets;
            };
            let prefixedIdentifier = prefixIdentifier(identifier, options);
            let rule = utilities[identifier];
            classList.add([
              prefixedIdentifier,
              options
            ]);
            let withOffsets = [
              {
                sort: offset,
                layer: "utilities",
                options
              },
              wrapped
            ];
            if (!context.candidateRuleMap.has(prefixedIdentifier)) {
              context.candidateRuleMap.set(prefixedIdentifier, []);
            }
            context.candidateRuleMap.get(prefixedIdentifier).push(withOffsets);
          }
        },
        matchComponents: function(components, options) {
          let defaultOptions = {
            respectPrefix: true,
            respectImportant: false,
            modifiers: false
          };
          options = normalizeOptionTypes({
            ...defaultOptions,
            ...options
          });
          let offset = offsets.create("components");
          for (let identifier in components) {
            let wrapped = function(modifier, { isOnlyPlugin }) {
              let [value2, coercedType, utilityModifier] = (0, _pluginUtils.coerceValue)(options.types, modifier, options, tailwindConfig);
              if (value2 === void 0) {
                return [];
              }
              if (!options.types.some(({ type }) => type === coercedType)) {
                if (isOnlyPlugin) {
                  _log.default.warn([
                    `Unnecessary typehint \`${coercedType}\` in \`${identifier}-${modifier}\`.`,
                    `You can safely update it to \`${identifier}-${modifier.replace(coercedType + ":", "")}\`.`
                  ]);
                } else {
                  return [];
                }
              }
              if (!(0, _isSyntacticallyValidPropertyValue.default)(value2)) {
                return [];
              }
              let extras = {
                get modifier() {
                  if (!options.modifiers) {
                    _log.default.warn(`modifier-used-without-options-for-${identifier}`, [
                      "Your plugin must set `modifiers: true` in its options to support modifiers."
                    ]);
                  }
                  return utilityModifier;
                }
              };
              let modifiersEnabled = (0, _featureFlags.flagEnabled)(tailwindConfig, "generalizedModifiers");
              let ruleSets = [].concat(modifiersEnabled ? rule(value2, extras) : rule(value2)).filter(Boolean).map((declaration) => ({
                [(0, _nameClass.default)(identifier, modifier)]: declaration
              }));
              return ruleSets;
            };
            let prefixedIdentifier = prefixIdentifier(identifier, options);
            let rule = components[identifier];
            classList.add([
              prefixedIdentifier,
              options
            ]);
            let withOffsets = [
              {
                sort: offset,
                layer: "components",
                options
              },
              wrapped
            ];
            if (!context.candidateRuleMap.has(prefixedIdentifier)) {
              context.candidateRuleMap.set(prefixedIdentifier, []);
            }
            context.candidateRuleMap.get(prefixedIdentifier).push(withOffsets);
          }
        },
        addVariant(variantName, variantFunctions, options = {}) {
          variantFunctions = [].concat(variantFunctions).map((variantFunction) => {
            if (typeof variantFunction !== "string") {
              return (api2 = {}) => {
                let { args, modifySelectors, container, separator, wrap, format } = api2;
                let result = variantFunction(Object.assign({
                  modifySelectors,
                  container,
                  separator
                }, options.type === VARIANT_TYPES.MatchVariant && {
                  args,
                  wrap,
                  format
                }));
                if (typeof result === "string" && !isValidVariantFormatString(result)) {
                  throw new Error(`Your custom variant \`${variantName}\` has an invalid format string. Make sure it's an at-rule or contains a \`&\` placeholder.`);
                }
                if (Array.isArray(result)) {
                  return result.filter((variant) => typeof variant === "string").map((variant) => parseVariant(variant));
                }
                return result && typeof result === "string" && parseVariant(result)(api2);
              };
            }
            if (!isValidVariantFormatString(variantFunction)) {
              throw new Error(`Your custom variant \`${variantName}\` has an invalid format string. Make sure it's an at-rule or contains a \`&\` placeholder.`);
            }
            return parseVariant(variantFunction);
          });
          insertInto(variantList, variantName, options);
          variantMap.set(variantName, variantFunctions);
          context.variantOptions.set(variantName, options);
        },
        matchVariant(variant, variantFn, options) {
          var _options_id;
          let id = (_options_id = options === null || options === void 0 ? void 0 : options.id) !== null && _options_id !== void 0 ? _options_id : ++variantIdentifier;
          let isSpecial = variant === "@";
          let modifiersEnabled = (0, _featureFlags.flagEnabled)(tailwindConfig, "generalizedModifiers");
          var _options_values;
          for (let [key, value2] of Object.entries((_options_values = options === null || options === void 0 ? void 0 : options.values) !== null && _options_values !== void 0 ? _options_values : {})) {
            if (key === "DEFAULT")
              continue;
            api.addVariant(isSpecial ? `${variant}${key}` : `${variant}-${key}`, ({ args, container }) => {
              return variantFn(value2, modifiersEnabled ? {
                modifier: args === null || args === void 0 ? void 0 : args.modifier,
                container
              } : {
                container
              });
            }, {
              ...options,
              value: value2,
              id,
              type: VARIANT_TYPES.MatchVariant,
              variantInfo: VARIANT_INFO.Base
            });
          }
          var _options_values1;
          let hasDefault = "DEFAULT" in ((_options_values1 = options === null || options === void 0 ? void 0 : options.values) !== null && _options_values1 !== void 0 ? _options_values1 : {});
          api.addVariant(variant, ({ args, container }) => {
            if ((args === null || args === void 0 ? void 0 : args.value) === _sharedState.NONE && !hasDefault) {
              return null;
            }
            var _args_value;
            return variantFn((args === null || args === void 0 ? void 0 : args.value) === _sharedState.NONE ? options.values.DEFAULT : (_args_value = args === null || args === void 0 ? void 0 : args.value) !== null && _args_value !== void 0 ? _args_value : typeof args === "string" ? args : "", modifiersEnabled ? {
              modifier: args === null || args === void 0 ? void 0 : args.modifier,
              container
            } : {
              container
            });
          }, {
            ...options,
            id,
            type: VARIANT_TYPES.MatchVariant,
            variantInfo: VARIANT_INFO.Dynamic
          });
        }
      };
      return api;
    }
    var fileModifiedMapCache = /* @__PURE__ */ new WeakMap();
    function getFileModifiedMap(context) {
      if (!fileModifiedMapCache.has(context)) {
        fileModifiedMapCache.set(context, /* @__PURE__ */ new Map());
      }
      return fileModifiedMapCache.get(context);
    }
    function trackModified(files, fileModifiedMap) {
      let changed = false;
      let mtimesToCommit = /* @__PURE__ */ new Map();
      for (let file of files) {
        var _fs_statSync;
        if (!file)
          continue;
        let parsed = _url.default.parse(file);
        let pathname = parsed.hash ? parsed.href.replace(parsed.hash, "") : parsed.href;
        pathname = parsed.search ? pathname.replace(parsed.search, "") : pathname;
        let newModified = (_fs_statSync = _fs.default.statSync(decodeURIComponent(pathname), {
          throwIfNoEntry: false
        })) === null || _fs_statSync === void 0 ? void 0 : _fs_statSync.mtimeMs;
        if (!newModified) {
          continue;
        }
        if (!fileModifiedMap.has(file) || newModified > fileModifiedMap.get(file)) {
          changed = true;
        }
        mtimesToCommit.set(file, newModified);
      }
      return [
        changed,
        mtimesToCommit
      ];
    }
    function extractVariantAtRules(node) {
      node.walkAtRules((atRule) => {
        if ([
          "responsive",
          "variants"
        ].includes(atRule.name)) {
          extractVariantAtRules(atRule);
          atRule.before(atRule.nodes);
          atRule.remove();
        }
      });
    }
    function collectLayerPlugins(root) {
      let layerPlugins = [];
      root.each((node) => {
        if (node.type === "atrule" && [
          "responsive",
          "variants"
        ].includes(node.name)) {
          node.name = "layer";
          node.params = "utilities";
        }
      });
      root.walkAtRules("layer", (layerRule) => {
        extractVariantAtRules(layerRule);
        if (layerRule.params === "base") {
          for (let node of layerRule.nodes) {
            layerPlugins.push(function({ addBase }) {
              addBase(node, {
                respectPrefix: false
              });
            });
          }
          layerRule.remove();
        } else if (layerRule.params === "components") {
          for (let node of layerRule.nodes) {
            layerPlugins.push(function({ addComponents }) {
              addComponents(node, {
                respectPrefix: false,
                preserveSource: true
              });
            });
          }
          layerRule.remove();
        } else if (layerRule.params === "utilities") {
          for (let node of layerRule.nodes) {
            layerPlugins.push(function({ addUtilities }) {
              addUtilities(node, {
                respectPrefix: false,
                preserveSource: true
              });
            });
          }
          layerRule.remove();
        }
      });
      return layerPlugins;
    }
    function resolvePlugins(context, root) {
      let corePluginList = Object.entries({
        ..._corePlugins.variantPlugins,
        ..._corePlugins.corePlugins
      }).map(([name, plugin]) => {
        if (!context.tailwindConfig.corePlugins.includes(name)) {
          return null;
        }
        return plugin;
      }).filter(Boolean);
      let userPlugins = context.tailwindConfig.plugins.map((plugin) => {
        if (plugin.__isOptionsFunction) {
          plugin = plugin();
        }
        return typeof plugin === "function" ? plugin : plugin.handler;
      });
      let layerPlugins = collectLayerPlugins(root);
      let beforeVariants = [
        _corePlugins.variantPlugins["childVariant"],
        _corePlugins.variantPlugins["pseudoElementVariants"],
        _corePlugins.variantPlugins["pseudoClassVariants"],
        _corePlugins.variantPlugins["hasVariants"],
        _corePlugins.variantPlugins["ariaVariants"],
        _corePlugins.variantPlugins["dataVariants"]
      ];
      let afterVariants = [
        _corePlugins.variantPlugins["supportsVariants"],
        _corePlugins.variantPlugins["reducedMotionVariants"],
        _corePlugins.variantPlugins["prefersContrastVariants"],
        _corePlugins.variantPlugins["screenVariants"],
        _corePlugins.variantPlugins["orientationVariants"],
        _corePlugins.variantPlugins["directionVariants"],
        _corePlugins.variantPlugins["darkVariants"],
        _corePlugins.variantPlugins["forcedColorsVariants"],
        _corePlugins.variantPlugins["printVariant"]
      ];
      let isLegacyDarkMode = context.tailwindConfig.darkMode === "class" || Array.isArray(context.tailwindConfig.darkMode) && context.tailwindConfig.darkMode[0] === "class";
      if (isLegacyDarkMode) {
        afterVariants = [
          _corePlugins.variantPlugins["supportsVariants"],
          _corePlugins.variantPlugins["reducedMotionVariants"],
          _corePlugins.variantPlugins["prefersContrastVariants"],
          _corePlugins.variantPlugins["darkVariants"],
          _corePlugins.variantPlugins["screenVariants"],
          _corePlugins.variantPlugins["orientationVariants"],
          _corePlugins.variantPlugins["directionVariants"],
          _corePlugins.variantPlugins["forcedColorsVariants"],
          _corePlugins.variantPlugins["printVariant"]
        ];
      }
      return [
        ...corePluginList,
        ...beforeVariants,
        ...userPlugins,
        ...afterVariants,
        ...layerPlugins
      ];
    }
    function registerPlugins(plugins, context) {
      let variantList = [];
      let variantMap = /* @__PURE__ */ new Map();
      context.variantMap = variantMap;
      let offsets = new _offsets.Offsets();
      context.offsets = offsets;
      let classList = /* @__PURE__ */ new Set();
      let pluginApi = buildPluginApi(context.tailwindConfig, context, {
        variantList,
        variantMap,
        offsets,
        classList
      });
      for (let plugin of plugins) {
        if (Array.isArray(plugin)) {
          for (let pluginItem of plugin) {
            pluginItem(pluginApi);
          }
        } else {
          plugin === null || plugin === void 0 ? void 0 : plugin(pluginApi);
        }
      }
      offsets.recordVariants(variantList, (variant) => variantMap.get(variant).length);
      for (let [variantName, variantFunctions] of variantMap.entries()) {
        context.variantMap.set(variantName, variantFunctions.map((variantFunction, idx) => [
          offsets.forVariant(variantName, idx),
          variantFunction
        ]));
      }
      var _context_tailwindConfig_safelist;
      let safelist = ((_context_tailwindConfig_safelist = context.tailwindConfig.safelist) !== null && _context_tailwindConfig_safelist !== void 0 ? _context_tailwindConfig_safelist : []).filter(Boolean);
      if (safelist.length > 0) {
        let checks = [];
        for (let value2 of safelist) {
          if (typeof value2 === "string") {
            context.changedContent.push({
              content: value2,
              extension: "html"
            });
            continue;
          }
          if (value2 instanceof RegExp) {
            _log.default.warn("root-regex", [
              "Regular expressions in `safelist` work differently in Tailwind CSS v3.0.",
              "Update your `safelist` configuration to eliminate this warning.",
              "https://tailwindcss.com/docs/content-configuration#safelisting-classes"
            ]);
            continue;
          }
          checks.push(value2);
        }
        if (checks.length > 0) {
          let patternMatchingCount = /* @__PURE__ */ new Map();
          let prefixLength = context.tailwindConfig.prefix.length;
          let checkImportantUtils = checks.some((check) => check.pattern.source.includes("!"));
          for (let util of classList) {
            let utils = Array.isArray(util) ? (() => {
              let [utilName, options] = util;
              var _options_values;
              let values = Object.keys((_options_values = options === null || options === void 0 ? void 0 : options.values) !== null && _options_values !== void 0 ? _options_values : {});
              let classes = values.map((value2) => (0, _nameClass.formatClass)(utilName, value2));
              if (options === null || options === void 0 ? void 0 : options.supportsNegativeValues) {
                classes = [
                  ...classes,
                  ...classes.map((cls) => "-" + cls)
                ];
                classes = [
                  ...classes,
                  ...classes.map((cls) => cls.slice(0, prefixLength) + "-" + cls.slice(prefixLength))
                ];
              }
              if (options.types.some(({ type }) => type === "color")) {
                classes = [
                  ...classes,
                  ...classes.flatMap((cls) => Object.keys(context.tailwindConfig.theme.opacity).map((opacity) => `${cls}/${opacity}`))
                ];
              }
              if (checkImportantUtils && (options === null || options === void 0 ? void 0 : options.respectImportant)) {
                classes = [
                  ...classes,
                  ...classes.map((cls) => "!" + cls)
                ];
              }
              return classes;
            })() : [
              util
            ];
            for (let util2 of utils) {
              for (let { pattern, variants = [] } of checks) {
                pattern.lastIndex = 0;
                if (!patternMatchingCount.has(pattern)) {
                  patternMatchingCount.set(pattern, 0);
                }
                if (!pattern.test(util2))
                  continue;
                patternMatchingCount.set(pattern, patternMatchingCount.get(pattern) + 1);
                context.changedContent.push({
                  content: util2,
                  extension: "html"
                });
                for (let variant of variants) {
                  context.changedContent.push({
                    content: variant + context.tailwindConfig.separator + util2,
                    extension: "html"
                  });
                }
              }
            }
          }
          for (let [regex, count] of patternMatchingCount.entries()) {
            if (count !== 0)
              continue;
            _log.default.warn([
              `The safelist pattern \`${regex}\` doesn't match any Tailwind CSS classes.`,
              "Fix this pattern or remove it from your `safelist` configuration.",
              "https://tailwindcss.com/docs/content-configuration#safelisting-classes"
            ]);
          }
        }
      }
      var _context_tailwindConfig_darkMode, _concat_;
      let darkClassName = (_concat_ = [].concat((_context_tailwindConfig_darkMode = context.tailwindConfig.darkMode) !== null && _context_tailwindConfig_darkMode !== void 0 ? _context_tailwindConfig_darkMode : "media")[1]) !== null && _concat_ !== void 0 ? _concat_ : "dark";
      let parasiteUtilities = [
        prefix(context, darkClassName),
        prefix(context, "group"),
        prefix(context, "peer")
      ];
      context.getClassOrder = function getClassOrder(classes) {
        let sorted = [
          ...classes
        ].sort((a, z) => {
          if (a === z)
            return 0;
          if (a < z)
            return -1;
          return 1;
        });
        let sortedClassNames = new Map(sorted.map((className) => [
          className,
          null
        ]));
        let rules = (0, _generateRules.generateRules)(new Set(sorted), context, true);
        rules = context.offsets.sort(rules);
        let idx = BigInt(parasiteUtilities.length);
        for (const [, rule] of rules) {
          let candidate = rule.raws.tailwind.candidate;
          var _sortedClassNames_get;
          sortedClassNames.set(candidate, (_sortedClassNames_get = sortedClassNames.get(candidate)) !== null && _sortedClassNames_get !== void 0 ? _sortedClassNames_get : idx++);
        }
        return classes.map((className) => {
          var _sortedClassNames_get2;
          let order = (_sortedClassNames_get2 = sortedClassNames.get(className)) !== null && _sortedClassNames_get2 !== void 0 ? _sortedClassNames_get2 : null;
          let parasiteIndex = parasiteUtilities.indexOf(className);
          if (order === null && parasiteIndex !== -1) {
            order = BigInt(parasiteIndex);
          }
          return [
            className,
            order
          ];
        });
      };
      context.getClassList = function getClassList(options = {}) {
        let output = [];
        for (let util of classList) {
          if (Array.isArray(util)) {
            var _utilOptions_types;
            let [utilName, utilOptions] = util;
            let negativeClasses = [];
            var _utilOptions_modifiers;
            let modifiers = Object.keys((_utilOptions_modifiers = utilOptions === null || utilOptions === void 0 ? void 0 : utilOptions.modifiers) !== null && _utilOptions_modifiers !== void 0 ? _utilOptions_modifiers : {});
            if (utilOptions === null || utilOptions === void 0 ? void 0 : (_utilOptions_types = utilOptions.types) === null || _utilOptions_types === void 0 ? void 0 : _utilOptions_types.some(({ type }) => type === "color")) {
              var _context_tailwindConfig_theme_opacity;
              modifiers.push(...Object.keys((_context_tailwindConfig_theme_opacity = context.tailwindConfig.theme.opacity) !== null && _context_tailwindConfig_theme_opacity !== void 0 ? _context_tailwindConfig_theme_opacity : {}));
            }
            let metadata = {
              modifiers
            };
            let includeMetadata = options.includeMetadata && modifiers.length > 0;
            var _utilOptions_values;
            for (let [key, value2] of Object.entries((_utilOptions_values = utilOptions === null || utilOptions === void 0 ? void 0 : utilOptions.values) !== null && _utilOptions_values !== void 0 ? _utilOptions_values : {})) {
              if (value2 == null) {
                continue;
              }
              let cls = (0, _nameClass.formatClass)(utilName, key);
              output.push(includeMetadata ? [
                cls,
                metadata
              ] : cls);
              if ((utilOptions === null || utilOptions === void 0 ? void 0 : utilOptions.supportsNegativeValues) && (0, _negateValue.default)(value2)) {
                let cls2 = (0, _nameClass.formatClass)(utilName, `-${key}`);
                negativeClasses.push(includeMetadata ? [
                  cls2,
                  metadata
                ] : cls2);
              }
            }
            output.push(...negativeClasses);
          } else {
            output.push(util);
          }
        }
        return output;
      };
      context.getVariants = function getVariants() {
        let id = Math.random().toString(36).substring(7).toUpperCase();
        let result = [];
        for (let [name, options] of context.variantOptions.entries()) {
          if (options.variantInfo === VARIANT_INFO.Base)
            continue;
          var _options_values;
          result.push({
            name,
            isArbitrary: options.type === Symbol.for("MATCH_VARIANT"),
            values: Object.keys((_options_values = options.values) !== null && _options_values !== void 0 ? _options_values : {}),
            hasDash: name !== "@",
            selectors({ modifier, value: value2 } = {}) {
              let candidate = `TAILWINDPLACEHOLDER${id}`;
              let rule = _postcss.default.rule({
                selector: `.${candidate}`
              });
              let container = _postcss.default.root({
                nodes: [
                  rule.clone()
                ]
              });
              let before = container.toString();
              var _context_variantMap_get;
              let fns = ((_context_variantMap_get = context.variantMap.get(name)) !== null && _context_variantMap_get !== void 0 ? _context_variantMap_get : []).flatMap(([_, fn]) => fn);
              let formatStrings = [];
              for (let fn of fns) {
                var _options_values2;
                let localFormatStrings = [];
                var _options_values_value;
                let api = {
                  args: {
                    modifier,
                    value: (_options_values_value = (_options_values2 = options.values) === null || _options_values2 === void 0 ? void 0 : _options_values2[value2]) !== null && _options_values_value !== void 0 ? _options_values_value : value2
                  },
                  separator: context.tailwindConfig.separator,
                  modifySelectors(modifierFunction) {
                    container.each((rule2) => {
                      if (rule2.type !== "rule") {
                        return;
                      }
                      rule2.selectors = rule2.selectors.map((selector) => {
                        return modifierFunction({
                          get className() {
                            return (0, _generateRules.getClassNameFromSelector)(selector);
                          },
                          selector
                        });
                      });
                    });
                    return container;
                  },
                  format(str) {
                    localFormatStrings.push(str);
                  },
                  wrap(wrapper) {
                    localFormatStrings.push(`@${wrapper.name} ${wrapper.params} { & }`);
                  },
                  container
                };
                let ruleWithVariant = fn(api);
                if (localFormatStrings.length > 0) {
                  formatStrings.push(localFormatStrings);
                }
                if (Array.isArray(ruleWithVariant)) {
                  for (let variantFunction of ruleWithVariant) {
                    localFormatStrings = [];
                    variantFunction(api);
                    formatStrings.push(localFormatStrings);
                  }
                }
              }
              let manualFormatStrings = [];
              let after = container.toString();
              if (before !== after) {
                container.walkRules((rule2) => {
                  let modified = rule2.selector;
                  let rebuiltBase = (0, _postcssselectorparser.default)((selectors) => {
                    selectors.walkClasses((classNode) => {
                      classNode.value = `${name}${context.tailwindConfig.separator}${classNode.value}`;
                    });
                  }).processSync(modified);
                  manualFormatStrings.push(modified.replace(rebuiltBase, "&").replace(candidate, "&"));
                });
                container.walkAtRules((atrule) => {
                  manualFormatStrings.push(`@${atrule.name} (${atrule.params}) { & }`);
                });
              }
              var _options_values1;
              let isArbitraryVariant = !(value2 in ((_options_values1 = options.values) !== null && _options_values1 !== void 0 ? _options_values1 : {}));
              var _options_INTERNAL_FEATURES;
              let internalFeatures = (_options_INTERNAL_FEATURES = options[INTERNAL_FEATURES]) !== null && _options_INTERNAL_FEATURES !== void 0 ? _options_INTERNAL_FEATURES : {};
              let respectPrefix = (() => {
                if (isArbitraryVariant)
                  return false;
                if (internalFeatures.respectPrefix === false)
                  return false;
                return true;
              })();
              formatStrings = formatStrings.map((format) => format.map((str) => ({
                format: str,
                respectPrefix
              })));
              manualFormatStrings = manualFormatStrings.map((format) => ({
                format,
                respectPrefix
              }));
              let opts = {
                candidate,
                context
              };
              let result2 = formatStrings.map((formats) => (0, _formatVariantSelector.finalizeSelector)(`.${candidate}`, (0, _formatVariantSelector.formatVariantSelector)(formats, opts), opts).replace(`.${candidate}`, "&").replace("{ & }", "").trim());
              if (manualFormatStrings.length > 0) {
                result2.push((0, _formatVariantSelector.formatVariantSelector)(manualFormatStrings, opts).toString().replace(`.${candidate}`, "&"));
              }
              return result2;
            }
          });
        }
        return result;
      };
    }
    function markInvalidUtilityCandidate(context, candidate) {
      if (!context.classCache.has(candidate)) {
        return;
      }
      context.notClassCache.add(candidate);
      context.classCache.delete(candidate);
      context.applyClassCache.delete(candidate);
      context.candidateRuleMap.delete(candidate);
      context.candidateRuleCache.delete(candidate);
      context.stylesheetCache = null;
    }
    function markInvalidUtilityNode(context, node) {
      let candidate = node.raws.tailwind.candidate;
      if (!candidate) {
        return;
      }
      for (const entry of context.ruleCache) {
        if (entry[1].raws.tailwind.candidate === candidate) {
          context.ruleCache.delete(entry);
        }
      }
      markInvalidUtilityCandidate(context, candidate);
    }
    function createContext(tailwindConfig, changedContent = [], root = _postcss.default.root()) {
      var _tailwindConfig_blocklist;
      let context = {
        disposables: [],
        ruleCache: /* @__PURE__ */ new Set(),
        candidateRuleCache: /* @__PURE__ */ new Map(),
        classCache: /* @__PURE__ */ new Map(),
        applyClassCache: /* @__PURE__ */ new Map(),
        // Seed the not class cache with the blocklist (which is only strings)
        notClassCache: new Set((_tailwindConfig_blocklist = tailwindConfig.blocklist) !== null && _tailwindConfig_blocklist !== void 0 ? _tailwindConfig_blocklist : []),
        postCssNodeCache: /* @__PURE__ */ new Map(),
        candidateRuleMap: /* @__PURE__ */ new Map(),
        tailwindConfig,
        changedContent,
        variantMap: /* @__PURE__ */ new Map(),
        stylesheetCache: null,
        variantOptions: /* @__PURE__ */ new Map(),
        markInvalidUtilityCandidate: (candidate) => markInvalidUtilityCandidate(context, candidate),
        markInvalidUtilityNode: (node) => markInvalidUtilityNode(context, node)
      };
      let resolvedPlugins = resolvePlugins(context, root);
      registerPlugins(resolvedPlugins, context);
      return context;
    }
    var contextMap = _sharedState.contextMap;
    var configContextMap = _sharedState.configContextMap;
    var contextSourcesMap = _sharedState.contextSourcesMap;
    function getContext(root, result, tailwindConfig, userConfigPath, tailwindConfigHash, contextDependencies) {
      let sourcePath = result.opts.from;
      let isConfigFile = userConfigPath !== null;
      _sharedState.env.DEBUG && console.log("Source path:", sourcePath);
      let existingContext;
      if (isConfigFile && contextMap.has(sourcePath)) {
        existingContext = contextMap.get(sourcePath);
      } else if (configContextMap.has(tailwindConfigHash)) {
        let context2 = configContextMap.get(tailwindConfigHash);
        contextSourcesMap.get(context2).add(sourcePath);
        contextMap.set(sourcePath, context2);
        existingContext = context2;
      }
      let cssDidChange = (0, _cacheInvalidation.hasContentChanged)(sourcePath, root);
      if (existingContext) {
        let [contextDependenciesChanged, mtimesToCommit2] = trackModified([
          ...contextDependencies
        ], getFileModifiedMap(existingContext));
        if (!contextDependenciesChanged && !cssDidChange) {
          return [
            existingContext,
            false,
            mtimesToCommit2
          ];
        }
      }
      if (contextMap.has(sourcePath)) {
        let oldContext = contextMap.get(sourcePath);
        if (contextSourcesMap.has(oldContext)) {
          contextSourcesMap.get(oldContext).delete(sourcePath);
          if (contextSourcesMap.get(oldContext).size === 0) {
            contextSourcesMap.delete(oldContext);
            for (let [tailwindConfigHash2, context2] of configContextMap) {
              if (context2 === oldContext) {
                configContextMap.delete(tailwindConfigHash2);
              }
            }
            for (let disposable of oldContext.disposables.splice(0)) {
              disposable(oldContext);
            }
          }
        }
      }
      _sharedState.env.DEBUG && console.log("Setting up new context...");
      let context = createContext(tailwindConfig, [], root);
      Object.assign(context, {
        userConfigPath
      });
      let [, mtimesToCommit] = trackModified([
        ...contextDependencies
      ], getFileModifiedMap(context));
      configContextMap.set(tailwindConfigHash, context);
      contextMap.set(sourcePath, context);
      if (!contextSourcesMap.has(context)) {
        contextSourcesMap.set(context, /* @__PURE__ */ new Set());
      }
      contextSourcesMap.get(context).add(sourcePath);
      return [
        context,
        true,
        mtimesToCommit
      ];
    }
  }
});

// node_modules/tailwindcss/lib/util/parseDependency.js
var require_parseDependency = __commonJS({
  "node_modules/tailwindcss/lib/util/parseDependency.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    Object.defineProperty(exports, "default", {
      enumerable: true,
      get: function() {
        return parseDependency;
      }
    });
    function parseDependency(contentPath) {
      if (contentPath.ignore) {
        return [];
      }
      if (!contentPath.glob) {
        return [
          {
            type: "dependency",
            file: contentPath.base
          }
        ];
      }
      if (process.env.ROLLUP_WATCH === "true") {
        return [
          {
            type: "dependency",
            file: contentPath.base
          }
        ];
      }
      return [
        {
          type: "dir-dependency",
          dir: contentPath.base,
          glob: contentPath.glob
        }
      ];
    }
  }
});

// node_modules/tailwindcss/lib/util/validateConfig.js
var require_validateConfig = __commonJS({
  "node_modules/tailwindcss/lib/util/validateConfig.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    Object.defineProperty(exports, "validateConfig", {
      enumerable: true,
      get: function() {
        return validateConfig;
      }
    });
    var _log = _interop_require_default(require_log());
    function _interop_require_default(obj) {
      return obj && obj.__esModule ? obj : {
        default: obj
      };
    }
    function validateConfig(config) {
      if (config.content.files.length === 0) {
        _log.default.warn("content-problems", [
          "The `content` option in your Tailwind CSS configuration is missing or empty.",
          "Configure your content sources or your generated CSS will be missing styles.",
          "https://tailwindcss.com/docs/content-configuration"
        ]);
      }
      try {
        let plugin = __require("@tailwindcss/line-clamp");
        if (config.plugins.includes(plugin)) {
          _log.default.warn("line-clamp-in-core", [
            "As of Tailwind CSS v3.3, the `@tailwindcss/line-clamp` plugin is now included by default.",
            "Remove it from the `plugins` array in your configuration to eliminate this warning."
          ]);
          config.plugins = config.plugins.filter((p) => p !== plugin);
        }
      } catch {
      }
      return config;
    }
  }
});

// node_modules/is-extglob/index.js
var require_is_extglob = __commonJS({
  "node_modules/is-extglob/index.js"(exports, module) {
    module.exports = function isExtglob(str) {
      if (typeof str !== "string" || str === "") {
        return false;
      }
      var match2;
      while (match2 = /(\\).|([@?!+*]\(.*\))/g.exec(str)) {
        if (match2[2])
          return true;
        str = str.slice(match2.index + match2[0].length);
      }
      return false;
    };
  }
});

// node_modules/is-glob/index.js
var require_is_glob = __commonJS({
  "node_modules/is-glob/index.js"(exports, module) {
    var isExtglob = require_is_extglob();
    var chars = { "{": "}", "(": ")", "[": "]" };
    var strictCheck = function(str) {
      if (str[0] === "!") {
        return true;
      }
      var index = 0;
      var pipeIndex = -2;
      var closeSquareIndex = -2;
      var closeCurlyIndex = -2;
      var closeParenIndex = -2;
      var backSlashIndex = -2;
      while (index < str.length) {
        if (str[index] === "*") {
          return true;
        }
        if (str[index + 1] === "?" && /[\].+)]/.test(str[index])) {
          return true;
        }
        if (closeSquareIndex !== -1 && str[index] === "[" && str[index + 1] !== "]") {
          if (closeSquareIndex < index) {
            closeSquareIndex = str.indexOf("]", index);
          }
          if (closeSquareIndex > index) {
            if (backSlashIndex === -1 || backSlashIndex > closeSquareIndex) {
              return true;
            }
            backSlashIndex = str.indexOf("\\", index);
            if (backSlashIndex === -1 || backSlashIndex > closeSquareIndex) {
              return true;
            }
          }
        }
        if (closeCurlyIndex !== -1 && str[index] === "{" && str[index + 1] !== "}") {
          closeCurlyIndex = str.indexOf("}", index);
          if (closeCurlyIndex > index) {
            backSlashIndex = str.indexOf("\\", index);
            if (backSlashIndex === -1 || backSlashIndex > closeCurlyIndex) {
              return true;
            }
          }
        }
        if (closeParenIndex !== -1 && str[index] === "(" && str[index + 1] === "?" && /[:!=]/.test(str[index + 2]) && str[index + 3] !== ")") {
          closeParenIndex = str.indexOf(")", index);
          if (closeParenIndex > index) {
            backSlashIndex = str.indexOf("\\", index);
            if (backSlashIndex === -1 || backSlashIndex > closeParenIndex) {
              return true;
            }
          }
        }
        if (pipeIndex !== -1 && str[index] === "(" && str[index + 1] !== "|") {
          if (pipeIndex < index) {
            pipeIndex = str.indexOf("|", index);
          }
          if (pipeIndex !== -1 && str[pipeIndex + 1] !== ")") {
            closeParenIndex = str.indexOf(")", pipeIndex);
            if (closeParenIndex > pipeIndex) {
              backSlashIndex = str.indexOf("\\", pipeIndex);
              if (backSlashIndex === -1 || backSlashIndex > closeParenIndex) {
                return true;
              }
            }
          }
        }
        if (str[index] === "\\") {
          var open = str[index + 1];
          index += 2;
          var close = chars[open];
          if (close) {
            var n = str.indexOf(close, index);
            if (n !== -1) {
              index = n + 1;
            }
          }
          if (str[index] === "!") {
            return true;
          }
        } else {
          index++;
        }
      }
      return false;
    };
    var relaxedCheck = function(str) {
      if (str[0] === "!") {
        return true;
      }
      var index = 0;
      while (index < str.length) {
        if (/[*?{}()[\]]/.test(str[index])) {
          return true;
        }
        if (str[index] === "\\") {
          var open = str[index + 1];
          index += 2;
          var close = chars[open];
          if (close) {
            var n = str.indexOf(close, index);
            if (n !== -1) {
              index = n + 1;
            }
          }
          if (str[index] === "!") {
            return true;
          }
        } else {
          index++;
        }
      }
      return false;
    };
    module.exports = function isGlob(str, options) {
      if (typeof str !== "string" || str === "") {
        return false;
      }
      if (isExtglob(str)) {
        return true;
      }
      var check = strictCheck;
      if (options && options.strict === false) {
        check = relaxedCheck;
      }
      return check(str);
    };
  }
});

// node_modules/fast-glob/out/utils/array.js
var require_array = __commonJS({
  "node_modules/fast-glob/out/utils/array.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.splitWhen = exports.flatten = void 0;
    function flatten(items) {
      return items.reduce((collection, item) => [].concat(collection, item), []);
    }
    exports.flatten = flatten;
    function splitWhen(items, predicate) {
      const result = [[]];
      let groupIndex = 0;
      for (const item of items) {
        if (predicate(item)) {
          groupIndex++;
          result[groupIndex] = [];
        } else {
          result[groupIndex].push(item);
        }
      }
      return result;
    }
    exports.splitWhen = splitWhen;
  }
});

// node_modules/fast-glob/out/utils/errno.js
var require_errno = __commonJS({
  "node_modules/fast-glob/out/utils/errno.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.isEnoentCodeError = void 0;
    function isEnoentCodeError(error) {
      return error.code === "ENOENT";
    }
    exports.isEnoentCodeError = isEnoentCodeError;
  }
});

// node_modules/fast-glob/out/utils/fs.js
var require_fs2 = __commonJS({
  "node_modules/fast-glob/out/utils/fs.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.createDirentFromStats = void 0;
    var DirentFromStats = class {
      constructor(name, stats) {
        this.name = name;
        this.isBlockDevice = stats.isBlockDevice.bind(stats);
        this.isCharacterDevice = stats.isCharacterDevice.bind(stats);
        this.isDirectory = stats.isDirectory.bind(stats);
        this.isFIFO = stats.isFIFO.bind(stats);
        this.isFile = stats.isFile.bind(stats);
        this.isSocket = stats.isSocket.bind(stats);
        this.isSymbolicLink = stats.isSymbolicLink.bind(stats);
      }
    };
    function createDirentFromStats(name, stats) {
      return new DirentFromStats(name, stats);
    }
    exports.createDirentFromStats = createDirentFromStats;
  }
});

// browser-external:os
var require_os = __commonJS({
  "browser-external:os"(exports, module) {
    module.exports = Object.create(new Proxy({}, {
      get(_, key) {
        if (key !== "__esModule" && key !== "__proto__" && key !== "constructor" && key !== "splice") {
          console.warn(`Module "os" has been externalized for browser compatibility. Cannot access "os.${key}" in client code. See http://vitejs.dev/guide/troubleshooting.html#module-externalized-for-browser-compatibility for more details.`);
        }
      }
    }));
  }
});

// node_modules/fast-glob/out/utils/path.js
var require_path2 = __commonJS({
  "node_modules/fast-glob/out/utils/path.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.convertPosixPathToPattern = exports.convertWindowsPathToPattern = exports.convertPathToPattern = exports.escapePosixPath = exports.escapeWindowsPath = exports.escape = exports.removeLeadingDotSegment = exports.makeAbsolute = exports.unixify = void 0;
    var os = require_os();
    var path = require_path();
    var IS_WINDOWS_PLATFORM = os.platform() === "win32";
    var LEADING_DOT_SEGMENT_CHARACTERS_COUNT = 2;
    var POSIX_UNESCAPED_GLOB_SYMBOLS_RE = /(\\?)([()*?[\]{|}]|^!|[!+@](?=\()|\\(?![!()*+?@[\]{|}]))/g;
    var WINDOWS_UNESCAPED_GLOB_SYMBOLS_RE = /(\\?)([()[\]{}]|^!|[!+@](?=\())/g;
    var DOS_DEVICE_PATH_RE = /^\\\\([.?])/;
    var WINDOWS_BACKSLASHES_RE = /\\(?![!()+@[\]{}])/g;
    function unixify(filepath) {
      return filepath.replace(/\\/g, "/");
    }
    exports.unixify = unixify;
    function makeAbsolute(cwd, filepath) {
      return path.resolve(cwd, filepath);
    }
    exports.makeAbsolute = makeAbsolute;
    function removeLeadingDotSegment(entry) {
      if (entry.charAt(0) === ".") {
        const secondCharactery = entry.charAt(1);
        if (secondCharactery === "/" || secondCharactery === "\\") {
          return entry.slice(LEADING_DOT_SEGMENT_CHARACTERS_COUNT);
        }
      }
      return entry;
    }
    exports.removeLeadingDotSegment = removeLeadingDotSegment;
    exports.escape = IS_WINDOWS_PLATFORM ? escapeWindowsPath : escapePosixPath;
    function escapeWindowsPath(pattern) {
      return pattern.replace(WINDOWS_UNESCAPED_GLOB_SYMBOLS_RE, "\\$2");
    }
    exports.escapeWindowsPath = escapeWindowsPath;
    function escapePosixPath(pattern) {
      return pattern.replace(POSIX_UNESCAPED_GLOB_SYMBOLS_RE, "\\$2");
    }
    exports.escapePosixPath = escapePosixPath;
    exports.convertPathToPattern = IS_WINDOWS_PLATFORM ? convertWindowsPathToPattern : convertPosixPathToPattern;
    function convertWindowsPathToPattern(filepath) {
      return escapeWindowsPath(filepath).replace(DOS_DEVICE_PATH_RE, "//$1").replace(WINDOWS_BACKSLASHES_RE, "/");
    }
    exports.convertWindowsPathToPattern = convertWindowsPathToPattern;
    function convertPosixPathToPattern(filepath) {
      return escapePosixPath(filepath);
    }
    exports.convertPosixPathToPattern = convertPosixPathToPattern;
  }
});

// node_modules/fast-glob/node_modules/glob-parent/index.js
var require_glob_parent = __commonJS({
  "node_modules/fast-glob/node_modules/glob-parent/index.js"(exports, module) {
    "use strict";
    var isGlob = require_is_glob();
    var pathPosixDirname = require_path().posix.dirname;
    var isWin32 = require_os().platform() === "win32";
    var slash = "/";
    var backslash = /\\/g;
    var enclosure = /[\{\[].*[\}\]]$/;
    var globby = /(^|[^\\])([\{\[]|\([^\)]+$)/;
    var escaped = /\\([\!\*\?\|\[\]\(\)\{\}])/g;
    module.exports = function globParent(str, opts) {
      var options = Object.assign({ flipBackslashes: true }, opts);
      if (options.flipBackslashes && isWin32 && str.indexOf(slash) < 0) {
        str = str.replace(backslash, slash);
      }
      if (enclosure.test(str)) {
        str += slash;
      }
      str += "a";
      do {
        str = pathPosixDirname(str);
      } while (isGlob(str) || globby.test(str));
      return str.replace(escaped, "$1");
    };
  }
});

// browser-external:util
var require_util2 = __commonJS({
  "browser-external:util"(exports, module) {
    module.exports = Object.create(new Proxy({}, {
      get(_, key) {
        if (key !== "__esModule" && key !== "__proto__" && key !== "constructor" && key !== "splice") {
          console.warn(`Module "util" has been externalized for browser compatibility. Cannot access "util.${key}" in client code. See http://vitejs.dev/guide/troubleshooting.html#module-externalized-for-browser-compatibility for more details.`);
        }
      }
    }));
  }
});

// node_modules/braces/lib/utils.js
var require_utils = __commonJS({
  "node_modules/braces/lib/utils.js"(exports) {
    "use strict";
    exports.isInteger = (num) => {
      if (typeof num === "number") {
        return Number.isInteger(num);
      }
      if (typeof num === "string" && num.trim() !== "") {
        return Number.isInteger(Number(num));
      }
      return false;
    };
    exports.find = (node, type) => node.nodes.find((node2) => node2.type === type);
    exports.exceedsLimit = (min, max, step = 1, limit) => {
      if (limit === false)
        return false;
      if (!exports.isInteger(min) || !exports.isInteger(max))
        return false;
      return (Number(max) - Number(min)) / Number(step) >= limit;
    };
    exports.escapeNode = (block, n = 0, type) => {
      const node = block.nodes[n];
      if (!node)
        return;
      if (type && node.type === type || node.type === "open" || node.type === "close") {
        if (node.escaped !== true) {
          node.value = "\\" + node.value;
          node.escaped = true;
        }
      }
    };
    exports.encloseBrace = (node) => {
      if (node.type !== "brace")
        return false;
      if (node.commas >> 0 + node.ranges >> 0 === 0) {
        node.invalid = true;
        return true;
      }
      return false;
    };
    exports.isInvalidBrace = (block) => {
      if (block.type !== "brace")
        return false;
      if (block.invalid === true || block.dollar)
        return true;
      if (block.commas >> 0 + block.ranges >> 0 === 0) {
        block.invalid = true;
        return true;
      }
      if (block.open !== true || block.close !== true) {
        block.invalid = true;
        return true;
      }
      return false;
    };
    exports.isOpenOrClose = (node) => {
      if (node.type === "open" || node.type === "close") {
        return true;
      }
      return node.open === true || node.close === true;
    };
    exports.reduce = (nodes) => nodes.reduce((acc, node) => {
      if (node.type === "text")
        acc.push(node.value);
      if (node.type === "range")
        node.type = "text";
      return acc;
    }, []);
    exports.flatten = (...args) => {
      const result = [];
      const flat = (arr) => {
        for (let i = 0; i < arr.length; i++) {
          const ele = arr[i];
          if (Array.isArray(ele)) {
            flat(ele);
            continue;
          }
          if (ele !== void 0) {
            result.push(ele);
          }
        }
        return result;
      };
      flat(args);
      return result;
    };
  }
});

// node_modules/braces/lib/stringify.js
var require_stringify = __commonJS({
  "node_modules/braces/lib/stringify.js"(exports, module) {
    "use strict";
    var utils = require_utils();
    module.exports = (ast, options = {}) => {
      const stringify = (node, parent = {}) => {
        const invalidBlock = options.escapeInvalid && utils.isInvalidBrace(parent);
        const invalidNode = node.invalid === true && options.escapeInvalid === true;
        let output = "";
        if (node.value) {
          if ((invalidBlock || invalidNode) && utils.isOpenOrClose(node)) {
            return "\\" + node.value;
          }
          return node.value;
        }
        if (node.value) {
          return node.value;
        }
        if (node.nodes) {
          for (const child of node.nodes) {
            output += stringify(child);
          }
        }
        return output;
      };
      return stringify(ast);
    };
  }
});

// node_modules/is-number/index.js
var require_is_number = __commonJS({
  "node_modules/is-number/index.js"(exports, module) {
    "use strict";
    module.exports = function(num) {
      if (typeof num === "number") {
        return num - num === 0;
      }
      if (typeof num === "string" && num.trim() !== "") {
        return Number.isFinite ? Number.isFinite(+num) : isFinite(+num);
      }
      return false;
    };
  }
});

// node_modules/to-regex-range/index.js
var require_to_regex_range = __commonJS({
  "node_modules/to-regex-range/index.js"(exports, module) {
    "use strict";
    var isNumber = require_is_number();
    var toRegexRange = (min, max, options) => {
      if (isNumber(min) === false) {
        throw new TypeError("toRegexRange: expected the first argument to be a number");
      }
      if (max === void 0 || min === max) {
        return String(min);
      }
      if (isNumber(max) === false) {
        throw new TypeError("toRegexRange: expected the second argument to be a number.");
      }
      let opts = { relaxZeros: true, ...options };
      if (typeof opts.strictZeros === "boolean") {
        opts.relaxZeros = opts.strictZeros === false;
      }
      let relax = String(opts.relaxZeros);
      let shorthand = String(opts.shorthand);
      let capture = String(opts.capture);
      let wrap = String(opts.wrap);
      let cacheKey = min + ":" + max + "=" + relax + shorthand + capture + wrap;
      if (toRegexRange.cache.hasOwnProperty(cacheKey)) {
        return toRegexRange.cache[cacheKey].result;
      }
      let a = Math.min(min, max);
      let b = Math.max(min, max);
      if (Math.abs(a - b) === 1) {
        let result = min + "|" + max;
        if (opts.capture) {
          return `(${result})`;
        }
        if (opts.wrap === false) {
          return result;
        }
        return `(?:${result})`;
      }
      let isPadded = hasPadding(min) || hasPadding(max);
      let state2 = { min, max, a, b };
      let positives = [];
      let negatives = [];
      if (isPadded) {
        state2.isPadded = isPadded;
        state2.maxLen = String(state2.max).length;
      }
      if (a < 0) {
        let newMin = b < 0 ? Math.abs(b) : 1;
        negatives = splitToPatterns(newMin, Math.abs(a), state2, opts);
        a = state2.a = 0;
      }
      if (b >= 0) {
        positives = splitToPatterns(a, b, state2, opts);
      }
      state2.negatives = negatives;
      state2.positives = positives;
      state2.result = collatePatterns(negatives, positives, opts);
      if (opts.capture === true) {
        state2.result = `(${state2.result})`;
      } else if (opts.wrap !== false && positives.length + negatives.length > 1) {
        state2.result = `(?:${state2.result})`;
      }
      toRegexRange.cache[cacheKey] = state2;
      return state2.result;
    };
    function collatePatterns(neg, pos, options) {
      let onlyNegative = filterPatterns(neg, pos, "-", false, options) || [];
      let onlyPositive = filterPatterns(pos, neg, "", false, options) || [];
      let intersected = filterPatterns(neg, pos, "-?", true, options) || [];
      let subpatterns = onlyNegative.concat(intersected).concat(onlyPositive);
      return subpatterns.join("|");
    }
    function splitToRanges(min, max) {
      let nines = 1;
      let zeros = 1;
      let stop = countNines(min, nines);
      let stops = /* @__PURE__ */ new Set([max]);
      while (min <= stop && stop <= max) {
        stops.add(stop);
        nines += 1;
        stop = countNines(min, nines);
      }
      stop = countZeros(max + 1, zeros) - 1;
      while (min < stop && stop <= max) {
        stops.add(stop);
        zeros += 1;
        stop = countZeros(max + 1, zeros) - 1;
      }
      stops = [...stops];
      stops.sort(compare);
      return stops;
    }
    function rangeToPattern(start, stop, options) {
      if (start === stop) {
        return { pattern: start, count: [], digits: 0 };
      }
      let zipped = zip(start, stop);
      let digits = zipped.length;
      let pattern = "";
      let count = 0;
      for (let i = 0; i < digits; i++) {
        let [startDigit, stopDigit] = zipped[i];
        if (startDigit === stopDigit) {
          pattern += startDigit;
        } else if (startDigit !== "0" || stopDigit !== "9") {
          pattern += toCharacterClass(startDigit, stopDigit, options);
        } else {
          count++;
        }
      }
      if (count) {
        pattern += options.shorthand === true ? "\\d" : "[0-9]";
      }
      return { pattern, count: [count], digits };
    }
    function splitToPatterns(min, max, tok, options) {
      let ranges = splitToRanges(min, max);
      let tokens = [];
      let start = min;
      let prev;
      for (let i = 0; i < ranges.length; i++) {
        let max2 = ranges[i];
        let obj = rangeToPattern(String(start), String(max2), options);
        let zeros = "";
        if (!tok.isPadded && prev && prev.pattern === obj.pattern) {
          if (prev.count.length > 1) {
            prev.count.pop();
          }
          prev.count.push(obj.count[0]);
          prev.string = prev.pattern + toQuantifier(prev.count);
          start = max2 + 1;
          continue;
        }
        if (tok.isPadded) {
          zeros = padZeros(max2, tok, options);
        }
        obj.string = zeros + obj.pattern + toQuantifier(obj.count);
        tokens.push(obj);
        start = max2 + 1;
        prev = obj;
      }
      return tokens;
    }
    function filterPatterns(arr, comparison, prefix, intersection, options) {
      let result = [];
      for (let ele of arr) {
        let { string } = ele;
        if (!intersection && !contains(comparison, "string", string)) {
          result.push(prefix + string);
        }
        if (intersection && contains(comparison, "string", string)) {
          result.push(prefix + string);
        }
      }
      return result;
    }
    function zip(a, b) {
      let arr = [];
      for (let i = 0; i < a.length; i++)
        arr.push([a[i], b[i]]);
      return arr;
    }
    function compare(a, b) {
      return a > b ? 1 : b > a ? -1 : 0;
    }
    function contains(arr, key, val) {
      return arr.some((ele) => ele[key] === val);
    }
    function countNines(min, len) {
      return Number(String(min).slice(0, -len) + "9".repeat(len));
    }
    function countZeros(integer, zeros) {
      return integer - integer % Math.pow(10, zeros);
    }
    function toQuantifier(digits) {
      let [start = 0, stop = ""] = digits;
      if (stop || start > 1) {
        return `{${start + (stop ? "," + stop : "")}}`;
      }
      return "";
    }
    function toCharacterClass(a, b, options) {
      return `[${a}${b - a === 1 ? "" : "-"}${b}]`;
    }
    function hasPadding(str) {
      return /^-?(0+)\d/.test(str);
    }
    function padZeros(value2, tok, options) {
      if (!tok.isPadded) {
        return value2;
      }
      let diff = Math.abs(tok.maxLen - String(value2).length);
      let relax = options.relaxZeros !== false;
      switch (diff) {
        case 0:
          return "";
        case 1:
          return relax ? "0?" : "0";
        case 2:
          return relax ? "0{0,2}" : "00";
        default: {
          return relax ? `0{0,${diff}}` : `0{${diff}}`;
        }
      }
    }
    toRegexRange.cache = {};
    toRegexRange.clearCache = () => toRegexRange.cache = {};
    module.exports = toRegexRange;
  }
});

// node_modules/fill-range/index.js
var require_fill_range = __commonJS({
  "node_modules/fill-range/index.js"(exports, module) {
    "use strict";
    var util = require_util2();
    var toRegexRange = require_to_regex_range();
    var isObject = (val) => val !== null && typeof val === "object" && !Array.isArray(val);
    var transform2 = (toNumber) => {
      return (value2) => toNumber === true ? Number(value2) : String(value2);
    };
    var isValidValue = (value2) => {
      return typeof value2 === "number" || typeof value2 === "string" && value2 !== "";
    };
    var isNumber = (num) => Number.isInteger(+num);
    var zeros = (input2) => {
      let value2 = `${input2}`;
      let index = -1;
      if (value2[0] === "-")
        value2 = value2.slice(1);
      if (value2 === "0")
        return false;
      while (value2[++index] === "0")
        ;
      return index > 0;
    };
    var stringify = (start, end, options) => {
      if (typeof start === "string" || typeof end === "string") {
        return true;
      }
      return options.stringify === true;
    };
    var pad = (input2, maxLength, toNumber) => {
      if (maxLength > 0) {
        let dash = input2[0] === "-" ? "-" : "";
        if (dash)
          input2 = input2.slice(1);
        input2 = dash + input2.padStart(dash ? maxLength - 1 : maxLength, "0");
      }
      if (toNumber === false) {
        return String(input2);
      }
      return input2;
    };
    var toMaxLen = (input2, maxLength) => {
      let negative = input2[0] === "-" ? "-" : "";
      if (negative) {
        input2 = input2.slice(1);
        maxLength--;
      }
      while (input2.length < maxLength)
        input2 = "0" + input2;
      return negative ? "-" + input2 : input2;
    };
    var toSequence = (parts, options, maxLen) => {
      parts.negatives.sort((a, b) => a < b ? -1 : a > b ? 1 : 0);
      parts.positives.sort((a, b) => a < b ? -1 : a > b ? 1 : 0);
      let prefix = options.capture ? "" : "?:";
      let positives = "";
      let negatives = "";
      let result;
      if (parts.positives.length) {
        positives = parts.positives.map((v) => toMaxLen(String(v), maxLen)).join("|");
      }
      if (parts.negatives.length) {
        negatives = `-(${prefix}${parts.negatives.map((v) => toMaxLen(String(v), maxLen)).join("|")})`;
      }
      if (positives && negatives) {
        result = `${positives}|${negatives}`;
      } else {
        result = positives || negatives;
      }
      if (options.wrap) {
        return `(${prefix}${result})`;
      }
      return result;
    };
    var toRange = (a, b, isNumbers, options) => {
      if (isNumbers) {
        return toRegexRange(a, b, { wrap: false, ...options });
      }
      let start = String.fromCharCode(a);
      if (a === b)
        return start;
      let stop = String.fromCharCode(b);
      return `[${start}-${stop}]`;
    };
    var toRegex = (start, end, options) => {
      if (Array.isArray(start)) {
        let wrap = options.wrap === true;
        let prefix = options.capture ? "" : "?:";
        return wrap ? `(${prefix}${start.join("|")})` : start.join("|");
      }
      return toRegexRange(start, end, options);
    };
    var rangeError = (...args) => {
      return new RangeError("Invalid range arguments: " + util.inspect(...args));
    };
    var invalidRange = (start, end, options) => {
      if (options.strictRanges === true)
        throw rangeError([start, end]);
      return [];
    };
    var invalidStep = (step, options) => {
      if (options.strictRanges === true) {
        throw new TypeError(`Expected step "${step}" to be a number`);
      }
      return [];
    };
    var fillNumbers = (start, end, step = 1, options = {}) => {
      let a = Number(start);
      let b = Number(end);
      if (!Number.isInteger(a) || !Number.isInteger(b)) {
        if (options.strictRanges === true)
          throw rangeError([start, end]);
        return [];
      }
      if (a === 0)
        a = 0;
      if (b === 0)
        b = 0;
      let descending = a > b;
      let startString = String(start);
      let endString = String(end);
      let stepString = String(step);
      step = Math.max(Math.abs(step), 1);
      let padded = zeros(startString) || zeros(endString) || zeros(stepString);
      let maxLen = padded ? Math.max(startString.length, endString.length, stepString.length) : 0;
      let toNumber = padded === false && stringify(start, end, options) === false;
      let format = options.transform || transform2(toNumber);
      if (options.toRegex && step === 1) {
        return toRange(toMaxLen(start, maxLen), toMaxLen(end, maxLen), true, options);
      }
      let parts = { negatives: [], positives: [] };
      let push = (num) => parts[num < 0 ? "negatives" : "positives"].push(Math.abs(num));
      let range = [];
      let index = 0;
      while (descending ? a >= b : a <= b) {
        if (options.toRegex === true && step > 1) {
          push(a);
        } else {
          range.push(pad(format(a, index), maxLen, toNumber));
        }
        a = descending ? a - step : a + step;
        index++;
      }
      if (options.toRegex === true) {
        return step > 1 ? toSequence(parts, options, maxLen) : toRegex(range, null, { wrap: false, ...options });
      }
      return range;
    };
    var fillLetters = (start, end, step = 1, options = {}) => {
      if (!isNumber(start) && start.length > 1 || !isNumber(end) && end.length > 1) {
        return invalidRange(start, end, options);
      }
      let format = options.transform || ((val) => String.fromCharCode(val));
      let a = `${start}`.charCodeAt(0);
      let b = `${end}`.charCodeAt(0);
      let descending = a > b;
      let min = Math.min(a, b);
      let max = Math.max(a, b);
      if (options.toRegex && step === 1) {
        return toRange(min, max, false, options);
      }
      let range = [];
      let index = 0;
      while (descending ? a >= b : a <= b) {
        range.push(format(a, index));
        a = descending ? a - step : a + step;
        index++;
      }
      if (options.toRegex === true) {
        return toRegex(range, null, { wrap: false, options });
      }
      return range;
    };
    var fill = (start, end, step, options = {}) => {
      if (end == null && isValidValue(start)) {
        return [start];
      }
      if (!isValidValue(start) || !isValidValue(end)) {
        return invalidRange(start, end, options);
      }
      if (typeof step === "function") {
        return fill(start, end, 1, { transform: step });
      }
      if (isObject(step)) {
        return fill(start, end, 0, step);
      }
      let opts = { ...options };
      if (opts.capture === true)
        opts.wrap = true;
      step = step || opts.step || 1;
      if (!isNumber(step)) {
        if (step != null && !isObject(step))
          return invalidStep(step, opts);
        return fill(start, end, 1, step);
      }
      if (isNumber(start) && isNumber(end)) {
        return fillNumbers(start, end, step, opts);
      }
      return fillLetters(start, end, Math.max(Math.abs(step), 1), opts);
    };
    module.exports = fill;
  }
});

// node_modules/braces/lib/compile.js
var require_compile = __commonJS({
  "node_modules/braces/lib/compile.js"(exports, module) {
    "use strict";
    var fill = require_fill_range();
    var utils = require_utils();
    var compile = (ast, options = {}) => {
      const walk = (node, parent = {}) => {
        const invalidBlock = utils.isInvalidBrace(parent);
        const invalidNode = node.invalid === true && options.escapeInvalid === true;
        const invalid = invalidBlock === true || invalidNode === true;
        const prefix = options.escapeInvalid === true ? "\\" : "";
        let output = "";
        if (node.isOpen === true) {
          return prefix + node.value;
        }
        if (node.isClose === true) {
          console.log("node.isClose", prefix, node.value);
          return prefix + node.value;
        }
        if (node.type === "open") {
          return invalid ? prefix + node.value : "(";
        }
        if (node.type === "close") {
          return invalid ? prefix + node.value : ")";
        }
        if (node.type === "comma") {
          return node.prev.type === "comma" ? "" : invalid ? node.value : "|";
        }
        if (node.value) {
          return node.value;
        }
        if (node.nodes && node.ranges > 0) {
          const args = utils.reduce(node.nodes);
          const range = fill(...args, { ...options, wrap: false, toRegex: true, strictZeros: true });
          if (range.length !== 0) {
            return args.length > 1 && range.length > 1 ? `(${range})` : range;
          }
        }
        if (node.nodes) {
          for (const child of node.nodes) {
            output += walk(child, node);
          }
        }
        return output;
      };
      return walk(ast);
    };
    module.exports = compile;
  }
});

// node_modules/braces/lib/expand.js
var require_expand = __commonJS({
  "node_modules/braces/lib/expand.js"(exports, module) {
    "use strict";
    var fill = require_fill_range();
    var stringify = require_stringify();
    var utils = require_utils();
    var append = (queue = "", stash = "", enclose = false) => {
      const result = [];
      queue = [].concat(queue);
      stash = [].concat(stash);
      if (!stash.length)
        return queue;
      if (!queue.length) {
        return enclose ? utils.flatten(stash).map((ele) => `{${ele}}`) : stash;
      }
      for (const item of queue) {
        if (Array.isArray(item)) {
          for (const value2 of item) {
            result.push(append(value2, stash, enclose));
          }
        } else {
          for (let ele of stash) {
            if (enclose === true && typeof ele === "string")
              ele = `{${ele}}`;
            result.push(Array.isArray(ele) ? append(item, ele, enclose) : item + ele);
          }
        }
      }
      return utils.flatten(result);
    };
    var expand = (ast, options = {}) => {
      const rangeLimit = options.rangeLimit === void 0 ? 1e3 : options.rangeLimit;
      const walk = (node, parent = {}) => {
        node.queue = [];
        let p = parent;
        let q = parent.queue;
        while (p.type !== "brace" && p.type !== "root" && p.parent) {
          p = p.parent;
          q = p.queue;
        }
        if (node.invalid || node.dollar) {
          q.push(append(q.pop(), stringify(node, options)));
          return;
        }
        if (node.type === "brace" && node.invalid !== true && node.nodes.length === 2) {
          q.push(append(q.pop(), ["{}"]));
          return;
        }
        if (node.nodes && node.ranges > 0) {
          const args = utils.reduce(node.nodes);
          if (utils.exceedsLimit(...args, options.step, rangeLimit)) {
            throw new RangeError("expanded array length exceeds range limit. Use options.rangeLimit to increase or disable the limit.");
          }
          let range = fill(...args, options);
          if (range.length === 0) {
            range = stringify(node, options);
          }
          q.push(append(q.pop(), range));
          node.nodes = [];
          return;
        }
        const enclose = utils.encloseBrace(node);
        let queue = node.queue;
        let block = node;
        while (block.type !== "brace" && block.type !== "root" && block.parent) {
          block = block.parent;
          queue = block.queue;
        }
        for (let i = 0; i < node.nodes.length; i++) {
          const child = node.nodes[i];
          if (child.type === "comma" && node.type === "brace") {
            if (i === 1)
              queue.push("");
            queue.push("");
            continue;
          }
          if (child.type === "close") {
            q.push(append(q.pop(), queue, enclose));
            continue;
          }
          if (child.value && child.type !== "open") {
            queue.push(append(queue.pop(), child.value));
            continue;
          }
          if (child.nodes) {
            walk(child, node);
          }
        }
        return queue;
      };
      return utils.flatten(walk(ast));
    };
    module.exports = expand;
  }
});

// node_modules/braces/lib/constants.js
var require_constants = __commonJS({
  "node_modules/braces/lib/constants.js"(exports, module) {
    "use strict";
    module.exports = {
      MAX_LENGTH: 1e4,
      // Digits
      CHAR_0: "0",
      /* 0 */
      CHAR_9: "9",
      /* 9 */
      // Alphabet chars.
      CHAR_UPPERCASE_A: "A",
      /* A */
      CHAR_LOWERCASE_A: "a",
      /* a */
      CHAR_UPPERCASE_Z: "Z",
      /* Z */
      CHAR_LOWERCASE_Z: "z",
      /* z */
      CHAR_LEFT_PARENTHESES: "(",
      /* ( */
      CHAR_RIGHT_PARENTHESES: ")",
      /* ) */
      CHAR_ASTERISK: "*",
      /* * */
      // Non-alphabetic chars.
      CHAR_AMPERSAND: "&",
      /* & */
      CHAR_AT: "@",
      /* @ */
      CHAR_BACKSLASH: "\\",
      /* \ */
      CHAR_BACKTICK: "`",
      /* ` */
      CHAR_CARRIAGE_RETURN: "\r",
      /* \r */
      CHAR_CIRCUMFLEX_ACCENT: "^",
      /* ^ */
      CHAR_COLON: ":",
      /* : */
      CHAR_COMMA: ",",
      /* , */
      CHAR_DOLLAR: "$",
      /* . */
      CHAR_DOT: ".",
      /* . */
      CHAR_DOUBLE_QUOTE: '"',
      /* " */
      CHAR_EQUAL: "=",
      /* = */
      CHAR_EXCLAMATION_MARK: "!",
      /* ! */
      CHAR_FORM_FEED: "\f",
      /* \f */
      CHAR_FORWARD_SLASH: "/",
      /* / */
      CHAR_HASH: "#",
      /* # */
      CHAR_HYPHEN_MINUS: "-",
      /* - */
      CHAR_LEFT_ANGLE_BRACKET: "<",
      /* < */
      CHAR_LEFT_CURLY_BRACE: "{",
      /* { */
      CHAR_LEFT_SQUARE_BRACKET: "[",
      /* [ */
      CHAR_LINE_FEED: "\n",
      /* \n */
      CHAR_NO_BREAK_SPACE: " ",
      /* \u00A0 */
      CHAR_PERCENT: "%",
      /* % */
      CHAR_PLUS: "+",
      /* + */
      CHAR_QUESTION_MARK: "?",
      /* ? */
      CHAR_RIGHT_ANGLE_BRACKET: ">",
      /* > */
      CHAR_RIGHT_CURLY_BRACE: "}",
      /* } */
      CHAR_RIGHT_SQUARE_BRACKET: "]",
      /* ] */
      CHAR_SEMICOLON: ";",
      /* ; */
      CHAR_SINGLE_QUOTE: "'",
      /* ' */
      CHAR_SPACE: " ",
      /*   */
      CHAR_TAB: "	",
      /* \t */
      CHAR_UNDERSCORE: "_",
      /* _ */
      CHAR_VERTICAL_LINE: "|",
      /* | */
      CHAR_ZERO_WIDTH_NOBREAK_SPACE: "\uFEFF"
      /* \uFEFF */
    };
  }
});

// node_modules/braces/lib/parse.js
var require_parse = __commonJS({
  "node_modules/braces/lib/parse.js"(exports, module) {
    "use strict";
    var stringify = require_stringify();
    var {
      MAX_LENGTH,
      CHAR_BACKSLASH,
      /* \ */
      CHAR_BACKTICK,
      /* ` */
      CHAR_COMMA,
      /* , */
      CHAR_DOT,
      /* . */
      CHAR_LEFT_PARENTHESES,
      /* ( */
      CHAR_RIGHT_PARENTHESES,
      /* ) */
      CHAR_LEFT_CURLY_BRACE,
      /* { */
      CHAR_RIGHT_CURLY_BRACE,
      /* } */
      CHAR_LEFT_SQUARE_BRACKET,
      /* [ */
      CHAR_RIGHT_SQUARE_BRACKET,
      /* ] */
      CHAR_DOUBLE_QUOTE,
      /* " */
      CHAR_SINGLE_QUOTE,
      /* ' */
      CHAR_NO_BREAK_SPACE,
      CHAR_ZERO_WIDTH_NOBREAK_SPACE
    } = require_constants();
    var parse2 = (input2, options = {}) => {
      if (typeof input2 !== "string") {
        throw new TypeError("Expected a string");
      }
      const opts = options || {};
      const max = typeof opts.maxLength === "number" ? Math.min(MAX_LENGTH, opts.maxLength) : MAX_LENGTH;
      if (input2.length > max) {
        throw new SyntaxError(`Input length (${input2.length}), exceeds max characters (${max})`);
      }
      const ast = { type: "root", input: input2, nodes: [] };
      const stack = [ast];
      let block = ast;
      let prev = ast;
      let brackets = 0;
      const length = input2.length;
      let index = 0;
      let depth = 0;
      let value2;
      const advance = () => input2[index++];
      const push = (node) => {
        if (node.type === "text" && prev.type === "dot") {
          prev.type = "text";
        }
        if (prev && prev.type === "text" && node.type === "text") {
          prev.value += node.value;
          return;
        }
        block.nodes.push(node);
        node.parent = block;
        node.prev = prev;
        prev = node;
        return node;
      };
      push({ type: "bos" });
      while (index < length) {
        block = stack[stack.length - 1];
        value2 = advance();
        if (value2 === CHAR_ZERO_WIDTH_NOBREAK_SPACE || value2 === CHAR_NO_BREAK_SPACE) {
          continue;
        }
        if (value2 === CHAR_BACKSLASH) {
          push({ type: "text", value: (options.keepEscaping ? value2 : "") + advance() });
          continue;
        }
        if (value2 === CHAR_RIGHT_SQUARE_BRACKET) {
          push({ type: "text", value: "\\" + value2 });
          continue;
        }
        if (value2 === CHAR_LEFT_SQUARE_BRACKET) {
          brackets++;
          let next2;
          while (index < length && (next2 = advance())) {
            value2 += next2;
            if (next2 === CHAR_LEFT_SQUARE_BRACKET) {
              brackets++;
              continue;
            }
            if (next2 === CHAR_BACKSLASH) {
              value2 += advance();
              continue;
            }
            if (next2 === CHAR_RIGHT_SQUARE_BRACKET) {
              brackets--;
              if (brackets === 0) {
                break;
              }
            }
          }
          push({ type: "text", value: value2 });
          continue;
        }
        if (value2 === CHAR_LEFT_PARENTHESES) {
          block = push({ type: "paren", nodes: [] });
          stack.push(block);
          push({ type: "text", value: value2 });
          continue;
        }
        if (value2 === CHAR_RIGHT_PARENTHESES) {
          if (block.type !== "paren") {
            push({ type: "text", value: value2 });
            continue;
          }
          block = stack.pop();
          push({ type: "text", value: value2 });
          block = stack[stack.length - 1];
          continue;
        }
        if (value2 === CHAR_DOUBLE_QUOTE || value2 === CHAR_SINGLE_QUOTE || value2 === CHAR_BACKTICK) {
          const open = value2;
          let next2;
          if (options.keepQuotes !== true) {
            value2 = "";
          }
          while (index < length && (next2 = advance())) {
            if (next2 === CHAR_BACKSLASH) {
              value2 += next2 + advance();
              continue;
            }
            if (next2 === open) {
              if (options.keepQuotes === true)
                value2 += next2;
              break;
            }
            value2 += next2;
          }
          push({ type: "text", value: value2 });
          continue;
        }
        if (value2 === CHAR_LEFT_CURLY_BRACE) {
          depth++;
          const dollar = prev.value && prev.value.slice(-1) === "$" || block.dollar === true;
          const brace = {
            type: "brace",
            open: true,
            close: false,
            dollar,
            depth,
            commas: 0,
            ranges: 0,
            nodes: []
          };
          block = push(brace);
          stack.push(block);
          push({ type: "open", value: value2 });
          continue;
        }
        if (value2 === CHAR_RIGHT_CURLY_BRACE) {
          if (block.type !== "brace") {
            push({ type: "text", value: value2 });
            continue;
          }
          const type = "close";
          block = stack.pop();
          block.close = true;
          push({ type, value: value2 });
          depth--;
          block = stack[stack.length - 1];
          continue;
        }
        if (value2 === CHAR_COMMA && depth > 0) {
          if (block.ranges > 0) {
            block.ranges = 0;
            const open = block.nodes.shift();
            block.nodes = [open, { type: "text", value: stringify(block) }];
          }
          push({ type: "comma", value: value2 });
          block.commas++;
          continue;
        }
        if (value2 === CHAR_DOT && depth > 0 && block.commas === 0) {
          const siblings = block.nodes;
          if (depth === 0 || siblings.length === 0) {
            push({ type: "text", value: value2 });
            continue;
          }
          if (prev.type === "dot") {
            block.range = [];
            prev.value += value2;
            prev.type = "range";
            if (block.nodes.length !== 3 && block.nodes.length !== 5) {
              block.invalid = true;
              block.ranges = 0;
              prev.type = "text";
              continue;
            }
            block.ranges++;
            block.args = [];
            continue;
          }
          if (prev.type === "range") {
            siblings.pop();
            const before = siblings[siblings.length - 1];
            before.value += prev.value + value2;
            prev = before;
            block.ranges--;
            continue;
          }
          push({ type: "dot", value: value2 });
          continue;
        }
        push({ type: "text", value: value2 });
      }
      do {
        block = stack.pop();
        if (block.type !== "root") {
          block.nodes.forEach((node) => {
            if (!node.nodes) {
              if (node.type === "open")
                node.isOpen = true;
              if (node.type === "close")
                node.isClose = true;
              if (!node.nodes)
                node.type = "text";
              node.invalid = true;
            }
          });
          const parent = stack[stack.length - 1];
          const index2 = parent.nodes.indexOf(block);
          parent.nodes.splice(index2, 1, ...block.nodes);
        }
      } while (stack.length > 0);
      push({ type: "eos" });
      return ast;
    };
    module.exports = parse2;
  }
});

// node_modules/braces/index.js
var require_braces = __commonJS({
  "node_modules/braces/index.js"(exports, module) {
    "use strict";
    var stringify = require_stringify();
    var compile = require_compile();
    var expand = require_expand();
    var parse2 = require_parse();
    var braces = (input2, options = {}) => {
      let output = [];
      if (Array.isArray(input2)) {
        for (const pattern of input2) {
          const result = braces.create(pattern, options);
          if (Array.isArray(result)) {
            output.push(...result);
          } else {
            output.push(result);
          }
        }
      } else {
        output = [].concat(braces.create(input2, options));
      }
      if (options && options.expand === true && options.nodupes === true) {
        output = [...new Set(output)];
      }
      return output;
    };
    braces.parse = (input2, options = {}) => parse2(input2, options);
    braces.stringify = (input2, options = {}) => {
      if (typeof input2 === "string") {
        return stringify(braces.parse(input2, options), options);
      }
      return stringify(input2, options);
    };
    braces.compile = (input2, options = {}) => {
      if (typeof input2 === "string") {
        input2 = braces.parse(input2, options);
      }
      return compile(input2, options);
    };
    braces.expand = (input2, options = {}) => {
      if (typeof input2 === "string") {
        input2 = braces.parse(input2, options);
      }
      let result = expand(input2, options);
      if (options.noempty === true) {
        result = result.filter(Boolean);
      }
      if (options.nodupes === true) {
        result = [...new Set(result)];
      }
      return result;
    };
    braces.create = (input2, options = {}) => {
      if (input2 === "" || input2.length < 3) {
        return [input2];
      }
      return options.expand !== true ? braces.compile(input2, options) : braces.expand(input2, options);
    };
    module.exports = braces;
  }
});

// node_modules/picomatch/lib/constants.js
var require_constants2 = __commonJS({
  "node_modules/picomatch/lib/constants.js"(exports, module) {
    "use strict";
    var path = require_path();
    var WIN_SLASH = "\\\\/";
    var WIN_NO_SLASH = `[^${WIN_SLASH}]`;
    var DOT_LITERAL = "\\.";
    var PLUS_LITERAL = "\\+";
    var QMARK_LITERAL = "\\?";
    var SLASH_LITERAL = "\\/";
    var ONE_CHAR = "(?=.)";
    var QMARK = "[^/]";
    var END_ANCHOR = `(?:${SLASH_LITERAL}|$)`;
    var START_ANCHOR = `(?:^|${SLASH_LITERAL})`;
    var DOTS_SLASH = `${DOT_LITERAL}{1,2}${END_ANCHOR}`;
    var NO_DOT = `(?!${DOT_LITERAL})`;
    var NO_DOTS = `(?!${START_ANCHOR}${DOTS_SLASH})`;
    var NO_DOT_SLASH = `(?!${DOT_LITERAL}{0,1}${END_ANCHOR})`;
    var NO_DOTS_SLASH = `(?!${DOTS_SLASH})`;
    var QMARK_NO_DOT = `[^.${SLASH_LITERAL}]`;
    var STAR = `${QMARK}*?`;
    var POSIX_CHARS = {
      DOT_LITERAL,
      PLUS_LITERAL,
      QMARK_LITERAL,
      SLASH_LITERAL,
      ONE_CHAR,
      QMARK,
      END_ANCHOR,
      DOTS_SLASH,
      NO_DOT,
      NO_DOTS,
      NO_DOT_SLASH,
      NO_DOTS_SLASH,
      QMARK_NO_DOT,
      STAR,
      START_ANCHOR
    };
    var WINDOWS_CHARS = {
      ...POSIX_CHARS,
      SLASH_LITERAL: `[${WIN_SLASH}]`,
      QMARK: WIN_NO_SLASH,
      STAR: `${WIN_NO_SLASH}*?`,
      DOTS_SLASH: `${DOT_LITERAL}{1,2}(?:[${WIN_SLASH}]|$)`,
      NO_DOT: `(?!${DOT_LITERAL})`,
      NO_DOTS: `(?!(?:^|[${WIN_SLASH}])${DOT_LITERAL}{1,2}(?:[${WIN_SLASH}]|$))`,
      NO_DOT_SLASH: `(?!${DOT_LITERAL}{0,1}(?:[${WIN_SLASH}]|$))`,
      NO_DOTS_SLASH: `(?!${DOT_LITERAL}{1,2}(?:[${WIN_SLASH}]|$))`,
      QMARK_NO_DOT: `[^.${WIN_SLASH}]`,
      START_ANCHOR: `(?:^|[${WIN_SLASH}])`,
      END_ANCHOR: `(?:[${WIN_SLASH}]|$)`
    };
    var POSIX_REGEX_SOURCE = {
      alnum: "a-zA-Z0-9",
      alpha: "a-zA-Z",
      ascii: "\\x00-\\x7F",
      blank: " \\t",
      cntrl: "\\x00-\\x1F\\x7F",
      digit: "0-9",
      graph: "\\x21-\\x7E",
      lower: "a-z",
      print: "\\x20-\\x7E ",
      punct: "\\-!\"#$%&'()\\*+,./:;<=>?@[\\]^_`{|}~",
      space: " \\t\\r\\n\\v\\f",
      upper: "A-Z",
      word: "A-Za-z0-9_",
      xdigit: "A-Fa-f0-9"
    };
    module.exports = {
      MAX_LENGTH: 1024 * 64,
      POSIX_REGEX_SOURCE,
      // regular expressions
      REGEX_BACKSLASH: /\\(?![*+?^${}(|)[\]])/g,
      REGEX_NON_SPECIAL_CHARS: /^[^@![\].,$*+?^{}()|\\/]+/,
      REGEX_SPECIAL_CHARS: /[-*+?.^${}(|)[\]]/,
      REGEX_SPECIAL_CHARS_BACKREF: /(\\?)((\W)(\3*))/g,
      REGEX_SPECIAL_CHARS_GLOBAL: /([-*+?.^${}(|)[\]])/g,
      REGEX_REMOVE_BACKSLASH: /(?:\[.*?[^\\]\]|\\(?=.))/g,
      // Replace globs with equivalent patterns to reduce parsing time.
      REPLACEMENTS: {
        "***": "*",
        "**/**": "**",
        "**/**/**": "**"
      },
      // Digits
      CHAR_0: 48,
      /* 0 */
      CHAR_9: 57,
      /* 9 */
      // Alphabet chars.
      CHAR_UPPERCASE_A: 65,
      /* A */
      CHAR_LOWERCASE_A: 97,
      /* a */
      CHAR_UPPERCASE_Z: 90,
      /* Z */
      CHAR_LOWERCASE_Z: 122,
      /* z */
      CHAR_LEFT_PARENTHESES: 40,
      /* ( */
      CHAR_RIGHT_PARENTHESES: 41,
      /* ) */
      CHAR_ASTERISK: 42,
      /* * */
      // Non-alphabetic chars.
      CHAR_AMPERSAND: 38,
      /* & */
      CHAR_AT: 64,
      /* @ */
      CHAR_BACKWARD_SLASH: 92,
      /* \ */
      CHAR_CARRIAGE_RETURN: 13,
      /* \r */
      CHAR_CIRCUMFLEX_ACCENT: 94,
      /* ^ */
      CHAR_COLON: 58,
      /* : */
      CHAR_COMMA: 44,
      /* , */
      CHAR_DOT: 46,
      /* . */
      CHAR_DOUBLE_QUOTE: 34,
      /* " */
      CHAR_EQUAL: 61,
      /* = */
      CHAR_EXCLAMATION_MARK: 33,
      /* ! */
      CHAR_FORM_FEED: 12,
      /* \f */
      CHAR_FORWARD_SLASH: 47,
      /* / */
      CHAR_GRAVE_ACCENT: 96,
      /* ` */
      CHAR_HASH: 35,
      /* # */
      CHAR_HYPHEN_MINUS: 45,
      /* - */
      CHAR_LEFT_ANGLE_BRACKET: 60,
      /* < */
      CHAR_LEFT_CURLY_BRACE: 123,
      /* { */
      CHAR_LEFT_SQUARE_BRACKET: 91,
      /* [ */
      CHAR_LINE_FEED: 10,
      /* \n */
      CHAR_NO_BREAK_SPACE: 160,
      /* \u00A0 */
      CHAR_PERCENT: 37,
      /* % */
      CHAR_PLUS: 43,
      /* + */
      CHAR_QUESTION_MARK: 63,
      /* ? */
      CHAR_RIGHT_ANGLE_BRACKET: 62,
      /* > */
      CHAR_RIGHT_CURLY_BRACE: 125,
      /* } */
      CHAR_RIGHT_SQUARE_BRACKET: 93,
      /* ] */
      CHAR_SEMICOLON: 59,
      /* ; */
      CHAR_SINGLE_QUOTE: 39,
      /* ' */
      CHAR_SPACE: 32,
      /*   */
      CHAR_TAB: 9,
      /* \t */
      CHAR_UNDERSCORE: 95,
      /* _ */
      CHAR_VERTICAL_LINE: 124,
      /* | */
      CHAR_ZERO_WIDTH_NOBREAK_SPACE: 65279,
      /* \uFEFF */
      SEP: path.sep,
      /**
       * Create EXTGLOB_CHARS
       */
      extglobChars(chars) {
        return {
          "!": { type: "negate", open: "(?:(?!(?:", close: `))${chars.STAR})` },
          "?": { type: "qmark", open: "(?:", close: ")?" },
          "+": { type: "plus", open: "(?:", close: ")+" },
          "*": { type: "star", open: "(?:", close: ")*" },
          "@": { type: "at", open: "(?:", close: ")" }
        };
      },
      /**
       * Create GLOB_CHARS
       */
      globChars(win32) {
        return win32 === true ? WINDOWS_CHARS : POSIX_CHARS;
      }
    };
  }
});

// node_modules/picomatch/lib/utils.js
var require_utils2 = __commonJS({
  "node_modules/picomatch/lib/utils.js"(exports) {
    "use strict";
    var path = require_path();
    var win32 = process.platform === "win32";
    var {
      REGEX_BACKSLASH,
      REGEX_REMOVE_BACKSLASH,
      REGEX_SPECIAL_CHARS,
      REGEX_SPECIAL_CHARS_GLOBAL
    } = require_constants2();
    exports.isObject = (val) => val !== null && typeof val === "object" && !Array.isArray(val);
    exports.hasRegexChars = (str) => REGEX_SPECIAL_CHARS.test(str);
    exports.isRegexChar = (str) => str.length === 1 && exports.hasRegexChars(str);
    exports.escapeRegex = (str) => str.replace(REGEX_SPECIAL_CHARS_GLOBAL, "\\$1");
    exports.toPosixSlashes = (str) => str.replace(REGEX_BACKSLASH, "/");
    exports.removeBackslashes = (str) => {
      return str.replace(REGEX_REMOVE_BACKSLASH, (match2) => {
        return match2 === "\\" ? "" : match2;
      });
    };
    exports.supportsLookbehinds = () => {
      const segs = process.version.slice(1).split(".").map(Number);
      if (segs.length === 3 && segs[0] >= 9 || segs[0] === 8 && segs[1] >= 10) {
        return true;
      }
      return false;
    };
    exports.isWindows = (options) => {
      if (options && typeof options.windows === "boolean") {
        return options.windows;
      }
      return win32 === true || path.sep === "\\";
    };
    exports.escapeLast = (input2, char, lastIdx) => {
      const idx = input2.lastIndexOf(char, lastIdx);
      if (idx === -1)
        return input2;
      if (input2[idx - 1] === "\\")
        return exports.escapeLast(input2, char, idx - 1);
      return `${input2.slice(0, idx)}\\${input2.slice(idx)}`;
    };
    exports.removePrefix = (input2, state2 = {}) => {
      let output = input2;
      if (output.startsWith("./")) {
        output = output.slice(2);
        state2.prefix = "./";
      }
      return output;
    };
    exports.wrapOutput = (input2, state2 = {}, options = {}) => {
      const prepend = options.contains ? "" : "^";
      const append = options.contains ? "" : "$";
      let output = `${prepend}(?:${input2})${append}`;
      if (state2.negated === true) {
        output = `(?:^(?!${output}).*$)`;
      }
      return output;
    };
  }
});

// node_modules/picomatch/lib/scan.js
var require_scan = __commonJS({
  "node_modules/picomatch/lib/scan.js"(exports, module) {
    "use strict";
    var utils = require_utils2();
    var {
      CHAR_ASTERISK,
      /* * */
      CHAR_AT,
      /* @ */
      CHAR_BACKWARD_SLASH,
      /* \ */
      CHAR_COMMA,
      /* , */
      CHAR_DOT,
      /* . */
      CHAR_EXCLAMATION_MARK,
      /* ! */
      CHAR_FORWARD_SLASH,
      /* / */
      CHAR_LEFT_CURLY_BRACE,
      /* { */
      CHAR_LEFT_PARENTHESES,
      /* ( */
      CHAR_LEFT_SQUARE_BRACKET,
      /* [ */
      CHAR_PLUS,
      /* + */
      CHAR_QUESTION_MARK,
      /* ? */
      CHAR_RIGHT_CURLY_BRACE,
      /* } */
      CHAR_RIGHT_PARENTHESES,
      /* ) */
      CHAR_RIGHT_SQUARE_BRACKET
      /* ] */
    } = require_constants2();
    var isPathSeparator = (code) => {
      return code === CHAR_FORWARD_SLASH || code === CHAR_BACKWARD_SLASH;
    };
    var depth = (token) => {
      if (token.isPrefix !== true) {
        token.depth = token.isGlobstar ? Infinity : 1;
      }
    };
    var scan = (input2, options) => {
      const opts = options || {};
      const length = input2.length - 1;
      const scanToEnd = opts.parts === true || opts.scanToEnd === true;
      const slashes = [];
      const tokens = [];
      const parts = [];
      let str = input2;
      let index = -1;
      let start = 0;
      let lastIndex = 0;
      let isBrace = false;
      let isBracket = false;
      let isGlob = false;
      let isExtglob = false;
      let isGlobstar = false;
      let braceEscaped = false;
      let backslashes = false;
      let negated = false;
      let negatedExtglob = false;
      let finished = false;
      let braces = 0;
      let prev;
      let code;
      let token = { value: "", depth: 0, isGlob: false };
      const eos = () => index >= length;
      const peek = () => str.charCodeAt(index + 1);
      const advance = () => {
        prev = code;
        return str.charCodeAt(++index);
      };
      while (index < length) {
        code = advance();
        let next2;
        if (code === CHAR_BACKWARD_SLASH) {
          backslashes = token.backslashes = true;
          code = advance();
          if (code === CHAR_LEFT_CURLY_BRACE) {
            braceEscaped = true;
          }
          continue;
        }
        if (braceEscaped === true || code === CHAR_LEFT_CURLY_BRACE) {
          braces++;
          while (eos() !== true && (code = advance())) {
            if (code === CHAR_BACKWARD_SLASH) {
              backslashes = token.backslashes = true;
              advance();
              continue;
            }
            if (code === CHAR_LEFT_CURLY_BRACE) {
              braces++;
              continue;
            }
            if (braceEscaped !== true && code === CHAR_DOT && (code = advance()) === CHAR_DOT) {
              isBrace = token.isBrace = true;
              isGlob = token.isGlob = true;
              finished = true;
              if (scanToEnd === true) {
                continue;
              }
              break;
            }
            if (braceEscaped !== true && code === CHAR_COMMA) {
              isBrace = token.isBrace = true;
              isGlob = token.isGlob = true;
              finished = true;
              if (scanToEnd === true) {
                continue;
              }
              break;
            }
            if (code === CHAR_RIGHT_CURLY_BRACE) {
              braces--;
              if (braces === 0) {
                braceEscaped = false;
                isBrace = token.isBrace = true;
                finished = true;
                break;
              }
            }
          }
          if (scanToEnd === true) {
            continue;
          }
          break;
        }
        if (code === CHAR_FORWARD_SLASH) {
          slashes.push(index);
          tokens.push(token);
          token = { value: "", depth: 0, isGlob: false };
          if (finished === true)
            continue;
          if (prev === CHAR_DOT && index === start + 1) {
            start += 2;
            continue;
          }
          lastIndex = index + 1;
          continue;
        }
        if (opts.noext !== true) {
          const isExtglobChar = code === CHAR_PLUS || code === CHAR_AT || code === CHAR_ASTERISK || code === CHAR_QUESTION_MARK || code === CHAR_EXCLAMATION_MARK;
          if (isExtglobChar === true && peek() === CHAR_LEFT_PARENTHESES) {
            isGlob = token.isGlob = true;
            isExtglob = token.isExtglob = true;
            finished = true;
            if (code === CHAR_EXCLAMATION_MARK && index === start) {
              negatedExtglob = true;
            }
            if (scanToEnd === true) {
              while (eos() !== true && (code = advance())) {
                if (code === CHAR_BACKWARD_SLASH) {
                  backslashes = token.backslashes = true;
                  code = advance();
                  continue;
                }
                if (code === CHAR_RIGHT_PARENTHESES) {
                  isGlob = token.isGlob = true;
                  finished = true;
                  break;
                }
              }
              continue;
            }
            break;
          }
        }
        if (code === CHAR_ASTERISK) {
          if (prev === CHAR_ASTERISK)
            isGlobstar = token.isGlobstar = true;
          isGlob = token.isGlob = true;
          finished = true;
          if (scanToEnd === true) {
            continue;
          }
          break;
        }
        if (code === CHAR_QUESTION_MARK) {
          isGlob = token.isGlob = true;
          finished = true;
          if (scanToEnd === true) {
            continue;
          }
          break;
        }
        if (code === CHAR_LEFT_SQUARE_BRACKET) {
          while (eos() !== true && (next2 = advance())) {
            if (next2 === CHAR_BACKWARD_SLASH) {
              backslashes = token.backslashes = true;
              advance();
              continue;
            }
            if (next2 === CHAR_RIGHT_SQUARE_BRACKET) {
              isBracket = token.isBracket = true;
              isGlob = token.isGlob = true;
              finished = true;
              break;
            }
          }
          if (scanToEnd === true) {
            continue;
          }
          break;
        }
        if (opts.nonegate !== true && code === CHAR_EXCLAMATION_MARK && index === start) {
          negated = token.negated = true;
          start++;
          continue;
        }
        if (opts.noparen !== true && code === CHAR_LEFT_PARENTHESES) {
          isGlob = token.isGlob = true;
          if (scanToEnd === true) {
            while (eos() !== true && (code = advance())) {
              if (code === CHAR_LEFT_PARENTHESES) {
                backslashes = token.backslashes = true;
                code = advance();
                continue;
              }
              if (code === CHAR_RIGHT_PARENTHESES) {
                finished = true;
                break;
              }
            }
            continue;
          }
          break;
        }
        if (isGlob === true) {
          finished = true;
          if (scanToEnd === true) {
            continue;
          }
          break;
        }
      }
      if (opts.noext === true) {
        isExtglob = false;
        isGlob = false;
      }
      let base = str;
      let prefix = "";
      let glob = "";
      if (start > 0) {
        prefix = str.slice(0, start);
        str = str.slice(start);
        lastIndex -= start;
      }
      if (base && isGlob === true && lastIndex > 0) {
        base = str.slice(0, lastIndex);
        glob = str.slice(lastIndex);
      } else if (isGlob === true) {
        base = "";
        glob = str;
      } else {
        base = str;
      }
      if (base && base !== "" && base !== "/" && base !== str) {
        if (isPathSeparator(base.charCodeAt(base.length - 1))) {
          base = base.slice(0, -1);
        }
      }
      if (opts.unescape === true) {
        if (glob)
          glob = utils.removeBackslashes(glob);
        if (base && backslashes === true) {
          base = utils.removeBackslashes(base);
        }
      }
      const state2 = {
        prefix,
        input: input2,
        start,
        base,
        glob,
        isBrace,
        isBracket,
        isGlob,
        isExtglob,
        isGlobstar,
        negated,
        negatedExtglob
      };
      if (opts.tokens === true) {
        state2.maxDepth = 0;
        if (!isPathSeparator(code)) {
          tokens.push(token);
        }
        state2.tokens = tokens;
      }
      if (opts.parts === true || opts.tokens === true) {
        let prevIndex;
        for (let idx = 0; idx < slashes.length; idx++) {
          const n = prevIndex ? prevIndex + 1 : start;
          const i = slashes[idx];
          const value2 = input2.slice(n, i);
          if (opts.tokens) {
            if (idx === 0 && start !== 0) {
              tokens[idx].isPrefix = true;
              tokens[idx].value = prefix;
            } else {
              tokens[idx].value = value2;
            }
            depth(tokens[idx]);
            state2.maxDepth += tokens[idx].depth;
          }
          if (idx !== 0 || value2 !== "") {
            parts.push(value2);
          }
          prevIndex = i;
        }
        if (prevIndex && prevIndex + 1 < input2.length) {
          const value2 = input2.slice(prevIndex + 1);
          parts.push(value2);
          if (opts.tokens) {
            tokens[tokens.length - 1].value = value2;
            depth(tokens[tokens.length - 1]);
            state2.maxDepth += tokens[tokens.length - 1].depth;
          }
        }
        state2.slashes = slashes;
        state2.parts = parts;
      }
      return state2;
    };
    module.exports = scan;
  }
});

// node_modules/picomatch/lib/parse.js
var require_parse2 = __commonJS({
  "node_modules/picomatch/lib/parse.js"(exports, module) {
    "use strict";
    var constants = require_constants2();
    var utils = require_utils2();
    var {
      MAX_LENGTH,
      POSIX_REGEX_SOURCE,
      REGEX_NON_SPECIAL_CHARS,
      REGEX_SPECIAL_CHARS_BACKREF,
      REPLACEMENTS
    } = constants;
    var expandRange = (args, options) => {
      if (typeof options.expandRange === "function") {
        return options.expandRange(...args, options);
      }
      args.sort();
      const value2 = `[${args.join("-")}]`;
      try {
        new RegExp(value2);
      } catch (ex) {
        return args.map((v) => utils.escapeRegex(v)).join("..");
      }
      return value2;
    };
    var syntaxError = (type, char) => {
      return `Missing ${type}: "${char}" - use "\\\\${char}" to match literal characters`;
    };
    var parse2 = (input2, options) => {
      if (typeof input2 !== "string") {
        throw new TypeError("Expected a string");
      }
      input2 = REPLACEMENTS[input2] || input2;
      const opts = { ...options };
      const max = typeof opts.maxLength === "number" ? Math.min(MAX_LENGTH, opts.maxLength) : MAX_LENGTH;
      let len = input2.length;
      if (len > max) {
        throw new SyntaxError(`Input length: ${len}, exceeds maximum allowed length: ${max}`);
      }
      const bos = { type: "bos", value: "", output: opts.prepend || "" };
      const tokens = [bos];
      const capture = opts.capture ? "" : "?:";
      const win32 = utils.isWindows(options);
      const PLATFORM_CHARS = constants.globChars(win32);
      const EXTGLOB_CHARS = constants.extglobChars(PLATFORM_CHARS);
      const {
        DOT_LITERAL,
        PLUS_LITERAL,
        SLASH_LITERAL,
        ONE_CHAR,
        DOTS_SLASH,
        NO_DOT,
        NO_DOT_SLASH,
        NO_DOTS_SLASH,
        QMARK,
        QMARK_NO_DOT,
        STAR,
        START_ANCHOR
      } = PLATFORM_CHARS;
      const globstar = (opts2) => {
        return `(${capture}(?:(?!${START_ANCHOR}${opts2.dot ? DOTS_SLASH : DOT_LITERAL}).)*?)`;
      };
      const nodot = opts.dot ? "" : NO_DOT;
      const qmarkNoDot = opts.dot ? QMARK : QMARK_NO_DOT;
      let star = opts.bash === true ? globstar(opts) : STAR;
      if (opts.capture) {
        star = `(${star})`;
      }
      if (typeof opts.noext === "boolean") {
        opts.noextglob = opts.noext;
      }
      const state2 = {
        input: input2,
        index: -1,
        start: 0,
        dot: opts.dot === true,
        consumed: "",
        output: "",
        prefix: "",
        backtrack: false,
        negated: false,
        brackets: 0,
        braces: 0,
        parens: 0,
        quotes: 0,
        globstar: false,
        tokens
      };
      input2 = utils.removePrefix(input2, state2);
      len = input2.length;
      const extglobs = [];
      const braces = [];
      const stack = [];
      let prev = bos;
      let value2;
      const eos = () => state2.index === len - 1;
      const peek = state2.peek = (n = 1) => input2[state2.index + n];
      const advance = state2.advance = () => input2[++state2.index] || "";
      const remaining = () => input2.slice(state2.index + 1);
      const consume = (value3 = "", num = 0) => {
        state2.consumed += value3;
        state2.index += num;
      };
      const append = (token) => {
        state2.output += token.output != null ? token.output : token.value;
        consume(token.value);
      };
      const negate = () => {
        let count = 1;
        while (peek() === "!" && (peek(2) !== "(" || peek(3) === "?")) {
          advance();
          state2.start++;
          count++;
        }
        if (count % 2 === 0) {
          return false;
        }
        state2.negated = true;
        state2.start++;
        return true;
      };
      const increment = (type) => {
        state2[type]++;
        stack.push(type);
      };
      const decrement = (type) => {
        state2[type]--;
        stack.pop();
      };
      const push = (tok) => {
        if (prev.type === "globstar") {
          const isBrace = state2.braces > 0 && (tok.type === "comma" || tok.type === "brace");
          const isExtglob = tok.extglob === true || extglobs.length && (tok.type === "pipe" || tok.type === "paren");
          if (tok.type !== "slash" && tok.type !== "paren" && !isBrace && !isExtglob) {
            state2.output = state2.output.slice(0, -prev.output.length);
            prev.type = "star";
            prev.value = "*";
            prev.output = star;
            state2.output += prev.output;
          }
        }
        if (extglobs.length && tok.type !== "paren") {
          extglobs[extglobs.length - 1].inner += tok.value;
        }
        if (tok.value || tok.output)
          append(tok);
        if (prev && prev.type === "text" && tok.type === "text") {
          prev.value += tok.value;
          prev.output = (prev.output || "") + tok.value;
          return;
        }
        tok.prev = prev;
        tokens.push(tok);
        prev = tok;
      };
      const extglobOpen = (type, value3) => {
        const token = { ...EXTGLOB_CHARS[value3], conditions: 1, inner: "" };
        token.prev = prev;
        token.parens = state2.parens;
        token.output = state2.output;
        const output = (opts.capture ? "(" : "") + token.open;
        increment("parens");
        push({ type, value: value3, output: state2.output ? "" : ONE_CHAR });
        push({ type: "paren", extglob: true, value: advance(), output });
        extglobs.push(token);
      };
      const extglobClose = (token) => {
        let output = token.close + (opts.capture ? ")" : "");
        let rest;
        if (token.type === "negate") {
          let extglobStar = star;
          if (token.inner && token.inner.length > 1 && token.inner.includes("/")) {
            extglobStar = globstar(opts);
          }
          if (extglobStar !== star || eos() || /^\)+$/.test(remaining())) {
            output = token.close = `)$))${extglobStar}`;
          }
          if (token.inner.includes("*") && (rest = remaining()) && /^\.[^\\/.]+$/.test(rest)) {
            const expression = parse2(rest, { ...options, fastpaths: false }).output;
            output = token.close = `)${expression})${extglobStar})`;
          }
          if (token.prev.type === "bos") {
            state2.negatedExtglob = true;
          }
        }
        push({ type: "paren", extglob: true, value: value2, output });
        decrement("parens");
      };
      if (opts.fastpaths !== false && !/(^[*!]|[/()[\]{}"])/.test(input2)) {
        let backslashes = false;
        let output = input2.replace(REGEX_SPECIAL_CHARS_BACKREF, (m, esc, chars, first, rest, index) => {
          if (first === "\\") {
            backslashes = true;
            return m;
          }
          if (first === "?") {
            if (esc) {
              return esc + first + (rest ? QMARK.repeat(rest.length) : "");
            }
            if (index === 0) {
              return qmarkNoDot + (rest ? QMARK.repeat(rest.length) : "");
            }
            return QMARK.repeat(chars.length);
          }
          if (first === ".") {
            return DOT_LITERAL.repeat(chars.length);
          }
          if (first === "*") {
            if (esc) {
              return esc + first + (rest ? star : "");
            }
            return star;
          }
          return esc ? m : `\\${m}`;
        });
        if (backslashes === true) {
          if (opts.unescape === true) {
            output = output.replace(/\\/g, "");
          } else {
            output = output.replace(/\\+/g, (m) => {
              return m.length % 2 === 0 ? "\\\\" : m ? "\\" : "";
            });
          }
        }
        if (output === input2 && opts.contains === true) {
          state2.output = input2;
          return state2;
        }
        state2.output = utils.wrapOutput(output, state2, options);
        return state2;
      }
      while (!eos()) {
        value2 = advance();
        if (value2 === "\0") {
          continue;
        }
        if (value2 === "\\") {
          const next2 = peek();
          if (next2 === "/" && opts.bash !== true) {
            continue;
          }
          if (next2 === "." || next2 === ";") {
            continue;
          }
          if (!next2) {
            value2 += "\\";
            push({ type: "text", value: value2 });
            continue;
          }
          const match2 = /^\\+/.exec(remaining());
          let slashes = 0;
          if (match2 && match2[0].length > 2) {
            slashes = match2[0].length;
            state2.index += slashes;
            if (slashes % 2 !== 0) {
              value2 += "\\";
            }
          }
          if (opts.unescape === true) {
            value2 = advance();
          } else {
            value2 += advance();
          }
          if (state2.brackets === 0) {
            push({ type: "text", value: value2 });
            continue;
          }
        }
        if (state2.brackets > 0 && (value2 !== "]" || prev.value === "[" || prev.value === "[^")) {
          if (opts.posix !== false && value2 === ":") {
            const inner = prev.value.slice(1);
            if (inner.includes("[")) {
              prev.posix = true;
              if (inner.includes(":")) {
                const idx = prev.value.lastIndexOf("[");
                const pre = prev.value.slice(0, idx);
                const rest2 = prev.value.slice(idx + 2);
                const posix = POSIX_REGEX_SOURCE[rest2];
                if (posix) {
                  prev.value = pre + posix;
                  state2.backtrack = true;
                  advance();
                  if (!bos.output && tokens.indexOf(prev) === 1) {
                    bos.output = ONE_CHAR;
                  }
                  continue;
                }
              }
            }
          }
          if (value2 === "[" && peek() !== ":" || value2 === "-" && peek() === "]") {
            value2 = `\\${value2}`;
          }
          if (value2 === "]" && (prev.value === "[" || prev.value === "[^")) {
            value2 = `\\${value2}`;
          }
          if (opts.posix === true && value2 === "!" && prev.value === "[") {
            value2 = "^";
          }
          prev.value += value2;
          append({ value: value2 });
          continue;
        }
        if (state2.quotes === 1 && value2 !== '"') {
          value2 = utils.escapeRegex(value2);
          prev.value += value2;
          append({ value: value2 });
          continue;
        }
        if (value2 === '"') {
          state2.quotes = state2.quotes === 1 ? 0 : 1;
          if (opts.keepQuotes === true) {
            push({ type: "text", value: value2 });
          }
          continue;
        }
        if (value2 === "(") {
          increment("parens");
          push({ type: "paren", value: value2 });
          continue;
        }
        if (value2 === ")") {
          if (state2.parens === 0 && opts.strictBrackets === true) {
            throw new SyntaxError(syntaxError("opening", "("));
          }
          const extglob = extglobs[extglobs.length - 1];
          if (extglob && state2.parens === extglob.parens + 1) {
            extglobClose(extglobs.pop());
            continue;
          }
          push({ type: "paren", value: value2, output: state2.parens ? ")" : "\\)" });
          decrement("parens");
          continue;
        }
        if (value2 === "[") {
          if (opts.nobracket === true || !remaining().includes("]")) {
            if (opts.nobracket !== true && opts.strictBrackets === true) {
              throw new SyntaxError(syntaxError("closing", "]"));
            }
            value2 = `\\${value2}`;
          } else {
            increment("brackets");
          }
          push({ type: "bracket", value: value2 });
          continue;
        }
        if (value2 === "]") {
          if (opts.nobracket === true || prev && prev.type === "bracket" && prev.value.length === 1) {
            push({ type: "text", value: value2, output: `\\${value2}` });
            continue;
          }
          if (state2.brackets === 0) {
            if (opts.strictBrackets === true) {
              throw new SyntaxError(syntaxError("opening", "["));
            }
            push({ type: "text", value: value2, output: `\\${value2}` });
            continue;
          }
          decrement("brackets");
          const prevValue = prev.value.slice(1);
          if (prev.posix !== true && prevValue[0] === "^" && !prevValue.includes("/")) {
            value2 = `/${value2}`;
          }
          prev.value += value2;
          append({ value: value2 });
          if (opts.literalBrackets === false || utils.hasRegexChars(prevValue)) {
            continue;
          }
          const escaped = utils.escapeRegex(prev.value);
          state2.output = state2.output.slice(0, -prev.value.length);
          if (opts.literalBrackets === true) {
            state2.output += escaped;
            prev.value = escaped;
            continue;
          }
          prev.value = `(${capture}${escaped}|${prev.value})`;
          state2.output += prev.value;
          continue;
        }
        if (value2 === "{" && opts.nobrace !== true) {
          increment("braces");
          const open = {
            type: "brace",
            value: value2,
            output: "(",
            outputIndex: state2.output.length,
            tokensIndex: state2.tokens.length
          };
          braces.push(open);
          push(open);
          continue;
        }
        if (value2 === "}") {
          const brace = braces[braces.length - 1];
          if (opts.nobrace === true || !brace) {
            push({ type: "text", value: value2, output: value2 });
            continue;
          }
          let output = ")";
          if (brace.dots === true) {
            const arr = tokens.slice();
            const range = [];
            for (let i = arr.length - 1; i >= 0; i--) {
              tokens.pop();
              if (arr[i].type === "brace") {
                break;
              }
              if (arr[i].type !== "dots") {
                range.unshift(arr[i].value);
              }
            }
            output = expandRange(range, opts);
            state2.backtrack = true;
          }
          if (brace.comma !== true && brace.dots !== true) {
            const out = state2.output.slice(0, brace.outputIndex);
            const toks = state2.tokens.slice(brace.tokensIndex);
            brace.value = brace.output = "\\{";
            value2 = output = "\\}";
            state2.output = out;
            for (const t2 of toks) {
              state2.output += t2.output || t2.value;
            }
          }
          push({ type: "brace", value: value2, output });
          decrement("braces");
          braces.pop();
          continue;
        }
        if (value2 === "|") {
          if (extglobs.length > 0) {
            extglobs[extglobs.length - 1].conditions++;
          }
          push({ type: "text", value: value2 });
          continue;
        }
        if (value2 === ",") {
          let output = value2;
          const brace = braces[braces.length - 1];
          if (brace && stack[stack.length - 1] === "braces") {
            brace.comma = true;
            output = "|";
          }
          push({ type: "comma", value: value2, output });
          continue;
        }
        if (value2 === "/") {
          if (prev.type === "dot" && state2.index === state2.start + 1) {
            state2.start = state2.index + 1;
            state2.consumed = "";
            state2.output = "";
            tokens.pop();
            prev = bos;
            continue;
          }
          push({ type: "slash", value: value2, output: SLASH_LITERAL });
          continue;
        }
        if (value2 === ".") {
          if (state2.braces > 0 && prev.type === "dot") {
            if (prev.value === ".")
              prev.output = DOT_LITERAL;
            const brace = braces[braces.length - 1];
            prev.type = "dots";
            prev.output += value2;
            prev.value += value2;
            brace.dots = true;
            continue;
          }
          if (state2.braces + state2.parens === 0 && prev.type !== "bos" && prev.type !== "slash") {
            push({ type: "text", value: value2, output: DOT_LITERAL });
            continue;
          }
          push({ type: "dot", value: value2, output: DOT_LITERAL });
          continue;
        }
        if (value2 === "?") {
          const isGroup = prev && prev.value === "(";
          if (!isGroup && opts.noextglob !== true && peek() === "(" && peek(2) !== "?") {
            extglobOpen("qmark", value2);
            continue;
          }
          if (prev && prev.type === "paren") {
            const next2 = peek();
            let output = value2;
            if (next2 === "<" && !utils.supportsLookbehinds()) {
              throw new Error("Node.js v10 or higher is required for regex lookbehinds");
            }
            if (prev.value === "(" && !/[!=<:]/.test(next2) || next2 === "<" && !/<([!=]|\w+>)/.test(remaining())) {
              output = `\\${value2}`;
            }
            push({ type: "text", value: value2, output });
            continue;
          }
          if (opts.dot !== true && (prev.type === "slash" || prev.type === "bos")) {
            push({ type: "qmark", value: value2, output: QMARK_NO_DOT });
            continue;
          }
          push({ type: "qmark", value: value2, output: QMARK });
          continue;
        }
        if (value2 === "!") {
          if (opts.noextglob !== true && peek() === "(") {
            if (peek(2) !== "?" || !/[!=<:]/.test(peek(3))) {
              extglobOpen("negate", value2);
              continue;
            }
          }
          if (opts.nonegate !== true && state2.index === 0) {
            negate();
            continue;
          }
        }
        if (value2 === "+") {
          if (opts.noextglob !== true && peek() === "(" && peek(2) !== "?") {
            extglobOpen("plus", value2);
            continue;
          }
          if (prev && prev.value === "(" || opts.regex === false) {
            push({ type: "plus", value: value2, output: PLUS_LITERAL });
            continue;
          }
          if (prev && (prev.type === "bracket" || prev.type === "paren" || prev.type === "brace") || state2.parens > 0) {
            push({ type: "plus", value: value2 });
            continue;
          }
          push({ type: "plus", value: PLUS_LITERAL });
          continue;
        }
        if (value2 === "@") {
          if (opts.noextglob !== true && peek() === "(" && peek(2) !== "?") {
            push({ type: "at", extglob: true, value: value2, output: "" });
            continue;
          }
          push({ type: "text", value: value2 });
          continue;
        }
        if (value2 !== "*") {
          if (value2 === "$" || value2 === "^") {
            value2 = `\\${value2}`;
          }
          const match2 = REGEX_NON_SPECIAL_CHARS.exec(remaining());
          if (match2) {
            value2 += match2[0];
            state2.index += match2[0].length;
          }
          push({ type: "text", value: value2 });
          continue;
        }
        if (prev && (prev.type === "globstar" || prev.star === true)) {
          prev.type = "star";
          prev.star = true;
          prev.value += value2;
          prev.output = star;
          state2.backtrack = true;
          state2.globstar = true;
          consume(value2);
          continue;
        }
        let rest = remaining();
        if (opts.noextglob !== true && /^\([^?]/.test(rest)) {
          extglobOpen("star", value2);
          continue;
        }
        if (prev.type === "star") {
          if (opts.noglobstar === true) {
            consume(value2);
            continue;
          }
          const prior = prev.prev;
          const before = prior.prev;
          const isStart = prior.type === "slash" || prior.type === "bos";
          const afterStar = before && (before.type === "star" || before.type === "globstar");
          if (opts.bash === true && (!isStart || rest[0] && rest[0] !== "/")) {
            push({ type: "star", value: value2, output: "" });
            continue;
          }
          const isBrace = state2.braces > 0 && (prior.type === "comma" || prior.type === "brace");
          const isExtglob = extglobs.length && (prior.type === "pipe" || prior.type === "paren");
          if (!isStart && prior.type !== "paren" && !isBrace && !isExtglob) {
            push({ type: "star", value: value2, output: "" });
            continue;
          }
          while (rest.slice(0, 3) === "/**") {
            const after = input2[state2.index + 4];
            if (after && after !== "/") {
              break;
            }
            rest = rest.slice(3);
            consume("/**", 3);
          }
          if (prior.type === "bos" && eos()) {
            prev.type = "globstar";
            prev.value += value2;
            prev.output = globstar(opts);
            state2.output = prev.output;
            state2.globstar = true;
            consume(value2);
            continue;
          }
          if (prior.type === "slash" && prior.prev.type !== "bos" && !afterStar && eos()) {
            state2.output = state2.output.slice(0, -(prior.output + prev.output).length);
            prior.output = `(?:${prior.output}`;
            prev.type = "globstar";
            prev.output = globstar(opts) + (opts.strictSlashes ? ")" : "|$)");
            prev.value += value2;
            state2.globstar = true;
            state2.output += prior.output + prev.output;
            consume(value2);
            continue;
          }
          if (prior.type === "slash" && prior.prev.type !== "bos" && rest[0] === "/") {
            const end = rest[1] !== void 0 ? "|$" : "";
            state2.output = state2.output.slice(0, -(prior.output + prev.output).length);
            prior.output = `(?:${prior.output}`;
            prev.type = "globstar";
            prev.output = `${globstar(opts)}${SLASH_LITERAL}|${SLASH_LITERAL}${end})`;
            prev.value += value2;
            state2.output += prior.output + prev.output;
            state2.globstar = true;
            consume(value2 + advance());
            push({ type: "slash", value: "/", output: "" });
            continue;
          }
          if (prior.type === "bos" && rest[0] === "/") {
            prev.type = "globstar";
            prev.value += value2;
            prev.output = `(?:^|${SLASH_LITERAL}|${globstar(opts)}${SLASH_LITERAL})`;
            state2.output = prev.output;
            state2.globstar = true;
            consume(value2 + advance());
            push({ type: "slash", value: "/", output: "" });
            continue;
          }
          state2.output = state2.output.slice(0, -prev.output.length);
          prev.type = "globstar";
          prev.output = globstar(opts);
          prev.value += value2;
          state2.output += prev.output;
          state2.globstar = true;
          consume(value2);
          continue;
        }
        const token = { type: "star", value: value2, output: star };
        if (opts.bash === true) {
          token.output = ".*?";
          if (prev.type === "bos" || prev.type === "slash") {
            token.output = nodot + token.output;
          }
          push(token);
          continue;
        }
        if (prev && (prev.type === "bracket" || prev.type === "paren") && opts.regex === true) {
          token.output = value2;
          push(token);
          continue;
        }
        if (state2.index === state2.start || prev.type === "slash" || prev.type === "dot") {
          if (prev.type === "dot") {
            state2.output += NO_DOT_SLASH;
            prev.output += NO_DOT_SLASH;
          } else if (opts.dot === true) {
            state2.output += NO_DOTS_SLASH;
            prev.output += NO_DOTS_SLASH;
          } else {
            state2.output += nodot;
            prev.output += nodot;
          }
          if (peek() !== "*") {
            state2.output += ONE_CHAR;
            prev.output += ONE_CHAR;
          }
        }
        push(token);
      }
      while (state2.brackets > 0) {
        if (opts.strictBrackets === true)
          throw new SyntaxError(syntaxError("closing", "]"));
        state2.output = utils.escapeLast(state2.output, "[");
        decrement("brackets");
      }
      while (state2.parens > 0) {
        if (opts.strictBrackets === true)
          throw new SyntaxError(syntaxError("closing", ")"));
        state2.output = utils.escapeLast(state2.output, "(");
        decrement("parens");
      }
      while (state2.braces > 0) {
        if (opts.strictBrackets === true)
          throw new SyntaxError(syntaxError("closing", "}"));
        state2.output = utils.escapeLast(state2.output, "{");
        decrement("braces");
      }
      if (opts.strictSlashes !== true && (prev.type === "star" || prev.type === "bracket")) {
        push({ type: "maybe_slash", value: "", output: `${SLASH_LITERAL}?` });
      }
      if (state2.backtrack === true) {
        state2.output = "";
        for (const token of state2.tokens) {
          state2.output += token.output != null ? token.output : token.value;
          if (token.suffix) {
            state2.output += token.suffix;
          }
        }
      }
      return state2;
    };
    parse2.fastpaths = (input2, options) => {
      const opts = { ...options };
      const max = typeof opts.maxLength === "number" ? Math.min(MAX_LENGTH, opts.maxLength) : MAX_LENGTH;
      const len = input2.length;
      if (len > max) {
        throw new SyntaxError(`Input length: ${len}, exceeds maximum allowed length: ${max}`);
      }
      input2 = REPLACEMENTS[input2] || input2;
      const win32 = utils.isWindows(options);
      const {
        DOT_LITERAL,
        SLASH_LITERAL,
        ONE_CHAR,
        DOTS_SLASH,
        NO_DOT,
        NO_DOTS,
        NO_DOTS_SLASH,
        STAR,
        START_ANCHOR
      } = constants.globChars(win32);
      const nodot = opts.dot ? NO_DOTS : NO_DOT;
      const slashDot = opts.dot ? NO_DOTS_SLASH : NO_DOT;
      const capture = opts.capture ? "" : "?:";
      const state2 = { negated: false, prefix: "" };
      let star = opts.bash === true ? ".*?" : STAR;
      if (opts.capture) {
        star = `(${star})`;
      }
      const globstar = (opts2) => {
        if (opts2.noglobstar === true)
          return star;
        return `(${capture}(?:(?!${START_ANCHOR}${opts2.dot ? DOTS_SLASH : DOT_LITERAL}).)*?)`;
      };
      const create = (str) => {
        switch (str) {
          case "*":
            return `${nodot}${ONE_CHAR}${star}`;
          case ".*":
            return `${DOT_LITERAL}${ONE_CHAR}${star}`;
          case "*.*":
            return `${nodot}${star}${DOT_LITERAL}${ONE_CHAR}${star}`;
          case "*/*":
            return `${nodot}${star}${SLASH_LITERAL}${ONE_CHAR}${slashDot}${star}`;
          case "**":
            return nodot + globstar(opts);
          case "**/*":
            return `(?:${nodot}${globstar(opts)}${SLASH_LITERAL})?${slashDot}${ONE_CHAR}${star}`;
          case "**/*.*":
            return `(?:${nodot}${globstar(opts)}${SLASH_LITERAL})?${slashDot}${star}${DOT_LITERAL}${ONE_CHAR}${star}`;
          case "**/.*":
            return `(?:${nodot}${globstar(opts)}${SLASH_LITERAL})?${DOT_LITERAL}${ONE_CHAR}${star}`;
          default: {
            const match2 = /^(.*?)\.(\w+)$/.exec(str);
            if (!match2)
              return;
            const source2 = create(match2[1]);
            if (!source2)
              return;
            return source2 + DOT_LITERAL + match2[2];
          }
        }
      };
      const output = utils.removePrefix(input2, state2);
      let source = create(output);
      if (source && opts.strictSlashes !== true) {
        source += `${SLASH_LITERAL}?`;
      }
      return source;
    };
    module.exports = parse2;
  }
});

// node_modules/picomatch/lib/picomatch.js
var require_picomatch = __commonJS({
  "node_modules/picomatch/lib/picomatch.js"(exports, module) {
    "use strict";
    var path = require_path();
    var scan = require_scan();
    var parse2 = require_parse2();
    var utils = require_utils2();
    var constants = require_constants2();
    var isObject = (val) => val && typeof val === "object" && !Array.isArray(val);
    var picomatch = (glob, options, returnState = false) => {
      if (Array.isArray(glob)) {
        const fns = glob.map((input2) => picomatch(input2, options, returnState));
        const arrayMatcher = (str) => {
          for (const isMatch of fns) {
            const state3 = isMatch(str);
            if (state3)
              return state3;
          }
          return false;
        };
        return arrayMatcher;
      }
      const isState = isObject(glob) && glob.tokens && glob.input;
      if (glob === "" || typeof glob !== "string" && !isState) {
        throw new TypeError("Expected pattern to be a non-empty string");
      }
      const opts = options || {};
      const posix = utils.isWindows(options);
      const regex = isState ? picomatch.compileRe(glob, options) : picomatch.makeRe(glob, options, false, true);
      const state2 = regex.state;
      delete regex.state;
      let isIgnored = () => false;
      if (opts.ignore) {
        const ignoreOpts = { ...options, ignore: null, onMatch: null, onResult: null };
        isIgnored = picomatch(opts.ignore, ignoreOpts, returnState);
      }
      const matcher = (input2, returnObject = false) => {
        const { isMatch, match: match2, output } = picomatch.test(input2, regex, options, { glob, posix });
        const result = { glob, state: state2, regex, posix, input: input2, output, match: match2, isMatch };
        if (typeof opts.onResult === "function") {
          opts.onResult(result);
        }
        if (isMatch === false) {
          result.isMatch = false;
          return returnObject ? result : false;
        }
        if (isIgnored(input2)) {
          if (typeof opts.onIgnore === "function") {
            opts.onIgnore(result);
          }
          result.isMatch = false;
          return returnObject ? result : false;
        }
        if (typeof opts.onMatch === "function") {
          opts.onMatch(result);
        }
        return returnObject ? result : true;
      };
      if (returnState) {
        matcher.state = state2;
      }
      return matcher;
    };
    picomatch.test = (input2, regex, options, { glob, posix } = {}) => {
      if (typeof input2 !== "string") {
        throw new TypeError("Expected input to be a string");
      }
      if (input2 === "") {
        return { isMatch: false, output: "" };
      }
      const opts = options || {};
      const format = opts.format || (posix ? utils.toPosixSlashes : null);
      let match2 = input2 === glob;
      let output = match2 && format ? format(input2) : input2;
      if (match2 === false) {
        output = format ? format(input2) : input2;
        match2 = output === glob;
      }
      if (match2 === false || opts.capture === true) {
        if (opts.matchBase === true || opts.basename === true) {
          match2 = picomatch.matchBase(input2, regex, options, posix);
        } else {
          match2 = regex.exec(output);
        }
      }
      return { isMatch: Boolean(match2), match: match2, output };
    };
    picomatch.matchBase = (input2, glob, options, posix = utils.isWindows(options)) => {
      const regex = glob instanceof RegExp ? glob : picomatch.makeRe(glob, options);
      return regex.test(path.basename(input2));
    };
    picomatch.isMatch = (str, patterns, options) => picomatch(patterns, options)(str);
    picomatch.parse = (pattern, options) => {
      if (Array.isArray(pattern))
        return pattern.map((p) => picomatch.parse(p, options));
      return parse2(pattern, { ...options, fastpaths: false });
    };
    picomatch.scan = (input2, options) => scan(input2, options);
    picomatch.compileRe = (state2, options, returnOutput = false, returnState = false) => {
      if (returnOutput === true) {
        return state2.output;
      }
      const opts = options || {};
      const prepend = opts.contains ? "" : "^";
      const append = opts.contains ? "" : "$";
      let source = `${prepend}(?:${state2.output})${append}`;
      if (state2 && state2.negated === true) {
        source = `^(?!${source}).*$`;
      }
      const regex = picomatch.toRegex(source, options);
      if (returnState === true) {
        regex.state = state2;
      }
      return regex;
    };
    picomatch.makeRe = (input2, options = {}, returnOutput = false, returnState = false) => {
      if (!input2 || typeof input2 !== "string") {
        throw new TypeError("Expected a non-empty string");
      }
      let parsed = { negated: false, fastpaths: true };
      if (options.fastpaths !== false && (input2[0] === "." || input2[0] === "*")) {
        parsed.output = parse2.fastpaths(input2, options);
      }
      if (!parsed.output) {
        parsed = parse2(input2, options);
      }
      return picomatch.compileRe(parsed, options, returnOutput, returnState);
    };
    picomatch.toRegex = (source, options) => {
      try {
        const opts = options || {};
        return new RegExp(source, opts.flags || (opts.nocase ? "i" : ""));
      } catch (err) {
        if (options && options.debug === true)
          throw err;
        return /$^/;
      }
    };
    picomatch.constants = constants;
    module.exports = picomatch;
  }
});

// node_modules/picomatch/index.js
var require_picomatch2 = __commonJS({
  "node_modules/picomatch/index.js"(exports, module) {
    "use strict";
    module.exports = require_picomatch();
  }
});

// node_modules/micromatch/index.js
var require_micromatch = __commonJS({
  "node_modules/micromatch/index.js"(exports, module) {
    "use strict";
    var util = require_util2();
    var braces = require_braces();
    var picomatch = require_picomatch2();
    var utils = require_utils2();
    var isEmptyString = (val) => val === "" || val === "./";
    var micromatch = (list, patterns, options) => {
      patterns = [].concat(patterns);
      list = [].concat(list);
      let omit = /* @__PURE__ */ new Set();
      let keep = /* @__PURE__ */ new Set();
      let items = /* @__PURE__ */ new Set();
      let negatives = 0;
      let onResult = (state2) => {
        items.add(state2.output);
        if (options && options.onResult) {
          options.onResult(state2);
        }
      };
      for (let i = 0; i < patterns.length; i++) {
        let isMatch = picomatch(String(patterns[i]), { ...options, onResult }, true);
        let negated = isMatch.state.negated || isMatch.state.negatedExtglob;
        if (negated)
          negatives++;
        for (let item of list) {
          let matched = isMatch(item, true);
          let match2 = negated ? !matched.isMatch : matched.isMatch;
          if (!match2)
            continue;
          if (negated) {
            omit.add(matched.output);
          } else {
            omit.delete(matched.output);
            keep.add(matched.output);
          }
        }
      }
      let result = negatives === patterns.length ? [...items] : [...keep];
      let matches = result.filter((item) => !omit.has(item));
      if (options && matches.length === 0) {
        if (options.failglob === true) {
          throw new Error(`No matches found for "${patterns.join(", ")}"`);
        }
        if (options.nonull === true || options.nullglob === true) {
          return options.unescape ? patterns.map((p) => p.replace(/\\/g, "")) : patterns;
        }
      }
      return matches;
    };
    micromatch.match = micromatch;
    micromatch.matcher = (pattern, options) => picomatch(pattern, options);
    micromatch.isMatch = (str, patterns, options) => picomatch(patterns, options)(str);
    micromatch.any = micromatch.isMatch;
    micromatch.not = (list, patterns, options = {}) => {
      patterns = [].concat(patterns).map(String);
      let result = /* @__PURE__ */ new Set();
      let items = [];
      let onResult = (state2) => {
        if (options.onResult)
          options.onResult(state2);
        items.push(state2.output);
      };
      let matches = new Set(micromatch(list, patterns, { ...options, onResult }));
      for (let item of items) {
        if (!matches.has(item)) {
          result.add(item);
        }
      }
      return [...result];
    };
    micromatch.contains = (str, pattern, options) => {
      if (typeof str !== "string") {
        throw new TypeError(`Expected a string: "${util.inspect(str)}"`);
      }
      if (Array.isArray(pattern)) {
        return pattern.some((p) => micromatch.contains(str, p, options));
      }
      if (typeof pattern === "string") {
        if (isEmptyString(str) || isEmptyString(pattern)) {
          return false;
        }
        if (str.includes(pattern) || str.startsWith("./") && str.slice(2).includes(pattern)) {
          return true;
        }
      }
      return micromatch.isMatch(str, pattern, { ...options, contains: true });
    };
    micromatch.matchKeys = (obj, patterns, options) => {
      if (!utils.isObject(obj)) {
        throw new TypeError("Expected the first argument to be an object");
      }
      let keys = micromatch(Object.keys(obj), patterns, options);
      let res = {};
      for (let key of keys)
        res[key] = obj[key];
      return res;
    };
    micromatch.some = (list, patterns, options) => {
      let items = [].concat(list);
      for (let pattern of [].concat(patterns)) {
        let isMatch = picomatch(String(pattern), options);
        if (items.some((item) => isMatch(item))) {
          return true;
        }
      }
      return false;
    };
    micromatch.every = (list, patterns, options) => {
      let items = [].concat(list);
      for (let pattern of [].concat(patterns)) {
        let isMatch = picomatch(String(pattern), options);
        if (!items.every((item) => isMatch(item))) {
          return false;
        }
      }
      return true;
    };
    micromatch.all = (str, patterns, options) => {
      if (typeof str !== "string") {
        throw new TypeError(`Expected a string: "${util.inspect(str)}"`);
      }
      return [].concat(patterns).every((p) => picomatch(p, options)(str));
    };
    micromatch.capture = (glob, input2, options) => {
      let posix = utils.isWindows(options);
      let regex = picomatch.makeRe(String(glob), { ...options, capture: true });
      let match2 = regex.exec(posix ? utils.toPosixSlashes(input2) : input2);
      if (match2) {
        return match2.slice(1).map((v) => v === void 0 ? "" : v);
      }
    };
    micromatch.makeRe = (...args) => picomatch.makeRe(...args);
    micromatch.scan = (...args) => picomatch.scan(...args);
    micromatch.parse = (patterns, options) => {
      let res = [];
      for (let pattern of [].concat(patterns || [])) {
        for (let str of braces(String(pattern), options)) {
          res.push(picomatch.parse(str, options));
        }
      }
      return res;
    };
    micromatch.braces = (pattern, options) => {
      if (typeof pattern !== "string")
        throw new TypeError("Expected a string");
      if (options && options.nobrace === true || !/\{.*\}/.test(pattern)) {
        return [pattern];
      }
      return braces(pattern, options);
    };
    micromatch.braceExpand = (pattern, options) => {
      if (typeof pattern !== "string")
        throw new TypeError("Expected a string");
      return micromatch.braces(pattern, { ...options, expand: true });
    };
    module.exports = micromatch;
  }
});

// node_modules/fast-glob/out/utils/pattern.js
var require_pattern = __commonJS({
  "node_modules/fast-glob/out/utils/pattern.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.removeDuplicateSlashes = exports.matchAny = exports.convertPatternsToRe = exports.makeRe = exports.getPatternParts = exports.expandBraceExpansion = exports.expandPatternsWithBraceExpansion = exports.isAffectDepthOfReadingPattern = exports.endsWithSlashGlobStar = exports.hasGlobStar = exports.getBaseDirectory = exports.isPatternRelatedToParentDirectory = exports.getPatternsOutsideCurrentDirectory = exports.getPatternsInsideCurrentDirectory = exports.getPositivePatterns = exports.getNegativePatterns = exports.isPositivePattern = exports.isNegativePattern = exports.convertToNegativePattern = exports.convertToPositivePattern = exports.isDynamicPattern = exports.isStaticPattern = void 0;
    var path = require_path();
    var globParent = require_glob_parent();
    var micromatch = require_micromatch();
    var GLOBSTAR = "**";
    var ESCAPE_SYMBOL = "\\";
    var COMMON_GLOB_SYMBOLS_RE = /[*?]|^!/;
    var REGEX_CHARACTER_CLASS_SYMBOLS_RE = /\[[^[]*]/;
    var REGEX_GROUP_SYMBOLS_RE = /(?:^|[^!*+?@])\([^(]*\|[^|]*\)/;
    var GLOB_EXTENSION_SYMBOLS_RE = /[!*+?@]\([^(]*\)/;
    var BRACE_EXPANSION_SEPARATORS_RE = /,|\.\./;
    var DOUBLE_SLASH_RE = /(?!^)\/{2,}/g;
    function isStaticPattern(pattern, options = {}) {
      return !isDynamicPattern(pattern, options);
    }
    exports.isStaticPattern = isStaticPattern;
    function isDynamicPattern(pattern, options = {}) {
      if (pattern === "") {
        return false;
      }
      if (options.caseSensitiveMatch === false || pattern.includes(ESCAPE_SYMBOL)) {
        return true;
      }
      if (COMMON_GLOB_SYMBOLS_RE.test(pattern) || REGEX_CHARACTER_CLASS_SYMBOLS_RE.test(pattern) || REGEX_GROUP_SYMBOLS_RE.test(pattern)) {
        return true;
      }
      if (options.extglob !== false && GLOB_EXTENSION_SYMBOLS_RE.test(pattern)) {
        return true;
      }
      if (options.braceExpansion !== false && hasBraceExpansion(pattern)) {
        return true;
      }
      return false;
    }
    exports.isDynamicPattern = isDynamicPattern;
    function hasBraceExpansion(pattern) {
      const openingBraceIndex = pattern.indexOf("{");
      if (openingBraceIndex === -1) {
        return false;
      }
      const closingBraceIndex = pattern.indexOf("}", openingBraceIndex + 1);
      if (closingBraceIndex === -1) {
        return false;
      }
      const braceContent = pattern.slice(openingBraceIndex, closingBraceIndex);
      return BRACE_EXPANSION_SEPARATORS_RE.test(braceContent);
    }
    function convertToPositivePattern(pattern) {
      return isNegativePattern(pattern) ? pattern.slice(1) : pattern;
    }
    exports.convertToPositivePattern = convertToPositivePattern;
    function convertToNegativePattern(pattern) {
      return "!" + pattern;
    }
    exports.convertToNegativePattern = convertToNegativePattern;
    function isNegativePattern(pattern) {
      return pattern.startsWith("!") && pattern[1] !== "(";
    }
    exports.isNegativePattern = isNegativePattern;
    function isPositivePattern(pattern) {
      return !isNegativePattern(pattern);
    }
    exports.isPositivePattern = isPositivePattern;
    function getNegativePatterns(patterns) {
      return patterns.filter(isNegativePattern);
    }
    exports.getNegativePatterns = getNegativePatterns;
    function getPositivePatterns(patterns) {
      return patterns.filter(isPositivePattern);
    }
    exports.getPositivePatterns = getPositivePatterns;
    function getPatternsInsideCurrentDirectory(patterns) {
      return patterns.filter((pattern) => !isPatternRelatedToParentDirectory(pattern));
    }
    exports.getPatternsInsideCurrentDirectory = getPatternsInsideCurrentDirectory;
    function getPatternsOutsideCurrentDirectory(patterns) {
      return patterns.filter(isPatternRelatedToParentDirectory);
    }
    exports.getPatternsOutsideCurrentDirectory = getPatternsOutsideCurrentDirectory;
    function isPatternRelatedToParentDirectory(pattern) {
      return pattern.startsWith("..") || pattern.startsWith("./..");
    }
    exports.isPatternRelatedToParentDirectory = isPatternRelatedToParentDirectory;
    function getBaseDirectory(pattern) {
      return globParent(pattern, { flipBackslashes: false });
    }
    exports.getBaseDirectory = getBaseDirectory;
    function hasGlobStar(pattern) {
      return pattern.includes(GLOBSTAR);
    }
    exports.hasGlobStar = hasGlobStar;
    function endsWithSlashGlobStar(pattern) {
      return pattern.endsWith("/" + GLOBSTAR);
    }
    exports.endsWithSlashGlobStar = endsWithSlashGlobStar;
    function isAffectDepthOfReadingPattern(pattern) {
      const basename = path.basename(pattern);
      return endsWithSlashGlobStar(pattern) || isStaticPattern(basename);
    }
    exports.isAffectDepthOfReadingPattern = isAffectDepthOfReadingPattern;
    function expandPatternsWithBraceExpansion(patterns) {
      return patterns.reduce((collection, pattern) => {
        return collection.concat(expandBraceExpansion(pattern));
      }, []);
    }
    exports.expandPatternsWithBraceExpansion = expandPatternsWithBraceExpansion;
    function expandBraceExpansion(pattern) {
      const patterns = micromatch.braces(pattern, { expand: true, nodupes: true, keepEscaping: true });
      patterns.sort((a, b) => a.length - b.length);
      return patterns.filter((pattern2) => pattern2 !== "");
    }
    exports.expandBraceExpansion = expandBraceExpansion;
    function getPatternParts(pattern, options) {
      let { parts } = micromatch.scan(pattern, Object.assign(Object.assign({}, options), { parts: true }));
      if (parts.length === 0) {
        parts = [pattern];
      }
      if (parts[0].startsWith("/")) {
        parts[0] = parts[0].slice(1);
        parts.unshift("");
      }
      return parts;
    }
    exports.getPatternParts = getPatternParts;
    function makeRe(pattern, options) {
      return micromatch.makeRe(pattern, options);
    }
    exports.makeRe = makeRe;
    function convertPatternsToRe(patterns, options) {
      return patterns.map((pattern) => makeRe(pattern, options));
    }
    exports.convertPatternsToRe = convertPatternsToRe;
    function matchAny(entry, patternsRe) {
      return patternsRe.some((patternRe) => patternRe.test(entry));
    }
    exports.matchAny = matchAny;
    function removeDuplicateSlashes(pattern) {
      return pattern.replace(DOUBLE_SLASH_RE, "/");
    }
    exports.removeDuplicateSlashes = removeDuplicateSlashes;
  }
});

// browser-external:stream
var require_stream = __commonJS({
  "browser-external:stream"(exports, module) {
    module.exports = Object.create(new Proxy({}, {
      get(_, key) {
        if (key !== "__esModule" && key !== "__proto__" && key !== "constructor" && key !== "splice") {
          console.warn(`Module "stream" has been externalized for browser compatibility. Cannot access "stream.${key}" in client code. See http://vitejs.dev/guide/troubleshooting.html#module-externalized-for-browser-compatibility for more details.`);
        }
      }
    }));
  }
});

// node_modules/merge2/index.js
var require_merge2 = __commonJS({
  "node_modules/merge2/index.js"(exports, module) {
    "use strict";
    var Stream = require_stream();
    var PassThrough = Stream.PassThrough;
    var slice = Array.prototype.slice;
    module.exports = merge2;
    function merge2() {
      const streamsQueue = [];
      const args = slice.call(arguments);
      let merging = false;
      let options = args[args.length - 1];
      if (options && !Array.isArray(options) && options.pipe == null) {
        args.pop();
      } else {
        options = {};
      }
      const doEnd = options.end !== false;
      const doPipeError = options.pipeError === true;
      if (options.objectMode == null) {
        options.objectMode = true;
      }
      if (options.highWaterMark == null) {
        options.highWaterMark = 64 * 1024;
      }
      const mergedStream = PassThrough(options);
      function addStream() {
        for (let i = 0, len = arguments.length; i < len; i++) {
          streamsQueue.push(pauseStreams(arguments[i], options));
        }
        mergeStream();
        return this;
      }
      function mergeStream() {
        if (merging) {
          return;
        }
        merging = true;
        let streams = streamsQueue.shift();
        if (!streams) {
          process.nextTick(endStream);
          return;
        }
        if (!Array.isArray(streams)) {
          streams = [streams];
        }
        let pipesCount = streams.length + 1;
        function next2() {
          if (--pipesCount > 0) {
            return;
          }
          merging = false;
          mergeStream();
        }
        function pipe(stream) {
          function onend() {
            stream.removeListener("merge2UnpipeEnd", onend);
            stream.removeListener("end", onend);
            if (doPipeError) {
              stream.removeListener("error", onerror);
            }
            next2();
          }
          function onerror(err) {
            mergedStream.emit("error", err);
          }
          if (stream._readableState.endEmitted) {
            return next2();
          }
          stream.on("merge2UnpipeEnd", onend);
          stream.on("end", onend);
          if (doPipeError) {
            stream.on("error", onerror);
          }
          stream.pipe(mergedStream, { end: false });
          stream.resume();
        }
        for (let i = 0; i < streams.length; i++) {
          pipe(streams[i]);
        }
        next2();
      }
      function endStream() {
        merging = false;
        mergedStream.emit("queueDrain");
        if (doEnd) {
          mergedStream.end();
        }
      }
      mergedStream.setMaxListeners(0);
      mergedStream.add = addStream;
      mergedStream.on("unpipe", function(stream) {
        stream.emit("merge2UnpipeEnd");
      });
      if (args.length) {
        addStream.apply(null, args);
      }
      return mergedStream;
    }
    function pauseStreams(streams, options) {
      if (!Array.isArray(streams)) {
        if (!streams._readableState && streams.pipe) {
          streams = streams.pipe(PassThrough(options));
        }
        if (!streams._readableState || !streams.pause || !streams.pipe) {
          throw new Error("Only readable stream can be merged.");
        }
        streams.pause();
      } else {
        for (let i = 0, len = streams.length; i < len; i++) {
          streams[i] = pauseStreams(streams[i], options);
        }
      }
      return streams;
    }
  }
});

// node_modules/fast-glob/out/utils/stream.js
var require_stream2 = __commonJS({
  "node_modules/fast-glob/out/utils/stream.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.merge = void 0;
    var merge2 = require_merge2();
    function merge(streams) {
      const mergedStream = merge2(streams);
      streams.forEach((stream) => {
        stream.once("error", (error) => mergedStream.emit("error", error));
      });
      mergedStream.once("close", () => propagateCloseEventToSources(streams));
      mergedStream.once("end", () => propagateCloseEventToSources(streams));
      return mergedStream;
    }
    exports.merge = merge;
    function propagateCloseEventToSources(streams) {
      streams.forEach((stream) => stream.emit("close"));
    }
  }
});

// node_modules/fast-glob/out/utils/string.js
var require_string2 = __commonJS({
  "node_modules/fast-glob/out/utils/string.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.isEmpty = exports.isString = void 0;
    function isString(input2) {
      return typeof input2 === "string";
    }
    exports.isString = isString;
    function isEmpty(input2) {
      return input2 === "";
    }
    exports.isEmpty = isEmpty;
  }
});

// node_modules/fast-glob/out/utils/index.js
var require_utils3 = __commonJS({
  "node_modules/fast-glob/out/utils/index.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.string = exports.stream = exports.pattern = exports.path = exports.fs = exports.errno = exports.array = void 0;
    var array2 = require_array();
    exports.array = array2;
    var errno = require_errno();
    exports.errno = errno;
    var fs = require_fs2();
    exports.fs = fs;
    var path = require_path2();
    exports.path = path;
    var pattern = require_pattern();
    exports.pattern = pattern;
    var stream = require_stream2();
    exports.stream = stream;
    var string = require_string2();
    exports.string = string;
  }
});

// node_modules/fast-glob/out/managers/tasks.js
var require_tasks = __commonJS({
  "node_modules/fast-glob/out/managers/tasks.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.convertPatternGroupToTask = exports.convertPatternGroupsToTasks = exports.groupPatternsByBaseDirectory = exports.getNegativePatternsAsPositive = exports.getPositivePatterns = exports.convertPatternsToTasks = exports.generate = void 0;
    var utils = require_utils3();
    function generate(input2, settings) {
      const patterns = processPatterns(input2, settings);
      const ignore = processPatterns(settings.ignore, settings);
      const positivePatterns = getPositivePatterns(patterns);
      const negativePatterns = getNegativePatternsAsPositive(patterns, ignore);
      const staticPatterns = positivePatterns.filter((pattern) => utils.pattern.isStaticPattern(pattern, settings));
      const dynamicPatterns = positivePatterns.filter((pattern) => utils.pattern.isDynamicPattern(pattern, settings));
      const staticTasks = convertPatternsToTasks(
        staticPatterns,
        negativePatterns,
        /* dynamic */
        false
      );
      const dynamicTasks = convertPatternsToTasks(
        dynamicPatterns,
        negativePatterns,
        /* dynamic */
        true
      );
      return staticTasks.concat(dynamicTasks);
    }
    exports.generate = generate;
    function processPatterns(input2, settings) {
      let patterns = input2;
      if (settings.braceExpansion) {
        patterns = utils.pattern.expandPatternsWithBraceExpansion(patterns);
      }
      if (settings.baseNameMatch) {
        patterns = patterns.map((pattern) => pattern.includes("/") ? pattern : `**/${pattern}`);
      }
      return patterns.map((pattern) => utils.pattern.removeDuplicateSlashes(pattern));
    }
    function convertPatternsToTasks(positive, negative, dynamic) {
      const tasks = [];
      const patternsOutsideCurrentDirectory = utils.pattern.getPatternsOutsideCurrentDirectory(positive);
      const patternsInsideCurrentDirectory = utils.pattern.getPatternsInsideCurrentDirectory(positive);
      const outsideCurrentDirectoryGroup = groupPatternsByBaseDirectory(patternsOutsideCurrentDirectory);
      const insideCurrentDirectoryGroup = groupPatternsByBaseDirectory(patternsInsideCurrentDirectory);
      tasks.push(...convertPatternGroupsToTasks(outsideCurrentDirectoryGroup, negative, dynamic));
      if ("." in insideCurrentDirectoryGroup) {
        tasks.push(convertPatternGroupToTask(".", patternsInsideCurrentDirectory, negative, dynamic));
      } else {
        tasks.push(...convertPatternGroupsToTasks(insideCurrentDirectoryGroup, negative, dynamic));
      }
      return tasks;
    }
    exports.convertPatternsToTasks = convertPatternsToTasks;
    function getPositivePatterns(patterns) {
      return utils.pattern.getPositivePatterns(patterns);
    }
    exports.getPositivePatterns = getPositivePatterns;
    function getNegativePatternsAsPositive(patterns, ignore) {
      const negative = utils.pattern.getNegativePatterns(patterns).concat(ignore);
      const positive = negative.map(utils.pattern.convertToPositivePattern);
      return positive;
    }
    exports.getNegativePatternsAsPositive = getNegativePatternsAsPositive;
    function groupPatternsByBaseDirectory(patterns) {
      const group = {};
      return patterns.reduce((collection, pattern) => {
        const base = utils.pattern.getBaseDirectory(pattern);
        if (base in collection) {
          collection[base].push(pattern);
        } else {
          collection[base] = [pattern];
        }
        return collection;
      }, group);
    }
    exports.groupPatternsByBaseDirectory = groupPatternsByBaseDirectory;
    function convertPatternGroupsToTasks(positive, negative, dynamic) {
      return Object.keys(positive).map((base) => {
        return convertPatternGroupToTask(base, positive[base], negative, dynamic);
      });
    }
    exports.convertPatternGroupsToTasks = convertPatternGroupsToTasks;
    function convertPatternGroupToTask(base, positive, negative, dynamic) {
      return {
        dynamic,
        positive,
        negative,
        base,
        patterns: [].concat(positive, negative.map(utils.pattern.convertToNegativePattern))
      };
    }
    exports.convertPatternGroupToTask = convertPatternGroupToTask;
  }
});

// browser-external:events
var require_events = __commonJS({
  "browser-external:events"(exports, module) {
    module.exports = Object.create(new Proxy({}, {
      get(_, key) {
        if (key !== "__esModule" && key !== "__proto__" && key !== "constructor" && key !== "splice") {
          console.warn(`Module "events" has been externalized for browser compatibility. Cannot access "events.${key}" in client code. See http://vitejs.dev/guide/troubleshooting.html#module-externalized-for-browser-compatibility for more details.`);
        }
      }
    }));
  }
});

// node_modules/@nodelib/fs.stat/out/providers/async.js
var require_async2 = __commonJS({
  "node_modules/@nodelib/fs.stat/out/providers/async.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.read = void 0;
    function read(path, settings, callback) {
      settings.fs.lstat(path, (lstatError, lstat) => {
        if (lstatError !== null) {
          callFailureCallback(callback, lstatError);
          return;
        }
        if (!lstat.isSymbolicLink() || !settings.followSymbolicLink) {
          callSuccessCallback(callback, lstat);
          return;
        }
        settings.fs.stat(path, (statError, stat) => {
          if (statError !== null) {
            if (settings.throwErrorOnBrokenSymbolicLink) {
              callFailureCallback(callback, statError);
              return;
            }
            callSuccessCallback(callback, lstat);
            return;
          }
          if (settings.markSymbolicLink) {
            stat.isSymbolicLink = () => true;
          }
          callSuccessCallback(callback, stat);
        });
      });
    }
    exports.read = read;
    function callFailureCallback(callback, error) {
      callback(error);
    }
    function callSuccessCallback(callback, result) {
      callback(null, result);
    }
  }
});

// node_modules/@nodelib/fs.stat/out/providers/sync.js
var require_sync2 = __commonJS({
  "node_modules/@nodelib/fs.stat/out/providers/sync.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.read = void 0;
    function read(path, settings) {
      const lstat = settings.fs.lstatSync(path);
      if (!lstat.isSymbolicLink() || !settings.followSymbolicLink) {
        return lstat;
      }
      try {
        const stat = settings.fs.statSync(path);
        if (settings.markSymbolicLink) {
          stat.isSymbolicLink = () => true;
        }
        return stat;
      } catch (error) {
        if (!settings.throwErrorOnBrokenSymbolicLink) {
          return lstat;
        }
        throw error;
      }
    }
    exports.read = read;
  }
});

// node_modules/@nodelib/fs.stat/out/adapters/fs.js
var require_fs3 = __commonJS({
  "node_modules/@nodelib/fs.stat/out/adapters/fs.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.createFileSystemAdapter = exports.FILE_SYSTEM_ADAPTER = void 0;
    var fs = require_fs();
    exports.FILE_SYSTEM_ADAPTER = {
      lstat: fs.lstat,
      stat: fs.stat,
      lstatSync: fs.lstatSync,
      statSync: fs.statSync
    };
    function createFileSystemAdapter(fsMethods) {
      if (fsMethods === void 0) {
        return exports.FILE_SYSTEM_ADAPTER;
      }
      return Object.assign(Object.assign({}, exports.FILE_SYSTEM_ADAPTER), fsMethods);
    }
    exports.createFileSystemAdapter = createFileSystemAdapter;
  }
});

// node_modules/@nodelib/fs.stat/out/settings.js
var require_settings = __commonJS({
  "node_modules/@nodelib/fs.stat/out/settings.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var fs = require_fs3();
    var Settings = class {
      constructor(_options = {}) {
        this._options = _options;
        this.followSymbolicLink = this._getValue(this._options.followSymbolicLink, true);
        this.fs = fs.createFileSystemAdapter(this._options.fs);
        this.markSymbolicLink = this._getValue(this._options.markSymbolicLink, false);
        this.throwErrorOnBrokenSymbolicLink = this._getValue(this._options.throwErrorOnBrokenSymbolicLink, true);
      }
      _getValue(option, value2) {
        return option !== null && option !== void 0 ? option : value2;
      }
    };
    exports.default = Settings;
  }
});

// node_modules/@nodelib/fs.stat/out/index.js
var require_out = __commonJS({
  "node_modules/@nodelib/fs.stat/out/index.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.statSync = exports.stat = exports.Settings = void 0;
    var async = require_async2();
    var sync = require_sync2();
    var settings_1 = require_settings();
    exports.Settings = settings_1.default;
    function stat(path, optionsOrSettingsOrCallback, callback) {
      if (typeof optionsOrSettingsOrCallback === "function") {
        async.read(path, getSettings(), optionsOrSettingsOrCallback);
        return;
      }
      async.read(path, getSettings(optionsOrSettingsOrCallback), callback);
    }
    exports.stat = stat;
    function statSync(path, optionsOrSettings) {
      const settings = getSettings(optionsOrSettings);
      return sync.read(path, settings);
    }
    exports.statSync = statSync;
    function getSettings(settingsOrOptions = {}) {
      if (settingsOrOptions instanceof settings_1.default) {
        return settingsOrOptions;
      }
      return new settings_1.default(settingsOrOptions);
    }
  }
});

// node_modules/queue-microtask/index.js
var require_queue_microtask = __commonJS({
  "node_modules/queue-microtask/index.js"(exports, module) {
    var promise;
    module.exports = typeof queueMicrotask === "function" ? queueMicrotask.bind(typeof window !== "undefined" ? window : global) : (cb) => (promise || (promise = Promise.resolve())).then(cb).catch((err) => setTimeout(() => {
      throw err;
    }, 0));
  }
});

// node_modules/run-parallel/index.js
var require_run_parallel = __commonJS({
  "node_modules/run-parallel/index.js"(exports, module) {
    module.exports = runParallel;
    var queueMicrotask2 = require_queue_microtask();
    function runParallel(tasks, cb) {
      let results, pending, keys;
      let isSync = true;
      if (Array.isArray(tasks)) {
        results = [];
        pending = tasks.length;
      } else {
        keys = Object.keys(tasks);
        results = {};
        pending = keys.length;
      }
      function done(err) {
        function end() {
          if (cb)
            cb(err, results);
          cb = null;
        }
        if (isSync)
          queueMicrotask2(end);
        else
          end();
      }
      function each(i, err, result) {
        results[i] = result;
        if (--pending === 0 || err) {
          done(err);
        }
      }
      if (!pending) {
        done(null);
      } else if (keys) {
        keys.forEach(function(key) {
          tasks[key](function(err, result) {
            each(key, err, result);
          });
        });
      } else {
        tasks.forEach(function(task, i) {
          task(function(err, result) {
            each(i, err, result);
          });
        });
      }
      isSync = false;
    }
  }
});

// node_modules/@nodelib/fs.scandir/out/constants.js
var require_constants3 = __commonJS({
  "node_modules/@nodelib/fs.scandir/out/constants.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.IS_SUPPORT_READDIR_WITH_FILE_TYPES = void 0;
    var NODE_PROCESS_VERSION_PARTS = process.versions.node.split(".");
    if (NODE_PROCESS_VERSION_PARTS[0] === void 0 || NODE_PROCESS_VERSION_PARTS[1] === void 0) {
      throw new Error(`Unexpected behavior. The 'process.versions.node' variable has invalid value: ${process.versions.node}`);
    }
    var MAJOR_VERSION = Number.parseInt(NODE_PROCESS_VERSION_PARTS[0], 10);
    var MINOR_VERSION = Number.parseInt(NODE_PROCESS_VERSION_PARTS[1], 10);
    var SUPPORTED_MAJOR_VERSION = 10;
    var SUPPORTED_MINOR_VERSION = 10;
    var IS_MATCHED_BY_MAJOR = MAJOR_VERSION > SUPPORTED_MAJOR_VERSION;
    var IS_MATCHED_BY_MAJOR_AND_MINOR = MAJOR_VERSION === SUPPORTED_MAJOR_VERSION && MINOR_VERSION >= SUPPORTED_MINOR_VERSION;
    exports.IS_SUPPORT_READDIR_WITH_FILE_TYPES = IS_MATCHED_BY_MAJOR || IS_MATCHED_BY_MAJOR_AND_MINOR;
  }
});

// node_modules/@nodelib/fs.scandir/out/utils/fs.js
var require_fs4 = __commonJS({
  "node_modules/@nodelib/fs.scandir/out/utils/fs.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.createDirentFromStats = void 0;
    var DirentFromStats = class {
      constructor(name, stats) {
        this.name = name;
        this.isBlockDevice = stats.isBlockDevice.bind(stats);
        this.isCharacterDevice = stats.isCharacterDevice.bind(stats);
        this.isDirectory = stats.isDirectory.bind(stats);
        this.isFIFO = stats.isFIFO.bind(stats);
        this.isFile = stats.isFile.bind(stats);
        this.isSocket = stats.isSocket.bind(stats);
        this.isSymbolicLink = stats.isSymbolicLink.bind(stats);
      }
    };
    function createDirentFromStats(name, stats) {
      return new DirentFromStats(name, stats);
    }
    exports.createDirentFromStats = createDirentFromStats;
  }
});

// node_modules/@nodelib/fs.scandir/out/utils/index.js
var require_utils4 = __commonJS({
  "node_modules/@nodelib/fs.scandir/out/utils/index.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.fs = void 0;
    var fs = require_fs4();
    exports.fs = fs;
  }
});

// node_modules/@nodelib/fs.scandir/out/providers/common.js
var require_common = __commonJS({
  "node_modules/@nodelib/fs.scandir/out/providers/common.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.joinPathSegments = void 0;
    function joinPathSegments(a, b, separator) {
      if (a.endsWith(separator)) {
        return a + b;
      }
      return a + separator + b;
    }
    exports.joinPathSegments = joinPathSegments;
  }
});

// node_modules/@nodelib/fs.scandir/out/providers/async.js
var require_async3 = __commonJS({
  "node_modules/@nodelib/fs.scandir/out/providers/async.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.readdir = exports.readdirWithFileTypes = exports.read = void 0;
    var fsStat = require_out();
    var rpl = require_run_parallel();
    var constants_1 = require_constants3();
    var utils = require_utils4();
    var common = require_common();
    function read(directory, settings, callback) {
      if (!settings.stats && constants_1.IS_SUPPORT_READDIR_WITH_FILE_TYPES) {
        readdirWithFileTypes(directory, settings, callback);
        return;
      }
      readdir(directory, settings, callback);
    }
    exports.read = read;
    function readdirWithFileTypes(directory, settings, callback) {
      settings.fs.readdir(directory, { withFileTypes: true }, (readdirError, dirents) => {
        if (readdirError !== null) {
          callFailureCallback(callback, readdirError);
          return;
        }
        const entries = dirents.map((dirent) => ({
          dirent,
          name: dirent.name,
          path: common.joinPathSegments(directory, dirent.name, settings.pathSegmentSeparator)
        }));
        if (!settings.followSymbolicLinks) {
          callSuccessCallback(callback, entries);
          return;
        }
        const tasks = entries.map((entry) => makeRplTaskEntry(entry, settings));
        rpl(tasks, (rplError, rplEntries) => {
          if (rplError !== null) {
            callFailureCallback(callback, rplError);
            return;
          }
          callSuccessCallback(callback, rplEntries);
        });
      });
    }
    exports.readdirWithFileTypes = readdirWithFileTypes;
    function makeRplTaskEntry(entry, settings) {
      return (done) => {
        if (!entry.dirent.isSymbolicLink()) {
          done(null, entry);
          return;
        }
        settings.fs.stat(entry.path, (statError, stats) => {
          if (statError !== null) {
            if (settings.throwErrorOnBrokenSymbolicLink) {
              done(statError);
              return;
            }
            done(null, entry);
            return;
          }
          entry.dirent = utils.fs.createDirentFromStats(entry.name, stats);
          done(null, entry);
        });
      };
    }
    function readdir(directory, settings, callback) {
      settings.fs.readdir(directory, (readdirError, names) => {
        if (readdirError !== null) {
          callFailureCallback(callback, readdirError);
          return;
        }
        const tasks = names.map((name) => {
          const path = common.joinPathSegments(directory, name, settings.pathSegmentSeparator);
          return (done) => {
            fsStat.stat(path, settings.fsStatSettings, (error, stats) => {
              if (error !== null) {
                done(error);
                return;
              }
              const entry = {
                name,
                path,
                dirent: utils.fs.createDirentFromStats(name, stats)
              };
              if (settings.stats) {
                entry.stats = stats;
              }
              done(null, entry);
            });
          };
        });
        rpl(tasks, (rplError, entries) => {
          if (rplError !== null) {
            callFailureCallback(callback, rplError);
            return;
          }
          callSuccessCallback(callback, entries);
        });
      });
    }
    exports.readdir = readdir;
    function callFailureCallback(callback, error) {
      callback(error);
    }
    function callSuccessCallback(callback, result) {
      callback(null, result);
    }
  }
});

// node_modules/@nodelib/fs.scandir/out/providers/sync.js
var require_sync3 = __commonJS({
  "node_modules/@nodelib/fs.scandir/out/providers/sync.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.readdir = exports.readdirWithFileTypes = exports.read = void 0;
    var fsStat = require_out();
    var constants_1 = require_constants3();
    var utils = require_utils4();
    var common = require_common();
    function read(directory, settings) {
      if (!settings.stats && constants_1.IS_SUPPORT_READDIR_WITH_FILE_TYPES) {
        return readdirWithFileTypes(directory, settings);
      }
      return readdir(directory, settings);
    }
    exports.read = read;
    function readdirWithFileTypes(directory, settings) {
      const dirents = settings.fs.readdirSync(directory, { withFileTypes: true });
      return dirents.map((dirent) => {
        const entry = {
          dirent,
          name: dirent.name,
          path: common.joinPathSegments(directory, dirent.name, settings.pathSegmentSeparator)
        };
        if (entry.dirent.isSymbolicLink() && settings.followSymbolicLinks) {
          try {
            const stats = settings.fs.statSync(entry.path);
            entry.dirent = utils.fs.createDirentFromStats(entry.name, stats);
          } catch (error) {
            if (settings.throwErrorOnBrokenSymbolicLink) {
              throw error;
            }
          }
        }
        return entry;
      });
    }
    exports.readdirWithFileTypes = readdirWithFileTypes;
    function readdir(directory, settings) {
      const names = settings.fs.readdirSync(directory);
      return names.map((name) => {
        const entryPath = common.joinPathSegments(directory, name, settings.pathSegmentSeparator);
        const stats = fsStat.statSync(entryPath, settings.fsStatSettings);
        const entry = {
          name,
          path: entryPath,
          dirent: utils.fs.createDirentFromStats(name, stats)
        };
        if (settings.stats) {
          entry.stats = stats;
        }
        return entry;
      });
    }
    exports.readdir = readdir;
  }
});

// node_modules/@nodelib/fs.scandir/out/adapters/fs.js
var require_fs5 = __commonJS({
  "node_modules/@nodelib/fs.scandir/out/adapters/fs.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.createFileSystemAdapter = exports.FILE_SYSTEM_ADAPTER = void 0;
    var fs = require_fs();
    exports.FILE_SYSTEM_ADAPTER = {
      lstat: fs.lstat,
      stat: fs.stat,
      lstatSync: fs.lstatSync,
      statSync: fs.statSync,
      readdir: fs.readdir,
      readdirSync: fs.readdirSync
    };
    function createFileSystemAdapter(fsMethods) {
      if (fsMethods === void 0) {
        return exports.FILE_SYSTEM_ADAPTER;
      }
      return Object.assign(Object.assign({}, exports.FILE_SYSTEM_ADAPTER), fsMethods);
    }
    exports.createFileSystemAdapter = createFileSystemAdapter;
  }
});

// node_modules/@nodelib/fs.scandir/out/settings.js
var require_settings2 = __commonJS({
  "node_modules/@nodelib/fs.scandir/out/settings.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var path = require_path();
    var fsStat = require_out();
    var fs = require_fs5();
    var Settings = class {
      constructor(_options = {}) {
        this._options = _options;
        this.followSymbolicLinks = this._getValue(this._options.followSymbolicLinks, false);
        this.fs = fs.createFileSystemAdapter(this._options.fs);
        this.pathSegmentSeparator = this._getValue(this._options.pathSegmentSeparator, path.sep);
        this.stats = this._getValue(this._options.stats, false);
        this.throwErrorOnBrokenSymbolicLink = this._getValue(this._options.throwErrorOnBrokenSymbolicLink, true);
        this.fsStatSettings = new fsStat.Settings({
          followSymbolicLink: this.followSymbolicLinks,
          fs: this.fs,
          throwErrorOnBrokenSymbolicLink: this.throwErrorOnBrokenSymbolicLink
        });
      }
      _getValue(option, value2) {
        return option !== null && option !== void 0 ? option : value2;
      }
    };
    exports.default = Settings;
  }
});

// node_modules/@nodelib/fs.scandir/out/index.js
var require_out2 = __commonJS({
  "node_modules/@nodelib/fs.scandir/out/index.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.Settings = exports.scandirSync = exports.scandir = void 0;
    var async = require_async3();
    var sync = require_sync3();
    var settings_1 = require_settings2();
    exports.Settings = settings_1.default;
    function scandir(path, optionsOrSettingsOrCallback, callback) {
      if (typeof optionsOrSettingsOrCallback === "function") {
        async.read(path, getSettings(), optionsOrSettingsOrCallback);
        return;
      }
      async.read(path, getSettings(optionsOrSettingsOrCallback), callback);
    }
    exports.scandir = scandir;
    function scandirSync(path, optionsOrSettings) {
      const settings = getSettings(optionsOrSettings);
      return sync.read(path, settings);
    }
    exports.scandirSync = scandirSync;
    function getSettings(settingsOrOptions = {}) {
      if (settingsOrOptions instanceof settings_1.default) {
        return settingsOrOptions;
      }
      return new settings_1.default(settingsOrOptions);
    }
  }
});

// node_modules/reusify/reusify.js
var require_reusify = __commonJS({
  "node_modules/reusify/reusify.js"(exports, module) {
    "use strict";
    function reusify(Constructor) {
      var head = new Constructor();
      var tail = head;
      function get() {
        var current = head;
        if (current.next) {
          head = current.next;
        } else {
          head = new Constructor();
          tail = head;
        }
        current.next = null;
        return current;
      }
      function release(obj) {
        tail.next = obj;
        tail = obj;
      }
      return {
        get,
        release
      };
    }
    module.exports = reusify;
  }
});

// node_modules/fastq/queue.js
var require_queue = __commonJS({
  "node_modules/fastq/queue.js"(exports, module) {
    "use strict";
    var reusify = require_reusify();
    function fastqueue(context, worker, _concurrency) {
      if (typeof context === "function") {
        _concurrency = worker;
        worker = context;
        context = null;
      }
      if (!(_concurrency >= 1)) {
        throw new Error("fastqueue concurrency must be equal to or greater than 1");
      }
      var cache = reusify(Task);
      var queueHead = null;
      var queueTail = null;
      var _running = 0;
      var errorHandler = null;
      var self2 = {
        push,
        drain: noop,
        saturated: noop,
        pause,
        paused: false,
        get concurrency() {
          return _concurrency;
        },
        set concurrency(value2) {
          if (!(value2 >= 1)) {
            throw new Error("fastqueue concurrency must be equal to or greater than 1");
          }
          _concurrency = value2;
          if (self2.paused)
            return;
          for (; queueHead && _running < _concurrency; ) {
            _running++;
            release();
          }
        },
        running,
        resume,
        idle,
        length,
        getQueue,
        unshift,
        empty: noop,
        kill,
        killAndDrain,
        error
      };
      return self2;
      function running() {
        return _running;
      }
      function pause() {
        self2.paused = true;
      }
      function length() {
        var current = queueHead;
        var counter = 0;
        while (current) {
          current = current.next;
          counter++;
        }
        return counter;
      }
      function getQueue() {
        var current = queueHead;
        var tasks = [];
        while (current) {
          tasks.push(current.value);
          current = current.next;
        }
        return tasks;
      }
      function resume() {
        if (!self2.paused)
          return;
        self2.paused = false;
        if (queueHead === null) {
          _running++;
          release();
          return;
        }
        for (; queueHead && _running < _concurrency; ) {
          _running++;
          release();
        }
      }
      function idle() {
        return _running === 0 && self2.length() === 0;
      }
      function push(value2, done) {
        var current = cache.get();
        current.context = context;
        current.release = release;
        current.value = value2;
        current.callback = done || noop;
        current.errorHandler = errorHandler;
        if (_running >= _concurrency || self2.paused) {
          if (queueTail) {
            queueTail.next = current;
            queueTail = current;
          } else {
            queueHead = current;
            queueTail = current;
            self2.saturated();
          }
        } else {
          _running++;
          worker.call(context, current.value, current.worked);
        }
      }
      function unshift(value2, done) {
        var current = cache.get();
        current.context = context;
        current.release = release;
        current.value = value2;
        current.callback = done || noop;
        current.errorHandler = errorHandler;
        if (_running >= _concurrency || self2.paused) {
          if (queueHead) {
            current.next = queueHead;
            queueHead = current;
          } else {
            queueHead = current;
            queueTail = current;
            self2.saturated();
          }
        } else {
          _running++;
          worker.call(context, current.value, current.worked);
        }
      }
      function release(holder) {
        if (holder) {
          cache.release(holder);
        }
        var next2 = queueHead;
        if (next2 && _running <= _concurrency) {
          if (!self2.paused) {
            if (queueTail === queueHead) {
              queueTail = null;
            }
            queueHead = next2.next;
            next2.next = null;
            worker.call(context, next2.value, next2.worked);
            if (queueTail === null) {
              self2.empty();
            }
          } else {
            _running--;
          }
        } else if (--_running === 0) {
          self2.drain();
        }
      }
      function kill() {
        queueHead = null;
        queueTail = null;
        self2.drain = noop;
      }
      function killAndDrain() {
        queueHead = null;
        queueTail = null;
        self2.drain();
        self2.drain = noop;
      }
      function error(handler) {
        errorHandler = handler;
      }
    }
    function noop() {
    }
    function Task() {
      this.value = null;
      this.callback = noop;
      this.next = null;
      this.release = noop;
      this.context = null;
      this.errorHandler = null;
      var self2 = this;
      this.worked = function worked(err, result) {
        var callback = self2.callback;
        var errorHandler = self2.errorHandler;
        var val = self2.value;
        self2.value = null;
        self2.callback = noop;
        if (self2.errorHandler) {
          errorHandler(err, val);
        }
        callback.call(self2.context, err, result);
        self2.release(self2);
      };
    }
    function queueAsPromised(context, worker, _concurrency) {
      if (typeof context === "function") {
        _concurrency = worker;
        worker = context;
        context = null;
      }
      function asyncWrapper(arg, cb) {
        worker.call(this, arg).then(function(res) {
          cb(null, res);
        }, cb);
      }
      var queue = fastqueue(context, asyncWrapper, _concurrency);
      var pushCb = queue.push;
      var unshiftCb = queue.unshift;
      queue.push = push;
      queue.unshift = unshift;
      queue.drained = drained;
      return queue;
      function push(value2) {
        var p = new Promise(function(resolve, reject) {
          pushCb(value2, function(err, result) {
            if (err) {
              reject(err);
              return;
            }
            resolve(result);
          });
        });
        p.catch(noop);
        return p;
      }
      function unshift(value2) {
        var p = new Promise(function(resolve, reject) {
          unshiftCb(value2, function(err, result) {
            if (err) {
              reject(err);
              return;
            }
            resolve(result);
          });
        });
        p.catch(noop);
        return p;
      }
      function drained() {
        if (queue.idle()) {
          return new Promise(function(resolve) {
            resolve();
          });
        }
        var previousDrain = queue.drain;
        var p = new Promise(function(resolve) {
          queue.drain = function() {
            previousDrain();
            resolve();
          };
        });
        return p;
      }
    }
    module.exports = fastqueue;
    module.exports.promise = queueAsPromised;
  }
});

// node_modules/@nodelib/fs.walk/out/readers/common.js
var require_common2 = __commonJS({
  "node_modules/@nodelib/fs.walk/out/readers/common.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.joinPathSegments = exports.replacePathSegmentSeparator = exports.isAppliedFilter = exports.isFatalError = void 0;
    function isFatalError(settings, error) {
      if (settings.errorFilter === null) {
        return true;
      }
      return !settings.errorFilter(error);
    }
    exports.isFatalError = isFatalError;
    function isAppliedFilter(filter, value2) {
      return filter === null || filter(value2);
    }
    exports.isAppliedFilter = isAppliedFilter;
    function replacePathSegmentSeparator(filepath, separator) {
      return filepath.split(/[/\\]/).join(separator);
    }
    exports.replacePathSegmentSeparator = replacePathSegmentSeparator;
    function joinPathSegments(a, b, separator) {
      if (a === "") {
        return b;
      }
      if (a.endsWith(separator)) {
        return a + b;
      }
      return a + separator + b;
    }
    exports.joinPathSegments = joinPathSegments;
  }
});

// node_modules/@nodelib/fs.walk/out/readers/reader.js
var require_reader = __commonJS({
  "node_modules/@nodelib/fs.walk/out/readers/reader.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var common = require_common2();
    var Reader = class {
      constructor(_root, _settings) {
        this._root = _root;
        this._settings = _settings;
        this._root = common.replacePathSegmentSeparator(_root, _settings.pathSegmentSeparator);
      }
    };
    exports.default = Reader;
  }
});

// node_modules/@nodelib/fs.walk/out/readers/async.js
var require_async4 = __commonJS({
  "node_modules/@nodelib/fs.walk/out/readers/async.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var events_1 = require_events();
    var fsScandir = require_out2();
    var fastq = require_queue();
    var common = require_common2();
    var reader_1 = require_reader();
    var AsyncReader = class extends reader_1.default {
      constructor(_root, _settings) {
        super(_root, _settings);
        this._settings = _settings;
        this._scandir = fsScandir.scandir;
        this._emitter = new events_1.EventEmitter();
        this._queue = fastq(this._worker.bind(this), this._settings.concurrency);
        this._isFatalError = false;
        this._isDestroyed = false;
        this._queue.drain = () => {
          if (!this._isFatalError) {
            this._emitter.emit("end");
          }
        };
      }
      read() {
        this._isFatalError = false;
        this._isDestroyed = false;
        setImmediate(() => {
          this._pushToQueue(this._root, this._settings.basePath);
        });
        return this._emitter;
      }
      get isDestroyed() {
        return this._isDestroyed;
      }
      destroy() {
        if (this._isDestroyed) {
          throw new Error("The reader is already destroyed");
        }
        this._isDestroyed = true;
        this._queue.killAndDrain();
      }
      onEntry(callback) {
        this._emitter.on("entry", callback);
      }
      onError(callback) {
        this._emitter.once("error", callback);
      }
      onEnd(callback) {
        this._emitter.once("end", callback);
      }
      _pushToQueue(directory, base) {
        const queueItem = { directory, base };
        this._queue.push(queueItem, (error) => {
          if (error !== null) {
            this._handleError(error);
          }
        });
      }
      _worker(item, done) {
        this._scandir(item.directory, this._settings.fsScandirSettings, (error, entries) => {
          if (error !== null) {
            done(error, void 0);
            return;
          }
          for (const entry of entries) {
            this._handleEntry(entry, item.base);
          }
          done(null, void 0);
        });
      }
      _handleError(error) {
        if (this._isDestroyed || !common.isFatalError(this._settings, error)) {
          return;
        }
        this._isFatalError = true;
        this._isDestroyed = true;
        this._emitter.emit("error", error);
      }
      _handleEntry(entry, base) {
        if (this._isDestroyed || this._isFatalError) {
          return;
        }
        const fullpath = entry.path;
        if (base !== void 0) {
          entry.path = common.joinPathSegments(base, entry.name, this._settings.pathSegmentSeparator);
        }
        if (common.isAppliedFilter(this._settings.entryFilter, entry)) {
          this._emitEntry(entry);
        }
        if (entry.dirent.isDirectory() && common.isAppliedFilter(this._settings.deepFilter, entry)) {
          this._pushToQueue(fullpath, base === void 0 ? void 0 : entry.path);
        }
      }
      _emitEntry(entry) {
        this._emitter.emit("entry", entry);
      }
    };
    exports.default = AsyncReader;
  }
});

// node_modules/@nodelib/fs.walk/out/providers/async.js
var require_async5 = __commonJS({
  "node_modules/@nodelib/fs.walk/out/providers/async.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var async_1 = require_async4();
    var AsyncProvider = class {
      constructor(_root, _settings) {
        this._root = _root;
        this._settings = _settings;
        this._reader = new async_1.default(this._root, this._settings);
        this._storage = [];
      }
      read(callback) {
        this._reader.onError((error) => {
          callFailureCallback(callback, error);
        });
        this._reader.onEntry((entry) => {
          this._storage.push(entry);
        });
        this._reader.onEnd(() => {
          callSuccessCallback(callback, this._storage);
        });
        this._reader.read();
      }
    };
    exports.default = AsyncProvider;
    function callFailureCallback(callback, error) {
      callback(error);
    }
    function callSuccessCallback(callback, entries) {
      callback(null, entries);
    }
  }
});

// node_modules/@nodelib/fs.walk/out/providers/stream.js
var require_stream3 = __commonJS({
  "node_modules/@nodelib/fs.walk/out/providers/stream.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var stream_1 = require_stream();
    var async_1 = require_async4();
    var StreamProvider = class {
      constructor(_root, _settings) {
        this._root = _root;
        this._settings = _settings;
        this._reader = new async_1.default(this._root, this._settings);
        this._stream = new stream_1.Readable({
          objectMode: true,
          read: () => {
          },
          destroy: () => {
            if (!this._reader.isDestroyed) {
              this._reader.destroy();
            }
          }
        });
      }
      read() {
        this._reader.onError((error) => {
          this._stream.emit("error", error);
        });
        this._reader.onEntry((entry) => {
          this._stream.push(entry);
        });
        this._reader.onEnd(() => {
          this._stream.push(null);
        });
        this._reader.read();
        return this._stream;
      }
    };
    exports.default = StreamProvider;
  }
});

// node_modules/@nodelib/fs.walk/out/readers/sync.js
var require_sync4 = __commonJS({
  "node_modules/@nodelib/fs.walk/out/readers/sync.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var fsScandir = require_out2();
    var common = require_common2();
    var reader_1 = require_reader();
    var SyncReader = class extends reader_1.default {
      constructor() {
        super(...arguments);
        this._scandir = fsScandir.scandirSync;
        this._storage = [];
        this._queue = /* @__PURE__ */ new Set();
      }
      read() {
        this._pushToQueue(this._root, this._settings.basePath);
        this._handleQueue();
        return this._storage;
      }
      _pushToQueue(directory, base) {
        this._queue.add({ directory, base });
      }
      _handleQueue() {
        for (const item of this._queue.values()) {
          this._handleDirectory(item.directory, item.base);
        }
      }
      _handleDirectory(directory, base) {
        try {
          const entries = this._scandir(directory, this._settings.fsScandirSettings);
          for (const entry of entries) {
            this._handleEntry(entry, base);
          }
        } catch (error) {
          this._handleError(error);
        }
      }
      _handleError(error) {
        if (!common.isFatalError(this._settings, error)) {
          return;
        }
        throw error;
      }
      _handleEntry(entry, base) {
        const fullpath = entry.path;
        if (base !== void 0) {
          entry.path = common.joinPathSegments(base, entry.name, this._settings.pathSegmentSeparator);
        }
        if (common.isAppliedFilter(this._settings.entryFilter, entry)) {
          this._pushToStorage(entry);
        }
        if (entry.dirent.isDirectory() && common.isAppliedFilter(this._settings.deepFilter, entry)) {
          this._pushToQueue(fullpath, base === void 0 ? void 0 : entry.path);
        }
      }
      _pushToStorage(entry) {
        this._storage.push(entry);
      }
    };
    exports.default = SyncReader;
  }
});

// node_modules/@nodelib/fs.walk/out/providers/sync.js
var require_sync5 = __commonJS({
  "node_modules/@nodelib/fs.walk/out/providers/sync.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var sync_1 = require_sync4();
    var SyncProvider = class {
      constructor(_root, _settings) {
        this._root = _root;
        this._settings = _settings;
        this._reader = new sync_1.default(this._root, this._settings);
      }
      read() {
        return this._reader.read();
      }
    };
    exports.default = SyncProvider;
  }
});

// node_modules/@nodelib/fs.walk/out/settings.js
var require_settings3 = __commonJS({
  "node_modules/@nodelib/fs.walk/out/settings.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var path = require_path();
    var fsScandir = require_out2();
    var Settings = class {
      constructor(_options = {}) {
        this._options = _options;
        this.basePath = this._getValue(this._options.basePath, void 0);
        this.concurrency = this._getValue(this._options.concurrency, Number.POSITIVE_INFINITY);
        this.deepFilter = this._getValue(this._options.deepFilter, null);
        this.entryFilter = this._getValue(this._options.entryFilter, null);
        this.errorFilter = this._getValue(this._options.errorFilter, null);
        this.pathSegmentSeparator = this._getValue(this._options.pathSegmentSeparator, path.sep);
        this.fsScandirSettings = new fsScandir.Settings({
          followSymbolicLinks: this._options.followSymbolicLinks,
          fs: this._options.fs,
          pathSegmentSeparator: this._options.pathSegmentSeparator,
          stats: this._options.stats,
          throwErrorOnBrokenSymbolicLink: this._options.throwErrorOnBrokenSymbolicLink
        });
      }
      _getValue(option, value2) {
        return option !== null && option !== void 0 ? option : value2;
      }
    };
    exports.default = Settings;
  }
});

// node_modules/@nodelib/fs.walk/out/index.js
var require_out3 = __commonJS({
  "node_modules/@nodelib/fs.walk/out/index.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.Settings = exports.walkStream = exports.walkSync = exports.walk = void 0;
    var async_1 = require_async5();
    var stream_1 = require_stream3();
    var sync_1 = require_sync5();
    var settings_1 = require_settings3();
    exports.Settings = settings_1.default;
    function walk(directory, optionsOrSettingsOrCallback, callback) {
      if (typeof optionsOrSettingsOrCallback === "function") {
        new async_1.default(directory, getSettings()).read(optionsOrSettingsOrCallback);
        return;
      }
      new async_1.default(directory, getSettings(optionsOrSettingsOrCallback)).read(callback);
    }
    exports.walk = walk;
    function walkSync(directory, optionsOrSettings) {
      const settings = getSettings(optionsOrSettings);
      const provider = new sync_1.default(directory, settings);
      return provider.read();
    }
    exports.walkSync = walkSync;
    function walkStream(directory, optionsOrSettings) {
      const settings = getSettings(optionsOrSettings);
      const provider = new stream_1.default(directory, settings);
      return provider.read();
    }
    exports.walkStream = walkStream;
    function getSettings(settingsOrOptions = {}) {
      if (settingsOrOptions instanceof settings_1.default) {
        return settingsOrOptions;
      }
      return new settings_1.default(settingsOrOptions);
    }
  }
});

// node_modules/fast-glob/out/readers/reader.js
var require_reader2 = __commonJS({
  "node_modules/fast-glob/out/readers/reader.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var path = require_path();
    var fsStat = require_out();
    var utils = require_utils3();
    var Reader = class {
      constructor(_settings) {
        this._settings = _settings;
        this._fsStatSettings = new fsStat.Settings({
          followSymbolicLink: this._settings.followSymbolicLinks,
          fs: this._settings.fs,
          throwErrorOnBrokenSymbolicLink: this._settings.followSymbolicLinks
        });
      }
      _getFullEntryPath(filepath) {
        return path.resolve(this._settings.cwd, filepath);
      }
      _makeEntry(stats, pattern) {
        const entry = {
          name: pattern,
          path: pattern,
          dirent: utils.fs.createDirentFromStats(pattern, stats)
        };
        if (this._settings.stats) {
          entry.stats = stats;
        }
        return entry;
      }
      _isFatalError(error) {
        return !utils.errno.isEnoentCodeError(error) && !this._settings.suppressErrors;
      }
    };
    exports.default = Reader;
  }
});

// node_modules/fast-glob/out/readers/stream.js
var require_stream4 = __commonJS({
  "node_modules/fast-glob/out/readers/stream.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var stream_1 = require_stream();
    var fsStat = require_out();
    var fsWalk = require_out3();
    var reader_1 = require_reader2();
    var ReaderStream = class extends reader_1.default {
      constructor() {
        super(...arguments);
        this._walkStream = fsWalk.walkStream;
        this._stat = fsStat.stat;
      }
      dynamic(root, options) {
        return this._walkStream(root, options);
      }
      static(patterns, options) {
        const filepaths = patterns.map(this._getFullEntryPath, this);
        const stream = new stream_1.PassThrough({ objectMode: true });
        stream._write = (index, _enc, done) => {
          return this._getEntry(filepaths[index], patterns[index], options).then((entry) => {
            if (entry !== null && options.entryFilter(entry)) {
              stream.push(entry);
            }
            if (index === filepaths.length - 1) {
              stream.end();
            }
            done();
          }).catch(done);
        };
        for (let i = 0; i < filepaths.length; i++) {
          stream.write(i);
        }
        return stream;
      }
      _getEntry(filepath, pattern, options) {
        return this._getStat(filepath).then((stats) => this._makeEntry(stats, pattern)).catch((error) => {
          if (options.errorFilter(error)) {
            return null;
          }
          throw error;
        });
      }
      _getStat(filepath) {
        return new Promise((resolve, reject) => {
          this._stat(filepath, this._fsStatSettings, (error, stats) => {
            return error === null ? resolve(stats) : reject(error);
          });
        });
      }
    };
    exports.default = ReaderStream;
  }
});

// node_modules/fast-glob/out/readers/async.js
var require_async6 = __commonJS({
  "node_modules/fast-glob/out/readers/async.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var fsWalk = require_out3();
    var reader_1 = require_reader2();
    var stream_1 = require_stream4();
    var ReaderAsync = class extends reader_1.default {
      constructor() {
        super(...arguments);
        this._walkAsync = fsWalk.walk;
        this._readerStream = new stream_1.default(this._settings);
      }
      dynamic(root, options) {
        return new Promise((resolve, reject) => {
          this._walkAsync(root, options, (error, entries) => {
            if (error === null) {
              resolve(entries);
            } else {
              reject(error);
            }
          });
        });
      }
      async static(patterns, options) {
        const entries = [];
        const stream = this._readerStream.static(patterns, options);
        return new Promise((resolve, reject) => {
          stream.once("error", reject);
          stream.on("data", (entry) => entries.push(entry));
          stream.once("end", () => resolve(entries));
        });
      }
    };
    exports.default = ReaderAsync;
  }
});

// node_modules/fast-glob/out/providers/matchers/matcher.js
var require_matcher = __commonJS({
  "node_modules/fast-glob/out/providers/matchers/matcher.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var utils = require_utils3();
    var Matcher = class {
      constructor(_patterns, _settings, _micromatchOptions) {
        this._patterns = _patterns;
        this._settings = _settings;
        this._micromatchOptions = _micromatchOptions;
        this._storage = [];
        this._fillStorage();
      }
      _fillStorage() {
        for (const pattern of this._patterns) {
          const segments = this._getPatternSegments(pattern);
          const sections = this._splitSegmentsIntoSections(segments);
          this._storage.push({
            complete: sections.length <= 1,
            pattern,
            segments,
            sections
          });
        }
      }
      _getPatternSegments(pattern) {
        const parts = utils.pattern.getPatternParts(pattern, this._micromatchOptions);
        return parts.map((part) => {
          const dynamic = utils.pattern.isDynamicPattern(part, this._settings);
          if (!dynamic) {
            return {
              dynamic: false,
              pattern: part
            };
          }
          return {
            dynamic: true,
            pattern: part,
            patternRe: utils.pattern.makeRe(part, this._micromatchOptions)
          };
        });
      }
      _splitSegmentsIntoSections(segments) {
        return utils.array.splitWhen(segments, (segment) => segment.dynamic && utils.pattern.hasGlobStar(segment.pattern));
      }
    };
    exports.default = Matcher;
  }
});

// node_modules/fast-glob/out/providers/matchers/partial.js
var require_partial = __commonJS({
  "node_modules/fast-glob/out/providers/matchers/partial.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var matcher_1 = require_matcher();
    var PartialMatcher = class extends matcher_1.default {
      match(filepath) {
        const parts = filepath.split("/");
        const levels = parts.length;
        const patterns = this._storage.filter((info) => !info.complete || info.segments.length > levels);
        for (const pattern of patterns) {
          const section = pattern.sections[0];
          if (!pattern.complete && levels > section.length) {
            return true;
          }
          const match2 = parts.every((part, index) => {
            const segment = pattern.segments[index];
            if (segment.dynamic && segment.patternRe.test(part)) {
              return true;
            }
            if (!segment.dynamic && segment.pattern === part) {
              return true;
            }
            return false;
          });
          if (match2) {
            return true;
          }
        }
        return false;
      }
    };
    exports.default = PartialMatcher;
  }
});

// node_modules/fast-glob/out/providers/filters/deep.js
var require_deep = __commonJS({
  "node_modules/fast-glob/out/providers/filters/deep.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var utils = require_utils3();
    var partial_1 = require_partial();
    var DeepFilter = class {
      constructor(_settings, _micromatchOptions) {
        this._settings = _settings;
        this._micromatchOptions = _micromatchOptions;
      }
      getFilter(basePath, positive, negative) {
        const matcher = this._getMatcher(positive);
        const negativeRe = this._getNegativePatternsRe(negative);
        return (entry) => this._filter(basePath, entry, matcher, negativeRe);
      }
      _getMatcher(patterns) {
        return new partial_1.default(patterns, this._settings, this._micromatchOptions);
      }
      _getNegativePatternsRe(patterns) {
        const affectDepthOfReadingPatterns = patterns.filter(utils.pattern.isAffectDepthOfReadingPattern);
        return utils.pattern.convertPatternsToRe(affectDepthOfReadingPatterns, this._micromatchOptions);
      }
      _filter(basePath, entry, matcher, negativeRe) {
        if (this._isSkippedByDeep(basePath, entry.path)) {
          return false;
        }
        if (this._isSkippedSymbolicLink(entry)) {
          return false;
        }
        const filepath = utils.path.removeLeadingDotSegment(entry.path);
        if (this._isSkippedByPositivePatterns(filepath, matcher)) {
          return false;
        }
        return this._isSkippedByNegativePatterns(filepath, negativeRe);
      }
      _isSkippedByDeep(basePath, entryPath) {
        if (this._settings.deep === Infinity) {
          return false;
        }
        return this._getEntryLevel(basePath, entryPath) >= this._settings.deep;
      }
      _getEntryLevel(basePath, entryPath) {
        const entryPathDepth = entryPath.split("/").length;
        if (basePath === "") {
          return entryPathDepth;
        }
        const basePathDepth = basePath.split("/").length;
        return entryPathDepth - basePathDepth;
      }
      _isSkippedSymbolicLink(entry) {
        return !this._settings.followSymbolicLinks && entry.dirent.isSymbolicLink();
      }
      _isSkippedByPositivePatterns(entryPath, matcher) {
        return !this._settings.baseNameMatch && !matcher.match(entryPath);
      }
      _isSkippedByNegativePatterns(entryPath, patternsRe) {
        return !utils.pattern.matchAny(entryPath, patternsRe);
      }
    };
    exports.default = DeepFilter;
  }
});

// node_modules/fast-glob/out/providers/filters/entry.js
var require_entry = __commonJS({
  "node_modules/fast-glob/out/providers/filters/entry.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var utils = require_utils3();
    var EntryFilter = class {
      constructor(_settings, _micromatchOptions) {
        this._settings = _settings;
        this._micromatchOptions = _micromatchOptions;
        this.index = /* @__PURE__ */ new Map();
      }
      getFilter(positive, negative) {
        const positiveRe = utils.pattern.convertPatternsToRe(positive, this._micromatchOptions);
        const negativeRe = utils.pattern.convertPatternsToRe(negative, Object.assign(Object.assign({}, this._micromatchOptions), { dot: true }));
        return (entry) => this._filter(entry, positiveRe, negativeRe);
      }
      _filter(entry, positiveRe, negativeRe) {
        const filepath = utils.path.removeLeadingDotSegment(entry.path);
        if (this._settings.unique && this._isDuplicateEntry(filepath)) {
          return false;
        }
        if (this._onlyFileFilter(entry) || this._onlyDirectoryFilter(entry)) {
          return false;
        }
        if (this._isSkippedByAbsoluteNegativePatterns(filepath, negativeRe)) {
          return false;
        }
        const isDirectory = entry.dirent.isDirectory();
        const isMatched = this._isMatchToPatterns(filepath, positiveRe, isDirectory) && !this._isMatchToPatterns(filepath, negativeRe, isDirectory);
        if (this._settings.unique && isMatched) {
          this._createIndexRecord(filepath);
        }
        return isMatched;
      }
      _isDuplicateEntry(filepath) {
        return this.index.has(filepath);
      }
      _createIndexRecord(filepath) {
        this.index.set(filepath, void 0);
      }
      _onlyFileFilter(entry) {
        return this._settings.onlyFiles && !entry.dirent.isFile();
      }
      _onlyDirectoryFilter(entry) {
        return this._settings.onlyDirectories && !entry.dirent.isDirectory();
      }
      _isSkippedByAbsoluteNegativePatterns(entryPath, patternsRe) {
        if (!this._settings.absolute) {
          return false;
        }
        const fullpath = utils.path.makeAbsolute(this._settings.cwd, entryPath);
        return utils.pattern.matchAny(fullpath, patternsRe);
      }
      _isMatchToPatterns(filepath, patternsRe, isDirectory) {
        const isMatched = utils.pattern.matchAny(filepath, patternsRe);
        if (!isMatched && isDirectory) {
          return utils.pattern.matchAny(filepath + "/", patternsRe);
        }
        return isMatched;
      }
    };
    exports.default = EntryFilter;
  }
});

// node_modules/fast-glob/out/providers/filters/error.js
var require_error = __commonJS({
  "node_modules/fast-glob/out/providers/filters/error.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var utils = require_utils3();
    var ErrorFilter = class {
      constructor(_settings) {
        this._settings = _settings;
      }
      getFilter() {
        return (error) => this._isNonFatalError(error);
      }
      _isNonFatalError(error) {
        return utils.errno.isEnoentCodeError(error) || this._settings.suppressErrors;
      }
    };
    exports.default = ErrorFilter;
  }
});

// node_modules/fast-glob/out/providers/transformers/entry.js
var require_entry2 = __commonJS({
  "node_modules/fast-glob/out/providers/transformers/entry.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var utils = require_utils3();
    var EntryTransformer = class {
      constructor(_settings) {
        this._settings = _settings;
      }
      getTransformer() {
        return (entry) => this._transform(entry);
      }
      _transform(entry) {
        let filepath = entry.path;
        if (this._settings.absolute) {
          filepath = utils.path.makeAbsolute(this._settings.cwd, filepath);
          filepath = utils.path.unixify(filepath);
        }
        if (this._settings.markDirectories && entry.dirent.isDirectory()) {
          filepath += "/";
        }
        if (!this._settings.objectMode) {
          return filepath;
        }
        return Object.assign(Object.assign({}, entry), { path: filepath });
      }
    };
    exports.default = EntryTransformer;
  }
});

// node_modules/fast-glob/out/providers/provider.js
var require_provider = __commonJS({
  "node_modules/fast-glob/out/providers/provider.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var path = require_path();
    var deep_1 = require_deep();
    var entry_1 = require_entry();
    var error_1 = require_error();
    var entry_2 = require_entry2();
    var Provider = class {
      constructor(_settings) {
        this._settings = _settings;
        this.errorFilter = new error_1.default(this._settings);
        this.entryFilter = new entry_1.default(this._settings, this._getMicromatchOptions());
        this.deepFilter = new deep_1.default(this._settings, this._getMicromatchOptions());
        this.entryTransformer = new entry_2.default(this._settings);
      }
      _getRootDirectory(task) {
        return path.resolve(this._settings.cwd, task.base);
      }
      _getReaderOptions(task) {
        const basePath = task.base === "." ? "" : task.base;
        return {
          basePath,
          pathSegmentSeparator: "/",
          concurrency: this._settings.concurrency,
          deepFilter: this.deepFilter.getFilter(basePath, task.positive, task.negative),
          entryFilter: this.entryFilter.getFilter(task.positive, task.negative),
          errorFilter: this.errorFilter.getFilter(),
          followSymbolicLinks: this._settings.followSymbolicLinks,
          fs: this._settings.fs,
          stats: this._settings.stats,
          throwErrorOnBrokenSymbolicLink: this._settings.throwErrorOnBrokenSymbolicLink,
          transform: this.entryTransformer.getTransformer()
        };
      }
      _getMicromatchOptions() {
        return {
          dot: this._settings.dot,
          matchBase: this._settings.baseNameMatch,
          nobrace: !this._settings.braceExpansion,
          nocase: !this._settings.caseSensitiveMatch,
          noext: !this._settings.extglob,
          noglobstar: !this._settings.globstar,
          posix: true,
          strictSlashes: false
        };
      }
    };
    exports.default = Provider;
  }
});

// node_modules/fast-glob/out/providers/async.js
var require_async7 = __commonJS({
  "node_modules/fast-glob/out/providers/async.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var async_1 = require_async6();
    var provider_1 = require_provider();
    var ProviderAsync = class extends provider_1.default {
      constructor() {
        super(...arguments);
        this._reader = new async_1.default(this._settings);
      }
      async read(task) {
        const root = this._getRootDirectory(task);
        const options = this._getReaderOptions(task);
        const entries = await this.api(root, task, options);
        return entries.map((entry) => options.transform(entry));
      }
      api(root, task, options) {
        if (task.dynamic) {
          return this._reader.dynamic(root, options);
        }
        return this._reader.static(task.patterns, options);
      }
    };
    exports.default = ProviderAsync;
  }
});

// node_modules/fast-glob/out/providers/stream.js
var require_stream5 = __commonJS({
  "node_modules/fast-glob/out/providers/stream.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var stream_1 = require_stream();
    var stream_2 = require_stream4();
    var provider_1 = require_provider();
    var ProviderStream = class extends provider_1.default {
      constructor() {
        super(...arguments);
        this._reader = new stream_2.default(this._settings);
      }
      read(task) {
        const root = this._getRootDirectory(task);
        const options = this._getReaderOptions(task);
        const source = this.api(root, task, options);
        const destination = new stream_1.Readable({ objectMode: true, read: () => {
        } });
        source.once("error", (error) => destination.emit("error", error)).on("data", (entry) => destination.emit("data", options.transform(entry))).once("end", () => destination.emit("end"));
        destination.once("close", () => source.destroy());
        return destination;
      }
      api(root, task, options) {
        if (task.dynamic) {
          return this._reader.dynamic(root, options);
        }
        return this._reader.static(task.patterns, options);
      }
    };
    exports.default = ProviderStream;
  }
});

// node_modules/fast-glob/out/readers/sync.js
var require_sync6 = __commonJS({
  "node_modules/fast-glob/out/readers/sync.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var fsStat = require_out();
    var fsWalk = require_out3();
    var reader_1 = require_reader2();
    var ReaderSync = class extends reader_1.default {
      constructor() {
        super(...arguments);
        this._walkSync = fsWalk.walkSync;
        this._statSync = fsStat.statSync;
      }
      dynamic(root, options) {
        return this._walkSync(root, options);
      }
      static(patterns, options) {
        const entries = [];
        for (const pattern of patterns) {
          const filepath = this._getFullEntryPath(pattern);
          const entry = this._getEntry(filepath, pattern, options);
          if (entry === null || !options.entryFilter(entry)) {
            continue;
          }
          entries.push(entry);
        }
        return entries;
      }
      _getEntry(filepath, pattern, options) {
        try {
          const stats = this._getStat(filepath);
          return this._makeEntry(stats, pattern);
        } catch (error) {
          if (options.errorFilter(error)) {
            return null;
          }
          throw error;
        }
      }
      _getStat(filepath) {
        return this._statSync(filepath, this._fsStatSettings);
      }
    };
    exports.default = ReaderSync;
  }
});

// node_modules/fast-glob/out/providers/sync.js
var require_sync7 = __commonJS({
  "node_modules/fast-glob/out/providers/sync.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    var sync_1 = require_sync6();
    var provider_1 = require_provider();
    var ProviderSync = class extends provider_1.default {
      constructor() {
        super(...arguments);
        this._reader = new sync_1.default(this._settings);
      }
      read(task) {
        const root = this._getRootDirectory(task);
        const options = this._getReaderOptions(task);
        const entries = this.api(root, task, options);
        return entries.map(options.transform);
      }
      api(root, task, options) {
        if (task.dynamic) {
          return this._reader.dynamic(root, options);
        }
        return this._reader.static(task.patterns, options);
      }
    };
    exports.default = ProviderSync;
  }
});

// node_modules/fast-glob/out/settings.js
var require_settings4 = __commonJS({
  "node_modules/fast-glob/out/settings.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", { value: true });
    exports.DEFAULT_FILE_SYSTEM_ADAPTER = void 0;
    var fs = require_fs();
    var os = require_os();
    var CPU_COUNT = Math.max(os.cpus().length, 1);
    exports.DEFAULT_FILE_SYSTEM_ADAPTER = {
      lstat: fs.lstat,
      lstatSync: fs.lstatSync,
      stat: fs.stat,
      statSync: fs.statSync,
      readdir: fs.readdir,
      readdirSync: fs.readdirSync
    };
    var Settings = class {
      constructor(_options = {}) {
        this._options = _options;
        this.absolute = this._getValue(this._options.absolute, false);
        this.baseNameMatch = this._getValue(this._options.baseNameMatch, false);
        this.braceExpansion = this._getValue(this._options.braceExpansion, true);
        this.caseSensitiveMatch = this._getValue(this._options.caseSensitiveMatch, true);
        this.concurrency = this._getValue(this._options.concurrency, CPU_COUNT);
        this.cwd = this._getValue(this._options.cwd, process.cwd());
        this.deep = this._getValue(this._options.deep, Infinity);
        this.dot = this._getValue(this._options.dot, false);
        this.extglob = this._getValue(this._options.extglob, true);
        this.followSymbolicLinks = this._getValue(this._options.followSymbolicLinks, true);
        this.fs = this._getFileSystemMethods(this._options.fs);
        this.globstar = this._getValue(this._options.globstar, true);
        this.ignore = this._getValue(this._options.ignore, []);
        this.markDirectories = this._getValue(this._options.markDirectories, false);
        this.objectMode = this._getValue(this._options.objectMode, false);
        this.onlyDirectories = this._getValue(this._options.onlyDirectories, false);
        this.onlyFiles = this._getValue(this._options.onlyFiles, true);
        this.stats = this._getValue(this._options.stats, false);
        this.suppressErrors = this._getValue(this._options.suppressErrors, false);
        this.throwErrorOnBrokenSymbolicLink = this._getValue(this._options.throwErrorOnBrokenSymbolicLink, false);
        this.unique = this._getValue(this._options.unique, true);
        if (this.onlyDirectories) {
          this.onlyFiles = false;
        }
        if (this.stats) {
          this.objectMode = true;
        }
        this.ignore = [].concat(this.ignore);
      }
      _getValue(option, value2) {
        return option === void 0 ? value2 : option;
      }
      _getFileSystemMethods(methods = {}) {
        return Object.assign(Object.assign({}, exports.DEFAULT_FILE_SYSTEM_ADAPTER), methods);
      }
    };
    exports.default = Settings;
  }
});

// node_modules/fast-glob/out/index.js
var require_out4 = __commonJS({
  "node_modules/fast-glob/out/index.js"(exports, module) {
    "use strict";
    var taskManager = require_tasks();
    var async_1 = require_async7();
    var stream_1 = require_stream5();
    var sync_1 = require_sync7();
    var settings_1 = require_settings4();
    var utils = require_utils3();
    async function FastGlob(source, options) {
      assertPatternsInput(source);
      const works = getWorks(source, async_1.default, options);
      const result = await Promise.all(works);
      return utils.array.flatten(result);
    }
    (function(FastGlob2) {
      FastGlob2.glob = FastGlob2;
      FastGlob2.globSync = sync;
      FastGlob2.globStream = stream;
      FastGlob2.async = FastGlob2;
      function sync(source, options) {
        assertPatternsInput(source);
        const works = getWorks(source, sync_1.default, options);
        return utils.array.flatten(works);
      }
      FastGlob2.sync = sync;
      function stream(source, options) {
        assertPatternsInput(source);
        const works = getWorks(source, stream_1.default, options);
        return utils.stream.merge(works);
      }
      FastGlob2.stream = stream;
      function generateTasks(source, options) {
        assertPatternsInput(source);
        const patterns = [].concat(source);
        const settings = new settings_1.default(options);
        return taskManager.generate(patterns, settings);
      }
      FastGlob2.generateTasks = generateTasks;
      function isDynamicPattern(source, options) {
        assertPatternsInput(source);
        const settings = new settings_1.default(options);
        return utils.pattern.isDynamicPattern(source, settings);
      }
      FastGlob2.isDynamicPattern = isDynamicPattern;
      function escapePath(source) {
        assertPatternsInput(source);
        return utils.path.escape(source);
      }
      FastGlob2.escapePath = escapePath;
      function convertPathToPattern(source) {
        assertPatternsInput(source);
        return utils.path.convertPathToPattern(source);
      }
      FastGlob2.convertPathToPattern = convertPathToPattern;
      let posix;
      (function(posix2) {
        function escapePath2(source) {
          assertPatternsInput(source);
          return utils.path.escapePosixPath(source);
        }
        posix2.escapePath = escapePath2;
        function convertPathToPattern2(source) {
          assertPatternsInput(source);
          return utils.path.convertPosixPathToPattern(source);
        }
        posix2.convertPathToPattern = convertPathToPattern2;
      })(posix = FastGlob2.posix || (FastGlob2.posix = {}));
      let win32;
      (function(win322) {
        function escapePath2(source) {
          assertPatternsInput(source);
          return utils.path.escapeWindowsPath(source);
        }
        win322.escapePath = escapePath2;
        function convertPathToPattern2(source) {
          assertPatternsInput(source);
          return utils.path.convertWindowsPathToPattern(source);
        }
        win322.convertPathToPattern = convertPathToPattern2;
      })(win32 = FastGlob2.win32 || (FastGlob2.win32 = {}));
    })(FastGlob || (FastGlob = {}));
    function getWorks(source, _Provider, options) {
      const patterns = [].concat(source);
      const settings = new settings_1.default(options);
      const tasks = taskManager.generate(patterns, settings);
      const provider = new _Provider(settings);
      return tasks.map(provider.read, provider);
    }
    function assertPatternsInput(input2) {
      const source = [].concat(input2);
      const isValidSource = source.every((item) => utils.string.isString(item) && !utils.string.isEmpty(item));
      if (!isValidSource) {
        throw new TypeError("Patterns must be a string (non empty) or an array of strings");
      }
    }
    module.exports = FastGlob;
  }
});

// node_modules/normalize-path/index.js
var require_normalize_path = __commonJS({
  "node_modules/normalize-path/index.js"(exports, module) {
    module.exports = function(path, stripTrailing) {
      if (typeof path !== "string") {
        throw new TypeError("expected path to be a string");
      }
      if (path === "\\" || path === "/")
        return "/";
      var len = path.length;
      if (len <= 1)
        return path;
      var prefix = "";
      if (len > 4 && path[3] === "\\") {
        var ch = path[2];
        if ((ch === "?" || ch === ".") && path.slice(0, 2) === "\\\\") {
          path = path.slice(2);
          prefix = "//";
        }
      }
      var segs = path.split(/[/\\]+/);
      if (stripTrailing !== false && segs[segs.length - 1] === "") {
        segs.pop();
      }
      return prefix + segs.join("/");
    };
  }
});

// node_modules/glob-parent/index.js
var require_glob_parent2 = __commonJS({
  "node_modules/glob-parent/index.js"(exports, module) {
    "use strict";
    var isGlob = require_is_glob();
    var pathPosixDirname = require_path().posix.dirname;
    var isWin32 = require_os().platform() === "win32";
    var slash = "/";
    var backslash = /\\/g;
    var escaped = /\\([!*?|[\](){}])/g;
    module.exports = function globParent(str, opts) {
      var options = Object.assign({ flipBackslashes: true }, opts);
      if (options.flipBackslashes && isWin32 && str.indexOf(slash) < 0) {
        str = str.replace(backslash, slash);
      }
      if (isEnclosure(str)) {
        str += slash;
      }
      str += "a";
      do {
        str = pathPosixDirname(str);
      } while (isGlobby(str));
      return str.replace(escaped, "$1");
    };
    function isEnclosure(str) {
      var lastChar = str.slice(-1);
      var enclosureStart;
      switch (lastChar) {
        case "}":
          enclosureStart = "{";
          break;
        case "]":
          enclosureStart = "[";
          break;
        default:
          return false;
      }
      var foundIndex = str.indexOf(enclosureStart);
      if (foundIndex < 0) {
        return false;
      }
      return str.slice(foundIndex + 1, -1).includes(slash);
    }
    function isGlobby(str) {
      if (/\([^()]+$/.test(str)) {
        return true;
      }
      if (str[0] === "{" || str[0] === "[") {
        return true;
      }
      if (/[^\\][{[]/.test(str)) {
        return true;
      }
      return isGlob(str);
    }
  }
});

// node_modules/tailwindcss/lib/util/parseGlob.js
var require_parseGlob = __commonJS({
  "node_modules/tailwindcss/lib/util/parseGlob.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    Object.defineProperty(exports, "parseGlob", {
      enumerable: true,
      get: function() {
        return parseGlob;
      }
    });
    var _globparent = _interop_require_default(require_glob_parent2());
    function _interop_require_default(obj) {
      return obj && obj.__esModule ? obj : {
        default: obj
      };
    }
    function parseGlob(pattern) {
      let glob = pattern;
      let base = (0, _globparent.default)(pattern);
      if (base !== ".") {
        glob = pattern.substr(base.length);
        if (glob.charAt(0) === "/") {
          glob = glob.substr(1);
        }
      }
      if (glob.substr(0, 2) === "./") {
        glob = glob.substr(2);
      }
      if (glob.charAt(0) === "/") {
        glob = glob.substr(1);
      }
      return {
        base,
        glob
      };
    }
  }
});

// node_modules/tailwindcss/lib/lib/content.js
var require_content = __commonJS({
  "node_modules/tailwindcss/lib/lib/content.js"(exports) {
    "use strict";
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    function _export(target, all) {
      for (var name in all)
        Object.defineProperty(target, name, {
          enumerable: true,
          get: all[name]
        });
    }
    _export(exports, {
      parseCandidateFiles: function() {
        return parseCandidateFiles;
      },
      resolvedChangedContent: function() {
        return resolvedChangedContent;
      }
    });
    var _fs = _interop_require_default(require_fs());
    var _path = _interop_require_default(require_path());
    var _isglob = _interop_require_default(require_is_glob());
    var _fastglob = _interop_require_default(require_out4());
    var _normalizepath = _interop_require_default(require_normalize_path());
    var _parseGlob = require_parseGlob();
    var _sharedState = require_sharedState();
    function _interop_require_default(obj) {
      return obj && obj.__esModule ? obj : {
        default: obj
      };
    }
    function parseCandidateFiles(context, tailwindConfig) {
      let files = tailwindConfig.content.files;
      files = files.filter((filePath) => typeof filePath === "string");
      files = files.map(_normalizepath.default);
      let tasks = _fastglob.default.generateTasks(files);
      let included = [];
      let excluded = [];
      for (const task of tasks) {
        included.push(...task.positive.map((filePath) => parseFilePath(filePath, false)));
        excluded.push(...task.negative.map((filePath) => parseFilePath(filePath, true)));
      }
      let paths = [
        ...included,
        ...excluded
      ];
      paths = resolveRelativePaths(context, paths);
      paths = paths.flatMap(resolvePathSymlinks);
      paths = paths.map(resolveGlobPattern);
      return paths;
    }
    function parseFilePath(filePath, ignore) {
      let contentPath = {
        original: filePath,
        base: filePath,
        ignore,
        pattern: filePath,
        glob: null
      };
      if ((0, _isglob.default)(filePath)) {
        Object.assign(contentPath, (0, _parseGlob.parseGlob)(filePath));
      }
      return contentPath;
    }
    function resolveGlobPattern(contentPath) {
      let base = (0, _normalizepath.default)(contentPath.base);
      base = _fastglob.default.escapePath(base);
      contentPath.pattern = contentPath.glob ? `${base}/${contentPath.glob}` : base;
      contentPath.pattern = contentPath.ignore ? `!${contentPath.pattern}` : contentPath.pattern;
      return contentPath;
    }
    function resolveRelativePaths(context, contentPaths) {
      let resolveFrom = [];
      if (context.userConfigPath && context.tailwindConfig.content.relative) {
        resolveFrom = [
          _path.default.dirname(context.userConfigPath)
        ];
      }
      return contentPaths.map((contentPath) => {
        contentPath.base = _path.default.resolve(...resolveFrom, contentPath.base);
        return contentPath;
      });
    }
    function resolvePathSymlinks(contentPath) {
      let paths = [
        contentPath
      ];
      try {
        let resolvedPath = _fs.default.realpathSync(contentPath.base);
        if (resolvedPath !== contentPath.base) {
          paths.push({
            ...contentPath,
            base: resolvedPath
          });
        }
      } catch {
      }
      return paths;
    }
    function resolvedChangedContent(context, candidateFiles, fileModifiedMap) {
      let changedContent = context.tailwindConfig.content.files.filter((item) => typeof item.raw === "string").map(({ raw, extension = "html" }) => ({
        content: raw,
        extension
      }));
      let [changedFiles, mTimesToCommit] = resolveChangedFiles(candidateFiles, fileModifiedMap);
      for (let changedFile of changedFiles) {
        let extension = _path.default.extname(changedFile).slice(1);
        changedContent.push({
          file: changedFile,
          extension
        });
      }
      return [
        changedContent,
        mTimesToCommit
      ];
    }
    function resolveChangedFiles(candidateFiles, fileModifiedMap) {
      let paths = candidateFiles.map((contentPath) => contentPath.pattern);
      let mTimesToCommit = /* @__PURE__ */ new Map();
      let changedFiles = /* @__PURE__ */ new Set();
      _sharedState.env.DEBUG && console.time("Finding changed files");
      let files = _fastglob.default.sync(paths, {
        absolute: true
      });
      for (let file of files) {
        let prevModified = fileModifiedMap.get(file) || -Infinity;
        let modified = _fs.default.statSync(file).mtimeMs;
        if (modified > prevModified) {
          changedFiles.add(file);
          mTimesToCommit.set(file, modified);
        }
      }
      _sharedState.env.DEBUG && console.timeEnd("Finding changed files");
      return [
        changedFiles,
        mTimesToCommit
      ];
    }
  }
});

// browser-external:module
var require_module = __commonJS({
  "browser-external:module"(exports, module) {
    module.exports = Object.create(new Proxy({}, {
      get(_, key) {
        if (key !== "__esModule" && key !== "__proto__" && key !== "constructor" && key !== "splice") {
          console.warn(`Module "module" has been externalized for browser compatibility. Cannot access "module.${key}" in client code. See http://vitejs.dev/guide/troubleshooting.html#module-externalized-for-browser-compatibility for more details.`);
        }
      }
    }));
  }
});

// browser-external:perf_hooks
var require_perf_hooks = __commonJS({
  "browser-external:perf_hooks"(exports, module) {
    module.exports = Object.create(new Proxy({}, {
      get(_, key) {
        if (key !== "__esModule" && key !== "__proto__" && key !== "constructor" && key !== "splice") {
          console.warn(`Module "perf_hooks" has been externalized for browser compatibility. Cannot access "perf_hooks.${key}" in client code. See http://vitejs.dev/guide/troubleshooting.html#module-externalized-for-browser-compatibility for more details.`);
        }
      }
    }));
  }
});

// browser-external:vm
var require_vm = __commonJS({
  "browser-external:vm"(exports, module) {
    module.exports = Object.create(new Proxy({}, {
      get(_, key) {
        if (key !== "__esModule" && key !== "__proto__" && key !== "constructor" && key !== "splice") {
          console.warn(`Module "vm" has been externalized for browser compatibility. Cannot access "vm.${key}" in client code. See http://vitejs.dev/guide/troubleshooting.html#module-externalized-for-browser-compatibility for more details.`);
        }
      }
    }));
  }
});

// browser-external:assert
var require_assert = __commonJS({
  "browser-external:assert"(exports, module) {
    module.exports = Object.create(new Proxy({}, {
      get(_, key) {
        if (key !== "__esModule" && key !== "__proto__" && key !== "constructor" && key !== "splice") {
          console.warn(`Module "assert" has been externalized for browser compatibility. Cannot access "assert.${key}" in client code. See http://vitejs.dev/guide/troubleshooting.html#module-externalized-for-browser-compatibility for more details.`);
        }
      }
    }));
  }
});

// browser-external:process
var require_process = __commonJS({
  "browser-external:process"(exports, module) {
    module.exports = Object.create(new Proxy({}, {
      get(_, key) {
        if (key !== "__esModule" && key !== "__proto__" && key !== "constructor" && key !== "splice") {
          console.warn(`Module "process" has been externalized for browser compatibility. Cannot access "process.${key}" in client code. See http://vitejs.dev/guide/troubleshooting.html#module-externalized-for-browser-compatibility for more details.`);
        }
      }
    }));
  }
});

// browser-external:v8
var require_v8 = __commonJS({
  "browser-external:v8"(exports, module) {
    module.exports = Object.create(new Proxy({}, {
      get(_, key) {
        if (key !== "__esModule" && key !== "__proto__" && key !== "constructor" && key !== "splice") {
          console.warn(`Module "v8" has been externalized for browser compatibility. Cannot access "v8.${key}" in client code. See http://vitejs.dev/guide/troubleshooting.html#module-externalized-for-browser-compatibility for more details.`);
        }
      }
    }));
  }
});

// node_modules/jiti/dist/jiti.js
var require_jiti = __commonJS({
  "node_modules/jiti/dist/jiti.js"(exports, module) {
    (() => {
      var __webpack_modules__ = { "./node_modules/.pnpm/create-require@1.1.1/node_modules/create-require/create-require.js": (module2, __unused_webpack_exports, __webpack_require__2) => {
        const nativeModule = __webpack_require__2("module"), path = __webpack_require__2("path"), fs = __webpack_require__2("fs");
        module2.exports = function(filename) {
          return filename || (filename = process.cwd()), function(path2) {
            try {
              return fs.lstatSync(path2).isDirectory();
            } catch (e) {
              return false;
            }
          }(filename) && (filename = path.join(filename, "index.js")), nativeModule.createRequire ? nativeModule.createRequire(filename) : nativeModule.createRequireFromPath ? nativeModule.createRequireFromPath(filename) : function(filename2) {
            const mod = new nativeModule.Module(filename2, null);
            return mod.filename = filename2, mod.paths = nativeModule.Module._nodeModulePaths(path.dirname(filename2)), mod._compile("module.exports = require;", filename2), mod.exports;
          }(filename);
        };
      }, "./node_modules/.pnpm/mlly@1.7.1/node_modules/mlly/dist lazy recursive": (module2) => {
        function webpackEmptyAsyncContext(req) {
          return Promise.resolve().then(() => {
            var e = new Error("Cannot find module '" + req + "'");
            throw e.code = "MODULE_NOT_FOUND", e;
          });
        }
        webpackEmptyAsyncContext.keys = () => [], webpackEmptyAsyncContext.resolve = webpackEmptyAsyncContext, webpackEmptyAsyncContext.id = "./node_modules/.pnpm/mlly@1.7.1/node_modules/mlly/dist lazy recursive", module2.exports = webpackEmptyAsyncContext;
      }, "./node_modules/.pnpm/object-hash@3.0.0/node_modules/object-hash/index.js": (module2, exports2, __webpack_require__2) => {
        "use strict";
        var crypto = __webpack_require__2("crypto");
        function objectHash(object, options) {
          return function(object2, options2) {
            var hashingStream;
            hashingStream = "passthrough" !== options2.algorithm ? crypto.createHash(options2.algorithm) : new PassThrough();
            void 0 === hashingStream.write && (hashingStream.write = hashingStream.update, hashingStream.end = hashingStream.update);
            var hasher = typeHasher(options2, hashingStream);
            hasher.dispatch(object2), hashingStream.update || hashingStream.end("");
            if (hashingStream.digest)
              return hashingStream.digest("buffer" === options2.encoding ? void 0 : options2.encoding);
            var buf = hashingStream.read();
            if ("buffer" === options2.encoding)
              return buf;
            return buf.toString(options2.encoding);
          }(object, options = applyDefaults(object, options));
        }
        (exports2 = module2.exports = objectHash).sha1 = function(object) {
          return objectHash(object);
        }, exports2.keys = function(object) {
          return objectHash(object, { excludeValues: true, algorithm: "sha1", encoding: "hex" });
        }, exports2.MD5 = function(object) {
          return objectHash(object, { algorithm: "md5", encoding: "hex" });
        }, exports2.keysMD5 = function(object) {
          return objectHash(object, { algorithm: "md5", encoding: "hex", excludeValues: true });
        };
        var hashes = crypto.getHashes ? crypto.getHashes().slice() : ["sha1", "md5"];
        hashes.push("passthrough");
        var encodings = ["buffer", "hex", "binary", "base64"];
        function applyDefaults(object, sourceOptions) {
          sourceOptions = sourceOptions || {};
          var options = {};
          if (options.algorithm = sourceOptions.algorithm || "sha1", options.encoding = sourceOptions.encoding || "hex", options.excludeValues = !!sourceOptions.excludeValues, options.algorithm = options.algorithm.toLowerCase(), options.encoding = options.encoding.toLowerCase(), options.ignoreUnknown = true === sourceOptions.ignoreUnknown, options.respectType = false !== sourceOptions.respectType, options.respectFunctionNames = false !== sourceOptions.respectFunctionNames, options.respectFunctionProperties = false !== sourceOptions.respectFunctionProperties, options.unorderedArrays = true === sourceOptions.unorderedArrays, options.unorderedSets = false !== sourceOptions.unorderedSets, options.unorderedObjects = false !== sourceOptions.unorderedObjects, options.replacer = sourceOptions.replacer || void 0, options.excludeKeys = sourceOptions.excludeKeys || void 0, void 0 === object)
            throw new Error("Object argument required.");
          for (var i = 0; i < hashes.length; ++i)
            hashes[i].toLowerCase() === options.algorithm.toLowerCase() && (options.algorithm = hashes[i]);
          if (-1 === hashes.indexOf(options.algorithm))
            throw new Error('Algorithm "' + options.algorithm + '"  not supported. supported values: ' + hashes.join(", "));
          if (-1 === encodings.indexOf(options.encoding) && "passthrough" !== options.algorithm)
            throw new Error('Encoding "' + options.encoding + '"  not supported. supported values: ' + encodings.join(", "));
          return options;
        }
        function isNativeFunction(f) {
          if ("function" != typeof f)
            return false;
          return null != /^function\s+\w*\s*\(\s*\)\s*{\s+\[native code\]\s+}$/i.exec(Function.prototype.toString.call(f));
        }
        function typeHasher(options, writeTo, context) {
          context = context || [];
          var write = function(str) {
            return writeTo.update ? writeTo.update(str, "utf8") : writeTo.write(str, "utf8");
          };
          return { dispatch: function(value2) {
            options.replacer && (value2 = options.replacer(value2));
            var type = typeof value2;
            return null === value2 && (type = "null"), this["_" + type](value2);
          }, _object: function(object) {
            var objString = Object.prototype.toString.call(object), objType = /\[object (.*)\]/i.exec(objString);
            objType = (objType = objType ? objType[1] : "unknown:[" + objString + "]").toLowerCase();
            var objectNumber;
            if ((objectNumber = context.indexOf(object)) >= 0)
              return this.dispatch("[CIRCULAR:" + objectNumber + "]");
            if (context.push(object), "undefined" != typeof Buffer && Buffer.isBuffer && Buffer.isBuffer(object))
              return write("buffer:"), write(object);
            if ("object" === objType || "function" === objType || "asyncfunction" === objType) {
              var keys = Object.keys(object);
              options.unorderedObjects && (keys = keys.sort()), false === options.respectType || isNativeFunction(object) || keys.splice(0, 0, "prototype", "__proto__", "constructor"), options.excludeKeys && (keys = keys.filter(function(key) {
                return !options.excludeKeys(key);
              })), write("object:" + keys.length + ":");
              var self2 = this;
              return keys.forEach(function(key) {
                self2.dispatch(key), write(":"), options.excludeValues || self2.dispatch(object[key]), write(",");
              });
            }
            if (!this["_" + objType]) {
              if (options.ignoreUnknown)
                return write("[" + objType + "]");
              throw new Error('Unknown object type "' + objType + '"');
            }
            this["_" + objType](object);
          }, _array: function(arr, unordered) {
            unordered = void 0 !== unordered ? unordered : false !== options.unorderedArrays;
            var self2 = this;
            if (write("array:" + arr.length + ":"), !unordered || arr.length <= 1)
              return arr.forEach(function(entry) {
                return self2.dispatch(entry);
              });
            var contextAdditions = [], entries = arr.map(function(entry) {
              var strm = new PassThrough(), localContext = context.slice();
              return typeHasher(options, strm, localContext).dispatch(entry), contextAdditions = contextAdditions.concat(localContext.slice(context.length)), strm.read().toString();
            });
            return context = context.concat(contextAdditions), entries.sort(), this._array(entries, false);
          }, _date: function(date) {
            return write("date:" + date.toJSON());
          }, _symbol: function(sym) {
            return write("symbol:" + sym.toString());
          }, _error: function(err) {
            return write("error:" + err.toString());
          }, _boolean: function(bool) {
            return write("bool:" + bool.toString());
          }, _string: function(string) {
            write("string:" + string.length + ":"), write(string.toString());
          }, _function: function(fn) {
            write("fn:"), isNativeFunction(fn) ? this.dispatch("[native]") : this.dispatch(fn.toString()), false !== options.respectFunctionNames && this.dispatch("function-name:" + String(fn.name)), options.respectFunctionProperties && this._object(fn);
          }, _number: function(number) {
            return write("number:" + number.toString());
          }, _xml: function(xml) {
            return write("xml:" + xml.toString());
          }, _null: function() {
            return write("Null");
          }, _undefined: function() {
            return write("Undefined");
          }, _regexp: function(regex) {
            return write("regex:" + regex.toString());
          }, _uint8array: function(arr) {
            return write("uint8array:"), this.dispatch(Array.prototype.slice.call(arr));
          }, _uint8clampedarray: function(arr) {
            return write("uint8clampedarray:"), this.dispatch(Array.prototype.slice.call(arr));
          }, _int8array: function(arr) {
            return write("int8array:"), this.dispatch(Array.prototype.slice.call(arr));
          }, _uint16array: function(arr) {
            return write("uint16array:"), this.dispatch(Array.prototype.slice.call(arr));
          }, _int16array: function(arr) {
            return write("int16array:"), this.dispatch(Array.prototype.slice.call(arr));
          }, _uint32array: function(arr) {
            return write("uint32array:"), this.dispatch(Array.prototype.slice.call(arr));
          }, _int32array: function(arr) {
            return write("int32array:"), this.dispatch(Array.prototype.slice.call(arr));
          }, _float32array: function(arr) {
            return write("float32array:"), this.dispatch(Array.prototype.slice.call(arr));
          }, _float64array: function(arr) {
            return write("float64array:"), this.dispatch(Array.prototype.slice.call(arr));
          }, _arraybuffer: function(arr) {
            return write("arraybuffer:"), this.dispatch(new Uint8Array(arr));
          }, _url: function(url) {
            return write("url:" + url.toString());
          }, _map: function(map) {
            write("map:");
            var arr = Array.from(map);
            return this._array(arr, false !== options.unorderedSets);
          }, _set: function(set) {
            write("set:");
            var arr = Array.from(set);
            return this._array(arr, false !== options.unorderedSets);
          }, _file: function(file) {
            return write("file:"), this.dispatch([file.name, file.size, file.type, file.lastModfied]);
          }, _blob: function() {
            if (options.ignoreUnknown)
              return write("[blob]");
            throw Error('Hashing Blob objects is currently not supported\n(see https://github.com/puleos/object-hash/issues/26)\nUse "options.replacer" or "options.ignoreUnknown"\n');
          }, _domwindow: function() {
            return write("domwindow");
          }, _bigint: function(number) {
            return write("bigint:" + number.toString());
          }, _process: function() {
            return write("process");
          }, _timer: function() {
            return write("timer");
          }, _pipe: function() {
            return write("pipe");
          }, _tcp: function() {
            return write("tcp");
          }, _udp: function() {
            return write("udp");
          }, _tty: function() {
            return write("tty");
          }, _statwatcher: function() {
            return write("statwatcher");
          }, _securecontext: function() {
            return write("securecontext");
          }, _connection: function() {
            return write("connection");
          }, _zlib: function() {
            return write("zlib");
          }, _context: function() {
            return write("context");
          }, _nodescript: function() {
            return write("nodescript");
          }, _httpparser: function() {
            return write("httpparser");
          }, _dataview: function() {
            return write("dataview");
          }, _signal: function() {
            return write("signal");
          }, _fsevent: function() {
            return write("fsevent");
          }, _tlswrap: function() {
            return write("tlswrap");
          } };
        }
        function PassThrough() {
          return { buf: "", write: function(b) {
            this.buf += b;
          }, end: function(b) {
            this.buf += b;
          }, read: function() {
            return this.buf;
          } };
        }
        exports2.writeToStream = function(object, options, stream) {
          return void 0 === stream && (stream = options, options = {}), typeHasher(options = applyDefaults(object, options), stream).dispatch(object);
        };
      }, "./node_modules/.pnpm/pirates@4.0.6/node_modules/pirates/lib/index.js": (module2, exports2, __webpack_require__2) => {
        "use strict";
        module2 = __webpack_require__2.nmd(module2), Object.defineProperty(exports2, "__esModule", { value: true }), exports2.addHook = function(hook, opts = {}) {
          let reverted = false;
          const loaders = [], oldLoaders = [];
          let exts;
          const originalJSLoader = Module._extensions[".js"], matcher = opts.matcher || null, ignoreNodeModules = false !== opts.ignoreNodeModules;
          exts = opts.extensions || opts.exts || opts.extension || opts.ext || [".js"], Array.isArray(exts) || (exts = [exts]);
          return exts.forEach((ext) => {
            if ("string" != typeof ext)
              throw new TypeError(`Invalid Extension: ${ext}`);
            const oldLoader = Module._extensions[ext] || originalJSLoader;
            oldLoaders[ext] = Module._extensions[ext], loaders[ext] = Module._extensions[ext] = function(mod, filename) {
              let compile;
              reverted || function(filename2, exts2, matcher2, ignoreNodeModules2) {
                if ("string" != typeof filename2)
                  return false;
                if (-1 === exts2.indexOf(_path.default.extname(filename2)))
                  return false;
                const resolvedFilename = _path.default.resolve(filename2);
                if (ignoreNodeModules2 && nodeModulesRegex.test(resolvedFilename))
                  return false;
                if (matcher2 && "function" == typeof matcher2)
                  return !!matcher2(resolvedFilename);
                return true;
              }(filename, exts, matcher, ignoreNodeModules) && (compile = mod._compile, mod._compile = function(code) {
                mod._compile = compile;
                const newCode = hook(code, filename);
                if ("string" != typeof newCode)
                  throw new Error(HOOK_RETURNED_NOTHING_ERROR_MESSAGE);
                return mod._compile(newCode, filename);
              }), oldLoader(mod, filename);
            };
          }), function() {
            reverted || (reverted = true, exts.forEach((ext) => {
              Module._extensions[ext] === loaders[ext] && (oldLoaders[ext] ? Module._extensions[ext] = oldLoaders[ext] : delete Module._extensions[ext]);
            }));
          };
        };
        var _module = _interopRequireDefault(__webpack_require__2("module")), _path = _interopRequireDefault(__webpack_require__2("path"));
        function _interopRequireDefault(obj) {
          return obj && obj.__esModule ? obj : { default: obj };
        }
        const nodeModulesRegex = /^(?:.*[\\/])?node_modules(?:[\\/].*)?$/, Module = module2.constructor.length > 1 ? module2.constructor : _module.default, HOOK_RETURNED_NOTHING_ERROR_MESSAGE = "[Pirates] A hook returned a non-string, or nothing at all! This is a violation of intergalactic law!\n--------------------\nIf you have no idea what this means or what Pirates is, let me explain: Pirates is a module that makes is easy to implement require hooks. One of the require hooks you're using uses it. One of these require hooks didn't return anything from it's handler, so we don't know what to do. You might want to debug this.";
      }, "./node_modules/.pnpm/semver@7.6.2/node_modules/semver/classes/comparator.js": (module2, __unused_webpack_exports, __webpack_require__2) => {
        const ANY = Symbol("SemVer ANY");
        class Comparator {
          static get ANY() {
            return ANY;
          }
          constructor(comp, options) {
            if (options = parseOptions(options), comp instanceof Comparator) {
              if (comp.loose === !!options.loose)
                return comp;
              comp = comp.value;
            }
            comp = comp.trim().split(/\s+/).join(" "), debug("comparator", comp, options), this.options = options, this.loose = !!options.loose, this.parse(comp), this.semver === ANY ? this.value = "" : this.value = this.operator + this.semver.version, debug("comp", this);
          }
          parse(comp) {
            const r = this.options.loose ? re[t2.COMPARATORLOOSE] : re[t2.COMPARATOR], m = comp.match(r);
            if (!m)
              throw new TypeError(`Invalid comparator: ${comp}`);
            this.operator = void 0 !== m[1] ? m[1] : "", "=" === this.operator && (this.operator = ""), m[2] ? this.semver = new SemVer(m[2], this.options.loose) : this.semver = ANY;
          }
          toString() {
            return this.value;
          }
          test(version) {
            if (debug("Comparator.test", version, this.options.loose), this.semver === ANY || version === ANY)
              return true;
            if ("string" == typeof version)
              try {
                version = new SemVer(version, this.options);
              } catch (er) {
                return false;
              }
            return cmp(version, this.operator, this.semver, this.options);
          }
          intersects(comp, options) {
            if (!(comp instanceof Comparator))
              throw new TypeError("a Comparator is required");
            return "" === this.operator ? "" === this.value || new Range(comp.value, options).test(this.value) : "" === comp.operator ? "" === comp.value || new Range(this.value, options).test(comp.semver) : (!(options = parseOptions(options)).includePrerelease || "<0.0.0-0" !== this.value && "<0.0.0-0" !== comp.value) && (!(!options.includePrerelease && (this.value.startsWith("<0.0.0") || comp.value.startsWith("<0.0.0"))) && (!(!this.operator.startsWith(">") || !comp.operator.startsWith(">")) || (!(!this.operator.startsWith("<") || !comp.operator.startsWith("<")) || (!(this.semver.version !== comp.semver.version || !this.operator.includes("=") || !comp.operator.includes("=")) || (!!(cmp(this.semver, "<", comp.semver, options) && this.operator.startsWith(">") && comp.operator.startsWith("<")) || !!(cmp(this.semver, ">", comp.semver, options) && this.operator.startsWith("<") && comp.operator.startsWith(">")))))));
          }
        }
        module2.exports = Comparator;
        const parseOptions = __webpack_require__2("./node_modules/.pnpm/semver@7.6.2/node_modules/semver/internal/parse-options.js"), { safeRe: re, t: t2 } = __webpack_require__2("./node_modules/.pnpm/semver@7.6.2/node_modules/semver/internal/re.js"), cmp = __webpack_require__2("./node_modules/.pnpm/semver@7.6.2/node_modules/semver/functions/cmp.js"), debug = __webpack_require__2("./node_modules/.pnpm/semver@7.6.2/node_modules/semver/internal/debug.js"), SemVer = __webpack_require__2("./node_modules/.pnpm/semver@7.6.2/node_modules/semver/classes/semver.js"), Range = __webpack_require__2("./node_modules/.pnpm/semver@7.6.2/node_modules/semver/classes/range.js");
      }, "./node_modules/.pnpm/semver@7.6.2/node_modules/semver/classes/range.js": (module2, __unused_webpack_exports, __webpack_require__2) => {
        class Range {
          constructor(range, options) {
            if (options = parseOptions(options), range instanceof Range)
              return range.loose === !!options.loose && range.includePrerelease === !!options.includePrerelease ? range : new Range(range.raw, options);
            if (range instanceof Comparator)
              return this.raw = range.value, this.set = [[range]], this.format(), this;
            if (this.options = options, this.loose = !!options.loose, this.includePrerelease = !!options.includePrerelease, this.raw = range.trim().split(/\s+/).join(" "), this.set = this.raw.split("||").map((r) => this.parseRange(r.trim())).filter((c) => c.length), !this.set.length)
              throw new TypeError(`Invalid SemVer Range: ${this.raw}`);
            if (this.set.length > 1) {
              const first = this.set[0];
              if (this.set = this.set.filter((c) => !isNullSet(c[0])), 0 === this.set.length)
                this.set = [first];
              else if (this.set.length > 1) {
                for (const c of this.set)
                  if (1 === c.length && isAny(c[0])) {
                    this.set = [c];
                    break;
                  }
              }
            }
            this.format();
          }
          format() {
            return this.range = this.set.map((comps) => comps.join(" ").trim()).join("||").trim(), this.range;
          }
          toString() {
            return this.range;
          }
          parseRange(range) {
            const memoKey = ((this.options.includePrerelease && FLAG_INCLUDE_PRERELEASE) | (this.options.loose && FLAG_LOOSE)) + ":" + range, cached = cache.get(memoKey);
            if (cached)
              return cached;
            const loose = this.options.loose, hr = loose ? re[t2.HYPHENRANGELOOSE] : re[t2.HYPHENRANGE];
            range = range.replace(hr, hyphenReplace(this.options.includePrerelease)), debug("hyphen replace", range), range = range.replace(re[t2.COMPARATORTRIM], comparatorTrimReplace), debug("comparator trim", range), range = range.replace(re[t2.TILDETRIM], tildeTrimReplace), debug("tilde trim", range), range = range.replace(re[t2.CARETTRIM], caretTrimReplace), debug("caret trim", range);
            let rangeList = range.split(" ").map((comp) => parseComparator(comp, this.options)).join(" ").split(/\s+/).map((comp) => replaceGTE0(comp, this.options));
            loose && (rangeList = rangeList.filter((comp) => (debug("loose invalid filter", comp, this.options), !!comp.match(re[t2.COMPARATORLOOSE])))), debug("range list", rangeList);
            const rangeMap = /* @__PURE__ */ new Map(), comparators = rangeList.map((comp) => new Comparator(comp, this.options));
            for (const comp of comparators) {
              if (isNullSet(comp))
                return [comp];
              rangeMap.set(comp.value, comp);
            }
            rangeMap.size > 1 && rangeMap.has("") && rangeMap.delete("");
            const result = [...rangeMap.values()];
            return cache.set(memoKey, result), result;
          }
          intersects(range, options) {
            if (!(range instanceof Range))
              throw new TypeError("a Range is required");
            return this.set.some((thisComparators) => isSatisfiable(thisComparators, options) && range.set.some((rangeComparators) => isSatisfiable(rangeComparators, options) && thisComparators.every((thisComparator) => rangeComparators.every((rangeComparator) => thisComparator.intersects(rangeComparator, options)))));
          }
          test(version) {
            if (!version)
              return false;
            if ("string" == typeof version)
              try {
                version = new SemVer(version, this.options);
              } catch (er) {
                return false;
              }
            for (let i = 0; i < this.set.length; i++)
              if (testSet(this.set[i], version, this.options))
                return true;
            return false;
          }
        }
        module2.exports = Range;
        const cache = new (__webpack_require__2("./node_modules/.pnpm/semver@7.6.2/node_modules/semver/internal/lrucache.js"))(), parseOptions = __webpack_require__2("./node_modules/.pnpm/semver@7.6.2/node_modules/semver/internal/parse-options.js"), Comparator = __webpack_require__2("./node_modules/.pnpm/semver@7.6.2/node_modules/semver/classes/comparator.js"), debug = __webpack_require__2("./node_modules/.pnpm/semver@7.6.2/node_modules/semver/internal/debug.js"), SemVer = __webpack_require__2("./node_modules/.pnpm/semver@7.6.2/node_modules/semver/classes/semver.js"), { safeRe: re, t: t2, comparatorTrimReplace, tildeTrimReplace, caretTrimReplace } = __webpack_require__2("./node_modules/.pnpm/semver@7.6.2/node_modules/semver/internal/re.js"), { FLAG_INCLUDE_PRERELEASE, FLAG_LOOSE } = __webpack_require__2("./node_modules/.pnpm/semver@7.6.2/node_modules/semver/internal/constants.js"), isNullSet = (c) => "<0.0.0-0" === c.value, isAny = (c) => "" === c.value, isSatisfiable = (comparators, options) => {
          let result = true;
          const remainingComparators = comparators.slice();
          let testComparator = remainingComparators.pop();
          for (; result && remainingComparators.length; )
            result = remainingComparators.every((otherComparator) => testComparator.intersects(otherComparator, options)), testComparator = remainingComparators.pop();
          return result;
        }, parseComparator = (comp, options) => (debug("comp", comp, options), comp = replaceCarets(comp, options), debug("caret", comp), comp = replaceTildes(comp, options), debug("tildes", comp), comp = replaceXRanges(comp, options), debug("xrange", comp), comp = replaceStars(comp, options), debug("stars", comp), comp), isX = (id) => !id || "x" === id.toLowerCase() || "*" === id, replaceTildes = (comp, options) => comp.trim().split(/\s+/).map((c) => replaceTilde(c, options)).join(" "), replaceTilde = (comp, options) => {
          const r = options.loose ? re[t2.TILDELOOSE] : re[t2.TILDE];
          return comp.replace(r, (_, M, m, p, pr) => {
            let ret;
            return debug("tilde", comp, _, M, m, p, pr), isX(M) ? ret = "" : isX(m) ? ret = `>=${M}.0.0 <${+M + 1}.0.0-0` : isX(p) ? ret = `>=${M}.${m}.0 <${M}.${+m + 1}.0-0` : pr ? (debug("replaceTilde pr", pr), ret = `>=${M}.${m}.${p}-${pr} <${M}.${+m + 1}.0-0`) : ret = `>=${M}.${m}.${p} <${M}.${+m + 1}.0-0`, debug("tilde return", ret), ret;
          });
        }, replaceCarets = (comp, options) => comp.trim().split(/\s+/).map((c) => replaceCaret(c, options)).join(" "), replaceCaret = (comp, options) => {
          debug("caret", comp, options);
          const r = options.loose ? re[t2.CARETLOOSE] : re[t2.CARET], z = options.includePrerelease ? "-0" : "";
          return comp.replace(r, (_, M, m, p, pr) => {
            let ret;
            return debug("caret", comp, _, M, m, p, pr), isX(M) ? ret = "" : isX(m) ? ret = `>=${M}.0.0${z} <${+M + 1}.0.0-0` : isX(p) ? ret = "0" === M ? `>=${M}.${m}.0${z} <${M}.${+m + 1}.0-0` : `>=${M}.${m}.0${z} <${+M + 1}.0.0-0` : pr ? (debug("replaceCaret pr", pr), ret = "0" === M ? "0" === m ? `>=${M}.${m}.${p}-${pr} <${M}.${m}.${+p + 1}-0` : `>=${M}.${m}.${p}-${pr} <${M}.${+m + 1}.0-0` : `>=${M}.${m}.${p}-${pr} <${+M + 1}.0.0-0`) : (debug("no pr"), ret = "0" === M ? "0" === m ? `>=${M}.${m}.${p}${z} <${M}.${m}.${+p + 1}-0` : `>=${M}.${m}.${p}${z} <${M}.${+m + 1}.0-0` : `>=${M}.${m}.${p} <${+M + 1}.0.0-0`), debug("caret return", ret), ret;
          });
        }, replaceXRanges = (comp, options) => (debug("replaceXRanges", comp, options), comp.split(/\s+/).map((c) => replaceXRange(c, options)).join(" ")), replaceXRange = (comp, options) => {
          comp = comp.trim();
          const r = options.loose ? re[t2.XRANGELOOSE] : re[t2.XRANGE];
          return comp.replace(r, (ret, gtlt, M, m, p, pr) => {
            debug("xRange", comp, ret, gtlt, M, m, p, pr);
            const xM = isX(M), xm = xM || isX(m), xp = xm || isX(p), anyX = xp;
            return "=" === gtlt && anyX && (gtlt = ""), pr = options.includePrerelease ? "-0" : "", xM ? ret = ">" === gtlt || "<" === gtlt ? "<0.0.0-0" : "*" : gtlt && anyX ? (xm && (m = 0), p = 0, ">" === gtlt ? (gtlt = ">=", xm ? (M = +M + 1, m = 0, p = 0) : (m = +m + 1, p = 0)) : "<=" === gtlt && (gtlt = "<", xm ? M = +M + 1 : m = +m + 1), "<" === gtlt && (pr = "-0"), ret = `${gtlt + M}.${m}.${p}${pr}`) : xm ? ret = `>=${M}.0.0${pr} <${+M + 1}.0.0-0` : xp && (ret = `>=${M}.${m}.0${pr} <${M}.${+m + 1}.0-0`), debug("xRange return", ret), ret;
          });
        }, replaceStars = (comp, options) => (debug("replaceStars", comp, options), comp.trim().replace(re[t2.STAR], "")), replaceGTE0 = (comp, options) => (debug("replaceGTE0", comp, options), comp.trim().replace(re[options.includePrerelease ? t2.GTE0PRE : t2.GTE0], "")), hyphenReplace = (incPr) => ($0, from, fM, fm, fp, fpr, fb, to, tM, tm, tp, tpr) => `${from = isX(fM) ? "" : isX(fm) ? `>=${fM}.0.0${incPr ? "-0" : ""}` : isX(fp) ? `>=${fM}.${fm}.0${incPr ? "-0" : ""}` : fpr ? `>=${from}` : `>=${from}${incPr ? "-0" : ""}`} ${to = isX(tM) ? "" : isX(tm) ? `<${+tM + 1}.0.0-0` : isX(tp) ? `<${tM}.${+tm + 1}.0-0` : tpr ? `<=${tM}.${tm}.${tp}-${tpr}` : incPr ? `<${tM}.${tm}.${+tp + 1}-0` : `<=${to}`}`.trim(), testSet = (set, version, options) => {
          for (let i = 0; i < set.length; i++)
            if (!set[i].test(version))
              return false;
          if (version.prerelease.length && !options.includePrerelease) {
            for (let i = 0; i < set.length; i++)
              if (debug(set[i].semver), set[i].semver !== Comparator.ANY && set[i].semver.prerelease.length > 0) {
                const allowed = set[i].semver;
                if (allowed.major === version.major && allowed.minor === version.minor && allowed.patch === version.patch)
                  return true;
              }
            return false;
          }
          return true;
        };
      }, "./node_modules/.pnpm/semver@7.6.2/node_modules/semver/classes/semver.js": (module2, __unused_webpack_exports, __webpack_require__2) => {
        const debug = __webpack_require__2("./node_modules/.pnpm/semver@7.6.2/node_modules/semver/internal/debug.js"), { MAX_LENGTH, MAX_SAFE_INTEGER } = __webpack_require__2("./node_modules/.pnpm/semver@7.6.2/node_modules/semver/internal/constants.js"), { safeRe: re, t: t2 } = __webpack_require__2("./node_modules/.pnpm/semver@7.6.2/node_modules/semver/internal/re.js"), parseOptions = __webpack_require__2("./node_modules/.pnpm/semver@7.6.2/node_modules/semver/internal/parse-options.js"), { compareIdentifiers } = __webpack_require__2("./node_modules/.pnpm/semver@7.6.2/node_modules/semver/internal/identifiers.js");
        class SemVer {
          constructor(version, options) {
            if (options = parseOptions(options), version instanceof SemVer) {
              if (version.loose === !!options.loose && version.includePrerelease === !!options.includePrerelease)
                return version;
              version = version.version;
            } else if ("string" != typeof version)
              throw new TypeError(`Invalid version. Must be a string. Got type "${typeof version}".`);
            if (version.length > MAX_LENGTH)
              throw new TypeError(`version is longer than ${MAX_LENGTH} characters`);
            debug("SemVer", version, options), this.options = options, this.loose = !!options.loose, this.includePrerelease = !!options.includePrerelease;
            const m = version.trim().match(options.loose ? re[t2.LOOSE] : re[t2.FULL]);
            if (!m)
              throw new TypeError(`Invalid Version: ${version}`);
            if (this.raw = version, this.major = +m[1], this.minor = +m[2], this.patch = +m[3], this.major > MAX_SAFE_INTEGER || this.major < 0)
              throw new TypeError("Invalid major version");
            if (this.minor > MAX_SAFE_INTEGER || this.minor < 0)
              throw new TypeError("Invalid minor version");
            if (this.patch > MAX_SAFE_INTEGER || this.patch < 0)
              throw new TypeError("Invalid patch version");
            m[4] ? this.prerelease = m[4].split(".").map((id) => {
              if (/^[0-9]+$/.test(id)) {
                const num = +id;
                if (num >= 0 && num < MAX_SAFE_INTEGER)
                  return num;
              }
              return id;
            }) : this.prerelease = [], this.build = m[5] ? m[5].split(".") : [], this.format();
          }
          format() {
            return this.version = `${this.major}.${this.minor}.${this.patch}`, this.prerelease.length && (this.version += `-${this.prerelease.join(".")}`), this.version;
          }
          toString() {
            return this.version;
          }
          compare(other) {
            if (debug("SemVer.compare", this.version, this.options, other), !(other instanceof SemVer)) {
              if ("string" == typeof other && other === this.version)
                return 0;
              other = new SemVer(other, this.options);
            }
            return other.version === this.version ? 0 : this.compareMain(other) || this.comparePre(other);
          }
          compareMain(other) {
            return other instanceof SemVer || (other = new SemVer(other, this.options)), compareIdentifiers(this.major, other.major) || compareIdentifiers(this.minor, other.minor) || compareIdentifiers(this.patch, other.patch);
          }
          comparePre(other) {
            if (other instanceof SemVer || (other = new SemVer(other, this.options)), this.prerelease.length && !other.prerelease.length)
              return -1;
            if (!this.prerelease.length && other.prerelease.length)
              return 1;
            if (!this.prerelease.length && !other.prerelease.length)
              return 0;
            let i = 0;
            do {
              const a = this.prerelease[i], b = other.prerelease[i];
              if (debug("prerelease compare", i, a, b), void 0 === a && void 0 === b)
                return 0;
              if (void 0 === b)
                return 1;
              if (void 0 === a)
                return -1;
              if (a !== b)
                return compareIdentifiers(a, b);
            } while (++i);
          }
          compareBuild(other) {
            other instanceof SemVer || (other = new SemVer(other, this.options));
            let i = 0;
            do {
              const a = this.build[i], b = other.build[i];
              if (debug("build compare", i, a, b), void 0 === a && void 0 === b)
                return 0;
              if (void 0 === b)
                return 1;
              if (void 0 === a)
                return -1;
              if (a !== b)
                return compareIdentifiers(a, b);
            } while (++i);
          }
          inc(release, identifier, identifierBase) {
            switch (release) {
              case "premajor":
                this.prerelease.length = 0, this.patch = 0, this.minor = 0, this.major++, this.inc("pre", identifier, identifierBase);
                break;
              case "preminor":
                this.prerelease.length = 0, this.patch = 0, this.minor++, this.inc("pre", identifier, identifierBase);
                break;
              case "prepatch":
                this.prerelease.length = 0, this.inc("patch", identifier, identifierBase), this.inc("pre", identifier, identifierBase);
                break;
              case "prerelease":
                0 === this.prerelease.length && this.inc("patch", identifier, identifierBase), this.inc("pre", identifier, identifierBase);
                break;
              case "major":
                0 === this.minor && 0 === this.patch && 0 !== this.prerelease.length || this.major++, this.minor = 0, this.patch = 0, this.prerelease = [];
                break;
              case "minor":
                0 === this.patch && 0 !== this.prerelease.length || this.minor++, this.patch = 0, this.prerelease = [];
                break;
              case "patch":
                0 === this.prerelease.length && this.patch++, this.prerelease = [];
                break;
              case "pre": {
                const base = Number(identifierBase) ? 1 : 0;
                if (!identifier && false === identifierBase)
                  throw new Error("invalid increment argument: identifier is empty");
                if (0 === this.prerelease.length)
                  this.prerelease = [base];
                else {
                  let i = this.prerelease.length;
                  for (; --i >= 0; )
                    "number" == typeof this.prerelease[i] && (this.prerelease[i]++, i = -2);
                  if (-1 === i) {
                    if (identifier === this.prerelease.join(".") && false === identifierBase)
                      throw new Error("invalid increment argument: identifier already exists");
                    this.prerelease.push(base);
                  }
                }
                if (identifier) {
                  let prerelease = [identifier, base];
                  false === identifierBase && (prerelease = [identifier]), 0 === compareIdentifiers(this.prerelease[0], identifier) ? isNaN(this.prerelease[1]) && (this.prerelease = prerelease) : this.prerelease = prerelease;
                }
                break;
              }
              default:
                throw new Error(`invalid increment argument: ${release}`);
            }
            return this.raw = this.format(), this.build.length && (this.raw += `+${this.build.join(".")}`), this;
          }
        }
        module2.exports = SemVer;
      }, "./node_modules/.pnpm/semver@7.6.2/node_modules/semver/functions/clean.js": (module2, __unused_webpack_exports, __webpack_require__2) => {
        const parse2 = __webpack_require__2("./node_modules/.pnpm/semver@7.6.2/node_modules/semver/functions/parse.js");
        module2.exports = (version, options) => {
          const s = parse2(version.trim().replace(/^[=v]+/, ""), options);
          return s ? s.version : null;
        };
      }, "./node_modules/.pnpm/semver@7.6.2/node_modules/semver/functions/cmp.js": (module2, __unused_webpack_exports, __webpack_require__2) => {
        const eq = __webpack_require__2("./node_modules/.pnpm/semver@7.6.2/node_modules/semver/functions/eq.js"), neq = __webpack_require__2("./node_modules/.pnpm/semver@7.6.2/node_modules/semver/functions/neq.js"), gt = __webpack_require__2("./node_modules/.pnpm/semver@7.6.2/node_modules/semver/functions/gt.js"), gte = __webpack_require__2("./node_modules/.pnpm/semver@7.6.2/node_modules/semver/functions/gte.js"), lt = __webpack_require__2("./node_modules/.pnpm/semver@7.6.2/node_modules/semver/functions/lt.js"), lte = __webpack_require__2("./node_modules/.pnpm/semver@7.6.2/node_modules/semver/functions/lte.js");
        module2.exports = (a, op, b, loose) => {
          switch (op) {
            case "===":
              return "object" == typeof a && (a = a.version), "object" == typeof b && (b = b.version), a === b;
            case "!==":
              return "object" == typeof a && (a = a.version), "object" == typeof b && (b = b.version), a !== b;
            case "":
            case "=":
            case "==":
              return eq(a, b, loose);
            case "!=":
              return neq(a, b, loose);
            case ">":
              return gt(a, b, loose);
            case ">=":
              return gte(a, b, loose);
            case "<":
              return lt(a, b, loose);
            case "<=":
              return lte(a, b, loose);
            default:
              throw new TypeError(`Invalid operator: ${op}`);
          }
        };
      }, "./node_modules/.pnpm/semver@7.6.2/node_modules/semver/functions/coerce.js": (module2, __unused_webpack_exports, __webpack_require__2) => {
        const SemVer = __webpack_require__2("./node_modules/.pnpm/semver@7.6.2/node_modules/semver/classes/semver.js"), parse2 = __webpack_require__2("./node_modules/.pnpm/semver@7.6.2/node_modules/semver/functions/parse.js"), { safeRe: re, t: t2 } = __webpack_require__2("./node_modules/.pnpm/semver@7.6.2/node_modules/semver/internal/re.js");
        module2.exports = (version, options) => {
          if (version instanceof SemVer)
            return version;
          if ("number" == typeof version && (version = String(version)), "string" != typeof version)
            return null;
          let match2 = null;
          if ((options = options || {}).rtl) {
            const coerceRtlRegex = options.includePrerelease ? re[t2.COERCERTLFULL] : re[t2.COERCERTL];
            let next2;
            for (; (next2 = coerceRtlRegex.exec(version)) && (!match2 || match2.index + match2[0].length !== version.length); )
              match2 && next2.index + next2[0].length === match2.index + match2[0].length || (match2 = next2), coerceRtlRegex.lastIndex = next2.index + next2[1].length + next2[2].length;
            coerceRtlRegex.lastIndex = -1;
          } else
            match2 = version.match(options.includePrerelease ? re[t2.COERCEFULL] : re[t2.COERCE]);
          if (null === match2)
            return null;
          const major = match2[2], minor = match2[3] || "0", patch = match2[4] || "0", prerelease = options.includePrerelease && match2[5] ? `-${match2[5]}` : "", build = options.includePrerelease && match2[6] ? `+${match2[6]}` : "";
          return parse2(`${major}.${minor}.${patch}${prerelease}${build}`, options);
        };
      }, "./node_modules/.pnpm/semver@7.6.2/node_modules/semver/functions/compare-build.js": (module2, __unused_webpack_exports, __webpack_require__2) => {
        const SemVer = __webpack_require__2("./node_modules/.pnpm/semver@7.6.2/node_modules/semver/classes/semver.js");
        module2.exports = (a, b, loose) => {
          const versionA = new SemVer(a, loose), versionB = new SemVer(b, loose);
          return versionA.compare(versionB) || versionA.compareBuild(versionB);
        };
      }, "./node_modules/.pnpm/semver@7.6.2/node_modules/semver/functions/compare-loose.js": (module2, __unused_webpack_exports, __webpack_require__2) => {
        const compare = __webpack_require__2("./node_modules/.pnpm/semver@7.6.2/node_modules/semver/functions/compare.js");
        module2.exports = (a, b) => compare(a, b, true);
      }, "./node_modules/.pnpm/semver@7.6.2/node_modules/semver/functions/compare.js": (module2, __unused_webpack_exports, __webpack_require__2) => {
        const SemVer = __webpack_require__2("./node_modules/.pnpm/semver@7.6.2/node_modules/semver/classes/semver.js");
        module2.exports = (a, b, loose) => new SemVer(a, loose).compare(new SemVer(b, loose));
      }, "./node_modules/.pnpm/semver@7.6.2/node_modules/semver/functions/diff.js": (module2, __unused_webpack_exports, __webpack_require__2) => {
        const parse2 = __webpack_require__2("./node_modules/.pnpm/semver@7.6.2/node_modules/semver/functions/parse.js");
        module2.exports = (version1, version2) => {
          const v1 = parse2(version1, null, true), v2 = parse2(version2, null, true), comparison = v1.compare(v2);
          if (0 === comparison)
            return null;
          const v1Higher = comparison > 0, highVersion = v1Higher ? v1 : v2, lowVersion = v1Higher ? v2 : v1, highHasPre = !!highVersion.prerelease.length;
          if (!!lowVersion.prerelease.length && !highHasPre)
            return lowVersion.patch || lowVersion.minor ? highVersion.patch ? "patch" : highVersion.minor ? "minor" : "major" : "major";
          const prefix = highHasPre ? "pre" : "";
          return v1.major !== v2.major ? prefix + "major" : v1.minor !== v2.minor ? prefix + "minor" : v1.patch !== v2.patch ? prefix + "patch" : "prerelease";
        };
      }, "./node_modules/.pnpm/semver@7.6.2/node_modules/semver/functions/eq.js": (module2, __unused_webpack_exports, __webpack_require__2) => {
        const compare = __webpack_require__2("./node_modules/.pnpm/semver@7.6.2/node_modules/semver/functions/compare.js");
        module2.exports = (a, b, loose) => 0 === compare(a, b, loose);
      }, "./node_modules/.pnpm/semver@7.6.2/node_modules/semver/functions/gt.js": (module2, __unused_webpack_exports, __webpack_require__2) => {
        const compare = __webpack_require__2("./node_modules/.pnpm/semver@7.6.2/node_modules/semver/functions/compare.js");
        module2.exports = (a, b, loose) => compare(a, b, loose) > 0;
      }, "./node_modules/.pnpm/semver@7.6.2/node_modules/semver/functions/gte.js": (module2, __unused_webpack_exports, __webpack_require__2) => {
        const compare = __webpack_require__2("./node_modules/.pnpm/semver@7.6.2/node_modules/semver/functions/compare.js");
        module2.exports = (a, b, loose) => compare(a, b, loose) >= 0;
      }, "./node_modules/.pnpm/semver@7.6.2/node_modules/semver/functions/inc.js": (module2, __unused_webpack_exports, __webpack_require__2) => {
        const SemVer = __webpack_require__2("./node_modules/.pnpm/semver@7.6.2/node_modules/semver/classes/semver.js");
        module2.exports = (version, release, options, identifier, identifierBase) => {
          "string" == typeof options && (identifierBase = identifier, identifier = options, options = void 0);
          try {
            return new SemVer(version instanceof SemVer ? version.version : version, options).inc(release, identifier, identifierBase).version;
          } catch (er) {
            return null;
          }
        };
      }, "./node_modules/.pnpm/semver@7.6.2/node_modules/semver/functions/lt.js": (module2, __unused_webpack_exports, __webpack_require__2) => {
        const compare = __webpack_require__2("./node_modules/.pnpm/semver@7.6.2/node_modules/semver/functions/compare.js");
        module2.exports = (a, b, loose) => compare(a, b, loose) < 0;
      }, "./node_modules/.pnpm/semver@7.6.2/node_modules/semver/functions/lte.js": (module2, __unused_webpack_exports, __webpack_require__2) => {
        const compare = __webpack_require__2("./node_modules/.pnpm/semver@7.6.2/node_modules/semver/functions/compare.js");
        module2.exports = (a, b, loose) => compare(a, b, loose) <= 0;
      }, "./node_modules/.pnpm/semver@7.6.2/node_modules/semver/functions/major.js": (module2, __unused_webpack_exports, __webpack_require__2) => {
        const SemVer = __webpack_require__2("./node_modules/.pnpm/semver@7.6.2/node_modules/semver/classes/semver.js");
        module2.exports = (a, loose) => new SemVer(a, loose).major;
      }, "./node_modules/.pnpm/semver@7.6.2/node_modules/semver/functions/minor.js": (module2, __unused_webpack_exports, __webpack_require__2) => {
        const SemVer = __webpack_require__2("./node_modules/.pnpm/semver@7.6.2/node_modules/semver/classes/semver.js");
        module2.exports = (a, loose) => new SemVer(a, loose).minor;
      }, "./node_modules/.pnpm/semver@7.6.2/node_modules/semver/functions/neq.js": (module2, __unused_webpack_exports, __webpack_require__2) => {
        const compare = __webpack_require__2("./node_modules/.pnpm/semver@7.6.2/node_modules/semver/functions/compare.js");
        module2.exports = (a, b, loose) => 0 !== compare(a, b, loose);
      }, "./node_modules/.pnpm/semver@7.6.2/node_modules/semver/functions/parse.js": (module2, __unused_webpack_exports, __webpack_require__2) => {
        const SemVer = __webpack_require__2("./node_modules/.pnpm/semver@7.6.2/node_modules/semver/classes/semver.js");
        module2.exports = (version, options, throwErrors = false) => {
          if (version instanceof SemVer)
            return version;
          try {
            return new SemVer(version, options);
          } catch (er) {
            if (!throwErrors)
              return null;
            throw er;
          }
        };
      }, "./node_modules/.pnpm/semver@7.6.2/node_modules/semver/functions/patch.js": (module2, __unused_webpack_exports, __webpack_require__2) => {
        const SemVer = __webpack_require__2("./node_modules/.pnpm/semver@7.6.2/node_modules/semver/classes/semver.js");
        module2.exports = (a, loose) => new SemVer(a, loose).patch;
      }, "./node_modules/.pnpm/semver@7.6.2/node_modules/semver/functions/prerelease.js": (module2, __unused_webpack_exports, __webpack_require__2) => {
        const parse2 = __webpack_require__2("./node_modules/.pnpm/semver@7.6.2/node_modules/semver/functions/parse.js");
        module2.exports = (version, options) => {
          const parsed = parse2(version, options);
          return parsed && parsed.prerelease.length ? parsed.prerelease : null;
        };
      }, "./node_modules/.pnpm/semver@7.6.2/node_modules/semver/functions/rcompare.js": (module2, __unused_webpack_exports, __webpack_require__2) => {
        const compare = __webpack_require__2("./node_modules/.pnpm/semver@7.6.2/node_modules/semver/functions/compare.js");
        module2.exports = (a, b, loose) => compare(b, a, loose);
      }, "./node_modules/.pnpm/semver@7.6.2/node_modules/semver/functions/rsort.js": (module2, __unused_webpack_exports, __webpack_require__2) => {
        const compareBuild = __webpack_require__2("./node_modules/.pnpm/semver@7.6.2/node_modules/semver/functions/compare-build.js");
        module2.exports = (list, loose) => list.sort((a, b) => compareBuild(b, a, loose));
      }, "./node_modules/.pnpm/semver@7.6.2/node_modules/semver/functions/satisfies.js": (module2, __unused_webpack_exports, __webpack_require__2) => {
        const Range = __webpack_require__2("./node_modules/.pnpm/semver@7.6.2/node_modules/semver/classes/range.js");
        module2.exports = (version, range, options) => {
          try {
            range = new Range(range, options);
          } catch (er) {
            return false;
          }
          return range.test(version);
        };
      }, "./node_modules/.pnpm/semver@7.6.2/node_modules/semver/functions/sort.js": (module2, __unused_webpack_exports, __webpack_require__2) => {
        const compareBuild = __webpack_require__2("./node_modules/.pnpm/semver@7.6.2/node_modules/semver/functions/compare-build.js");
        module2.exports = (list, loose) => list.sort((a, b) => compareBuild(a, b, loose));
      }, "./node_modules/.pnpm/semver@7.6.2/node_modules/semver/functions/valid.js": (module2, __unused_webpack_exports, __webpack_require__2) => {
        const parse2 = __webpack_require__2("./node_modules/.pnpm/semver@7.6.2/node_modules/semver/functions/parse.js");
        module2.exports = (version, options) => {
          const v = parse2(version, options);
          return v ? v.version : null;
        };
      }, "./node_modules/.pnpm/semver@7.6.2/node_modules/semver/index.js": (module2, __unused_webpack_exports, __webpack_require__2) => {
        const internalRe = __webpack_require__2("./node_modules/.pnpm/semver@7.6.2/node_modules/semver/internal/re.js"), constants = __webpack_require__2("./node_modules/.pnpm/semver@7.6.2/node_modules/semver/internal/constants.js"), SemVer = __webpack_require__2("./node_modules/.pnpm/semver@7.6.2/node_modules/semver/classes/semver.js"), identifiers = __webpack_require__2("./node_modules/.pnpm/semver@7.6.2/node_modules/semver/internal/identifiers.js"), parse2 = __webpack_require__2("./node_modules/.pnpm/semver@7.6.2/node_modules/semver/functions/parse.js"), valid = __webpack_require__2("./node_modules/.pnpm/semver@7.6.2/node_modules/semver/functions/valid.js"), clean = __webpack_require__2("./node_modules/.pnpm/semver@7.6.2/node_modules/semver/functions/clean.js"), inc = __webpack_require__2("./node_modules/.pnpm/semver@7.6.2/node_modules/semver/functions/inc.js"), diff = __webpack_require__2("./node_modules/.pnpm/semver@7.6.2/node_modules/semver/functions/diff.js"), major = __webpack_require__2("./node_modules/.pnpm/semver@7.6.2/node_modules/semver/functions/major.js"), minor = __webpack_require__2("./node_modules/.pnpm/semver@7.6.2/node_modules/semver/functions/minor.js"), patch = __webpack_require__2("./node_modules/.pnpm/semver@7.6.2/node_modules/semver/functions/patch.js"), prerelease = __webpack_require__2("./node_modules/.pnpm/semver@7.6.2/node_modules/semver/functions/prerelease.js"), compare = __webpack_require__2("./node_modules/.pnpm/semver@7.6.2/node_modules/semver/functions/compare.js"), rcompare = __webpack_require__2("./node_modules/.pnpm/semver@7.6.2/node_modules/semver/functions/rcompare.js"), compareLoose = __webpack_require__2("./node_modules/.pnpm/semver@7.6.2/node_modules/semver/functions/compare-loose.js"), compareBuild = __webpack_require__2("./node_modules/.pnpm/semver@7.6.2/node_modules/semver/functions/compare-build.js"), sort = __webpack_require__2("./node_modules/.pnpm/semver@7.6.2/node_modules/semver/functions/sort.js"), rsort = __webpack_require__2("./node_modules/.pnpm/semver@7.6.2/node_modules/semver/functions/rsort.js"), gt = __webpack_require__2("./node_modules/.pnpm/semver@7.6.2/node_modules/semver/functions/gt.js"), lt = __webpack_require__2("./node_modules/.pnpm/semver@7.6.2/node_modules/semver/functions/lt.js"), eq = __webpack_require__2("./node_modules/.pnpm/semver@7.6.2/node_modules/semver/functions/eq.js"), neq = __webpack_require__2("./node_modules/.pnpm/semver@7.6.2/node_modules/semver/functions/neq.js"), gte = __webpack_require__2("./node_modules/.pnpm/semver@7.6.2/node_modules/semver/functions/gte.js"), lte = __webpack_require__2("./node_modules/.pnpm/semver@7.6.2/node_modules/semver/functions/lte.js"), cmp = __webpack_require__2("./node_modules/.pnpm/semver@7.6.2/node_modules/semver/functions/cmp.js"), coerce = __webpack_require__2("./node_modules/.pnpm/semver@7.6.2/node_modules/semver/functions/coerce.js"), Comparator = __webpack_require__2("./node_modules/.pnpm/semver@7.6.2/node_modules/semver/classes/comparator.js"), Range = __webpack_require__2("./node_modules/.pnpm/semver@7.6.2/node_modules/semver/classes/range.js"), satisfies = __webpack_require__2("./node_modules/.pnpm/semver@7.6.2/node_modules/semver/functions/satisfies.js"), toComparators = __webpack_require__2("./node_modules/.pnpm/semver@7.6.2/node_modules/semver/ranges/to-comparators.js"), maxSatisfying = __webpack_require__2("./node_modules/.pnpm/semver@7.6.2/node_modules/semver/ranges/max-satisfying.js"), minSatisfying = __webpack_require__2("./node_modules/.pnpm/semver@7.6.2/node_modules/semver/ranges/min-satisfying.js"), minVersion = __webpack_require__2("./node_modules/.pnpm/semver@7.6.2/node_modules/semver/ranges/min-version.js"), validRange = __webpack_require__2("./node_modules/.pnpm/semver@7.6.2/node_modules/semver/ranges/valid.js"), outside = __webpack_require__2("./node_modules/.pnpm/semver@7.6.2/node_modules/semver/ranges/outside.js"), gtr = __webpack_require__2("./node_modules/.pnpm/semver@7.6.2/node_modules/semver/ranges/gtr.js"), ltr = __webpack_require__2("./node_modules/.pnpm/semver@7.6.2/node_modules/semver/ranges/ltr.js"), intersects = __webpack_require__2("./node_modules/.pnpm/semver@7.6.2/node_modules/semver/ranges/intersects.js"), simplifyRange = __webpack_require__2("./node_modules/.pnpm/semver@7.6.2/node_modules/semver/ranges/simplify.js"), subset = __webpack_require__2("./node_modules/.pnpm/semver@7.6.2/node_modules/semver/ranges/subset.js");
        module2.exports = { parse: parse2, valid, clean, inc, diff, major, minor, patch, prerelease, compare, rcompare, compareLoose, compareBuild, sort, rsort, gt, lt, eq, neq, gte, lte, cmp, coerce, Comparator, Range, satisfies, toComparators, maxSatisfying, minSatisfying, minVersion, validRange, outside, gtr, ltr, intersects, simplifyRange, subset, SemVer, re: internalRe.re, src: internalRe.src, tokens: internalRe.t, SEMVER_SPEC_VERSION: constants.SEMVER_SPEC_VERSION, RELEASE_TYPES: constants.RELEASE_TYPES, compareIdentifiers: identifiers.compareIdentifiers, rcompareIdentifiers: identifiers.rcompareIdentifiers };
      }, "./node_modules/.pnpm/semver@7.6.2/node_modules/semver/internal/constants.js": (module2) => {
        const MAX_SAFE_INTEGER = Number.MAX_SAFE_INTEGER || 9007199254740991;
        module2.exports = { MAX_LENGTH: 256, MAX_SAFE_COMPONENT_LENGTH: 16, MAX_SAFE_BUILD_LENGTH: 250, MAX_SAFE_INTEGER, RELEASE_TYPES: ["major", "premajor", "minor", "preminor", "patch", "prepatch", "prerelease"], SEMVER_SPEC_VERSION: "2.0.0", FLAG_INCLUDE_PRERELEASE: 1, FLAG_LOOSE: 2 };
      }, "./node_modules/.pnpm/semver@7.6.2/node_modules/semver/internal/debug.js": (module2) => {
        const debug = "object" == typeof process && process.env && process.env.NODE_DEBUG && /\bsemver\b/i.test(process.env.NODE_DEBUG) ? (...args) => console.error("SEMVER", ...args) : () => {
        };
        module2.exports = debug;
      }, "./node_modules/.pnpm/semver@7.6.2/node_modules/semver/internal/identifiers.js": (module2) => {
        const numeric = /^[0-9]+$/, compareIdentifiers = (a, b) => {
          const anum = numeric.test(a), bnum = numeric.test(b);
          return anum && bnum && (a = +a, b = +b), a === b ? 0 : anum && !bnum ? -1 : bnum && !anum ? 1 : a < b ? -1 : 1;
        };
        module2.exports = { compareIdentifiers, rcompareIdentifiers: (a, b) => compareIdentifiers(b, a) };
      }, "./node_modules/.pnpm/semver@7.6.2/node_modules/semver/internal/lrucache.js": (module2) => {
        module2.exports = class {
          constructor() {
            this.max = 1e3, this.map = /* @__PURE__ */ new Map();
          }
          get(key) {
            const value2 = this.map.get(key);
            return void 0 === value2 ? void 0 : (this.map.delete(key), this.map.set(key, value2), value2);
          }
          delete(key) {
            return this.map.delete(key);
          }
          set(key, value2) {
            if (!this.delete(key) && void 0 !== value2) {
              if (this.map.size >= this.max) {
                const firstKey = this.map.keys().next().value;
                this.delete(firstKey);
              }
              this.map.set(key, value2);
            }
            return this;
          }
        };
      }, "./node_modules/.pnpm/semver@7.6.2/node_modules/semver/internal/parse-options.js": (module2) => {
        const looseOption = Object.freeze({ loose: true }), emptyOpts = Object.freeze({});
        module2.exports = (options) => options ? "object" != typeof options ? looseOption : options : emptyOpts;
      }, "./node_modules/.pnpm/semver@7.6.2/node_modules/semver/internal/re.js": (module2, exports2, __webpack_require__2) => {
        const { MAX_SAFE_COMPONENT_LENGTH, MAX_SAFE_BUILD_LENGTH, MAX_LENGTH } = __webpack_require__2("./node_modules/.pnpm/semver@7.6.2/node_modules/semver/internal/constants.js"), debug = __webpack_require__2("./node_modules/.pnpm/semver@7.6.2/node_modules/semver/internal/debug.js"), re = (exports2 = module2.exports = {}).re = [], safeRe = exports2.safeRe = [], src = exports2.src = [], t2 = exports2.t = {};
        let R = 0;
        const safeRegexReplacements = [["\\s", 1], ["\\d", MAX_LENGTH], ["[a-zA-Z0-9-]", MAX_SAFE_BUILD_LENGTH]], createToken = (name, value2, isGlobal) => {
          const safe = ((value3) => {
            for (const [token, max] of safeRegexReplacements)
              value3 = value3.split(`${token}*`).join(`${token}{0,${max}}`).split(`${token}+`).join(`${token}{1,${max}}`);
            return value3;
          })(value2), index = R++;
          debug(name, index, value2), t2[name] = index, src[index] = value2, re[index] = new RegExp(value2, isGlobal ? "g" : void 0), safeRe[index] = new RegExp(safe, isGlobal ? "g" : void 0);
        };
        createToken("NUMERICIDENTIFIER", "0|[1-9]\\d*"), createToken("NUMERICIDENTIFIERLOOSE", "\\d+"), createToken("NONNUMERICIDENTIFIER", "\\d*[a-zA-Z-][a-zA-Z0-9-]*"), createToken("MAINVERSION", `(${src[t2.NUMERICIDENTIFIER]})\\.(${src[t2.NUMERICIDENTIFIER]})\\.(${src[t2.NUMERICIDENTIFIER]})`), createToken("MAINVERSIONLOOSE", `(${src[t2.NUMERICIDENTIFIERLOOSE]})\\.(${src[t2.NUMERICIDENTIFIERLOOSE]})\\.(${src[t2.NUMERICIDENTIFIERLOOSE]})`), createToken("PRERELEASEIDENTIFIER", `(?:${src[t2.NUMERICIDENTIFIER]}|${src[t2.NONNUMERICIDENTIFIER]})`), createToken("PRERELEASEIDENTIFIERLOOSE", `(?:${src[t2.NUMERICIDENTIFIERLOOSE]}|${src[t2.NONNUMERICIDENTIFIER]})`), createToken("PRERELEASE", `(?:-(${src[t2.PRERELEASEIDENTIFIER]}(?:\\.${src[t2.PRERELEASEIDENTIFIER]})*))`), createToken("PRERELEASELOOSE", `(?:-?(${src[t2.PRERELEASEIDENTIFIERLOOSE]}(?:\\.${src[t2.PRERELEASEIDENTIFIERLOOSE]})*))`), createToken("BUILDIDENTIFIER", "[a-zA-Z0-9-]+"), createToken("BUILD", `(?:\\+(${src[t2.BUILDIDENTIFIER]}(?:\\.${src[t2.BUILDIDENTIFIER]})*))`), createToken("FULLPLAIN", `v?${src[t2.MAINVERSION]}${src[t2.PRERELEASE]}?${src[t2.BUILD]}?`), createToken("FULL", `^${src[t2.FULLPLAIN]}$`), createToken("LOOSEPLAIN", `[v=\\s]*${src[t2.MAINVERSIONLOOSE]}${src[t2.PRERELEASELOOSE]}?${src[t2.BUILD]}?`), createToken("LOOSE", `^${src[t2.LOOSEPLAIN]}$`), createToken("GTLT", "((?:<|>)?=?)"), createToken("XRANGEIDENTIFIERLOOSE", `${src[t2.NUMERICIDENTIFIERLOOSE]}|x|X|\\*`), createToken("XRANGEIDENTIFIER", `${src[t2.NUMERICIDENTIFIER]}|x|X|\\*`), createToken("XRANGEPLAIN", `[v=\\s]*(${src[t2.XRANGEIDENTIFIER]})(?:\\.(${src[t2.XRANGEIDENTIFIER]})(?:\\.(${src[t2.XRANGEIDENTIFIER]})(?:${src[t2.PRERELEASE]})?${src[t2.BUILD]}?)?)?`), createToken("XRANGEPLAINLOOSE", `[v=\\s]*(${src[t2.XRANGEIDENTIFIERLOOSE]})(?:\\.(${src[t2.XRANGEIDENTIFIERLOOSE]})(?:\\.(${src[t2.XRANGEIDENTIFIERLOOSE]})(?:${src[t2.PRERELEASELOOSE]})?${src[t2.BUILD]}?)?)?`), createToken("XRANGE", `^${src[t2.GTLT]}\\s*${src[t2.XRANGEPLAIN]}$`), createToken("XRANGELOOSE", `^${src[t2.GTLT]}\\s*${src[t2.XRANGEPLAINLOOSE]}$`), createToken("COERCEPLAIN", `(^|[^\\d])(\\d{1,${MAX_SAFE_COMPONENT_LENGTH}})(?:\\.(\\d{1,${MAX_SAFE_COMPONENT_LENGTH}}))?(?:\\.(\\d{1,${MAX_SAFE_COMPONENT_LENGTH}}))?`), createToken("COERCE", `${src[t2.COERCEPLAIN]}(?:$|[^\\d])`), createToken("COERCEFULL", src[t2.COERCEPLAIN] + `(?:${src[t2.PRERELEASE]})?(?:${src[t2.BUILD]})?(?:$|[^\\d])`), createToken("COERCERTL", src[t2.COERCE], true), createToken("COERCERTLFULL", src[t2.COERCEFULL], true), createToken("LONETILDE", "(?:~>?)"), createToken("TILDETRIM", `(\\s*)${src[t2.LONETILDE]}\\s+`, true), exports2.tildeTrimReplace = "$1~", createToken("TILDE", `^${src[t2.LONETILDE]}${src[t2.XRANGEPLAIN]}$`), createToken("TILDELOOSE", `^${src[t2.LONETILDE]}${src[t2.XRANGEPLAINLOOSE]}$`), createToken("LONECARET", "(?:\\^)"), createToken("CARETTRIM", `(\\s*)${src[t2.LONECARET]}\\s+`, true), exports2.caretTrimReplace = "$1^", createToken("CARET", `^${src[t2.LONECARET]}${src[t2.XRANGEPLAIN]}$`), createToken("CARETLOOSE", `^${src[t2.LONECARET]}${src[t2.XRANGEPLAINLOOSE]}$`), createToken("COMPARATORLOOSE", `^${src[t2.GTLT]}\\s*(${src[t2.LOOSEPLAIN]})$|^$`), createToken("COMPARATOR", `^${src[t2.GTLT]}\\s*(${src[t2.FULLPLAIN]})$|^$`), createToken("COMPARATORTRIM", `(\\s*)${src[t2.GTLT]}\\s*(${src[t2.LOOSEPLAIN]}|${src[t2.XRANGEPLAIN]})`, true), exports2.comparatorTrimReplace = "$1$2$3", createToken("HYPHENRANGE", `^\\s*(${src[t2.XRANGEPLAIN]})\\s+-\\s+(${src[t2.XRANGEPLAIN]})\\s*$`), createToken("HYPHENRANGELOOSE", `^\\s*(${src[t2.XRANGEPLAINLOOSE]})\\s+-\\s+(${src[t2.XRANGEPLAINLOOSE]})\\s*$`), createToken("STAR", "(<|>)?=?\\s*\\*"), createToken("GTE0", "^\\s*>=\\s*0\\.0\\.0\\s*$"), createToken("GTE0PRE", "^\\s*>=\\s*0\\.0\\.0-0\\s*$");
      }, "./node_modules/.pnpm/semver@7.6.2/node_modules/semver/ranges/gtr.js": (module2, __unused_webpack_exports, __webpack_require__2) => {
        const outside = __webpack_require__2("./node_modules/.pnpm/semver@7.6.2/node_modules/semver/ranges/outside.js");
        module2.exports = (version, range, options) => outside(version, range, ">", options);
      }, "./node_modules/.pnpm/semver@7.6.2/node_modules/semver/ranges/intersects.js": (module2, __unused_webpack_exports, __webpack_require__2) => {
        const Range = __webpack_require__2("./node_modules/.pnpm/semver@7.6.2/node_modules/semver/classes/range.js");
        module2.exports = (r1, r2, options) => (r1 = new Range(r1, options), r2 = new Range(r2, options), r1.intersects(r2, options));
      }, "./node_modules/.pnpm/semver@7.6.2/node_modules/semver/ranges/ltr.js": (module2, __unused_webpack_exports, __webpack_require__2) => {
        const outside = __webpack_require__2("./node_modules/.pnpm/semver@7.6.2/node_modules/semver/ranges/outside.js");
        module2.exports = (version, range, options) => outside(version, range, "<", options);
      }, "./node_modules/.pnpm/semver@7.6.2/node_modules/semver/ranges/max-satisfying.js": (module2, __unused_webpack_exports, __webpack_require__2) => {
        const SemVer = __webpack_require__2("./node_modules/.pnpm/semver@7.6.2/node_modules/semver/classes/semver.js"), Range = __webpack_require__2("./node_modules/.pnpm/semver@7.6.2/node_modules/semver/classes/range.js");
        module2.exports = (versions, range, options) => {
          let max = null, maxSV = null, rangeObj = null;
          try {
            rangeObj = new Range(range, options);
          } catch (er) {
            return null;
          }
          return versions.forEach((v) => {
            rangeObj.test(v) && (max && -1 !== maxSV.compare(v) || (max = v, maxSV = new SemVer(max, options)));
          }), max;
        };
      }, "./node_modules/.pnpm/semver@7.6.2/node_modules/semver/ranges/min-satisfying.js": (module2, __unused_webpack_exports, __webpack_require__2) => {
        const SemVer = __webpack_require__2("./node_modules/.pnpm/semver@7.6.2/node_modules/semver/classes/semver.js"), Range = __webpack_require__2("./node_modules/.pnpm/semver@7.6.2/node_modules/semver/classes/range.js");
        module2.exports = (versions, range, options) => {
          let min = null, minSV = null, rangeObj = null;
          try {
            rangeObj = new Range(range, options);
          } catch (er) {
            return null;
          }
          return versions.forEach((v) => {
            rangeObj.test(v) && (min && 1 !== minSV.compare(v) || (min = v, minSV = new SemVer(min, options)));
          }), min;
        };
      }, "./node_modules/.pnpm/semver@7.6.2/node_modules/semver/ranges/min-version.js": (module2, __unused_webpack_exports, __webpack_require__2) => {
        const SemVer = __webpack_require__2("./node_modules/.pnpm/semver@7.6.2/node_modules/semver/classes/semver.js"), Range = __webpack_require__2("./node_modules/.pnpm/semver@7.6.2/node_modules/semver/classes/range.js"), gt = __webpack_require__2("./node_modules/.pnpm/semver@7.6.2/node_modules/semver/functions/gt.js");
        module2.exports = (range, loose) => {
          range = new Range(range, loose);
          let minver = new SemVer("0.0.0");
          if (range.test(minver))
            return minver;
          if (minver = new SemVer("0.0.0-0"), range.test(minver))
            return minver;
          minver = null;
          for (let i = 0; i < range.set.length; ++i) {
            const comparators = range.set[i];
            let setMin = null;
            comparators.forEach((comparator) => {
              const compver = new SemVer(comparator.semver.version);
              switch (comparator.operator) {
                case ">":
                  0 === compver.prerelease.length ? compver.patch++ : compver.prerelease.push(0), compver.raw = compver.format();
                case "":
                case ">=":
                  setMin && !gt(compver, setMin) || (setMin = compver);
                  break;
                case "<":
                case "<=":
                  break;
                default:
                  throw new Error(`Unexpected operation: ${comparator.operator}`);
              }
            }), !setMin || minver && !gt(minver, setMin) || (minver = setMin);
          }
          return minver && range.test(minver) ? minver : null;
        };
      }, "./node_modules/.pnpm/semver@7.6.2/node_modules/semver/ranges/outside.js": (module2, __unused_webpack_exports, __webpack_require__2) => {
        const SemVer = __webpack_require__2("./node_modules/.pnpm/semver@7.6.2/node_modules/semver/classes/semver.js"), Comparator = __webpack_require__2("./node_modules/.pnpm/semver@7.6.2/node_modules/semver/classes/comparator.js"), { ANY } = Comparator, Range = __webpack_require__2("./node_modules/.pnpm/semver@7.6.2/node_modules/semver/classes/range.js"), satisfies = __webpack_require__2("./node_modules/.pnpm/semver@7.6.2/node_modules/semver/functions/satisfies.js"), gt = __webpack_require__2("./node_modules/.pnpm/semver@7.6.2/node_modules/semver/functions/gt.js"), lt = __webpack_require__2("./node_modules/.pnpm/semver@7.6.2/node_modules/semver/functions/lt.js"), lte = __webpack_require__2("./node_modules/.pnpm/semver@7.6.2/node_modules/semver/functions/lte.js"), gte = __webpack_require__2("./node_modules/.pnpm/semver@7.6.2/node_modules/semver/functions/gte.js");
        module2.exports = (version, range, hilo, options) => {
          let gtfn, ltefn, ltfn, comp, ecomp;
          switch (version = new SemVer(version, options), range = new Range(range, options), hilo) {
            case ">":
              gtfn = gt, ltefn = lte, ltfn = lt, comp = ">", ecomp = ">=";
              break;
            case "<":
              gtfn = lt, ltefn = gte, ltfn = gt, comp = "<", ecomp = "<=";
              break;
            default:
              throw new TypeError('Must provide a hilo val of "<" or ">"');
          }
          if (satisfies(version, range, options))
            return false;
          for (let i = 0; i < range.set.length; ++i) {
            const comparators = range.set[i];
            let high = null, low = null;
            if (comparators.forEach((comparator) => {
              comparator.semver === ANY && (comparator = new Comparator(">=0.0.0")), high = high || comparator, low = low || comparator, gtfn(comparator.semver, high.semver, options) ? high = comparator : ltfn(comparator.semver, low.semver, options) && (low = comparator);
            }), high.operator === comp || high.operator === ecomp)
              return false;
            if ((!low.operator || low.operator === comp) && ltefn(version, low.semver))
              return false;
            if (low.operator === ecomp && ltfn(version, low.semver))
              return false;
          }
          return true;
        };
      }, "./node_modules/.pnpm/semver@7.6.2/node_modules/semver/ranges/simplify.js": (module2, __unused_webpack_exports, __webpack_require__2) => {
        const satisfies = __webpack_require__2("./node_modules/.pnpm/semver@7.6.2/node_modules/semver/functions/satisfies.js"), compare = __webpack_require__2("./node_modules/.pnpm/semver@7.6.2/node_modules/semver/functions/compare.js");
        module2.exports = (versions, range, options) => {
          const set = [];
          let first = null, prev = null;
          const v = versions.sort((a, b) => compare(a, b, options));
          for (const version of v) {
            satisfies(version, range, options) ? (prev = version, first || (first = version)) : (prev && set.push([first, prev]), prev = null, first = null);
          }
          first && set.push([first, null]);
          const ranges = [];
          for (const [min, max] of set)
            min === max ? ranges.push(min) : max || min !== v[0] ? max ? min === v[0] ? ranges.push(`<=${max}`) : ranges.push(`${min} - ${max}`) : ranges.push(`>=${min}`) : ranges.push("*");
          const simplified = ranges.join(" || "), original = "string" == typeof range.raw ? range.raw : String(range);
          return simplified.length < original.length ? simplified : range;
        };
      }, "./node_modules/.pnpm/semver@7.6.2/node_modules/semver/ranges/subset.js": (module2, __unused_webpack_exports, __webpack_require__2) => {
        const Range = __webpack_require__2("./node_modules/.pnpm/semver@7.6.2/node_modules/semver/classes/range.js"), Comparator = __webpack_require__2("./node_modules/.pnpm/semver@7.6.2/node_modules/semver/classes/comparator.js"), { ANY } = Comparator, satisfies = __webpack_require__2("./node_modules/.pnpm/semver@7.6.2/node_modules/semver/functions/satisfies.js"), compare = __webpack_require__2("./node_modules/.pnpm/semver@7.6.2/node_modules/semver/functions/compare.js"), minimumVersionWithPreRelease = [new Comparator(">=0.0.0-0")], minimumVersion = [new Comparator(">=0.0.0")], simpleSubset = (sub, dom, options) => {
          if (sub === dom)
            return true;
          if (1 === sub.length && sub[0].semver === ANY) {
            if (1 === dom.length && dom[0].semver === ANY)
              return true;
            sub = options.includePrerelease ? minimumVersionWithPreRelease : minimumVersion;
          }
          if (1 === dom.length && dom[0].semver === ANY) {
            if (options.includePrerelease)
              return true;
            dom = minimumVersion;
          }
          const eqSet = /* @__PURE__ */ new Set();
          let gt, lt, gtltComp, higher, lower, hasDomLT, hasDomGT;
          for (const c of sub)
            ">" === c.operator || ">=" === c.operator ? gt = higherGT(gt, c, options) : "<" === c.operator || "<=" === c.operator ? lt = lowerLT(lt, c, options) : eqSet.add(c.semver);
          if (eqSet.size > 1)
            return null;
          if (gt && lt) {
            if (gtltComp = compare(gt.semver, lt.semver, options), gtltComp > 0)
              return null;
            if (0 === gtltComp && (">=" !== gt.operator || "<=" !== lt.operator))
              return null;
          }
          for (const eq of eqSet) {
            if (gt && !satisfies(eq, String(gt), options))
              return null;
            if (lt && !satisfies(eq, String(lt), options))
              return null;
            for (const c of dom)
              if (!satisfies(eq, String(c), options))
                return false;
            return true;
          }
          let needDomLTPre = !(!lt || options.includePrerelease || !lt.semver.prerelease.length) && lt.semver, needDomGTPre = !(!gt || options.includePrerelease || !gt.semver.prerelease.length) && gt.semver;
          needDomLTPre && 1 === needDomLTPre.prerelease.length && "<" === lt.operator && 0 === needDomLTPre.prerelease[0] && (needDomLTPre = false);
          for (const c of dom) {
            if (hasDomGT = hasDomGT || ">" === c.operator || ">=" === c.operator, hasDomLT = hasDomLT || "<" === c.operator || "<=" === c.operator, gt) {
              if (needDomGTPre && c.semver.prerelease && c.semver.prerelease.length && c.semver.major === needDomGTPre.major && c.semver.minor === needDomGTPre.minor && c.semver.patch === needDomGTPre.patch && (needDomGTPre = false), ">" === c.operator || ">=" === c.operator) {
                if (higher = higherGT(gt, c, options), higher === c && higher !== gt)
                  return false;
              } else if (">=" === gt.operator && !satisfies(gt.semver, String(c), options))
                return false;
            }
            if (lt) {
              if (needDomLTPre && c.semver.prerelease && c.semver.prerelease.length && c.semver.major === needDomLTPre.major && c.semver.minor === needDomLTPre.minor && c.semver.patch === needDomLTPre.patch && (needDomLTPre = false), "<" === c.operator || "<=" === c.operator) {
                if (lower = lowerLT(lt, c, options), lower === c && lower !== lt)
                  return false;
              } else if ("<=" === lt.operator && !satisfies(lt.semver, String(c), options))
                return false;
            }
            if (!c.operator && (lt || gt) && 0 !== gtltComp)
              return false;
          }
          return !(gt && hasDomLT && !lt && 0 !== gtltComp) && (!(lt && hasDomGT && !gt && 0 !== gtltComp) && (!needDomGTPre && !needDomLTPre));
        }, higherGT = (a, b, options) => {
          if (!a)
            return b;
          const comp = compare(a.semver, b.semver, options);
          return comp > 0 ? a : comp < 0 || ">" === b.operator && ">=" === a.operator ? b : a;
        }, lowerLT = (a, b, options) => {
          if (!a)
            return b;
          const comp = compare(a.semver, b.semver, options);
          return comp < 0 ? a : comp > 0 || "<" === b.operator && "<=" === a.operator ? b : a;
        };
        module2.exports = (sub, dom, options = {}) => {
          if (sub === dom)
            return true;
          sub = new Range(sub, options), dom = new Range(dom, options);
          let sawNonNull = false;
          OUTER:
            for (const simpleSub of sub.set) {
              for (const simpleDom of dom.set) {
                const isSub = simpleSubset(simpleSub, simpleDom, options);
                if (sawNonNull = sawNonNull || null !== isSub, isSub)
                  continue OUTER;
              }
              if (sawNonNull)
                return false;
            }
          return true;
        };
      }, "./node_modules/.pnpm/semver@7.6.2/node_modules/semver/ranges/to-comparators.js": (module2, __unused_webpack_exports, __webpack_require__2) => {
        const Range = __webpack_require__2("./node_modules/.pnpm/semver@7.6.2/node_modules/semver/classes/range.js");
        module2.exports = (range, options) => new Range(range, options).set.map((comp) => comp.map((c) => c.value).join(" ").trim().split(" "));
      }, "./node_modules/.pnpm/semver@7.6.2/node_modules/semver/ranges/valid.js": (module2, __unused_webpack_exports, __webpack_require__2) => {
        const Range = __webpack_require__2("./node_modules/.pnpm/semver@7.6.2/node_modules/semver/classes/range.js");
        module2.exports = (range, options) => {
          try {
            return new Range(range, options).range || "*";
          } catch (er) {
            return null;
          }
        };
      }, crypto: (module2) => {
        "use strict";
        module2.exports = require_crypto();
      }, fs: (module2) => {
        "use strict";
        module2.exports = require_fs();
      }, module: (module2) => {
        "use strict";
        module2.exports = require_module();
      }, path: (module2) => {
        "use strict";
        module2.exports = require_path();
      } }, __webpack_module_cache__ = {};
      function __webpack_require__(moduleId) {
        var cachedModule = __webpack_module_cache__[moduleId];
        if (void 0 !== cachedModule)
          return cachedModule.exports;
        var module2 = __webpack_module_cache__[moduleId] = { id: moduleId, loaded: false, exports: {} };
        return __webpack_modules__[moduleId](module2, module2.exports, __webpack_require__), module2.loaded = true, module2.exports;
      }
      __webpack_require__.n = (module2) => {
        var getter = module2 && module2.__esModule ? () => module2.default : () => module2;
        return __webpack_require__.d(getter, { a: getter }), getter;
      }, __webpack_require__.d = (exports2, definition) => {
        for (var key in definition)
          __webpack_require__.o(definition, key) && !__webpack_require__.o(exports2, key) && Object.defineProperty(exports2, key, { enumerable: true, get: definition[key] });
      }, __webpack_require__.o = (obj, prop) => Object.prototype.hasOwnProperty.call(obj, prop), __webpack_require__.nmd = (module2) => (module2.paths = [], module2.children || (module2.children = []), module2);
      var __webpack_exports__ = {};
      (() => {
        "use strict";
        __webpack_require__.d(__webpack_exports__, { default: () => createJITI });
        var external_fs_ = __webpack_require__("fs"), external_module_ = __webpack_require__("module");
        const external_perf_hooks_namespaceObject = require_perf_hooks(), external_os_namespaceObject = require_os(), external_vm_namespaceObject = require_vm();
        var external_vm_default = __webpack_require__.n(external_vm_namespaceObject);
        const external_url_namespaceObject = require_url(), _DRIVE_LETTER_START_RE = /^[A-Za-z]:\//;
        function normalizeWindowsPath(input2 = "") {
          return input2 ? input2.replace(/\\/g, "/").replace(_DRIVE_LETTER_START_RE, (r) => r.toUpperCase()) : input2;
        }
        const _UNC_REGEX = /^[/\\]{2}/, _IS_ABSOLUTE_RE = /^[/\\](?![/\\])|^[/\\]{2}(?!\.)|^[A-Za-z]:[/\\]/, _DRIVE_LETTER_RE = /^[A-Za-z]:$/, pathe_ff20891b_normalize = function(path) {
          if (0 === path.length)
            return ".";
          const isUNCPath = (path = normalizeWindowsPath(path)).match(_UNC_REGEX), isPathAbsolute = isAbsolute(path), trailingSeparator = "/" === path[path.length - 1];
          return 0 === (path = normalizeString(path, !isPathAbsolute)).length ? isPathAbsolute ? "/" : trailingSeparator ? "./" : "." : (trailingSeparator && (path += "/"), _DRIVE_LETTER_RE.test(path) && (path += "/"), isUNCPath ? isPathAbsolute ? `//${path}` : `//./${path}` : isPathAbsolute && !isAbsolute(path) ? `/${path}` : path);
        }, join = function(...arguments_) {
          if (0 === arguments_.length)
            return ".";
          let joined;
          for (const argument of arguments_)
            argument && argument.length > 0 && (void 0 === joined ? joined = argument : joined += `/${argument}`);
          return void 0 === joined ? "." : pathe_ff20891b_normalize(joined.replace(/\/\/+/g, "/"));
        };
        function normalizeString(path, allowAboveRoot) {
          let res = "", lastSegmentLength = 0, lastSlash = -1, dots = 0, char = null;
          for (let index = 0; index <= path.length; ++index) {
            if (index < path.length)
              char = path[index];
            else {
              if ("/" === char)
                break;
              char = "/";
            }
            if ("/" === char) {
              if (lastSlash === index - 1 || 1 === dots)
                ;
              else if (2 === dots) {
                if (res.length < 2 || 2 !== lastSegmentLength || "." !== res[res.length - 1] || "." !== res[res.length - 2]) {
                  if (res.length > 2) {
                    const lastSlashIndex = res.lastIndexOf("/");
                    -1 === lastSlashIndex ? (res = "", lastSegmentLength = 0) : (res = res.slice(0, lastSlashIndex), lastSegmentLength = res.length - 1 - res.lastIndexOf("/")), lastSlash = index, dots = 0;
                    continue;
                  }
                  if (res.length > 0) {
                    res = "", lastSegmentLength = 0, lastSlash = index, dots = 0;
                    continue;
                  }
                }
                allowAboveRoot && (res += res.length > 0 ? "/.." : "..", lastSegmentLength = 2);
              } else
                res.length > 0 ? res += `/${path.slice(lastSlash + 1, index)}` : res = path.slice(lastSlash + 1, index), lastSegmentLength = index - lastSlash - 1;
              lastSlash = index, dots = 0;
            } else
              "." === char && -1 !== dots ? ++dots : dots = -1;
          }
          return res;
        }
        const isAbsolute = function(p) {
          return _IS_ABSOLUTE_RE.test(p);
        }, _EXTNAME_RE = /.(\.[^./]+)$/, extname = function(p) {
          const match2 = _EXTNAME_RE.exec(normalizeWindowsPath(p));
          return match2 && match2[1] || "";
        }, pathe_ff20891b_dirname = function(p) {
          const segments = normalizeWindowsPath(p).replace(/\/$/, "").split("/").slice(0, -1);
          return 1 === segments.length && _DRIVE_LETTER_RE.test(segments[0]) && (segments[0] += "/"), segments.join("/") || (isAbsolute(p) ? "/" : ".");
        }, basename = function(p, extension) {
          const lastSegment = normalizeWindowsPath(p).split("/").pop();
          return extension && lastSegment.endsWith(extension) ? lastSegment.slice(0, -extension.length) : lastSegment;
        }, suspectProtoRx = /"(?:_|\\u0{2}5[Ff]){2}(?:p|\\u0{2}70)(?:r|\\u0{2}72)(?:o|\\u0{2}6[Ff])(?:t|\\u0{2}74)(?:o|\\u0{2}6[Ff])(?:_|\\u0{2}5[Ff]){2}"\s*:/, suspectConstructorRx = /"(?:c|\\u0063)(?:o|\\u006[Ff])(?:n|\\u006[Ee])(?:s|\\u0073)(?:t|\\u0074)(?:r|\\u0072)(?:u|\\u0075)(?:c|\\u0063)(?:t|\\u0074)(?:o|\\u006[Ff])(?:r|\\u0072)"\s*:/, JsonSigRx = /^\s*["[{]|^\s*-?\d{1,16}(\.\d{1,17})?([Ee][+-]?\d+)?\s*$/;
        function jsonParseTransform(key, value2) {
          if (!("__proto__" === key || "constructor" === key && value2 && "object" == typeof value2 && "prototype" in value2))
            return value2;
          !function(key2) {
            console.warn(`[destr] Dropping "${key2}" key to prevent prototype pollution.`);
          }(key);
        }
        function destr(value2, options = {}) {
          if ("string" != typeof value2)
            return value2;
          const _value = value2.trim();
          if ('"' === value2[0] && value2.endsWith('"') && !value2.includes("\\"))
            return _value.slice(1, -1);
          if (_value.length <= 9) {
            const _lval = _value.toLowerCase();
            if ("true" === _lval)
              return true;
            if ("false" === _lval)
              return false;
            if ("undefined" === _lval)
              return;
            if ("null" === _lval)
              return null;
            if ("nan" === _lval)
              return Number.NaN;
            if ("infinity" === _lval)
              return Number.POSITIVE_INFINITY;
            if ("-infinity" === _lval)
              return Number.NEGATIVE_INFINITY;
          }
          if (!JsonSigRx.test(value2)) {
            if (options.strict)
              throw new SyntaxError("[destr] Invalid JSON");
            return value2;
          }
          try {
            if (suspectProtoRx.test(value2) || suspectConstructorRx.test(value2)) {
              if (options.strict)
                throw new Error("[destr] Possible prototype pollution");
              return JSON.parse(value2, jsonParseTransform);
            }
            return JSON.parse(value2);
          } catch (error) {
            if (options.strict)
              throw error;
            return value2;
          }
        }
        function escapeStringRegexp(string) {
          if ("string" != typeof string)
            throw new TypeError("Expected a string");
          return string.replace(/[|\\{}()[\]^$+*?.]/g, "\\$&").replace(/-/g, "\\x2d");
        }
        var create_require = __webpack_require__("./node_modules/.pnpm/create-require@1.1.1/node_modules/create-require/create-require.js"), create_require_default = __webpack_require__.n(create_require), semver = __webpack_require__("./node_modules/.pnpm/semver@7.6.2/node_modules/semver/index.js");
        const pathSeparators = /* @__PURE__ */ new Set(["/", "\\", void 0]), normalizedAliasSymbol = Symbol.for("pathe:normalizedAlias");
        function normalizeAliases(_aliases) {
          if (_aliases[normalizedAliasSymbol])
            return _aliases;
          const aliases = Object.fromEntries(Object.entries(_aliases).sort(([a], [b]) => function(a2, b2) {
            return b2.split("/").length - a2.split("/").length;
          }(a, b)));
          for (const key in aliases)
            for (const alias in aliases)
              alias === key || key.startsWith(alias) || aliases[key].startsWith(alias) && pathSeparators.has(aliases[key][alias.length]) && (aliases[key] = aliases[alias] + aliases[key].slice(alias.length));
          return Object.defineProperty(aliases, normalizedAliasSymbol, { value: true, enumerable: false }), aliases;
        }
        function hasTrailingSlash(path = "/") {
          const lastChar = path[path.length - 1];
          return "/" === lastChar || "\\" === lastChar;
        }
        var lib = __webpack_require__("./node_modules/.pnpm/pirates@4.0.6/node_modules/pirates/lib/index.js"), object_hash = __webpack_require__("./node_modules/.pnpm/object-hash@3.0.0/node_modules/object-hash/index.js"), object_hash_default = __webpack_require__.n(object_hash), astralIdentifierCodes = [509, 0, 227, 0, 150, 4, 294, 9, 1368, 2, 2, 1, 6, 3, 41, 2, 5, 0, 166, 1, 574, 3, 9, 9, 370, 1, 81, 2, 71, 10, 50, 3, 123, 2, 54, 14, 32, 10, 3, 1, 11, 3, 46, 10, 8, 0, 46, 9, 7, 2, 37, 13, 2, 9, 6, 1, 45, 0, 13, 2, 49, 13, 9, 3, 2, 11, 83, 11, 7, 0, 3, 0, 158, 11, 6, 9, 7, 3, 56, 1, 2, 6, 3, 1, 3, 2, 10, 0, 11, 1, 3, 6, 4, 4, 193, 17, 10, 9, 5, 0, 82, 19, 13, 9, 214, 6, 3, 8, 28, 1, 83, 16, 16, 9, 82, 12, 9, 9, 84, 14, 5, 9, 243, 14, 166, 9, 71, 5, 2, 1, 3, 3, 2, 0, 2, 1, 13, 9, 120, 6, 3, 6, 4, 0, 29, 9, 41, 6, 2, 3, 9, 0, 10, 10, 47, 15, 406, 7, 2, 7, 17, 9, 57, 21, 2, 13, 123, 5, 4, 0, 2, 1, 2, 6, 2, 0, 9, 9, 49, 4, 2, 1, 2, 4, 9, 9, 330, 3, 10, 1, 2, 0, 49, 6, 4, 4, 14, 9, 5351, 0, 7, 14, 13835, 9, 87, 9, 39, 4, 60, 6, 26, 9, 1014, 0, 2, 54, 8, 3, 82, 0, 12, 1, 19628, 1, 4706, 45, 3, 22, 543, 4, 4, 5, 9, 7, 3, 6, 31, 3, 149, 2, 1418, 49, 513, 54, 5, 49, 9, 0, 15, 0, 23, 4, 2, 14, 1361, 6, 2, 16, 3, 6, 2, 1, 2, 4, 101, 0, 161, 6, 10, 9, 357, 0, 62, 13, 499, 13, 983, 6, 110, 6, 6, 9, 4759, 9, 787719, 239], astralIdentifierStartCodes = [0, 11, 2, 25, 2, 18, 2, 1, 2, 14, 3, 13, 35, 122, 70, 52, 268, 28, 4, 48, 48, 31, 14, 29, 6, 37, 11, 29, 3, 35, 5, 7, 2, 4, 43, 157, 19, 35, 5, 35, 5, 39, 9, 51, 13, 10, 2, 14, 2, 6, 2, 1, 2, 10, 2, 14, 2, 6, 2, 1, 68, 310, 10, 21, 11, 7, 25, 5, 2, 41, 2, 8, 70, 5, 3, 0, 2, 43, 2, 1, 4, 0, 3, 22, 11, 22, 10, 30, 66, 18, 2, 1, 11, 21, 11, 25, 71, 55, 7, 1, 65, 0, 16, 3, 2, 2, 2, 28, 43, 28, 4, 28, 36, 7, 2, 27, 28, 53, 11, 21, 11, 18, 14, 17, 111, 72, 56, 50, 14, 50, 14, 35, 349, 41, 7, 1, 79, 28, 11, 0, 9, 21, 43, 17, 47, 20, 28, 22, 13, 52, 58, 1, 3, 0, 14, 44, 33, 24, 27, 35, 30, 0, 3, 0, 9, 34, 4, 0, 13, 47, 15, 3, 22, 0, 2, 0, 36, 17, 2, 24, 20, 1, 64, 6, 2, 0, 2, 3, 2, 14, 2, 9, 8, 46, 39, 7, 3, 1, 3, 21, 2, 6, 2, 1, 2, 4, 4, 0, 19, 0, 13, 4, 159, 52, 19, 3, 21, 2, 31, 47, 21, 1, 2, 0, 185, 46, 42, 3, 37, 47, 21, 0, 60, 42, 14, 0, 72, 26, 38, 6, 186, 43, 117, 63, 32, 7, 3, 0, 3, 7, 2, 1, 2, 23, 16, 0, 2, 0, 95, 7, 3, 38, 17, 0, 2, 0, 29, 0, 11, 39, 8, 0, 22, 0, 12, 45, 20, 0, 19, 72, 264, 8, 2, 36, 18, 0, 50, 29, 113, 6, 2, 1, 2, 37, 22, 0, 26, 5, 2, 1, 2, 31, 15, 0, 328, 18, 16, 0, 2, 12, 2, 33, 125, 0, 80, 921, 103, 110, 18, 195, 2637, 96, 16, 1071, 18, 5, 4026, 582, 8634, 568, 8, 30, 18, 78, 18, 29, 19, 47, 17, 3, 32, 20, 6, 18, 689, 63, 129, 74, 6, 0, 67, 12, 65, 1, 2, 0, 29, 6135, 9, 1237, 43, 8, 8936, 3, 2, 6, 2, 1, 2, 290, 16, 0, 30, 2, 3, 0, 15, 3, 9, 395, 2309, 106, 6, 12, 4, 8, 8, 9, 5991, 84, 2, 70, 2, 1, 3, 0, 3, 1, 3, 3, 2, 11, 2, 0, 2, 6, 2, 64, 2, 3, 3, 7, 2, 6, 2, 27, 2, 3, 2, 4, 2, 0, 4, 6, 2, 339, 3, 24, 2, 24, 2, 30, 2, 24, 2, 30, 2, 24, 2, 30, 2, 24, 2, 30, 2, 24, 2, 7, 1845, 30, 7, 5, 262, 61, 147, 44, 11, 6, 17, 0, 322, 29, 19, 43, 485, 27, 757, 6, 2, 3, 2, 1, 2, 14, 2, 196, 60, 67, 8, 0, 1205, 3, 2, 26, 2, 1, 2, 0, 3, 0, 2, 9, 2, 3, 2, 0, 2, 0, 7, 0, 5, 0, 2, 0, 2, 0, 2, 2, 2, 1, 2, 0, 3, 0, 2, 0, 2, 0, 2, 0, 2, 0, 2, 1, 2, 0, 3, 3, 2, 6, 2, 3, 2, 3, 2, 0, 2, 9, 2, 16, 6, 2, 2, 4, 2, 16, 4421, 42719, 33, 4153, 7, 221, 3, 5761, 15, 7472, 16, 621, 2467, 541, 1507, 4938, 6, 4191], nonASCIIidentifierStartChars = "ªµºÀ-ÖØ-öø-ˁˆ-ˑˠ-ˤˬˮͰ-ʹͶͷͺ-ͽͿΆΈ-ΊΌΎ-ΡΣ-ϵϷ-ҁҊ-ԯԱ-Ֆՙՠ-ֈא-תׯ-ײؠ-يٮٯٱ-ۓەۥۦۮۯۺ-ۼۿܐܒ-ܯݍ-ޥޱߊ-ߪߴߵߺࠀ-ࠕࠚࠤࠨࡀ-ࡘࡠ-ࡪࡰ-ࢇࢉ-ࢎࢠ-ࣉऄ-हऽॐक़-ॡॱ-ঀঅ-ঌএঐও-নপ-রলশ-হঽৎড়ঢ়য়-ৡৰৱৼਅ-ਊਏਐਓ-ਨਪ-ਰਲਲ਼ਵਸ਼ਸਹਖ਼-ੜਫ਼ੲ-ੴઅ-ઍએ-ઑઓ-નપ-રલળવ-હઽૐૠૡૹଅ-ଌଏଐଓ-ନପ-ରଲଳଵ-ହଽଡ଼ଢ଼ୟ-ୡୱஃஅ-ஊஎ-ஐஒ-கஙசஜஞடணதந-பம-ஹௐఅ-ఌఎ-ఐఒ-నప-హఽౘ-ౚౝౠౡಀಅ-ಌಎ-ಐಒ-ನಪ-ಳವ-ಹಽೝೞೠೡೱೲഄ-ഌഎ-ഐഒ-ഺഽൎൔ-ൖൟ-ൡൺ-ൿඅ-ඖක-නඳ-රලව-ෆก-ะาำเ-ๆກຂຄຆ-ຊຌ-ຣລວ-ະາຳຽເ-ໄໆໜ-ໟༀཀ-ཇཉ-ཬྈ-ྌက-ဪဿၐ-ၕၚ-ၝၡၥၦၮ-ၰၵ-ႁႎႠ-ჅჇჍა-ჺჼ-ቈቊ-ቍቐ-ቖቘቚ-ቝበ-ኈኊ-ኍነ-ኰኲ-ኵኸ-ኾዀዂ-ዅወ-ዖዘ-ጐጒ-ጕጘ-ፚᎀ-ᎏᎠ-Ᏽᏸ-ᏽᐁ-ᙬᙯ-ᙿᚁ-ᚚᚠ-ᛪᛮ-ᛸᜀ-ᜑᜟ-ᜱᝀ-ᝑᝠ-ᝬᝮ-ᝰក-ឳៗៜᠠ-ᡸᢀ-ᢨᢪᢰ-ᣵᤀ-ᤞᥐ-ᥭᥰ-ᥴᦀ-ᦫᦰ-ᧉᨀ-ᨖᨠ-ᩔᪧᬅ-ᬳᭅ-ᭌᮃ-ᮠᮮᮯᮺ-ᯥᰀ-ᰣᱍ-ᱏᱚ-ᱽᲀ-ᲈᲐ-ᲺᲽ-Ჿᳩ-ᳬᳮ-ᳳᳵᳶᳺᴀ-ᶿḀ-ἕἘ-Ἕἠ-ὅὈ-Ὅὐ-ὗὙὛὝὟ-ώᾀ-ᾴᾶ-ᾼιῂ-ῄῆ-ῌῐ-ΐῖ-Ίῠ-Ῥῲ-ῴῶ-ῼⁱⁿₐ-ₜℂℇℊ-ℓℕ℘-ℝℤΩℨK-ℹℼ-ℿⅅ-ⅉⅎⅠ-ↈⰀ-ⳤⳫ-ⳮⳲⳳⴀ-ⴥⴧⴭⴰ-ⵧⵯⶀ-ⶖⶠ-ⶦⶨ-ⶮⶰ-ⶶⶸ-ⶾⷀ-ⷆⷈ-ⷎⷐ-ⷖⷘ-ⷞ々-〇〡-〩〱-〵〸-〼ぁ-ゖ゛-ゟァ-ヺー-ヿㄅ-ㄯㄱ-ㆎㆠ-ㆿㇰ-ㇿ㐀-䶿一-ꒌꓐ-ꓽꔀ-ꘌꘐ-ꘟꘪꘫꙀ-ꙮꙿ-ꚝꚠ-ꛯꜗ-ꜟꜢ-ꞈꞋ-ꟊꟐꟑꟓꟕ-ꟙꟲ-ꠁꠃ-ꠅꠇ-ꠊꠌ-ꠢꡀ-ꡳꢂ-ꢳꣲ-ꣷꣻꣽꣾꤊ-ꤥꤰ-ꥆꥠ-ꥼꦄ-ꦲꧏꧠ-ꧤꧦ-ꧯꧺ-ꧾꨀ-ꨨꩀ-ꩂꩄ-ꩋꩠ-ꩶꩺꩾ-ꪯꪱꪵꪶꪹ-ꪽꫀꫂꫛ-ꫝꫠ-ꫪꫲ-ꫴꬁ-ꬆꬉ-ꬎꬑ-ꬖꬠ-ꬦꬨ-ꬮꬰ-ꭚꭜ-ꭩꭰ-ꯢ가-힣ힰ-ퟆퟋ-ퟻ豈-舘並-龎ﬀ-ﬆﬓ-ﬗיִײַ-ﬨשׁ-זּטּ-לּמּנּסּףּפּצּ-ﮱﯓ-ﴽﵐ-ﶏﶒ-ﷇﷰ-ﷻﹰ-ﹴﹶ-ﻼＡ-Ｚａ-ｚｦ-ﾾￂ-ￇￊ-ￏￒ-ￗￚ-ￜ", reservedWords = { 3: "abstract boolean byte char class double enum export extends final float goto implements import int interface long native package private protected public short static super synchronized throws transient volatile", 5: "class enum extends super const export import", 6: "enum", strict: "implements interface let package private protected public static yield", strictBind: "eval arguments" }, ecma5AndLessKeywords = "break case catch continue debugger default do else finally for function if return switch throw try var while with null true false instanceof typeof void delete new in this", keywords$1 = { 5: ecma5AndLessKeywords, "5module": ecma5AndLessKeywords + " export import", 6: ecma5AndLessKeywords + " const class extends export import super" }, keywordRelationalOperator = /^in(stanceof)?$/, nonASCIIidentifierStart = new RegExp("[" + nonASCIIidentifierStartChars + "]"), nonASCIIidentifier = new RegExp("[" + nonASCIIidentifierStartChars + "‌‍·̀-ͯ·҃-֑҇-ׇֽֿׁׂׅׄؐ-ًؚ-٩ٰۖ-ۜ۟-۪ۤۧۨ-ۭ۰-۹ܑܰ-݊ަ-ް߀-߉߫-߽߳ࠖ-࠙ࠛ-ࠣࠥ-ࠧࠩ-࡙࠭-࡛࢘-࢟࣊-ࣣ࣡-ःऺ-़ा-ॏ॑-ॗॢॣ०-९ঁ-ঃ়া-ৄেৈো-্ৗৢৣ০-৯৾ਁ-ਃ਼ਾ-ੂੇੈੋ-੍ੑ੦-ੱੵઁ-ઃ઼ા-ૅે-ૉો-્ૢૣ૦-૯ૺ-૿ଁ-ଃ଼ା-ୄେୈୋ-୍୕-ୗୢୣ୦-୯ஂா-ூெ-ைொ-்ௗ௦-௯ఀ-ఄ఼ా-ౄె-ైొ-్ౕౖౢౣ౦-౯ಁ-ಃ಼ಾ-ೄೆ-ೈೊ-್ೕೖೢೣ೦-೯ೳഀ-ഃ഻഼ാ-ൄെ-ൈൊ-്ൗൢൣ൦-൯ඁ-ඃ්ා-ුූෘ-ෟ෦-෯ෲෳัิ-ฺ็-๎๐-๙ັິ-ຼ່-໎໐-໙༘༙༠-༩༹༵༷༾༿ཱ-྄྆྇ྍ-ྗྙ-ྼ࿆ါ-ှ၀-၉ၖ-ၙၞ-ၠၢ-ၤၧ-ၭၱ-ၴႂ-ႍႏ-ႝ፝-፟፩-፱ᜒ-᜕ᜲ-᜴ᝒᝓᝲᝳ឴-៓៝០-៩᠋-᠍᠏-᠙ᢩᤠ-ᤫᤰ-᤻᥆-᥏᧐-᧚ᨗ-ᨛᩕ-ᩞ᩠-᩿᩼-᪉᪐-᪙᪰-᪽ᪿ-ᫎᬀ-ᬄ᬴-᭄᭐-᭙᭫-᭳ᮀ-ᮂᮡ-ᮭ᮰-᮹᯦-᯳ᰤ-᰷᱀-᱉᱐-᱙᳐-᳔᳒-᳨᳭᳴᳷-᳹᷀-᷿‌‍‿⁀⁔⃐-⃥⃜⃡-⃰⳯-⵿⳱ⷠ-〪ⷿ-゙゚〯・꘠-꘩꙯ꙴ-꙽ꚞꚟ꛰꛱ꠂ꠆ꠋꠣ-ꠧ꠬ꢀꢁꢴ-ꣅ꣐-꣙꣠-꣱ꣿ-꤉ꤦ-꤭ꥇ-꥓ꦀ-ꦃ꦳-꧀꧐-꧙ꧥ꧰-꧹ꨩ-ꨶꩃꩌꩍ꩐-꩙ꩻ-ꩽꪰꪲ-ꪴꪷꪸꪾ꪿꫁ꫫ-ꫯꫵ꫶ꯣ-ꯪ꯬꯭꯰-꯹ﬞ︀-️︠-︯︳︴﹍-﹏０-９＿･]");
        function isInAstralSet(code, set) {
          for (var pos = 65536, i2 = 0; i2 < set.length; i2 += 2) {
            if ((pos += set[i2]) > code)
              return false;
            if ((pos += set[i2 + 1]) >= code)
              return true;
          }
          return false;
        }
        function isIdentifierStart(code, astral) {
          return code < 65 ? 36 === code : code < 91 || (code < 97 ? 95 === code : code < 123 || (code <= 65535 ? code >= 170 && nonASCIIidentifierStart.test(String.fromCharCode(code)) : false !== astral && isInAstralSet(code, astralIdentifierStartCodes)));
        }
        function isIdentifierChar(code, astral) {
          return code < 48 ? 36 === code : code < 58 || !(code < 65) && (code < 91 || (code < 97 ? 95 === code : code < 123 || (code <= 65535 ? code >= 170 && nonASCIIidentifier.test(String.fromCharCode(code)) : false !== astral && (isInAstralSet(code, astralIdentifierStartCodes) || isInAstralSet(code, astralIdentifierCodes)))));
        }
        var TokenType2 = function(label, conf) {
          void 0 === conf && (conf = {}), this.label = label, this.keyword = conf.keyword, this.beforeExpr = !!conf.beforeExpr, this.startsExpr = !!conf.startsExpr, this.isLoop = !!conf.isLoop, this.isAssign = !!conf.isAssign, this.prefix = !!conf.prefix, this.postfix = !!conf.postfix, this.binop = conf.binop || null, this.updateContext = null;
        };
        function binop(name, prec) {
          return new TokenType2(name, { beforeExpr: true, binop: prec });
        }
        var beforeExpr = { beforeExpr: true }, startsExpr = { startsExpr: true }, keywords = {};
        function kw(name, options) {
          return void 0 === options && (options = {}), options.keyword = name, keywords[name] = new TokenType2(name, options);
        }
        var types$1 = { num: new TokenType2("num", startsExpr), regexp: new TokenType2("regexp", startsExpr), string: new TokenType2("string", startsExpr), name: new TokenType2("name", startsExpr), privateId: new TokenType2("privateId", startsExpr), eof: new TokenType2("eof"), bracketL: new TokenType2("[", { beforeExpr: true, startsExpr: true }), bracketR: new TokenType2("]"), braceL: new TokenType2("{", { beforeExpr: true, startsExpr: true }), braceR: new TokenType2("}"), parenL: new TokenType2("(", { beforeExpr: true, startsExpr: true }), parenR: new TokenType2(")"), comma: new TokenType2(",", beforeExpr), semi: new TokenType2(";", beforeExpr), colon: new TokenType2(":", beforeExpr), dot: new TokenType2("."), question: new TokenType2("?", beforeExpr), questionDot: new TokenType2("?."), arrow: new TokenType2("=>", beforeExpr), template: new TokenType2("template"), invalidTemplate: new TokenType2("invalidTemplate"), ellipsis: new TokenType2("...", beforeExpr), backQuote: new TokenType2("`", startsExpr), dollarBraceL: new TokenType2("${", { beforeExpr: true, startsExpr: true }), eq: new TokenType2("=", { beforeExpr: true, isAssign: true }), assign: new TokenType2("_=", { beforeExpr: true, isAssign: true }), incDec: new TokenType2("++/--", { prefix: true, postfix: true, startsExpr: true }), prefix: new TokenType2("!/~", { beforeExpr: true, prefix: true, startsExpr: true }), logicalOR: binop("||", 1), logicalAND: binop("&&", 2), bitwiseOR: binop("|", 3), bitwiseXOR: binop("^", 4), bitwiseAND: binop("&", 5), equality: binop("==/!=/===/!==", 6), relational: binop("</>/<=/>=", 7), bitShift: binop("<</>>/>>>", 8), plusMin: new TokenType2("+/-", { beforeExpr: true, binop: 9, prefix: true, startsExpr: true }), modulo: binop("%", 10), star: binop("*", 10), slash: binop("/", 10), starstar: new TokenType2("**", { beforeExpr: true }), coalesce: binop("??", 1), _break: kw("break"), _case: kw("case", beforeExpr), _catch: kw("catch"), _continue: kw("continue"), _debugger: kw("debugger"), _default: kw("default", beforeExpr), _do: kw("do", { isLoop: true, beforeExpr: true }), _else: kw("else", beforeExpr), _finally: kw("finally"), _for: kw("for", { isLoop: true }), _function: kw("function", startsExpr), _if: kw("if"), _return: kw("return", beforeExpr), _switch: kw("switch"), _throw: kw("throw", beforeExpr), _try: kw("try"), _var: kw("var"), _const: kw("const"), _while: kw("while", { isLoop: true }), _with: kw("with"), _new: kw("new", { beforeExpr: true, startsExpr: true }), _this: kw("this", startsExpr), _super: kw("super", startsExpr), _class: kw("class", startsExpr), _extends: kw("extends", beforeExpr), _export: kw("export"), _import: kw("import", startsExpr), _null: kw("null", startsExpr), _true: kw("true", startsExpr), _false: kw("false", startsExpr), _in: kw("in", { beforeExpr: true, binop: 7 }), _instanceof: kw("instanceof", { beforeExpr: true, binop: 7 }), _typeof: kw("typeof", { beforeExpr: true, prefix: true, startsExpr: true }), _void: kw("void", { beforeExpr: true, prefix: true, startsExpr: true }), _delete: kw("delete", { beforeExpr: true, prefix: true, startsExpr: true }) }, lineBreak = /\r\n?|\n|\u2028|\u2029/, lineBreakG = new RegExp(lineBreak.source, "g");
        function isNewLine(code) {
          return 10 === code || 13 === code || 8232 === code || 8233 === code;
        }
        function nextLineBreak(code, from, end) {
          void 0 === end && (end = code.length);
          for (var i2 = from; i2 < end; i2++) {
            var next2 = code.charCodeAt(i2);
            if (isNewLine(next2))
              return i2 < end - 1 && 13 === next2 && 10 === code.charCodeAt(i2 + 1) ? i2 + 2 : i2 + 1;
          }
          return -1;
        }
        var nonASCIIwhitespace = /[\u1680\u2000-\u200a\u202f\u205f\u3000\ufeff]/, skipWhiteSpace2 = /(?:\s|\/\/.*|\/\*[^]*?\*\/)*/g, ref = Object.prototype, acorn_hasOwnProperty = ref.hasOwnProperty, acorn_toString = ref.toString, hasOwn = Object.hasOwn || function(obj, propName) {
          return acorn_hasOwnProperty.call(obj, propName);
        }, isArray = Array.isArray || function(obj) {
          return "[object Array]" === acorn_toString.call(obj);
        }, regexpCache = /* @__PURE__ */ Object.create(null);
        function wordsRegexp(words) {
          return regexpCache[words] || (regexpCache[words] = new RegExp("^(?:" + words.replace(/ /g, "|") + ")$"));
        }
        function codePointToString(code) {
          return code <= 65535 ? String.fromCharCode(code) : (code -= 65536, String.fromCharCode(55296 + (code >> 10), 56320 + (1023 & code)));
        }
        var loneSurrogate = /(?:[\uD800-\uDBFF](?![\uDC00-\uDFFF])|(?:[^\uD800-\uDBFF]|^)[\uDC00-\uDFFF])/, Position = function(line, col) {
          this.line = line, this.column = col;
        };
        Position.prototype.offset = function(n) {
          return new Position(this.line, this.column + n);
        };
        var SourceLocation = function(p, start, end) {
          this.start = start, this.end = end, null !== p.sourceFile && (this.source = p.sourceFile);
        };
        function getLineInfo(input2, offset) {
          for (var line = 1, cur = 0; ; ) {
            var nextBreak = nextLineBreak(input2, cur, offset);
            if (nextBreak < 0)
              return new Position(line, offset - cur);
            ++line, cur = nextBreak;
          }
        }
        var defaultOptions = { ecmaVersion: null, sourceType: "script", onInsertedSemicolon: null, onTrailingComma: null, allowReserved: null, allowReturnOutsideFunction: false, allowImportExportEverywhere: false, allowAwaitOutsideFunction: null, allowSuperOutsideMethod: null, allowHashBang: false, checkPrivateFields: true, locations: false, onToken: null, onComment: null, ranges: false, program: null, sourceFile: null, directSourceFile: null, preserveParens: false }, warnedAboutEcmaVersion = false;
        function getOptions(opts) {
          var options = {};
          for (var opt2 in defaultOptions)
            options[opt2] = opts && hasOwn(opts, opt2) ? opts[opt2] : defaultOptions[opt2];
          if ("latest" === options.ecmaVersion ? options.ecmaVersion = 1e8 : null == options.ecmaVersion ? (!warnedAboutEcmaVersion && "object" == typeof console && console.warn && (warnedAboutEcmaVersion = true, console.warn("Since Acorn 8.0.0, options.ecmaVersion is required.\nDefaulting to 2020, but this will stop working in the future.")), options.ecmaVersion = 11) : options.ecmaVersion >= 2015 && (options.ecmaVersion -= 2009), null == options.allowReserved && (options.allowReserved = options.ecmaVersion < 5), opts && null != opts.allowHashBang || (options.allowHashBang = options.ecmaVersion >= 14), isArray(options.onToken)) {
            var tokens = options.onToken;
            options.onToken = function(token) {
              return tokens.push(token);
            };
          }
          return isArray(options.onComment) && (options.onComment = function(options2, array2) {
            return function(block, text, start, end, startLoc, endLoc) {
              var comment = { type: block ? "Block" : "Line", value: text, start, end };
              options2.locations && (comment.loc = new SourceLocation(this, startLoc, endLoc)), options2.ranges && (comment.range = [start, end]), array2.push(comment);
            };
          }(options, options.onComment)), options;
        }
        function functionFlags(async, generator) {
          return 2 | (async ? 4 : 0) | (generator ? 8 : 0);
        }
        var Parser = function(options, input2, startPos) {
          this.options = options = getOptions(options), this.sourceFile = options.sourceFile, this.keywords = wordsRegexp(keywords$1[options.ecmaVersion >= 6 ? 6 : "module" === options.sourceType ? "5module" : 5]);
          var reserved = "";
          true !== options.allowReserved && (reserved = reservedWords[options.ecmaVersion >= 6 ? 6 : 5 === options.ecmaVersion ? 5 : 3], "module" === options.sourceType && (reserved += " await")), this.reservedWords = wordsRegexp(reserved);
          var reservedStrict = (reserved ? reserved + " " : "") + reservedWords.strict;
          this.reservedWordsStrict = wordsRegexp(reservedStrict), this.reservedWordsStrictBind = wordsRegexp(reservedStrict + " " + reservedWords.strictBind), this.input = String(input2), this.containsEsc = false, startPos ? (this.pos = startPos, this.lineStart = this.input.lastIndexOf("\n", startPos - 1) + 1, this.curLine = this.input.slice(0, this.lineStart).split(lineBreak).length) : (this.pos = this.lineStart = 0, this.curLine = 1), this.type = types$1.eof, this.value = null, this.start = this.end = this.pos, this.startLoc = this.endLoc = this.curPosition(), this.lastTokEndLoc = this.lastTokStartLoc = null, this.lastTokStart = this.lastTokEnd = this.pos, this.context = this.initialContext(), this.exprAllowed = true, this.inModule = "module" === options.sourceType, this.strict = this.inModule || this.strictDirective(this.pos), this.potentialArrowAt = -1, this.potentialArrowInForAwait = false, this.yieldPos = this.awaitPos = this.awaitIdentPos = 0, this.labels = [], this.undefinedExports = /* @__PURE__ */ Object.create(null), 0 === this.pos && options.allowHashBang && "#!" === this.input.slice(0, 2) && this.skipLineComment(2), this.scopeStack = [], this.enterScope(1), this.regexpState = null, this.privateNameStack = [];
        }, prototypeAccessors = { inFunction: { configurable: true }, inGenerator: { configurable: true }, inAsync: { configurable: true }, canAwait: { configurable: true }, allowSuper: { configurable: true }, allowDirectSuper: { configurable: true }, treatFunctionsAsVar: { configurable: true }, allowNewDotTarget: { configurable: true }, inClassStaticBlock: { configurable: true } };
        Parser.prototype.parse = function() {
          var node = this.options.program || this.startNode();
          return this.nextToken(), this.parseTopLevel(node);
        }, prototypeAccessors.inFunction.get = function() {
          return (2 & this.currentVarScope().flags) > 0;
        }, prototypeAccessors.inGenerator.get = function() {
          return (8 & this.currentVarScope().flags) > 0 && !this.currentVarScope().inClassFieldInit;
        }, prototypeAccessors.inAsync.get = function() {
          return (4 & this.currentVarScope().flags) > 0 && !this.currentVarScope().inClassFieldInit;
        }, prototypeAccessors.canAwait.get = function() {
          for (var i2 = this.scopeStack.length - 1; i2 >= 0; i2--) {
            var scope = this.scopeStack[i2];
            if (scope.inClassFieldInit || 256 & scope.flags)
              return false;
            if (2 & scope.flags)
              return (4 & scope.flags) > 0;
          }
          return this.inModule && this.options.ecmaVersion >= 13 || this.options.allowAwaitOutsideFunction;
        }, prototypeAccessors.allowSuper.get = function() {
          var ref2 = this.currentThisScope(), flags = ref2.flags, inClassFieldInit = ref2.inClassFieldInit;
          return (64 & flags) > 0 || inClassFieldInit || this.options.allowSuperOutsideMethod;
        }, prototypeAccessors.allowDirectSuper.get = function() {
          return (128 & this.currentThisScope().flags) > 0;
        }, prototypeAccessors.treatFunctionsAsVar.get = function() {
          return this.treatFunctionsAsVarInScope(this.currentScope());
        }, prototypeAccessors.allowNewDotTarget.get = function() {
          var ref2 = this.currentThisScope(), flags = ref2.flags, inClassFieldInit = ref2.inClassFieldInit;
          return (258 & flags) > 0 || inClassFieldInit;
        }, prototypeAccessors.inClassStaticBlock.get = function() {
          return (256 & this.currentVarScope().flags) > 0;
        }, Parser.extend = function() {
          for (var plugins = [], len = arguments.length; len--; )
            plugins[len] = arguments[len];
          for (var cls = this, i2 = 0; i2 < plugins.length; i2++)
            cls = plugins[i2](cls);
          return cls;
        }, Parser.parse = function(input2, options) {
          return new this(options, input2).parse();
        }, Parser.parseExpressionAt = function(input2, pos, options) {
          var parser = new this(options, input2, pos);
          return parser.nextToken(), parser.parseExpression();
        }, Parser.tokenizer = function(input2, options) {
          return new this(options, input2);
        }, Object.defineProperties(Parser.prototype, prototypeAccessors);
        var pp$9 = Parser.prototype, literal = /^(?:'((?:\\.|[^'\\])*?)'|"((?:\\.|[^"\\])*?)")/;
        pp$9.strictDirective = function(start) {
          if (this.options.ecmaVersion < 5)
            return false;
          for (; ; ) {
            skipWhiteSpace2.lastIndex = start, start += skipWhiteSpace2.exec(this.input)[0].length;
            var match2 = literal.exec(this.input.slice(start));
            if (!match2)
              return false;
            if ("use strict" === (match2[1] || match2[2])) {
              skipWhiteSpace2.lastIndex = start + match2[0].length;
              var spaceAfter = skipWhiteSpace2.exec(this.input), end = spaceAfter.index + spaceAfter[0].length, next2 = this.input.charAt(end);
              return ";" === next2 || "}" === next2 || lineBreak.test(spaceAfter[0]) && !(/[(`.[+\-/*%<>=,?^&]/.test(next2) || "!" === next2 && "=" === this.input.charAt(end + 1));
            }
            start += match2[0].length, skipWhiteSpace2.lastIndex = start, start += skipWhiteSpace2.exec(this.input)[0].length, ";" === this.input[start] && start++;
          }
        }, pp$9.eat = function(type) {
          return this.type === type && (this.next(), true);
        }, pp$9.isContextual = function(name) {
          return this.type === types$1.name && this.value === name && !this.containsEsc;
        }, pp$9.eatContextual = function(name) {
          return !!this.isContextual(name) && (this.next(), true);
        }, pp$9.expectContextual = function(name) {
          this.eatContextual(name) || this.unexpected();
        }, pp$9.canInsertSemicolon = function() {
          return this.type === types$1.eof || this.type === types$1.braceR || lineBreak.test(this.input.slice(this.lastTokEnd, this.start));
        }, pp$9.insertSemicolon = function() {
          if (this.canInsertSemicolon())
            return this.options.onInsertedSemicolon && this.options.onInsertedSemicolon(this.lastTokEnd, this.lastTokEndLoc), true;
        }, pp$9.semicolon = function() {
          this.eat(types$1.semi) || this.insertSemicolon() || this.unexpected();
        }, pp$9.afterTrailingComma = function(tokType, notNext) {
          if (this.type === tokType)
            return this.options.onTrailingComma && this.options.onTrailingComma(this.lastTokStart, this.lastTokStartLoc), notNext || this.next(), true;
        }, pp$9.expect = function(type) {
          this.eat(type) || this.unexpected();
        }, pp$9.unexpected = function(pos) {
          this.raise(null != pos ? pos : this.start, "Unexpected token");
        };
        var DestructuringErrors = function() {
          this.shorthandAssign = this.trailingComma = this.parenthesizedAssign = this.parenthesizedBind = this.doubleProto = -1;
        };
        pp$9.checkPatternErrors = function(refDestructuringErrors, isAssign) {
          if (refDestructuringErrors) {
            refDestructuringErrors.trailingComma > -1 && this.raiseRecoverable(refDestructuringErrors.trailingComma, "Comma is not permitted after the rest element");
            var parens = isAssign ? refDestructuringErrors.parenthesizedAssign : refDestructuringErrors.parenthesizedBind;
            parens > -1 && this.raiseRecoverable(parens, isAssign ? "Assigning to rvalue" : "Parenthesized pattern");
          }
        }, pp$9.checkExpressionErrors = function(refDestructuringErrors, andThrow) {
          if (!refDestructuringErrors)
            return false;
          var shorthandAssign = refDestructuringErrors.shorthandAssign, doubleProto = refDestructuringErrors.doubleProto;
          if (!andThrow)
            return shorthandAssign >= 0 || doubleProto >= 0;
          shorthandAssign >= 0 && this.raise(shorthandAssign, "Shorthand property assignments are valid only in destructuring patterns"), doubleProto >= 0 && this.raiseRecoverable(doubleProto, "Redefinition of __proto__ property");
        }, pp$9.checkYieldAwaitInDefaultParams = function() {
          this.yieldPos && (!this.awaitPos || this.yieldPos < this.awaitPos) && this.raise(this.yieldPos, "Yield expression cannot be a default value"), this.awaitPos && this.raise(this.awaitPos, "Await expression cannot be a default value");
        }, pp$9.isSimpleAssignTarget = function(expr) {
          return "ParenthesizedExpression" === expr.type ? this.isSimpleAssignTarget(expr.expression) : "Identifier" === expr.type || "MemberExpression" === expr.type;
        };
        var pp$8 = Parser.prototype;
        pp$8.parseTopLevel = function(node) {
          var exports2 = /* @__PURE__ */ Object.create(null);
          for (node.body || (node.body = []); this.type !== types$1.eof; ) {
            var stmt = this.parseStatement(null, true, exports2);
            node.body.push(stmt);
          }
          if (this.inModule)
            for (var i2 = 0, list2 = Object.keys(this.undefinedExports); i2 < list2.length; i2 += 1) {
              var name = list2[i2];
              this.raiseRecoverable(this.undefinedExports[name].start, "Export '" + name + "' is not defined");
            }
          return this.adaptDirectivePrologue(node.body), this.next(), node.sourceType = this.options.sourceType, this.finishNode(node, "Program");
        };
        var loopLabel = { kind: "loop" }, switchLabel = { kind: "switch" };
        pp$8.isLet = function(context) {
          if (this.options.ecmaVersion < 6 || !this.isContextual("let"))
            return false;
          skipWhiteSpace2.lastIndex = this.pos;
          var skip = skipWhiteSpace2.exec(this.input), next2 = this.pos + skip[0].length, nextCh = this.input.charCodeAt(next2);
          if (91 === nextCh || 92 === nextCh)
            return true;
          if (context)
            return false;
          if (123 === nextCh || nextCh > 55295 && nextCh < 56320)
            return true;
          if (isIdentifierStart(nextCh, true)) {
            for (var pos = next2 + 1; isIdentifierChar(nextCh = this.input.charCodeAt(pos), true); )
              ++pos;
            if (92 === nextCh || nextCh > 55295 && nextCh < 56320)
              return true;
            var ident = this.input.slice(next2, pos);
            if (!keywordRelationalOperator.test(ident))
              return true;
          }
          return false;
        }, pp$8.isAsyncFunction = function() {
          if (this.options.ecmaVersion < 8 || !this.isContextual("async"))
            return false;
          skipWhiteSpace2.lastIndex = this.pos;
          var after, skip = skipWhiteSpace2.exec(this.input), next2 = this.pos + skip[0].length;
          return !(lineBreak.test(this.input.slice(this.pos, next2)) || "function" !== this.input.slice(next2, next2 + 8) || next2 + 8 !== this.input.length && (isIdentifierChar(after = this.input.charCodeAt(next2 + 8)) || after > 55295 && after < 56320));
        }, pp$8.parseStatement = function(context, topLevel, exports2) {
          var kind, starttype = this.type, node = this.startNode();
          switch (this.isLet(context) && (starttype = types$1._var, kind = "let"), starttype) {
            case types$1._break:
            case types$1._continue:
              return this.parseBreakContinueStatement(node, starttype.keyword);
            case types$1._debugger:
              return this.parseDebuggerStatement(node);
            case types$1._do:
              return this.parseDoStatement(node);
            case types$1._for:
              return this.parseForStatement(node);
            case types$1._function:
              return context && (this.strict || "if" !== context && "label" !== context) && this.options.ecmaVersion >= 6 && this.unexpected(), this.parseFunctionStatement(node, false, !context);
            case types$1._class:
              return context && this.unexpected(), this.parseClass(node, true);
            case types$1._if:
              return this.parseIfStatement(node);
            case types$1._return:
              return this.parseReturnStatement(node);
            case types$1._switch:
              return this.parseSwitchStatement(node);
            case types$1._throw:
              return this.parseThrowStatement(node);
            case types$1._try:
              return this.parseTryStatement(node);
            case types$1._const:
            case types$1._var:
              return kind = kind || this.value, context && "var" !== kind && this.unexpected(), this.parseVarStatement(node, kind);
            case types$1._while:
              return this.parseWhileStatement(node);
            case types$1._with:
              return this.parseWithStatement(node);
            case types$1.braceL:
              return this.parseBlock(true, node);
            case types$1.semi:
              return this.parseEmptyStatement(node);
            case types$1._export:
            case types$1._import:
              if (this.options.ecmaVersion > 10 && starttype === types$1._import) {
                skipWhiteSpace2.lastIndex = this.pos;
                var skip = skipWhiteSpace2.exec(this.input), next2 = this.pos + skip[0].length, nextCh = this.input.charCodeAt(next2);
                if (40 === nextCh || 46 === nextCh)
                  return this.parseExpressionStatement(node, this.parseExpression());
              }
              return this.options.allowImportExportEverywhere || (topLevel || this.raise(this.start, "'import' and 'export' may only appear at the top level"), this.inModule || this.raise(this.start, "'import' and 'export' may appear only with 'sourceType: module'")), starttype === types$1._import ? this.parseImport(node) : this.parseExport(node, exports2);
            default:
              if (this.isAsyncFunction())
                return context && this.unexpected(), this.next(), this.parseFunctionStatement(node, true, !context);
              var maybeName = this.value, expr = this.parseExpression();
              return starttype === types$1.name && "Identifier" === expr.type && this.eat(types$1.colon) ? this.parseLabeledStatement(node, maybeName, expr, context) : this.parseExpressionStatement(node, expr);
          }
        }, pp$8.parseBreakContinueStatement = function(node, keyword) {
          var isBreak = "break" === keyword;
          this.next(), this.eat(types$1.semi) || this.insertSemicolon() ? node.label = null : this.type !== types$1.name ? this.unexpected() : (node.label = this.parseIdent(), this.semicolon());
          for (var i2 = 0; i2 < this.labels.length; ++i2) {
            var lab = this.labels[i2];
            if (null == node.label || lab.name === node.label.name) {
              if (null != lab.kind && (isBreak || "loop" === lab.kind))
                break;
              if (node.label && isBreak)
                break;
            }
          }
          return i2 === this.labels.length && this.raise(node.start, "Unsyntactic " + keyword), this.finishNode(node, isBreak ? "BreakStatement" : "ContinueStatement");
        }, pp$8.parseDebuggerStatement = function(node) {
          return this.next(), this.semicolon(), this.finishNode(node, "DebuggerStatement");
        }, pp$8.parseDoStatement = function(node) {
          return this.next(), this.labels.push(loopLabel), node.body = this.parseStatement("do"), this.labels.pop(), this.expect(types$1._while), node.test = this.parseParenExpression(), this.options.ecmaVersion >= 6 ? this.eat(types$1.semi) : this.semicolon(), this.finishNode(node, "DoWhileStatement");
        }, pp$8.parseForStatement = function(node) {
          this.next();
          var awaitAt = this.options.ecmaVersion >= 9 && this.canAwait && this.eatContextual("await") ? this.lastTokStart : -1;
          if (this.labels.push(loopLabel), this.enterScope(0), this.expect(types$1.parenL), this.type === types$1.semi)
            return awaitAt > -1 && this.unexpected(awaitAt), this.parseFor(node, null);
          var isLet = this.isLet();
          if (this.type === types$1._var || this.type === types$1._const || isLet) {
            var init$1 = this.startNode(), kind = isLet ? "let" : this.value;
            return this.next(), this.parseVar(init$1, true, kind), this.finishNode(init$1, "VariableDeclaration"), (this.type === types$1._in || this.options.ecmaVersion >= 6 && this.isContextual("of")) && 1 === init$1.declarations.length ? (this.options.ecmaVersion >= 9 && (this.type === types$1._in ? awaitAt > -1 && this.unexpected(awaitAt) : node.await = awaitAt > -1), this.parseForIn(node, init$1)) : (awaitAt > -1 && this.unexpected(awaitAt), this.parseFor(node, init$1));
          }
          var startsWithLet = this.isContextual("let"), isForOf = false, refDestructuringErrors = new DestructuringErrors(), init = this.parseExpression(!(awaitAt > -1) || "await", refDestructuringErrors);
          return this.type === types$1._in || (isForOf = this.options.ecmaVersion >= 6 && this.isContextual("of")) ? (this.options.ecmaVersion >= 9 && (this.type === types$1._in ? awaitAt > -1 && this.unexpected(awaitAt) : node.await = awaitAt > -1), startsWithLet && isForOf && this.raise(init.start, "The left-hand side of a for-of loop may not start with 'let'."), this.toAssignable(init, false, refDestructuringErrors), this.checkLValPattern(init), this.parseForIn(node, init)) : (this.checkExpressionErrors(refDestructuringErrors, true), awaitAt > -1 && this.unexpected(awaitAt), this.parseFor(node, init));
        }, pp$8.parseFunctionStatement = function(node, isAsync, declarationPosition) {
          return this.next(), this.parseFunction(node, FUNC_STATEMENT | (declarationPosition ? 0 : FUNC_HANGING_STATEMENT), false, isAsync);
        }, pp$8.parseIfStatement = function(node) {
          return this.next(), node.test = this.parseParenExpression(), node.consequent = this.parseStatement("if"), node.alternate = this.eat(types$1._else) ? this.parseStatement("if") : null, this.finishNode(node, "IfStatement");
        }, pp$8.parseReturnStatement = function(node) {
          return this.inFunction || this.options.allowReturnOutsideFunction || this.raise(this.start, "'return' outside of function"), this.next(), this.eat(types$1.semi) || this.insertSemicolon() ? node.argument = null : (node.argument = this.parseExpression(), this.semicolon()), this.finishNode(node, "ReturnStatement");
        }, pp$8.parseSwitchStatement = function(node) {
          var cur;
          this.next(), node.discriminant = this.parseParenExpression(), node.cases = [], this.expect(types$1.braceL), this.labels.push(switchLabel), this.enterScope(0);
          for (var sawDefault = false; this.type !== types$1.braceR; )
            if (this.type === types$1._case || this.type === types$1._default) {
              var isCase = this.type === types$1._case;
              cur && this.finishNode(cur, "SwitchCase"), node.cases.push(cur = this.startNode()), cur.consequent = [], this.next(), isCase ? cur.test = this.parseExpression() : (sawDefault && this.raiseRecoverable(this.lastTokStart, "Multiple default clauses"), sawDefault = true, cur.test = null), this.expect(types$1.colon);
            } else
              cur || this.unexpected(), cur.consequent.push(this.parseStatement(null));
          return this.exitScope(), cur && this.finishNode(cur, "SwitchCase"), this.next(), this.labels.pop(), this.finishNode(node, "SwitchStatement");
        }, pp$8.parseThrowStatement = function(node) {
          return this.next(), lineBreak.test(this.input.slice(this.lastTokEnd, this.start)) && this.raise(this.lastTokEnd, "Illegal newline after throw"), node.argument = this.parseExpression(), this.semicolon(), this.finishNode(node, "ThrowStatement");
        };
        var empty$1 = [];
        pp$8.parseCatchClauseParam = function() {
          var param = this.parseBindingAtom(), simple = "Identifier" === param.type;
          return this.enterScope(simple ? 32 : 0), this.checkLValPattern(param, simple ? 4 : 2), this.expect(types$1.parenR), param;
        }, pp$8.parseTryStatement = function(node) {
          if (this.next(), node.block = this.parseBlock(), node.handler = null, this.type === types$1._catch) {
            var clause = this.startNode();
            this.next(), this.eat(types$1.parenL) ? clause.param = this.parseCatchClauseParam() : (this.options.ecmaVersion < 10 && this.unexpected(), clause.param = null, this.enterScope(0)), clause.body = this.parseBlock(false), this.exitScope(), node.handler = this.finishNode(clause, "CatchClause");
          }
          return node.finalizer = this.eat(types$1._finally) ? this.parseBlock() : null, node.handler || node.finalizer || this.raise(node.start, "Missing catch or finally clause"), this.finishNode(node, "TryStatement");
        }, pp$8.parseVarStatement = function(node, kind, allowMissingInitializer) {
          return this.next(), this.parseVar(node, false, kind, allowMissingInitializer), this.semicolon(), this.finishNode(node, "VariableDeclaration");
        }, pp$8.parseWhileStatement = function(node) {
          return this.next(), node.test = this.parseParenExpression(), this.labels.push(loopLabel), node.body = this.parseStatement("while"), this.labels.pop(), this.finishNode(node, "WhileStatement");
        }, pp$8.parseWithStatement = function(node) {
          return this.strict && this.raise(this.start, "'with' in strict mode"), this.next(), node.object = this.parseParenExpression(), node.body = this.parseStatement("with"), this.finishNode(node, "WithStatement");
        }, pp$8.parseEmptyStatement = function(node) {
          return this.next(), this.finishNode(node, "EmptyStatement");
        }, pp$8.parseLabeledStatement = function(node, maybeName, expr, context) {
          for (var i$1 = 0, list2 = this.labels; i$1 < list2.length; i$1 += 1) {
            list2[i$1].name === maybeName && this.raise(expr.start, "Label '" + maybeName + "' is already declared");
          }
          for (var kind = this.type.isLoop ? "loop" : this.type === types$1._switch ? "switch" : null, i2 = this.labels.length - 1; i2 >= 0; i2--) {
            var label$1 = this.labels[i2];
            if (label$1.statementStart !== node.start)
              break;
            label$1.statementStart = this.start, label$1.kind = kind;
          }
          return this.labels.push({ name: maybeName, kind, statementStart: this.start }), node.body = this.parseStatement(context ? -1 === context.indexOf("label") ? context + "label" : context : "label"), this.labels.pop(), node.label = expr, this.finishNode(node, "LabeledStatement");
        }, pp$8.parseExpressionStatement = function(node, expr) {
          return node.expression = expr, this.semicolon(), this.finishNode(node, "ExpressionStatement");
        }, pp$8.parseBlock = function(createNewLexicalScope, node, exitStrict) {
          for (void 0 === createNewLexicalScope && (createNewLexicalScope = true), void 0 === node && (node = this.startNode()), node.body = [], this.expect(types$1.braceL), createNewLexicalScope && this.enterScope(0); this.type !== types$1.braceR; ) {
            var stmt = this.parseStatement(null);
            node.body.push(stmt);
          }
          return exitStrict && (this.strict = false), this.next(), createNewLexicalScope && this.exitScope(), this.finishNode(node, "BlockStatement");
        }, pp$8.parseFor = function(node, init) {
          return node.init = init, this.expect(types$1.semi), node.test = this.type === types$1.semi ? null : this.parseExpression(), this.expect(types$1.semi), node.update = this.type === types$1.parenR ? null : this.parseExpression(), this.expect(types$1.parenR), node.body = this.parseStatement("for"), this.exitScope(), this.labels.pop(), this.finishNode(node, "ForStatement");
        }, pp$8.parseForIn = function(node, init) {
          var isForIn = this.type === types$1._in;
          return this.next(), "VariableDeclaration" === init.type && null != init.declarations[0].init && (!isForIn || this.options.ecmaVersion < 8 || this.strict || "var" !== init.kind || "Identifier" !== init.declarations[0].id.type) && this.raise(init.start, (isForIn ? "for-in" : "for-of") + " loop variable declaration may not have an initializer"), node.left = init, node.right = isForIn ? this.parseExpression() : this.parseMaybeAssign(), this.expect(types$1.parenR), node.body = this.parseStatement("for"), this.exitScope(), this.labels.pop(), this.finishNode(node, isForIn ? "ForInStatement" : "ForOfStatement");
        }, pp$8.parseVar = function(node, isFor, kind, allowMissingInitializer) {
          for (node.declarations = [], node.kind = kind; ; ) {
            var decl = this.startNode();
            if (this.parseVarId(decl, kind), this.eat(types$1.eq) ? decl.init = this.parseMaybeAssign(isFor) : allowMissingInitializer || "const" !== kind || this.type === types$1._in || this.options.ecmaVersion >= 6 && this.isContextual("of") ? allowMissingInitializer || "Identifier" === decl.id.type || isFor && (this.type === types$1._in || this.isContextual("of")) ? decl.init = null : this.raise(this.lastTokEnd, "Complex binding patterns require an initialization value") : this.unexpected(), node.declarations.push(this.finishNode(decl, "VariableDeclarator")), !this.eat(types$1.comma))
              break;
          }
          return node;
        }, pp$8.parseVarId = function(decl, kind) {
          decl.id = this.parseBindingAtom(), this.checkLValPattern(decl.id, "var" === kind ? 1 : 2, false);
        };
        var FUNC_STATEMENT = 1, FUNC_HANGING_STATEMENT = 2;
        function isPrivateNameConflicted(privateNameMap, element) {
          var name = element.key.name, curr = privateNameMap[name], next2 = "true";
          return "MethodDefinition" !== element.type || "get" !== element.kind && "set" !== element.kind || (next2 = (element.static ? "s" : "i") + element.kind), "iget" === curr && "iset" === next2 || "iset" === curr && "iget" === next2 || "sget" === curr && "sset" === next2 || "sset" === curr && "sget" === next2 ? (privateNameMap[name] = "true", false) : !!curr || (privateNameMap[name] = next2, false);
        }
        function checkKeyName(node, name) {
          var computed = node.computed, key = node.key;
          return !computed && ("Identifier" === key.type && key.name === name || "Literal" === key.type && key.value === name);
        }
        pp$8.parseFunction = function(node, statement, allowExpressionBody, isAsync, forInit) {
          this.initFunction(node), (this.options.ecmaVersion >= 9 || this.options.ecmaVersion >= 6 && !isAsync) && (this.type === types$1.star && statement & FUNC_HANGING_STATEMENT && this.unexpected(), node.generator = this.eat(types$1.star)), this.options.ecmaVersion >= 8 && (node.async = !!isAsync), statement & FUNC_STATEMENT && (node.id = 4 & statement && this.type !== types$1.name ? null : this.parseIdent(), !node.id || statement & FUNC_HANGING_STATEMENT || this.checkLValSimple(node.id, this.strict || node.generator || node.async ? this.treatFunctionsAsVar ? 1 : 2 : 3));
          var oldYieldPos = this.yieldPos, oldAwaitPos = this.awaitPos, oldAwaitIdentPos = this.awaitIdentPos;
          return this.yieldPos = 0, this.awaitPos = 0, this.awaitIdentPos = 0, this.enterScope(functionFlags(node.async, node.generator)), statement & FUNC_STATEMENT || (node.id = this.type === types$1.name ? this.parseIdent() : null), this.parseFunctionParams(node), this.parseFunctionBody(node, allowExpressionBody, false, forInit), this.yieldPos = oldYieldPos, this.awaitPos = oldAwaitPos, this.awaitIdentPos = oldAwaitIdentPos, this.finishNode(node, statement & FUNC_STATEMENT ? "FunctionDeclaration" : "FunctionExpression");
        }, pp$8.parseFunctionParams = function(node) {
          this.expect(types$1.parenL), node.params = this.parseBindingList(types$1.parenR, false, this.options.ecmaVersion >= 8), this.checkYieldAwaitInDefaultParams();
        }, pp$8.parseClass = function(node, isStatement) {
          this.next();
          var oldStrict = this.strict;
          this.strict = true, this.parseClassId(node, isStatement), this.parseClassSuper(node);
          var privateNameMap = this.enterClassBody(), classBody = this.startNode(), hadConstructor = false;
          for (classBody.body = [], this.expect(types$1.braceL); this.type !== types$1.braceR; ) {
            var element = this.parseClassElement(null !== node.superClass);
            element && (classBody.body.push(element), "MethodDefinition" === element.type && "constructor" === element.kind ? (hadConstructor && this.raiseRecoverable(element.start, "Duplicate constructor in the same class"), hadConstructor = true) : element.key && "PrivateIdentifier" === element.key.type && isPrivateNameConflicted(privateNameMap, element) && this.raiseRecoverable(element.key.start, "Identifier '#" + element.key.name + "' has already been declared"));
          }
          return this.strict = oldStrict, this.next(), node.body = this.finishNode(classBody, "ClassBody"), this.exitClassBody(), this.finishNode(node, isStatement ? "ClassDeclaration" : "ClassExpression");
        }, pp$8.parseClassElement = function(constructorAllowsSuper) {
          if (this.eat(types$1.semi))
            return null;
          var ecmaVersion = this.options.ecmaVersion, node = this.startNode(), keyName = "", isGenerator = false, isAsync = false, kind = "method", isStatic = false;
          if (this.eatContextual("static")) {
            if (ecmaVersion >= 13 && this.eat(types$1.braceL))
              return this.parseClassStaticBlock(node), node;
            this.isClassElementNameStart() || this.type === types$1.star ? isStatic = true : keyName = "static";
          }
          if (node.static = isStatic, !keyName && ecmaVersion >= 8 && this.eatContextual("async") && (!this.isClassElementNameStart() && this.type !== types$1.star || this.canInsertSemicolon() ? keyName = "async" : isAsync = true), !keyName && (ecmaVersion >= 9 || !isAsync) && this.eat(types$1.star) && (isGenerator = true), !keyName && !isAsync && !isGenerator) {
            var lastValue = this.value;
            (this.eatContextual("get") || this.eatContextual("set")) && (this.isClassElementNameStart() ? kind = lastValue : keyName = lastValue);
          }
          if (keyName ? (node.computed = false, node.key = this.startNodeAt(this.lastTokStart, this.lastTokStartLoc), node.key.name = keyName, this.finishNode(node.key, "Identifier")) : this.parseClassElementName(node), ecmaVersion < 13 || this.type === types$1.parenL || "method" !== kind || isGenerator || isAsync) {
            var isConstructor = !node.static && checkKeyName(node, "constructor"), allowsDirectSuper = isConstructor && constructorAllowsSuper;
            isConstructor && "method" !== kind && this.raise(node.key.start, "Constructor can't have get/set modifier"), node.kind = isConstructor ? "constructor" : kind, this.parseClassMethod(node, isGenerator, isAsync, allowsDirectSuper);
          } else
            this.parseClassField(node);
          return node;
        }, pp$8.isClassElementNameStart = function() {
          return this.type === types$1.name || this.type === types$1.privateId || this.type === types$1.num || this.type === types$1.string || this.type === types$1.bracketL || this.type.keyword;
        }, pp$8.parseClassElementName = function(element) {
          this.type === types$1.privateId ? ("constructor" === this.value && this.raise(this.start, "Classes can't have an element named '#constructor'"), element.computed = false, element.key = this.parsePrivateIdent()) : this.parsePropertyName(element);
        }, pp$8.parseClassMethod = function(method, isGenerator, isAsync, allowsDirectSuper) {
          var key = method.key;
          "constructor" === method.kind ? (isGenerator && this.raise(key.start, "Constructor can't be a generator"), isAsync && this.raise(key.start, "Constructor can't be an async method")) : method.static && checkKeyName(method, "prototype") && this.raise(key.start, "Classes may not have a static property named prototype");
          var value2 = method.value = this.parseMethod(isGenerator, isAsync, allowsDirectSuper);
          return "get" === method.kind && 0 !== value2.params.length && this.raiseRecoverable(value2.start, "getter should have no params"), "set" === method.kind && 1 !== value2.params.length && this.raiseRecoverable(value2.start, "setter should have exactly one param"), "set" === method.kind && "RestElement" === value2.params[0].type && this.raiseRecoverable(value2.params[0].start, "Setter cannot use rest params"), this.finishNode(method, "MethodDefinition");
        }, pp$8.parseClassField = function(field) {
          if (checkKeyName(field, "constructor") ? this.raise(field.key.start, "Classes can't have a field named 'constructor'") : field.static && checkKeyName(field, "prototype") && this.raise(field.key.start, "Classes can't have a static field named 'prototype'"), this.eat(types$1.eq)) {
            var scope = this.currentThisScope(), inClassFieldInit = scope.inClassFieldInit;
            scope.inClassFieldInit = true, field.value = this.parseMaybeAssign(), scope.inClassFieldInit = inClassFieldInit;
          } else
            field.value = null;
          return this.semicolon(), this.finishNode(field, "PropertyDefinition");
        }, pp$8.parseClassStaticBlock = function(node) {
          node.body = [];
          var oldLabels = this.labels;
          for (this.labels = [], this.enterScope(320); this.type !== types$1.braceR; ) {
            var stmt = this.parseStatement(null);
            node.body.push(stmt);
          }
          return this.next(), this.exitScope(), this.labels = oldLabels, this.finishNode(node, "StaticBlock");
        }, pp$8.parseClassId = function(node, isStatement) {
          this.type === types$1.name ? (node.id = this.parseIdent(), isStatement && this.checkLValSimple(node.id, 2, false)) : (true === isStatement && this.unexpected(), node.id = null);
        }, pp$8.parseClassSuper = function(node) {
          node.superClass = this.eat(types$1._extends) ? this.parseExprSubscripts(null, false) : null;
        }, pp$8.enterClassBody = function() {
          var element = { declared: /* @__PURE__ */ Object.create(null), used: [] };
          return this.privateNameStack.push(element), element.declared;
        }, pp$8.exitClassBody = function() {
          var ref2 = this.privateNameStack.pop(), declared = ref2.declared, used = ref2.used;
          if (this.options.checkPrivateFields)
            for (var len = this.privateNameStack.length, parent = 0 === len ? null : this.privateNameStack[len - 1], i2 = 0; i2 < used.length; ++i2) {
              var id = used[i2];
              hasOwn(declared, id.name) || (parent ? parent.used.push(id) : this.raiseRecoverable(id.start, "Private field '#" + id.name + "' must be declared in an enclosing class"));
            }
        }, pp$8.parseExportAllDeclaration = function(node, exports2) {
          return this.options.ecmaVersion >= 11 && (this.eatContextual("as") ? (node.exported = this.parseModuleExportName(), this.checkExport(exports2, node.exported, this.lastTokStart)) : node.exported = null), this.expectContextual("from"), this.type !== types$1.string && this.unexpected(), node.source = this.parseExprAtom(), this.semicolon(), this.finishNode(node, "ExportAllDeclaration");
        }, pp$8.parseExport = function(node, exports2) {
          if (this.next(), this.eat(types$1.star))
            return this.parseExportAllDeclaration(node, exports2);
          if (this.eat(types$1._default))
            return this.checkExport(exports2, "default", this.lastTokStart), node.declaration = this.parseExportDefaultDeclaration(), this.finishNode(node, "ExportDefaultDeclaration");
          if (this.shouldParseExportStatement())
            node.declaration = this.parseExportDeclaration(node), "VariableDeclaration" === node.declaration.type ? this.checkVariableExport(exports2, node.declaration.declarations) : this.checkExport(exports2, node.declaration.id, node.declaration.id.start), node.specifiers = [], node.source = null;
          else {
            if (node.declaration = null, node.specifiers = this.parseExportSpecifiers(exports2), this.eatContextual("from"))
              this.type !== types$1.string && this.unexpected(), node.source = this.parseExprAtom();
            else {
              for (var i2 = 0, list2 = node.specifiers; i2 < list2.length; i2 += 1) {
                var spec = list2[i2];
                this.checkUnreserved(spec.local), this.checkLocalExport(spec.local), "Literal" === spec.local.type && this.raise(spec.local.start, "A string literal cannot be used as an exported binding without `from`.");
              }
              node.source = null;
            }
            this.semicolon();
          }
          return this.finishNode(node, "ExportNamedDeclaration");
        }, pp$8.parseExportDeclaration = function(node) {
          return this.parseStatement(null);
        }, pp$8.parseExportDefaultDeclaration = function() {
          var isAsync;
          if (this.type === types$1._function || (isAsync = this.isAsyncFunction())) {
            var fNode = this.startNode();
            return this.next(), isAsync && this.next(), this.parseFunction(fNode, 4 | FUNC_STATEMENT, false, isAsync);
          }
          if (this.type === types$1._class) {
            var cNode = this.startNode();
            return this.parseClass(cNode, "nullableID");
          }
          var declaration = this.parseMaybeAssign();
          return this.semicolon(), declaration;
        }, pp$8.checkExport = function(exports2, name, pos) {
          exports2 && ("string" != typeof name && (name = "Identifier" === name.type ? name.name : name.value), hasOwn(exports2, name) && this.raiseRecoverable(pos, "Duplicate export '" + name + "'"), exports2[name] = true);
        }, pp$8.checkPatternExport = function(exports2, pat) {
          var type = pat.type;
          if ("Identifier" === type)
            this.checkExport(exports2, pat, pat.start);
          else if ("ObjectPattern" === type)
            for (var i2 = 0, list2 = pat.properties; i2 < list2.length; i2 += 1) {
              var prop = list2[i2];
              this.checkPatternExport(exports2, prop);
            }
          else if ("ArrayPattern" === type)
            for (var i$1 = 0, list$1 = pat.elements; i$1 < list$1.length; i$1 += 1) {
              var elt = list$1[i$1];
              elt && this.checkPatternExport(exports2, elt);
            }
          else
            "Property" === type ? this.checkPatternExport(exports2, pat.value) : "AssignmentPattern" === type ? this.checkPatternExport(exports2, pat.left) : "RestElement" === type && this.checkPatternExport(exports2, pat.argument);
        }, pp$8.checkVariableExport = function(exports2, decls) {
          if (exports2)
            for (var i2 = 0, list2 = decls; i2 < list2.length; i2 += 1) {
              var decl = list2[i2];
              this.checkPatternExport(exports2, decl.id);
            }
        }, pp$8.shouldParseExportStatement = function() {
          return "var" === this.type.keyword || "const" === this.type.keyword || "class" === this.type.keyword || "function" === this.type.keyword || this.isLet() || this.isAsyncFunction();
        }, pp$8.parseExportSpecifier = function(exports2) {
          var node = this.startNode();
          return node.local = this.parseModuleExportName(), node.exported = this.eatContextual("as") ? this.parseModuleExportName() : node.local, this.checkExport(exports2, node.exported, node.exported.start), this.finishNode(node, "ExportSpecifier");
        }, pp$8.parseExportSpecifiers = function(exports2) {
          var nodes = [], first = true;
          for (this.expect(types$1.braceL); !this.eat(types$1.braceR); ) {
            if (first)
              first = false;
            else if (this.expect(types$1.comma), this.afterTrailingComma(types$1.braceR))
              break;
            nodes.push(this.parseExportSpecifier(exports2));
          }
          return nodes;
        }, pp$8.parseImport = function(node) {
          return this.next(), this.type === types$1.string ? (node.specifiers = empty$1, node.source = this.parseExprAtom()) : (node.specifiers = this.parseImportSpecifiers(), this.expectContextual("from"), node.source = this.type === types$1.string ? this.parseExprAtom() : this.unexpected()), this.semicolon(), this.finishNode(node, "ImportDeclaration");
        }, pp$8.parseImportSpecifier = function() {
          var node = this.startNode();
          return node.imported = this.parseModuleExportName(), this.eatContextual("as") ? node.local = this.parseIdent() : (this.checkUnreserved(node.imported), node.local = node.imported), this.checkLValSimple(node.local, 2), this.finishNode(node, "ImportSpecifier");
        }, pp$8.parseImportDefaultSpecifier = function() {
          var node = this.startNode();
          return node.local = this.parseIdent(), this.checkLValSimple(node.local, 2), this.finishNode(node, "ImportDefaultSpecifier");
        }, pp$8.parseImportNamespaceSpecifier = function() {
          var node = this.startNode();
          return this.next(), this.expectContextual("as"), node.local = this.parseIdent(), this.checkLValSimple(node.local, 2), this.finishNode(node, "ImportNamespaceSpecifier");
        }, pp$8.parseImportSpecifiers = function() {
          var nodes = [], first = true;
          if (this.type === types$1.name && (nodes.push(this.parseImportDefaultSpecifier()), !this.eat(types$1.comma)))
            return nodes;
          if (this.type === types$1.star)
            return nodes.push(this.parseImportNamespaceSpecifier()), nodes;
          for (this.expect(types$1.braceL); !this.eat(types$1.braceR); ) {
            if (first)
              first = false;
            else if (this.expect(types$1.comma), this.afterTrailingComma(types$1.braceR))
              break;
            nodes.push(this.parseImportSpecifier());
          }
          return nodes;
        }, pp$8.parseModuleExportName = function() {
          if (this.options.ecmaVersion >= 13 && this.type === types$1.string) {
            var stringLiteral = this.parseLiteral(this.value);
            return loneSurrogate.test(stringLiteral.value) && this.raise(stringLiteral.start, "An export name cannot include a lone surrogate."), stringLiteral;
          }
          return this.parseIdent(true);
        }, pp$8.adaptDirectivePrologue = function(statements) {
          for (var i2 = 0; i2 < statements.length && this.isDirectiveCandidate(statements[i2]); ++i2)
            statements[i2].directive = statements[i2].expression.raw.slice(1, -1);
        }, pp$8.isDirectiveCandidate = function(statement) {
          return this.options.ecmaVersion >= 5 && "ExpressionStatement" === statement.type && "Literal" === statement.expression.type && "string" == typeof statement.expression.value && ('"' === this.input[statement.start] || "'" === this.input[statement.start]);
        };
        var pp$7 = Parser.prototype;
        pp$7.toAssignable = function(node, isBinding, refDestructuringErrors) {
          if (this.options.ecmaVersion >= 6 && node)
            switch (node.type) {
              case "Identifier":
                this.inAsync && "await" === node.name && this.raise(node.start, "Cannot use 'await' as identifier inside an async function");
                break;
              case "ObjectPattern":
              case "ArrayPattern":
              case "AssignmentPattern":
              case "RestElement":
                break;
              case "ObjectExpression":
                node.type = "ObjectPattern", refDestructuringErrors && this.checkPatternErrors(refDestructuringErrors, true);
                for (var i2 = 0, list2 = node.properties; i2 < list2.length; i2 += 1) {
                  var prop = list2[i2];
                  this.toAssignable(prop, isBinding), "RestElement" !== prop.type || "ArrayPattern" !== prop.argument.type && "ObjectPattern" !== prop.argument.type || this.raise(prop.argument.start, "Unexpected token");
                }
                break;
              case "Property":
                "init" !== node.kind && this.raise(node.key.start, "Object pattern can't contain getter or setter"), this.toAssignable(node.value, isBinding);
                break;
              case "ArrayExpression":
                node.type = "ArrayPattern", refDestructuringErrors && this.checkPatternErrors(refDestructuringErrors, true), this.toAssignableList(node.elements, isBinding);
                break;
              case "SpreadElement":
                node.type = "RestElement", this.toAssignable(node.argument, isBinding), "AssignmentPattern" === node.argument.type && this.raise(node.argument.start, "Rest elements cannot have a default value");
                break;
              case "AssignmentExpression":
                "=" !== node.operator && this.raise(node.left.end, "Only '=' operator can be used for specifying default value."), node.type = "AssignmentPattern", delete node.operator, this.toAssignable(node.left, isBinding);
                break;
              case "ParenthesizedExpression":
                this.toAssignable(node.expression, isBinding, refDestructuringErrors);
                break;
              case "ChainExpression":
                this.raiseRecoverable(node.start, "Optional chaining cannot appear in left-hand side");
                break;
              case "MemberExpression":
                if (!isBinding)
                  break;
              default:
                this.raise(node.start, "Assigning to rvalue");
            }
          else
            refDestructuringErrors && this.checkPatternErrors(refDestructuringErrors, true);
          return node;
        }, pp$7.toAssignableList = function(exprList, isBinding) {
          for (var end = exprList.length, i2 = 0; i2 < end; i2++) {
            var elt = exprList[i2];
            elt && this.toAssignable(elt, isBinding);
          }
          if (end) {
            var last = exprList[end - 1];
            6 === this.options.ecmaVersion && isBinding && last && "RestElement" === last.type && "Identifier" !== last.argument.type && this.unexpected(last.argument.start);
          }
          return exprList;
        }, pp$7.parseSpread = function(refDestructuringErrors) {
          var node = this.startNode();
          return this.next(), node.argument = this.parseMaybeAssign(false, refDestructuringErrors), this.finishNode(node, "SpreadElement");
        }, pp$7.parseRestBinding = function() {
          var node = this.startNode();
          return this.next(), 6 === this.options.ecmaVersion && this.type !== types$1.name && this.unexpected(), node.argument = this.parseBindingAtom(), this.finishNode(node, "RestElement");
        }, pp$7.parseBindingAtom = function() {
          if (this.options.ecmaVersion >= 6)
            switch (this.type) {
              case types$1.bracketL:
                var node = this.startNode();
                return this.next(), node.elements = this.parseBindingList(types$1.bracketR, true, true), this.finishNode(node, "ArrayPattern");
              case types$1.braceL:
                return this.parseObj(true);
            }
          return this.parseIdent();
        }, pp$7.parseBindingList = function(close, allowEmpty, allowTrailingComma, allowModifiers) {
          for (var elts = [], first = true; !this.eat(close); )
            if (first ? first = false : this.expect(types$1.comma), allowEmpty && this.type === types$1.comma)
              elts.push(null);
            else {
              if (allowTrailingComma && this.afterTrailingComma(close))
                break;
              if (this.type === types$1.ellipsis) {
                var rest = this.parseRestBinding();
                this.parseBindingListItem(rest), elts.push(rest), this.type === types$1.comma && this.raiseRecoverable(this.start, "Comma is not permitted after the rest element"), this.expect(close);
                break;
              }
              elts.push(this.parseAssignableListItem(allowModifiers));
            }
          return elts;
        }, pp$7.parseAssignableListItem = function(allowModifiers) {
          var elem = this.parseMaybeDefault(this.start, this.startLoc);
          return this.parseBindingListItem(elem), elem;
        }, pp$7.parseBindingListItem = function(param) {
          return param;
        }, pp$7.parseMaybeDefault = function(startPos, startLoc, left) {
          if (left = left || this.parseBindingAtom(), this.options.ecmaVersion < 6 || !this.eat(types$1.eq))
            return left;
          var node = this.startNodeAt(startPos, startLoc);
          return node.left = left, node.right = this.parseMaybeAssign(), this.finishNode(node, "AssignmentPattern");
        }, pp$7.checkLValSimple = function(expr, bindingType, checkClashes) {
          void 0 === bindingType && (bindingType = 0);
          var isBind = 0 !== bindingType;
          switch (expr.type) {
            case "Identifier":
              this.strict && this.reservedWordsStrictBind.test(expr.name) && this.raiseRecoverable(expr.start, (isBind ? "Binding " : "Assigning to ") + expr.name + " in strict mode"), isBind && (2 === bindingType && "let" === expr.name && this.raiseRecoverable(expr.start, "let is disallowed as a lexically bound name"), checkClashes && (hasOwn(checkClashes, expr.name) && this.raiseRecoverable(expr.start, "Argument name clash"), checkClashes[expr.name] = true), 5 !== bindingType && this.declareName(expr.name, bindingType, expr.start));
              break;
            case "ChainExpression":
              this.raiseRecoverable(expr.start, "Optional chaining cannot appear in left-hand side");
              break;
            case "MemberExpression":
              isBind && this.raiseRecoverable(expr.start, "Binding member expression");
              break;
            case "ParenthesizedExpression":
              return isBind && this.raiseRecoverable(expr.start, "Binding parenthesized expression"), this.checkLValSimple(expr.expression, bindingType, checkClashes);
            default:
              this.raise(expr.start, (isBind ? "Binding" : "Assigning to") + " rvalue");
          }
        }, pp$7.checkLValPattern = function(expr, bindingType, checkClashes) {
          switch (void 0 === bindingType && (bindingType = 0), expr.type) {
            case "ObjectPattern":
              for (var i2 = 0, list2 = expr.properties; i2 < list2.length; i2 += 1) {
                var prop = list2[i2];
                this.checkLValInnerPattern(prop, bindingType, checkClashes);
              }
              break;
            case "ArrayPattern":
              for (var i$1 = 0, list$1 = expr.elements; i$1 < list$1.length; i$1 += 1) {
                var elem = list$1[i$1];
                elem && this.checkLValInnerPattern(elem, bindingType, checkClashes);
              }
              break;
            default:
              this.checkLValSimple(expr, bindingType, checkClashes);
          }
        }, pp$7.checkLValInnerPattern = function(expr, bindingType, checkClashes) {
          switch (void 0 === bindingType && (bindingType = 0), expr.type) {
            case "Property":
              this.checkLValInnerPattern(expr.value, bindingType, checkClashes);
              break;
            case "AssignmentPattern":
              this.checkLValPattern(expr.left, bindingType, checkClashes);
              break;
            case "RestElement":
              this.checkLValPattern(expr.argument, bindingType, checkClashes);
              break;
            default:
              this.checkLValPattern(expr, bindingType, checkClashes);
          }
        };
        var TokContext = function(token, isExpr, preserveSpace, override, generator) {
          this.token = token, this.isExpr = !!isExpr, this.preserveSpace = !!preserveSpace, this.override = override, this.generator = !!generator;
        }, types = { b_stat: new TokContext("{", false), b_expr: new TokContext("{", true), b_tmpl: new TokContext("${", false), p_stat: new TokContext("(", false), p_expr: new TokContext("(", true), q_tmpl: new TokContext("`", true, true, function(p) {
          return p.tryReadTemplateToken();
        }), f_stat: new TokContext("function", false), f_expr: new TokContext("function", true), f_expr_gen: new TokContext("function", true, false, null, true), f_gen: new TokContext("function", false, false, null, true) }, pp$6 = Parser.prototype;
        pp$6.initialContext = function() {
          return [types.b_stat];
        }, pp$6.curContext = function() {
          return this.context[this.context.length - 1];
        }, pp$6.braceIsBlock = function(prevType) {
          var parent = this.curContext();
          return parent === types.f_expr || parent === types.f_stat || (prevType !== types$1.colon || parent !== types.b_stat && parent !== types.b_expr ? prevType === types$1._return || prevType === types$1.name && this.exprAllowed ? lineBreak.test(this.input.slice(this.lastTokEnd, this.start)) : prevType === types$1._else || prevType === types$1.semi || prevType === types$1.eof || prevType === types$1.parenR || prevType === types$1.arrow || (prevType === types$1.braceL ? parent === types.b_stat : prevType !== types$1._var && prevType !== types$1._const && prevType !== types$1.name && !this.exprAllowed) : !parent.isExpr);
        }, pp$6.inGeneratorContext = function() {
          for (var i2 = this.context.length - 1; i2 >= 1; i2--) {
            var context = this.context[i2];
            if ("function" === context.token)
              return context.generator;
          }
          return false;
        }, pp$6.updateContext = function(prevType) {
          var update, type = this.type;
          type.keyword && prevType === types$1.dot ? this.exprAllowed = false : (update = type.updateContext) ? update.call(this, prevType) : this.exprAllowed = type.beforeExpr;
        }, pp$6.overrideContext = function(tokenCtx) {
          this.curContext() !== tokenCtx && (this.context[this.context.length - 1] = tokenCtx);
        }, types$1.parenR.updateContext = types$1.braceR.updateContext = function() {
          if (1 !== this.context.length) {
            var out = this.context.pop();
            out === types.b_stat && "function" === this.curContext().token && (out = this.context.pop()), this.exprAllowed = !out.isExpr;
          } else
            this.exprAllowed = true;
        }, types$1.braceL.updateContext = function(prevType) {
          this.context.push(this.braceIsBlock(prevType) ? types.b_stat : types.b_expr), this.exprAllowed = true;
        }, types$1.dollarBraceL.updateContext = function() {
          this.context.push(types.b_tmpl), this.exprAllowed = true;
        }, types$1.parenL.updateContext = function(prevType) {
          var statementParens = prevType === types$1._if || prevType === types$1._for || prevType === types$1._with || prevType === types$1._while;
          this.context.push(statementParens ? types.p_stat : types.p_expr), this.exprAllowed = true;
        }, types$1.incDec.updateContext = function() {
        }, types$1._function.updateContext = types$1._class.updateContext = function(prevType) {
          !prevType.beforeExpr || prevType === types$1._else || prevType === types$1.semi && this.curContext() !== types.p_stat || prevType === types$1._return && lineBreak.test(this.input.slice(this.lastTokEnd, this.start)) || (prevType === types$1.colon || prevType === types$1.braceL) && this.curContext() === types.b_stat ? this.context.push(types.f_stat) : this.context.push(types.f_expr), this.exprAllowed = false;
        }, types$1.colon.updateContext = function() {
          "function" === this.curContext().token && this.context.pop(), this.exprAllowed = true;
        }, types$1.backQuote.updateContext = function() {
          this.curContext() === types.q_tmpl ? this.context.pop() : this.context.push(types.q_tmpl), this.exprAllowed = false;
        }, types$1.star.updateContext = function(prevType) {
          if (prevType === types$1._function) {
            var index = this.context.length - 1;
            this.context[index] === types.f_expr ? this.context[index] = types.f_expr_gen : this.context[index] = types.f_gen;
          }
          this.exprAllowed = true;
        }, types$1.name.updateContext = function(prevType) {
          var allowed = false;
          this.options.ecmaVersion >= 6 && prevType !== types$1.dot && ("of" === this.value && !this.exprAllowed || "yield" === this.value && this.inGeneratorContext()) && (allowed = true), this.exprAllowed = allowed;
        };
        var pp$5 = Parser.prototype;
        function isPrivateFieldAccess(node) {
          return "MemberExpression" === node.type && "PrivateIdentifier" === node.property.type || "ChainExpression" === node.type && isPrivateFieldAccess(node.expression);
        }
        pp$5.checkPropClash = function(prop, propHash, refDestructuringErrors) {
          if (!(this.options.ecmaVersion >= 9 && "SpreadElement" === prop.type || this.options.ecmaVersion >= 6 && (prop.computed || prop.method || prop.shorthand))) {
            var name, key = prop.key;
            switch (key.type) {
              case "Identifier":
                name = key.name;
                break;
              case "Literal":
                name = String(key.value);
                break;
              default:
                return;
            }
            var kind = prop.kind;
            if (this.options.ecmaVersion >= 6)
              "__proto__" === name && "init" === kind && (propHash.proto && (refDestructuringErrors ? refDestructuringErrors.doubleProto < 0 && (refDestructuringErrors.doubleProto = key.start) : this.raiseRecoverable(key.start, "Redefinition of __proto__ property")), propHash.proto = true);
            else {
              var other = propHash[name = "$" + name];
              if (other)
                ("init" === kind ? this.strict && other.init || other.get || other.set : other.init || other[kind]) && this.raiseRecoverable(key.start, "Redefinition of property");
              else
                other = propHash[name] = { init: false, get: false, set: false };
              other[kind] = true;
            }
          }
        }, pp$5.parseExpression = function(forInit, refDestructuringErrors) {
          var startPos = this.start, startLoc = this.startLoc, expr = this.parseMaybeAssign(forInit, refDestructuringErrors);
          if (this.type === types$1.comma) {
            var node = this.startNodeAt(startPos, startLoc);
            for (node.expressions = [expr]; this.eat(types$1.comma); )
              node.expressions.push(this.parseMaybeAssign(forInit, refDestructuringErrors));
            return this.finishNode(node, "SequenceExpression");
          }
          return expr;
        }, pp$5.parseMaybeAssign = function(forInit, refDestructuringErrors, afterLeftParse) {
          if (this.isContextual("yield")) {
            if (this.inGenerator)
              return this.parseYield(forInit);
            this.exprAllowed = false;
          }
          var ownDestructuringErrors = false, oldParenAssign = -1, oldTrailingComma = -1, oldDoubleProto = -1;
          refDestructuringErrors ? (oldParenAssign = refDestructuringErrors.parenthesizedAssign, oldTrailingComma = refDestructuringErrors.trailingComma, oldDoubleProto = refDestructuringErrors.doubleProto, refDestructuringErrors.parenthesizedAssign = refDestructuringErrors.trailingComma = -1) : (refDestructuringErrors = new DestructuringErrors(), ownDestructuringErrors = true);
          var startPos = this.start, startLoc = this.startLoc;
          this.type !== types$1.parenL && this.type !== types$1.name || (this.potentialArrowAt = this.start, this.potentialArrowInForAwait = "await" === forInit);
          var left = this.parseMaybeConditional(forInit, refDestructuringErrors);
          if (afterLeftParse && (left = afterLeftParse.call(this, left, startPos, startLoc)), this.type.isAssign) {
            var node = this.startNodeAt(startPos, startLoc);
            return node.operator = this.value, this.type === types$1.eq && (left = this.toAssignable(left, false, refDestructuringErrors)), ownDestructuringErrors || (refDestructuringErrors.parenthesizedAssign = refDestructuringErrors.trailingComma = refDestructuringErrors.doubleProto = -1), refDestructuringErrors.shorthandAssign >= left.start && (refDestructuringErrors.shorthandAssign = -1), this.type === types$1.eq ? this.checkLValPattern(left) : this.checkLValSimple(left), node.left = left, this.next(), node.right = this.parseMaybeAssign(forInit), oldDoubleProto > -1 && (refDestructuringErrors.doubleProto = oldDoubleProto), this.finishNode(node, "AssignmentExpression");
          }
          return ownDestructuringErrors && this.checkExpressionErrors(refDestructuringErrors, true), oldParenAssign > -1 && (refDestructuringErrors.parenthesizedAssign = oldParenAssign), oldTrailingComma > -1 && (refDestructuringErrors.trailingComma = oldTrailingComma), left;
        }, pp$5.parseMaybeConditional = function(forInit, refDestructuringErrors) {
          var startPos = this.start, startLoc = this.startLoc, expr = this.parseExprOps(forInit, refDestructuringErrors);
          if (this.checkExpressionErrors(refDestructuringErrors))
            return expr;
          if (this.eat(types$1.question)) {
            var node = this.startNodeAt(startPos, startLoc);
            return node.test = expr, node.consequent = this.parseMaybeAssign(), this.expect(types$1.colon), node.alternate = this.parseMaybeAssign(forInit), this.finishNode(node, "ConditionalExpression");
          }
          return expr;
        }, pp$5.parseExprOps = function(forInit, refDestructuringErrors) {
          var startPos = this.start, startLoc = this.startLoc, expr = this.parseMaybeUnary(refDestructuringErrors, false, false, forInit);
          return this.checkExpressionErrors(refDestructuringErrors) || expr.start === startPos && "ArrowFunctionExpression" === expr.type ? expr : this.parseExprOp(expr, startPos, startLoc, -1, forInit);
        }, pp$5.parseExprOp = function(left, leftStartPos, leftStartLoc, minPrec, forInit) {
          var prec = this.type.binop;
          if (null != prec && (!forInit || this.type !== types$1._in) && prec > minPrec) {
            var logical = this.type === types$1.logicalOR || this.type === types$1.logicalAND, coalesce = this.type === types$1.coalesce;
            coalesce && (prec = types$1.logicalAND.binop);
            var op = this.value;
            this.next();
            var startPos = this.start, startLoc = this.startLoc, right = this.parseExprOp(this.parseMaybeUnary(null, false, false, forInit), startPos, startLoc, prec, forInit), node = this.buildBinary(leftStartPos, leftStartLoc, left, right, op, logical || coalesce);
            return (logical && this.type === types$1.coalesce || coalesce && (this.type === types$1.logicalOR || this.type === types$1.logicalAND)) && this.raiseRecoverable(this.start, "Logical expressions and coalesce expressions cannot be mixed. Wrap either by parentheses"), this.parseExprOp(node, leftStartPos, leftStartLoc, minPrec, forInit);
          }
          return left;
        }, pp$5.buildBinary = function(startPos, startLoc, left, right, op, logical) {
          "PrivateIdentifier" === right.type && this.raise(right.start, "Private identifier can only be left side of binary expression");
          var node = this.startNodeAt(startPos, startLoc);
          return node.left = left, node.operator = op, node.right = right, this.finishNode(node, logical ? "LogicalExpression" : "BinaryExpression");
        }, pp$5.parseMaybeUnary = function(refDestructuringErrors, sawUnary, incDec, forInit) {
          var expr, startPos = this.start, startLoc = this.startLoc;
          if (this.isContextual("await") && this.canAwait)
            expr = this.parseAwait(forInit), sawUnary = true;
          else if (this.type.prefix) {
            var node = this.startNode(), update = this.type === types$1.incDec;
            node.operator = this.value, node.prefix = true, this.next(), node.argument = this.parseMaybeUnary(null, true, update, forInit), this.checkExpressionErrors(refDestructuringErrors, true), update ? this.checkLValSimple(node.argument) : this.strict && "delete" === node.operator && "Identifier" === node.argument.type ? this.raiseRecoverable(node.start, "Deleting local variable in strict mode") : "delete" === node.operator && isPrivateFieldAccess(node.argument) ? this.raiseRecoverable(node.start, "Private fields can not be deleted") : sawUnary = true, expr = this.finishNode(node, update ? "UpdateExpression" : "UnaryExpression");
          } else if (sawUnary || this.type !== types$1.privateId) {
            if (expr = this.parseExprSubscripts(refDestructuringErrors, forInit), this.checkExpressionErrors(refDestructuringErrors))
              return expr;
            for (; this.type.postfix && !this.canInsertSemicolon(); ) {
              var node$1 = this.startNodeAt(startPos, startLoc);
              node$1.operator = this.value, node$1.prefix = false, node$1.argument = expr, this.checkLValSimple(expr), this.next(), expr = this.finishNode(node$1, "UpdateExpression");
            }
          } else
            (forInit || 0 === this.privateNameStack.length) && this.options.checkPrivateFields && this.unexpected(), expr = this.parsePrivateIdent(), this.type !== types$1._in && this.unexpected();
          return incDec || !this.eat(types$1.starstar) ? expr : sawUnary ? void this.unexpected(this.lastTokStart) : this.buildBinary(startPos, startLoc, expr, this.parseMaybeUnary(null, false, false, forInit), "**", false);
        }, pp$5.parseExprSubscripts = function(refDestructuringErrors, forInit) {
          var startPos = this.start, startLoc = this.startLoc, expr = this.parseExprAtom(refDestructuringErrors, forInit);
          if ("ArrowFunctionExpression" === expr.type && ")" !== this.input.slice(this.lastTokStart, this.lastTokEnd))
            return expr;
          var result = this.parseSubscripts(expr, startPos, startLoc, false, forInit);
          return refDestructuringErrors && "MemberExpression" === result.type && (refDestructuringErrors.parenthesizedAssign >= result.start && (refDestructuringErrors.parenthesizedAssign = -1), refDestructuringErrors.parenthesizedBind >= result.start && (refDestructuringErrors.parenthesizedBind = -1), refDestructuringErrors.trailingComma >= result.start && (refDestructuringErrors.trailingComma = -1)), result;
        }, pp$5.parseSubscripts = function(base, startPos, startLoc, noCalls, forInit) {
          for (var maybeAsyncArrow = this.options.ecmaVersion >= 8 && "Identifier" === base.type && "async" === base.name && this.lastTokEnd === base.end && !this.canInsertSemicolon() && base.end - base.start == 5 && this.potentialArrowAt === base.start, optionalChained = false; ; ) {
            var element = this.parseSubscript(base, startPos, startLoc, noCalls, maybeAsyncArrow, optionalChained, forInit);
            if (element.optional && (optionalChained = true), element === base || "ArrowFunctionExpression" === element.type) {
              if (optionalChained) {
                var chainNode = this.startNodeAt(startPos, startLoc);
                chainNode.expression = element, element = this.finishNode(chainNode, "ChainExpression");
              }
              return element;
            }
            base = element;
          }
        }, pp$5.shouldParseAsyncArrow = function() {
          return !this.canInsertSemicolon() && this.eat(types$1.arrow);
        }, pp$5.parseSubscriptAsyncArrow = function(startPos, startLoc, exprList, forInit) {
          return this.parseArrowExpression(this.startNodeAt(startPos, startLoc), exprList, true, forInit);
        }, pp$5.parseSubscript = function(base, startPos, startLoc, noCalls, maybeAsyncArrow, optionalChained, forInit) {
          var optionalSupported = this.options.ecmaVersion >= 11, optional = optionalSupported && this.eat(types$1.questionDot);
          noCalls && optional && this.raise(this.lastTokStart, "Optional chaining cannot appear in the callee of new expressions");
          var computed = this.eat(types$1.bracketL);
          if (computed || optional && this.type !== types$1.parenL && this.type !== types$1.backQuote || this.eat(types$1.dot)) {
            var node = this.startNodeAt(startPos, startLoc);
            node.object = base, computed ? (node.property = this.parseExpression(), this.expect(types$1.bracketR)) : this.type === types$1.privateId && "Super" !== base.type ? node.property = this.parsePrivateIdent() : node.property = this.parseIdent("never" !== this.options.allowReserved), node.computed = !!computed, optionalSupported && (node.optional = optional), base = this.finishNode(node, "MemberExpression");
          } else if (!noCalls && this.eat(types$1.parenL)) {
            var refDestructuringErrors = new DestructuringErrors(), oldYieldPos = this.yieldPos, oldAwaitPos = this.awaitPos, oldAwaitIdentPos = this.awaitIdentPos;
            this.yieldPos = 0, this.awaitPos = 0, this.awaitIdentPos = 0;
            var exprList = this.parseExprList(types$1.parenR, this.options.ecmaVersion >= 8, false, refDestructuringErrors);
            if (maybeAsyncArrow && !optional && this.shouldParseAsyncArrow())
              return this.checkPatternErrors(refDestructuringErrors, false), this.checkYieldAwaitInDefaultParams(), this.awaitIdentPos > 0 && this.raise(this.awaitIdentPos, "Cannot use 'await' as identifier inside an async function"), this.yieldPos = oldYieldPos, this.awaitPos = oldAwaitPos, this.awaitIdentPos = oldAwaitIdentPos, this.parseSubscriptAsyncArrow(startPos, startLoc, exprList, forInit);
            this.checkExpressionErrors(refDestructuringErrors, true), this.yieldPos = oldYieldPos || this.yieldPos, this.awaitPos = oldAwaitPos || this.awaitPos, this.awaitIdentPos = oldAwaitIdentPos || this.awaitIdentPos;
            var node$1 = this.startNodeAt(startPos, startLoc);
            node$1.callee = base, node$1.arguments = exprList, optionalSupported && (node$1.optional = optional), base = this.finishNode(node$1, "CallExpression");
          } else if (this.type === types$1.backQuote) {
            (optional || optionalChained) && this.raise(this.start, "Optional chaining cannot appear in the tag of tagged template expressions");
            var node$2 = this.startNodeAt(startPos, startLoc);
            node$2.tag = base, node$2.quasi = this.parseTemplate({ isTagged: true }), base = this.finishNode(node$2, "TaggedTemplateExpression");
          }
          return base;
        }, pp$5.parseExprAtom = function(refDestructuringErrors, forInit, forNew) {
          this.type === types$1.slash && this.readRegexp();
          var node, canBeArrow = this.potentialArrowAt === this.start;
          switch (this.type) {
            case types$1._super:
              return this.allowSuper || this.raise(this.start, "'super' keyword outside a method"), node = this.startNode(), this.next(), this.type !== types$1.parenL || this.allowDirectSuper || this.raise(node.start, "super() call outside constructor of a subclass"), this.type !== types$1.dot && this.type !== types$1.bracketL && this.type !== types$1.parenL && this.unexpected(), this.finishNode(node, "Super");
            case types$1._this:
              return node = this.startNode(), this.next(), this.finishNode(node, "ThisExpression");
            case types$1.name:
              var startPos = this.start, startLoc = this.startLoc, containsEsc = this.containsEsc, id = this.parseIdent(false);
              if (this.options.ecmaVersion >= 8 && !containsEsc && "async" === id.name && !this.canInsertSemicolon() && this.eat(types$1._function))
                return this.overrideContext(types.f_expr), this.parseFunction(this.startNodeAt(startPos, startLoc), 0, false, true, forInit);
              if (canBeArrow && !this.canInsertSemicolon()) {
                if (this.eat(types$1.arrow))
                  return this.parseArrowExpression(this.startNodeAt(startPos, startLoc), [id], false, forInit);
                if (this.options.ecmaVersion >= 8 && "async" === id.name && this.type === types$1.name && !containsEsc && (!this.potentialArrowInForAwait || "of" !== this.value || this.containsEsc))
                  return id = this.parseIdent(false), !this.canInsertSemicolon() && this.eat(types$1.arrow) || this.unexpected(), this.parseArrowExpression(this.startNodeAt(startPos, startLoc), [id], true, forInit);
              }
              return id;
            case types$1.regexp:
              var value2 = this.value;
              return (node = this.parseLiteral(value2.value)).regex = { pattern: value2.pattern, flags: value2.flags }, node;
            case types$1.num:
            case types$1.string:
              return this.parseLiteral(this.value);
            case types$1._null:
            case types$1._true:
            case types$1._false:
              return (node = this.startNode()).value = this.type === types$1._null ? null : this.type === types$1._true, node.raw = this.type.keyword, this.next(), this.finishNode(node, "Literal");
            case types$1.parenL:
              var start = this.start, expr = this.parseParenAndDistinguishExpression(canBeArrow, forInit);
              return refDestructuringErrors && (refDestructuringErrors.parenthesizedAssign < 0 && !this.isSimpleAssignTarget(expr) && (refDestructuringErrors.parenthesizedAssign = start), refDestructuringErrors.parenthesizedBind < 0 && (refDestructuringErrors.parenthesizedBind = start)), expr;
            case types$1.bracketL:
              return node = this.startNode(), this.next(), node.elements = this.parseExprList(types$1.bracketR, true, true, refDestructuringErrors), this.finishNode(node, "ArrayExpression");
            case types$1.braceL:
              return this.overrideContext(types.b_expr), this.parseObj(false, refDestructuringErrors);
            case types$1._function:
              return node = this.startNode(), this.next(), this.parseFunction(node, 0);
            case types$1._class:
              return this.parseClass(this.startNode(), false);
            case types$1._new:
              return this.parseNew();
            case types$1.backQuote:
              return this.parseTemplate();
            case types$1._import:
              return this.options.ecmaVersion >= 11 ? this.parseExprImport(forNew) : this.unexpected();
            default:
              return this.parseExprAtomDefault();
          }
        }, pp$5.parseExprAtomDefault = function() {
          this.unexpected();
        }, pp$5.parseExprImport = function(forNew) {
          var node = this.startNode();
          if (this.containsEsc && this.raiseRecoverable(this.start, "Escape sequence in keyword import"), this.next(), this.type === types$1.parenL && !forNew)
            return this.parseDynamicImport(node);
          if (this.type === types$1.dot) {
            var meta = this.startNodeAt(node.start, node.loc && node.loc.start);
            return meta.name = "import", node.meta = this.finishNode(meta, "Identifier"), this.parseImportMeta(node);
          }
          this.unexpected();
        }, pp$5.parseDynamicImport = function(node) {
          if (this.next(), node.source = this.parseMaybeAssign(), !this.eat(types$1.parenR)) {
            var errorPos = this.start;
            this.eat(types$1.comma) && this.eat(types$1.parenR) ? this.raiseRecoverable(errorPos, "Trailing comma is not allowed in import()") : this.unexpected(errorPos);
          }
          return this.finishNode(node, "ImportExpression");
        }, pp$5.parseImportMeta = function(node) {
          this.next();
          var containsEsc = this.containsEsc;
          return node.property = this.parseIdent(true), "meta" !== node.property.name && this.raiseRecoverable(node.property.start, "The only valid meta property for import is 'import.meta'"), containsEsc && this.raiseRecoverable(node.start, "'import.meta' must not contain escaped characters"), "module" === this.options.sourceType || this.options.allowImportExportEverywhere || this.raiseRecoverable(node.start, "Cannot use 'import.meta' outside a module"), this.finishNode(node, "MetaProperty");
        }, pp$5.parseLiteral = function(value2) {
          var node = this.startNode();
          return node.value = value2, node.raw = this.input.slice(this.start, this.end), 110 === node.raw.charCodeAt(node.raw.length - 1) && (node.bigint = node.raw.slice(0, -1).replace(/_/g, "")), this.next(), this.finishNode(node, "Literal");
        }, pp$5.parseParenExpression = function() {
          this.expect(types$1.parenL);
          var val = this.parseExpression();
          return this.expect(types$1.parenR), val;
        }, pp$5.shouldParseArrow = function(exprList) {
          return !this.canInsertSemicolon();
        }, pp$5.parseParenAndDistinguishExpression = function(canBeArrow, forInit) {
          var val, startPos = this.start, startLoc = this.startLoc, allowTrailingComma = this.options.ecmaVersion >= 8;
          if (this.options.ecmaVersion >= 6) {
            this.next();
            var spreadStart, innerStartPos = this.start, innerStartLoc = this.startLoc, exprList = [], first = true, lastIsComma = false, refDestructuringErrors = new DestructuringErrors(), oldYieldPos = this.yieldPos, oldAwaitPos = this.awaitPos;
            for (this.yieldPos = 0, this.awaitPos = 0; this.type !== types$1.parenR; ) {
              if (first ? first = false : this.expect(types$1.comma), allowTrailingComma && this.afterTrailingComma(types$1.parenR, true)) {
                lastIsComma = true;
                break;
              }
              if (this.type === types$1.ellipsis) {
                spreadStart = this.start, exprList.push(this.parseParenItem(this.parseRestBinding())), this.type === types$1.comma && this.raiseRecoverable(this.start, "Comma is not permitted after the rest element");
                break;
              }
              exprList.push(this.parseMaybeAssign(false, refDestructuringErrors, this.parseParenItem));
            }
            var innerEndPos = this.lastTokEnd, innerEndLoc = this.lastTokEndLoc;
            if (this.expect(types$1.parenR), canBeArrow && this.shouldParseArrow(exprList) && this.eat(types$1.arrow))
              return this.checkPatternErrors(refDestructuringErrors, false), this.checkYieldAwaitInDefaultParams(), this.yieldPos = oldYieldPos, this.awaitPos = oldAwaitPos, this.parseParenArrowList(startPos, startLoc, exprList, forInit);
            exprList.length && !lastIsComma || this.unexpected(this.lastTokStart), spreadStart && this.unexpected(spreadStart), this.checkExpressionErrors(refDestructuringErrors, true), this.yieldPos = oldYieldPos || this.yieldPos, this.awaitPos = oldAwaitPos || this.awaitPos, exprList.length > 1 ? ((val = this.startNodeAt(innerStartPos, innerStartLoc)).expressions = exprList, this.finishNodeAt(val, "SequenceExpression", innerEndPos, innerEndLoc)) : val = exprList[0];
          } else
            val = this.parseParenExpression();
          if (this.options.preserveParens) {
            var par = this.startNodeAt(startPos, startLoc);
            return par.expression = val, this.finishNode(par, "ParenthesizedExpression");
          }
          return val;
        }, pp$5.parseParenItem = function(item) {
          return item;
        }, pp$5.parseParenArrowList = function(startPos, startLoc, exprList, forInit) {
          return this.parseArrowExpression(this.startNodeAt(startPos, startLoc), exprList, false, forInit);
        };
        var empty = [];
        pp$5.parseNew = function() {
          this.containsEsc && this.raiseRecoverable(this.start, "Escape sequence in keyword new");
          var node = this.startNode();
          if (this.next(), this.options.ecmaVersion >= 6 && this.type === types$1.dot) {
            var meta = this.startNodeAt(node.start, node.loc && node.loc.start);
            meta.name = "new", node.meta = this.finishNode(meta, "Identifier"), this.next();
            var containsEsc = this.containsEsc;
            return node.property = this.parseIdent(true), "target" !== node.property.name && this.raiseRecoverable(node.property.start, "The only valid meta property for new is 'new.target'"), containsEsc && this.raiseRecoverable(node.start, "'new.target' must not contain escaped characters"), this.allowNewDotTarget || this.raiseRecoverable(node.start, "'new.target' can only be used in functions and class static block"), this.finishNode(node, "MetaProperty");
          }
          var startPos = this.start, startLoc = this.startLoc;
          return node.callee = this.parseSubscripts(this.parseExprAtom(null, false, true), startPos, startLoc, true, false), this.eat(types$1.parenL) ? node.arguments = this.parseExprList(types$1.parenR, this.options.ecmaVersion >= 8, false) : node.arguments = empty, this.finishNode(node, "NewExpression");
        }, pp$5.parseTemplateElement = function(ref2) {
          var isTagged = ref2.isTagged, elem = this.startNode();
          return this.type === types$1.invalidTemplate ? (isTagged || this.raiseRecoverable(this.start, "Bad escape sequence in untagged template literal"), elem.value = { raw: this.value, cooked: null }) : elem.value = { raw: this.input.slice(this.start, this.end).replace(/\r\n?/g, "\n"), cooked: this.value }, this.next(), elem.tail = this.type === types$1.backQuote, this.finishNode(elem, "TemplateElement");
        }, pp$5.parseTemplate = function(ref2) {
          void 0 === ref2 && (ref2 = {});
          var isTagged = ref2.isTagged;
          void 0 === isTagged && (isTagged = false);
          var node = this.startNode();
          this.next(), node.expressions = [];
          var curElt = this.parseTemplateElement({ isTagged });
          for (node.quasis = [curElt]; !curElt.tail; )
            this.type === types$1.eof && this.raise(this.pos, "Unterminated template literal"), this.expect(types$1.dollarBraceL), node.expressions.push(this.parseExpression()), this.expect(types$1.braceR), node.quasis.push(curElt = this.parseTemplateElement({ isTagged }));
          return this.next(), this.finishNode(node, "TemplateLiteral");
        }, pp$5.isAsyncProp = function(prop) {
          return !prop.computed && "Identifier" === prop.key.type && "async" === prop.key.name && (this.type === types$1.name || this.type === types$1.num || this.type === types$1.string || this.type === types$1.bracketL || this.type.keyword || this.options.ecmaVersion >= 9 && this.type === types$1.star) && !lineBreak.test(this.input.slice(this.lastTokEnd, this.start));
        }, pp$5.parseObj = function(isPattern, refDestructuringErrors) {
          var node = this.startNode(), first = true, propHash = {};
          for (node.properties = [], this.next(); !this.eat(types$1.braceR); ) {
            if (first)
              first = false;
            else if (this.expect(types$1.comma), this.options.ecmaVersion >= 5 && this.afterTrailingComma(types$1.braceR))
              break;
            var prop = this.parseProperty(isPattern, refDestructuringErrors);
            isPattern || this.checkPropClash(prop, propHash, refDestructuringErrors), node.properties.push(prop);
          }
          return this.finishNode(node, isPattern ? "ObjectPattern" : "ObjectExpression");
        }, pp$5.parseProperty = function(isPattern, refDestructuringErrors) {
          var isGenerator, isAsync, startPos, startLoc, prop = this.startNode();
          if (this.options.ecmaVersion >= 9 && this.eat(types$1.ellipsis))
            return isPattern ? (prop.argument = this.parseIdent(false), this.type === types$1.comma && this.raiseRecoverable(this.start, "Comma is not permitted after the rest element"), this.finishNode(prop, "RestElement")) : (prop.argument = this.parseMaybeAssign(false, refDestructuringErrors), this.type === types$1.comma && refDestructuringErrors && refDestructuringErrors.trailingComma < 0 && (refDestructuringErrors.trailingComma = this.start), this.finishNode(prop, "SpreadElement"));
          this.options.ecmaVersion >= 6 && (prop.method = false, prop.shorthand = false, (isPattern || refDestructuringErrors) && (startPos = this.start, startLoc = this.startLoc), isPattern || (isGenerator = this.eat(types$1.star)));
          var containsEsc = this.containsEsc;
          return this.parsePropertyName(prop), !isPattern && !containsEsc && this.options.ecmaVersion >= 8 && !isGenerator && this.isAsyncProp(prop) ? (isAsync = true, isGenerator = this.options.ecmaVersion >= 9 && this.eat(types$1.star), this.parsePropertyName(prop)) : isAsync = false, this.parsePropertyValue(prop, isPattern, isGenerator, isAsync, startPos, startLoc, refDestructuringErrors, containsEsc), this.finishNode(prop, "Property");
        }, pp$5.parseGetterSetter = function(prop) {
          prop.kind = prop.key.name, this.parsePropertyName(prop), prop.value = this.parseMethod(false);
          var paramCount = "get" === prop.kind ? 0 : 1;
          if (prop.value.params.length !== paramCount) {
            var start = prop.value.start;
            "get" === prop.kind ? this.raiseRecoverable(start, "getter should have no params") : this.raiseRecoverable(start, "setter should have exactly one param");
          } else
            "set" === prop.kind && "RestElement" === prop.value.params[0].type && this.raiseRecoverable(prop.value.params[0].start, "Setter cannot use rest params");
        }, pp$5.parsePropertyValue = function(prop, isPattern, isGenerator, isAsync, startPos, startLoc, refDestructuringErrors, containsEsc) {
          (isGenerator || isAsync) && this.type === types$1.colon && this.unexpected(), this.eat(types$1.colon) ? (prop.value = isPattern ? this.parseMaybeDefault(this.start, this.startLoc) : this.parseMaybeAssign(false, refDestructuringErrors), prop.kind = "init") : this.options.ecmaVersion >= 6 && this.type === types$1.parenL ? (isPattern && this.unexpected(), prop.kind = "init", prop.method = true, prop.value = this.parseMethod(isGenerator, isAsync)) : isPattern || containsEsc || !(this.options.ecmaVersion >= 5) || prop.computed || "Identifier" !== prop.key.type || "get" !== prop.key.name && "set" !== prop.key.name || this.type === types$1.comma || this.type === types$1.braceR || this.type === types$1.eq ? this.options.ecmaVersion >= 6 && !prop.computed && "Identifier" === prop.key.type ? ((isGenerator || isAsync) && this.unexpected(), this.checkUnreserved(prop.key), "await" !== prop.key.name || this.awaitIdentPos || (this.awaitIdentPos = startPos), prop.kind = "init", isPattern ? prop.value = this.parseMaybeDefault(startPos, startLoc, this.copyNode(prop.key)) : this.type === types$1.eq && refDestructuringErrors ? (refDestructuringErrors.shorthandAssign < 0 && (refDestructuringErrors.shorthandAssign = this.start), prop.value = this.parseMaybeDefault(startPos, startLoc, this.copyNode(prop.key))) : prop.value = this.copyNode(prop.key), prop.shorthand = true) : this.unexpected() : ((isGenerator || isAsync) && this.unexpected(), this.parseGetterSetter(prop));
        }, pp$5.parsePropertyName = function(prop) {
          if (this.options.ecmaVersion >= 6) {
            if (this.eat(types$1.bracketL))
              return prop.computed = true, prop.key = this.parseMaybeAssign(), this.expect(types$1.bracketR), prop.key;
            prop.computed = false;
          }
          return prop.key = this.type === types$1.num || this.type === types$1.string ? this.parseExprAtom() : this.parseIdent("never" !== this.options.allowReserved);
        }, pp$5.initFunction = function(node) {
          node.id = null, this.options.ecmaVersion >= 6 && (node.generator = node.expression = false), this.options.ecmaVersion >= 8 && (node.async = false);
        }, pp$5.parseMethod = function(isGenerator, isAsync, allowDirectSuper) {
          var node = this.startNode(), oldYieldPos = this.yieldPos, oldAwaitPos = this.awaitPos, oldAwaitIdentPos = this.awaitIdentPos;
          return this.initFunction(node), this.options.ecmaVersion >= 6 && (node.generator = isGenerator), this.options.ecmaVersion >= 8 && (node.async = !!isAsync), this.yieldPos = 0, this.awaitPos = 0, this.awaitIdentPos = 0, this.enterScope(64 | functionFlags(isAsync, node.generator) | (allowDirectSuper ? 128 : 0)), this.expect(types$1.parenL), node.params = this.parseBindingList(types$1.parenR, false, this.options.ecmaVersion >= 8), this.checkYieldAwaitInDefaultParams(), this.parseFunctionBody(node, false, true, false), this.yieldPos = oldYieldPos, this.awaitPos = oldAwaitPos, this.awaitIdentPos = oldAwaitIdentPos, this.finishNode(node, "FunctionExpression");
        }, pp$5.parseArrowExpression = function(node, params, isAsync, forInit) {
          var oldYieldPos = this.yieldPos, oldAwaitPos = this.awaitPos, oldAwaitIdentPos = this.awaitIdentPos;
          return this.enterScope(16 | functionFlags(isAsync, false)), this.initFunction(node), this.options.ecmaVersion >= 8 && (node.async = !!isAsync), this.yieldPos = 0, this.awaitPos = 0, this.awaitIdentPos = 0, node.params = this.toAssignableList(params, true), this.parseFunctionBody(node, true, false, forInit), this.yieldPos = oldYieldPos, this.awaitPos = oldAwaitPos, this.awaitIdentPos = oldAwaitIdentPos, this.finishNode(node, "ArrowFunctionExpression");
        }, pp$5.parseFunctionBody = function(node, isArrowFunction, isMethod, forInit) {
          var isExpression = isArrowFunction && this.type !== types$1.braceL, oldStrict = this.strict, useStrict = false;
          if (isExpression)
            node.body = this.parseMaybeAssign(forInit), node.expression = true, this.checkParams(node, false);
          else {
            var nonSimple = this.options.ecmaVersion >= 7 && !this.isSimpleParamList(node.params);
            oldStrict && !nonSimple || (useStrict = this.strictDirective(this.end)) && nonSimple && this.raiseRecoverable(node.start, "Illegal 'use strict' directive in function with non-simple parameter list");
            var oldLabels = this.labels;
            this.labels = [], useStrict && (this.strict = true), this.checkParams(node, !oldStrict && !useStrict && !isArrowFunction && !isMethod && this.isSimpleParamList(node.params)), this.strict && node.id && this.checkLValSimple(node.id, 5), node.body = this.parseBlock(false, void 0, useStrict && !oldStrict), node.expression = false, this.adaptDirectivePrologue(node.body.body), this.labels = oldLabels;
          }
          this.exitScope();
        }, pp$5.isSimpleParamList = function(params) {
          for (var i2 = 0, list2 = params; i2 < list2.length; i2 += 1) {
            if ("Identifier" !== list2[i2].type)
              return false;
          }
          return true;
        }, pp$5.checkParams = function(node, allowDuplicates) {
          for (var nameHash = /* @__PURE__ */ Object.create(null), i2 = 0, list2 = node.params; i2 < list2.length; i2 += 1) {
            var param = list2[i2];
            this.checkLValInnerPattern(param, 1, allowDuplicates ? null : nameHash);
          }
        }, pp$5.parseExprList = function(close, allowTrailingComma, allowEmpty, refDestructuringErrors) {
          for (var elts = [], first = true; !this.eat(close); ) {
            if (first)
              first = false;
            else if (this.expect(types$1.comma), allowTrailingComma && this.afterTrailingComma(close))
              break;
            var elt = void 0;
            allowEmpty && this.type === types$1.comma ? elt = null : this.type === types$1.ellipsis ? (elt = this.parseSpread(refDestructuringErrors), refDestructuringErrors && this.type === types$1.comma && refDestructuringErrors.trailingComma < 0 && (refDestructuringErrors.trailingComma = this.start)) : elt = this.parseMaybeAssign(false, refDestructuringErrors), elts.push(elt);
          }
          return elts;
        }, pp$5.checkUnreserved = function(ref2) {
          var start = ref2.start, end = ref2.end, name = ref2.name;
          (this.inGenerator && "yield" === name && this.raiseRecoverable(start, "Cannot use 'yield' as identifier inside a generator"), this.inAsync && "await" === name && this.raiseRecoverable(start, "Cannot use 'await' as identifier inside an async function"), this.currentThisScope().inClassFieldInit && "arguments" === name && this.raiseRecoverable(start, "Cannot use 'arguments' in class field initializer"), !this.inClassStaticBlock || "arguments" !== name && "await" !== name || this.raise(start, "Cannot use " + name + " in class static initialization block"), this.keywords.test(name) && this.raise(start, "Unexpected keyword '" + name + "'"), this.options.ecmaVersion < 6 && -1 !== this.input.slice(start, end).indexOf("\\")) || (this.strict ? this.reservedWordsStrict : this.reservedWords).test(name) && (this.inAsync || "await" !== name || this.raiseRecoverable(start, "Cannot use keyword 'await' outside an async function"), this.raiseRecoverable(start, "The keyword '" + name + "' is reserved"));
        }, pp$5.parseIdent = function(liberal) {
          var node = this.parseIdentNode();
          return this.next(!!liberal), this.finishNode(node, "Identifier"), liberal || (this.checkUnreserved(node), "await" !== node.name || this.awaitIdentPos || (this.awaitIdentPos = node.start)), node;
        }, pp$5.parseIdentNode = function() {
          var node = this.startNode();
          return this.type === types$1.name ? node.name = this.value : this.type.keyword ? (node.name = this.type.keyword, "class" !== node.name && "function" !== node.name || this.lastTokEnd === this.lastTokStart + 1 && 46 === this.input.charCodeAt(this.lastTokStart) || this.context.pop(), this.type = types$1.name) : this.unexpected(), node;
        }, pp$5.parsePrivateIdent = function() {
          var no